
/*********************************************************************
                              NOVILIT, INC                            
 The  following  code  is  the sole property of NOVILIT Inc., and     
 contains its proprietary and confidential information.  This code    
 is  used under license.  No reproduction of this code may be made    
 in  any  form  without  the express written consent of NOVILIT Inc.. 
 Copyright (c) 1999-2002  NOVILIT, Inc., Marlborough, MA  USA        
 For inquires call Toll-Free: 1.877.529.4196                          
 or                                                                   
 email to: sales@novilit.com                                          
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 CMDE, CMDL, and NOVILIT are trademarks of NOVILIT Inc.               
 CMDE/CMDL are US patent 6,356,950                                         
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                                                                      
 File:        nlbis.h           
 Author:      novilit-102                                             
 Created:     1/29/2000 2:14pm    
 Comments:                                                                
                                                                      
*********************************************************************/

#ifndef __NL_BIS_H__
#define __NL_BIS_H__

#include "nltypes.h"

typedef struct {
   u1 *mp_pduO;      /*pointer to the begining of the PDU*/
   u4 m_shiftPduB    /*shift of the first bit of first octet of the pdu (bits)*/
      ,m_lenPduB     /*length of the PDU (bits)*/
      ,m_offPduO     /*offset of the first octet of the current PDU relating to the begining of the protocol of topmost level*/
      ,m_indCurO     /*index (offset) of the current octet in the pdu*/
      ,m_shiftCurB   /*shift of the dcurrent bit in the current octet in the current PDU*/
      ,m_lsbf        /*least significant bit first flag*/
      ,m_lsof        /*least significant octet first flag*/
	  ,m_pend		 /*premature end of packet if 1*/	
	  /* //gan */
#ifdef G_OPT
	  ,m_previndCurO  /*index (offset) of previous current octect*/
#endif
      ;
} NlBis;

/*pseudo variables access macros*/

#define NlBis_PtrCurO(x) ((x)->mp_pduO+(x)->m_indCurO)
#define NlBis_IndCurB(x) (((x)->m_indCurO<<ULM(3))+(x)->m_shiftCurB-(x)->m_shiftPduB)
#define NlBis_LenCurB(x) ((x)->m_lenPduB - NlBis_IndCurB(x))
#define NlBis_LenPduO(x) (((x)->m_lenPduB+(x)->m_shiftPduB+ULM(7))>>ULM(3))
#define NlBis_LenCurO(x) (NlBis_LenPduO(x)-(x)->m_indCurO)
#define NlBis_OffCurO(x) ((x)->m_offPduO+(x)->m_indCurO)
#define NlBis_IndCurO(x) ((x)->m_indCurO)
#define NlBis_ShiftCurO(x) ((x)->m_shiftCurB)

void NlBis_InitFromBuf        (NlBis *ap_bis, u1 *ap_pduO, u4 a_lenPduB, u4 a_offPduO, u4 a_shiftPduB); 
void NlBis_InitCopy           (NlBis *ap_bisD, NlBis *ap_bisS); 
void NlBis_InitFromSuper      (NlBis *ap_bisD, NlBis *ap_bisS); 
void NlBis_InitFromSuperLen   (NlBis *ap_bisD, NlBis *ap_bisS, u4 a_lenPduB);
void NlBis_SetCurLen          (NlBis *ap_bis, u4 a_lenCurB);
void NlBis_SetLsbf            (NlBis *ap_bis, u4 a_lsbf); 
u4   NlBis_GetLsbf            (NlBis *ap_bis);
void NlBis_SetLsof            (NlBis *ap_bis, u4 a_lsof); 
u4   NlBis_GetLsof            (NlBis *ap_bis); 
void NlBis_AdvanceB           (NlBis *ap_bis, u4 a_numB);
u4   NlBis_FieldValue         (NlBis *ap_bis, u4 a_lenB);
u4   NlBis_ChecksValue        (u1 *a_pduO, u1 *a_curO, u4 a_lenO, u4 a_lenB, u4 a_num1, u4 a_num2);
u4   NlBis_LSChecksValue      (u1 *a_pduO, u1 *a_curO, u4 a_lenO, u4 a_lenB, u4 a_num1, u4 a_num2);
u4   NlBis_AlignValue         (NlBis *ap_bis, u4 a_AlignSizeB); 

#endif /*__NLBIS_H__*/

/*********************************************************************
 End of File: nlbis.h
*********************************************************************/

