/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

//static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/decode.cpp#1 $";

//*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

/*======================================================================*/
/*  Lucent Technologies Network Wireless Systems                        */
/*  EVRC Floating-point C Simulation.                                   */
/*                                                                      */
/*  Copyright (C) 1996 Lucent Technologies Incorporated. All rights     */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/
/*  Module:     decode.c                                                */
/*----------------------------------------------------------------------*/
/*  History:                                                            */
/*	   09/04/95  ACELP Fixed codebook added (AT&T/Nokia)		*/
/*----------------------------------------------------------------------*/
/*  EVRC Decoder                                                        */
/*======================================================================*/
/*         ..Includes.                                                  */
/*----------------------------------------------------------------------*/

#ifdef WIN32
#include <iostream>
#include <Winsock2.h>
using namespace std;
#endif

#include  <string.h>

#include  "macro.h"
#include  "proto.h"
#include  "rom.h"
#include  "acelp.h"	/* for ACELP */
#include  "struct.h"
#include "lu_mod.h"

using namespace std;

/*======================================================================*/
/*         ..Reset RCELP decoder parameters.                            */
/*----------------------------------------------------------------------*/
void    FGV_MEM::InitDecoder()
{
  /*....(local) variables....*/
  int     j;
  float   ftmp;
  
  bit_rate=4;
  last_valid_rate = 1;	/* reset last_valid_rate */
  decode_fcnt = 0;
  
  for (j=0; j<ORDER; j++) SynMemory[j] = 0.0;
  
  ftmp = 0.48 / (float) ORDER;
  OldOldlspD[0] = OldlspD[0] = ftmp;
  for (j=1; j<ORDER; j++) {
    OldOldlspD[j] = OldOldlspD[j - 1] + ftmp;
    OldlspD[j] = OldlspD[j - 1] + ftmp;
  }
  for (j=0; j<ACBMemSize; j++)
    PitchMemoryD[j]  = PitchPreFiltMemoryD[j] = PitchMemoryD2[j] = PitchMemoryD3[j] = 0.0;
  pdelayD = 40.0;
  ave_acb_gain = ave_fcb_gain = ave_acb_gain_back = 0.0;
  FadeScale = 1.0;
  
  prev_frame_error = 0;
  prev_prev_frame_error = 0;
  
  erasureFlag = 0;
  errorFlag = 0;

#if MOT_SUPPRESSED_EIGHTH_RATE
  init_bbg();
  consec_eighth_rates=3;
#endif
}

/*======================================================================*/
/*         ..Decode bitstream data.                                     */
/*----------------------------------------------------------------------*/

//float prevpD[ACBMemSize];
//char PPP_MODE_D;
//int rcelp_half_rateD;
//int prev_rcelp_half=0;

void FGV_MEM::decode (short*  codeBuf,short  rate,short  post_filter,float*  outFbuf,
			  short run_length, short phase_offset, float time_warp_fraction, short *obuf_len)
{

  /*....(local) variables....*/
  register int i;
  short   local_rate;
  short tmp;
  short spl_hcelp=0x6E;
  short poss_spl_hcelp;
  short poss_qnelp;
#if MOT_SUPPRESSED_EIGHTH_RATE
  short update_bbg_flag;
#endif
  SPL_HNELP=0;
  errorFlag=0;
  BAD_RATE=0;
  SPL_HCELP=0;
  SPL_HPPP=0;
  //void fer_processing(float*,short,short);

  //printf ("\n in decode");

  //Phase Matching variable
  int	do_phase_match = 0;

  if (phase_offset != 10) //Phase Offset == 10 denotes Phase Matching disabled
	do_phase_match = 1; //check for Phase Matching

Lable:
    
  // NOTE: "rate" is a true rate and not like that in ENC's VAD
  for (i = 0; i < PACKWDSNUM; i++) {RxPkt[i]=codeBuf[i];}
  data_packet.PACKET_RATE=rate;
    
  /* Re-initialize PackWdsPtr */
  PackWdsPtr[0] = 16;
  PackWdsPtr[1] = 0;
  //gautam
  PktPtr[0]=16;PktPtr[1]=0;

  PACKET_RATE=data_packet.PACKET_RATE;

  rcelp_half_rateD=0; PPP_MODE_D=' '; //Reset the two global variables  


//This is added to ensure the proper adjustment between blank(rate 0) and erasure(rate 14)
#if  defined(QCDTX) || MOT_SUPPRESSED_EIGHTH_RATE
static short DTX_STATE = 0;

   if ((rate == 4) || (rate ==3) || (rate==2))
           DTX_STATE =0;
   else if (rate==1) DTX_STATE=1;
   
   if ((rate==0) || (rate==0xE))
   {
   	 if ((lastrateD ==4) || (lastrateD ==3) ||(lastrateD ==2))
                rate=0xE;
         else if ((lastrateD ==1) || (lastrateD ==0))
                rate=0;
         else
         {
            if (DTX_STATE ==1)rate=0;
            else rate=0xE;
         }
   }
   data_packet.PACKET_RATE=rate;
   PACKET_RATE=data_packet.PACKET_RATE;
#endif
																														   


#ifdef QCDTX
    unsigned int Isil=0;
    // To avoid issues with different endianess and to minimize changes to the code
    // the 1/8 rate frame will be converted to Network order (big endian) and 
    // Smart blanking will assume that is working on a big endian machine
    //unsigned char tmpbuf[2]={0,0};
    //tmpbuf[1] = RxPkt[0]>> 8; //upper 8 bits => LSF
    //tmpbuf[0] = RxPkt[0] & 0x00FF;//lower 8 bits => power
    short tmpbuf = htons(RxPkt[0]);

    short rt;
    rt = (short) data_packet.PACKET_RATE;
    if (rt == 1) SILFrame = 1;
    else
      SILFrame=0;
    
    Isil = SB_dec.Decode(&rt, &tmpbuf);
    
    rate= rt;
    if (rate !=0)
      {
//	RxPkt[0] = (tmpbuf[1] << 8) | tmpbuf[0];
    TxPkt[0] = ntohs(tmpbuf);
	data_packet.PACKET_RATE =PACKET_RATE =rate; //erasure
      codeBuf[0]=RxPkt[0];
      }
    else
      rate= data_packet.PACKET_RATE =PACKET_RATE =0xE; //erasure
      
#endif //QCDTX

  // Check for Erasure - from codeBuf or from packet.cc or from external ctrl
  if (rate==0xE && !do_phase_match) {
    if (fer_counter==3) ave_acb_gain*=0.75;
    fer_counter=3;
    if (lastrateD>2) {
      ave_acb_gain_back=ave_acb_gain;
      pdelayD2=pdelayD;
      for (i=0;i<ACBMemSize;i++)
	PitchMemoryD2[i]=PitchMemoryD[i];
    }

    if (lastrateD!=3) prev_rcelp_half=0;
    if (prev_rcelp_half==1) {
      lastrateD=4;
      prev_rcelp_half=0;
    }
    fer_processing(outFbuf,post_filter,bit_rate=lastrateD); 
  }
  else {
#if 0
    fer_counter--;
    if (fer_counter<0) fer_counter=0;
#endif

    if ((PACKET_RATE==2)||(PACKET_RATE==4))
      BitUnpack((short *)&data_packet.MODE_BIT,(unsigned short *)RxPkt,1,PktPtr);
   
   

   if (PACKET_RATE == 3) //SPL packet detector 
     {
       //chk for spl. 1/2 rate CELP and PPP
       BitUnpack(&poss_spl_hcelp,(unsigned short *)RxPkt,7,PktPtr);
       BitUnpack(&poss_qnelp,(unsigned short *)RxPkt,2,PktPtr);
       if ((poss_spl_hcelp == spl_hcelp))
	 {
	   if (poss_qnelp == 0) {

		    BitUnpack((short *) &data_packet.MODE_BIT ,(unsigned short *)RxPkt,1,PktPtr);
	        
		    if (data_packet.MODE_BIT == 0) //unpacking for SPL_HCELP
		      {
			BitUnpack((short *) &data_packet.LSP_IDX[0] ,(unsigned short *)RxPkt,6,PktPtr);
			BitUnpack((short *) &data_packet.LSP_IDX[1] ,(unsigned short *)RxPkt,6,PktPtr);
			BitUnpack((short *) &data_packet.LSP_IDX[2] ,(unsigned short *)RxPkt,9,PktPtr);
			BitUnpack((short *) &data_packet.LSP_IDX[3] ,(unsigned short *)RxPkt,7,PktPtr);
	    
			for(i=0;i<NoOfSubFrames;i++) BitUnpack((short *) &data_packet.ACBG_IDX[i] ,(unsigned short *)RxPkt,3,PktPtr);

			BitUnpack((short *) &data_packet.DELAY_IDX ,(unsigned short *)RxPkt,7,PktPtr);
			data_packet.PACKET_RATE=4;
			PACKET_RATE=data_packet.PACKET_RATE;
			SPL_HCELP=1;
		      }
		    else //unpacking for SPL_HPPP
		      {
	       
			BitUnpack((short *) &data_packet.LSP_IDX[0] ,(unsigned short *)RxPkt,6,PktPtr);
			BitUnpack((short *) &data_packet.LSP_IDX[1] ,(unsigned short *)RxPkt,6,PktPtr);
			BitUnpack((short *) &data_packet.LSP_IDX[2] ,(unsigned short *)RxPkt,9,PktPtr);
			BitUnpack((short *) &data_packet.LSP_IDX[3] ,(unsigned short *)RxPkt,7,PktPtr);
			BitUnpack((short *) &data_packet.F_ROT_IDX,(unsigned short *)RxPkt,7,PktPtr);
			BitUnpack((short *) &data_packet.A_AMP_IDX[0],(unsigned short *)RxPkt,6,PktPtr);
			BitUnpack((short *) &data_packet.A_AMP_IDX[1],(unsigned short *)RxPkt,6,PktPtr);
			BitUnpack((short *) &data_packet.A_AMP_IDX[2],(unsigned short *)RxPkt,8,PktPtr);
			BitUnpack((short *) &data_packet.A_POWER_IDX,(unsigned short *)RxPkt,8,PktPtr);
			BitUnpack((short *) &data_packet.delayindex,(unsigned short *)RxPkt,7,PktPtr);
			for (i=0;i<NUM_FIXED_BAND;i++) {
			  if (i<3)
			    data_packet.F_ALIGN_IDX[i]= 0x10;
			  else
			    data_packet.F_ALIGN_IDX[i]= 0x20;
			}       
			data_packet.PACKET_RATE=4;
			PACKET_RATE=data_packet.PACKET_RATE;
			SPL_HPPP=1;
		      }

	     
	   }
	   else {
	     BitUnpack((short *)&data_packet.LSP_IDX[0],(unsigned short*)RxPkt,8,PktPtr);
	     BitUnpack((short *)&data_packet.LSP_IDX[1],(unsigned short*)RxPkt,8,PktPtr);
	     BitUnpack((short *)&data_packet.NELP_GAIN_IDX[0][0],(unsigned short*)RxPkt,5,PktPtr);
	     BitUnpack((short *)&data_packet.NELP_GAIN_IDX[1][0],(unsigned short*)RxPkt,6,PktPtr);
	     BitUnpack((short *)&data_packet.NELP_GAIN_IDX[1][1],(unsigned short*)RxPkt,6,PktPtr);
	     BitUnpack((short *)&data_packet.NELP_FID,(unsigned short*)RxPkt,2,PktPtr);
	     data_packet.PACKET_RATE =2;
	     data_packet.MODE_BIT =0;
	     PACKET_RATE=data_packet.PACKET_RATE;
	     SPL_HNELP=1;
	   }
	   
	 }
       else
	{// not a spl. 1/2 rate , restore RxPkt
	      for (i = 0; i < PACKWDSNUM; i++) {RxPkt[i]=codeBuf[i];}
	      PktPtr[0]=16;PktPtr[1]=0;
	}
     } //SPL packet detector

     if  (((LAST_PACKET_RATE_D ==1) || ((LAST_PACKET_RATE_D ==2) && (LAST_MODE_BIT_D==0))) && (SPL_HCELP ==1)) //prev was QNELP/Sil
	{
	    ones_dec_cnt=0;
	    dec_lsp_vq_28((short int *)data_packet.LSP_IDX, OldlspD);
#if 1 
	    PACKET_RATE=data_packet.PACKET_RATE=0xE;//erasure , bug-fix in the way the next frame is processed
	    rate=0xE;
#endif
            if (lastrateD!=3) prev_rcelp_half=0;
            if (prev_rcelp_half==1) {
              lastrateD=4;
              prev_rcelp_half=0;
            }
            fer_processing(outFbuf,post_filter,bit_rate=lastrateD); 

	    /* Use curr frames good LSP if curr frame is spl hcelp and prev frame was QNELP/Sil */ 
	}
     else { //not special half-celp and last frmae not nelp,eighth

       //initialize zrbit for bad-rate detection
       zrbit[0]=1;   
      
   
#if 0
	 
    //Translate the PACKET_RATE to the appropriate bit_rate and PPP_MODE
    switch(PACKET_RATE) {
#if MOT_SUPPRESSED_EIGHTH_RATE
/* RATE=0 will be treated as RATE=1 after supp rate 1/8 processing below */
    case 0:
#endif
    case 1:
      bit_rate=local_rate=1;
      break;
    case 2:
      if (SPL_HNELP ==0)
	{
	  BitUnpack((short *)&data_packet.MODE_BIT,(unsigned short *)RxPkt,1,PktPtr);
	  MODE_BIT=data_packet.MODE_BIT;
	}
      else
	MODE_BIT=data_packet.MODE_BIT=0;
      
      if (MODE_BIT==0)
        bit_rate=local_rate=2;
      else {
        bit_rate=local_rate=3;
        PPP_MODE_D='Q';
	data_packet.MODE_BIT=1;data_packet.PACKET_RATE=2;
      }
      break;
    case 3:
      bit_rate=local_rate=3;
      rcelp_half_rateD=1;   //Half-rate CELP
      break;
    case 4:
      BitUnpack((short *)&data_packet.MODE_BIT,(unsigned short *)RxPkt,1,PktPtr);
      MODE_BIT=data_packet.MODE_BIT;
      if (MODE_BIT==0)
        bit_rate=local_rate=4;
      else {
        bit_rate=local_rate=3;
        PPP_MODE_D='F';
	data_packet.MODE_BIT=1;data_packet.PACKET_RATE=4;
      }
      break;
    }
#endif

    
    //unpacking routine
    switch(data_packet.PACKET_RATE) {
    case 1:
      //silence
      BitUnpack((short *)&data_packet.LSP_IDX[0],(unsigned short*)RxPkt,4,PktPtr);
      BitUnpack((short *)&data_packet.LSP_IDX[1],(unsigned short*)RxPkt,4,PktPtr);
      BitUnpack((short *)&data_packet.SILENCE_GAIN,(unsigned short*)RxPkt,NUM_EQ_BITS,PktPtr);
      BitUnpack(zrbit,(unsigned short*)RxPkt,1,PktPtr); //15th bit

      //do bad-rate check
      BAD_RATE = bad_rate_check(0,codeBuf);
	      
      break;
    case 2:
      if (SPL_HNELP ==0) { //if SPL_HNELP is 1 unpacking done in spl_half-rate section above
        if(data_packet.MODE_BIT==0){
	//NELP
	    BitUnpack((short *)&data_packet.LSP_IDX[0],(unsigned short*)RxPkt,8,PktPtr);
	    BitUnpack((short *)&data_packet.LSP_IDX[1],(unsigned short*)RxPkt,8,PktPtr);
	    BitUnpack((short *)&data_packet.NELP_GAIN_IDX[0][0],(unsigned short*)RxPkt,5,PktPtr);
	    BitUnpack((short *)&data_packet.NELP_GAIN_IDX[1][0],(unsigned short*)RxPkt,6,PktPtr);
	    BitUnpack((short *)&data_packet.NELP_GAIN_IDX[1][1],(unsigned short*)RxPkt,6,PktPtr);
	    BitUnpack((short *)&data_packet.NELP_FID,(unsigned short*)RxPkt,2,PktPtr);
	    BitUnpack(zrbit,(unsigned short*)RxPkt,4,PktPtr); // no free bits
	    //do bad-rate check
	    BAD_RATE = bad_rate_check(1,codeBuf);
	}
	else if(data_packet.MODE_BIT==1){
	  //QPPP
	  BitUnpack((short *)&data_packet.LSP_IDX[0],(unsigned short *)RxPkt,10,PktPtr);
	  BitUnpack((short *)&data_packet.LSP_IDX[1],(unsigned short *)RxPkt,6,PktPtr);
	  BitUnpack((short *)&data_packet.Q_delta_lag,(unsigned short *)RxPkt,4,PktPtr);
	  BitUnpack((short *)&data_packet.AMP_IDX[0],(unsigned short *)RxPkt,6,PktPtr);
	  BitUnpack((short *)&data_packet.AMP_IDX[1],(unsigned short *)RxPkt,6,PktPtr);
	  BitUnpack((short *)&data_packet.POWER_IDX,(unsigned short *)RxPkt,6,PktPtr);
	  BitUnpack(zrbit,(unsigned short*)RxPkt,1,PktPtr); //40th bit
	  //do bad-rate check
	  BAD_RATE = bad_rate_check(2,codeBuf);
	}
      }

      break;
    case 3:
      //Half Rate Celp
      BitUnpack((short *) &data_packet.DELAY_IDX ,(unsigned short *)RxPkt,7,PktPtr);
      BitUnpack((short *) &data_packet.LSP_IDX[0] ,(unsigned short *)RxPkt,7,PktPtr);
      BitUnpack((short *) &data_packet.LSP_IDX[1] ,(unsigned short *)RxPkt,7,PktPtr);
      BitUnpack((short *) &data_packet.LSP_IDX[2] ,(unsigned short *)RxPkt,8,PktPtr);
      for(i=0;i<NoOfSubFrames;i++) BitUnpack((short *) &data_packet.ACBG_IDX[i] ,(unsigned short *)RxPkt,3,PktPtr);
      for(i=0;i<NoOfSubFrames;i++) BitUnpack((short *) &data_packet.FCB_PULSE_IDX[i][0] ,(unsigned short *)RxPkt,10,PktPtr);
      for(i=0;i<NoOfSubFrames;i++) BitUnpack((short *) &data_packet.FCBG_IDX[i] ,(unsigned short *) RxPkt,4,PktPtr);
      //do bad-rate check
      BAD_RATE = bad_rate_check(3,codeBuf);

      break;
    case 4:
      if(data_packet.MODE_BIT==0){
	if (SPL_HCELP==0) {
	  //FCELP
	  BitUnpack((short *) &data_packet.DELAY_IDX ,(unsigned short *)RxPkt,7,PktPtr);
	  BitUnpack((short *) &data_packet.LSP_IDX[0] ,(unsigned short *)RxPkt,6,PktPtr);
	  BitUnpack((short *) &data_packet.LSP_IDX[1] ,(unsigned short *)RxPkt,6,PktPtr);
	  BitUnpack((short *) &data_packet.LSP_IDX[2] ,(unsigned short *)RxPkt,9,PktPtr);
	  BitUnpack((short *) &data_packet.LSP_IDX[3] ,(unsigned short *)RxPkt,7,PktPtr);
	  BitUnpack((short *) &data_packet.DELTA_DELAY_IDX ,(unsigned short *)RxPkt,5,PktPtr);
	  for(i=0;i<NoOfSubFrames;i++) BitUnpack((short *) &data_packet.ACBG_IDX[i] ,(unsigned short *)RxPkt,3,PktPtr);
	  for(i=0;i<NoOfSubFrames;i++)
	  {
	  	  BitUnpack((short *) &data_packet.FCB_PULSE_IDX[i][1] ,(unsigned short *)RxPkt,8,PktPtr);
	  	  BitUnpack((short *) &data_packet.FCB_PULSE_IDX[i][0] ,(unsigned short *)RxPkt,8,PktPtr);
	  	  BitUnpack((short *) &data_packet.FCB_PULSE_IDX[i][3],(unsigned short *)RxPkt,8,PktPtr);
	  	  BitUnpack((short *) &data_packet.FCB_PULSE_IDX[i][2],(unsigned short *)RxPkt,8,PktPtr);
	  	  BitUnpack((short *) &tmp,(unsigned short *)RxPkt,3,PktPtr);
	  	  data_packet.FCB_PULSE_IDX[i][3] += (tmp<<8);
	  }
	  for(i=0;i<NoOfSubFrames;i++) BitUnpack((short *) &data_packet.FCBG_IDX[i] ,(unsigned short *) RxPkt,5,PktPtr);
	}
	//do bad-rate check
	BAD_RATE = bad_rate_check(5,codeBuf); //do this for spl. packet also

      }
      else if(data_packet.MODE_BIT==1){
	if (SPL_HPPP ==0) {
	  //FPPP
	  BitUnpack((short *) &data_packet.delayindex,(unsigned short *)RxPkt,7,PktPtr);
	  BitUnpack((short *) &data_packet.LSP_IDX[0] ,(unsigned short *)RxPkt,6,PktPtr);
	  BitUnpack((short *) &data_packet.LSP_IDX[1] ,(unsigned short *)RxPkt,6,PktPtr);
	  BitUnpack((short *) &data_packet.LSP_IDX[2] ,(unsigned short *)RxPkt,9,PktPtr);
	  BitUnpack((short *) &data_packet.LSP_IDX[3] ,(unsigned short *)RxPkt,7,PktPtr);
	  BitUnpack((short *) &data_packet.F_ROT_IDX,(unsigned short *)RxPkt,7,PktPtr);
	  BitUnpack((short *) &data_packet.A_AMP_IDX[0],(unsigned short *)RxPkt,6,PktPtr);
	  BitUnpack((short *) &data_packet.A_AMP_IDX[1],(unsigned short *)RxPkt,6,PktPtr);
	  BitUnpack((short *) &data_packet.A_AMP_IDX[2],(unsigned short *)RxPkt,8,PktPtr);
	  BitUnpack((short *) &data_packet.A_POWER_IDX,(unsigned short *)RxPkt,8,PktPtr);
	  for (i=0;i<NUM_FIXED_BAND;i++) {
	    if (i<3)
	      BitUnpack((short *) &data_packet.F_ALIGN_IDX[i],(unsigned short *)RxPkt,5,PktPtr);
	    else
	      BitUnpack((short *) &data_packet.F_ALIGN_IDX[i],(unsigned short *)RxPkt,6,PktPtr);
	  } //for
	} //for SPL_HPPP
	//do bad-rate check
	BAD_RATE = bad_rate_check(4,codeBuf);
      }
      else{
//	cerr<<"MODE_BIT neither 0 nor 1 in Frame #"<<decode_fcnt<<"\n";
      }
      break;
      
    } //for switch case

   
#if MOT_SUPPRESSED_EIGHTH_RATE
    if (PACKET_RATE == 1 && !BAD_RATE)
      {
      if (consec_eighth_rates < 3) // Most likely in DTX
	{
	consec_eighth_rates++;
	// Decode packet to update bgn estimate before re-encoding
	silence_decoder(outFbuf, 1);
#if 0
// NOTE TO ANANTH: REMOVE THIS BLOCK ONCE 1/8 RATE DECODER IS SOFTENED BY 3dB
{
int indx;
for (indx=0; indx<160; indx++)
{
outFbuf[indx] = outFbuf[indx]/2.0;
}
}
#endif
	// Update bgn estimate
	update_bbg_estimate(outFbuf, PACKET_RATE, 1.0);
	PACKET_RATE = 0;
	}
      }
    else if (PACKET_RATE == 0)
      {
      consec_eighth_rates = 0;
      }

    if (PACKET_RATE == 0) //suppressed eighth rate
      {
//printf("MOTO DTX ON\n");

//      consec_eighth_rates = 0;
      gen_encode_bbg(codeBuf);
//      for (i = 0; i < PACKWDSNUM; i++) {RxPkt[i]=codeBuf[i];}
      // After this, process as eighth rate.
      PACKET_RATE = data_packet.PACKET_RATE = 1;
      update_bbg_flag = 0;

      // Reset PktPtr
      for (i = 0; i < PACKWDSNUM; i++) {RxPkt[i]=codeBuf[i];}
      PktPtr[0]=16;PktPtr[1]=0;
      BitUnpack((short *)&data_packet.LSP_IDX[0],(unsigned short*)RxPkt,4,PktPtr);
      BitUnpack((short *)&data_packet.LSP_IDX[1],(unsigned short*)RxPkt,4,PktPtr);
      BitUnpack((short *)&data_packet.SILENCE_GAIN,(unsigned short*)RxPkt,NUM_EQ_BITS,PktPtr);
      }
    else
      {
      update_bbg_flag = 1;
      }
#endif
	
    if (!BAD_RATE) {  //speech proc, not bad-rate and not TTY
		N_consec_ers=0;
		fer_counter--;
		if (fer_counter<0) fer_counter=0;
		//Translate the PACKET_RATE to the appropriate bit_rate and PPP_MODE
		switch(PACKET_RATE) {
#ifdef MOT_SUPPRESSED_EIGHTH_RATE
		case 0:
#endif //MOT_SUPPRESSED_EIGHTH_RATE
		case 1:
                  bit_rate=local_rate=1;
		  break;
		case 2:
      		  MODE_BIT=data_packet.MODE_BIT;
                  if (MODE_BIT==0)
		    bit_rate=local_rate=2;
		  else {
                    bit_rate=local_rate=3;
		    PPP_MODE_D='Q';
		    data_packet.MODE_BIT=1;data_packet.PACKET_RATE=2;
		  }
		  break;
		case 3:
                  bit_rate=local_rate=3;
		  rcelp_half_rateD=1;   //Half-rate CELP
		  break;
		case 4:
      
		  MODE_BIT=data_packet.MODE_BIT;
                  if (MODE_BIT==0)
		    bit_rate=local_rate=4;
		  else {
                    bit_rate=local_rate=3;
		    PPP_MODE_D='F';
		    data_packet.MODE_BIT=1;data_packet.PACKET_RATE=4;
		  }
		  break;

		default:
		  bit_rate=0xE;
		    
		} //end of switch
	      
  //If not full-rate, disable Phase Matching for HCELP and QNELP
  if (((bit_rate != 4  && rcelp_half_rateD == 1)|| (bit_rate < 3 )) && do_phase_match == 1)
  {
	  do_phase_match = 0;
	  if (phase_offset == -1)
	  {
		rate = 0xE;
		printf ("\n going back to Lable 1 %d", bit_rate);
		go_back_input = 1;
	    goto Lable;
	  }
	  printf ("\n 1setting phase_offset to 10 %d", bit_rate);
	  phase_offset = 10;
  }
  //Phase Matching: if delay change is big, disable Phase Matching
  if (((bit_rate == 3 && PPP_MODE_D == 'F' && fabs(data_packet.delayindex + DMIN - pdelayD) >= 15) || (bit_rate == 4 && fabs(data_packet.DELAY_IDX + DMIN - pdelayD) >= 15)) && do_phase_match == 1)
  {
	  do_phase_match = 0;
	  if (phase_offset == -1)
	  {
		rate = 0xE;
		printf ("\n going back to Lable 2 %d %d %f", bit_rate, data_packet.delayindex + DMIN, pdelayD);
		go_back_input = 1;
	    goto Lable;
	  }

	  if (bit_rate == 3)
		  printf ("\n 2setting phase_offset to 10 %d %d %f %d", bit_rate, data_packet.delayindex + DMIN, pdelayD, data_packet.DELAY_IDX + DMIN);
	  else
		printf ("\n 2setting phase_offset to 10 %d %d %f", bit_rate, data_packet.DELAY_IDX + DMIN, pdelayD);	
	  phase_offset = 10;
  }
  //If full-rate CELP and delta delay == 0, disable Phase Matching
  if (bit_rate == 4 && data_packet.DELTA_DELAY_IDX == 0 && do_phase_match == 1)
  {
	  do_phase_match = 0;
	  if (phase_offset == -1)
	  {
		rate = 0xE;
		printf ("\n going back to Lable 3 %d %d", bit_rate, data_packet.DELTA_DELAY_IDX);
		go_back_input = 1;
	    goto Lable;
	  }
	  printf ("\n 3setting phase_offset to 10 %d", bit_rate);
	  phase_offset = 10;
  }

          
    // Do regular decoding
    switch(bit_rate) {

    case 1:
      silence_decoder(outFbuf, post_filter);
	  //printf ("\n SILENCE decoding");
	  *obuf_len = 160;
//      if(data_packet.PACKET_RATE!=1) cerr<<"Data packet wrongly called SILENCE in Frame #:"<<decode_fcnt<<"\n"<<"rate is actually:"<<data_packet.PACKET_RATE<<"\n";
      break;

    case 2:
      nelp_decoder(outFbuf, post_filter, time_warp_fraction, obuf_len);
//      if(data_packet.PACKET_RATE!=2) cerr<<"Data packet wrongly called NELP in Frame #:"<<decode_fcnt<<"\n"<<"rate is actually:"<<data_packet.PACKET_RATE<<"\n";
//       if(data_packet.MODE_BIT!=0) cerr<<"Rate not set for NELP in Frame #:"<<decode_fcnt<<"\n";
      break;

    case 3:
      if (rcelp_half_rateD){
        celp_decoder(outFbuf,post_filter,bit_rate, run_length, 10, 1, obuf_len);
	if(data_packet.PACKET_RATE!=3) cerr<<"Data packet wrongly called RCELP in Frame #:"<<decode_fcnt<<"\n"<<"rate is actually:"<<data_packet.PACKET_RATE<<"\n";
      }
      else{
        voiced_decoder(outFbuf, post_filter, run_length, phase_offset, time_warp_fraction, obuf_len);
		//printf ("\n voiced decoding %d", phase_offset);
      }
      break;

    case 4:
      celp_decoder(outFbuf, post_filter,bit_rate, run_length, phase_offset, time_warp_fraction, obuf_len);
      if(data_packet.PACKET_RATE!=4) cerr<<"Data packet wrongly called FCELP in Frame #:"<<decode_fcnt<<"\n"<<"rate is actually:"<<data_packet.PACKET_RATE<<"\n";
      break;

    case 12:
      cerr<<"come in case 12 frame #:"<<decode_fcnt<<"\n";
      break;
      
    }

    /* Add fading when there is no erasure*/
    FadeScale = MIN(1.0, FadeScale+0.6); //CELP erasure routine is using this FadeScale

    //Back up this frame for potential pitch correction in case of erasures
    if (fer_counter==2) {
      pdelayD3=pdelayD2;
      for (i=0;i<ACBMemSize;i++) PitchMemoryD3[i]=PitchMemoryD2[i];
    }
#if MOT_SUPPRESSED_EIGHTH_RATE
    if (update_bbg_flag == 1) //not suppressed eighth rate
      {
      update_bbg_estimate(outFbuf, PACKET_RATE, 1.0);
      }
#endif
    } //not bad-rate
    else {
      // bad-rate detecte
      N_consec_ers++;    
#if 1 
		PACKET_RATE=data_packet.PACKET_RATE=0xE;//erasure , bug-fix in the way the next frame is processed
#endif	  
      if (lastrateD!=3) prev_rcelp_half=0;
      if (prev_rcelp_half==1) {
        lastrateD=4;
        prev_rcelp_half=0;
      }
      fer_processing(outFbuf,post_filter,bit_rate=lastrateD); 
    } //bad-rate
   } //not special half-celp and last frmae not nelp,eighth
}
  
  /* update decoder varaibles */
  for (i=0;i<ACBMemSize;i++) prevpD[i]=PitchMemoryD[i];
  for (i=0; i<LPCORDER; i++) {
    OldOldlspD[i] = OldlspD[i];
    OldlspD[i] = lsp[i];
  }
  lastrateD = bit_rate;
  prev_rcelp_half=rcelp_half_rateD;
  LAST_PACKET_RATE_D = PACKET_RATE;
  LAST_MODE_BIT_D = MODE_BIT;
  decode_fcnt++;
  prev_prev_frame_error = prev_frame_error;
  prev_frame_error=(rate==0xE||errorFlag==1||BAD_RATE==1);


}
