/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

/**************************************************************************
****        Globalstar Vocoder C/C++ Simulation  - Version 3           ****
****                Copyright 1996 - Qualcomm, Inc.                    ****
***************************************************************************

Globalstar Vocoder Main Defines File (defines, static arrays, etc.)
Sharath Manjunath; Ver 1 - 25 July 1996
		   Ver 2 - 12 October 1996
Modifications:	23 January 1997  - Removed Recursive CB Defines
		21 February 1997 - Define for Onset Mode
		10 April 1997    - Updated vocoder rates
To Do: Increment NUMMODES by 1 (for ONSET) and Adjust Accordingly
**************************************************************************/

#ifndef _defines_h
#define _defines_h

#include <stdio.h>

//#define USE_RCELP_WITH_UQ_LSP

#define DTX
//#define QCDTX
#define NEWMALSPVQ
#define LSP_SPRD
//#define NEWMALSPVQ3

//# define MRES
//# define QRES 
//#define RES
#define PA_BUMPUP
#define FIX_BUG_IN_COD7_35

#define EVRC_LSPQ
#define DBG_ANANTH 1
#define FQQ_ANANTH 1
#define GET_PPP_RESID_FROM_UQLSP_ANANTH 0
#define OP2_OPENLOOP_BUMPUP_LIKE_OP1 1
#define OP2_BUMPUP_CELP 1
#define RESIDUAL_DOMAIN_CORR_FOR_OL_BUMPUP 1
#define IMPROVED_MODE_DEC 1
#define NEW_POSTFILT_TILT 0
#define REDUCE_CLEAN_SILENCE 1
#define NEW_RCELP_RSHIFT 0
#define ENRATIOS_FOR_OL_BUMPUP 1
#define CL_BUMPUP_UNSTABLE 1

#define FSIZE 160
#define LPCOFFSET 40
#define DEC_DELAY 40
#define TX_SIZE (2*FSIZE+FSIZE+LPCOFFSET)
#define RX_SIZE (FSIZE+DEC_DELAY)
#define NUMMODES 7
#define ATYPE 0
#define BTYPE 1
#define YES 1
#define NO 0
#define FULL 0
#define THREE_QUARTER 1
#define HALF 2
#define QUARTER 3
#define ZERO 4
#define BLANK 5
#define ERASURE 14
#define CELP 0
#define PPP 1
#define NELP 2
#define ONSET 4
#define PF_ON 1
#define UNLIMITED -1
#define INACTIVE 0
#define ACTIVE 1
//#define UNVOICED 2
//#define VOICED 3
//#define TRANSIENT 4
#define ENCODER 0
#define DECODER 1

/* New additions -- JH*/
#define NEW_MODE_DECISION  YES

#define PitchPreFilter NO
//To Add noise for anti-buzz
#define ADD_NOISE 0

#include <math.h>
static double anint(double x) {return (x)>=0?(int)((x)+0.5):(int)((x)-0.5);}
#ifdef __SUNOS4__
static double log2(double x)  {return log(x)/log(2.0);}
#endif

#ifdef WIN32
#define M_PI 3.1415926535898
static double log2(double x)  {return log(x)/log(2.0);}
#endif

#ifdef PI
#undef PI
#endif
#define PI M_PI
#ifdef TWO_PI
#undef TWO_PI
#endif
#define TWO_PI (2*M_PI)

#define MAX(a,b) ((a)>(b)?(a):(b))
#ifdef MIN
#undef MIN
#endif
#define MIN(a,b) ((a)<(b)?(a):(b))
#define SIGN(a) ((a)>=0?(1):(-1))
#define SQR(a) ((a)*(a))
#define FRAC(a) ((a)-(float)((int)(a)))
#define ABS(a) ((a)>=0?(a):(-(a)))
/* Coder Specifics */
typedef struct{int mode;int curr_voiced;int speech_type;int qspeech_type;}MODE;
#define LPCORDER 10
#define BPFORDER 23
#define LPCSF 4
#define IRLEN 20
#define MINLAG 16
//#define MAXLAG 127
#define MAXLAG 120
#define MINLAG_TRK 12 /* 4 lesser than actual min. to enable interp. of corr */
#define MINLAG_PPP 16
#define MAXLAG_PPP MAXLAG
//#define MAXLAG_WI 190 /* Need to allocate more space to handle pitch doubling/tripling*/
#define MAXLAG_WI_EVRC 61 /* Need to allocate more space to handle pitch doubling/tripling*/

#define SUBSAMP 2
#define DECIM_FILTER_LENGTH 15
#define LAGRANGE (MAXLAG_PPP-MINLAG_TRK+1)
#define FR_INTERP_WIDTH 8
#define PITCH_FILT_ORDER (MAXLAG+FR_INTERP_WIDTH/2)
#define LENGTH_OF_IMPULSE_RESPONSE 40
#define PFZF 0.625
#define PFPF 0.775
#define AGC_FACTOR 0.9375
#define BRIGHT_COEFF 0.3


//static float BWE_FACTOR=0.9883;
//static float PWF=0.8;
//static float VOC_RATE[NUMMODES]={0.0, 1.55, 1.55, 3.9, 3.9, 6.0, 8.5};
//static float CHAN_RATE[NUMMODES]={0.05, 2.4, 2.4, 4.8, 4.8, 7.2, 9.6};
//static int PITCH[NUMMODES]={NO,NO,NO,YES,NO,YES,YES};
static int CBSF[NUMMODES]={4, 4, 0, 0, 4, 4, 4};
//static int QUANTIZE[NUMMODES]={NO,NO,NO,YES,YES,YES,YES};

#define MAXCBSF 8
#define NUMPPPCB 3

#define CELPB_LEVELS 9
#define MAX_CELPB 2.0
#define MIN_CELPB 0.0
#define PPPB_LEVELS 64
#define MAX_PPPB 4.0
#define MIN_PPPB 0.0625
//static float EXY_INTERP_COEFF[4]={-0.04,0.54,0.54,-0.04};
//static int CBLENGTH[NUMMODES]={0, 0, 70, 128, 256, 256, 128};


//static float *CB[NUMMODES]={0, 0, CBQUART, CBPPP, CBHALF, CBTHREEQ, CBFULL};
#define CELPGFULLLENGTH 16
#define CELPGACELPFULLLENGTH 32
#define MAXGACELP 11.2636
#define MINGACELP 0
#define CELPGTHREEQLENGTH 256
#define CELPGHALFLENGTH 256
#define NUM_ERB 22
#define NUM_FIXED_BAND 17 /* Num of bands for multiband alignment in FPPP */
//static int PPPGLENGTH=256;

#define PTS 500 /* Number of points for integration in SD computation */
#endif
