/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/encode.cpp#1 $";

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

/*======================================================================*/
/*  Lucent Technologies Network Wireless Systems                        */
/*  EVRC Floating-point C Simulation.                                   */
/*                                                                      */
/*  Copyright (C) 1996 Lucent Technologies Incorporated. All rights     */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/
/*  Module:     encode                                               	*/
/*----------------------------------------------------------------------*/
/*  History:                                                            */
/*	   09/04/95  ACELP fixed codebook search added	(AT&T/Nokia)	*/
/*     03/08/96  Trap added for all ones rate 1/8 packet(TJ,Lucent Tech)*/
/*     08/18/96  Modified LSP interpolation in preencode to use         */
/*               non-quantized Endpoints.                               */
/*----------------------------------------------------------------------*/
/* EVRC Encoder */
/*======================================================================*/
/*         ..Includes.                                                  */
/*----------------------------------------------------------------------*/
#include  <string.h>
#ifdef WIN32
#include <iostream>
#include <Winsock2.h>
using namespace std;
#include <io.h>
#else
#include  <unistd.h>
#endif


#include  "macro.h"
#include  "proto.h"
#include  "rom.h"
#include  "acelp.h"	/* for ACELP fixed codebook */
#include  "struct.h"
#include  "lu_mod.h"

//float VC;

/*======================================================================*/
/*         ..Reset RCELP encoder parameters.                            */
/*----------------------------------------------------------------------*/

void FGV_MEM::InitEncoder()
{
  /*....(local) variables....*/
  int     j;
  float   ftmp;
  float   sum1, sum2;
  /****************************************************/
  /*         Algorithm (one time) initializations     */
  /****************************************************/
  
  /* Calculate ROM tables */
  
  /* FCB gains (4k) */
  sum1 = sum2 = 8.0 / 16.0;	/* Spacing  8.3/16.0 ?*/
  gnvq_4[0] = exp(sum1);
  for (j=1; j<16; j++) {
    sum2 += sum1;
    gnvq_4[j] = exp(sum2);
  }
  
	/* FCB gains (8k) */
  sum1 = sum2 = 8.0 / 32.0;	/* Spacing */
  gnvq_8[0] = exp(sum1);
  for (j=1; j<32; j++) {
    sum2 += sum1;
    gnvq_8[j] = exp(sum2);
  }
  
  /* More initialization is done in the routines using FirstTime */
  /* static variable to indicate algorithmic reset.              */
  
  bit_rate=4;
  
  encode_fcnt = 0;
  
  /* ACB gains */
  for (j=0; j<ACBGainSize-1; j++) ppvq_mid[j] = (ppvq[j] + ppvq[j + 1]) / 2.0;

  for (j=0; j<ORDER; j++) SynMemoryM[j] = 0.0;

  ftmp = 0.48 / (float) ORDER;
  OldOldlspE[0] = OldlspE[0] = Oldlsp_nq[0] = ftmp;
  for (j=1; j<ORDER; j++) {
    OldOldlspE[j] = OldOldlspE[j - 1] + ftmp;
    OldlspE[j] = OldlspE[j - 1] + ftmp;
    Oldlsp_nq[j] = Oldlsp_nq[j - 1] + ftmp;
  }
  
  /*	HPspeech = residual; */
  
  for (j=0; j<GUARD; j++) ConstHPspeech[j] = 0.0;

  for (j=0; j<ORDER; j++) WFmemIIR[j] = WFmemFIR[j] = 0.0;

  for (j=0; j<ACBMemSize; j++) Excitation[j] = 0.0;
  accshift = 0.0;
  shiftSTATE = 0;
  dpm = 0;
  pdelay = 40.0;
  
  LPCgain = 1.0;
}

/*======================================================================*/
/*         ..Get beta, et al.                                           */
/*----------------------------------------------------------------------*/
#define SIGN(a) ((a)>=0?(1):(-1))
#define SQR(a) ((a)*(a))
double sens[ORDER], P_s[ORDER/2], Q_s[ORDER/2];
float lsi[ORDER];



void FGV_MEM::pre_encode (float*  inFbuf,float*  Rs)
{
  /*....(local) variables....*/
  register int i, j;	/* counters */
  float   sum1;		/* tmp accumulator */
  
  float lsc[ORDER];
  
  //static float  last_delay, last_beta;
  int   k, k0;
  float sum0;
  
  /*....execute....*/
  
  /* Re-initialize PackWdsPtr */
  PackWdsPtr[0] = 16;
  PackWdsPtr[1] = 0;
  PktPtr[0]=16;PktPtr[1]=0;
  for (i=0; i<PACKWDSNUM; i++){ PackedWords[i] = 0; TxPkt[i]=0;}

  /* Process Data */
  for (j = 0; j < FrameSize + LOOKAHEAD_LEN; j++)
    HPspeech[j + GUARD] = inFbuf[j];
  //  for (j=0; j<FrameSize + 80; j++) HPspeech[j + GUARD] = inFbuf[j];
  
  /* Make sure HPspeech - HPspeech+2*GUARD have the right memory */
  for (j=0; j<GUARD; j++) HPspeech[j] = ConstHPspeech[j];

  /* Update ConstHPspeech for next frame */
  for (j=0; j<GUARD; j++) ConstHPspeech[j] = HPspeech[j + FrameSize];
 

  /* Calculate prediction coefficients */
  /* reflection coef. not needed-returned in Scratch */
  lpcanalys(pci, Scratch, HPspeech, ORDER, LPC_ANALYSIS_WINDOW_LENGTH, Rs);

  /* Calculate P_s and Q_s for weight computation */
  for (i=0;i<ORDER/2;i++) P_s[i]=pci[i]+pci[ORDER-1-i];
  for (i=0;i<ORDER/2;i++) Q_s[i]=pci[i]-pci[ORDER-1-i];
  
  /* Calculate impulse response of 1/A(z) Note: only one IIR filter */
  ImpulseRzp(H, pci, pci, 1.0, 1.0, ORDER, Hlength);
  
  /* Get energy of H */
  for (j=0,sum1=0; j<Hlength; j++) sum1 += H[j] * H[j];

  /* determine spectral transistion degree (set flag if large) --
     for frame erasures */
  if (sum1 / LPCgain > 10.0) LPCflag = 1;
  else LPCflag = 0;
  
  LPCgain = sum1;
  
  /* Bandwidth expansion */
  weight(pci, pci, _Gamma_4, ORDER);
  

  /* Convert prediction coefficients to lsp */
  a2lsp(lsp_nq, pci);
  
  /* compute lsi for quantization */
  for (i=0; i<ORDER; i++) lsc[i]=cos(pi2*lsp_nq[i]);
  for (i=0;i<ORDER;i++)
    lsi[i]=(lsc[i]<0.0)+ (SIGN(lsc[i]))*0.5*sqrt(1.0-fabs(lsc[i]));
  /* compute sensitivity weights */  
  compute_sens(lsc, Rs, P_s, Q_s, sens);  
  
  /* Get residual signal */
  for (j=0; j<ORDER; j++) Scratch[j]=0; /* Scratch is used as filter memory */

  lsp2a(pci_nq, Oldlsp_nq);
  
  GetResidual(residual, HPspeech, pci_nq, Scratch, ORDER, GUARD);
  
  for (i=0; i<NoOfSubFrames; i++) {
    
    Interpol(lspi_nq, Oldlsp_nq, lsp_nq, i, ORDER);
    lsp2a(pci_nq, lspi_nq);
    if (i < 2)
      GetResidual(residual + i * (SubFrameSize - 1) + GUARD,
		  HPspeech + i * (SubFrameSize - 1) + GUARD, pci_nq, Scratch,
		  ORDER, SubFrameSize - 1);
    else
      GetResidual(residual + i * (SubFrameSize - 1) + GUARD,
		  HPspeech + i * (SubFrameSize - 1) + GUARD, pci_nq, Scratch,
		  ORDER, SubFrameSize);
  }

  GetResidual(residual + FrameSize + GUARD, HPspeech + FrameSize + GUARD, pci,Scratch, ORDER, LOOKAHEAD_LEN);
  //  GetResidual(residual + FrameSize + GUARD, HPspeech + FrameSize + GUARD, pci,Scratch, ORDER, GUARD);
  
  /* Calculate pitch period at the end of the frame, use n.q. lpc coef. */
  fndppf(&delay1, &beta1, residual + GUARD, DMIN, DMAX, FrameSize);
  fndppf(&delay, &beta, residual + 2 * GUARD, DMIN, DMAX, FrameSize);
  
  if (beta1 > beta + 0.4) {
    if (fabs(delay - delay1) > 15) {
      beta = beta1;
      delay = delay1;
    }
    else {
      beta = (beta + beta1) / 2.0;
      delay = floor((delay + delay1) / 2.0);
    }
  }
  else if ((beta1 > beta +0.05) && fabs(delay1 - last_delay) < 7 ) {
    /* if delay1 is close to delay for last frame and beta1 > beta */
    if (fabs(delay - delay1) > 15) {
      beta = beta1;
      delay = delay1;
    }
    else {
      beta = (beta + beta1) / 2.0;
      j = (short) ((delay + delay1) / 2.0 +0.5);
      
      for(k=j-1,sum0=-1.0E30; k<=j+1; k++) {
        for (i=0,sum1=0.0; i<FrameSize-k; i++)
          sum1 += residual[GUARD*3/2+i] * residual[GUARD*3/2+i+k];
        if(sum1 > sum0) {
          sum0 = sum1;
          k0 = k;
        }
      }
      delay = (float)k0;
    }
  }
  
  last_delay = delay;
  last_beta  = beta;
  
  get_nacf_at_pitch(residual+GUARD,(int)delay1,(int)delay,nacf_ap+2);
  
  for (k=0;k<2;k++) {
	curr_ns_snr[k]=(next_ns_snr[0][k]+next_ns_snr[1][k])/2.0;
  }	
  return;
}

/***** Compute the sensitivity weights for LSI quantization  *********
   Inputs:
          float *lsc -- lsc coeffs
	  float *Rs -- aotucorrs
	  double *P_s, *Q_s -- P Q coeffs derived from LPC coeffs
   Outputs:
          double *sens -- weights
	  ***********************************************************/
void compute_sens(float *lsc, float *Rs, double *P_s, double *Q_s,double *sens)
{
  int i,j,k;
  double J[ORDER][ORDER],RJ[ORDER];
      
  for (i=0;i<ORDER;i+=2) {
    J[i][ORDER-1]=J[i][0]=1.0;
    J[i][ORDER-2]=J[i][1]=2.0*lsc[i]+P_s[0];
    J[i+1][ORDER-1]=-(J[i+1][0]=1.0);
    J[i+1][ORDER-2]=-(J[i+1][1]=2.0*lsc[i+1]+Q_s[0]);
    for (k=2;k<ORDER/2;k++) {
      J[i][ORDER-1-k]=
	J[i][k]=2.0*lsc[i]*J[i][k-1]+P_s[k-1]-J[i][k-2];
      J[i+1][ORDER-1-k]=
	-(J[i+1][k]=2.0*lsc[i+1]*J[i+1][k-1]+Q_s[k-1]-J[i+1][k-2]);
    }

    RJ[0]=1.0; for (j=1;j<ORDER/2;j++) RJ[0]+=SQR(J[i][j]); RJ[0]*=2.0;
    for (k=2;k<=ORDER-2;k+=2) {
      RJ[k]=J[i][k];
      RJ[k-1]=J[i][k-1]+J[i][ORDER/2-1+k/2]*J[i][ORDER/2-k/2]/2.0;
      for (j=1;j<ORDER/2-k/2;j++) {
	RJ[k]+=J[i][j+k]*J[i][j];
	RJ[k-1]+=J[i][j+k-1]*J[i][j];
      }
      RJ[k]*=2.0;RJ[k-1]*=2.0;
    }
    RJ[ORDER-1]=J[i][ORDER-1];
    sens[i]=Rs[0]*RJ[0]/2.0;
    for (j=1;j<ORDER;j++) sens[i]+=Rs[j]*RJ[j];
    sens[i]*=(1.0-fabs(lsc[i]));
    sens[i]=(sens[i]>0) ? sens[i]:1.0;
    RJ[0]=1.0; for (j=1;j<ORDER/2;j++)RJ[0]+=SQR(J[i+1][j]); RJ[0]*=2.0;
    for (k=2;k<=ORDER-2;k+=2) {
      RJ[k]=J[i+1][k];
      RJ[k-1]=J[i+1][k-1]+
	J[i+1][ORDER/2-1+k/2]*J[i+1][ORDER/2-k/2]/2.0;
      for (j=1;j<ORDER/2-k/2;j++) {
	RJ[k]+=J[i+1][j+k]*J[i+1][j];
	RJ[k-1]+=J[i+1][j+k-1]*J[i+1][j];
      }
      RJ[k]*=2.0;RJ[k-1]*=2.0;
    }
    RJ[ORDER-1]=J[i+1][ORDER-1];
    sens[i+1]=Rs[0]*RJ[0]/2.0;
    for (j=1;j<ORDER;j++) sens[i+1]+=Rs[j]*RJ[j];
    sens[i+1]*=(1.0-fabs(lsc[i+1]));
    sens[i+1]=(sens[i+1]>0) ? sens[i+1]:1.0;
  }
}/* End Next Sensitivities */


/*======================================================================*/
/*         ..Encode speech data.                                        */
/*----------------------------------------------------------------------*/

/* My global data definition */
float q_resid[FrameSize];
//float global_lsp[ORDER];
float prev_uvgain;
//float prev_en[ACBMemSize];
/* End of my data */

//char PPP_MODE_E='Q' ;

//int rcelp_half_rateE=0,prev_dim_and_burstE=0,dim_and_burstE=0;

//////////////////////////////////////////////////////
// Do stand-alone RCELP
// Computes residualm - modified residual (full-frame)
// Computes mspeech - modified speech (full-frame)
// Computes wspeech - weighted modified speech
// Updates pdelay, accshift, dpm, shiftSTATE, delay
//         data_packet.DELAY_IDX,data_packet.DELTA_DELAY_IDX
// Also updates pci, pci_nq etc
//////////////////////////////////////////////////////
void FGV_MEM::get_rcelp()
{
  int i, j;
  int subframesize;
  float   delayi[3];
  // Update shiftSTATE with hysteresis 
  /*
    accshift = 0;
    dpm = 0;
  shiftSTATE = 0;
  */
  if (beta < 0.1) {
    accshift = 0;
    dpm = 0;
    shiftSTATE = 0;
  }
  
  if (accshift > 20) shiftSTATE = -1;
  if (accshift < -20) shiftSTATE = 1;
  if (accshift <= 10 && shiftSTATE == -1) shiftSTATE = 0;
  if (accshift >= -10 && shiftSTATE == 1) shiftSTATE = 0;

  /* Control accshift */
  
  if (shiftSTATE == 1 && beta < 0.4) delay += 1.0;
  else if (shiftSTATE == -1 && beta < 0.4) delay -= 1.0;
  if (delay > DMAX) delay = DMAX;
  if (delay < DMIN) delay = DMIN;

  
  data_packet.DELAY_IDX=(int) (delay-DMIN);

  if (lastrateE <3) pdelay=delay;

  //Prepare for the delta delay
  j = (short) (delay - pdelay);
  if (abs(j) > 15) j = 0;
  else j = j + 16;
  assert(j>=0 && j<32);
  data_packet.DELTA_DELAY_IDX=(unsigned short) j;
  
  if (rate==3 && !rcelp_half_rateE && !dim_and_burstE) assert(fabs(delay-pdelay)<=15);
  /* Smooth interpolation if the difference between delays is too big */
  if (fabs(delay - pdelay) > 15) pdelay = delay;

  //float residualm_frame[FrameSize+EXTRA];
  for (i=0; i<NoOfSubFrames; i++) {
    if (i < 2) subframesize = SubFrameSize - 1;
    else subframesize = SubFrameSize;

    /* interpolate lsp */
#ifdef USE_RCELP_WITH_UQ_LSP
#else //USE_RCELP_WITH_UQ_LSP
    Interpol(lspi, OldlspE, lsp, i, ORDER);
#endif //USE_RCELP_WITH_UQ_LSP
    Interpol(lspi_nq, Oldlsp_nq, lsp_nq, i, ORDER);

    /* Convert lsp to PC */
#ifdef USE_RCELP_WITH_UQ_LSP
#else //USE_RCELP_WITH_UQ_LSP
    lsp2a(pci, lspi);
#endif //USE_RCELP_WITH_UQ_LSP
    lsp2a(pci_nq, lspi_nq);

    
    /* Interpolate delay */
    Interpol_delay(delayi, &pdelay, &delay, i);

    ComputeACB(residualm, Excitation + ACBMemSize, delayi,
	       residual + GUARD + i * (SubFrameSize - 1),
	       FrameSize + GUARD - i * (SubFrameSize - 1), &dpm,
	       &accshift, beta, subframesize, RSHIFT);

    for (j=0;j<subframesize;j++) residualm_frame[i * (SubFrameSize - 1) + j]=residualm[j];

    /* Get weighted speech */
    /* ORIGM */
#ifdef USE_RCELP_WITH_UQ_LSP
    SynthesisFilter(mspeech+i*(SubFrameSize-1), residualm, pci_nq, SynMemoryM, ORDER, subframesize);
#else //USE_RCELP_WITH_UQ_LSP
    SynthesisFilter(mspeech+i*(SubFrameSize-1), residualm, pci, SynMemoryM, ORDER, subframesize);
#endif //USE_RCELP_WITH_UQ_LSP
    
    /* Weighting filter */
    weight(wpci, pci_nq, GAMMA_1, ORDER);
    fir(Scratch, mspeech+i*(SubFrameSize-1), wpci, WFmemFIR, ORDER, subframesize);
    weight(wpci, pci_nq, GAMMA2, ORDER);
    iir(wspeech+i*(SubFrameSize-1), Scratch, wpci, WFmemIIR, ORDER, subframesize);

    /* Update residualm */
    for (j=0; j<dpm; j++) residualm[j] = residualm[j + subframesize];

  }
}
