/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/lsp.cpp#1 $";

/*======================================================================*/
/*  Lucent Technologies Network Wireless Systems                        */
/*  EVRC Floating-point C Simulation.                                   */
/*                                                                      */
/*  Copyright (C) 1996 Lucent Technologies Incorporated. All rights     */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

#include "macro.h"

/*----------------------------------------------------------------------*/
/*  Module:     a2lsp                                                   */
/*----------------------------------------------------------------------*/
/*  History:                                                            */
/*      1/1/95   Written by Dror Nahumi, AT&T                           */
/*----------------------------------------------------------------------*/

/*
 * pctolsp - convert pc to lsp
 *
 * NOTES: 1. This routine is hardwired for 10th order
 *        2. The routine uses 3 stage uniform grid quantization of lsp.
 */

#define STEPSNUM 4

void a2lsp(float *freq,float *a)
{
  static float STEPS[4] =
  {0.00635, 0.003175, 0.0015875, 0.00079375};	/* rom storage */
  int     lspnumber;
  int     root, notlast;
  float   temp, temp0, temp1, temp2;
  float   q[10];
  float   prev[2];
  int     offset;
  int     iswitch;
  float   frequency, LastFreq;
  float   STEP;
  int     STEPindex;
  
  LastFreq = 0;
  
  /* calculate q[z] and p[z] , they are all stored in q*/
  
  q[0] = a[0] + a[9] - 1.0;
  q[1] = a[1] + a[8] - q[0];
  q[2] = a[2] + a[7] - q[1];
  q[3] = a[3] + a[6] - q[2];
  q[4] = a[4] + a[5] - q[3];
  q[4] = q[4] / 2;
  
  offset = 5;
  q[0 + offset] = a[0] - a[9] + 1.0;
  q[1 + offset] = a[1] - a[8] + q[0 + offset];
  q[2 + offset] = a[2] - a[7] + q[1 + offset];
  q[3 + offset] = a[3] - a[6] + q[2 + offset];
  q[4 + offset] = a[4] - a[5] + q[3 + offset];
  q[4 + offset] = q[4 + offset] / 2;
  
  prev[0] = 9e9;
  prev[1] = 9e9;
  lspnumber = 0;
  notlast = TRUE;
  iswitch = 0;
  frequency = 0;
  
  while (notlast) {
    
    root = TRUE;
    offset = iswitch * 5;
    STEPindex = 0;	/* Start with low resolution grid */
    STEP = STEPS[STEPindex];
    
    while (root) {
      
      temp = cos(frequency * 6.2832);
      temp1 = 2.0 * temp + q[0 + offset];
      temp2 = 2.0 * temp * temp1 - 1.0 + q[1 + offset];
      temp0 = 2.0 * temp * temp2 - temp1 + q[2 + offset];
      temp1 = 2.0 * temp * temp0 - temp2 + q[3 + offset];
      temp2 = temp * temp1 - temp0 + q[4 + offset];
      
      if ((temp2 * prev[iswitch]) <= 0.0 || frequency >= 0.5) {
	if (STEPindex == STEPSNUM - 1) {
	  if (fabs(temp2) < fabs(prev[iswitch])) {
	    freq[lspnumber] = frequency;
	  }
	  else {
	    freq[lspnumber] = frequency - STEP;
	  }
	  
	  if ((prev[iswitch]) < 0.0) {
	    prev[iswitch] = 9e9;
	  }
	  else {
	    prev[iswitch] = -9e9;
	  }
	  root = FALSE;
	  frequency = LastFreq;
	  STEPindex = 0;
	}
	else {
	  if (STEPindex == 0) {
	    LastFreq = frequency;
	  }
	  frequency -= STEPS[++STEPindex];/* Go back one grid step */
	  STEP = STEPS[STEPindex];
	}
      }
      else {
	prev[iswitch] = temp2;
	frequency += STEP;
      }
    }
    
    lspnumber++;
    if (lspnumber > ORDER - 1)
      notlast = FALSE;
    iswitch = 1 - iswitch;
  }
}
/*======================================================================*/
/*  Lucent Technologies Network Wireless Systems                        */
/*  EVRC Floating-point C Simulation.                                   */
/*                                                                      */
/*  Copyright (C) 1996 Lucent Technologies Incorporated. All rights     */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/
/*  Module:     lsp2a                                                   */
/*----------------------------------------------------------------------*/
/*  History:                                                            */
/*     01/01/95  Written By Dror Nahumi, AT&T                           */
/*----------------------------------------------------------------------*/

/************************************************************************
* Routine name: lsptopc.                                                *
* Function: Convert lsp to pc.                                          *
* Inputs: freq - Quantized line spectral frequencies.                   *
* Outputs: pc - prediction coefficients.                                *
************************************************************************/

void lsp2a(float *pc,float *freq)
{
  float   p[ORDER / 2], q[ORDER / 2];
  float   a[ORDER / 2 + 1], a1[ORDER / 2 + 1], a2[ORDER / 2 + 1];
  float   b[ORDER / 2 + 1], b1[ORDER / 2 + 1], b2[ORDER / 2 + 1];
  float   xx, xf;
  int     i, k;
  int     lspflag;
  
  lspflag = 1;
  /*	*** check input for ill-conditioned cases */
  if ((freq[0] <= 0.0) || (freq[ORDER - 1] >= 0.5)) {
    lspflag = 0;
    if (freq[0] <= 0) freq[0] = 0.022;
    if (freq[ORDER - 1] >= 0.5)	freq[ORDER - 1] = 0.499;
  }

  if (!lspflag) {
    xx = (freq[ORDER - 1] - freq[0]) / (float) ORDER;
    for (i=1; i<ORDER; i++)	freq[i] = freq[i - 1] + xx;
  }

  for (i=0; i<=ORDER/2; i++) {
    a[i] = 0.;
    a1[i] = 0.;
    a2[i] = 0.;
    b[i] = 0.;
    b1[i] = 0.;
    b2[i] = 0.;
  }
  
  for (i=0; i<ORDER/2; i++) {
    p[i] = cos(6.2832 * freq[2 * i]);
    q[i] = cos(6.2832 * freq[2 * i + 1]);
  }
  
  xf = 0.;
  xx = .25;
  
  for (k=0; k<=ORDER; k++) {
    a[0] = xx + xf;
    b[0] = xx - xf;
    xf = xx;
    xx = 0;
    
    for (i=0; i<ORDER/2; i++) {
      a[i + 1] = a[i] - 2 * p[i] * a1[i] + a2[i];
      b[i + 1] = b[i] - 2 * q[i] * b1[i] + b2[i];
      a2[i] = a1[i];
      a1[i] = a[i];
      b2[i] = b1[i];
      b1[i] = b[i];
    }
    if (k != 0) {
      pc[k - 1] = 2 * (a[ORDER / 2] + b[ORDER / 2]);
    }
    //printf("LSP2A %f\n",pc[k-1]);
  }
}
