/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/silence.cpp#1 $";

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

/* This is the original EVRC eighth rate coder */
/* separated from the main routine encode.c */

#include  <stdio.h>
#include  <stdlib.h>

#include  "macro.h"
#include  "proto.h"
#include  "rom.h"
#include  "struct.h"
#include  "lu_mod.h"

#ifdef NEWMALSPVQ3
//extern float cbprevprev_E3[LPCORDER],cbprev_E3[LPCORDER];
#endif //NEWMALSPVQ3

#ifdef DTX
#define LSP_INTERP 1
#define GAIN_SMOOTH 1
#endif //DTX


//static float copy[FrameSize];

void FGV_MEM::silence_decoder(float *outFbuf,short post_filter)
{
  register int i, j;
  register float *foutP;
  float   delayi[3];
  short   subframesize;
  
  // Gain Quantization Setups
  FCBGainSize = 16;	/*...use half-rate gain quantizer...*/
  gnvq = gnvq_4;

  // LSP Quantization
  float tmplsi[ORDER], tmplsc[ORDER];
#ifdef EVRC_LSPQ
  lspmaq_dec(ORDER, 1, 2, nsub8, nsize8, lsp,(short int *)data_packet.LSP_IDX, 1, lsptab8);
#else //EVRC_LSPQ
  dec_lsp_vq_8 ((short int *)data_packet.LSP_IDX, lsp);
#endif //EVRC_LSPQ
  /* Check for monontonic LSP */
  for (j=1; j<ORDER; j++) if (lsp[j] <= lsp[j - 1]) errorFlag=1;
#ifdef NEWMALSPVQ
    for (i=0;i<ORDER;i++) cbprevprev_D[i]=cbprev_D[i]=lsp[i];    
#else //NEWMALSPVQ
  /* Compute lsi for backing up for MA LPC in PPP */
  for (i=0; i<ORDER; i++) tmplsc[i]=cos(pi2*lsp[i]);
  for (i=0;i<ORDER;i++)
    tmplsi[i]=(tmplsc[i]<0.)+(SIGN(tmplsc[i]))*0.5*sqrt(1-fabs(tmplsc[i]));
  for (i=0;i<ORDER;i++) cbprevprev_D[i]=cbprev_D[i]=tmplsi[i];
#endif //NEWMALSPVQ
  
#ifdef LSP_SPRD
  lsp_spread(lsp);
#endif 

  
  
  // Do Silence Decoding
  
  delayi[0] = (float) (DMIN);
  delayi[1] = (float) (DMIN);
  delayi[2] = (float) (DMIN);
  
  idxcbg=data_packet.SILENCE_GAIN;

  foutP = outFbuf;
  
  for (i=0; i<NoOfSubFrames; i++) {
    
    if (i < 2) subframesize = SubFrameSize - 1;
    else subframesize = SubFrameSize;

    if (lastrateD != 1 && i == 0 && decode_fcnt == 0) j = 0; /* Reset seed */
    else j = 1;
    
    GetExc800bps_dec(PitchMemoryD + ACBMemSize, subframesize, idxcbg, j, i);
    
    for (j = 0; j < ACBMemSize; j++)
      PitchMemoryD[j] = PitchMemoryD[j + subframesize];
    for (j = 0; j < ACBMemSize; j++)
      PitchPreFiltMemoryD[j] = PitchMemoryD[j];
    
   
    #ifdef QRES
       for(j=0;j<subframesize;j++)
         printf("%f\n",PitchMemoryD[j+ACBMemSize]);
    #endif 
    
    /* Linear interpolation of lsp */
    Interpol(lspi, OldlspD, lsp, i, ORDER);
    
    /* Convert lsp to PC */
    lsp2a(pci, lspi);
    
    /* Synthesis of decoder output signal and postfilter output signal */
    SynthesisFilter(DECspeech, PitchMemoryD + ACBMemSize, pci, SynMemory,
		    ORDER, subframesize);
    if (post_filter) {
	Post_Filter(DECspeech, lspi, pci, DECspeechPF, 
		    (delayi[0]+delayi[1])/2.0, 0.0, 0.0, 
		    subframesize);
    }
    else V_copy(DECspeech, DECspeechPF, subframesize);

    /* Write decoder output and variables to files */
    for (j = 0; j < subframesize; j++) {
      if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
      else {
	if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
	else *foutP++ = DECspeechPF[j];
      }
    }
  }
}

void FGV_MEM::silence_erasure_decoder(float *outFbuf,short post_filter)
{
  register int i, j;
  register float *foutP;
  float   delayi[3];
  short   subframesize;
  
  delayi[0] = (float) (DMIN);
  delayi[1] = (float) (DMIN);
  delayi[2] = (float) (DMIN);
  
  foutP = outFbuf;

  //static long silence_erasure_seed=0;
  int N=SubFrameSize;
  double G0,G1,G2,Gain;
  for (i=0,G2=1;i<N;i++) G2+=SQR(PitchMemoryD[ACBMemSize-i]);
  G2=sqrt(G2/N);
  for (i=0,G1=1;i<N-1;i++) G1+=SQR(PitchMemoryD[ACBMemSize-N-i]);
  G1=sqrt(G1/(N-1));
  for (i=0,G0=1;i<ACBMemSize-(2*N-1);i++) G0+=SQR(PitchMemoryD[i]);
  G0=sqrt(G0/(ACBMemSize-(2*N-1)));
  Gain=pow(10.,(log10(G0)+log10(G1)+log10(G2))/3.);
  
  /* Convert lsp to PC */
  lsp2a(pci, OldlspD);
    
  for (i=0; i<NoOfSubFrames; i++) {
    
    if (i < 2) subframesize = SubFrameSize - 1;
    else subframesize = SubFrameSize;

    Interpol(lspi, OldlspD, OldlspD, i, ORDER);

    for (j=0;j<subframesize;j++) PitchMemoryD[j+ACBMemSize]=Gain*ran_g(&silence_erasure_seed);
   
    
    for (j = 0; j < ACBMemSize; j++)
      PitchMemoryD[j] = PitchMemoryD[j + subframesize];
    
    
    /* Synthesis of decoder output signal and postfilter output signal */
    SynthesisFilter(DECspeech, PitchMemoryD + ACBMemSize, pci, SynMemory,
		    ORDER, subframesize);
    if (post_filter) {
	Post_Filter(DECspeech, lspi, pci, DECspeechPF, 
		    (delayi[0]+delayi[1])/2.0, 0.0, 0.0, 
		    subframesize);
    }
    else V_copy(DECspeech, DECspeechPF, subframesize);

    /* Write decoder output and variables to files */
    for (j = 0; j < subframesize; j++) {
      if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
      else {
	if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
	else *foutP++ = DECspeechPF[j];
      }
    }
  }
}

/*======================================================================*/
/*  Lucent Technologies Network Wireless Systems                        */
/*  EVRC Floating-point C Simulation.                                   */
/*                                                                      */
/*  Copyright (C) 1996 Lucent Technologies Incorporated. All rights     */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/
/*  Module:     getext1k.c                                              */
/*----------------------------------------------------------------------*/
/*  History:                                                            */
/*     12/01/94  Written By Dror Nahumi, AT&T                           */
/*----------------------------------------------------------------------*/

/****************************************************************************
* Routine name: GetExc800bps.                                               *
* Function: Energy quantization of the residual signal.                     *
* Inputs: input - signal array.                                             *
*         length - size of signal array.                                    *
* Output: output - quantized signal.                                        *
****************************************************************************/

#define IA 16807
#define IM 2147483647
#define AM (1.0/IM)
#define IQ 127773
#define IR 2836
#define MASK1 23148373

float ran0(long *seed0)
{
  long    k;
  float   ans;
  
  *seed0 ^= MASK1;
  k = (*seed0) / IQ;
  *seed0 = IA * (*seed0 - k * IQ) - IR * k;
  if (*seed0 < 0) *seed0 += IM;
  ans = AM * (*seed0);
  *seed0 ^= MASK1;
  return (ans);
}

float FGV_MEM::ran_g(long *seed0)
{
  //static int iset = 0;
  //static float gset;
  float   fac, rsq, v1, v2;
  
  if (iset == 0) {
    do {
      v1 = 2.0 * ran0(seed0) - 1.0;
      v2 = 2.0 * ran0(seed0) - 1.0;
      rsq = v1 * v1 + v2 * v2;
    }
    while (rsq >= 1.0 || rsq == 0.0);
    fac = sqrt(-2.0 * log(rsq) / rsq);
    gset = v1 * fac;
    iset = 1;
    return (v2 * fac);
  }
  else {
    iset = 0;
    return (gset);
  }
}

    #define	MAX_LOG_ENERGY	(2.6)		/* set to about 2.1 for is-127 equivalent */
    #define	MIN_LOG_ENERGY	(0.2)
    #define   LOG_ZERO_ENERGY	(-2.0)

void FGV_MEM::GetExc800bps(float *output,short *best,float scale,float *input,
		  short length,short flag,short n)
{
  short   i, j;
  float   sum, tmp, D, *ptr;
  //static long GetExc800bps_Seed;
  //static float GetExc800bps_Sum[NoOfSubFrames];

	float maxSFEnergy, maxSFEnergyQ;
	//static float maxSFEnergyQLast;
  
  if (!flag) GetExc800bps_Seed = 1234;


	/* Get energy of next sub frame */
	for (i = 0, sum = 0; i < length; i++)
		sum += fabs(input[i]);

	sum = sum / (float) SubFrameSize;
	if (sum < 1)
		sum = 1;

	sum = log10(sum / scale);	/*...fix for noise puffs...*/

	GetExc800bps_Sum[n] = sum;

	/* Quantize if last frame */
	if (n == NoOfSubFrames - 1)
	{
		maxSFEnergy = GetExc800bps_Sum[0];
		for (j = 1; j < 3; j++)
			if (GetExc800bps_Sum[j] > maxSFEnergy)
				maxSFEnergy = GetExc800bps_Sum[j];

		/* Quantize to 8 bits */
		for (i = 0, sum = 1e30; i < NUM_Q_LEVELS; i++)
		{
			D = maxSFEnergy - (MIN_LOG_ENERGY + (float)i * (MAX_LOG_ENERGY - MIN_LOG_ENERGY)/NUM_Q_LEVELS) ;
			tmp = D * D;
			if (tmp < sum)
			{
				sum = tmp;
				*best = i;
			}
		}

		maxSFEnergyQ = MIN_LOG_ENERGY + *best * (MAX_LOG_ENERGY - MIN_LOG_ENERGY)/NUM_Q_LEVELS ;

		if (*best == 0)
			maxSFEnergyQ = LOG_ZERO_ENERGY;
		//fprintf (stderr, "\r   best = %d, maxSFEnergyQ = %4.2f\n", (int)*best, maxSFEnergyQ);

		/* Interpolate only if last frame was eighth rate */
		if (LAST_PACKET_RATE_E != 1)
			maxSFEnergyQLast = maxSFEnergyQ;

		/* Interpolate using quantized max energy as endpoint */
		GetExc800bps_Sum[0] = 0.667*maxSFEnergyQLast + 0.333*maxSFEnergyQ;
		GetExc800bps_Sum[1] = 0.333*maxSFEnergyQLast + 0.667*maxSFEnergyQ;
		GetExc800bps_Sum[2] = maxSFEnergyQ;
		maxSFEnergyQLast = maxSFEnergyQ;


    /* Convert to linear domain */
    for (j = 0; j < 3; j++) GetExc800bps_Sum[j] = pow(10.0, double(GetExc800bps_Sum[j]));
    
    /* Get excitation */
    j = FrameSize - ACBMemSize;
    for (i = 0; i < FrameSize - 1; i++) {
      tmp = ran_g(&GetExc800bps_Seed);
      if (i >= j) output[i - j] = GetExc800bps_Sum[i / (length - 1)] * tmp;
    }
    output[i - j] = GetExc800bps_Sum[2] * ran_g(&GetExc800bps_Seed);	/* last excitation */
  }

}

void FGV_MEM::GetExc800bps_dec(float *output,short length,short best,short flag,short n)
{
  short   i, j;
  float   sum;
  //static long GetExc800bps_dec_Seed;
  //static float GetExc800bps_dec_Sum[NoOfSubFrames];
  //static short PrevBest = 0;

        int fer_flag = 0;  // This was passed in
	float maxSFEnergyQ;
	//static float maxSFEnergyQLast;

  if (!flag && !n) GetExc800bps_dec_Seed = 1234;
  
  if (n == 0) {

		/* De-quantize */
		if (fer_flag == 0)
		{
  			//best /= 2;
			maxSFEnergyQ = MIN_LOG_ENERGY + (float)best * (MAX_LOG_ENERGY - MIN_LOG_ENERGY)/NUM_Q_LEVELS ;

			if (best == 0)
				maxSFEnergyQ = LOG_ZERO_ENERGY;
			//fprintf (stderr, "\r   best = %d, maxSFEnergyQ = %4.2f\n", (int)best, maxSFEnergyQ);

			/* Interpolate only if last frame was eighth rate */
			if (LAST_PACKET_RATE_D != 1)
				maxSFEnergyQLast_dec = maxSFEnergyQ;

			/* Interpolate using quantized max energy as endpoint */
			GetExc800bps_dec_Sum[0] = 0.667*maxSFEnergyQLast_dec + 0.333*maxSFEnergyQ;
			GetExc800bps_dec_Sum[1] = 0.333*maxSFEnergyQLast_dec + 0.667*maxSFEnergyQ;
			GetExc800bps_dec_Sum[2] = maxSFEnergyQ;
			maxSFEnergyQLast_dec = maxSFEnergyQ;
			PrevBest = best;
		}
		else
		{
			for (j = 0; j < 3; j++)
				GetExc800bps_dec_Sum[j] = MIN_LOG_ENERGY + (float)PrevBest * (MAX_LOG_ENERGY - MIN_LOG_ENERGY)/NUM_Q_LEVELS;
		}


  }
  
  /* Convert to linear domain */
  sum = pow(10.0, double(GetExc800bps_dec_Sum[n]));
  
  for (i = 0; i < length; i++) {
    //output[i] = 0.707 * sum * ran_g(&GetExc800bps_dec_Seed);
    output[i] = 0.656 * sum * ran_g(&GetExc800bps_dec_Seed);
  }
  //Note : The above reduction by 0.656 is done to compensate for the difference in energy between the FL and FX random number generators, this ensures the FL and FX decoders match in terms of energy of eighth-rate frames for the same packet input
  
}
