/**********************************************************************
Each of the companies; Qualcomm, Motorola, Lucent, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-WB Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-WB be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-WB or the field of use of practice of the 
EVRC-WB Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

float CBLSF[1536] =
    { 0.101072668, 0.157123633, 0.207020633, 0.259296347, 0.341237588,
0.400707424,
    0.093761647, 0.140459649, 0.259326268, 0.355328371, 0.397898658,
	0.449644864,
    0.073476585, 0.196193641, 0.276471394, 0.322521922, 0.376918376,
	0.418103059,
    0.049482656, 0.110047717, 0.231352718, 0.300727721, 0.357468687,
	0.452141845,
    0.078533399, 0.182991420, 0.286030399, 0.337189641, 0.390846661,
	0.429111966,
    0.084288235, 0.178290460, 0.230499648, 0.274420842, 0.322987450,
	0.414816828,
    0.106791041, 0.234994979, 0.310230067, 0.346678300, 0.383982945,
	0.422280240,
    0.088436370, 0.179402317, 0.241141225, 0.290668811, 0.350479397,
	0.395189204,
    0.095614210, 0.147469151, 0.206180772, 0.264872977, 0.319291236,
	0.436276803,
    0.118925921, 0.240949761, 0.298684013, 0.343857278, 0.394246052,
	0.440646243,
    0.082671587, 0.159135160, 0.227952691, 0.276875647, 0.351108378,
	0.406990861,
    0.085140287, 0.158946243, 0.212740821, 0.289792663, 0.354248505,
	0.399605594,
    0.074251845, 0.138915639, 0.214998275, 0.283001362, 0.343833405,
	0.390776951,
    0.072636852, 0.116223295, 0.163654731, 0.235880517, 0.385662030,
	0.464248125,
    0.057907046, 0.158687298, 0.287592027, 0.332619825, 0.394662719,
	0.443715387,
    0.089319123, 0.134452425, 0.201173440, 0.283579731, 0.357306508,
	0.450452893,
    0.100426546, 0.251370272, 0.321942598, 0.359804922, 0.399477634,
	0.439156394,
    0.078941170, 0.142261123, 0.213054674, 0.280567565, 0.355766206,
	0.416583607,
    0.063453548, 0.104282902, 0.154418747, 0.218504776, 0.336149405,
	0.442524590,
    0.081340113, 0.223358525, 0.293585325, 0.330925939, 0.370726293,
	0.412256821,
    0.072885484, 0.159146842, 0.249628799, 0.321844081, 0.374741136,
	0.412271781,
    0.070100829, 0.201960620, 0.269207244, 0.317507109, 0.396418835,
	0.442967995,
    0.078411964, 0.137455694, 0.219673451, 0.307397428, 0.386513350,
	0.459476819,
    0.108362219, 0.171746646, 0.231091704, 0.293124890, 0.368294724,
	0.410645377,
    0.130749192, 0.235607248, 0.289925716, 0.332193449, 0.378004926,
	0.422904127,
    0.078386945, 0.145187251, 0.244776801, 0.311173697, 0.382624080,
	0.435718965,
    0.088331710, 0.162881556, 0.238950139, 0.284362773, 0.367559906,
	0.436142476,
    0.065012900, 0.127961832, 0.210180177, 0.263062272, 0.318932819,
	0.377351914,
    0.123310894, 0.177326618, 0.233572771, 0.288288330, 0.343253445,
	0.390005368,
    0.161229369, 0.220110491, 0.297568337, 0.367150878, 0.409420202,
	0.450790302,
    0.069839751, 0.141882812, 0.203676151, 0.333047156, 0.409863290,
	0.450466899,
    0.076550822, 0.196857158, 0.290147101, 0.360052726, 0.418277175,
	0.462159694,
    0.154417489, 0.208944021, 0.252772586, 0.301648433, 0.385874661,
	0.436886048,
    0.083924598, 0.134542188, 0.190757863, 0.275289350, 0.356224413,
	0.397364534,
    0.072744186, 0.146261722, 0.236129754, 0.290964202, 0.337446199,
	0.439743675,
    0.114483238, 0.202222271, 0.254574857, 0.298908899, 0.343542311,
	0.390951385,
    0.086641675, 0.227484935, 0.282881837, 0.343912346, 0.405177768,
	0.447384227,
    0.050220531, 0.118629145, 0.262311697, 0.335408538, 0.378737517,
	0.418372986,
    0.062347166, 0.109959736, 0.168464711, 0.230082503, 0.304299477,
	0.378410931,
    0.078077993, 0.150914059, 0.214718639, 0.256476281, 0.321559512,
	0.402820047,
    0.136777121, 0.216126842, 0.270033417, 0.328370229, 0.383247490,
	0.427797028,
    0.089371867, 0.191477880, 0.243011932, 0.325759929, 0.378949511,
	0.438065386,
    0.083623413, 0.154169637, 0.233999783, 0.352112009, 0.411861162,
	0.450722502,
    0.051472173, 0.092297580, 0.183635997, 0.335299676, 0.407900432,
	0.455643254,
    0.073781287, 0.133813847, 0.190536478, 0.313812963, 0.390880084,
	0.435105900,
    0.120765052, 0.191580375, 0.233046127, 0.273253758, 0.318004150,
	0.436378026,
    0.056214354, 0.142336435, 0.275683736, 0.323575687, 0.365079158,
	0.406130788,
    0.054052504, 0.121037557, 0.203240226, 0.256518934, 0.355589863,
	0.414392203,
    0.094273027, 0.143842742, 0.209155060, 0.309097202, 0.372915788,
	0.411184276,
    0.051351024, 0.116294199, 0.240747475, 0.320202398, 0.396649451,
	0.460625918,
    0.116463412, 0.165862369, 0.212521028, 0.269537490, 0.401505268,
	0.467526081,
    0.070355111, 0.117239722, 0.173870568, 0.244020974, 0.366144382,
	0.417312855,
    0.164325251, 0.226322626, 0.271911446, 0.319494158, 0.374018095,
	0.417613181,
    0.073108826, 0.156991072, 0.227210393, 0.323717016, 0.399854354,
	0.436889391,
    0.138581907, 0.206336426, 0.247522701, 0.290799795, 0.337515431,
	0.435020275,
    0.092884989, 0.139796927, 0.188419717, 0.240416433, 0.350227933,
	0.454366513,
    0.084413283, 0.150154906, 0.234691789, 0.298255249, 0.345752973,
	0.394739750,
    0.072189308, 0.122376273, 0.276707898, 0.357974481, 0.399859128,
	0.450552683,
    0.168498771, 0.247268690, 0.295205841, 0.337729336, 0.383397096,
	0.425302115,
    0.119744503, 0.168134306, 0.239711854, 0.290098081, 0.342261432,
	0.444772017,
    0.068510187, 0.134375537, 0.209982188, 0.278359608, 0.346138446,
	0.410493066,
    0.073698192, 0.144625195, 0.222432243, 0.290943830, 0.348895965,
	0.414365624,
    0.099305284, 0.225543722, 0.278115942, 0.325494936, 0.387687117,
	0.428016343,
    0.100934585, 0.200226309, 0.250110561, 0.308723506, 0.362756451,
	0.408897060,
    0.138541020, 0.191465466, 0.241585904, 0.291621671, 0.366010055,
	0.414774175,
    0.073407034, 0.189380377, 0.307125909, 0.348213031, 0.385170719,
	0.418146190,
    0.085142977, 0.153792552, 0.241948618, 0.300042718, 0.370683162,
	0.421115385,
    0.103873333, 0.149883690, 0.247817934, 0.330997559, 0.390684960,
	0.453420337,
    0.130843857, 0.177544024, 0.223478846, 0.267409907, 0.358928933,
	0.415120655,
    0.109175644, 0.192286387, 0.247613738, 0.299184555, 0.362120467,
	0.447314835,
    0.098659672, 0.155999458, 0.199225861, 0.239302826, 0.300313441,
	0.419094754,
    0.089166016, 0.152964405, 0.258273618, 0.338869681, 0.386974581,
	0.425933801,
    0.082555165, 0.155152976, 0.263297025, 0.315463877, 0.377908956,
	0.457985060,
    0.091082114, 0.167181286, 0.212182346, 0.286088490, 0.339444230,
	0.445773101,
    0.075879220, 0.122050435, 0.181110049, 0.265878996, 0.348836759,
	0.442482095,
    0.075331393, 0.158512291, 0.209782926, 0.285865674, 0.415754728,
	0.472811298,
    0.109680531, 0.209272357, 0.261348491, 0.312893843, 0.392876842,
	0.450242490,
    0.076030799, 0.146015748, 0.213780898, 0.286148014, 0.352738920,
	0.435862682,
    0.120875314, 0.174980833, 0.223048013, 0.266059000, 0.361665125,
	0.452676129,
    0.057726803, 0.116463810, 0.201168028, 0.264094710, 0.404413665,
	0.472865729,
    0.089859454, 0.136504250, 0.217357269, 0.279810783, 0.398130546,
	0.467002302,
    0.111244944, 0.200099940, 0.306394433, 0.364991463, 0.403837843,
	0.446431207,
    0.059139367, 0.113505693, 0.229008525, 0.327717694, 0.370616477,
	0.444798914,
    0.066708537, 0.132682495, 0.210945235, 0.292376384, 0.368549690,
	0.451579710,
    0.078704841, 0.168829335, 0.267512244, 0.343798232, 0.383247809,
	0.447346984,
    0.144355316, 0.190664916, 0.233166925, 0.278875588, 0.373779522,
	0.450954550,
    0.088520133, 0.129004917, 0.217252545, 0.349652906, 0.410571688,
	0.457633646,
    0.073866499, 0.128793671, 0.271388781, 0.335262434, 0.381535301,
	0.451519231,
    0.072224259, 0.146829284, 0.228501298, 0.279855187, 0.328531453,
	0.394503405,
    0.072649823, 0.205860553, 0.292065873, 0.329476515, 0.398246570,
	0.457893387,
    0.071819002, 0.229246939, 0.310429329, 0.349750945, 0.409146297,
	0.460269729,
    0.072739427, 0.125230080, 0.180181698, 0.290759051, 0.419436778,
	0.471558589,
    0.143170885, 0.201643742, 0.245327955, 0.284427550, 0.327933508,
	0.377510273,
    0.076432443, 0.130896108, 0.216954130, 0.305715956, 0.355607051,
	0.399505009,
    0.102858529, 0.163293927, 0.216198462, 0.271482682, 0.358572585,
	0.426861674,
    0.074999236, 0.183584590, 0.243240478, 0.292972738, 0.373775225,
	0.420022468,
    0.082466850, 0.166186090, 0.285498026, 0.335248428, 0.373235053,
	0.410579487,
    0.074077172, 0.137329501, 0.205042178, 0.267958037, 0.336932924,
	0.402130588,
    0.052237613, 0.124474460, 0.253094398, 0.310433308, 0.356666227,
	0.402144275,
    0.078435264, 0.152000658, 0.257990322, 0.317269013, 0.356360173,
	0.395944712,
    0.065392405, 0.142145545, 0.226494673, 0.319129852, 0.383015283,
	0.421625954,
    0.094327777, 0.176066906, 0.259803097, 0.305636378, 0.381020594,
	0.430545156,
    0.074594458, 0.141816906, 0.199065910, 0.272153839, 0.345180015,
	0.423141587,
    0.079146671, 0.183594299, 0.280984232, 0.321725192, 0.359333664,
	0.396554594,
    0.054027660, 0.134775366, 0.253672607, 0.298482204, 0.377658287,
	0.427719838,
    0.078779310, 0.162933281, 0.215470169, 0.288763248, 0.383808671,
	0.427143856,
    0.063211426, 0.128848691, 0.210534774, 0.286805802, 0.354908520,
	0.427612886,
    0.077926080, 0.165074393, 0.257269987, 0.313734182, 0.353470078,
	0.434974597,
    0.117127804, 0.181823382, 0.231257384, 0.294017271, 0.388247661,
	0.434042268,
    0.089575299, 0.157503695, 0.217829641, 0.340324516, 0.427900479,
	0.468872691,
    0.087861391, 0.165069777, 0.235729957, 0.307970863, 0.377785293,
	0.448579639,
    0.087223466, 0.160683785, 0.290701278, 0.345407925, 0.399756473,
	0.462066429,
    0.068005905, 0.189319898, 0.283658672, 0.327838811, 0.371952582,
	0.445880213,
    0.055766444, 0.140599259, 0.294571608, 0.349159525, 0.412268917,
	0.467192492,
    0.092477935, 0.176573497, 0.230854563, 0.312113666, 0.360839270,
	0.433924334,
    0.104387483, 0.161962277, 0.211476812, 0.310850612, 0.401418369,
	0.449388942,
    0.077526219, 0.145985158, 0.213570018, 0.277078570, 0.341202892,
	0.410123826,
    0.150077302, 0.209619952, 0.257692702, 0.308608437, 0.362139884,
	0.403833864,
    0.092366001, 0.138915655, 0.215359079, 0.336090199, 0.392623149,
	0.433228031,
    0.087176436, 0.188989333, 0.238585037, 0.335223759, 0.416156276,
	0.457203609,
    0.074543257, 0.130920235, 0.188307672, 0.239460389, 0.300742682,
	0.370850593,
    0.060062163, 0.135216655, 0.238288532, 0.351198619, 0.424536421,
	0.468470665,
    0.080162159, 0.208181350, 0.270097716, 0.313197352, 0.361476526,
	0.440596428,
    0.073873740, 0.117233929, 0.214283351, 0.342852852, 0.389371136,
	0.450972375,
    0.157220272, 0.228485860, 0.278541204, 0.331770893, 0.396151136,
	0.446993820,
    0.133105353, 0.186028574, 0.249903023, 0.341708687, 0.401619382,
	0.449227718,
    0.078769521, 0.176402087, 0.235791390, 0.277253959, 0.348541368,
	0.454652674,
    0.070195224, 0.149061703, 0.236054792, 0.331508446, 0.384831400,
	0.451696371,
    0.097088637, 0.228607932, 0.285621848, 0.324243342, 0.373159773,
	0.446908035,
    0.072559280, 0.148800450, 0.196933552, 0.267738403, 0.360898794,
	0.452557240,
    0.049781820, 0.111843494, 0.280996328, 0.371222379, 0.411901110,
	0.454524236,
    0.095837839, 0.145945433, 0.226599078, 0.269038858, 0.362893324,
	0.455898698,
    0.098207815, 0.148972130, 0.197890232, 0.261646748, 0.375476909,
	0.424252488,
    0.079331307, 0.122896932, 0.187982996, 0.283016959, 0.388190206,
	0.458351116,
    0.083161338, 0.157371692, 0.224145546, 0.292573099, 0.358505899,
	0.422239974,
    0.086674509, 0.162875190, 0.259112046, 0.367802458, 0.423685737,
	0.464632166,
    0.076175503, 0.150438202, 0.221234443, 0.290745842, 0.369048960,
	0.452166196,
    0.078075701, 0.167539066, 0.255090519, 0.328192931, 0.397542787,
	0.440121828,
    0.086171372, 0.165481511, 0.235688895, 0.316531489, 0.383300807,
	0.424158428,
    0.108507766, 0.173245567, 0.218079037, 0.258540839, 0.315423293,
	0.438153717,
    0.052753243, 0.159283699, 0.294206188, 0.335127152, 0.377926463,
	0.415110469,
    0.092365189, 0.139143374, 0.187717207, 0.251697495, 0.397575573,
	0.467625393,
    0.117792595, 0.165499018, 0.241221916, 0.325212595, 0.377929646,
	0.427831405,
    0.083974732, 0.199792134, 0.251588792, 0.293149559, 0.338943210,
	0.432991845,
    0.055852037, 0.146871906, 0.269020874, 0.317062589, 0.399684535,
	0.463724824,
    0.116854376, 0.217928158, 0.279262812, 0.320281338, 0.362592362,
	0.404099812,
    0.092149646, 0.161524601, 0.228006645, 0.281836507, 0.336136672,
	0.383371472,
    0.067983893, 0.109997472, 0.174963804, 0.294379508, 0.389237605,
	0.435032848,
    0.053838664, 0.108072350, 0.196906336, 0.276270700, 0.361649210,
	0.450000575,
    0.063363291, 0.112256183, 0.192096515, 0.291845443, 0.360699055,
	0.404226340,
    0.078781554, 0.159261577, 0.251859833, 0.330697075, 0.369153843,
	0.437311947,
    0.112441821, 0.176306912, 0.225326475, 0.265789232, 0.312774159,
	0.379699131,
    0.116167018, 0.194206432, 0.282347713, 0.334150896, 0.376585105,
	0.419165578,
    0.095215989, 0.142201090, 0.198317882, 0.309139538, 0.413692717,
	0.463303382,
    0.065852697, 0.173361591, 0.261628763, 0.300177204, 0.366134514,
	0.444733024,
    0.073633273, 0.128161905, 0.179016525, 0.252129123, 0.388923433,
	0.442703480,
    0.061768129, 0.139256644, 0.225438998, 0.301955124, 0.394554653,
	0.443969876,
    0.054847722, 0.100500140, 0.172130050, 0.256160199, 0.335641541,
	0.397480876,
    0.070474891, 0.146958009, 0.198233689, 0.284563786, 0.400950772,
	0.453628671,
    0.057149437, 0.110786976, 0.206520727, 0.299393685, 0.390506706,
	0.456809542,
    0.076516349, 0.155680495, 0.214265684, 0.253293978, 0.330530917,
	0.449937231,
    0.084954537, 0.173975292, 0.260664921, 0.303139237, 0.342841392,
	0.386203953,
    0.140914434, 0.192664698, 0.258259930, 0.318036617, 0.374760871,
	0.422363319,
    0.071650760, 0.134672600, 0.249877717, 0.294783921, 0.371261691,
	0.456899623,
    0.074021070, 0.146720979, 0.231364337, 0.311958490, 0.360805052,
	0.418260941,
    0.121871640, 0.213353567, 0.269256582, 0.351557035, 0.414317718,
	0.456389054,
    0.047740244, 0.091269201, 0.186290065, 0.304540278, 0.369135381,
	0.423273049,
    0.110020900, 0.166601803, 0.288736670, 0.350130211, 0.391620314,
	0.429072655,
    0.089236267, 0.228325591, 0.330294890, 0.379098798, 0.418636388,
	0.458605923,
    0.105569622, 0.185331952, 0.232421444, 0.291129882, 0.341113925,
	0.427198764,
    0.065607567, 0.155128068, 0.272308219, 0.319613524, 0.384494469,
	0.428101173,
    0.077528718, 0.156355837, 0.230935732, 0.313016074, 0.406936589,
	0.460890911,
    0.082068390, 0.160250088, 0.299218773, 0.360915346, 0.398297500,
	0.436251498,
    0.103823072, 0.155134435, 0.224034456, 0.285210910, 0.332600886,
	0.408310097,
    0.086775827, 0.134826980, 0.186331127, 0.249069051, 0.337710874,
	0.413881952,
    0.050978649, 0.105514809, 0.216333585, 0.332466878, 0.391584822,
	0.432170606,
    0.082208796, 0.164849029, 0.241424839, 0.296490698, 0.345194498,
	0.418522114,
    0.083647143, 0.182012458, 0.271624489, 0.322483725, 0.411178387,
	0.466963945,
    0.066112550, 0.124255256, 0.216208330, 0.311098576, 0.416253520,
	0.470381320,
    0.071520650, 0.144022698, 0.217928795, 0.291523154, 0.369692900,
	0.408109084,
    0.076007913, 0.126456815, 0.265827748, 0.375039711, 0.421584415,
	0.460902211,
    0.065718577, 0.118881246, 0.191263816, 0.269797072, 0.338294813,
	0.403436931,
    0.074600330, 0.119196516, 0.208008349, 0.315301380, 0.380788706,
	0.421762827,
    0.059394794, 0.112343320, 0.229275269, 0.355557395, 0.409302109,
	0.451969162,
    0.052400349, 0.109153028, 0.218148428, 0.291976268, 0.342088271,
	0.402203640,
    0.073366943, 0.184752947, 0.245475969, 0.296734365, 0.393975807,
	0.445324762,
    0.103605937, 0.201268137, 0.256437606, 0.336592174, 0.392072154,
	0.433600772,
    0.111030117, 0.159247412, 0.204181946, 0.249362055, 0.351178883,
	0.450786323,
    0.056036991, 0.119498051, 0.222690233, 0.311227969, 0.371216968,
	0.409965149,
    0.085433960, 0.154621972, 0.211983403, 0.318623581, 0.374075391,
	0.441102540,
    0.087512746, 0.153351629, 0.219273017, 0.269697282, 0.321370754,
	0.375127246,
    0.065287379, 0.142929829, 0.234848557, 0.285445027, 0.397208721,
	0.468143283,
    0.084654275, 0.172056043, 0.218157819, 0.278656591, 0.384390382,
	0.454691508,
    0.092727872, 0.180170558, 0.245576396, 0.284658961, 0.325312226,
	0.375287356,
    0.072529168, 0.176777852, 0.262531012, 0.303704396, 0.358978590,
	0.408569201,
    0.078514476, 0.140283973, 0.251209844, 0.334717488, 0.408346702,
	0.463249269,
    0.069642447, 0.119993851, 0.196230724, 0.355645885, 0.427295849,
	0.465207830,
    0.068089143, 0.140241654, 0.284760979, 0.346218979, 0.385454174,
	0.423457509,
    0.098915386, 0.183429892, 0.232474920, 0.292828861, 0.405580589,
	0.465919730,
    0.105949653, 0.209589712, 0.259229184, 0.306604518, 0.377871077,
	0.420802327,
    0.076400898, 0.141239269, 0.221703632, 0.294479298, 0.370153972,
	0.428955198,
    0.054877547, 0.136057216, 0.267004858, 0.320310305, 0.368246023,
	0.446094753,
    0.061167080, 0.185046428, 0.300614562, 0.347578321, 0.396440480,
	0.445412615,
    0.100900255, 0.148685269, 0.224818453, 0.302776523, 0.352558279,
	0.439524837,
    0.087525606, 0.129701904, 0.218511620, 0.325068878, 0.369765634,
	0.445386991,
    0.094071999, 0.173362546, 0.262943542, 0.321524020, 0.371942556,
	0.415330103,
    0.092991002, 0.143490866, 0.222951725, 0.294191387, 0.391747956,
	0.437009075,
    0.125445305, 0.241909784, 0.302061917, 0.360945267, 0.414090127,
	0.458125276,
    0.065146304, 0.159137611, 0.308173467, 0.370799346, 0.410787980,
	0.453415881,
    0.096462315, 0.176934460, 0.278262364, 0.324535868, 0.384977027,
	0.443685466,
    0.100342624, 0.152498160, 0.247936822, 0.296046179, 0.391390016,
	0.461651035,
    0.079092861, 0.207471042, 0.315620327, 0.360248646, 0.398897832,
	0.436712729,
    0.102609866, 0.202186461, 0.292987221, 0.341071430, 0.389902554,
	0.444617955,
    0.108143572, 0.183886985, 0.303702009, 0.380620320, 0.419745698,
	0.459776826,
    0.091914462, 0.151496773, 0.207451466, 0.253360982, 0.304735084,
	0.362375434,
    0.071330365, 0.145239883, 0.215172231, 0.258329322, 0.387473531,
	0.464916576,
    0.065713373, 0.119938067, 0.184513259, 0.247507422, 0.321306137,
	0.390806236,
    0.070513438, 0.126416628, 0.240170539, 0.310775332, 0.352348990,
	0.439212894,
    0.077790941, 0.130170011, 0.249995492, 0.329985811, 0.372053805,
	0.414975187,
    0.149570219, 0.205112684, 0.289669158, 0.347677634, 0.390368878,
	0.433329254,
    0.061353944, 0.155916538, 0.263039990, 0.352020972, 0.405073522,
	0.449107238,
    0.128937499, 0.219314557, 0.265310335, 0.309690850, 0.355814589,
	0.435145212,
    0.082458431, 0.138948584, 0.196442400, 0.252874764, 0.323543537,
	0.383945226,
    0.089297780, 0.179077322, 0.269695850, 0.354247709, 0.406102140,
	0.446740127,
    0.065778436, 0.122438391, 0.196316190, 0.243549876, 0.368724124,
	0.460874200,
    0.079415181, 0.153412521, 0.225724363, 0.272645627, 0.338143616,
	0.431498494,
    0.101908852, 0.172674996, 0.232492268, 0.339111437, 0.398364823,
	0.440746829,
    0.082066241, 0.129910334, 0.188038223, 0.286193851, 0.373058232,
	0.420814423,
    0.057505036, 0.098395299, 0.163582315, 0.279151086, 0.396493160,
	0.458217585,
    0.078059245, 0.125606800, 0.230059425, 0.323141353, 0.400632462,
	0.444256514,
    0.060214777, 0.139904691, 0.235770859, 0.278747946, 0.365825913,
	0.428544260,
    0.071617433, 0.227146571, 0.299429494, 0.338626015, 0.389446098,
	0.433723162,
    0.065553486, 0.148732713, 0.242275681, 0.291804222, 0.358490780,
	0.403478471,
    0.167648247, 0.256143010, 0.311593707, 0.356840502, 0.397488834,
	0.438363006,
    0.088325232, 0.159131611, 0.238667479, 0.307748842, 0.362056646,
	0.404349526,
    0.063803052, 0.139680824, 0.245933698, 0.295368019, 0.338281922,
	0.382874749,
    0.112192585, 0.172654625, 0.257847719, 0.310903452, 0.356739120,
	0.405660963,
    0.069373173, 0.125810534, 0.194572011, 0.243165516, 0.316633666,
	0.438971933,
    0.084742431, 0.128216161, 0.207523244, 0.291223625, 0.335903829,
	0.424229411,
    0.062396664, 0.133314801, 0.248685010, 0.344324557, 0.394857207,
	0.432874071,
    0.048141283, 0.113206179, 0.271643429, 0.341352657, 0.389648861,
	0.453484317,
    0.057919317, 0.099266752, 0.172878078, 0.267001675, 0.344353842,
	0.436913105,
    0.072956053, 0.153269011, 0.233011590, 0.306085832, 0.362905738,
	0.442427187,
    0.064962432, 0.119981930, 0.211040728, 0.268827341, 0.327355139,
	0.425911997,
    0.102751704, 0.152396858, 0.202281476, 0.268376933, 0.386549000,
	0.452245774,
    0.048674738, 0.130888245, 0.297952377, 0.356104411, 0.396549979,
	0.432858633,
    0.066568783, 0.126131741, 0.222375584, 0.272036541, 0.351176655,
	0.454265609,
    0.071111384, 0.115587901, 0.194426862, 0.306318039, 0.355549278,
	0.442842263,
    0.083952721, 0.128317049, 0.173880277, 0.221600658, 0.320699120,
	0.436597500,
    0.090908221, 0.136774989, 0.193384715, 0.291682468, 0.393869650,
	0.442767619,
    0.082720145, 0.214417996, 0.271966991, 0.310116749, 0.350646033,
	0.404894154,
    0.079403849, 0.132194175, 0.210139274, 0.262939245, 0.372599229,
	0.436415268,
    0.154825754, 0.250887237, 0.329175076, 0.379728415, 0.413846779,
	0.452697296,
    0.067908693, 0.171027265, 0.313155494, 0.391521797, 0.429502691,
	0.465695958,
    0.059460287, 0.123740215, 0.211056962, 0.285098547, 0.384063796,
	0.428746387,
    0.072389525, 0.119535691, 0.185198103, 0.323187349, 0.407603130,
	0.452498671
};

float CBLSF2[48] =
    { 0.001977417, 0.003393335, -0.000464870, -0.004979333, -0.003424922,
-0.010018170,
    0.006179394, -0.002705284, 0.009647411, 0.006941702, 0.000981831,
	0.000361127,
    0.001875361, -0.001717716, -0.003814360, -0.002718826, -0.010472324,
	0.005537086,
    0.011276648, 0.007186766, -0.001790660, -0.003152923, 0.004325644,
	0.002620790,
    -0.007717248, -0.011387928, 0.003211882, 0.001738036, -0.001793067,
	-0.005031144,
    -0.001372088, -0.001395188, -0.011419448, 0.007253569, 0.003605959,
	-0.000695072,
    -0.009775601, 0.010293607, 0.004487340, 0.001631988, 0.000356837,
	0.001970473,
    -0.003047287, -0.006095407, -0.000109653, -0.007186197, 0.007296484,
	0.006055225
};

float CBLSF2_QR[96] =
    { -0.012088400, -0.003714705, 0.003645052, 0.000528269, 0.003684106,
-0.002276231,
    0.002742122, 0.000906215, 0.003297094, 0.007303168, 0.002160786,
	-0.009100204,
    0.003915091, 0.004865653, 0.005315127, -0.002259056, -0.007588955,
	-0.006923382,
    0.008202881, -0.002870740, -0.008786766, -0.001487815, -0.003881818,
	-0.004552713,
    0.009134147, 0.000550504, 0.001823550, 0.005401405, -0.001646423,
	0.006479293,
    -0.003379827, -0.005401638, -0.009329236, -0.004744557, 0.000657880,
	0.003154435,
    -0.003644339, 0.004356800, -0.002747244, -0.010424794, 0.002024507,
	-0.005212444,
    -0.002934321, 0.002186428, 0.000203895, -0.000400396, 0.005854016,
	0.009527752,
    -0.001364480, -0.001432739, 0.002253878, -0.005429219, -0.008033352,
	0.005768713,
    0.004080185, -0.007387291, 0.005679361, -0.005098269, 0.004532602,
	-0.001149948,
    0.008951151, 0.009222841, -0.001828724, -0.004034619, 0.001762407,
	0.000366082,
    0.002250219, -0.000123998, -0.005678063, 0.004382196, 0.009166492,
	-0.001152571,
    -0.005639799, 0.006668002, -0.003576313, 0.004301622, -0.005263470,
	0.000738296,
    -0.002427624, -0.009206576, 0.000685816, 0.007335913, -0.000823908,
	0.002769961,
    -0.005531546, -0.006135507, -0.000550000, -0.001369154, -0.006766765,
	-0.009839081,
    -0.001369138, 0.006327843, 0.009923740, 0.002819333, 0.001683312,
	0.001095662
};


float CBLSF_QR_RS1[384] =
    { 0.096377967, 0.183225408, 0.265024829, 0.332144431, 0.391855958,
0.439469769,
    0.070129660, 0.132912194, 0.206996537, 0.263162935, 0.319387093,
	0.374938349,
    0.099220887, 0.170117758, 0.238441015, 0.297250901, 0.360984891,
	0.407920380,
    0.077746740, 0.147937912, 0.227263740, 0.303827786, 0.376516237,
	0.422998876,
    0.121434494, 0.194133727, 0.248257659, 0.301444833, 0.365590147,
	0.421696056,
    0.079286045, 0.150125011, 0.227420264, 0.282527534, 0.332661399,
	0.382599116,
    0.086590654, 0.151023578, 0.209301851, 0.254897320, 0.306597627,
	0.366555417,
    0.088857124, 0.165033573, 0.242466626, 0.294748488, 0.339850210,
	0.385000509,
    0.072442674, 0.133093835, 0.216343774, 0.294081360, 0.363357552,
	0.411314889,
    0.098149243, 0.168733246, 0.236339417, 0.302979098, 0.373664019,
	0.428615878,
    0.064789496, 0.141795335, 0.245885183, 0.309686160, 0.364551295,
	0.413659363,
    0.067438629, 0.133586015, 0.221590010, 0.296256153, 0.363638671,
	0.436290754,
    0.070653035, 0.132846258, 0.209029023, 0.280670317, 0.351251480,
	0.427046448,
    0.082481277, 0.151911412, 0.222046715, 0.280279445, 0.360350476,
	0.447834682,
    0.108582752, 0.173350473, 0.224938856, 0.279865236, 0.349582674,
	0.423899914,
    0.070050558, 0.130205985, 0.219728013, 0.337151742, 0.412653373,
	0.459286954,
    0.068940379, 0.123223176, 0.175430730, 0.228567812, 0.292149624,
	0.361119810,
    0.085463898, 0.160275353, 0.243504204, 0.309722432, 0.367954172,
	0.414176922,
    0.084241056, 0.149561292, 0.229041386, 0.306341059, 0.360162974,
	0.429725906,
    0.088606454, 0.160140825, 0.228155600, 0.303018419, 0.374698746,
	0.441854740,
    0.066176819, 0.144069386, 0.268760223, 0.339415469, 0.389752200,
	0.440003590,
    0.105339789, 0.186848045, 0.246683599, 0.291633479, 0.339572204,
	0.398253612,
    0.076711692, 0.158486401, 0.238803877, 0.298230011, 0.365775918,
	0.432996404,
    0.084193708, 0.161223458, 0.232697590, 0.287257235, 0.341597835,
	0.412257850,
    0.074101393, 0.147523597, 0.236097231, 0.309892238, 0.375807911,
	0.446054398,
    0.079217059, 0.163924610, 0.279554092, 0.362341563, 0.413237852,
	0.458490120,
    0.084586665, 0.144615293, 0.200444508, 0.252143673, 0.322657267,
	0.386076885,
    0.075778043, 0.141236640, 0.210883726, 0.270793359, 0.337338902,
	0.386993682,
    0.084813758, 0.160512143, 0.242374195, 0.301817714, 0.353845725,
	0.399255093,
    0.077380489, 0.152900796, 0.232579276, 0.295522155, 0.360413462,
	0.414157391,
    0.055747671, 0.102767387, 0.163443442, 0.228791690, 0.300288609,
	0.372871751,
    0.077353088, 0.147621321, 0.218967484, 0.278131726, 0.341025173,
	0.406109753,
    0.092483997, 0.161282113, 0.225909772, 0.280694921, 0.344191500,
	0.392847021,
    0.087186483, 0.174848530, 0.245551288, 0.300533387, 0.354091576,
	0.425132112,
    0.109979498, 0.222862263, 0.296329082, 0.345556444, 0.392057144,
	0.437196310,
    0.079566427, 0.167786740, 0.269585995, 0.327772136, 0.373022019,
	0.418655553,
    0.073627253, 0.139145196, 0.209490781, 0.278430135, 0.347945637,
	0.410381373,
    0.087871854, 0.153998906, 0.221236337, 0.287585017, 0.358265625,
	0.407092972,
    0.074326091, 0.136600635, 0.203484019, 0.268029672, 0.337517793,
	0.406998330,
    0.056465803, 0.110662340, 0.190902254, 0.284308846, 0.371078719,
	0.434624570,
    0.097303201, 0.177156981, 0.253061241, 0.316411935, 0.373279668,
	0.417501785,
    0.065846787, 0.130056237, 0.214773813, 0.283229260, 0.342056708,
	0.400444127,
    0.091969209, 0.157079297, 0.212617588, 0.264032975, 0.331517929,
	0.402620388,
    0.076202604, 0.146243659, 0.228801115, 0.293476912, 0.348750494,
	0.395450000,
    0.087872172, 0.148469338, 0.211733994, 0.277419931, 0.349389722,
	0.421280512,
    0.069972518, 0.126512902, 0.189074545, 0.250692797, 0.325775048,
	0.391650027,
    0.079917516, 0.135597139, 0.187812055, 0.240015230, 0.310565843,
	0.374214099,
    0.079065468, 0.133604466, 0.190524624, 0.253905668, 0.357027779,
	0.440095840,
    0.056692067, 0.107106247, 0.178045580, 0.247203022, 0.323575523,
	0.392110490,
    0.085634608, 0.152938169, 0.219145325, 0.267718696, 0.320433846,
	0.374683368,
    0.088296672, 0.158868496, 0.226587957, 0.291889042, 0.356841367,
	0.426262277,
    0.074686134, 0.145674911, 0.221969700, 0.288069545, 0.350029288,
	0.418054558,
    0.070972865, 0.130515624, 0.197604436, 0.247288665, 0.301095957,
	0.363158057,
    0.080318345, 0.137854478, 0.206438948, 0.291546528, 0.393578263,
	0.454707563,
    0.097552904, 0.168829996, 0.231763187, 0.277037694, 0.323434154,
	0.378597241,
    0.060186409, 0.125222953, 0.226385397, 0.318193865, 0.386510858,
	0.436026058,
    0.066077270, 0.117392906, 0.176686174, 0.238534544, 0.311763755,
	0.378808733,
    0.062575943, 0.118935910, 0.193376735, 0.267872596, 0.339782403,
	0.403934258,
    0.088485447, 0.171679596, 0.250118523, 0.313966711, 0.374715460,
	0.441747289,
    0.082003992, 0.158616092, 0.244895790, 0.318482063, 0.384353792,
	0.428462743,
    0.079348909, 0.145770452, 0.217410238, 0.291154621, 0.361076565,
	0.430463412,
    0.109790744, 0.208903837, 0.273944189, 0.322744330, 0.370663523,
	0.421433809,
    0.092871149, 0.178471827, 0.259983619, 0.310968537, 0.354708365,
	0.400438736,
    0.086505875, 0.161320001, 0.240902551, 0.321838447, 0.397011184,
	0.452319878
};
