/**********************************************************************
Each of the companies; Qualcomm, Motorola, Lucent, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-WB Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-WB be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-WB or the field of use of practice of the 
EVRC-WB Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
#include "struct.h"
#include "defines.h"
#include "macro.h"

//The constructor for FGV_MEM class
FGV_MEM::FGV_MEM ()
{
    int i;

    rate = 4;
    WB_encoder_first_time = 1;
    WB_decoder_first_time = 1;
    Q_delta_lag = 0;
    fer_counter = 0;
    lastrateE = 1;
    pdelay = DMIN1;
    last_delay = delay1 = DMIN1;
    lastrateD = 1;
    pdelayD = DMIN1;

    LAST_PACKET_RATE_D = 1;

    OPSwitchFlag=0;
    prev_frame_op=0;

    operatingpoint_backup = 3;

	TRANSIENT_MODE_CODING=0;


    worigm = origm;		/* shared weighted original memory */
    for (i = 0; i < SubFrameSize; i++)
	worigm[i] = origm[i] = 0.0;
    for (i = 0; i < SubFrameSize + 6; i++)
	Scratch[i] = 0.0;
    prev_rcelp_half = 0;
    patterncount = 0;
    pattern_m = 0;

    ave_rate_kbps = 0;
    LAST_PPP_MODE_D = 'Q';
    PPP_MODE_E = 'Q';
    acbevrcFirstTime = 1;
    celpErasureSeed = 0;

    PREV_LSP_FLAG=0;

    for(i=0;i<2;i++) agc_lpfmem[i]=0.0;
    encode_fcnt_last=0;

    encode_fcnt_last2 = 0;
    for(i=0;i<3;i++) LBFilterStateMem[i]=0.0;
    for(i=0;i<2;i++) HBFilterStateMem[i]=0.0;

    for(i=0;i<MAX_TLEN ;i++)tmp_cb[i]=0;

	LAST_PACKET_RATE_D=1;

	decode_fcnt_last=0;
    dec_MusicModeNoiseSeed = 0;
    GetExc800bps_Seed = 0;
    GetExc800bps_dec_Seed = 0;
    cod3_10_offset[0] = 0;
    cod3_10_offset[1] = 2;
    cod3_10_offset[2] = 4;
    zeroInputFirstTime = 1;	/* init flag - sim only */
    autocorrelationFirstTime = 1;

    for (i = 0; i < ACBMemSize + SubFrameSize * 2; i++)
	Residual[i] = 0;

    for (i = 0; i < 5; i++)
	hpfmem.a[i] = hpfmem.b[i] = 0.0;
    for (i = 0; i < 5; i++)
	hpfmem8k.a[i] = hpfmem8k.b[i] = 0.0;
    rcelp_half_rateE = prev_dim_and_burstE = dim_and_burstE = 0;

    NUMFRAMES[0] = 0;		//zero,quarter,half,full
    NUMFRAMES[1] = 0;		//zero,quarter,half,full
    NUMFRAMES[2] = 0;		//zero,quarter,half,full
    NUMFRAMES[3] = 0;		//zero,quarter,half,full
    get_nacf_at_pitch_FirstTime = 1;

    for (i = 0; i < ORDER; i++) {
	FfiltMem[i] = 0.0;
	dec_FormantFilterMemory[i] = 0.0;
    }
    preemphmem[0] = 0.0;
    dec_preemphmem[0] = 0.0;

    last_delayBB = DMIN1;
    prev_celp_erasure = 0;

    SNR_THLD_L = 6.0;
    negSNRmean = 0; 
    negSNRvar = 0;
    negSNRbias = 0;
    
    /*related to the transient coding mode*/
    prev_frm_last_spike=0;
    prev_frame_trans=0;
    loc_last_pk_prev_frame=0;
    prev_frm_spegy=0.0;
    prev_frm_mode=1;
    num_syn_pk[0]=0;
    for(i=0;i<10;i++) {
	syn_pkloc[i]=0;
	enc_syn_mem[i]=0.0;
    }
    set_next_frm_transient=0;
    prev_frm_egy=0.0;
    prev_frm_last_coded_pk=240;
    estim_loc_first_pk=240;
    stdy_voiced_cnt=0;
    stdy_pitch_flag=0;

    
    total_bits_packed=0;
    for(i=0;i<MAX_RATES;i++)
        bit_rate_totals[i]=0;
    bit_rates=0;

    nelp_enc_seed = 0;
    nelp_dec_seed = 0;
    nelp_erasure_seed = 0;
    phase_offset = 10;
    run_length = 0;

    N_consec_ers = 0;

    go_back_input = 0;

    for (i = 0; i < NUM_CHAN; i++)
	ch_noise[i] = 0;
    LB_delay = DMIN1;
    update_bbg_flag = 0;

    for (i = 0; i < 160; i++)
	prev_qmdct[i] = 0.0;	//previous decoded MDCT coefficients for erasure processing
    norm_fade_fac = 1;
    prev_norm = 1;
    prev_noise_gain = 1;

    for (i = 0; i < 80; i++)
	prev_synth[i] = 0.0;


    for (i = 0; i < 80; i++) {
	dec_lookahead[i] = 0.0;
	dec_lookahead_wonoise[i] = 0.0;
    }
    for (i = 0; i < ORDER; i++)
	dec_FormantFilterMemory[i] = 0.0;
    dec_preemphmem[0] = 0;




    MDCT_NPULSES = 23;		/* Default: Used for WB */
    MDCT_NWORDS = 8;		/* 23 pulses on 144 position = 114 bits => 7*15 bits + 9 bits */
    MDCT_REMAINDER = 9;

    mdct_hist_cnt = 0, celp_hist_cnt = 0;


    for( i = 0; i<160; i++)
    qmdct[i]=0.0;

    for( i = 0; i<320; i++)
    MusicResidual[i]=0.0;



	for (i = 0; i < ORDER; i++) {	
	    SynMemoryM_recon[i] = 0.0;
	    WFmemFIR_recon[i] = 0.0;
	    WFmemIIR_recon[i] = 0.0;
	}

      for (i = 0; i < 80; i++) {
	    lookaheadME[i] = 0.0;
	    lookahead_wnoise[i] = 0.0;
	}

    SNRp = 0.0;
    ufcnt = 0;
    ns_sf_cnt = 0;
    update_bbg_reenc_flag =0;

    first_loc = 1;
    previous_modeWB = 1;

    scnt = 0;
    tsignal = 0.0; 
    tnoise = 0.0; 
    tsnr = 0.0; 
    for (i=0;i<NoOfSubFrames;i++) snr[i] = 0.0;
    avg_snr = 0;
    signalE = 0.0;
     noiseE = 0.0;


    prev_lpc_gain_sil = 0;
    decode_fcnt_last_sil = 0;

    for (i = 0; i < 160; i++)
	mdctcoeff[i] = 0.0;
    for (i = 0; i < 54; i++)
	last_music_signal_sf[i] = 0.0;

    celpSPL_HCELPSeed = 0;
    prev_celp_mdct_dec = 0;

    ave_rate = 0;
    numactive = 0;
    AV_TH = 6.3;

    Eprev = 0;
    Eavg = 1.6E6;
    LOWVOICEDTH = 0.55;
    VOICEDTH = 0.75;
    UNVOICEDTH = 0.35;
    SNRTH = 9.9657;

    mode_decision_FirstTime = 1;
    for (i = 0; i < 12; i++) {
	lpf_filt_mem[i] = hpf_filt_mem[i] = 0;
    }

    FirstHVframe = 1;


    for (i = 0; i < 5; i++)
	z.a[i] = z.b[i] = 0.0;


    vcount = 0;
    vE[0] = 0;
    vE[1] = 0;
    vE[2] = 0;
    vEav = 0;
    vEprev = 1E8;
    prev_voiced = 0;
    prev_mode = 1;
    prev_snr_diff = 0;


	/*==================================================*/
    /*      BAD-RATE CHECK variables                    */
	/*==================================================*/
    zrbit[0] = 0;
    zrbit[1] = 0;

    BAD_RATE = 0;
    WB_COUNT = 0;
    NB_COUNT = 0;
    ones_dec_cnt = 0;

    frame_cnt = 0;
    noise_suprs_first = TRUE;
    pre_emp_mem = de_emp_mem = 0.0;
    update_cnt = 0;
    for (i = 0; i < DELAY; i++)
	window_overlap[i] = 0.0;
    for (i = 0; i < NUM_CHAN; i++)
	ch_enrg[i] = 0.0;
    for (i = 0; i < FFT_LEN - FRM_LEN; i++)
	overlap[i] = 0.0;
    last_update_cnt = 0;
    hyster_cnt = 0;
    lastgoodpitch = 0;
    lastbeta = 0.0;
    fndppf_FirstTime = 1;

    mem_pre = 0;
    past_gain = 1.0;
    post_filter_first_time = 1;

    modifyorig_FirstTime = 1;
    factor1 = 0;
    factor2 = 0;

    update_background_first = 0;
    select_rate_first = 0;
    e_mem = &rate_mem;


    silence_erasure_seed = 0;
    iset = 0;
    PrevBest = 0;

    LASTLAST_PPP_MODE_E = LAST_PPP_MODE_E = 'Q';
    scr = ph_offset_E = ph_offset_D = 0.0;

    prev_nacf = 0;
    for (i = 0; i < 5; i++)
	nacf_ap[i] = 0;
    lpcgflag = FALSE;
    noSID = 0;
    WB_EncParams_Seed = 0;
    declick_frame_FirstTime = 0;
    LB2nd_der_frame_save = 0;
    comp_shift = 0;
    GainState = 1e-3;
    WB_DecParams_8thRate_Seed = 0;
    MaxErasureCount = 5;
    MaxGoodCountNeeded = 2;
    ErasureCount = 0;
    GoodCount = 0;
    noise_synthesis_Seed = 0;
    prev_mode1 = 0;
    for (i = 0;
	 i <
	 SPEECH_BUFFER_LEN * 7 / 8 + LOOKAHEAD_LEN * 7 / 8 +
	 HB_ANA_DELAY_NS_LB; i++)
	buf_HB[i] = 0.0;

    for (i = 0;
	 i <
	 SPEECH_BUFFER_LEN * 7 / 4 + LOOKAHEAD_LEN * 7 / 4 +
	 HB_ANA_DELAY_NS_LB * 2; i++)
	buf_WB14[i] = 0.0;

    for (i = 0; i < SPEECH_BUFFER_LEN + LOOKAHEAD_LEN; i++)
	buf_backup[i] = 0.0;

    for (i = 0; i < SPEECH_BUFFER_LEN * 7 / 4; i++)
	buf_WB14_out[i] = 0.0;
    for (i = 0; i < 28 + 48; i++)
	Synstate14[i] = 0.0;

    for (i = 0; i < 4; i++) {
	LBenvLPdB_frame_save[i] = 0.0;
	HBenvLPdB_frame_save2[i] = 0.0;
	HBenvLPdB_frame_save[i] = 0.0;
    }
    LB2nd_der_frame_save = 0;
    for (i = 0; i < LB_FRAMESIZE + LOOKAHEAD_8 - 1; i++)
	xLB_hpf_frame[i] = 0.0;

    for (i = 0; i < UB_FRAMESIZE + LOOKAHEAD_7 - 1; i++)
	xHB_hpf_frame[i] = 0.0;
    for (i = 0; i < DS_ATTN_SIZE; i++) {
	pulse_msr[i] = 0.0;
	excess_lvl_frame[i] = 0.0;
    }
    smooth_LB_ini = smooth_HB_ini = 0;
    comp_shift = 0;
    noise_iir[0] = 0;

    for (i = 0; i < LPF_8R_NR_ORD; i++)
	hpf_filt_mem1[i] = 0.0;



    for (i = 0; i < 4; i++) {
	fcb_target_lpfmem[i] = 0.0;
	mdct_orig_lpfmem[i] = 0.0;
	mdct_resid_lpfmem[i] = 0.0;
    }

    for (i = 0; i < 4; i++)
	fcb_filt_mem[i] = 0.0;

    for (i = 0; i < 4; i++)
	fcb_filt_mem_dec[i] = 0.0;
    autocorrelation_ExtWin_FirstTime = 1;
    initE = 0;
    initD = 0;
    erasure_8R = 0;


    // to fix UMR problems
    for (i = 0; i < SPEECH_BUFFER_LEN; i++)
	buf_out[i] = 0.0;
    beta = beta1 = 0.0;
    for (i = 0; i < 2; i++)
	curr_ns_snr[i] = 0;
    prev_snr[0] = prev_snr[1] = curr_snr[0] = curr_snr[1] = 0;
    for (i = 0; i < SPEECH_BUFFER_LEN + LOOKAHEAD_LEN; i++)
	buf[i] = 0.0;


    for (i = 0; i < 2 * SPEECH_BUFFER_LEN; i++)
	buf16[i] = 0;

    SPL_HCELP = SPL_HPPP = SPL_HNELP = 0;

    SPL_HMDCT =0;


    ER_counter = 0;

    ER_exct_nrg_avg = 0;

    attn_fac = 1.0;

    float ftmp;

    ftmp = 0.48 / (float) LPC_ORD_WB;
    prev_LSFs[0] = ftmp;

    for (i = 1; i < LPC_ORD_WB; i++) {
	prev_LSFs[i] = prev_LSFs[i - 1] + ftmp;
    }

    rate_last = 0;
    last_wb_mode_bit = 0;

    //static variables moved for Vulture compatability
    seed_ub = 0;
    ft = 0;
    EC = 0;
    smooth_gf = 0.0;
    /*for (i=0;i<5;i++) {
        ScaleFac[i] = 1.0;
    }*/
    for (i=0;i<32;i++) {
        frac[i] = ((float) (i+1))/32;
    }
    prev_mode2 = 1;
    //seed = 0;
    ScaleFac[0] = 0.9;
    ScaleFac[1] = 0.7;
    ScaleFac[2] = 0.5;
    ScaleFac[3] = 0.3;
    ScaleFac[4] = 0.1;
    LsfFac[0] = 0.8;
    LsfFac[1] = 0.6;
    LsfFac[2] = 0.4;
    LsfFac[3] = 0.2;
    LsfFac[4] = 0.1;
    agc1 = 1.0;
    agc_sm = 1.0;
    //first_cf = 1;
    //first_ff = 1;
    //first_Fn = 1;
    seed0 = 19267;
	last_subframesize = 54;
    gppf_sm = 0.0;
    gppf_sm_d = 0.0;
    DTX_STATE = 0;
    HO = 0;
    posn_prev_NER = 0;
	ft_enc = 1;
	prev_refl0 = 0;
    flag = 0;
	ra_deltasum = 0;
	running_avg = 0;
    nocompute = 0;
    env1_er = 1.0;
    env2_er = 1.0;

    ComputeACBFirstTime = 1;
    sfcnt = 0;

    Seed = 123456;

    firstTime_bbg2 = 1;
    firstTime_bbg = 1;
}
