/*====================================================================================
    EVS Codec 3GPP TS26.443 Jan 17, 2017. Version 12.8.0 / 13.4.0
  ====================================================================================*/

#include "options.h"
#include "cnst.h"
#include "rom_com.h"
#include "prot.h"
#include "basop_util.h"

/*----------------------------------------------------------------------------------*
 * Table of bitrates
 *----------------------------------------------------------------------------------*/

const long brate_tbl[SIZE_BRATE_TBL] =
{
    ACELP_7k20,  ACELP_8k00,  ACELP_9k60,  ACELP_13k20, ACELP_16k40, ACELP_24k40,
    ACELP_32k,   ACELP_48k,   ACELP_64k,   HQ_96k,      HQ_128k
};

/*----------------------------------------------------------------------------------*
 * Frame size and mode configuration tables
 *----------------------------------------------------------------------------------*/

const FrameSizeParams FrameSizeConfig[FRAME_SIZE_NB] =
{
    /*        bits,     net bits,   trans_bits,  trans_mode,  band_bits,   band_mode_min,  band_mode_max,  reserved_bits */
    {    FRAME_0,      FRAME_0,            0,       {0,0},          0,               0,              0,            0},  /*  0  kbps ZERO_FRAME*/
    {  FRAME_2_4,  FRAME_2_4-2,            1,       {1,1},          1,              NB,             WB,            0},  /*  2.4kbps VBR(SID)*/
    {  FRAME_7_2,  FRAME_7_2-1,            0,       {0,1},          1,              NB,             WB,            0},  /*  7.2kbps VBR/CBR*/
    {    FRAME_8,    FRAME_8-1,            0,       {0,1},          1,              NB,             WB,            0},  /*  8  kbps VBR/CBR*/
    {  FRAME_9_6,  FRAME_9_6-2,            0,       {0,1},          2,              NB,             SWB,           0},  /*  9.6kbps CBR*/
    { FRAME_13_2, FRAME_13_2-2,            0,       {0,1},          2,              NB,             SWB,           0},  /* 13.2kbps CBR*/
    { FRAME_16_4, FRAME_16_4-3,            0,       {0,1},          2,              NB,             FB,            1},  /* 16.4kbps CBR*/
    { FRAME_24_4, FRAME_24_4-3,            0,       {0,1},          2,              NB,             FB,            1},  /* 24.4kbps CBR*/
    {   FRAME_32,   FRAME_32-3,            0,       {0,1},          2,              WB,             FB,            1},  /* 32  kbps CBR*/
    {   FRAME_48,   FRAME_48-3,            0,       {0,1},          2,              WB,             FB,            1},  /* 48  kbps CBR*/
    {   FRAME_64,   FRAME_64-3,            0,       {0,1},          2,              WB,             FB,            1},  /* 64  kbps CBR*/
    {   FRAME_96,   FRAME_96-3,            0,       {0,1},          2,              WB,             FB,            1},  /* 96  kbps CBR*/
    {  FRAME_128,  FRAME_128-3,            0,       {0,1},          2,              WB,             FB,            1}   /*128  kbps CBR*/
};


/*----------------------------------------------------------------------------------*
 * Conversion of ACELP signalling parameters (ACELP internal Fs, coder type, bandwidth, sharpening flag) to index
 * (to be consulted with the decision matrix)
 *
 * - in order to retrieve the index, each section in this table starts with the bitrate
 * - the second value in each section corresponds to the number of bits
 * - the other values represent indices created by combining different parameters into a single value through the macro SIG2IND()
 *----------------------------------------------------------------------------------*/

const long acelp_sig_tbl[MAX_ACELP_SIG] =
{
    /*  GENERIC                      UNVOICED                      VOICED                        TRANSITION                      AUDIO                      INACTIVE                     */
    ACELP_7k20, 4,
    SIG2IND(GENERIC, NB, 1, 0),  SIG2IND(UNVOICED, NB, 0, 0),  SIG2IND(VOICED, NB, 1, 0),    SIG2IND(TRANSITION, NB, 1, 0),  SIG2IND(AUDIO, NB, 0, 0),  SIG2IND(INACTIVE, NB, 0, 0),
    SIG2IND(GENERIC, WB, 1, 0),  SIG2IND(UNVOICED, WB, 0, 0),  SIG2IND(VOICED, WB, 1, 0),    SIG2IND(TRANSITION, WB, 1, 0),  SIG2IND(AUDIO, WB, 0, 0),  SIG2IND(INACTIVE, WB, 0, 0),
    SIG2IND(GENERIC, NB, 0, 0),
    SIG2IND(GENERIC, WB, 0, 0),
    SIG2IND(LR_MDCT, NB, 0, 0),

    ACELP_8k00, 4,
    SIG2IND(GENERIC, NB, 1, 0),  SIG2IND(UNVOICED, NB, 0, 0),  SIG2IND(VOICED, NB, 1, 0),    SIG2IND(TRANSITION, NB, 1, 0),  SIG2IND(AUDIO, NB, 0, 0),  SIG2IND(INACTIVE, NB, 0, 0),
    SIG2IND(GENERIC, WB, 1, 0),  SIG2IND(UNVOICED, WB, 0, 0),  SIG2IND(VOICED, WB, 1, 0),    SIG2IND(TRANSITION, WB, 1, 0),  SIG2IND(AUDIO, WB, 0, 0),  SIG2IND(INACTIVE, WB, 0, 0),
    SIG2IND(GENERIC, NB, 0, 0),
    SIG2IND(GENERIC, WB, 0, 0),
    SIG2IND(LR_MDCT, NB, 0, 0),

    ACELP_13k20, 5,
    SIG2IND(GENERIC, NB, 1, 0),                                SIG2IND(VOICED, NB, 1, 0),    SIG2IND(TRANSITION, NB, 0, 0),  SIG2IND(AUDIO, NB, 0, 0),  SIG2IND(INACTIVE, NB, 0, 0),
    SIG2IND(GENERIC, WB, 1, 0),                                SIG2IND(VOICED, WB, 1, 0),    SIG2IND(TRANSITION, WB, 0, 0),  SIG2IND(AUDIO, WB, 0, 0),  SIG2IND(INACTIVE, WB, 0, 0),
    SIG2IND(GENERIC, SWB, 1, 0),                               SIG2IND(VOICED, SWB, 1, 0),   SIG2IND(TRANSITION, SWB, 0, 0), SIG2IND(AUDIO, SWB, 0, 0), SIG2IND(INACTIVE, SWB, 0, 0),
    SIG2IND(GENERIC, NB, 0, 0),                                SIG2IND(VOICED, NB, 0, 0),
    SIG2IND(GENERIC, WB, 0, 0),                                SIG2IND(VOICED, WB, 0, 0),
    SIG2IND(GENERIC, SWB, 0, 0),                               SIG2IND(VOICED, SWB, 0, 0),
    SIG2IND(GENERIC, WB, 1, 1),  SIG2IND(UNVOICED, WB, 0, 1),  SIG2IND(VOICED, WB, 1, 1),    SIG2IND(INACTIVE, WB, 0, 1),
    SIG2IND(GENERIC, SWB, 1, 1), SIG2IND(UNVOICED, SWB, 0, 1), SIG2IND(VOICED, SWB, 1, 1),   SIG2IND(INACTIVE, SWB, 0, 1),
    SIG2IND(LR_MDCT, NB, 0, 0),
    SIG2IND(LR_MDCT, WB, 0, 0),
    SIG2IND(LR_MDCT, SWB, 0, 0),

    ACELP_32k, 4,
    SIG2IND(GENERIC, WB, 1, 0),                                                              SIG2IND(TRANSITION, WB, 1, 0),                             SIG2IND(INACTIVE, WB, 0, 0),
    SIG2IND(GENERIC, SWB, 1, 0),                                                             SIG2IND(TRANSITION, SWB, 1, 0),                            SIG2IND(INACTIVE, SWB, 0, 0),
    SIG2IND(GENERIC, FB, 1, 0),                                                              SIG2IND(TRANSITION, FB, 1, 0),                             SIG2IND(INACTIVE, FB, 0, 0),
    SIG2IND(GENERIC, WB, 0, 0),                                                              SIG2IND(TRANSITION, WB, 0, 0),
    SIG2IND(GENERIC, SWB, 0, 0),                                                             SIG2IND(TRANSITION, SWB, 0, 0),
    SIG2IND(GENERIC, FB, 0, 0),                                                              SIG2IND(TRANSITION, FB, 0, 0),

    ACELP_64k, 4,
    SIG2IND(GENERIC, WB, 0, 0),                                                              SIG2IND(TRANSITION, WB, 0, 0),                             SIG2IND(INACTIVE, WB, 0, 0),
    SIG2IND(GENERIC, SWB, 1, 0),                                                             SIG2IND(TRANSITION, SWB, 1, 0),                            SIG2IND(INACTIVE, SWB, 0, 0),
    SIG2IND(GENERIC, FB, 1, 0),                                                              SIG2IND(TRANSITION, FB, 1, 0),                             SIG2IND(INACTIVE, FB, 0, 0),
    SIG2IND(GENERIC, SWB, 0, 0),                                                             SIG2IND(TRANSITION, SWB, 0, 0),
    SIG2IND(GENERIC, FB, 0, 0),                                                              SIG2IND(TRANSITION, FB, 0, 0),
};

/*----------------------------------------------------------------------------------*
 * ACELP bit allocation tables
 *----------------------------------------------------------------------------------*/

/* bit allocation table for end-frame LSF quantizer */
const short LSF_bits_tbl[] =
{
    /*  IC     UC     VC     GC     TC     AC  */
    22,    37,    31,    29,    31,    22,    /* ACELP_7k20  */
    22,    40,    36,    33,    34,    22,    /* ACELP_8k00  */
    31,     0,    37,    37,    40,    31,    /* ACELP_11k60 */
    31,     0,    39,    39,    41,    31,    /* ACELP_12k15 */
    31,     0,    38,    38,    40,    31,    /* ACELP_12k85 */
    31,     0,    38,    38,    40,    31,    /* ACELP_13k20 */
    31,     0,    37,    42,    42,    31,    /* ACELP_14k80 */
    31,     0,    43,    40,    40,    31,    /* ACELP_16k40 */
    31,     0,    42,    40,    40,     0,    /* ACELP_22k60 */
    31,     0,    46,    41,    41,    31,    /* ACELP_24k40 */
    41,     0,     0,    41,    41,     0,    /* ACELP_29k00 */
    41,     0,     0,    41,    41,     0,    /* ACELP_29k20 */
    41,     0,     0,    41,    41,     0,    /* ACELP_30k20 */
    41,     0,     0,    41,    41,     0,    /* ACELP_30k40 */
    41,     0,     0,    41,    41,     0,    /* ACELP_32k   */
    41,     0,     0,    41,    41,     0,    /* ACELP_48k   */
    41,     0,     0,    41,    41,     0,    /* ACELP_64k   */
};

/* bit allocation table for mid-frame LSF quantizer */
const short mid_LSF_bits_tbl[] =
{
    /* IC     UC     VC     GC     TC     AC */
    2,     5,     4,     5,     5,     2,     /* ACELP_7k20  */
    2,     5,     4,     5,     5,     2,     /* ACELP_8k00  */
    2,     0,     4,     5,     5,     2,     /* ACELP_11k60 */
    2,     0,     5,     5,     5,     2,     /* ACELP_12k15 */
    2,     0,     5,     5,     5,     2,     /* ACELP_12k85 */
    2,     0,     5,     5,     5,     2,     /* ACELP_13k20 */
    4,     0,     5,     5,     5,     4,     /* ACELP_14k80 */
    4,     0,     5,     5,     5,     4,     /* ACELP_16k40 */
    5,     0,     5,     5,     5,     5,     /* ACELP_22k60 */
    5,     0,     5,     5,     5,     5,     /* ACELP_24k40 */
    5,     0,     0,     5,     5,     5,     /* ACELP_29k00 */
    5,     0,     0,     5,     5,     5,     /* ACELP_29k20 */
    5,     0,     0,     5,     5,     5,     /* ACELP_30k20 */
    5,     0,     0,     5,     5,     5,     /* ACELP_30k40 */
    5,     0,     0,     5,     5,     5,     /* ACELP_32k   */
    5,     0,     0,     5,     5,     5,     /* ACELP_48k   */
    5,     0,     0,     5,     5,     5,     /* ACELP_64k   */
};


/* bit allocation table for scaled innovation energy prediction */
const short Es_pred_bits_tbl[] =
{
    /*  UC     VC     GC     TC  */
    0,     0,     0,     4,               /* ACELP_7k20  */
    0,     0,     0,     4,               /* ACELP_8k00  */
    0,     5,     4,     4,               /* ACELP_11k60 */
    0,     5,     5,     5,               /* ACELP_12k15 */
    0,     5,     4,     5,               /* ACELP_12k85 */
    0,     5,     4,     4,               /* ACELP_13k20 */
    0,     5,     5,     5,               /* ACELP_14k80 */
    0,     5,     5,     5,               /* ACELP_16k40 */
    0,     5,     5,     5,               /* ACELP_22k60 */
    0,     5,     5,     5,               /* ACELP_24k40 */
    0,     0,     5,     5,               /* ACELP_29k00 */
    0,     0,     5,     5,               /* ACELP_29k20 */
    0,     0,     5,     5,               /* ACELP_30k20 */
    0,     0,     5,     5,               /* ACELP_30k40 */
    0,     0,     5,     5,               /* ACELP_32k   */
    0,     0,     5,     5,               /* ACELP_48k   */
    0,     0,     5,     5,               /* ACELP_64k   */
};

/* bit allocation table for gain quantizer (ACELP@12.8kHz) */
/* the 4 values allocated correspond to 4 subframes */
const short gain_bits_tbl[] =
{
    /*  UC       VC       GC       TC0_0    TC0_64   TC0_128  TC0_192  TC64     TC128    TC192  */
    7,7,7,7, 7,6,6,6, 6,6,6,6, 5,5,5,5, 5,5,6,5, 5,3,6,6, 5,3,3,6, 3,6,6,6, 3,3,6,6, 3,3,3,10,  /* ACELP_7k20  */
    7,7,7,7, 8,7,6,6, 8,7,6,6, 5,5,5,5, 5,6,5,5, 5,3,6,6, 5,3,3,6, 3,5,5,5, 3,3,6,6, 3,3,3,14,  /* ACELP_8k00  */
    0,0,0,0, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,3,6,6, 6,3,3,6, 3,6,6,6, 3,3,6,6, 3,3,3,13,  /* ACELP_11k60 */
    0,0,0,0, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,3,6,6, 6,3,3,6, 3,6,6,6, 3,3,6,6, 3,3,3,14,  /* ACELP_12k15 */
    0,0,0,0, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,3,6,6, 6,3,3,6, 3,6,6,6, 3,3,6,5, 3,3,3,14,  /* ACELP_12k85 */
    0,0,0,0, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,3,6,6, 6,3,3,6, 3,6,6,6, 3,3,6,6, 3,3,3,15,  /* ACELP_13k20 */
    0,0,0,0, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,3,6,6, 6,3,3,6, 3,6,6,6, 3,3,6,6, 3,3,3,15,  /* ACELP_14k80 */
    0,0,0,0, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,3,6,6, 6,3,3,6, 3,6,6,6, 3,3,6,6, 3,3,3,15,  /* ACELP_16k40 */
    0,0,0,0, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,3,6,6, 6,3,3,6, 3,6,6,6, 3,3,6,6, 3,3,3,14,  /* ACELP_22k60 */
    0,0,0,0, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,6,6,6, 6,3,6,6, 6,3,3,6, 3,6,6,6, 3,3,6,6, 3,3,3,15,  /* ACELP_24k40 */
};

/* bit allocation table for gain gain quantizer (ACELP@16kHz) */
/* the 5 values allocated correspond to 5 subframes */
const short gain_bits_16kHz_tbl[] =
{
    /* IC               GC               TC0              TC64            TC128          TC192          TC256  */
    0,0,0,0,0,       6,0,0,0,0,       0,0,0,0,0,       0,0,0,0,0,      0,0,0,0,0,     0,0,0,0,0,     0,0,0,0, 0,    /* ACELP_8k00 */
    0,0,0,0,0,       6,0,0,0,0,       0,0,0,0,0,       0,0,0,0,0,      0,0,0,0,0,     0,0,0,0,0,     0,0,0,0, 0,    /* ACELP_14k80 */
    6,6,6,6,6,       6,6,6,6,6,       6,6,6,6,6,       3,6,6,6,6,      3,3,6,6,6,     3,3,3,6,6,     3,3,3,3,15,     /* ACELP_22k60 */
    6,6,6,6,6,       6,6,6,6,6,       6,6,6,6,6,       3,6,6,6,6,      3,3,6,6,6,     3,3,3,6,6,     3,3,3,3,16,     /* ACELP_24k40 */
    6,6,6,6,6,       6,6,6,6,6,       6,6,6,6,6,       3,6,6,6,6,      3,3,6,6,6,     3,3,3,6,6,     3,3,3,3,14,     /* ACELP_29k00 */
    6,6,6,6,6,       6,6,6,6,6,       6,6,6,6,6,       3,6,6,6,6,      3,3,6,6,6,     3,3,3,6,6,     3,3,3,3,14,     /* ACELP_29k20 */
    6,6,6,6,6,       6,6,6,6,6,       6,6,6,6,6,       3,6,6,6,6,      3,3,6,6,6,     3,3,3,6,6,     3,3,3,3,14,     /* ACELP_30k20 */
    6,6,6,6,6,       6,6,6,6,6,       6,6,6,6,6,       3,6,6,6,6,      3,3,6,6,6,     3,3,3,6,6,     3,3,3,3,14,     /* ACELP_30k40 */
    6,6,6,6,6,       6,6,6,6,6,       6,6,6,6,6,       3,6,6,6,6,      3,3,6,6,6,     3,3,3,6,6,     3,3,3,3,14,     /* ACELP_32k   */
    12,12,12,12,12,  12,12,12,12,12,  12,12,12,12,12,  6,12,12,12,12,  6,6,12,12,12,  6,6,6,12,12,   6,6,6,6,12,     /* ACELP_48k   */
    12,12,12,12,12,  12,12,12,12,12,  12,12,12,12,12,  6,12,12,12,12,  6,6,12,12,12,  6,6,6,12,12,   6,6,6,6,12      /* ACELP_64k   */
};

/* bit allocation table for adaptive codebook (pitch) (ACELP@12.8kHz) */
/* the 4 values correspond to 4 subframes */
const short ACB_bits_tbl[] =
{
    /*  UC        VC        GC        TC0_0    TC0_64   TC0_128  TC0_192  TC64     TC128    TC192  */
    0,0,0,0,  9,5,5,5,  8,5, 8,5, 6,5,6,6, 0,7,6,6, 0,0,7,6, 0,0,0,7, 0,0,9,6, 0,0,5,9, 0,0,0,8,   /* ACELP_7k20  */
    0,0,0,0, 10,5,5,5,  9,5, 8,5, 6,5,6,6, 0,7,6,6, 0,0,7,5, 0,0,0,7, 0,0,9,6, 0,0,5,9, 0,0,0,9,   /* ACELP_8k00  */
    0,0,0,0, 10,5,5,5, 10,6, 9,6, 6,5,6,6, 0,7,6,6, 0,0,7,6, 0,0,0,7, 0,0,9,6, 0,0,5,9, 0,0,0,9,   /* ACELP_11k60 */
    0,0,0,0, 10,5,5,5, 10,6, 9,6, 6,6,6,6, 0,7,6,6, 0,0,7,6, 0,0,0,7, 0,0,9,6, 0,0,5,9, 0,0,0,9,   /* ACELP_12k15 */
    0,0,0,0, 10,5,5,5, 10,6, 9,6, 6,5,6,6, 0,7,6,6, 0,0,7,6, 0,0,0,7, 0,0,9,6, 0,0,5,9, 0,0,0,9,   /* ACELP_12k85 */
    0,0,0,0, 10,5,5,5, 10,6, 9,6, 6,5,6,6, 0,7,6,6, 0,0,7,6, 0,0,0,7, 0,0,9,6, 0,0,5,9, 0,0,0,9,   /* ACELP_13k20 */
    0,0,0,0, 10,5,5,5, 10,6,10,6, 6,6,6,6, 0,7,6,6, 0,0,7,6, 0,0,0,7, 0,0,9,6, 0,0,5,9, 0,0,0,9,   /* ACELP_14k80 */
    0,0,0,0, 10,5,5,5, 10,6,10,6, 6,6,6,6, 0,7,6,6, 0,0,7,6, 0,0,0,7, 0,0,9,6, 0,0,5,9, 0,0,0,9,   /* ACELP_16k40 */
    0,0,0,0, 10,5,5,5, 10,6,10,6, 6,6,6,6, 0,7,6,6, 0,0,7,6, 0,0,0,7, 0,0,9,6, 0,0,5,9, 0,0,0,9,   /* ACELP_22k60 */
    0,0,0,0, 10,5,5,5, 10,6,10,6, 6,6,6,6, 0,7,6,6, 0,0,7,6, 0,0,0,7, 0,0,9,6, 0,0,5,9, 0,0,0,9,   /* ACELP_24k40 */
};

/* bit allocation table for adaptive codebook (pitch) (ACELP@16kHz) */
/* the 5 values correspond to 5 subframes */
const short ACB_bits_16kHz_tbl[] =
{
    /* IC            GC            TC0          TC64        TC128       TC192       TC256  */
    0,0, 0,0,0,   9,0, 0,0,0,  0,0, 0,0,0,  0,0, 0,0,0, 0,0, 0,0,0, 0,0,0, 0,0, 0,0,0,0, 0,    /* ACELP_8k00 */
    0,0, 0,0,0,  10,0, 0,0,0,  0,0, 0,0,0,  0,0, 0,0,0, 0,0, 0,0,0, 0,0,0, 0,0, 0,0,0,0, 0,    /* ACELP_14k80 */
    10,6,10,6,6,  10,6,10,6,6,  5,8,10,6,6,  0,6,10,6,6, 0,0,10,6,6, 0,0,0,10,6, 0,0,0,0,10,    /* ACELP_22k60 */
    10,6,10,6,6,  10,6,10,6,6,  5,8,10,6,6,  0,6,10,6,6, 0,0,10,6,6, 0,0,0,10,6, 0,0,0,0,10,    /* ACELP_24k40 */
    10,6,10,6,6,  10,6,10,6,6,  6,8,10,6,6,  0,6,10,6,6, 0,0,10,6,6, 0,0,0,10,6, 0,0,0,0,10,    /* ACELP_29k00 */
    10,6,10,6,6,  10,6,10,6,6,  6,8,10,6,6,  0,6,10,6,6, 0,0,10,6,6, 0,0,0,10,6, 0,0,0,0,10,    /* ACELP_29k20 */
    10,6,10,6,6,  10,6,10,6,6,  6,8,10,6,6,  0,6,10,6,6, 0,0,10,6,6, 0,0,0,10,6, 0,0,0,0,10,    /* ACELP_30k20 */
    10,6,10,6,6,  10,6,10,6,6,  6,8,10,6,6,  0,6,10,6,6, 0,0,10,6,6, 0,0,0,10,6, 0,0,0,0,10,    /* ACELP_30k40 */
    10,6,10,6,6,  10,6,10,6,6,  6,8,10,6,6,  0,6,10,6,6, 0,0,10,6,6, 0,0,0,10,6, 0,0,0,0,10,    /* ACELP_32k   */
    10,6,10,6,6,  10,6,10,6,6,  6,8,10,6,6,  0,6,10,6,6, 0,0,10,6,6, 0,0,0,10,6, 0,0,0,0,10,    /* ACELP_48k   */
    10,6,10,6,6,  10,6,10,6,6,  6,8,10,6,6,  0,6,10,6,6, 0,0,10,6,6, 0,0,0,10,6, 0,0,0,0,10     /* ACELP_64k   */
};

/* bit allocation table for algebraic (fixed) codebook (innovation) (ACELP@12.8kHz) */
/* the 4 values correspond to 4 subframes */
const short FCB_bits_tbl[] =
{
    /*  UC           VC           GC           TC0_0        TC0_64       TC0_128      TC0_192      TC64         TC128        TC192  */
    13,13,13,13, 12,12,12,20, 12,12,12,20, 12, 7,12,12, 12,12, 7,12, 12,12,12,12, 12,12,20,12, 12,12,12,12, 12,12,12,12, 12,12,12,20,    /* ACELP_7k20  */
    13,13,13,13, 12,20,12,20, 12,20,12,20, 20,12,12,12, 20,12,12,12, 20,12,20,12, 20,12,20,20, 20,12,12,20, 20,12,20,12, 12,20,12,20,    /* ACELP_8k00  */
    0, 0, 0, 0, 28,36,28,36, 28,28,28,36, 28,28,28,28, 28,28,28,28, 28,28,36,28, 28,36,28,36, 28,36,28,28, 28,28,28,36, 28,36,28,36,    /* ACELP_11k60 */
    0, 0, 0, 0, 28,36,36,36, 28,36,28,36, 36,28,28,28, 36,28,28,28, 36,28,36,28, 36,36,28,43, 28,36,28,36, 28,36,28,36, 28,36,36,36,    /* ACELP_12k15 */
    0, 0, 0, 0, 36,36,36,43, 36,36,36,36, 36,36,28,36, 36,28,36,36, 36,36,36,36, 36,36,43,43, 36,36,36,36, 36,36,36,43, 36,36,36,43,    /* ACELP_12k85 */
    0, 0, 0, 0, 36,43,36,43, 36,36,36,43, 36,36,36,36, 36,36,36,36, 36,36,43,36, 36,43,43,43, 36,43,36,36, 43,36,43,36, 36,43,36,43,    /* ACELP_13k20 */
    0, 0, 0, 0, 43,50,43,50, 43,43,43,43, 43,43,43,43, 43,43,43,43, 43,43,50,43, 43,50,50,50, 43,43,43,50, 50,43,50,43, 43,50,43,50,    /* ACELP_14k80 */
    0, 0, 0, 0, 50,56,50,56, 50,50,50,56, 56,50,50,50, 56,50,50,50, 56,50,56,56, 56,56,56,56, 50,56,50,56, 50,56,56,56, 50,56,56,56,    /* ACELP_16k40 */
    0, 0, 0, 0, 83,83,83,87, 78,83,83,83, 83,78,83,83, 83,78,83,87, 83,87,83,87, 83,87,87,92, 87,83,87,83, 87,83,87,87, 83,87,87,87,    /* ACELP_22k60 */
    0, 0, 0, 0, 92,92,92,92, 87,92,92,92, 92,87,92,92, 92,87,92,92, 92,92,92,92, 92,92,92,92, 92,92,92,92, 92,92,92,92, 92,92,92,92,    /* ACELP_24k40 */
};

/* bit allocation table for algebraic (fixed) codebook (innovation) (ACELP@16kHz) */
/* the 5 values correspond to 5 subframes */
const short FCB_bits_16kHz_tbl[] =
{
    /*  IC             GC              TC0             TC64            TC128           TC192           TC256  */
    0, 0, 0, 0, 0, 12, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,     /* ACELP_8k00 */
    0, 0, 0, 0, 0, 36, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,     /* ACELP_14k80 */
    0, 0, 0, 0, 0, 62,56,56,56,62, 62,56,56,56,56, 56,56,56,56,73, 62,56,62,62,62, 56,62,62,62,73, 62,62,62,62,68,     /* ACELP_22k60 */
    0, 0, 0, 0, 0, 68,68,68,73,73, 68,68,68,68,73, 68,73,68,73,73, 73,73,73,73,73, 73,78,73,73,78, 73,78,73,73,78,     /* ACELP_24k40 */
    12,12,12,12,12, 36,28,28,36,36, 36,28,28,36,36, 36,28,28,36,36, 36,28,28,36,36, 36,28,28,36,36, 36,28,28,36,36,     /* ACELP_29k00 */
    12,12,12,12,12, 36,28,28,36,36, 36,28,28,36,36, 36,28,28,36,36, 36,28,28,36,36, 36,28,28,36,36, 36,28,28,36,36,     /* ACELP_29k20 */
    12,12,12,12,12, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36,     /* ACELP_30k20 */
    12,12,12,12,12, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36,     /* ACELP_30k40 */
    12,12,12,12,12, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36,     /* ACELP_32k   */
    12,12,12,12,12, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36,     /* ACELP_48k   */
    12,12,12,12,12, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36, 36,36,36,36,36      /* ACELP_64k   */
};

/* bit allocation table for AVQ bits in active segments (ACELP@16kHz) */
const short AVQ_bits_16kHz_tbl[] =
{
    /*   IC                      GC                    TC0                   TC64                  TC128                 TC192                 TC256  */
    0,  0,  0,  0,  0,      0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,      /* ACELP_8k00 */
    0,  0,  0,  0,  0,      0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,      /* ACELP_14k80 */
    0,  0,  0,  0,  0,      0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,      /* ACELP_22k60 */
    0,  0,  0,  0,  0,      0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,    0,  0,  0,  0,  0,      /* ACELP_24k40 */
    78, 78, 78, 78, 78,     48, 48, 48, 48, 49,   48, 49, 49, 48, 49,   50, 50, 51, 52, 52,   50, 54, 53, 54, 54,   55, 55, 55, 55, 54,   52, 56, 56, 56, 56,      /* ACELP_29k00 */
    79, 79, 79, 79, 78,     49, 49, 49, 49, 49,   50, 49, 49, 50, 49,   52, 52, 51, 52, 52,   54, 54, 53, 54, 54,   56, 55, 55, 56, 56,   56, 56, 56, 56, 56,      /* ACELP_29k20 */
    78, 78, 78, 78, 78,     50, 50, 50, 50, 49,   51, 50, 50, 50, 50,   53, 53, 53, 52, 52,   55, 55, 55, 54, 54,   57, 57, 56, 56, 56,   57, 57, 57, 57, 56,      /* ACELP_30k20 */
    79, 79, 79, 79, 78,     51, 51, 51, 50, 50,   51, 51, 51, 51, 51,   54, 54, 53, 53, 53,   56, 56, 56, 55, 54,   58, 57, 57, 57, 57,   58, 58, 58, 57, 57,      /* ACELP_30k40 */
    86, 85, 85, 85, 85,     57, 57, 57, 57, 57,   58, 58, 57, 57, 57,   60, 60, 60, 60, 59,   62, 62, 62, 62, 61,   64, 64, 64, 63, 63,   64, 64, 64, 64, 64,      /* ACELP_32k   */
    143,142,142,142,142,    116,115,115,115,115,  116,116,115,115,115,  119,119,118,118,118,  121,121,121,121,121,  124,124,123,123,123,  126,126,126,126,126,      /* ACELP_48k   */
    207,206,206,206,206,    180,179,179,179,179,  180,180,179,179,179,  183,183,182,182,182,  185,185,185,185,185,  188,188,187,187,187,  190,190,190,190,190       /* ACELP_64k   */
};

/* bit allocation table for reserved bits (ACELP@12.8kHz) */
const short reserved_bits_tbl[] =
{
    /*  UC      VC       GC       TC0_0   TC0_64  TC0_128  TC0_192  TC64  TC128  TC192  */
    1,      0,       0,       0,      0,      2,       4,       0,    3,     0,    /* ACELP_7k20  */
    14,      0,       0,       0,      0,      0,       1,       0,    0,     0,    /* ACELP_8k00  */
    0,      0,       0,       0,      1,      3,       6,       2,    6,     0,    /* ACELP_11k60 */
    0,      0,       0,       0,      2,      4,       0,       3,    7,     0,    /* ACELP_12k15 */
    0,      0,       0,       0,      1,      3,       0,       2,    0,     0,    /* ACELP_12k85 */
    0,      0,       0,       0,      1,      4,       1,       3,    0,     0,    /* ACELP_13k20 */
    0,      0,       0,       0,      2,      5,       2,       4,    1,     1,    /* ACELP_14k80 */
    0,      0,       0,       0,      2,      0,       5,       5,    3,     3,    /* ACELP_16k40 */
    0,      0,       2,       2,      0,      1,       3,       0,    0,     1,    /* ACELP_22k60 */
    0,      0,       1,       1,      3,      8,      19,       7,   11,    11,    /* ACELP_24k40 */
};

/* NRG mode */
const unsigned char ACELP_NRG_MODE[RATE_MODE_MAX][BANDWIDTH_MODE_MAX][ACELP_MODE_MAX+RF_MODE_MAX] =
{
    {{0,0,1,1,0,0,0,0},{2,2,1,1,0,0,0,0}},
    {{1,1,1,1,0,0,0,0},{1,1,1,1,1,1,1,0}},
};

/* NRG bits : (0/2/3 bits) */
const unsigned char ACELP_NRG_BITS[3] = { 0,  3,  4 };

/* LTP MODE*/
const unsigned char ACELP_LTP_MODE[RATE_MODE_MAX][BANDWIDTH_MODE_MAX][ACELP_MODE_MAX+RF_MODE_MAX] =
{
    {{0,0,1,2,0,0,0,0},{0,0,1,2,0,0,0,0}},
    {{4,4,3,4,0,0,0,0},{4,4,3,4,8,0,9,0}},
};

/* LTP bits */
const unsigned char ACELP_LTP_BITS_SFR[8+RF_MODE_MAX][5] =
{
    {0,0,0,0,0},
    {8,4,4,4,4},
    {8,5,8,5,5},
    {9,6,6,6,6},
    {9,6,9,6,6},
    {8,5,5,5,5},
    {8,5,8,5,5},
    {8,0,0,0,0},
    {8,5,5,5,5},   /* All-pred mode in RF, rf_frame_type = 0 */
    {8,4,4,4,0},   /* Gen-pred mode in RF, rf_frame_type = 2 */
};

/* LTF modes (0 - LOW_PASS (LP filtering), 1 - FULL_BAND (no filtering), 2 - NORMAL_OPERATION (adaptive)) */
/* Mode 2 ACELP: INACTIVE,UNVOICED,VOICED,GENERIC */
const unsigned char ACELP_LTF_MODE[RATE_MODE_MAX][BANDWIDTH_MODE_MAX][ACELP_MODE_MAX+RF_MODE_MAX] =
{
    {{1,1,1,0,0,0,0,0},{1,1,1,0,0,0,0,0}},
    {{0,0,2,0,0,0,0,0},{0,0,2,0,1,1,1,0}},
};

/* LTF bits */
const unsigned char ACELP_LTF_BITS[4] = {  0,  0,  4,  0  };

/* GAINS ELEMENT */
/* 5 modes: (EVS: 5b/subframe), (AMRWB: 7b/subframe),(AMRWB: 6b/subframe),(UC: 5b/subframe) */
const unsigned char ACELP_GAINS_MODE[RATE_MODE_MAX][BANDWIDTH_MODE_MAX][ACELP_MODE_MAX+RF_MODE_MAX] =
{
    {{6,6,1,1,0,0,0,0},{7,7,1,1,0,0,0,0}},
    {{2,2,3,3,0,0,0,0},{2,2,3,3,3,2,1,0}},
};

/* gains bits */
const unsigned char ACELP_GAINS_BITS[10] =
{
    0, /* skip sub-frame wise gain coding*/
    5,
    6,
    7,
    6,
    7,
    6, /* UC */
    7, /* GUNVOICED UV (5b ICB/2b Gaussian) */
    4, /* GNELP UV */
    5  /* GNELP UV  */
};

/* BPF modes (0 - no filtering, 1 - filtering, 2 - adaptive) */
const unsigned char ACELP_BPF_MODE[RATE_MODE_MAX][BANDWIDTH_MODE_MAX][ACELP_MODE_MAX+RF_MODE_MAX] =
{
    {{1,1,1,1,0,0,0,0},{1,1,1,1,0,0,0,0}},
    {{1,1,2,2,0,0,0,0},{1,1,2,2,1,1,1,1}},

};

/* BPF bits */
const unsigned char ACELP_BPF_BITS[3] = { 0,  0,  2 };

/*----------------------------------------------------------------------------------*
 * Power of 2 table (2^x)
 *----------------------------------------------------------------------------------*/

const int pow2[] =
{
    1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 1048576
};

/*----------------------------------------------------------------------------------*
 * Perceptual critical bands
 *----------------------------------------------------------------------------------*/

const float crit_bands[] =
{
    100.0f, 200.0f, 300.0f, 400.0f, 510.0f, 630.0f, 770.0f, 920.0f, 1080.0f, 1270.0f, 1480.0f,
    1720.0f, 2000.0f, 2320.0f, 2700.0f, 3150.0f, 3700.0f, 4400.0f, 5300.0f, 6350.0f, 7700.0f,
    9500.0f, 12000.0f, 15500.0f, 40000.0f
};
const float crit_bins_corr[CRIT_NOIS_BAND] =
{
    0.9f, 0.9f, 0.85f, 0.8f, 0.775f, 0.75f, 0.725f, 0.7f, 0.675f, 0.65f, 0.625f,
    0.60f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f
};
const short crit_bins[CRIT_NOIS_BAND] =
{
    4, 4, 4, 4, 4, 5, 6, 6, 6, 8, 8, 10, 11, 13, 15, 18, 22, 16, 16, 20, 20, 20, 16
};

const float crit_bands_loc[CRIT_NOIS_BAND] =
{
    100.0f, 200.0f, 300.0f, 400.0f, 510.0f, 630.0f, 770.0f, 920.0f, 1080.0f, 1270.0f, 1480.0f,
    1720.0f, 2000.0f, 2320.0f, 2700.0f, 3150.0f, 3700.0f, 4100.0f, 4500.0f, 5000.0f, 5500.0f, 6000.0f, 6375.0f
};

const float inv_tbl[130] =
{
    0.0f, /* unused */
    1.0000000000f, 0.5000000000f, 0.3333333333f, 0.2500000000f,
    0.2000000000f, 0.1666666667f, 0.1428571429f, 0.1250000000f,
    0.1111111111f, 0.1000000000f, 0.0909090909f, 0.0833333333f,
    0.0769230769f, 0.0714285714f, 0.0666666667f, 0.0625000000f,
    0.0588235294f, 0.0555555556f, 0.0526315789f, 0.0500000000f,
    0.0476190476f, 0.0454545455f, 0.0434782609f, 0.0416666667f,
    0.0400000000f, 0.0384615385f, 0.0370370370f, 0.0357142857f,
    0.0344827586f, 0.0333333333f, 0.0322580645f, 0.0312500000f,
    0.0303030303f, 0.0294117647f, 0.0285714286f, 0.0277777778f,
    0.0270270270f, 0.0263157895f, 0.0256410256f, 0.0250000000f,
    0.0243902439f, 0.0238095238f, 0.0232558140f, 0.0227272727f,
    0.0222222222f, 0.0217391304f, 0.0212765957f, 0.0208333333f,
    0.0204081633f, 0.0200000000f, 0.0196078431f, 0.0192307692f,
    0.0188679245f, 0.0185185185f, 0.0181818182f, 0.0178571429f,
    0.0175438596f, 0.0172413793f, 0.0169491525f, 0.0166666667f,
    0.0163934426f, 0.0161290323f, 0.0158730159f, 0.0156250000f,
    0.0153846154f, 0.0151515152f, 0.0149253731f, 0.0147058824f,
    0.0144927536f, 0.0142857143f, 0.0140845070f, 0.0138888889f,
    0.0136986301f, 0.0135135135f, 0.0133333333f, 0.0131578947f,
    0.0129870130f, 0.0128205128f, 0.0126582278f, 0.0125000000f,
    0.0123456790f, 0.0121951220f, 0.0120481928f, 0.0119047619f,
    0.0117647059f, 0.0116279070f, 0.0114942529f, 0.0113636364f,
    0.0112359551f, 0.0111111111f, 0.0109890110f, 0.0108695652f,
    0.0107526882f, 0.0106382979f, 0.0105263158f, 0.0104166667f,
    0.0103092784f, 0.0102040816f, 0.0101010101f, 0.0100000000f,
    0.0099009901f, 0.0098039216f, 0.0097087379f, 0.0096153846f,
    0.0095238095f, 0.0094339623f, 0.0093457944f, 0.0092592593f,
    0.0091743119f, 0.0090909091f, 0.0090090090f, 0.0089285714f,
    0.0088495575f, 0.0087719298f, 0.0086956522f, 0.0086206897f,
    0.0085470085f, 0.0084745763f, 0.0084033613f, 0.0083333333f,
    0.0082644628f, 0.0081967213f, 0.0081300813f, 0.0080645161f,
    0.0080000000f, 0.0079365079f, 0.0078740157f, 0.0078125000f,
    0.0077519380f /* last val = 1/129 */
};


/*----------------------------------------------------------------------------------*
 * LD music post-filter
 *----------------------------------------------------------------------------------*/

const float mfreq_loc_LD[] = { 100.0f, 200.0f, 300.0f, 400.0f, 510.0f, 630.0f, 770.0f, 920.0f, 1080.0f, 1270.0f, 1480.0f,
                               1720.0f, 2000.0f, 2320.0f, 2700.0f, 3150.0f, 3700.0f, 4400.0f, 5300.0f, (6400.0f-BIN_16kdct)
                             };

const short mfreq_bindiv_LD[] = {10, 10, 10, 10, 11, 12, 14, 15, 16, 19, 21, 24, 28, 32, 38, 45, 55, 70, 90, 110};
const float sc_qnoise[] = {0.1f,0.1f,0.1f,0.1f,0.1f,0.1f,0.09091f,0.09091f,0.09091f,0.09091f,0.09091f,0.09091f,0.09091f,0.09091f,0.09091f,0.06667f,0.06667f,0.06667f,0.06667f,0.06667f};

const float post_dct_wind[OFFSET2] =
{
    1.000000f, 0.999933f, 0.999731f, 0.999395f, 0.998924f, 0.998319f, 0.997580f, 0.996707f,
    0.995700f, 0.994560f, 0.993287f, 0.991881f, 0.990343f, 0.988672f, 0.986870f, 0.984938f,
    0.982874f, 0.980681f, 0.978358f, 0.975907f, 0.973328f, 0.970621f, 0.967787f, 0.964828f,
    0.961743f, 0.958535f, 0.955202f, 0.951748f, 0.948172f, 0.944475f, 0.940658f, 0.936723f,
    0.932671f, 0.928501f, 0.924217f, 0.919819f, 0.915307f, 0.910684f, 0.905950f, 0.901107f,
    0.896156f, 0.891098f, 0.885935f, 0.880669f, 0.875300f, 0.869829f, 0.864260f, 0.858592f,
    0.852828f, 0.846968f, 0.841016f, 0.834971f, 0.828837f, 0.822614f, 0.816304f, 0.809909f,
    0.803431f, 0.796871f, 0.790231f, 0.783513f, 0.776719f, 0.769850f, 0.762908f, 0.755896f,
    0.748815f, 0.741667f, 0.734454f, 0.727178f, 0.719841f, 0.712444f, 0.704991f, 0.697482f,
    0.689920f, 0.682307f, 0.674645f, 0.666936f, 0.659182f, 0.651385f, 0.643547f, 0.635671f,
    0.627758f, 0.619811f, 0.611832f, 0.603822f, 0.595785f, 0.587721f, 0.579635f, 0.571526f,
    0.563399f, 0.555254f, 0.547095f, 0.538923f, 0.530740f, 0.522549f, 0.514353f, 0.506152f,
    0.497949f, 0.489747f, 0.481548f, 0.473354f, 0.465167f, 0.456990f, 0.448824f, 0.440671f,
    0.432535f, 0.424417f, 0.416319f, 0.408244f, 0.400193f, 0.392169f, 0.384175f, 0.376211f,
    0.368281f, 0.360386f, 0.352529f, 0.344712f, 0.336936f, 0.329204f, 0.321518f, 0.313880f,
    0.306293f, 0.298757f, 0.291276f, 0.283850f, 0.276483f, 0.269176f, 0.261931f, 0.254751f,
    0.247636f, 0.240589f, 0.233612f, 0.226707f, 0.219875f, 0.213118f, 0.206439f, 0.199839f,
    0.193320f, 0.186883f, 0.180530f, 0.174264f, 0.168085f, 0.161995f, 0.155996f, 0.150090f,
    0.144278f, 0.138562f, 0.132943f, 0.127423f, 0.122003f, 0.116685f, 0.111470f, 0.106360f,
    0.101355f, 0.096458f, 0.091669f, 0.086991f, 0.082423f, 0.077968f, 0.073626f, 0.069399f,
    0.065289f, 0.061295f, 0.057419f, 0.053662f, 0.050025f, 0.046510f, 0.043116f, 0.039846f,
    0.036699f, 0.033677f, 0.030780f, 0.028010f, 0.025367f, 0.022851f, 0.020464f, 0.018206f,
    0.016078f, 0.014080f, 0.012212f, 0.010476f, 0.008872f, 0.007400f, 0.006060f, 0.004853f,
    0.003780f, 0.002840f, 0.002034f, 0.001362f, 0.000824f, 0.000420f, 0.000151f, 0.000017f
};

const float MAX_SNR_SNR1_tab[MBANDS_GN_LD] = { 1.026316f,  1.026316f,  1.026316f,  1.026316f,  1.026316f,  1.026316f,  1.026316f,  1.026316f,  1.026316f,  1.026316f,  1.026316f,  1.026316f,  1.026316f,  1.026316f, 1.026316f, 1.02631627f, 1.043478f, 1.043478f, 1.043478f, 1.043478f};
const float INV_MAX_SNR_tab[MBANDS_GN_LD] = { .026316f,     .026316f,   .026316f,   .026316f,   .026316f,   .026316f,   .026316f,   .026316f,   .026316f,   .026316f,   .026316f,   .026316f,   .026316f,   .026316f, .026316f,   .026316f,    .043478f,  .043478f,  .043478f,  .043478f};

const float wind_sss[LEN_WIN_SSS] =  /* window for subsampling */
{
    0.080000f, 0.080183f, 0.080730f, 0.081642f, 0.082918f, 0.084557f, 0.086558f, 0.088918f,
    0.091636f, 0.094711f, 0.098139f, 0.101917f, 0.106043f, 0.110514f, 0.115326f, 0.120475f,
    0.125957f, 0.131767f, 0.137902f, 0.144356f, 0.151124f, 0.158200f, 0.165580f, 0.173257f,
    0.181225f, 0.189478f, 0.198009f, 0.206811f, 0.215878f, 0.225203f, 0.234777f, 0.244594f,
    0.254645f, 0.264922f, 0.275418f, 0.286124f, 0.297031f, 0.308132f, 0.319416f, 0.330876f,
    0.342501f, 0.354284f, 0.366213f, 0.378281f, 0.390477f, 0.402792f, 0.415215f, 0.427738f,
    0.440350f, 0.453041f, 0.465801f, 0.478620f, 0.491487f, 0.504393f, 0.517328f, 0.530280f,
    0.543240f, 0.556198f, 0.569142f, 0.582064f, 0.594952f, 0.607796f, 0.620587f, 0.633314f,
    0.645967f, 0.658535f, 0.671009f, 0.683380f, 0.695637f, 0.707770f, 0.719769f, 0.731627f,
    0.743332f, 0.754875f, 0.766248f, 0.777442f, 0.788447f, 0.799255f, 0.809857f, 0.820244f,
    0.830410f, 0.840344f, 0.850041f, 0.859491f, 0.868688f, 0.877623f, 0.886291f, 0.894684f,
    0.902795f, 0.910618f, 0.918147f, 0.925376f, 0.932299f, 0.938911f, 0.945205f, 0.951179f,
    0.956825f, 0.962141f, 0.967122f, 0.971764f, 0.976063f, 0.980016f, 0.983619f, 0.986871f,
    0.989767f, 0.992307f, 0.994488f, 0.996307f, 0.997765f, 0.998859f, 0.999589f, 0.999954f,
    1.000000f, 0.979530f, 0.918958f, 0.820763f, 0.688967f, 0.528964f, 0.347305f, 0.151428f
};

/*----------------------------------------------------------------------------------*
 * Low-pass FIR filter for low-frequency post-filtering @ 8kHz
 * fir1(240,(3900/32000),hanning(241))*5
 *----------------------------------------------------------------------------------*/

const float filter5_39s320_120[121] =
{
    0.609388f,  0.594507f,  0.551181f,  0.483219f,  0.396518f,  0.298448f,  0.197086f,  0.100396f,
    0.015442f, -0.052273f, -0.099277f, -0.124358f, -0.128542f, -0.114820f, -0.087682f, -0.052507f,
    -0.014899f,  0.019957f,  0.047847f,  0.065924f,  0.072906f,  0.069076f,  0.056094f,  0.036651f,
    0.014026f, -0.008391f, -0.027559f, -0.041148f, -0.047793f, -0.047188f, -0.040043f, -0.027903f,
    -0.012866f,  0.002740f,  0.016701f,  0.027204f,  0.033059f,  0.033817f,  0.029768f,  0.021853f,
    0.011477f,  0.000283f, -0.010097f, -0.018267f, -0.023248f, -0.024581f, -0.022354f, -0.017150f,
    -0.009927f, -0.001855f,  0.005864f,  0.012168f,  0.016275f,  0.017775f,  0.016654f,  0.013275f,
    0.008291f,  0.002530f, -0.003131f, -0.007899f, -0.011171f, -0.012604f, -0.012143f, -0.010011f,
    -0.006645f, -0.002628f,  0.001417f,  0.004913f,  0.007412f,  0.008646f,  0.008551f,  0.007261f,
    0.005067f,  0.002364f, -0.000416f, -0.002869f, -0.004678f, -0.005647f, -0.005724f, -0.004986f,
    -0.003623f, -0.001896f, -0.000090f,  0.001528f,  0.002746f,  0.003436f,  0.003559f,  0.003165f,
    0.002373f,  0.001348f,  0.000266f, -0.000708f, -0.001448f, -0.001877f, -0.001978f, -0.001782f,
    -0.001364f, -0.000818f, -0.000247f,  0.000261f,  0.000641f,  0.000858f,  0.000909f,  0.000817f,
    0.000625f,  0.000384f,  0.000142f, -0.000062f, -0.000203f, -0.000274f, -0.000280f, -0.000239f,
    -0.000172f, -0.000099f, -0.000038f,  0.000004f,  0.000024f,  0.000027f,  0.000019f,  0.000009f,
    0.000002f
};

/*----------------------------------------------------------------------------------*
 * LP analysis windows
 *----------------------------------------------------------------------------------*/

/* LP analysis window (length of the window is 25 ms which is 320 samples at 12.8kHz */
const float LP_assym_window[L_LP] =
{
    0.080000f, 0.080065f, 0.080258f, 0.080581f, 0.081033f, 0.081613f, 0.082323f, 0.083160f,
    0.084126f, 0.085220f, 0.086442f, 0.087791f, 0.089267f, 0.090869f, 0.092598f, 0.094452f,
    0.096431f, 0.098535f, 0.100762f, 0.103113f, 0.105587f, 0.108182f, 0.110899f, 0.113736f,
    0.116693f, 0.119769f, 0.122963f, 0.126274f, 0.129701f, 0.133243f, 0.136899f, 0.140668f,
    0.144550f, 0.148543f, 0.152645f, 0.156856f, 0.161175f, 0.165600f, 0.170130f, 0.174764f,
    0.179501f, 0.184339f, 0.189276f, 0.194313f, 0.199446f, 0.204674f, 0.209997f, 0.215413f,
    0.220919f, 0.226516f, 0.232200f, 0.237971f, 0.243826f, 0.249765f, 0.255785f, 0.261884f,
    0.268062f, 0.274317f, 0.280645f, 0.287047f, 0.293520f, 0.300062f, 0.306671f, 0.313345f,
    0.320084f, 0.326884f, 0.333744f, 0.340662f, 0.347635f, 0.354663f, 0.361743f, 0.368873f,
    0.376051f, 0.383274f, 0.390542f, 0.397852f, 0.405202f, 0.412590f, 0.420013f, 0.427470f,
    0.434959f, 0.442477f, 0.450022f, 0.457593f, 0.465187f, 0.472802f, 0.480436f, 0.488086f,
    0.495751f, 0.503429f, 0.511116f, 0.518812f, 0.526514f, 0.534220f, 0.541927f, 0.549634f,
    0.557337f, 0.565037f, 0.572729f, 0.580412f, 0.588083f, 0.595741f, 0.603384f, 0.611008f,
    0.618613f, 0.626195f, 0.633754f, 0.641286f, 0.648790f, 0.656263f, 0.663703f, 0.671109f,
    0.678478f, 0.685808f, 0.693097f, 0.700343f, 0.707544f, 0.714698f, 0.721803f, 0.728857f,
    0.735858f, 0.742804f, 0.749694f, 0.756524f, 0.763293f, 0.770000f, 0.776642f, 0.783218f,
    0.789725f, 0.796163f, 0.802528f, 0.808820f, 0.815036f, 0.821175f, 0.827236f, 0.833215f,
    0.839112f, 0.844925f, 0.850653f, 0.856294f, 0.861845f, 0.867306f, 0.872676f, 0.877952f,
    0.883133f, 0.888218f, 0.893205f, 0.898093f, 0.902880f, 0.907566f, 0.912148f, 0.916626f,
    0.920998f, 0.925263f, 0.929420f, 0.933468f, 0.937405f, 0.941230f, 0.944943f, 0.948543f,
    0.952027f, 0.955396f, 0.958649f, 0.961784f, 0.964800f, 0.967697f, 0.970474f, 0.973131f,
    0.975665f, 0.978078f, 0.980367f, 0.982533f, 0.984574f, 0.986491f, 0.988282f, 0.989948f,
    0.991487f, 0.992900f, 0.994185f, 0.995343f, 0.996373f, 0.997275f, 0.998048f, 0.998693f,
    0.999209f, 0.999597f, 0.999855f, 0.999984f, 0.999967f, 0.999705f, 0.999180f, 0.998393f,
    0.997344f, 0.996035f, 0.994465f, 0.992636f, 0.990548f, 0.988203f, 0.985603f, 0.982748f,
    0.979641f, 0.976282f, 0.972675f, 0.968820f, 0.964721f, 0.960380f, 0.955798f, 0.950980f,
    0.945926f, 0.940641f, 0.935128f, 0.929389f, 0.923427f, 0.917247f, 0.910852f, 0.904245f,
    0.897430f, 0.890410f, 0.883191f, 0.875777f, 0.868170f, 0.860376f, 0.852400f, 0.844245f,
    0.835916f, 0.827419f, 0.818757f, 0.809936f, 0.800962f, 0.791838f, 0.782571f, 0.773165f,
    0.763626f, 0.753960f, 0.744171f, 0.734266f, 0.724250f, 0.714129f, 0.703908f, 0.693594f,
    0.683193f, 0.672709f, 0.662150f, 0.651521f, 0.640828f, 0.630078f, 0.619277f, 0.608430f,
    0.597544f, 0.586626f, 0.575680f, 0.564715f, 0.553735f, 0.542747f, 0.531758f, 0.520774f,
    0.509800f, 0.498844f, 0.487911f, 0.477008f, 0.466141f, 0.455316f, 0.444540f, 0.433818f,
    0.423156f, 0.412561f, 0.402039f, 0.391596f, 0.381237f, 0.370969f, 0.360798f, 0.350728f,
    0.340767f, 0.330920f, 0.321191f, 0.311588f, 0.302115f, 0.292778f, 0.283582f, 0.274532f,
    0.265634f, 0.256892f, 0.248312f, 0.239898f, 0.231656f, 0.223589f, 0.215704f, 0.208003f,
    0.200492f, 0.193174f, 0.186055f, 0.179137f, 0.172426f, 0.165924f, 0.159636f, 0.153564f,
    0.147714f, 0.142087f, 0.136687f, 0.131518f, 0.126582f, 0.121881f, 0.117419f, 0.113199f,
    0.109222f, 0.105491f, 0.102007f, 0.098774f, 0.095793f, 0.093065f, 0.090592f, 0.088376f,
    0.086417f, 0.084718f, 0.083278f, 0.082099f, 0.081181f, 0.080525f, 0.080131f, 0.080000f
};

/* LP analysis window (length of the window is 25ms which is 400 samples at 16kHz */
const float LP_assym_window_16k[L_LP_16k] =
{
    0.080000f, 0.080041f, 0.080165f, 0.080371f, 0.080660f, 0.081032f, 0.081485f, 0.082021f,
    0.082639f, 0.083340f, 0.084122f, 0.084986f, 0.085932f, 0.086959f, 0.088067f, 0.089257f,
    0.090527f, 0.091879f, 0.093310f, 0.094822f, 0.096414f, 0.098085f, 0.099835f, 0.101665f,
    0.103573f, 0.105560f, 0.107624f, 0.109767f, 0.111986f, 0.114282f, 0.116655f, 0.119103f,
    0.121627f, 0.124227f, 0.126901f, 0.129649f, 0.132470f, 0.135365f, 0.138332f, 0.141372f,
    0.144483f, 0.147665f, 0.150917f, 0.154240f, 0.157631f, 0.161091f, 0.164619f, 0.168215f,
    0.171877f, 0.175605f, 0.179399f, 0.183257f, 0.187180f, 0.191166f, 0.195214f, 0.199324f,
    0.203496f, 0.207727f, 0.212019f, 0.216369f, 0.220777f, 0.225243f, 0.229765f, 0.234343f,
    0.238976f, 0.243663f, 0.248402f, 0.253195f, 0.258038f, 0.262933f, 0.267877f, 0.272870f,
    0.277911f, 0.282998f, 0.288132f, 0.293312f, 0.298535f, 0.303802f, 0.309111f, 0.314462f,
    0.319853f, 0.325283f, 0.330753f, 0.336259f, 0.341803f, 0.347382f, 0.352995f, 0.358642f,
    0.364322f, 0.370033f, 0.375774f, 0.381545f, 0.387345f, 0.393172f, 0.399025f, 0.404903f,
    0.410806f, 0.416732f, 0.422680f, 0.428649f, 0.434639f, 0.440647f, 0.446673f, 0.452715f,
    0.458774f, 0.464846f, 0.470933f, 0.477032f, 0.483142f, 0.489262f, 0.495391f, 0.501529f,
    0.507673f, 0.513823f, 0.519978f, 0.526136f, 0.532297f, 0.538459f, 0.544622f, 0.550784f,
    0.556943f, 0.563100f, 0.569253f, 0.575400f, 0.581541f, 0.587674f, 0.593799f, 0.599915f,
    0.606019f, 0.612112f, 0.618192f, 0.624258f, 0.630308f, 0.636343f, 0.642360f, 0.648358f,
    0.654338f, 0.660296f, 0.666234f, 0.672148f, 0.678039f, 0.683905f, 0.689745f, 0.695558f,
    0.701344f, 0.707100f, 0.712827f, 0.718522f, 0.724186f, 0.729816f, 0.735412f, 0.740973f,
    0.746499f, 0.751987f, 0.757437f, 0.762848f, 0.768219f, 0.773549f, 0.778837f, 0.784082f,
    0.789284f, 0.794440f, 0.799551f, 0.804616f, 0.809633f, 0.814601f, 0.819521f, 0.824390f,
    0.829208f, 0.833974f, 0.838688f, 0.843347f, 0.847953f, 0.852503f, 0.856997f, 0.861434f,
    0.865813f, 0.870134f, 0.874396f, 0.878598f, 0.882739f, 0.886818f, 0.890835f, 0.894789f,
    0.898680f, 0.902506f, 0.906267f, 0.909962f, 0.913591f, 0.917153f, 0.920647f, 0.924073f,
    0.927430f, 0.930718f, 0.933935f, 0.937082f, 0.940157f, 0.943160f, 0.946092f, 0.948950f,
    0.951735f, 0.954446f, 0.957082f, 0.959644f, 0.962130f, 0.964541f, 0.966876f, 0.969133f,
    0.971314f, 0.973418f, 0.975443f, 0.977391f, 0.979260f, 0.981050f, 0.982761f, 0.984392f,
    0.985944f, 0.987416f, 0.988807f, 0.990118f, 0.991348f, 0.992497f, 0.993565f, 0.994551f,
    0.995456f, 0.996279f, 0.997021f, 0.997680f, 0.998257f, 0.998752f, 0.999164f, 0.999494f,
    0.999742f, 0.999907f, 0.999990f, 0.999979f, 0.999811f, 0.999476f, 0.998973f, 0.998302f,
    0.997465f, 0.996460f, 0.995289f, 0.993952f, 0.992450f, 0.990782f, 0.988950f, 0.986955f,
    0.984796f, 0.982475f, 0.979993f, 0.977350f, 0.974548f, 0.971587f, 0.968469f, 0.965194f,
    0.961765f, 0.958182f, 0.954446f, 0.950559f, 0.946522f, 0.942337f, 0.938005f, 0.933528f,
    0.928908f, 0.924146f, 0.919243f, 0.914202f, 0.909025f, 0.903713f, 0.898269f, 0.892694f,
    0.886990f, 0.881160f, 0.875205f, 0.869128f, 0.862931f, 0.856617f, 0.850186f, 0.843643f,
    0.836989f, 0.830226f, 0.823358f, 0.816386f, 0.809314f, 0.802143f, 0.794877f, 0.787518f,
    0.780068f, 0.772531f, 0.764909f, 0.757206f, 0.749422f, 0.741563f, 0.733630f, 0.725626f,
    0.717555f, 0.709419f, 0.701221f, 0.692964f, 0.684652f, 0.676287f, 0.667872f, 0.659410f,
    0.650905f, 0.642360f, 0.633777f, 0.625160f, 0.616512f, 0.607835f, 0.599135f, 0.590412f,
    0.581672f, 0.572916f, 0.564148f, 0.555371f, 0.546589f, 0.537804f, 0.529020f, 0.520240f,
    0.511467f, 0.502705f, 0.493956f, 0.485224f, 0.476512f, 0.467823f, 0.459161f, 0.450528f,
    0.441927f, 0.433363f, 0.424837f, 0.416353f, 0.407915f, 0.399524f, 0.391185f, 0.382900f,
    0.374672f, 0.366505f, 0.358401f, 0.350363f, 0.342395f, 0.334498f, 0.326676f, 0.318932f,
    0.311269f, 0.303689f, 0.296196f, 0.288791f, 0.281478f, 0.274259f, 0.267137f, 0.260115f,
    0.253195f, 0.246379f, 0.239670f, 0.233071f, 0.226584f, 0.220211f, 0.213955f, 0.207818f,
    0.201802f, 0.195909f, 0.190142f, 0.184502f, 0.178992f, 0.173614f, 0.168369f, 0.163260f,
    0.158288f, 0.153456f, 0.148764f, 0.144215f, 0.139811f, 0.135552f, 0.131441f, 0.127479f,
    0.123667f, 0.120008f, 0.116501f, 0.113149f, 0.109952f, 0.106913f, 0.104031f, 0.101309f,
    0.098746f, 0.096344f, 0.094104f, 0.092027f, 0.090113f, 0.088363f, 0.086778f, 0.085358f,
    0.084104f, 0.083017f, 0.082096f, 0.081342f, 0.080755f, 0.080336f, 0.080084f, 0.080000f
};

/* LP analysis window for AMR-WB IO mode (length of the window is 30ms which is
 * 384 samples at 12.8kHz */
const float hamcos_window[L_LP_AMR_WB] =
{
    0.080000f, 0.080035f, 0.080139f, 0.080313f, 0.080556f, 0.080869f, 0.081251f, 0.081703f,
    0.082224f, 0.082814f, 0.083473f, 0.084201f, 0.084998f, 0.085864f, 0.086799f, 0.087802f,
    0.088873f, 0.090013f, 0.091221f, 0.092496f, 0.093839f, 0.095250f, 0.096728f, 0.098273f,
    0.099884f, 0.101563f, 0.103307f, 0.105118f, 0.106994f, 0.108936f, 0.110943f, 0.113015f,
    0.115151f, 0.117351f, 0.119616f, 0.121944f, 0.124335f, 0.126789f, 0.129306f, 0.131884f,
    0.134525f, 0.137226f, 0.139989f, 0.142812f, 0.145695f, 0.148638f, 0.151639f, 0.154700f,
    0.157819f, 0.160995f, 0.164229f, 0.167520f, 0.170867f, 0.174270f, 0.177728f, 0.181241f,
    0.184808f, 0.188429f, 0.192103f, 0.195829f, 0.199608f, 0.203438f, 0.207319f, 0.211250f,
    0.215231f, 0.219261f, 0.223340f, 0.227466f, 0.231640f, 0.235860f, 0.240126f, 0.244438f,
    0.248794f, 0.253195f, 0.257638f, 0.262125f, 0.266653f, 0.271223f, 0.275833f, 0.280483f,
    0.285173f, 0.289901f, 0.294667f, 0.299470f, 0.304309f, 0.309184f, 0.314094f, 0.319038f,
    0.324015f, 0.329025f, 0.334067f, 0.339140f, 0.344244f, 0.349377f, 0.354538f, 0.359728f,
    0.364946f, 0.370189f, 0.375458f, 0.380753f, 0.386071f, 0.391412f, 0.396776f, 0.402162f,
    0.407568f, 0.412995f, 0.418441f, 0.423905f, 0.429386f, 0.434885f, 0.440399f, 0.445928f,
    0.451472f, 0.457029f, 0.462598f, 0.468179f, 0.473771f, 0.479373f, 0.484984f, 0.490604f,
    0.496231f, 0.501865f, 0.507504f, 0.513148f, 0.518797f, 0.524448f, 0.530102f, 0.535757f,
    0.541413f, 0.547069f, 0.552724f, 0.558377f, 0.564027f, 0.569673f, 0.575315f, 0.580952f,
    0.586582f, 0.592205f, 0.597821f, 0.603428f, 0.609025f, 0.614611f, 0.620187f, 0.625750f,
    0.631300f, 0.636837f, 0.642359f, 0.647865f, 0.653355f, 0.658828f, 0.664283f, 0.669719f,
    0.675136f, 0.680532f, 0.685907f, 0.691260f, 0.696590f, 0.701896f, 0.707178f, 0.712435f,
    0.717665f, 0.722869f, 0.728045f, 0.733192f, 0.738311f, 0.743399f, 0.748457f, 0.753483f,
    0.758477f, 0.763438f, 0.768365f, 0.773257f, 0.778115f, 0.782936f, 0.787720f, 0.792467f,
    0.797176f, 0.801846f, 0.806477f, 0.811067f, 0.815616f, 0.820124f, 0.824589f, 0.829011f,
    0.833389f, 0.837723f, 0.842012f, 0.846256f, 0.850453f, 0.854603f, 0.858706f, 0.862760f,
    0.866766f, 0.870722f, 0.874628f, 0.878484f, 0.882288f, 0.886041f, 0.889741f, 0.893389f,
    0.896983f, 0.900523f, 0.904009f, 0.907439f, 0.910814f, 0.914133f, 0.917395f, 0.920601f,
    0.923748f, 0.926838f, 0.929869f, 0.932842f, 0.935755f, 0.938608f, 0.941401f, 0.944133f,
    0.946804f, 0.949413f, 0.951961f, 0.954446f, 0.956869f, 0.959229f, 0.961525f, 0.963758f,
    0.965926f, 0.968030f, 0.970070f, 0.972044f, 0.973953f, 0.975796f, 0.977574f, 0.979285f,
    0.980930f, 0.982509f, 0.984020f, 0.985464f, 0.986841f, 0.988151f, 0.989392f, 0.990566f,
    0.991672f, 0.992709f, 0.993678f, 0.994578f, 0.995409f, 0.996172f, 0.996866f, 0.997490f,
    0.998046f, 0.998532f, 0.998949f, 0.999296f, 0.999574f, 0.999783f, 0.999922f, 0.999991f,
    1.000000f, 0.999924f, 0.999698f, 0.999320f, 0.998791f, 0.998111f, 0.997280f, 0.996298f,
    0.995166f, 0.993883f, 0.992450f, 0.990867f, 0.989134f, 0.987252f, 0.985220f, 0.983039f,
    0.980710f, 0.978233f, 0.975607f, 0.972834f, 0.969914f, 0.966848f, 0.963635f, 0.960277f,
    0.956773f, 0.953125f, 0.949332f, 0.945396f, 0.941317f, 0.937096f, 0.932733f, 0.928229f,
    0.923585f, 0.918801f, 0.913879f, 0.908818f, 0.903619f, 0.898284f, 0.892814f, 0.887208f,
    0.881468f, 0.875595f, 0.869589f, 0.863452f, 0.857185f, 0.850788f, 0.844262f, 0.837609f,
    0.830829f, 0.823923f, 0.816893f, 0.809739f, 0.802463f, 0.795066f, 0.787548f, 0.779911f,
    0.772157f, 0.764285f, 0.756298f, 0.748197f, 0.739983f, 0.731657f, 0.723220f, 0.714674f,
    0.706019f, 0.697258f, 0.688392f, 0.679421f, 0.670348f, 0.661174f, 0.651899f, 0.642526f,
    0.633056f, 0.623490f, 0.613830f, 0.604077f, 0.594233f, 0.584299f, 0.574276f, 0.564167f,
    0.553972f, 0.543694f, 0.533333f, 0.522892f, 0.512372f, 0.501774f, 0.491101f, 0.480353f,
    0.469533f, 0.458641f, 0.447680f, 0.436652f, 0.425558f, 0.414399f, 0.403177f, 0.391895f,
    0.380553f, 0.369154f, 0.357699f, 0.346190f, 0.334629f, 0.323017f, 0.311356f, 0.299648f,
    0.287895f, 0.276098f, 0.264260f, 0.252381f, 0.240465f, 0.228512f, 0.216524f, 0.204504f,
    0.192453f, 0.180373f, 0.168265f, 0.156132f, 0.143976f, 0.131797f, 0.119599f, 0.107383f,
    0.095150f, 0.082903f, 0.070644f, 0.058374f, 0.046095f, 0.033809f, 0.021518f, 0.009223f
};


/* LAGW_STRONG */
const float lag_window_8k[17] =
{
    1.0001f,
    0.998890285694f, 0.995568526105f, 0.990056789412f, 0.982391584471f,
    0.972623458067f, 0.960816439805f, 0.947047343167f, 0.931404933402f,
    0.913988974871f, 0.894909172129f, 0.874284020465f, 0.852239582728f,
    0.828908210054f, 0.804427224606f, 0.778937582562f, 0.752582535421f
};

const float lag_window_12k8[NUM_LAGW_STRENGTHS][17] =
{
    /* LAGW_WEAK */
    {
        1.0001f,
        0.999951809733f, 0.999807252867f, 0.999566371195f, 0.999229234349f,
        0.998795939769f, 0.998266612656f, 0.997641405905f, 0.996920500042f,
        0.996104103128f, 0.995192450664f, 0.994185805476f, 0.993084457589f,
        0.991888724088f, 0.990598948965f, 0.989215502956f, 0.987738783362f
    },
    /* LAGW_MEDIUM */
    {
        1.0001f,
        0.999807252867f, 0.999229234349f, 0.998266612656f, 0.996920500042f,
        0.995192450664f, 0.993084457589f, 0.990598948965f, 0.987738783362f,
        0.984507244288f, 0.980908033914f, 0.976945266001f, 0.972623458067f,
        0.967947522806f, 0.962922758784f, 0.957554840431f, 0.951849807369f
    },
    /* LAGW_STRONG */
    {
        1.0001f,
        0.999566371183f, 0.998266612613f, 0.996104103033f, 0.993084457421f,
        0.989215493202f, 0.984507262707f, 0.978971838951f, 0.972623467445f,
        0.965478420258f, 0.957554817200f, 0.948872864246f, 0.939454317093f,
        0.929322779179f, 0.918503403664f, 0.907022833824f, 0.894909143448f
    }
};

const float lag_window_16k[NUM_LAGW_STRENGTHS][17] =
{
    /* LAGW_WEAK */
    {
        1.0001f,
        0.999969157962f, 0.999876637555f, 0.999722455899f, 0.999506641521f,
        0.999229234349f, 0.998890285694f, 0.998489858239f, 0.998028026020f,
        0.997504874399f, 0.996920500042f, 0.996275010885f, 0.995568526105f,
        0.994801176082f, 0.993973102356f, 0.993084457589f, 0.992135405511f
    },
    /* LAGW_MEDIUM */
    {
        1.0001f,
        0.999876637555f, 0.999506641521f, 0.998890285694f, 0.998028026020f,
        0.996920500042f, 0.995568526105f, 0.993973102356f, 0.992135405511f,
        0.990056789412f, 0.987738783362f, 0.985183090250f, 0.982391584471f,
        0.979366309628f, 0.976109476043f, 0.972623458067f, 0.968910791191f
    },
    /* LAGW_STRONG */
    {
        1.0001f,
        0.999722455899f, 0.998890285694f, 0.997504874399f, 0.995568526105f,
        0.993084457589f, 0.990056789412f, 0.986490534533f, 0.982391584471f,
        0.977766693093f, 0.972623458067f, 0.966970300068f, 0.960816439805f,
        0.954171872966f, 0.947047343167f, 0.939454313017f, 0.931404933402f
    }
};

const float lag_window_25k6[NUM_LAGW_STRENGTHS][17] =
{
    /* LAGW_WEAK */
    {
        1.0001f,
        0.999987952216f, 0.999951809733f, 0.999891575166f, 0.999807252867f,
        0.999698848932f, 0.999566371195f, 0.999409829230f, 0.999229234349f,
        0.999024599601f, 0.998795939769f, 0.998543271372f, 0.998266612656f,
        0.997965983599f, 0.997641405905f, 0.997292903003f, 0.996920500042f
    },
    /* LAGW_MEDIUM */
    {
        1.0001f,
        0.999951809733f, 0.999807252867f, 0.999566371195f, 0.999229234349f,
        0.998795939769f, 0.998266612656f, 0.997641405905f, 0.996920500042f,
        0.996104103128f, 0.995192450664f, 0.994185805476f, 0.993084457589f,
        0.991888724088f, 0.990598948965f, 0.989215502956f, 0.987738783362f
    },
    /* LAGW_STRONG */
    {
        1.0001f,
        0.999891579151f, 0.999566376209f, 0.999024569988f, 0.998266637325f,
        0.997292876244f, 0.996104121208f, 0.994700968266f, 0.993084430695f,
        0.991255581379f, 0.989215493202f, 0.986965596676f, 0.984507262707f,
        0.981842100620f, 0.978971838951f, 0.975898265839f, 0.972623467445f
    }
};

const float lag_window_32k[NUM_LAGW_STRENGTHS][17] =
{
    /* LAGW_WEAK */
    {
        1.0001f,
        0.999992289401f, 0.999969157962f, 0.999930606752f, 0.999876637555f,
        0.999807252867f, 0.999722455899f, 0.999622250572f, 0.999506641521f,
        0.999375634094f, 0.999229234349f, 0.999067449055f, 0.998890285694f,
        0.998697752455f, 0.998489858239f, 0.998266612656f, 0.998028026020f
    },
    /* LAGW_MEDIUM */
    {
        1.0001f,
        0.999969157962f, 0.999876637555f, 0.999722455899f, 0.999506641521f,
        0.999229234349f, 0.998890285694f, 0.998489858239f, 0.998028026020f,
        0.997504874399f, 0.996920500042f, 0.996275010885f, 0.995568526105f,
        0.994801176082f, 0.993973102356f, 0.993084457589f, 0.992135405511f
    },
    /* LAGW_STRONG */
    {
        1.0001f,
        0.999930606752f, 0.999722455899f, 0.999375634094f, 0.998890285694f,
        0.998266612656f, 0.997504874399f, 0.996605387628f, 0.995568526105f,
        0.994394720400f, 0.993084457589f, 0.991638280913f, 0.990056789412f,
        0.988340637503f, 0.986490534533f, 0.984507244288f, 0.982391584471f
    }
};

/* LAGW_STRONG */
const float lag_window_48k[17] =
{
    1.0001f,
    0.999969157962f, 0.999876637555f, 0.999722455899f, 0.999506641521f,
    0.999229234349f, 0.998890285694f, 0.998489858239f, 0.998028026020f,
    0.997504874399f, 0.996920500042f, 0.996275010885f, 0.995568526105f,
    0.994801176082f, 0.993973102356f, 0.993084457589f, 0.992135405511f
};


/*----------------------------------------------------------------------------------*
 * LP analysis - grid of points for evaluating Chebyshev polynomials
 *----------------------------------------------------------------------------------*/
const float grid50[(GRID50_POINTS-1)/2 - 1] =
{
    0.9980267284f,   0.9921147013f,   0.9822872507f,   0.9685831611f,   0.9510565163f,
    0.9297764859f,   0.9048270525f,   0.8763066800f,   0.8443279255f,   0.8090169944f,
    0.7705132428f,   0.7289686274f,   0.6845471059f,   0.6374239897f,   0.5877852523f,
    0.5358267950f,   0.4817536741f,   0.4257792916f,   0.3681245527f,   0.3090169944f,
    0.2486898872f,   0.1873813146f,   0.1253332336f,   0.0627905195f
};

const float grid40[(GRID40_POINTS-1)/2 - 1] =
{
    0.9969173337f,   0.9876883406f,   0.9723699204f,   0.9510565163f,   0.9238795325f,
    0.8910065242f,   0.8526401644f,   0.8090169944f,   0.7604059656f,   0.7071067812f,
    0.6494480483f,   0.5877852523f,   0.5224985647f,   0.4539904997f,   0.3826834324f,
    0.3090169944f,   0.2334453639f,   0.1564344650f,   0.0784590957f
};

const float grid100[GRID100_POINTS+1] =
{
    1.0000000000f,  0.9995065331f,  0.9980267286f,  0.9955619574f,  0.9921147227f,
    0.9876883626f,  0.9822872281f,  0.9759167433f,  0.9685831666f,  0.9602936506f,
    0.9510565400f,  0.9408807755f,  0.9297764897f,  0.9177545905f,  0.9048270583f,
    0.8910065293f,  0.8763066530f,  0.8607420325f,  0.8443279266f,  0.8270805478f,
    0.8090170026f,  0.7901549935f,  0.7705132365f,  0.7501110435f,  0.7289685607f,
    0.7071067691f,  0.6845470667f,  0.6613118052f,  0.6374239326f,  0.6129069924f,
    0.5877852440f,  0.5620833635f,  0.5358267426f,  0.5090413690f,  0.4817536175f,
    0.4539904296f,  0.4257791936f,  0.3971477747f,  0.3681245446f,  0.3387379050f,
    0.3090169728f,  0.2789910734f,  0.2486898303f,  0.2181431651f,  0.1873812228f,
    0.1564343721f,  0.1253331155f,  0.0941081867f,  0.0627903789f,  0.0314107276f,
    -0.0000000437f, -0.0314108171f, -0.0627905875f, -0.0941083953f, -0.1253333241f,
    -0.1564345658f, -0.1873814315f, -0.2181433737f, -0.2486900240f, -0.2789911330f,
    -0.3090170324f, -0.3387379944f, -0.3681246340f, -0.3971479833f, -0.4257793725f,
    -0.4539906085f, -0.4817537963f, -0.5090415478f, -0.5358269215f, -0.5620835423f,
    -0.5877854228f, -0.6129072309f, -0.6374241710f, -0.6613120437f, -0.6845472455f,
    -0.7071067691f, -0.7289686203f, -0.7501111031f, -0.7705132961f, -0.7901550531f,
    -0.8090170622f, -0.8270806074f, -0.8443279862f, -0.8607420921f, -0.8763067126f,
    -0.8910065889f, -0.9048271179f, -0.9177547097f, -0.9297765493f, -0.9408808351f,
    -0.9510565996f, -0.9602937698f, -0.9685832262f, -0.9759168029f, -0.9822872877f,
    -0.9876883626f, -0.9921147227f, -0.9955619574f, -0.9980267286f, -0.9995065331f,
    -1.0000000000f
};

/*----------------------------------------------------------------------------------*
 * Sinus & Cosinus - table for the FFT and IFFT of 256 points,
 * dimension of the table = 161
 *----------------------------------------------------------------------------------*/

const float sincos_t[161] =
{
    0.0f,
    0.0245412290096282960f, 0.0490676760673522950f, 0.0735645666718482970f, 0.0980171412229537960f, 0.1224106773734092700f,
    0.1467304676771163900f, 0.1709618866443634000f, 0.1950903236865997300f, 0.2191012352705001800f, 0.2429801821708679200f,
    0.2667127549648284900f, 0.2902846634387970000f, 0.3136817514896392800f, 0.3368898630142211900f, 0.3598950505256652800f,
    0.3826834261417388900f, 0.4052413105964660600f, 0.4275550842285156300f, 0.4496113359928131100f, 0.4713967442512512200f,
    0.4928981959819793700f, 0.5141027569770813000f, 0.5349976420402526900f, 0.5555702447891235400f, 0.5758081674575805700f,
    0.5956993103027343800f, 0.6152315735816955600f, 0.6343932747840881300f, 0.6531728506088256800f, 0.6715589761734008800f,
    0.6895405650138855000f, 0.7071067690849304200f, 0.7242470979690551800f, 0.7409511208534240700f, 0.7572088241577148400f,
    0.7730104327201843300f, 0.7883464097976684600f, 0.8032075166702270500f, 0.8175848126411438000f, 0.8314695954322814900f,
    0.8448535799980163600f, 0.8577286005020141600f, 0.8700869679450988800f, 0.8819212913513183600f, 0.8932242989540100100f,
    0.9039893150329589800f, 0.9142097830772399900f, 0.9238795042037963900f, 0.9329928159713745100f, 0.9415440559387207000f,
    0.9495281577110290500f, 0.9569403529167175300f, 0.9637760519981384300f, 0.9700312614440918000f, 0.9757021069526672400f,
    0.9807852506637573200f, 0.9852776527404785200f, 0.9891765117645263700f, 0.9924795627593994100f, 0.9951847195625305200f,
    0.9972904324531555200f, 0.9987954497337341300f, 0.9996988177299499500f, 1.0000000000000000000f, 0.9996988177299499500f,
    0.9987954497337341300f, 0.9972904324531555200f, 0.9951847195625305200f, 0.9924795627593994100f, 0.9891765117645263700f,
    0.9852776527404785200f, 0.9807852506637573200f, 0.9757021069526672400f, 0.9700312614440918000f, 0.9637760519981384300f,
    0.9569403529167175300f, 0.9495281577110290500f, 0.9415440559387207000f, 0.9329928159713745100f, 0.9238795042037963900f,
    0.9142097830772399900f, 0.9039893150329589800f, 0.8932242989540100100f, 0.8819212913513183600f, 0.8700869679450988800f,
    0.8577286005020141600f, 0.8448535799980163600f, 0.8314695954322814900f, 0.8175848126411438000f, 0.8032075166702270500f,
    0.7883464097976684600f, 0.7730104327201843300f, 0.7572088241577148400f, 0.7409511208534240700f, 0.7242470979690551800f,
    0.7071067690849304200f, 0.6895405650138855000f, 0.6715589761734008800f, 0.6531728506088256800f, 0.6343932747840881300f,
    0.6152315735816955600f, 0.5956993103027343800f, 0.5758081674575805700f, 0.5555702447891235400f, 0.5349976420402526900f,
    0.5141027569770813000f, 0.4928981959819793700f, 0.4713967442512512200f, 0.4496113359928131100f, 0.4275550842285156300f,
    0.4052413105964660600f, 0.3826834261417388900f, 0.3598950505256652800f, 0.3368898630142211900f, 0.3136817514896392800f,
    0.2902846634387970000f, 0.2667127549648284900f, 0.2429801821708679200f, 0.2191012352705001800f, 0.1950903236865997300f,
    0.1709618866443634000f, 0.1467304676771163900f, 0.1224106773734092700f, 0.0980171412229537960f, 0.0735645666718482970f,
    0.0490676723420619960f, 0.0245412290096282960f, -0.00000000041020686847303978f, -0.0245412290096282960f, -0.0490676760673522950f,
    -0.0735645666718482970f, -0.0980171412229537960f, -0.1224106773734092700f, -0.1467304676771163900f, -0.1709618866443634000f,
    -0.1950903236865997300f, -0.2191012352705001800f, -0.2429801821708679200f, -0.2667127549648284900f, -0.2902846634387970000f,
    -0.3136817514896392800f, -0.3368898630142211900f, -0.3598950505256652800f, -0.3826834261417388900f, -0.4052413105964660600f,
    -0.4275550842285156300f, -0.4496113359928131100f, -0.4713967442512512200f, -0.4928981959819793700f, -0.5141027569770813000f,
    -0.5349976420402526900f, -0.5555702447891235400f, -0.5758081674575805700f, -0.5956993103027343800f, -0.6152315735816955600f,
    -0.6343932747840881300f, -0.6531728506088256800f, -0.6715589761734008800f, -0.6895405650138855000f, -0.7071067690849304200f
};

/*----------------------------------------------------------------------------------*
 * Sinus & Cosinus - table for the FFT and IFFT of 1024 points,  value range [0 ... sin(-5pi/4)]
 * dimension of the table = 641=4*256*(5/8)+1
 *----------------------------------------------------------------------------------*/

/*  every 4th value is identical to sincos_t above but as sincos_t is also used in SWB TBE a separate table has been defined here */
const float sincos_t_ext[641] =
{
    0.0f,
    0.006135884649154f, 0.012271538285720f, 0.018406729905805f, 0.024541228522912f, 0.030674803176637f, 0.036807222941359f, 0.042938256934941f, 0.049067674327418f,
    0.055195244349690f, 0.061320736302209f, 0.067443919563664f, 0.073564563599667f, 0.079682437971430f, 0.085797312344440f, 0.091908956497133f, 0.098017140329561f,
    0.104121633872055f, 0.110222207293883f, 0.116318630911905f, 0.122410675199216f, 0.128498110793793f, 0.134580708507126f, 0.140658239332849f, 0.146730474455362f,
    0.152797185258443f, 0.158858143333861f, 0.164913120489970f, 0.170961888760301f, 0.177004220412149f, 0.183039887955141f, 0.189068664149806f, 0.195090322016128f,
    0.201104634842092f, 0.207111376192219f, 0.213110319916091f, 0.219101240156870f, 0.225083911359793f, 0.231058108280671f, 0.237023605994367f, 0.242980179903264f,
    0.248927605745720f, 0.254865659604515f, 0.260794117915276f, 0.266712757474898f, 0.272621355449949f, 0.278519689385053f, 0.284407537211272f, 0.290284677254462f,
    0.296150888243624f, 0.302005949319228f, 0.307849640041535f, 0.313681740398892f, 0.319502030816016f, 0.325310292162263f, 0.331106305759876f, 0.336889853392220f,
    0.342660717311994f, 0.348418680249435f, 0.354163525420490f, 0.359895036534988f, 0.365612997804774f, 0.371317193951837f, 0.377007410216418f, 0.382683432365090f,
    0.388345046698826f, 0.393992040061048f, 0.399624199845647f, 0.405241314004990f, 0.410843171057904f, 0.416429560097637f, 0.422000270799800f, 0.427555093430282f,
    0.433093818853152f, 0.438616238538528f, 0.444122144570429f, 0.449611329654607f, 0.455083587126344f, 0.460538710958240f, 0.465976495767966f, 0.471396736825998f,
    0.476799230063322f, 0.482183772079123f, 0.487550160148436f, 0.492898192229784f, 0.498227666972782f, 0.503538383725718f, 0.508830142543107f, 0.514102744193222f,
    0.519355990165590f, 0.524589682678469f, 0.529803624686295f, 0.534997619887097f, 0.540171472729893f, 0.545324988422046f, 0.550457972936605f, 0.555570233019602f,
    0.560661576197336f, 0.565731810783613f, 0.570780745886967f, 0.575808191417845f, 0.580813958095765f, 0.585797857456439f, 0.590759701858874f, 0.595699304492433f,
    0.600616479383869f, 0.605511041404326f, 0.610382806276309f, 0.615231590580627f, 0.620057211763289f, 0.624859488142386f, 0.629638238914927f, 0.634393284163645f,
    0.639124444863776f, 0.643831542889791f, 0.648514401022112f, 0.653172842953777f, 0.657806693297079f, 0.662415777590172f, 0.666999922303637f, 0.671558954847018f,
    0.676092703575316f, 0.680600997795453f, 0.685083667772700f, 0.689540544737067f, 0.693971460889654f, 0.698376249408973f, 0.702754744457225f, 0.707106781186547f,
    0.711432195745216f, 0.715730825283819f, 0.720002507961382f, 0.724247082951467f, 0.728464390448225f, 0.732654271672413f, 0.736816568877370f, 0.740951125354959f,
    0.745057785441466f, 0.749136394523459f, 0.753186799043613f, 0.757208846506485f, 0.761202385484262f, 0.765167265622459f, 0.769103337645580f, 0.773010453362737f,
    0.776888465673232f, 0.780737228572094f, 0.784556597155575f, 0.788346427626606f, 0.792106577300212f, 0.795836904608884f, 0.799537269107905f, 0.803207531480645f,
    0.806847553543799f, 0.810457198252595f, 0.814036329705948f, 0.817584813151584f, 0.821102514991105f, 0.824589302785025f, 0.828045045257756f, 0.831469612302545f,
    0.834862874986380f, 0.838224705554838f, 0.841554977436898f, 0.844853565249707f, 0.848120344803297f, 0.851355193105265f, 0.854557988365401f, 0.857728610000272f,
    0.860866938637767f, 0.863972856121587f, 0.867046245515693f, 0.870086991108711f, 0.873094978418290f, 0.876070094195407f, 0.879012226428633f, 0.881921264348355f,
    0.884797098430938f, 0.887639620402854f, 0.890448723244758f, 0.893224301195515f, 0.895966249756185f, 0.898674465693954f, 0.901348847046022f, 0.903989293123443f,
    0.906595704514915f, 0.909167983090522f, 0.911706032005430f, 0.914209755703531f, 0.916679059921043f, 0.919113851690058f, 0.921514039342042f, 0.923879532511287f,
    0.926210242138311f, 0.928506080473216f, 0.930766961078984f, 0.932992798834739f, 0.935183509938948f, 0.937339011912575f, 0.939459223602190f, 0.941544065183021f,
    0.943593458161960f, 0.945607325380521f, 0.947585591017741f, 0.949528180593037f, 0.951435020969008f, 0.953306040354194f, 0.955141168305771f, 0.956940335732209f,
    0.958703474895872f, 0.960430519415566f, 0.962121404269042f, 0.963776065795440f, 0.965394441697689f, 0.966976471044852f, 0.968522094274417f, 0.970031253194544f,
    0.971503890986252f, 0.972939952205560f, 0.974339382785576f, 0.975702130038529f, 0.977028142657754f, 0.978317370719628f, 0.979569765685441f, 0.980785280403230f,
    0.981963869109555f, 0.983105487431216f, 0.984210092386929f, 0.985277642388941f, 0.986308097244599f, 0.987301418157858f, 0.988257567730749f, 0.989176509964781f,
    0.990058210262297f, 0.990902635427780f, 0.991709753669100f, 0.992479534598710f, 0.993211949234795f, 0.993906970002356f, 0.994564570734255f, 0.995184726672197f,
    0.995767414467660f, 0.996312612182778f, 0.996820299291166f, 0.997290456678690f, 0.997723066644192f, 0.998118112900149f, 0.998475580573295f, 0.998795456205172f,
    0.999077727752645f, 0.999322384588350f, 0.999529417501093f, 0.999698818696204f, 0.999830581795823f, 0.999924701839145f, 0.999981175282601f, 1.000000000000000f,
    0.999981175282601f, 0.999924701839145f, 0.999830581795823f, 0.999698818696204f, 0.999529417501093f, 0.999322384588350f, 0.999077727752645f, 0.998795456205172f,
    0.998475580573295f, 0.998118112900149f, 0.997723066644192f, 0.997290456678690f, 0.996820299291166f, 0.996312612182778f, 0.995767414467660f, 0.995184726672197f,
    0.994564570734255f, 0.993906970002356f, 0.993211949234795f, 0.992479534598710f, 0.991709753669100f, 0.990902635427780f, 0.990058210262297f, 0.989176509964781f,
    0.988257567730749f, 0.987301418157858f, 0.986308097244599f, 0.985277642388941f, 0.984210092386929f, 0.983105487431216f, 0.981963869109555f, 0.980785280403230f,
    0.979569765685441f, 0.978317370719628f, 0.977028142657754f, 0.975702130038529f, 0.974339382785576f, 0.972939952205560f, 0.971503890986252f, 0.970031253194544f,
    0.968522094274417f, 0.966976471044852f, 0.965394441697689f, 0.963776065795440f, 0.962121404269042f, 0.960430519415566f, 0.958703474895872f, 0.956940335732209f,
    0.955141168305771f, 0.953306040354194f, 0.951435020969008f, 0.949528180593037f, 0.947585591017741f, 0.945607325380521f, 0.943593458161960f, 0.941544065183021f,
    0.939459223602190f, 0.937339011912575f, 0.935183509938948f, 0.932992798834739f, 0.930766961078984f, 0.928506080473216f, 0.926210242138311f, 0.923879532511287f,
    0.921514039342042f, 0.919113851690058f, 0.916679059921043f, 0.914209755703531f, 0.911706032005430f, 0.909167983090522f, 0.906595704514915f, 0.903989293123443f,
    0.901348847046022f, 0.898674465693954f, 0.895966249756185f, 0.893224301195515f, 0.890448723244758f, 0.887639620402854f, 0.884797098430938f, 0.881921264348355f,
    0.879012226428634f, 0.876070094195407f, 0.873094978418290f, 0.870086991108711f, 0.867046245515693f, 0.863972856121587f, 0.860866938637767f, 0.857728610000272f,
    0.854557988365401f, 0.851355193105265f, 0.848120344803297f, 0.844853565249707f, 0.841554977436898f, 0.838224705554838f, 0.834862874986380f, 0.831469612302545f,
    0.828045045257756f, 0.824589302785025f, 0.821102514991105f, 0.817584813151584f, 0.814036329705949f, 0.810457198252595f, 0.806847553543799f, 0.803207531480645f,
    0.799537269107905f, 0.795836904608884f, 0.792106577300212f, 0.788346427626606f, 0.784556597155575f, 0.780737228572095f, 0.776888465673232f, 0.773010453362737f,
    0.769103337645580f, 0.765167265622459f, 0.761202385484262f, 0.757208846506485f, 0.753186799043613f, 0.749136394523459f, 0.745057785441466f, 0.740951125354959f,
    0.736816568877370f, 0.732654271672413f, 0.728464390448225f, 0.724247082951467f, 0.720002507961382f, 0.715730825283819f, 0.711432195745217f, 0.707106781186548f,
    0.702754744457225f, 0.698376249408973f, 0.693971460889654f, 0.689540544737067f, 0.685083667772700f, 0.680600997795453f, 0.676092703575316f, 0.671558954847019f,
    0.666999922303638f, 0.662415777590172f, 0.657806693297079f, 0.653172842953777f, 0.648514401022113f, 0.643831542889791f, 0.639124444863776f, 0.634393284163645f,
    0.629638238914927f, 0.624859488142386f, 0.620057211763289f, 0.615231590580627f, 0.610382806276310f, 0.605511041404326f, 0.600616479383869f, 0.595699304492433f,
    0.590759701858874f, 0.585797857456439f, 0.580813958095765f, 0.575808191417845f, 0.570780745886967f, 0.565731810783613f, 0.560661576197336f, 0.555570233019602f,
    0.550457972936605f, 0.545324988422046f, 0.540171472729893f, 0.534997619887097f, 0.529803624686295f, 0.524589682678469f, 0.519355990165590f, 0.514102744193222f,
    0.508830142543107f, 0.503538383725718f, 0.498227666972782f, 0.492898192229784f, 0.487550160148436f, 0.482183772079123f, 0.476799230063322f, 0.471396736825998f,
    0.465976495767966f, 0.460538710958240f, 0.455083587126344f, 0.449611329654607f, 0.444122144570429f, 0.438616238538528f, 0.433093818853152f, 0.427555093430282f,
    0.422000270799800f, 0.416429560097637f, 0.410843171057904f, 0.405241314004990f, 0.399624199845647f, 0.393992040061048f, 0.388345046698827f, 0.382683432365090f,
    0.377007410216418f, 0.371317193951838f, 0.365612997804774f, 0.359895036534988f, 0.354163525420490f, 0.348418680249435f, 0.342660717311994f, 0.336889853392220f,
    0.331106305759876f, 0.325310292162263f, 0.319502030816016f, 0.313681740398891f, 0.307849640041535f, 0.302005949319228f, 0.296150888243624f, 0.290284677254462f,
    0.284407537211272f, 0.278519689385053f, 0.272621355449949f, 0.266712757474898f, 0.260794117915276f, 0.254865659604515f, 0.248927605745720f, 0.242980179903264f,
    0.237023605994367f, 0.231058108280671f, 0.225083911359793f, 0.219101240156870f, 0.213110319916091f, 0.207111376192219f, 0.201104634842092f, 0.195090322016129f,
    0.189068664149806f, 0.183039887955141f, 0.177004220412149f, 0.170961888760301f, 0.164913120489970f, 0.158858143333861f, 0.152797185258444f, 0.146730474455362f,
    0.140658239332850f, 0.134580708507126f, 0.128498110793793f, 0.122410675199216f, 0.116318630911905f, 0.110222207293883f, 0.104121633872055f, 0.098017140329561f,
    0.091908956497133f, 0.085797312344440f, 0.079682437971430f, 0.073564563599668f, 0.067443919563664f, 0.061320736302208f, 0.055195244349690f, 0.049067674327418f,
    0.042938256934941f, 0.036807222941359f, 0.030674803176637f, 0.024541228522912f, 0.018406729905805f, 0.012271538285720f, 0.006135884649155f, 0.000000000000000f,
    -0.006135884649155f, -0.012271538285720f, -0.018406729905805f, -0.024541228522912f, -0.030674803176637f, -0.036807222941359f, -0.042938256934941f, -0.049067674327418f,
    -0.055195244349690f, -0.061320736302208f, -0.067443919563664f, -0.073564563599667f, -0.079682437971430f, -0.085797312344440f, -0.091908956497133f, -0.098017140329561f,
    -0.104121633872054f, -0.110222207293883f, -0.116318630911904f, -0.122410675199216f, -0.128498110793793f, -0.134580708507126f, -0.140658239332849f, -0.146730474455362f,
    -0.152797185258443f, -0.158858143333861f, -0.164913120489970f, -0.170961888760301f, -0.177004220412149f, -0.183039887955141f, -0.189068664149806f, -0.195090322016128f,
    -0.201104634842092f, -0.207111376192219f, -0.213110319916091f, -0.219101240156870f, -0.225083911359793f, -0.231058108280671f, -0.237023605994367f, -0.242980179903264f,
    -0.248927605745720f, -0.254865659604514f, -0.260794117915276f, -0.266712757474898f, -0.272621355449949f, -0.278519689385053f, -0.284407537211272f, -0.290284677254462f,
    -0.296150888243624f, -0.302005949319228f, -0.307849640041535f, -0.313681740398891f, -0.319502030816016f, -0.325310292162263f, -0.331106305759876f, -0.336889853392220f,
    -0.342660717311994f, -0.348418680249435f, -0.354163525420490f, -0.359895036534988f, -0.365612997804774f, -0.371317193951837f, -0.377007410216418f, -0.382683432365090f,
    -0.388345046698826f, -0.393992040061048f, -0.399624199845647f, -0.405241314004990f, -0.410843171057904f, -0.416429560097637f, -0.422000270799800f, -0.427555093430282f,
    -0.433093818853152f, -0.438616238538527f, -0.444122144570429f, -0.449611329654607f, -0.455083587126344f, -0.460538710958240f, -0.465976495767966f, -0.471396736825998f,
    -0.476799230063322f, -0.482183772079123f, -0.487550160148436f, -0.492898192229784f, -0.498227666972782f, -0.503538383725717f, -0.508830142543107f, -0.514102744193222f,
    -0.519355990165590f, -0.524589682678469f, -0.529803624686295f, -0.534997619887097f, -0.540171472729893f, -0.545324988422046f, -0.550457972936605f, -0.555570233019602f,
    -0.560661576197336f, -0.565731810783613f, -0.570780745886967f, -0.575808191417845f, -0.580813958095764f, -0.585797857456439f, -0.590759701858874f, -0.595699304492433f,
    -0.600616479383869f, -0.605511041404325f, -0.610382806276309f, -0.615231590580627f, -0.620057211763289f, -0.624859488142386f, -0.629638238914927f, -0.634393284163645f,
    -0.639124444863776f, -0.643831542889791f, -0.648514401022112f, -0.653172842953777f, -0.657806693297079f, -0.662415777590172f, -0.666999922303637f, -0.671558954847018f,
    -0.676092703575316f, -0.680600997795453f, -0.685083667772700f, -0.689540544737067f, -0.693971460889654f, -0.698376249408973f, -0.702754744457225f, -0.707106781186547f
};


const float Asr_LP32[41] =
{
    0.00000000f, 0.00074311f, 0.00168152f, 0.00177319f, -0.00000000f, -0.00345938f, -0.00653664f, -0.00604727f,
    0.00000000f, 0.00988729f, 0.01759782f, 0.01556464f, -0.00000000f, -0.02426962f, -0.04321351f, -0.03907450f,
    0.00000000f, 0.07133152f, 0.15563209f, 0.22382514f, 0.25000000f, 0.22382514f, 0.15563209f, 0.07133152f,
    0.00000000f, -0.03907450f, -0.04321351f, -0.02426962f, -0.00000000f, 0.01556464f, 0.01759782f, 0.00988729f,
    0.00000000f, -0.00604727f, -0.00653664f, -0.00345938f, -0.00000000f, 0.00177319f, 0.00168152f, 0.00074311f,
    0.00000000f
};


const float Asr_LP16[21] =
{
    0.00000000f, 0.00336304f, -0.00000000f, -0.01307328f, 0.00000000f, 0.03519564f, -0.00000000f, -0.08642702f,
    0.00000000f, 0.31126418f, 0.50000000f, 0.31126418f, 0.00000000f, -0.08642702f, -0.00000000f, 0.03519564f,
    0.00000000f, -0.01307328f, -0.00000000f, 0.00336304f, 0.00000000f
};


const float Asr_LP48[61] =
{
    0.00000000f, 0.00029287f, 0.00071673f, 0.00112101f, 0.00127506f, 0.00094416f, -0.00000000f, -0.00147233f,
    -0.00311928f, -0.00435776f, -0.00452368f, -0.00310585f, 0.00000000f, 0.00430863f, 0.00872382f, 0.01173188f,
    0.01180048f, 0.00789952f, -0.00000000f, -0.01061594f, -0.02137287f, -0.02880901f, -0.02932326f, -0.02010347f,
    0.00000000f, 0.02990484f, 0.06622310f, 0.10375473f, 0.13646949f, 0.15876038f, 0.16666667f, 0.15876038f,
    0.13646949f, 0.10375473f, 0.06622310f, 0.02990484f, 0.00000000f, -0.02010347f, -0.02932326f, -0.02880901f,
    -0.02137287f, -0.01061594f, -0.00000000f, 0.00789952f, 0.01180048f, 0.01173188f, 0.00872382f, 0.00430863f,
    0.00000000f, -0.00310585f, -0.00452368f, -0.00435776f, -0.00311928f, -0.00147233f, -0.00000000f, 0.00094416f,
    0.00127506f, 0.00112101f, 0.00071673f, 0.00029287f, 0.00000000f
};

const short fft256_read_indexes[]=
{
    0, 128,  64, 192,  32, 160,  96, 224,  16, 144,  80, 208,  48, 176, 112, 240,
    8, 136,  72, 200,  40, 168, 104, 232,  24, 152,  88, 216,  56, 184, 120, 248,
    4, 132,  68, 196,  36, 164, 100, 228,  20, 148,  84, 212,  52, 180, 116, 244,
    12, 140,  76, 204,  44, 172, 108, 236,  28, 156,  92, 220,  60, 188, 124, 252,
    2, 130,  66, 194,  34, 162,  98, 226,  18, 146,  82, 210,  50, 178, 114, 242,
    10, 138,  74, 202,  42, 170, 106, 234,  26, 154,  90, 218,  58, 186, 122, 250,
    6, 134,  70, 198,  38, 166, 102, 230,  22, 150,  86, 214,  54, 182, 118, 246,
    14, 142,  78, 206,  46, 174, 110, 238,  30, 158,  94, 222,  62, 190, 126, 254,
    1, 129,  65, 193,  33, 161,  97, 225,  17, 145,  81, 209,  49, 177, 113, 241,
    9, 137,  73, 201,  41, 169, 105, 233,  25, 153,  89, 217,  57, 185, 121, 249,
    5, 133,  69, 197,  37, 165, 101, 229,  21, 149,  85, 213,  53, 181, 117, 245,
    13, 141,  77, 205,  45, 173, 109, 237,  29, 157,  93, 221,  61, 189, 125, 253,
    3, 131,  67, 195,  35, 163,  99, 227,  19, 147,  83, 211,  51, 179, 115, 243,
    11, 139,  75, 203,  43, 171, 107, 235,  27, 155,  91, 219,  59, 187, 123, 251,
    7, 135,  71, 199,  39, 167, 103, 231,  23, 151,  87, 215,  55, 183, 119, 247,
    15, 143,  79, 207,  47, 175, 111, 239,  31, 159,  95, 223,  63, 191, 127, 255
};


/*----------------------------------------------------------------------------------*
 * Sinus & Cosinus - table for the DCT-IV based 2
 *----------------------------------------------------------------------------------*/

const float sin_table256[] =
{
    0.003067957f, 0.009203755f, 0.015339206f, 0.02147408f, 0.027608146f, 0.033741172f, 0.039872928f, 0.046003182f, 0.052131705f,
    0.058258265f, 0.064382631f, 0.070504573f, 0.076623861f, 0.082740265f, 0.088853553f, 0.094963495f, 0.101069863f, 0.107172425f,
    0.113270952f, 0.119365215f, 0.125454983f, 0.131540029f, 0.137620122f, 0.143695033f, 0.149764535f, 0.155828398f, 0.161886394f,
    0.167938295f, 0.173983873f, 0.180022901f, 0.186055152f, 0.192080397f, 0.198098411f, 0.204108966f, 0.210111837f, 0.216106797f,
    0.222093621f, 0.228072083f, 0.234041959f, 0.240003022f, 0.24595505f, 0.251897818f, 0.257831102f, 0.263754679f, 0.269668326f,
    0.275571819f, 0.281464938f, 0.28734746f, 0.293219163f, 0.299079826f, 0.30492923f, 0.310767153f, 0.316593376f, 0.322407679f,
    0.328209844f, 0.333999651f, 0.339776884f, 0.345541325f, 0.351292756f, 0.357030961f, 0.362755724f, 0.36846683f, 0.374164063f,
    0.379847209f, 0.385516054f, 0.391170384f, 0.396809987f, 0.402434651f, 0.408044163f, 0.413638312f, 0.419216888f, 0.424779681f,
    0.430326481f, 0.43585708f, 0.441371269f, 0.44686884f, 0.452349587f, 0.457813304f, 0.463259784f, 0.468688822f, 0.474100215f,
    0.479493758f, 0.484869248f, 0.490226483f, 0.495565262f, 0.500885383f, 0.506186645f, 0.51146885f, 0.516731799f, 0.521975293f,
    0.527199135f, 0.532403128f, 0.537587076f, 0.542750785f, 0.547894059f, 0.553016706f, 0.558118531f, 0.563199344f, 0.568258953f,
    0.573297167f, 0.578313796f, 0.583308653f, 0.588281548f, 0.593232295f, 0.598160707f, 0.603066599f, 0.607949785f, 0.612810082f,
    0.617647308f, 0.622461279f, 0.627251815f, 0.632018736f, 0.636761861f, 0.641481013f, 0.646176013f, 0.650846685f, 0.655492853f,
    0.660114342f, 0.664710978f, 0.669282588f, 0.673829f, 0.678350043f, 0.682845546f, 0.687315341f, 0.691759258f, 0.696177131f,
    0.700568794f, 0.70493408f, 0.709272826f, 0.713584869f, 0.717870045f, 0.722128194f, 0.726359155f, 0.730562769f, 0.734738878f,
    0.738887324f, 0.743007952f, 0.747100606f, 0.751165132f, 0.755201377f, 0.759209189f, 0.763188417f, 0.767138912f, 0.771060524f,
    0.774953107f, 0.778816512f, 0.782650596f, 0.786455214f, 0.790230221f, 0.793975478f, 0.797690841f, 0.801376172f, 0.805031331f,
    0.808656182f, 0.812250587f, 0.815814411f, 0.81934752f, 0.822849781f, 0.826321063f, 0.829761234f, 0.833170165f, 0.836547727f,
    0.839893794f, 0.84320824f, 0.846490939f, 0.849741768f, 0.852960605f, 0.856147328f, 0.859301818f, 0.862423956f, 0.865513624f,
    0.868570706f, 0.871595087f, 0.874586652f, 0.87754529f, 0.880470889f, 0.883363339f, 0.88622253f, 0.889048356f, 0.891840709f,
    0.894599486f, 0.897324581f, 0.900015892f, 0.902673318f, 0.905296759f, 0.907886116f, 0.910441292f, 0.91296219f, 0.915448716f,
    0.917900776f, 0.920318277f, 0.922701128f, 0.925049241f, 0.927362526f, 0.929640896f, 0.931884266f, 0.93409255f, 0.936265667f,
    0.938403534f, 0.940506071f, 0.942573198f, 0.944604837f, 0.946600913f, 0.94856135f, 0.950486074f, 0.952375013f, 0.954228095f,
    0.956045251f, 0.957826413f, 0.959571513f, 0.961280486f, 0.962953267f, 0.964589793f, 0.966190003f, 0.967753837f, 0.969281235f,
    0.970772141f, 0.972226497f, 0.97364425f, 0.975025345f, 0.976369731f, 0.977677358f, 0.978948175f, 0.980182136f, 0.981379193f,
    0.982539302f, 0.983662419f, 0.984748502f, 0.985797509f, 0.986809402f, 0.987784142f, 0.988721692f, 0.989622017f, 0.990485084f,
    0.99131086f, 0.992099313f, 0.992850414f, 0.993564136f, 0.994240449f, 0.994879331f, 0.995480755f, 0.996044701f, 0.996571146f,
    0.99706007f, 0.997511456f, 0.997925286f, 0.998301545f, 0.998640218f, 0.998941293f, 0.999204759f, 0.999430605f, 0.999618822f,
    0.999769405f, 0.999882347f, 0.999957645f, 0.999995294f
};


/*----------------------------------------------------------------------------------*
 * 1/4 resolution interpolation filter (-3 dB at 0.913*fs/2)
 *----------------------------------------------------------------------------------*/

const float inter4_2[65] =
{
    0.940000f,
    0.856390f,   0.632268f,   0.337560f,   0.059072f,
    -0.131059f,  -0.199393f,  -0.158569f,  -0.056359f,
    0.047606f,   0.106749f,   0.103705f,   0.052062f,
    -0.015182f,  -0.063705f,  -0.073660f,  -0.046497f,
    -0.000983f,   0.038227f,   0.053143f,   0.040059f,
    0.009308f,  -0.021674f,  -0.037767f,  -0.033186f,
    -0.013028f,   0.010702f,   0.025901f,   0.026318f,
    0.013821f,  -0.003645f,  -0.016813f,  -0.019855f,
    -0.012766f,  -0.000530f,   0.010080f,   0.014122f,
    0.010657f,   0.002594f,  -0.005363f,  -0.009344f,
    -0.008101f,  -0.003182f,   0.002330f,   0.005635f,
    0.005562f,   0.002844f,  -0.000627f,  -0.002993f,
    -0.003362f,  -0.002044f,  -0.000116f,   0.001315f,
    0.001692f,   0.001151f,   0.000259f,  -0.000417f,
    -0.000618f,  -0.000434f,  -0.000133f,   0.000063f,
    0.000098f,   0.000048f,   0.000007f,   0.000000f
};


/*----------------------------------------------------------------------------------*
 * 1/6 resolution interpolation filter (-3 dB at 0.95*fs/2)
 *----------------------------------------------------------------------------------*/

const float inter6_2[PIT_FIR_SIZE6_2] =
{
    0.949986374119862F,  0.911081104469830F,  0.800115099292852F,  0.633320673120883F,  0.434558462154083F,  0.231177017786780F,
    0.049378173063717F, -0.090039611811170F, -0.174782560924477F, -0.202477516286360F, -0.180218293244902F, -0.122429229978978F,
    -0.047552067127379F,  0.025733669494145F,  0.081995376731897F,  0.111581381838187F,  0.111781798292302F,  0.086499988914996F,
    0.044629684447068F, -0.002416435594242F, -0.043440027386915F, -0.069857782812169F, -0.077293683967992F, -0.066098268486336F,
    -0.040782649068098F, -0.008590773415008F,  0.022397654632128F,  0.045171360007974F,  0.055274128677739F,  0.051578034020076F,
    0.036232016917169F,  0.013869500422767F, -0.009680698856947F, -0.028843394410080F, -0.039560663181280F, -0.040095747151623F,
    -0.031231107680685F, -0.015866154815425F,  0.001841532922707F,  0.017553701334759F,  0.027778555138199F,  0.030612329573745F,
    0.026046143652186F,  0.015803012695681F,  0.002782973481834F, -0.009720124055079F, -0.018826488463900F, -0.022710487805852F,
    -0.020936374578238F, -0.014436620433404F, -0.005169079181373F,  0.004437651243491F,  0.012100372954920F,  0.016207075406240F,
    0.016135389123271F,  0.012306629559665F,  0.005986734945567F, -0.001094950878591F, -0.007200842219958F, -0.010998212848124F,
    -0.011835179448280F, -0.009826566540474F, -0.005747665080695F, -0.000780600030751F,  0.003810613287985F,  0.006990479233404F,
    0.008174249796791F,  0.007317375965949F,  0.004864690818765F,  0.001587005259212F, -0.001642504305841F, -0.004070609517416F,
    -0.005230670504649F, -0.005019147682711F, -0.003673879223241F, -0.001671460853812F,  0.000420750005150F,  0.002095384947391F,
    0.003020513665060F,  0.003095468528243F,  0.002441025550729F,  0.001335514431569F,  0.000120805384516F, -0.000893340757369F,
    -0.001501610712267F, -0.001636887611783F, -0.001362571776250F, -0.000832126175863F, -0.000232033375863F,  0.000273627139471F,
    0.000582092683087F,  0.000666445711949F,  0.000566088888178F,  0.000360374058147F,  0.000136306914913F, -0.000038864994777F,
    -0.000132755824518F, -0.000148377158880F, -0.000112937171810F, -0.000061132514471F, -0.000019974224468F, -0.000000460344975F,
    0.000001976848453F
};


/*----------------------------------------------------------------------------------*
 * Low-pass FIR filter for low-frequency post-filtering @ 16kHz
 * response : -6dB @ 50Hz, -3dB @ 500Hz, -6dB @ 6.4kHz)
 * L_FILT=15 @ 16kHz (1+4x15=61 coef)
 * L_FILT=12 @ 12.8kHz (1+5x12=61 coef)
 * filter parameters: fs/2=32000, fc=6400, gain=5.0, n=61
 *----------------------------------------------------------------------------------*/

static const float filter_LP12_180H[] =   /* Sincfilt.m: N=180*2+1, Fmin=0, Fmax=1/12, hann( N )' */
{
    1.00000000f,  0.98854064f,  0.95463880f,  0.89969939f,  0.82598609f,  0.73650898f,
    0.63487604f,  0.52511631f,  0.41148461f,  0.29825804f,  0.18953518f,  0.08904855f,
    0.00000000f, -0.07507283f, -0.13439242f, -0.17699551f, -0.20274380f, -0.21229157f,
    -0.20701353f, -0.18889782f, -0.16041129f, -0.12434529f, -0.08365114f, -0.04127482f,
    -0.00000000f,  0.03769212f,  0.06973903f,  0.09458356f,  0.11122751f,  0.11925054f,
    0.11879487f,  0.11051837f,  0.09552022f,  0.07524478f,  0.05137065f,  0.02569204f,
    0.00000000f, -0.02402919f, -0.04493222f, -0.06153821f, -0.07302535f, -0.07895262f,
    -0.07926575f, -0.07427839f, -0.06463103f, -0.05123120f, -0.03517999f, -0.01768990f,
    -0.00000000f,  0.01670619f,  0.03137493f,  0.04314423f,  0.05139005f,  0.05575472f,
    0.05615642f,  0.05278011f,  0.04605151f,  0.03659641f,  0.02518906f,  0.01269314f,
    0.00000000f, -0.01203202f, -0.02263294f, -0.03116789f, -0.03717261f, -0.04037571f,
    -0.04070711f, -0.03829248f, -0.03343501f, -0.02658610f, -0.01830764f, -0.00922872f,
    -0.00000000f,  0.00875109f,  0.01646140f,  0.02266671f,  0.02702792f,  0.02934764f,
    0.02957617f,  0.02780739f,  0.02426498f,  0.01928068f,  0.01326622f,  0.00668131f,
    0.00000000f, -0.00632223f, -0.01187840f, -0.01633509f, -0.01945125f, -0.02108964f,
    -0.02122066f, -0.01991853f, -0.01735069f, -0.01376125f, -0.00945018f, -0.00474975f,
    -0.00000000f,  0.00447492f,  0.00838805f,  0.01150721f,  0.01366775f,  0.01478001f,
    0.01483115f,  0.01388152f,  0.01205626f,  0.00953282f,  0.00652562f,  0.00326903f,
    0.00000000f, -0.00305850f, -0.00571204f, -0.00780638f, -0.00923565f, -0.00994662f,
    -0.00993903f, -0.00926212f, -0.00800799f, -0.00630232f, -0.00429337f, -0.00214002f,
    -0.00000000f,  0.00198116f,  0.00367946f,  0.00499962f,  0.00587975f,  0.00629327f,
    0.00624819f,  0.00578397f,  0.00496633f,  0.00388057f,  0.00262394f,  0.00129781f,
    0.00000000f, -0.00118189f, -0.00217597f, -0.00292996f, -0.00341330f, -0.00361747f,
    -0.00355476f, -0.00325545f, -0.00276400f, -0.00213446f, -0.00142560f, -0.00069606f,
    -0.00000000f,  0.00061651f,  0.00111820f,  0.00148212f,  0.00169815f,  0.00176842f,
    0.00170582f,  0.00153178f,  0.00127370f,  0.00096205f,  0.00062756f,  0.00029879f,
    -0.00000000f, -0.00025029f, -0.00044009f, -0.00056414f, -0.00062342f, -0.00062426f,
    -0.00057701f, -0.00049453f, -0.00039069f, -0.00027889f, -0.00017088f, -0.00007586f,
    -0.00000000f,  0.00005374f,  0.00008534f,  0.00009723f,  0.00009358f,  0.00007948f,
    0.00006013f,  0.00004011f,  0.00002289f,  0.00001046f,  0.00000327f,  0.00000042f,
    0.00000000f
};

static const float filter_LP15_180H[] =   /* Sincfilt.m: N=180*2+1, Fmin=0, Fmax=1/15, hann( N )' */
{
    1.00000000f,  0.99262960f,  0.97071645f,  0.93484826f,  0.88598337f,
    0.82541986f,  0.75475374f,  0.67582786f,  0.59067328f,  0.50144522f,
    0.41035570f,  0.31960540f,  0.23131699f,  0.14747211f,  0.06985439f,
    0.00000000f, -0.06084233f, -0.11174093f, -0.15209937f, -0.18166306f,
    -0.20051411f, -0.20905505f, -0.20798222f, -0.19825005f, -0.18102779f,
    -0.15765038f, -0.12956550f, -0.09827869f, -0.06529875f, -0.03208525f,
    -0.00000000f,  0.02973580f,  0.05607741f,  0.07818439f,  0.09543959f,
    0.10745905f,  0.11409270f,  0.11541631f,  0.11171520f,  0.10346089f,
    0.09128169f,  0.07592875f,  0.05823905f,  0.03909687f,  0.01939543f,
    0.00000000f, -0.01828583f, -0.03474981f, -0.04879543f, -0.05996041f,
    -0.06792872f, -0.07253607f, -0.07376881f, -0.07175666f, -0.06675991f,
    -0.05915169f, -0.04939656f, -0.03802614f, -0.02561328f, -0.01274565f,
    -0.00000000f,  0.01208179f,  0.02301411f,  0.03238554f,  0.03987272f,
    0.04524984f,  0.04839345f,  0.04928266f,  0.04799492f,  0.04469779f,
    0.03963720f,  0.03312292f,  0.02551190f,  0.01719053f,  0.00855630f,
    0.00000000f, -0.00811094f, -0.01544730f, -0.02173055f, -0.02674237f,
    -0.03033123f, -0.03241557f, -0.03298387f, -0.03209149f, -0.02985488f,
    -0.02644325f, -0.02206842f, -0.01697326f, -0.01141932f, -0.00567433f,
    -0.00000000f,  0.00535923f,  0.01018613f,  0.01429886f,  0.01755714f,
    0.01986621f,  0.02117865f,  0.02149380f,  0.02085525f,  0.01934645f,
    0.01708469f,  0.01421394f,  0.01089691f,  0.00730662f,  0.00361802f,
    0.00000000f, -0.00339188f, -0.00642164f, -0.00897788f, -0.01097732f,
    -0.01236693f, -0.01312444f, -0.01325748f, -0.01280137f, -0.01181573f,
    -0.01038024f, -0.00858967f, -0.00654854f, -0.00436567f, -0.00214887f,
    -0.00000000f,  0.00198936f,  0.00374143f,  0.00519494f,  0.00630684f,
    0.00705299f,  0.00742798f,  0.00744401f,  0.00712902f,  0.00652419f,
    0.00568101f,  0.00465798f,  0.00351733f,  0.00232168f,  0.00113102f,
    0.00000000f, -0.00102431f, -0.00190408f, -0.00261180f, -0.00313077f,
    -0.00345499f, -0.00358855f, -0.00354447f, -0.00334328f, -0.00301127f,
    -0.00257862f, -0.00207746f, -0.00154002f, -0.00099694f, -0.00047581f,
    -0.00000000f,  0.00041214f,  0.00074776f,  0.00099963f,  0.00116592f,
    0.00124972f,  0.00125829f,  0.00120217f,  0.00109420f,  0.00094845f,
    0.00077928f,  0.00060035f,  0.00042395f,  0.00026030f,  0.00011724f,
    0.00000000f, -0.00008882f, -0.00014902f, -0.00018252f, -0.00019287f,
    -0.00018476f, -0.00016347f, -0.00013434f, -0.00010230f, -0.00007148f,
    -0.00004496f, -0.00002456f, -0.00001086f, -0.00000332f, -0.00000042f,
    -0.00000000f
};

static const float filter_LP24_90H[] =
{

    0.62500000f,  0.62302684f,  0.61713239f,  0.60739135f,  0.59392688f,
    0.57690853f,  0.55654955f,  0.53310336f,  0.50685949f,  0.47813890f,
    0.44728886f,  0.41467745f,  0.38068777f,  0.34571201f,  0.31014542f,
    0.27438036f,  0.23880054f,  0.20377540f,  0.16965495f,  0.13676502f,
    0.10540301f,  0.07583422f,  0.04828883f,  0.02295955f,  0.00000000f,
    -0.02047625f, -0.03839588f, -0.05372532f, -0.06646962f, -0.07667063f,
    -0.08440465f, -0.08977957f, -0.09293151f, -0.09402116f, -0.09322978f,
    -0.09075508f, -0.08680689f, -0.08160288f, -0.07536433f, -0.06831205f,
    -0.06066245f, -0.05262401f, -0.04439397f, -0.03615555f, -0.02807546f,
    -0.02030199f, -0.01296350f, -0.00616748f, -0.00000000f,  0.00547430f,
    0.01021181f,  0.01418909f,  0.01740171f,  0.01986272f,  0.02160081f,
    0.02265833f,  0.02308912f,  0.02295617f,  0.02232938f,  0.02128318f,
    0.01989437f,  0.01823991f,  0.01639502f,  0.01443144f,  0.01241584f,
    0.01040857f,  0.00846270f,  0.00662323f,  0.00492667f,  0.00340087f,
    0.00206511f,  0.00093039f,  0.00000000f, -0.00072977f, -0.00126877f,
    -0.00163197f, -0.00183843f, -0.00191018f, -0.00187107f, -0.00174574f,
    -0.00155856f, -0.00133271f, -0.00108939f, -0.00084707f, -0.00062106f,
    -0.00042304f, -0.00026095f, -0.00013888f, -0.00005723f, -0.00001296f,
    -0.00000000f, -0.00000000f, -0.00000000f, -0.00000000f, -0.00000000f,
    -0.00000000f,
    -0.00000000f
};


static const float filter_LP3_90H[] =   /* Sincfilt.m: N=90*2+1, Fmin=0, Fmax=1/3, hann( N )' */
{
    1.00000000f,  0.82674145f,  0.41299304f,  0.00000000f, -0.20574231f, -0.16414228f,
    -0.00000000f,  0.11638725f,  0.10137190f,  0.00000000f, -0.08020564f, -0.07244401f,
    -0.00000000f,  0.06039577f,  0.05561375f,  0.00000000f, -0.04776011f, -0.04448829f,
    -0.00000000f,  0.03891245f,  0.03651267f,  0.00000000f, -0.03231551f, -0.03046677f,
    -0.00000000f,  0.02717149f,  0.02569502f,  0.00000000f, -0.02302575f, -0.02181436f,
    -0.00000000f,  0.01960070f,  0.01858630f,  0.00000000f, -0.01671751f, -0.01585488f,
    -0.00000000f,  0.01425599f,  0.01351396f, -0.00000000f, -0.01213249f, -0.01148889f,
    -0.00000000f,  0.01028699f,  0.00972562f,  0.00000000f, -0.00867534f, -0.00818410f,
    -0.00000000f,  0.00726427f,  0.00683387f, -0.00000000f, -0.00602813f, -0.00565135f,
    -0.00000000f,  0.00494677f,  0.00461782f,  0.00000000f, -0.00400399f, -0.00371817f,
    -0.00000000f,  0.00318651f,  0.00293988f, -0.00000000f, -0.00248317f, -0.00227240f,
    -0.00000000f,  0.00188444f,  0.00170665f,  0.00000000f, -0.00138200f, -0.00123460f,
    -0.00000000f,  0.00096839f,  0.00084908f, -0.00000000f, -0.00063685f, -0.00054348f,
    0.00000000f,  0.00038113f,  0.00031171f,  0.00000000f, -0.00019534f, -0.00014798f,
    -0.00000000f,  0.00007391f,  0.00004679f, -0.00000000f, -0.00001145f, -0.00000283f,
    -0.00000000f
};

static const float filter_LP15_360H[] =   /* Sincfilt.m: N=360*2+1, Fmin=0, Fmax=1/15, hann( N )' */
{
    1.00000000f,  0.99268640f,  0.97093867f,  0.93532989f,  0.88679510f,  0.82660196f,  0.75631099f,  0.67772690f,
    0.59284259f,  0.50377777f,  0.41271428f,  0.32183024f,  0.23323527f,  0.14890901f,  0.07064471f,  0.00000000f,
    -0.06174384f, -0.11361280f, -0.15496039f, -0.18547676f, -0.20518652f, -0.21443575f, -0.21386869f, -0.20439528f,
    -0.18715077f, -0.16344917f, -0.13473211f, -0.10251518f, -0.06833357f, -0.03368904f, -0.00000000f,  0.03144362f,
    0.05951924f,  0.08330302f,  0.10209294f,  0.11542293f,  0.12306791f,  0.12503981f,  0.12157498f,  0.11311391f,
    0.10027413f,  0.08381753f,  0.06461370f,  0.04360066f,  0.02174455f,  0.00000000f, -0.02072746f, -0.03961549f,
    -0.05595444f, -0.06917113f, -0.07884629f, -0.08472521f, -0.08672137f, -0.08491313f, -0.07953401f, -0.07095693f,
    -0.05967349f, -0.04626915f, -0.03139548f, -0.01574075f, -0.00000000f,  0.01515402f,  0.02909808f,  0.04128258f,
    0.05125197f,  0.05866038f,  0.06328236f,  0.06501815f,  0.06389360f,  0.06005485f,  0.05375815f,  0.04535547f,
    0.03527650f,  0.02400801f,  0.01207150f,  0.00000000f, -0.01168480f, -0.02249426f, -0.03199250f, -0.03981317f,
    -0.04567293f, -0.04938087f, -0.05084386f, -0.05006752f, -0.04715306f, -0.04229010f, -0.03574599f, -0.02785210f,
    -0.01898788f, -0.00956319f, -0.00000000f,  0.00928603f,  0.01790311f,  0.02549938f,  0.03177686f,  0.03650265f,
    0.03951708f,  0.04073850f,  0.04016462f,  0.03787037f,  0.03400261f,  0.02877179f,  0.02244121f,  0.01531429f,
    0.00772039f,  0.00000000f, -0.00751019f, -0.01449168f, -0.02065736f, -0.02576304f, -0.02961675f, -0.03208568f,
    -0.03310029f, -0.03265561f, -0.03080978f, -0.02767986f, -0.02343523f, -0.01828891f, -0.01248723f, -0.00629832f,
    -0.00000000f,  0.00613249f,  0.01183829f,  0.01688181f,  0.02106227f,  0.02422142f,  0.02624931f,  0.02708778f,
    0.02673160f,  0.02522739f,  0.02267018f,  0.01919813f,  0.01498536f,  0.01023356f,  0.00516248f,  0.00000000f,
    -0.00502795f, -0.00970715f, -0.01384402f, -0.01727353f, -0.01986554f, -0.02152959f, -0.02221779f, -0.02192576f,
    -0.02069173f, -0.01859376f, -0.01574532f, -0.01228947f, -0.00839187f, -0.00423301f, -0.00000000f,  0.00412174f,
    0.00795646f,  0.01134547f,  0.01415358f,  0.01627438f,  0.01763405f,  0.01819377f,  0.01795046f,  0.01693597f,
    0.01521482f,  0.01288044f,  0.01005046f,  0.00686086f,  0.00345963f,  0.00000000f, -0.00336638f, -0.00649597f,
    -0.00925939f, -0.01154665f, -0.01327141f, -0.01437412f, -0.01482390f, -0.01461907f, -0.01378646f, -0.01237944f,
    -0.01047492f, -0.00816931f, -0.00557380f, -0.00280912f, -0.00000000f,  0.00273035f,  0.00526559f,  0.00750113f,
    0.00934836f,  0.01073805f,  0.01162284f,  0.01197870f,  0.01180528f,  0.01112531f,  0.00998290f,  0.00844105f,
    0.00657831f,  0.00448494f,  0.00225863f, -0.00000000f, -0.00219185f, -0.00422367f, -0.00601190f, -0.00748609f,
    -0.00859158f, -0.00929139f, -0.00956735f, -0.00942030f, -0.00886950f, -0.00795125f, -0.00671674f, -0.00522941f,
    -0.00356175f, -0.00179189f, -0.00000000f,  0.00173531f,  0.00334034f,  0.00474942f,  0.00590751f,  0.00677226f,
    0.00731550f,  0.00752400f,  0.00739958f,  0.00695854f,  0.00623048f,  0.00525657f,  0.00408738f,  0.00278032f,
    0.00139692f,  0.00000000f, -0.00134916f, -0.00259345f, -0.00368229f, -0.00457361f, -0.00523547f, -0.00564706f,
    -0.00579926f, -0.00569462f, -0.00534685f, -0.00477983f, -0.00402617f, -0.00312550f, -0.00212248f, -0.00106459f,
    -0.00000000f,  0.00102461f,  0.00196604f,  0.00278637f,  0.00345440f,  0.00394682f,  0.00424892f,  0.00435488f,
    0.00426778f,  0.00399900f,  0.00356752f,  0.00299868f,  0.00232288f,  0.00157398f,  0.00078772f, -0.00000000f,
    -0.00075466f, -0.00144465f, -0.00204251f, -0.00252601f, -0.00287889f, -0.00309135f, -0.00316023f, -0.00308882f,
    -0.00288648f, -0.00256794f, -0.00215242f, -0.00166255f, -0.00112325f, -0.00056046f, -0.00000000f,  0.00053364f,
    0.00101829f,  0.00143502f,  0.00176882f,  0.00200907f,  0.00214985f,  0.00218995f,  0.00213269f,  0.00198558f,
    0.00175975f,  0.00146927f,  0.00113036f,  0.00076058f,  0.00037792f,  0.00000000f, -0.00035672f, -0.00067764f,
    -0.00095057f, -0.00116614f, -0.00131812f, -0.00140347f, -0.00142235f, -0.00137791f, -0.00127596f, -0.00112458f,
    -0.00093361f, -0.00071406f, -0.00047757f, -0.00023583f, -0.00000000f,  0.00021973f,  0.00041459f,  0.00057751f,
    0.00070338f,  0.00078915f,  0.00083382f,  0.00083835f,  0.00080551f,  0.00073960f,  0.00064615f,  0.00053157f,
    0.00040275f,  0.00026674f,  0.00013039f, -0.00000000f, -0.00011891f, -0.00022183f, -0.00030537f, -0.00036737f,
    -0.00040691f, -0.00042423f, -0.00042061f, -0.00039828f, -0.00036014f, -0.00030964f, -0.00025049f, -0.00018648f,
    -0.00012124f, -0.00005812f, -0.00000000f,  0.00005082f,  0.00009265f,  0.00012448f,  0.00014596f,  0.00015731f,
    0.00015929f,  0.00015311f,  0.00014024f,  0.00012237f,  0.00010126f,  0.00007860f,  0.00005596f,  0.00003466f,
    0.00001576f,  0.00000000f, -0.00001220f, -0.00002074f, -0.00002578f, -0.00002769f, -0.00002704f, -0.00002448f,
    -0.00002068f, -0.00001629f, -0.00001190f, -0.00000794f, -0.00000472f, -0.00000238f, -0.00000092f, -0.00000021f,
    -0.00000000f
};

const Resampling_cfg resampling_cfg_tbl[] =
{
    /* fin    fout    up.fact.  filter coefs.         filter length/2 */
    {  8000,  12800,  8,	      filter5_39s320_120,   15,                 RS_INV_FAC  },
    {  12800, 8000,   5,	      filter5_39s320_120,   L_FILT_UP8k,        RS_INV_FAC  },
    {  16000, 8000,   6,	      filter_LP12_180H,     180/6,              0           },
    {  12800, 16000,  15,       filter_LP15_180H,     L_FILT_UP16k,       0           },
    {  12800, 32000,  15,       filter_LP15_180H,     L_FILT_UP32k,       0           },
    {  12800, 48000,  15,       filter_LP15_180H,     L_FILT_UP48k,       0           },

    {  16000, 12800,  12,       filter_LP15_180H,     L_FILT16k,          0           },
    {  16000, 32000,  12,       filter_LP12_180H,     L_FILT16k,          0           },
    {  16000, 48000,  12,       filter_LP12_180H,     L_FILT16k,          0           },

    {  32000, 12800,  6,        filter_LP15_180H,     L_FILT32k,          0           },
    {  32000, 16000,  6,        filter_LP12_180H,     L_FILT32k,          0           },
    {  32000, 25600,  12,       filter_LP15_360H,     L_FILT32k,          0           },
    {  32000, 48000,  3,        filter_LP3_90H,       L_FILT32k,          0           },

    {  48000, 12800,  4,        filter_LP15_180H,     L_FILT48k,          0           },
    {  48000, 16000,  4,        filter_LP12_180H,     L_FILT48k,          0           },
    {  48000, 25600,  8,        filter_LP15_360H,     L_FILT48k,          0           },
    {  48000, 32000,  2,        filter_LP3_90H,       L_FILT48k,          0           },

    /* configs with NB 4kHz low-pass */
    {  16000, 12800,  12,       filter_LP24_90H,     L_FILT16k,           0           },
    {  32000, 12800,  6,        filter_LP24_90H,     L_FILT32k,           0           },
    {  48000, 12800,  4,        filter_LP24_90H,     L_FILT48k,           0           },

    {  0,     0,      0,        0,                    0,                  0           } /* trailing entry (just to calculate the length of this table) */
};

/*----------------------------------------------------------------------------------*
 * LSP interpolation coefficients
 *----------------------------------------------------------------------------------*/

const float interpol_frac_12k8[NB_SUBFR] = { 0.25f, 0.5f, 0.75f, 1.0f };
const float interpol_isp_amr_wb[NB_SUBFR] = { 0.45f, 0.8f, 0.96f, 1.0f };
const float interpol_frac_16k[NB_SUBFR16k] = { 0.2f, 0.4f, 0.6f, 0.8f, 1.0f };

const float interpol_frac_mid[NB_SUBFR*3] = { 0.5f, 0.5f,  0.0f,
                                              0.0f, 1.0f,  0.0f,
                                              0.0f, 0.5f,  0.5f,
                                              0.0f, 0.0f,  1.0f
                                            };

const float interpol_frac_mid_16k[NB_SUBFR16k*3] = { 0.55f, 0.45f, 0.0f,
                                                     0.15f, 0.85f, 0.0f,
                                                     0.0f, 0.75f, 0.25f,
                                                     0.0f, 0.35f, 0.65f,
                                                     0.0f, 0.0f, 1.0f
                                                   };

const float  interpol_frac_mid_relaxprev_12k8[NB_SUBFR*3] = { 0.0f, 0.7f, 0.3f,
                                                              0.0f, 0.0f, 1.0f,
                                                              0.0f, 0.0f, 1.0f,
                                                              0.0f, 0.0f, 1.0f
                                                            };

const float interpol_frac_mid_FEC[NB_SUBFR*3] = { 0.25f, 0.55f, 0.20f,
                                                  0.00f, 0.70f, 0.30f,
                                                  0.00f, 0.45f, 0.55f,
                                                  0.00f, 0.00f, 1.00f
                                                };

const float interpol_frac_mid_relaxprev_pred_12k8[NB_SUBFR*3] = { 0.15f, 0.70f, 0.15f,
                                                                  0.05f, 0.65f, 0.30f,
                                                                  0.00f, 0.50f, 0.50f,
                                                                  0.00f, 0.0f,  1.00f
                                                                };

const float interpol_frac_mid_relaxprev_16k[NB_SUBFR16k*3] = { 0.0f, 0.7f, 0.3f,
                                                               0.0f, 0.0f, 1.0f,
                                                               0.0f, 0.0f, 1.0f,
                                                               0.0f, 0.0f, 1.0f,
                                                               0.0f, 0.0f, 1.0f
                                                             };

const float interpol_frac_mid_16k_FEC[NB_SUBFR16k*3] = { 0.4f, 0.40f, 0.2f,
                                                         0.0f, 0.80f, 0.20f,
                                                         0.0f, 0.65f, 0.35f,
                                                         0.0f, 0.15f, 0.85f,
                                                         0.0f, 0.00f, 1.00f
                                                       };

const float interpol_frac_mid_relaxprev_pred_16k[NB_SUBFR16k*3] = { 0.15f, 0.70f, 0.15f,
                                                                    0.05f, 0.65f, 0.30f,
                                                                    0.00f, 0.50f, 0.50f,
                                                                    0.00f, 0.15f, 0.85f,
                                                                    0.00f, 0.0f,  1.00f
                                                                  };

/*----------------------------------------------------------------------------------*
 * Innovative codebook
 *----------------------------------------------------------------------------------*/

/* Innovative codebook config */
const PulseConfig PulseConfTable[] =
{
    /* Design rules:
     * ---> "fixed" + "tried-pair-pos"*2 = pulses & 0xfe
     * ---> tracks with pulses % 3 == 0, have always TRACKPOS_FIXED_FIRST */
    /* bits,iter,alp,pulses,fixed,tried-pair-pos,codetrack */
    {  7, 4,  2.0f,  1, 0, {8}, TRACKPOS_FREE_ONE },                             /*  7 bits,  1 pulses, 4 tracks, 1000 free track */
    { 10, 4,  2.0f,  2, 0, {8}, TRACKPOS_FIXED_EVEN },                           /* 10 bits,  2 pulses, 4 tracks  1010 (used only even tracks designed for NB) */
    { 12, 4,  2.0f,  2, 0, {8}, TRACKPOS_FIXED_TWO },                            /* 12 bits,  2 pulses, 2 tracks  11 used all tracks ala AMR-WB 6.6 */
    { 15, 4,  2.0f,  3, 0, {8}, TRACKPOS_FIXED_FIRST },                            /* 15 bits,  3 pulses, 4 tracks  1110 fixed track to first  ? */
    { 17, 6,  2.0f,  3, 0, {8}, TRACKPOS_FREE_THREE },                             /* 17 bits,  3 pulses, 4 tracks  (used all tracks) - 1110, 1101, 1011, 0111 */
    { 20, 4,  2.0f,  4, 0, {4, 8}, TRACKPOS_FIXED_FIRST },                         /* 20 bits,  4 pulses, 4 tracks  1111 */
    { 24, 4,  2.0f,  5, 0, {4, 8}, TRACKPOS_FIXED_FIRST },                         /* 24 bits,  5 pulses, 4 tracks  2111 fixed track to first */
    { 26, 4,  2.0f,  5, 0, {4, 8}, TRACKPOS_FREE_ONE },                            /* 26 bits,  5 pulses, 4 tracks  2111 one free track ? */
    { 28, 4,  1.5f,  6, 0, {4, 8, 8}, TRACKPOS_FIXED_FIRST },                      /* 28 bits,  6 pulses, 4 tracks  2211 */
    { 30, 4,  1.5f,  6, 0, {4, 8, 8}, TRACKPOS_FIXED_TWO },                        /* 30 bits,  6 pulses, 4 tracks  2211 free consecutive track positions ? */
    { 32, 4,  1.5f,  7, 0, {4, 8, 8}, TRACKPOS_FIXED_FIRST },                      /* 32 bits,  6 pulses, 4 tracks  2221 fixed ?*/
    { 34, 4,  1.5f,  7, 0, {4, 8, 8}, TRACKPOS_FREE_THREE },                       /* 34 bits,  6 pulses, 4 tracks  2221 free track positions ? */
    { 36, 4,  1.0f,  8, 2, {4, 8, 8}, TRACKPOS_FIXED_FIRST },                      /* 36 bits,  8 pulses, 4 tracks  2222 */
    { 40, 4,  1.0f,  9, 2, {4, 8, 8}, TRACKPOS_FIXED_FIRST },                      /* 40 bits,  9 pulses, 4 tracks  3222 fixed ?*/
    { 43, 4,  1.0f, 10, 2, {4, 6, 8, 8}, TRACKPOS_FIXED_FIRST },                   /* 44 bits, 10 pulses, 4 tracks  3322 */
    { 46, 4,  1.0f, 10, 2, {4, 6, 8, 8}, TRACKPOS_FIXED_TWO },                     /* 46 bits, 10 pulses, 4 tracks  3322 free consecutive tracks ? */
    { 47, 4,  1.0f, 11, 2, {4, 6, 8, 8}, TRACKPOS_FIXED_FIRST },                   /* 47 bits, 10 pulses, 4 tracks  3332 fixed ? */
    { 49, 4,  1.0f, 11, 2, {4, 6, 8, 8}, TRACKPOS_FREE_THREE },                    /* 49 bits, 10 pulses, 4 tracks  3332 free three track positions ? */
    { 50, 4,  1.0f, 12, 4, {4, 6, 8, 8}, TRACKPOS_FIXED_FIRST },                   /* 50 bits, 12 pulses, 4 tracks  3333 */
    { 53, 4,  1.0f, 13, 4, {4, 6, 8, 8}, TRACKPOS_FIXED_FIRST },                   /* 53 bits, 13 pulses, 4 tracks  4333 fixed ? */
    { 55, 4,  1.0f, 13, 4, {4, 6, 8, 8}, TRACKPOS_FREE_ONE },                      /* 55 bits, 13 pulses, 4 tracks  4333 free one ? */
    { 56, 4,  1.0f, 14, 4, {4, 6, 6, 8, 8}, TRACKPOS_FIXED_FIRST },                   /* 56 bits, 14 pulses, 4 tracks  4433 fixed ?!?! */
    { 58, 4,  1.0f, 14, 4, {4, 6, 6, 8, 8}, TRACKPOS_FIXED_TWO },                     /* 58 bits, 14 pulses, 4 tracks  4433 free consecutive ? */
    { 59, 4,  1.0f, 15, 4, {4, 6, 6, 8, 8}, TRACKPOS_FIXED_FIRST },                   /* 59 bits, 15 pulses, 4 tracks  4443 fixed ? */
    { 61, 4,  1.0f, 15, 4, {4, 6, 6, 8, 8}, TRACKPOS_FREE_THREE },                    /* 61 bits, 15 pulses, 4 tracks  4443 free ? */
    { 62, 3,  0.8f, 16, 4, {4, 4, 6, 6, 8, 8}, TRACKPOS_FIXED_FIRST },             /* 62 bits, 16 pulses, 4 tracks  4444 */
    { 65, 3,  0.8f, 17, 4, {4, 4, 6, 6, 8, 8}, TRACKPOS_FIXED_FIRST },             /* 65 bits, 17 pulses, 4 tracks  5444 fixed ?*/
    { 68, 3, 0.75f, 18, 4, {2, 3, 4, 5, 6, 7, 8}, TRACKPOS_FIXED_FIRST },          /* 68 bits, 18 pulses, 4 tracks  5544 */
    { 70, 3, 0.75f, 19, 4, {2, 3, 4, 5, 6, 7, 8}, TRACKPOS_FIXED_FIRST },          /* 70 bits, 19 pulses, 4 tracks  5554 fixed ? */
    { 73, 3, 0.75f, 20, 4, {2, 3, 4, 5, 6, 7, 8, 8}, TRACKPOS_FIXED_FIRST },          /* 73 bits, 20 pulses, 4 tracks  5555 fixed ? */
    { 75, 3, 0.75f, 21, 4, {2, 3, 4, 5, 6, 7, 8, 8}, TRACKPOS_FIXED_FIRST },          /* 75 bits, 21 pulses, 4 tracks  6555 fixed ? */
    { 78, 3, 0.75f, 22, 4, {2, 3, 4, 5, 6, 7, 8, 8, 8}, TRACKPOS_FIXED_FIRST },          /* 78 bits, 22 pulses, 4 tracks  6655 fixed ? */
    { 80, 3, 0.75f, 23, 4, {2, 3, 4, 5, 6, 7, 8, 8, 8}, TRACKPOS_FIXED_FIRST },          /* 80 bits, 23 pulses, 4 tracks  6665 fixed ? */
    { 83, 2, 0.30f, 24, 4, {2, 3, 4, 5, 6, 7, 8, 8, 8, 8}, TRACKPOS_FIXED_FIRST},  /* 83 bits, 24 pulses, 4 tracks  6666 */
    { 85, 2, 0.30f, 25, 4, {2, 3, 4, 5, 6, 7, 8, 8, 8, 8}, TRACKPOS_FIXED_FIRST},  /* 85 bits, 25 pulses, 4 tracks  7666 */
    { 87, 2, 0.25f, 26, 4, {2, 3, 4, 5, 6, 7, 8, 8, 8, 8, 8}, TRACKPOS_FIXED_FIRST},  /* 87 bits, 26 pulses, 4 tracks  7766 */
    { 89, 2, 0.25f, 27, 4, {2, 3, 4, 5, 6, 7, 8, 8, 8, 8, 8}, TRACKPOS_FIXED_FIRST},  /* 89 bits, 27 pulses, 4 tracks  7776 */
    { 92, 2, 0.25f, 28, 4, {2, 3, 4, 5, 6, 7, 8, 8, 8, 8, 8, 8}, TRACKPOS_FIXED_FIRST},  /* 92 bits, 28 pulses, 4 tracks  7777 */
    { 94, 2, 0.25f, 29, 4, {2, 3, 4, 5, 6, 7, 8, 8, 8, 8, 8, 8}, TRACKPOS_FIXED_FIRST},  /* 94 bits, 29 pulses, 4 tracks  8777 */
    { 96, 1, 0.20f, 30, 4, {2, 3, 4, 5, 6, 7, 8, 8, 8, 8, 8, 8, 8}, TRACKPOS_FIXED_FIRST},  /* 96 bits, 30 pulses, 4 tracks  8877 */
    { 98, 1, 0.20f, 31, 4, {2, 3, 4, 5, 6, 7, 8, 8, 8, 8, 8, 8, 8}, TRACKPOS_FIXED_FIRST},  /* 98 bits, 31 pulses, 4 tracks  8887 */
};


/* Number of pulses & positions to the number of unique states that can be achieved with those pulses */
const long unsigned pulsestostates[17][9] =
{
    {    0,           0,           0,           0,           0,           0,       0,           0,           0},
    {    2,           2,           2,           2,           2,           2,       2,           2,           2},
    {    4,           8,          12,          16,          20,          24,      28,          32,          36},
    {    6,          18,          38,          66,         102,         146,     198,         258,         326},
    {    8,          32,          88,         192,         360,         608,     952,        1408,        1992},
    {   10,          50,         170,         450,        1002,        1970,    3530,        5890,        9290},
    {   12,          72,         292,         912,        2364,        5336,   10836,       20256,       35436},
    {   14,          98,         462,        1666,        4942,       12642,   28814,       59906,      115598},
    {   16,         128,         688,        2816,        9424,       27008,   68464,      157184,      332688},
    {   18,         162,         978,        4482,       16722,       53154,  148626,      374274,      864146},
    {   20,         200,        1340,        6800,       28004,       97880,  299660,      822560,     2060980},
    {   22,         242,        1782,        9922,       44726,      170610,  568150,     1690370,     4573910},
    {   24,         288,        2312,       14016,       68664,      284000, 1022760,     3281280,     9545560},
    {   26,         338,        2938,       19266,      101946,      454610, 1761370,     6065410,    18892250},
    {   28,         392,        3668,       25872,      147084,      703640, 2919620,    10746400,    35704060},
    {   30,         450,        4510,       34050,      207006,     1057730, 4680990,    18347010,    64797470},
    {   32,         512,        5472,       44032,      285088,     1549824, 7288544,    30316544,   113461024},
};

/*----------------------------------------------------------------------------------*
 * Gain quantization table for memory-less gain quantizer
 *----------------------------------------------------------------------------------*/

const float gain_qua_mless_7b[128*2] =
{
    0.0256f,    0.0555f,
    0.0915f,    1.1847f,
    0.0968f,    0.6282f,
    0.0996f,    0.2821f,
    0.1029f,    0.4465f,
    0.1065f,    0.9677f,
    0.1332f,    0.7997f,
    0.1535f,    1.3985f,
    0.1692f,    1.6101f,
    0.1873f,    2.0886f,
    0.1960f,    1.8291f,
    0.1964f,    0.1732f,
    0.2122f,    2.4304f,
    0.2292f,    0.5306f,
    0.2359f,    1.0716f,
    0.2369f,    0.6796f,
    0.2546f,    0.3544f,
    0.2694f,    1.2247f,
    0.2697f,    0.9217f,
    0.2996f,    2.7903f,
    0.3197f,    0.7881f,
    0.3199f,    3.2249f,
    0.3492f,    0.1667f,
    0.3560f,    0.4883f,
    0.3568f,    1.3541f,
    0.3599f,    0.6346f,
    0.3684f,    1.0620f,
    0.3716f,    1.5223f,
    0.3942f,    3.6890f,
    0.4059f,    0.3064f,
    0.4076f,    0.9021f,
    0.4149f,    1.7170f,
    0.4225f,    1.9400f,
    0.4229f,    2.2074f,
    0.4487f,    1.2106f,
    0.4554f,    0.7548f,
    0.4800f,    0.4531f,
    0.4882f,    0.6140f,
    0.4966f,    1.0464f,
    0.5126f,    1.3905f,
    0.5298f,    0.8967f,
    0.5369f,    2.4926f,
    0.5521f,    1.5735f,
    0.5614f,    0.1682f,
    0.5758f,    0.7770f,
    0.5939f,    1.1468f,
    0.5942f,    0.5222f,
    0.5946f,    0.3409f,
    0.6053f,    1.7908f,
    0.6129f,    0.9937f,
    0.6136f,    1.2784f,
    0.6184f,    2.0111f,
    0.6249f,    0.6626f,
    0.6527f,    3.0463f,
    0.6602f,    0.8724f,
    0.6692f,    1.4121f,
    0.6961f,    2.2440f,
    0.7035f,    1.0724f,
    0.7069f,    0.7548f,
    0.7081f,    1.5445f,
    0.7091f,    0.5579f,
    0.7253f,    1.6832f,
    0.7296f,    1.1850f,
    0.7359f,    0.4175f,
    0.7388f,    0.9680f,
    0.7428f,    2.7283f,
    0.7591f,    1.3040f,
    0.7700f,    0.6550f,
    0.7732f,    1.8595f,
    0.7742f,    0.8500f,
    0.7924f,    0.2178f,
    0.8078f,    1.4486f,
    0.8178f,    1.0725f,
    0.8255f,    0.7421f,
    0.8256f,    0.5278f,
    0.8316f,    2.0390f,
    0.8382f,    0.9422f,
    0.8435f,    1.2053f,
    0.8567f,    1.5952f,
    0.8570f,    2.4549f,
    0.8725f,    0.8299f,
    0.8756f,    1.3365f,
    0.8769f,    0.6222f,
    0.8799f,    0.3881f,
    0.8938f,    1.7540f,
    0.9121f,    1.0122f,
    0.9210f,    0.7117f,
    0.9249f,    1.1285f,
    0.9344f,    0.9022f,
    0.9375f,    3.7762f,
    0.9376f,    1.4769f,
    0.9388f,    0.5124f,
    0.9501f,    2.2014f,
    0.9582f,    1.2478f,
    0.9646f,    0.8003f,
    0.9815f,    0.6165f,
    0.9864f,    1.9390f,
    0.9985f,    1.3694f,
    1.0041f,    1.6163f,
    1.0071f,    1.0599f,
    1.0095f,    0.9596f,
    1.0142f,    3.3774f,
    1.0150f,    0.3827f,
    1.0223f,    0.7201f,
    1.0351f,    2.9891f,
    1.0393f,    0.8629f,
    1.0461f,    1.1773f,
    1.0601f,    1.7548f,
    1.0616f,    0.5225f,
    1.0969f,    1.4899f,
    1.0977f,    2.6574f,
    1.0996f,    0.6500f,
    1.1006f,    1.3029f,
    1.1129f,    0.7923f,
    1.1151f,    0.2047f,
    1.1169f,    1.0829f,
    1.1195f,    0.9526f,
    1.1442f,    2.3570f,
    1.1613f,    2.0960f,
    1.1920f,    0.4212f,
    1.1942f,    1.8806f,
    1.2055f,    1.6309f,
    1.2081f,    1.2005f,
    1.2091f,    0.5825f,
    1.2200f,    1.3871f,
    1.2201f,    0.8762f,
    1.2210f,    0.7314f,
    1.2298f,    1.0376f
};

const float gain_qua_mless_6b[64*2] =
{
    0.1023f,    0.1385f,
    0.1299f,    0.3865f,
    0.1415f,    0.9587f,
    0.1433f,    0.6630f,
    0.1708f,    1.2210f,
    0.1766f,    1.5334f,
    0.2387f,    2.1457f,
    0.2917f,    0.4762f,
    0.2918f,    0.8337f,
    0.3122f,    1.8254f,
    0.3231f,    2.9468f,
    0.3520f,    0.2219f,
    0.3673f,    1.0612f,
    0.3755f,    0.6540f,
    0.3787f,    1.3191f,
    0.3805f,    3.5578f,
    0.4114f,    2.4443f,
    0.4293f,    1.5662f,
    0.4750f,    0.8475f,
    0.4886f,    0.4489f,
    0.5635f,    1.2143f,
    0.5699f,    0.6556f,
    0.5730f,    1.0155f,
    0.5963f,    2.0279f,
    0.6021f,    1.4337f,
    0.6240f,    1.7159f,
    0.6480f,    0.2310f,
    0.6577f,    0.8326f,
    0.7030f,    0.4858f,
    0.7146f,    2.7331f,
    0.7351f,    1.1471f,
    0.7489f,    0.9787f,
    0.7493f,    0.6800f,
    0.7628f,    1.3365f,
    0.7947f,    1.5351f,
    0.7994f,    2.3357f,
    0.8258f,    0.8233f,
    0.8434f,    1.7918f,
    0.8620f,    0.5667f,
    0.8850f,    2.0286f,
    0.8873f,    1.2422f,
    0.8933f,    1.0855f,
    0.8952f,    0.9457f,
    0.9113f,    0.7066f,
    0.9189f,    0.4096f,
    0.9554f,    3.1133f,
    0.9662f,    3.6596f,
    0.9685f,    1.4001f,
    0.9703f,    1.6178f,
    0.9859f,    0.8469f,
    1.0095f,    0.5734f,
    1.0299f,    1.1866f,
    1.0337f,    1.0014f,
    1.0487f,    0.7284f,
    1.0769f,    2.6107f,
    1.0801f,    0.2455f,
    1.1195f,    2.1906f,
    1.1268f,    1.8445f,
    1.1591f,    0.4730f,
    1.1666f,    1.5523f,
    1.1711f,    1.3167f,
    1.1753f,    0.8763f,
    1.1893f,    1.0872f,
    1.1911f,    0.6722f
};

const float gain_qua_mless_5b[32*2] =
{
    0.1645f,    0.2137f,
    0.2102f,    0.5295f,
    0.2154f,    0.8448f,
    0.2615f,    1.5636f,
    0.2664f,    1.1856f,
    0.3012f,    2.1266f,
    0.4209f,    2.7473f,
    0.4713f,    0.6328f,
    0.4830f,    0.2861f,
    0.4938f,    0.9146f,
    0.5523f,    1.7829f,
    0.5798f,    1.1716f,
    0.6039f,    1.4473f,
    0.6068f,    3.5936f,
    0.7267f,    0.7460f,
    0.7329f,    2.1548f,
    0.7537f,    0.4738f,
    0.7586f,    0.9788f,
    0.8354f,    1.2308f,
    0.8529f,    1.7499f,
    0.8856f,    1.4611f,
    0.9253f,    0.6280f,
    0.9414f,    0.8362f,
    0.9570f,    1.0559f,
    0.9663f,    3.0746f,
    0.9765f,    2.5027f,
    1.0512f,    0.4129f,
    1.0815f,    2.0090f,
    1.1099f,    1.2670f,
    1.1250f,    1.5985f,
    1.1376f,    0.6895f,
    1.1529f,    0.9632f
};

const short E_ROM_qua_gain5b_const[NB_QUA_GAIN5B * 2]=
{
    1774,577,
    2090,1805,
    2103,3371,
    3908,1116,
    4834,2500,
    6030,4763,
    6838,1334,
    7490,2033,
    8585,3036,
    9845,1575,
    10437,2320,
    10649,3739,
    11298,945,
    12108,1920,
    12310,5108,
    12391,2758,
    12659,1237,
    13729,1557,
    13798,2201,
    13972,3275,
    14881,993,
    15175,1776,
    15409,16190,
    15551,2395,
    15879,4048,
    16341,1335,
    16988,2918,
    18317,7449,
    18368,2026,
    19114,1364,
    19991,4472,
    20644,2790,
};

const Word16 E_ROM_qua_gain6b_const[NB_QUA_GAIN6B * 2] =
{
    0,2758,
    143,3562,
    397,2146,
    544,4306,
    952,1726,
    1236,724,
    1779,3158,
    1820,5448,
    1975,2473,
    2121,1343,
    3049,3912,
    3081,1885,
    3289,8261,
    3416,2843,
    3495,2204,
    3831,3386,
    4295,4590,
    4300,2476,
    4345,1545,
    4913,1122,
    5198,2080,
    5200,3079,
    5448,3714,
    5482,2689,
    5546,1817,
    5783,17318,
    5934,6236,
    6156,2320,
    6481,4225,
    6828,3351,
    6832,5045,
    6888,2895,
    7186,2559,
    7214,1663,
    7373,2052,
    7906,3819,
    8192,1372,
    8452,3063,
    8464,2354,
    9021,4468,
    9037,2715,
    9175,1874,
    9219,3463,
    9831,2155,
    10523,5383,
    10557,9061,
    10618,3093,
    10633,3949,
    10890,2465,
    11141,1654,
    12132,2790,
    12180,3477,
    12376,2079,
    12494,4560,
    14430,2468,
    14573,3914,
    14576,3111,
    15043,1827,
    15207,1329,
    16073,6155,
    17519,4719,
    18345,2148,
    18554,2784,
    18576,3563,
};

const short E_ROM_qua_gain7b_const[NB_QUA_GAIN7B * 2] =
{
    123,2777,
    369,2102,
    404,4368,
    693,3486,
    1107,719,
    1222,1679,
    1657,1293,
    1667,5547,
    1805,2425,
    2369,3075,
    2489,12063,
    2681,1901,
    2693,3984,
    3031,7547,
    3248,990,
    3466,2672,
    3674,2165,
    3718,1513,
    3844,3456,
    4120,4656,
    4748,2967,
    4821,19622,
    4855,2400,
    4912,1776,
    5245,3860,
    5312,6282,
    5500,1176,
    5713,2056,
    5872,3287,
    5960,2662,
    6170,9756,
    6364,5021,
    6545,1476,
    6788,2283,
    6796,4163,
    7038,2949,
    7216,1831,
    7274,3516,
    7707,2510,
    8123,5762,
    8361,4485,
    8376,2110,
    8594,3135,
    8611,3755,
    8634,1570,
    8636,2748,
    8683,8222,
    9274,335,
    9512,2404,
    9640,5020,
    9690,1893,
    9778,3361,
    9808,15435,
    9936,4029,
    10194,2767,
    10306,6510,
    10325,1252,
    10686,2186,
    10844,32767,
    10913,4453,
    10968,3078,
    11044,1666,
    11076,3609,
    11398,2509,
    11423,5160,
    11848,1994,
    11997,2823,
    12002,3880,
    12084,7573,
    12129,3325,
    12214,5867,
    12331,1496,
    12450,4245,
    12458,2283,
    12768,901,
    12896,4741,
    12898,1811,
    12902,2569,
    12983,2959,
    13173,3331,
    13413,2059,
    13416,3734,
    13429,10641,
    13448,1148,
    13615,5340,
    13674,1425,
    13779,2332,
    13847,4264,
    13909,2657,
    13958,6488,
    14047,3085,
    14130,1648,
    14547,1915,
    14554,3684,
    14749,2739,
    14868,5017,
    14875,2216,
    14898,3197,
    14988,1085,
    15026,4246,
    15375,7971,
    15421,1446,
    15548,2462,
    15722,5920,
    15882,3449,
    15960,1782,
    15994,2863,
    16365,3977,
    16419,4754,
    16472,2162,
    17378,3101,
    17410,2550,
    17743,1339,
    17856,5485,
    17979,1982,
    17996,3628,
    18041,7110,
    18242,4381,
    18602,22207,
    19373,12827,
    19533,2777,
    19640,1678,
    19728,2272,
    19795,8861,
    20065,3275,
    20133,4881,
    20198,3947,
    20290,6128,
};

/*----------------------------------------------------------------------------------*
 * MA predicition coefficients for gain quantizer
 *----------------------------------------------------------------------------------*/

const float pred_gain[GAIN_PRED_ORDER] = { 0.5f, 0.4f, 0.3f, 0.2f };

/*----------------------------------------------------------------------------------*
 * 6-bit gain quantization table (only for AMR-WB IO mode)
 *----------------------------------------------------------------------------------*/

const float t_qua_gain6b[64*2] =
{
    0.095577f, 0.650507f,
    0.096232f, 1.737050f,
    0.187418f, 3.168846f,
    0.255896f, 4.962348f,
    0.274392f, 1.237365f,
    0.306340f, 2.191559f,
    0.340913f, 7.624112f,
    0.349443f, 0.694540f,
    0.393850f, 0.283414f,
    0.410411f, 3.335519f,
    0.467326f, 1.722400f,
    0.492699f, 1.024880f,
    0.502447f, 2.596945f,
    0.538748f, 4.284797f,
    0.594507f, 1.400231f,
    0.601562f, 0.715119f,
    0.615667f, 6.097708f,
    0.625075f, 2.174328f,
    0.662782f, 3.231284f,
    0.690967f, 1.751661f,
    0.696845f, 0.878992f,
    0.710639f, 1.185743f,
    0.715220f, 0.482280f,
    0.751490f, 2.486668f,
    0.764345f, 4.108078f,
    0.767472f, 12.8f,       /*0.767472f, 13.875360f,*/
    0.769099f, 1.658386f,
    0.803928f, 0.792686f,
    0.810832f, 1.183175f,
    0.818967f, 2.972155f,
    0.821480f, 6.255056f,
    0.833469f, 1.761157f,
    0.861276f, 2.207579f,
    0.863275f, 0.599961f,
    0.880429f, 0.913681f,
    0.880816f, 3.532393f,
    0.881643f, 1.383632f,
    0.892825f, 4.900598f,
    0.906974f, 8.542764f,
    0.925368f, 1.772085f,
    0.928281f, 2.841080f,
    0.933752f, 1.101603f,
    0.947124f, 2.305683f,
    0.956012f, 0.517399f,
    0.961870f, 3.892433f,
    0.972823f, 5.841643f,
    0.977796f, 1.463091f,
    0.981803f, 0.833284f,
    1.008362f, 2.077002f,
    1.011696f, 3.039251f,
    1.031157f, 1.162086f,
    1.031888f, 0.332692f,
    1.050599f, 4.104371f,
    1.074819f, 1.668828f,
    1.092217f, 2.572842f,
    1.108887f, 5.736302f,
    1.112667f, 0.769072f,
    1.135654f, 15.9999f,    /*1.135654f, 28.065996f,*/
    1.143096f, 10.587959f,
    1.168006f, 1.241697f,
    1.185414f, 3.211269f,
    1.186919f, 2.000422f,
    1.187154f, 4.421983f,
    1.243327f, 7.268204f
};

/*----------------------------------------------------------------------------------*
 * 7-bit gain quantization table (only for AMR-WB IO mode)
 *----------------------------------------------------------------------------------*/

const float t_qua_gain7b[128*2] =
{
    0.012445f, 0.215546f,
    0.028326f, 0.965442f,
    0.053042f, 0.525819f,
    0.065409f, 1.495322f,
    0.078212f, 2.323725f,
    0.100504f, 0.751276f,
    0.112617f, 3.427530f,
    0.113124f, 0.309583f,
    0.121763f, 1.140685f,
    0.143515f, 7.519609f,
    0.162430f, 0.568752f,
    0.164940f, 1.904113f,
    0.165429f, 4.947562f,
    0.194985f, 0.855463f,
    0.213527f, 1.281019f,
    0.223544f, 0.414672f,
    0.243135f, 2.781766f,
    0.257180f, 1.659565f,
    0.269488f, 0.636749f,
    0.286539f, 1.003938f,
    0.328124f, 2.225436f,
    0.328761f, 0.330278f,
    0.336807f, 11.500983f,
    0.339794f, 3.805726f,
    0.344454f, 1.494626f,
    0.346165f, 0.738748f,
    0.363605f, 1.141454f,
    0.398729f, 0.517614f,
    0.415276f, 2.928666f,
    0.416282f, 0.862935f,
    0.423421f, 1.873310f,
    0.444151f, 0.202244f,
    0.445842f, 1.301113f,
    0.455671f, 5.519512f,
    0.484764f, 0.387607f,
    0.488696f, 0.967884f,
    0.488730f, 0.666771f,
    0.508189f, 1.516224f,
    0.508792f, 2.348662f,
    0.531504f, 3.883870f,
    0.548649f, 1.112861f,
    0.551182f, 0.514986f,
    0.564397f, 1.742030f,
    0.566598f, 0.796454f,
    0.589255f, 3.081743f,
    0.598816f, 1.271936f,
    0.617654f, 0.333501f,
    0.619073f, 2.040522f,
    0.625282f, 0.950244f,
    0.630798f, 0.594883f,
    0.638918f, 4.863197f,
    0.650102f, 1.464846f,
    0.668412f, 0.747138f,
    0.669490f, 2.583027f,
    0.683757f, 1.125479f,
    0.691216f, 1.739274f,
    0.718441f, 3.297789f,
    0.722608f, 0.902743f,
    0.728827f, 2.194941f,
    0.729586f, 0.633849f,
    0.730907f, 7.432957f,
    0.731017f, 0.431076f,
    0.731543f, 1.387847f,
    0.759183f, 1.045210f,
    0.768606f, 1.789648f,
    0.771245f, 4.085637f,
    0.772613f, 0.778145f,
    0.786483f, 1.283204f,
    0.792467f, 2.412891f,
    0.802393f, 0.544588f,
    0.807156f, 0.255978f,
    0.814280f, 1.544409f,
    0.817839f, 0.938798f,
    0.826959f, 2.910633f,
    0.830453f, 0.684066f,
    0.833431f, 1.171532f,
    0.841208f, 1.908628f,
    0.846440f, 5.333522f,
    0.868280f, 0.841519f,
    0.868662f, 1.435230f,
    0.871449f, 3.675784f,
    0.881317f, 2.245058f,
    0.882020f, 0.480249f,
    0.882476f, 1.105804f,
    0.902856f, 0.684850f,
    0.904419f, 1.682113f,
    0.909384f, 2.787801f,
    0.916558f, 7.500981f,
    0.918444f, 0.950341f,
    0.919721f, 1.296319f,
    0.940272f, 4.682978f,
    0.940273f, 1.991736f,
    0.950291f, 3.507281f,
    0.957455f, 1.116284f,
    0.957723f, 0.793034f,
    0.958217f, 1.497824f,
    0.962628f, 2.514156f,
    0.968507f, 0.588605f,
    0.974739f, 0.339933f,
    0.991738f, 1.750201f,
    0.997210f, 0.936131f,
    1.002422f, 1.250008f,
    1.006040f, 2.167232f,
    1.008848f, 3.129940f,
    1.014404f, 5.842819f,
    1.027798f, 4.287319f,
    1.039404f, 1.489295f,
    1.039628f, 8.947958f,
    1.043214f, 0.765733f,
    1.045089f, 2.537806f,
    1.058994f, 1.031496f,
    1.060415f, 0.478612f,
    1.072132f, 12.8f,             /*1.072132f, 14.961459f,*/
    1.074778f, 1.910049f,
    1.076570f, 15.9999f,          /*1.076570f, 30.500374f,*/
    1.107853f, 3.843067f,
    1.110673f, 1.228576f,
    1.110969f, 2.758471f,
    1.140058f, 1.603077f,
    1.155384f, 0.668935f,
    1.176229f, 6.717108f,
    1.179008f, 2.011940f,
    1.187735f, 0.963552f,
    1.199569f, 4.891432f,
    1.206311f, 3.316329f,
    1.215323f, 2.507536f,
    1.223150f, 1.387102f,
    1.296012f, 9.684225f
};

/*----------------------------------------------------------------------------------*
 * Quantization table for scaled innovation energy prediciton
 *----------------------------------------------------------------------------------*/

const float Es_pred_qua_5b[32] =
{
    -8.0000f,
    -2.0519f,
    2.5095f,
    6.5923f,
    9.9507f,
    12.9923f,
    15.7251f,
    18.1521f,
    20.3552f,
    22.4218f,
    24.3014f,
    26.0214f,
    27.6040f,
    29.0898f,
    30.5291f,
    31.9154f,
    33.2749f,
    34.6277f,
    35.9525f,
    37.3081f,
    38.7173f,
    40.1734f,
    41.6751f,
    43.2697f,
    44.9559f,
    46.7826f,
    48.7749f,
    50.9729f,
    53.4967f,
    56.3814f,
    59.9748f,
    65.0000f
};


const float Es_pred_qua_4b[16] =
{
    -8.0000f,
    -0.1400f,
    7.1397f,
    12.8276f,
    17.9064f,
    22.4280f,
    26.6441f,
    30.6032f,
    34.2916f,
    37.8937f,
    41.4441f,
    45.0174f,
    48.7769f,
    52.9669f,
    58.0552f,
    65.0000f
};

const float Es_pred_qua_3b[8] =
{
    5.9422f,
    15.2711f,
    23.3857f,
    30.5310f,
    37.0190f,
    43.4539f,
    50.2442f,
    58.7164f
};

const float Es_pred_qua_4b_no_ltp[16] =
{
    -5.f,
    0.f,
    5.f,
    10.f,
    15.f,
    20.f,
    25.f,
    30.f,
    35.f,
    40.f,
    45.f,
    50.f,
    55.f,
    60.f,
    65.f,
    70.f
};

/*----------------------------------------------------------------------------------*
 * Gain estimation constants (for gain quantizer at 7.2 and 8.0 kbps)
 *----------------------------------------------------------------------------------*/

const float b_1sfr[2] =
{
    2.36736f,    -0.22452f
};

const float b_2sfr[4] =
{
    -0.00027f,     0.01703f,     0.91879f,     0.13234f
};

const float b_3sfr[6] =
{
    -0.11658f,     0.02674f,     0.13513f,     0.79682f,     0.02241f,     0.17815f
};

const float b_4sfr[8] =
{
    -0.09296f,     0.01578f,    -0.06606f,     0.20416f,     0.79254f,     0.00829f,     0.03499f,     0.15859f
};


/*----------------------------------------------------------------------------------*
 * Gain codebooks (for gain quantizer at 7.2 and 8.0 kbps)
 *----------------------------------------------------------------------------------*/

const float gp_gamma_1sfr_8b[2*256] =
{
    0.01864f,     0.29707f,
    0.02030f,     0.07182f,
    0.02151f,     1.08524f,
    0.03500f,     0.16009f,
    0.03977f,     0.02281f,
    0.04234f,     0.40424f,
    0.04933f,     0.76004f,
    0.05586f,     1.51515f,
    0.06020f,     2.12629f,
    0.06027f,     3.09183f,
    0.06439f,     0.11739f,
    0.07339f,     5.42703f,
    0.07352f,     0.03949f,
    0.08217f,     0.24883f,
    0.08739f,     0.64886f,
    0.10306f,    12.80025f,
    0.10466f,     0.50924f,
    0.11107f,     0.09482f,
    0.12457f,     1.36386f,
    0.13298f,     7.87494f,
    0.13422f,     0.19471f,
    0.13866f,     2.54472f,
    0.14144f,     0.90007f,
    0.14280f,     0.34101f,
    0.15640f,     0.05105f,
    0.15712f,    28.93375f,
    0.16220f,     4.10343f,
    0.16674f,     0.12822f,
    0.17199f,     0.01803f,
    0.17309f,     0.57791f,
    0.17880f,     1.83167f,
    0.21237f,     0.25432f,
    0.21425f,     0.42966f,
    0.22283f,     6.15919f,
    0.22382f,     1.40095f,
    0.22706f,     0.74928f,
    0.23090f,     1.03443f,
    0.23261f,    20.98373f,
    0.23699f,    10.51665f,
    0.24053f,     3.14177f,
    0.24195f,     0.09011f,
    0.25145f,     0.15676f,
    0.26865f,     0.02971f,
    0.27099f,     2.30569f,
    0.27377f,     0.33881f,
    0.28928f,     0.60729f,
    0.29592f,     0.06145f,
    0.31283f,    14.92646f,
    0.31414f,     0.21458f,
    0.31534f,     1.77427f,
    0.31962f,     0.49268f,
    0.32489f,     1.21756f,
    0.32814f,     4.91051f,
    0.34121f,     0.01364f,
    0.34148f,     8.74051f,
    0.34386f,     0.12541f,
    0.34508f,     0.89971f,
    0.35532f,     0.04229f,
    0.35970f,     0.27273f,
    0.36044f,     3.53446f,
    0.37703f,     0.71598f,
    0.38255f,     0.39178f,
    0.38772f,     2.13255f,
    0.40080f,     1.46796f,
    0.40443f,     0.09811f,
    0.41099f,     0.18558f,
    0.41248f,     0.57650f,
    0.42003f,     6.02510f,
    0.42491f,     2.66162f,
    0.44395f,     1.05504f,
    0.45244f,     0.32349f,
    0.46599f,     4.14121f,
    0.46643f,     0.07352f,
    0.46821f,     0.76710f,
    0.47180f,     0.44298f,
    0.47973f,     0.14694f,
    0.48709f,     0.22467f,
    0.48898f,     1.86483f,
    0.49391f,     7.20170f,
    0.49561f,     0.03365f,
    0.49719f,    11.52638f,
    0.51590f,     1.31314f,
    0.52029f,     3.12855f,
    0.52386f,     0.11286f,
    0.52972f,     0.53743f,
    0.54158f,     0.64936f,
    0.54442f,     0.88680f,
    0.54741f,    18.96873f,
    0.55717f,     5.01132f,
    0.55900f,     0.38267f,
    0.56108f,     2.20040f,
    0.56269f,     0.27811f,
    0.56764f,     0.01728f,
    0.56774f,     1.61683f,
    0.57428f,     0.17847f,
    0.59426f,     0.05172f,
    0.60253f,     1.12077f,
    0.61435f,     0.47966f,
    0.61837f,     2.64075f,
    0.61974f,     3.85052f,
    0.62233f,     0.77999f,
    0.62488f,    30.82914f,
    0.62591f,     8.30773f,
    0.63483f,     0.13040f,
    0.63717f,     0.08340f,
    0.64151f,     0.22596f,
    0.64277f,    14.45112f,
    0.65342f,     1.94833f,
    0.65906f,     1.41075f,
    0.66195f,     0.33327f,
    0.66208f,     0.59438f,
    0.66380f,     5.82288f,
    0.67561f,    55.08506f,
    0.67985f,     0.98953f,
    0.68848f,     0.02431f,
    0.69743f,     0.75692f,
    0.69940f,     0.41776f,
    0.71088f,     2.29372f,
    0.71473f,     9.88443f,
    0.71666f,     3.15179f,
    0.71976f,     1.57490f,
    0.72121f,     0.15977f,
    0.72569f,     0.25747f,
    0.73215f,     4.49475f,
    0.73242f,     1.17828f,
    0.73611f,     0.10706f,
    0.74660f,     0.50029f,
    0.75066f,     0.06441f,
    0.75918f,     0.66077f,
    0.76003f,     0.89356f,
    0.77072f,     6.95905f,
    0.77186f,    18.53232f,
    0.77303f,     1.82446f,
    0.78131f,     2.59582f,
    0.78137f,     0.37054f,
    0.78595f,     1.33439f,
    0.78988f,     0.20177f,
    0.79579f,     3.69204f,
    0.80621f,    12.12779f,
    0.80699f,    24.75305f,
    0.81287f,     0.04130f,
    0.81630f,     0.55362f,
    0.81694f,     0.29092f,
    0.81734f,     0.74874f,
    0.82110f,     1.06401f,
    0.82787f,     2.07876f,
    0.82981f,     5.00103f,
    0.84050f,     1.58158f,
    0.84438f,     2.89191f,
    0.84678f,     0.13416f,
    0.85616f,     0.44166f,
    0.86019f,     8.65103f,
    0.86346f,     0.01317f,
    0.86494f,     1.18927f,
    0.86577f,     0.09267f,
    0.86811f,     5.95882f,
    0.87117f,     0.84740f,
    0.87406f,     0.61269f,
    0.87981f,     0.23437f,
    0.88151f,     2.44548f,
    0.88504f,     0.33708f,
    0.88847f,     1.82180f,
    0.89206f,     3.31226f,
    0.89352f,    16.07224f,
    0.89868f,     0.17353f,
    0.90558f,     1.37396f,
    0.90956f,     4.04629f,
    0.91046f,     0.71437f,
    0.91555f,     0.95141f,
    0.91607f,     0.05802f,
    0.92133f,     0.50076f,
    0.92397f,     2.18529f,
    0.92943f,     6.99163f,
    0.93816f,     2.70762f,
    0.93915f,    10.79124f,
    0.93979f,    35.02379f,
    0.94373f,     0.29109f,
    0.94428f,     1.54440f,
    0.94915f,     1.11190f,
    0.94935f,     4.81827f,
    0.94963f,     0.39335f,
    0.95314f,     0.02810f,
    0.95605f,     0.62253f,
    0.96422f,     0.78364f,
    0.96502f,     1.90168f,
    0.96887f,     0.08041f,
    0.97223f,     3.22145f,
    0.97319f,     0.15476f,
    0.97937f,     0.21603f,
    0.99027f,     1.26402f,
    0.99060f,     2.42092f,
    0.99469f,     8.02656f,
    0.99661f,    20.50587f,
    0.99674f,     0.54301f,
    0.99823f,     5.86597f,
    0.99991f,     0.88884f,
    1.00124f,     0.33090f,
    1.00312f,     4.24275f,
    1.00328f,     1.65980f,
    1.02202f,    13.84765f,
    1.02395f,     0.69092f,
    1.02548f,     2.07584f,
    1.02556f,     0.12171f,
    1.02613f,     0.43643f,
    1.03316f,     1.03433f,
    1.03462f,     1.40902f,
    1.03999f,     2.82553f,
    1.05031f,     3.58878f,
    1.05184f,     0.26298f,
    1.06027f,     9.06668f,
    1.07241f,     0.79358f,
    1.07471f,     0.52241f,
    1.08008f,     1.76977f,
    1.08043f,     4.93935f,
    1.08062f,    45.38949f,
    1.08090f,     2.36074f,
    1.08304f,     1.15533f,
    1.08642f,     0.18015f,
    1.08996f,     0.06905f,
    1.09008f,     6.56321f,
    1.09044f,     0.01828f,
    1.09727f,     0.36021f,
    1.10075f,     0.62638f,
    1.11422f,     1.47205f,
    1.11535f,     0.93762f,
    1.11816f,     0.03576f,
    1.12340f,     0.10836f,
    1.13413f,    25.42389f,
    1.13994f,     2.96173f,
    1.14294f,     3.90159f,
    1.15382f,     0.04975f,
    1.15439f,    11.91982f,
    1.16090f,    16.73218f,
    1.16103f,     2.17967f,
    1.16117f,     0.68099f,
    1.16863f,     0.46714f,
    1.17332f,     1.18022f,
    1.17498f,     0.31199f,
    1.17616f,     9.51265f,
    1.18152f,     7.40048f,
    1.18372f,     0.24663f,
    1.18372f,     0.20126f,
    1.18610f,     0.14046f,
    1.18676f,     0.08978f,
    1.18699f,     5.55043f,
    1.18951f,     0.84044f,
    1.19478f,     1.59238f,
    1.19799f,     2.55164f,
    1.19820f,     1.89784f,
    1.19857f,     0.39387f,
    1.19888f,     0.56489f,
    1.19998f,     1.02889f,
    1.20345f,     3.31468f,
    1.20431f,     4.41910f,
    1.20567f,     1.32040f,
    1.21177f,     0.74548f
};

const float gp_gamma_1sfr_7b[2*128] =
{
    0.02136f,     0.16576f,
    0.02610f,     0.04700f,
    0.02673f,     1.32916f,
    0.03917f,     0.38038f,
    0.06539f,     3.93015f,
    0.06590f,     0.78428f,
    0.07007f,     2.41347f,
    0.07073f,     0.12201f,
    0.08692f,     0.02273f,
    0.10144f,     0.26162f,
    0.12117f,     0.58428f,
    0.12817f,     0.06582f,
    0.13200f,     6.18738f,
    0.13542f,     1.05113f,
    0.14605f,    12.85127f,
    0.15252f,     1.88832f,
    0.17593f,     0.43086f,
    0.18150f,    24.88791f,
    0.19845f,     0.19059f,
    0.20102f,     0.09975f,
    0.21887f,     3.04712f,
    0.22650f,     0.80244f,
    0.22710f,     1.36678f,
    0.23569f,     0.04128f,
    0.24090f,     0.33017f,
    0.24423f,     4.39312f,
    0.25622f,     9.04696f,
    0.26686f,     0.01465f,
    0.30474f,     0.13696f,
    0.30653f,     0.51721f,
    0.33982f,     2.33214f,
    0.34572f,     0.96726f,
    0.34776f,     0.22391f,
    0.35921f,     1.66824f,
    0.37321f,     5.83958f,
    0.38246f,     0.29909f,
    0.38918f,     0.07567f,
    0.39258f,     0.03099f,
    0.40290f,     0.67440f,
    0.43384f,     3.82188f,
    0.44136f,     1.28810f,
    0.45720f,     0.39518f,
    0.46915f,     0.18114f,
    0.49155f,     7.58133f,
    0.49486f,    18.79692f,
    0.49964f,     2.78200f,
    0.50311f,     0.11426f,
    0.50988f,     1.82600f,
    0.51013f,    12.50225f,
    0.51163f,     0.85831f,
    0.53672f,     0.55661f,
    0.54568f,     0.24221f,
    0.58854f,     0.04842f,
    0.58856f,     1.13464f,
    0.59022f,     5.29180f,
    0.61432f,     0.31344f,
    0.62368f,     0.01799f,
    0.62503f,     3.37535f,
    0.62557f,     0.15698f,
    0.63586f,     2.17291f,
    0.64066f,     0.72903f,
    0.65002f,     0.46018f,
    0.67718f,     0.08632f,
    0.67719f,     1.47658f,
    0.68875f,     9.72347f,
    0.68911f,    32.65981f,
    0.72111f,     4.49107f,
    0.72523f,     0.94174f,
    0.73603f,     0.22351f,
    0.75271f,    16.69924f,
    0.75455f,     2.72292f,
    0.75633f,     0.36255f,
    0.76400f,     0.65651f,
    0.76595f,     6.66691f,
    0.77475f,     1.86222f,
    0.79933f,     1.19851f,
    0.80473f,     0.13963f,
    0.80852f,     0.51193f,
    0.82270f,     3.73825f,
    0.84176f,     0.02816f,
    0.84259f,     0.05841f,
    0.85838f,     0.27004f,
    0.86563f,     0.82004f,
    0.86743f,     2.29536f,
    0.88363f,     1.49460f,
    0.89140f,     5.36064f,
    0.89183f,    12.35149f,
    0.89905f,     8.20030f,
    0.90532f,     0.58773f,
    0.90588f,     0.39700f,
    0.91006f,    24.98023f,
    0.92596f,     0.19474f,
    0.92719f,     3.17426f,
    0.93316f,     1.03857f,
    0.94022f,     0.10069f,
    0.94912f,     1.92355f,
    0.98244f,     0.69665f,
    0.98723f,     4.12701f,
    0.99391f,     0.45338f,
    0.99688f,     1.30750f,
    0.99874f,    44.92089f,
    1.00074f,     0.30398f,
    1.00361f,     2.48072f,
    1.00432f,     6.80059f,
    1.00968f,     0.01556f,
    1.01623f,    10.59523f,
    1.03016f,     0.88271f,
    1.03693f,     0.16444f,
    1.03908f,    18.89908f,
    1.04942f,     1.71141f,
    1.08216f,     0.03947f,
    1.08519f,     2.81718f,
    1.09035f,     0.07394f,
    1.09092f,     0.49594f,
    1.09429f,     1.02772f,
    1.09931f,     4.69322f,
    1.14445f,    13.97163f,
    1.14663f,     0.22834f,
    1.14869f,     8.63215f,
    1.15982f,     0.12298f,
    1.16574f,     0.78265f,
    1.16644f,     0.35763f,
    1.17170f,     1.51544f,
    1.17199f,     5.76835f,
    1.17405f,     2.05383f,
    1.17523f,     0.58874f,
    1.18128f,     3.43730f,
    1.18605f,     1.15776f
};

const float gp_gamma_1sfr_6b[2*64] =
{
    0.02662f,     0.35620f,
    0.02886f,     0.12384f,
    0.05872f,     0.03097f,
    0.06053f,     1.26461f,
    0.07678f,     3.09046f,
    0.08829f,     0.68582f,
    0.10444f,     0.24412f,
    0.11040f,     0.08899f,
    0.15678f,     8.15025f,
    0.15909f,     1.86873f,
    0.17247f,     0.48977f,
    0.17727f,    24.37615f,
    0.19825f,     0.05111f,
    0.21935f,     4.40219f,
    0.22361f,     0.15212f,
    0.22674f,     0.94328f,
    0.25832f,     0.01602f,
    0.28570f,     0.36784f,
    0.30922f,    12.93476f,
    0.31936f,     2.48635f,
    0.38038f,     1.35732f,
    0.38051f,     0.09521f,
    0.38075f,     0.21973f,
    0.38524f,     0.62092f,
    0.42799f,     0.03238f,
    0.44723f,     6.21713f,
    0.48877f,     3.39646f,
    0.53050f,     0.87060f,
    0.53522f,     0.31847f,
    0.54464f,     1.99023f,
    0.55504f,     0.15767f,
    0.63219f,     0.55908f,
    0.64035f,     0.05438f,
    0.64773f,    19.11642f,
    0.65402f,     1.48427f,
    0.67413f,     9.41877f,
    0.69087f,     4.69262f,
    0.71312f,     0.10928f,
    0.75159f,     0.21181f,
    0.76049f,     1.08676f,
    0.76781f,     0.01802f,
    0.77612f,     0.41533f,
    0.78253f,     2.60862f,
    0.86685f,     0.73032f,
    0.87435f,    33.14677f,
    0.89187f,     1.63714f,
    0.89264f,     6.41601f,
    0.89525f,    12.17085f,
    0.91060f,     0.07523f,
    0.92352f,     0.26853f,
    0.94457f,     3.60819f,
    0.97995f,     0.49732f,
    0.99345f,     0.96508f,
    0.99428f,     0.12950f,
    1.01209f,     2.04687f,
    1.02897f,     0.03326f,
    1.05102f,    17.03703f,
    1.06462f,     8.38911f,
    1.10284f,     4.88112f,
    1.11160f,     0.34356f,
    1.12908f,     0.17681f,
    1.13018f,     2.82130f,
    1.13048f,     0.64939f,
    1.13502f,     1.29540f
};


const float gp_gamma_2sfr_7b[2*128] =
{
    0.00607f,     2.39054f,
    0.00954f,     0.47393f,
    0.01025f,     1.13156f,
    0.01770f,     0.69243f,
    0.02670f,     0.86143f,
    0.02900f,     0.36511f,
    0.04481f,     1.44093f,
    0.05677f,     0.18129f,
    0.06916f,     0.29914f,
    0.06931f,     0.58281f,
    0.09094f,     0.99160f,
    0.11875f,     0.78403f,
    0.12072f,    32.79239f,
    0.12805f,     0.43746f,
    0.12919f,     1.87968f,
    0.14693f,     0.23271f,
    0.16393f,     0.66184f,
    0.17876f,     1.08413f,
    0.20774f,     0.52913f,
    0.21146f,     0.33304f,
    0.21176f,     0.82451f,
    0.22667f,     1.29470f,
    0.27074f,     0.96525f,
    0.27431f,     0.64919f,
    0.27900f,     0.42916f,
    0.27972f,     4.26235f,
    0.30501f,     1.65535f,
    0.32627f,     0.74124f,
    0.33076f,     0.21006f,
    0.33996f,     1.13073f,
    0.35145f,     0.51891f,
    0.35860f,     0.86393f,
    0.36177f,     0.33235f,
    0.37868f,     6.51886f,
    0.39024f,    12.56903f,
    0.39765f,     0.63998f,
    0.40513f,     1.42570f,
    0.40817f,     2.87488f,
    0.43002f,     2.06198f,
    0.43340f,     0.97173f,
    0.43475f,     0.40939f,
    0.43718f,    18.88363f,
    0.44833f,     0.75361f,
    0.46375f,     0.54756f,
    0.47932f,     1.22520f,
    0.51646f,     0.86275f,
    0.52785f,     0.64565f,
    0.53846f,     0.46049f,
    0.54240f,     1.07549f,
    0.54644f,     1.76965f,
    0.56866f,     0.26470f,
    0.58517f,     0.75438f,
    0.58905f,     1.35033f,
    0.59790f,     0.55874f,
    0.60132f,     0.95549f,
    0.61063f,     2.37370f,
    0.61285f,     0.37493f,
    0.64837f,     1.12469f,
    0.65662f,     0.64355f,
    0.66163f,     0.82985f,
    0.66799f,     1.54600f,
    0.67368f,     0.50148f,
    0.68300f,     3.65165f,
    0.70443f,     0.97799f,
    0.71587f,     1.25327f,
    0.72464f,     0.71612f,
    0.73632f,     0.31795f,
    0.75268f,     0.42125f,
    0.75309f,     2.14775f,
    0.75309f,     0.57562f,
    0.76160f,     0.86706f,
    0.76665f,     1.10985f,
    0.77299f,     1.64991f,
    0.80915f,     0.77262f,
    0.81281f,     1.32136f,
    0.81854f,     0.99876f,
    0.83675f,     0.63186f,
    0.83681f,     3.02209f,
    0.83687f,     0.48040f,
    0.85777f,     1.93471f,
    0.86131f,     0.87229f,
    0.86952f,     1.13226f,
    0.87613f,     1.46053f,
    0.87855f,     0.34269f,
    0.88214f,     0.19384f,
    0.89134f,     0.70978f,
    0.90866f,     0.95984f,
    0.92004f,     0.54981f,
    0.92222f,     1.24490f,
    0.93028f,     2.52260f,
    0.93695f,     0.80671f,
    0.94177f,     1.64620f,
    0.95825f,     1.05636f,
    0.96289f,     0.39904f,
    0.97439f,     0.65464f,
    0.97607f,     1.34420f,
    0.98128f,     0.88402f,
    0.99580f,     9.01834f,
    1.00135f,     2.01532f,
    1.01010f,     1.16279f,
    1.01723f,     0.74974f,
    1.02846f,     1.51554f,
    1.02849f,     0.94135f,
    1.03245f,     0.49354f,
    1.05191f,     0.60369f,
    1.05632f,     4.15579f,
    1.06623f,     1.06736f,
    1.07827f,     1.25591f,
    1.08027f,     0.82287f,
    1.08960f,     1.72193f,
    1.09072f,     0.28420f,
    1.10754f,     2.43024f,
    1.12653f,     0.95428f,
    1.12778f,     0.67641f,
    1.13450f,     1.41156f,
    1.14902f,     0.40686f,
    1.16032f,     3.38038f,
    1.16226f,     1.14385f,
    1.17713f,     0.54895f,
    1.18580f,     1.84337f,
    1.18686f,     0.74693f,
    1.19352f,     0.86699f,
    1.20171f,     1.54779f,
    1.20572f,     2.16971f,
    1.20617f,     1.02977f,
    1.20662f,     2.74485f,
    1.20688f,     1.28237f,
    1.20728f,     5.22483f
};


const float gp_gamma_2sfr_6b[2*64] =
{
    0.01130f,     0.59705f,
    0.02652f,     1.01430f,
    0.02794f,     0.28351f,
    0.06102f,     0.41178f,
    0.07430f,     0.77026f,
    0.07572f,     1.46777f,
    0.10914f,     0.18121f,
    0.12363f,     2.40953f,
    0.13197f,     0.51810f,
    0.14628f,     0.30909f,
    0.15972f,     0.92110f,
    0.20291f,     0.66321f,
    0.20694f,     1.21691f,
    0.23404f,     0.40495f,
    0.27484f,    33.61382f,
    0.28250f,     0.79452f,
    0.30145f,     1.75124f,
    0.31141f,     0.53656f,
    0.32351f,     0.23494f,
    0.33936f,     0.99733f,
    0.38508f,     3.72779f,
    0.40108f,     0.65367f,
    0.41319f,     0.40008f,
    0.42662f,     1.25364f,
    0.43246f,     9.93625f,
    0.45774f,     0.83578f,
    0.51009f,     1.61477f,
    0.51585f,     0.50984f,
    0.55413f,     1.04889f,
    0.56694f,     0.69123f,
    0.60142f,     2.29733f,
    0.60208f,     0.32174f,
    0.63695f,    16.75804f,
    0.64385f,     0.85349f,
    0.64786f,     1.32201f,
    0.67202f,     0.55054f,
    0.72879f,     1.03555f,
    0.74357f,     0.71744f,
    0.76140f,     1.79730f,
    0.78523f,     0.43896f,
    0.81538f,     1.20775f,
    0.81979f,     0.86215f,
    0.82523f,     3.16953f,
    0.86528f,     0.66633f,
    0.87274f,     0.25452f,
    0.88210f,     1.51311f,
    0.90326f,     0.99246f,
    0.93081f,     0.53871f,
    0.95916f,     2.20734f,
    0.96174f,     1.28996f,
    0.96917f,     0.82441f,
    0.99824f,     6.35842f,
    1.00335f,     0.36563f,
    1.02237f,     1.09680f,
    1.03188f,     0.64719f,
    1.04846f,     1.61469f,
    1.09185f,     0.91916f,
    1.11199f,     4.24727f,
    1.14659f,     0.48521f,
    1.15873f,     2.64461f,
    1.16374f,     1.37282f,
    1.17310f,     0.74954f,
    1.18098f,     1.86320f,
    1.18544f,     1.08087f
};

const float gp_gamma_3sfr_6b[2*64] =
{
    0.01192f,     0.29245f,
    0.04985f,     0.56198f,
    0.07032f,     1.20261f,
    0.08337f,     0.36774f,
    0.08405f,     0.80061f,
    0.09313f,     1.76147f,
    0.09580f,     0.19048f,
    0.13781f,     0.46427f,
    0.15191f,     1.01263f,
    0.17911f,     0.66093f,
    0.19176f,     0.31423f,
    0.21095f,     3.33105f,
    0.24351f,     0.84426f,
    0.25383f,     1.38475f,
    0.25558f,     0.52730f,
    0.26697f,     2.41458f,
    0.32244f,     1.02709f,
    0.33147f,     0.25578f,
    0.33614f,     0.69549f,
    0.35169f,     0.41222f,
    0.41458f,     1.21107f,
    0.41759f,     0.87121f,
    0.42537f,     0.59296f,
    0.46820f,     1.57552f,
    0.51038f,     0.47823f,
    0.51562f,     1.03574f,
    0.52553f,     0.74288f,
    0.56848f,     2.12515f,
    0.59985f,     0.33289f,
    0.60551f,    13.69166f,
    0.61194f,     0.89674f,
    0.62213f,     0.60927f,
    0.62628f,     1.28489f,
    0.70519f,     0.76916f,
    0.71649f,     1.72293f,
    0.71964f,     1.05889f,
    0.73148f,     8.45570f,
    0.73217f,     0.48093f,
    0.77896f,    26.25153f,
    0.78396f,     2.95227f,
    0.80147f,     0.90896f,
    0.80167f,     0.66149f,
    0.80656f,     1.44516f,
    0.86294f,     1.18805f,
    0.88649f,     0.81413f,
    0.90213f,     2.01099f,
    0.90474f,     0.55259f,
    0.91649f,     0.33485f,
    0.93167f,     1.03017f,
    0.96578f,     5.28431f,
    0.97308f,     1.36442f,
    0.97409f,     0.70362f,
    0.99790f,     0.92401f,
    1.05048f,     1.12005f,
    1.05996f,     1.76024f,
    1.06915f,     0.46437f,
    1.08636f,     0.80929f,
    1.10286f,     2.76431f,
    1.13708f,     3.74909f,
    1.15280f,     1.23892f,
    1.16077f,     0.62175f,
    1.17824f,     0.96656f,
    1.18408f,     2.17545f,
    1.18487f,     1.49786f
};

const float gp_gamma_4sfr_6b[2*64] =
{
    0.00934f,     0.27565f,
    0.01721f,     0.97811f,
    0.02433f,     0.46654f,
    0.04781f,     0.72086f,
    0.06776f,     1.45241f,
    0.08727f,     0.35723f,
    0.08791f,     3.41441f,
    0.09299f,     2.13125f,
    0.09778f,     0.57872f,
    0.11158f,     0.19319f,
    0.12208f,     0.85691f,
    0.16346f,     0.44503f,
    0.17183f,     1.17256f,
    0.18821f,     0.67810f,
    0.23565f,     0.93068f,
    0.25353f,     0.31870f,
    0.25723f,     0.55721f,
    0.27028f,     1.43169f,
    0.30369f,     0.74972f,
    0.33457f,     1.10643f,
    0.33886f,     0.45699f,
    0.37588f,     1.81394f,
    0.39890f,     0.91791f,
    0.40041f,     0.63732f,
    0.44484f,     0.33746f,
    0.45345f,     1.29581f,
    0.45454f,    20.73460f,
    0.48041f,     0.79572f,
    0.51620f,     0.51876f,
    0.52239f,     1.07372f,
    0.52970f,     2.77458f,
    0.57723f,     0.69551f,
    0.58187f,     1.53270f,
    0.60145f,     0.92017f,
    0.64601f,    11.29119f,
    0.65868f,     7.45030f,
    0.66000f,     0.40154f,
    0.66097f,     0.58966f,
    0.67054f,     1.18310f,
    0.69460f,     0.84554f,
    0.69993f,     2.09527f,
    0.76202f,     0.69518f,
    0.77672f,     1.01521f,
    0.78020f,     1.40843f,
    0.82725f,     0.50517f,
    0.84005f,     0.27186f,
    0.84739f,     0.84066f,
    0.85816f,     5.06160f,
    0.87075f,     1.17031f,
    0.87474f,     1.80610f,
    0.91532f,     0.65903f,
    0.93722f,     0.94775f,
    0.94762f,     1.39061f,
    1.00344f,     1.14608f,
    1.00732f,     0.77084f,
    1.01480f,     0.39878f,
    1.05149f,     2.51385f,
    1.07194f,     1.57173f,
    1.07599f,     1.01017f,
    1.10831f,     3.54277f,
    1.11815f,     0.59230f,
    1.17359f,     0.85449f,
    1.17572f,     1.24171f,
    1.18513f,     1.93190f
};


/*----------------------------------------------------------------------------------*
 * Transition coding - gain quantization table
 *----------------------------------------------------------------------------------*/

const float tbl_gain_code_tc[N_GAIN_CODE_TC] =
{
    0.36201f,
    0.72382f,
    0.96727f,
    1.1856f,
    1.4119f,
    1.679f,
    2.0743f,
    3.3301f
};

/*-----------------------------------------------------------------*
 * Transition coding - gain quantization table for g_trans
 *-----------------------------------------------------------------*/

const float tbl_gain_trans_tc[N_GAIN_TC] =
{
    35.8449f,
    86.7884f,
    150.0926f,
    233.3001f,
    346.0286f,
    511.5196f,
    819.6746f,
    1500.0f
};

/*-----------------------------------------------------------------*
 * Transition coding - table of prototype glottal impulses
 *-----------------------------------------------------------------*/

const float glottal_cdbk[L_IMPULSE*NUM_IMPULSE] =
{
    /* impulse 0 */
    -0.0873f,       -0.2063f,       -0.3544f,       -0.2126f,       -0.1581f,       -0.5208f,
    -0.5973f,        0.2106f,        1.0000f,        0.7095f,       -0.0767f,       -0.2388f,
    0.0709f,        0.1143f,       -0.0099f,        0.1015f,        0.1852f,
    /* impulse 1 */
    -0.2646f,       -0.1655f,       -0.0493f,       -0.3314f,       -0.5455f,       -0.2641f,
    -0.2661f,       -0.9837f,       -1.1157f,        0.1420f,        1.2626f,        0.8151f,
    -0.2146f,       -0.3466f,        0.0460f,        0.0398f,       -0.0598f,
    /* impulse 2 */
    0.0440f,        0.0685f,        0.5108f,        0.3092f,       -0.4060f,       -0.3111f,
    0.2513f,       -0.2578f,       -1.1648f,       -0.7488f,        0.1596f,        0.0151f,
    -0.4176f,       -0.1788f,        0.0580f,       -0.1082f,       -0.1541f,
    /* impulse 3 */
    -0.1579f,       -0.0873f,       -0.0224f,       -0.1885f,       -0.2000f,       -0.0267f,
    -0.4276f,       -1.1485f,       -0.9711f,       -0.1718f,       -0.0348f,       -0.3044f,
    0.0372f,        0.5686f,        0.4015f,        0.0141f,        0.1816f,
    /* impulse 4 */
    0.1022f,        0.3080f,        0.2984f,        0.3270f,        0.7278f,        0.8466f,
    -0.1128f,       -1.2094f,       -0.9235f,        0.0785f,        0.1648f,       -0.3146f,
    -0.2563f,       -0.0338f,       -0.1887f,       -0.2782f,       -0.1077f,
    /* impulse 5 */
    -0.0510f,       -0.1082f,       -0.0058f,       -0.0603f,       -0.2891f,       -0.2515f,
    -0.1505f,       -0.6434f,       -1.2732f,       -0.8490f,        0.4029f,        0.9251f,
    0.3172f,       -0.2032f,       -0.0563f,        0.0897f,       -0.0221f,
    /* impulse 6 */
    -0.0570f,       -0.2277f,       -0.1776f,       -0.0155f,       -0.2296f,       -0.4609f,
    0.1004f,        1.0174f,        1.0000f,        0.1053f,       -0.3371f,       -0.0458f,
    0.0924f,       -0.0681f,       -0.0348f,        0.0797f,        0.0183f,
    /* impulse 7 */
    0.1327f,        0.0575f,       -0.0754f,        0.0862f,        0.1887f,       -0.1959f,
    -0.3975f,        0.2925f,        0.9839f,        0.6334f,       -0.0121f,       -0.0045f,
    0.1349f,       -0.0815f,       -0.1751f,       -0.0072f,       -0.0099f
};

/*----------------------------------------------------------------------------------*
 * AMR-WB IO WB BWE - deemphasis
 *----------------------------------------------------------------------------------*/

const float deem_tab[56] =
{
    0.630730419421360f, 0.629416164964296f, 0.628129905227103f, 0.626871385453679f, 0.625640357452226f, 0.624436579475560f, 0.623259816105156f,
    0.622109838138814f, 0.620986422481867f, 0.619889352041818f, 0.618818415626335f, 0.617773407844493f, 0.616754129011203f, 0.615760385054730f,
    0.614791987427225f, 0.613848753018209f, 0.612930504070914f, 0.612037068101433f, 0.611168277820597f, 0.610323971058526f, 0.609503990691786f,
    0.608708184573088f, 0.607936405463484f, 0.607188510967000f, 0.606464363467645f, 0.605763830068759f, 0.605086782534647f, 0.604433097234441f,
    0.603802655088168f, 0.603195341514964f, 0.602611046383395f, 0.602049663963857f, 0.601511092883003f, 0.600995236080178f, 0.600502000765808f,
    0.600031298381734f, 0.599583044563439f, 0.599157159104159f, 0.598753565920828f, 0.598372193021851f, 0.598012972476677f, 0.597675840387130f,
    0.597360736860508f, 0.597067605984399f, 0.596796395803217f, 0.596547058296428f, 0.596319549358454f, 0.596113828780239f, 0.595929860232466f,
    0.595767611250409f, 0.595627053220407f, 0.595508161367956f, 0.595410914747406f, 0.595335296233253f, 0.595281292513031f, 0.595248894081778f
};

const float filt_hp[56] =
{
    0.001610570549503f, 0.004682981184545f, 0.008349027644995f, 0.012654118680910f, 0.017642537255539f, 0.023357023549788f,
    0.029838357405517f, 0.037124944278684f, 0.045252408764306f, 0.054253199698241f, 0.064156210737117f, 0.074986420169406f,
    0.086764553520305f, 0.099506772283889f, 0.113224391851657f, 0.127923631411203f, 0.143605398266754f, 0.160265108689438f,
    0.177892547044310f, 0.196471764568281f, 0.215981018793259f, 0.236392754226835f, 0.257673624523579f, 0.279784556007892f,
    0.302680852048711f, 0.326312337440982f, 0.350623541622164f, 0.375553919247241f, 0.401038106365070f, 0.427006210184762f,
    0.453384130194306f, 0.480093908196193f, 0.507054104656542f, 0.534180198625471f, 0.561385008376586f, 0.588579129831778f,
    0.615671389782721f, 0.642569310891142f, 0.669179585444241f, 0.695408554857669f, 0.721162691954086f, 0.746349083098340f,
    0.770875907338563f, 0.794652909783784f, 0.817591866540936f, 0.839607038635485f, 0.860615612448599f, 0.880538124318166f,
    0.899298867069991f, 0.916826276367851f, 0.933053294896263f, 0.947917712517199f, 0.961362480671352f, 0.973335999426038f,
    0.983792375705577f, 0.992691651376520f
};

/* table of values exp(-j*w*i) */
const float exp_tab_q[34] =
{
    1.000000000000000f,   -0.980785280403230f,    0.923879532511287f,   -0.831469612302544f,
    0.707106781186547f,   -0.555570233019602f,    0.382683432365086f,   -0.195090322016125f,
    -0.000000000000003f,    0.195090322016130f,   -0.382683432365091f,    0.555570233019606f,
    -0.707106781186553f,    0.831469612302547f,   -0.923879532511289f,    0.980785280403231f,
    -1.000000000000000f,    0.000000000000000f,   -0.195090322016129f,    0.382683432365090f,
    -0.555570233019604f,    0.707106781186549f,   -0.831469612302546f,    0.923879532511288f,
    -0.980785280403231f,    1.000000000000000f,   -0.980785280403230f,    0.923879532511286f,
    -0.831469612302543f,    0.707106781186542f,   -0.555570233019599f,    0.382683432365084f,
    -0.195090322016126f,   -0.000000000000005f
};

const float exp_tab_p[34] =
{
    1.000000000000000f,   -0.707106781186548f,   -0.000000000000000f,    0.707106781186548f,
    -1.000000000000000f,    0.707106781186547f,    0.000000000000000f,   -0.707106781186547f,
    1.000000000000000f,   -0.707106781186546f,   -0.000000000000003f,    0.707106781186548f,
    -1.000000000000000f,    0.707106781186546f,   -0.000000000000000f,   -0.707106781186548f,
    1.000000000000000f,    0.000000000000000f,   -0.707106781186548f,    1.000000000000000f,
    -0.707106781186547f,   -0.000000000000000f,    0.707106781186549f,   -1.000000000000000f,
    0.707106781186548f,    0.000000000000000f,   -0.707106781186549f,    1.000000000000000f,
    -0.707106781186548f,    0.000000000000000f,    0.707106781186549f,   -1.000000000000000f,
    0.707106781186547f,    0.000000000000000f
};

/* gains for 23k85 mode */
const float HP_gain[16] =
{
    /* values in Q15: 3624, 4673, 5597, 6479, 7425, 8378, 9324, 10264, 11210, 12206, 13391, 14844, 16770, 19655, 24289, 32728 */
    0.110595703125000f, 0.142608642578125f, 0.170806884765625f, 0.197723388671875f,
    0.226593017578125f, 0.255676269531250f, 0.284545898437500f, 0.313232421875000f,
    0.342102050781250f, 0.372497558593750f, 0.408660888671875f, 0.453002929687500f,
    0.511779785156250f, 0.599822998046875f, 0.741241455078125f, 0.998779296875000f
};

/* band-pass 6-8kHz filter */
const float fir_6k_8k[31]=
{
    0.001331237773450f,   -0.004734562657574f,    0.009865692979275f,   -0.014704482109862f,
    0.017170883692091f,   -0.018004559024736f,    0.022168155759205f,   -0.036012990296002f,
    0.060614595353634f,   -0.086000479894051f,    0.092413785317631f,   -0.060769441864153f,
    -0.012918738234409f,    0.109335430548556f,   -0.191677822804549f,    0.224071909378974f,
    -0.191677822804549f,    0.109335430548556f,   -0.012918738234409f,   -0.060769441864153f,
    0.092413785317631f,   -0.086000479894051f,    0.060614595353634f,   -0.036012990296002f,
    0.022168155759205f,   -0.018004559024736f,    0.017170883692091f,   -0.014704482109862f,
    0.009865692979275f,   -0.004734562657574f,    0.001331237773450f
};


/*----------------------------------------------------------------------------------*
 * 2nd order high-pass filter with cut-off frequency at 400 Hz.
 * Designed with Chebyshev of 2nd type
 * Optimized for fixed-point to get the following frequency response:
 *
 *  frequency:     0Hz   100Hz  200Hz  300Hz  400Hz  630Hz  1.5kHz  3kHz
 *  dB loss:     -infdB  -30dB  -20dB  -10dB  -3dB   +6dB    +1dB    0dB
 *
 * Algorithm:
 *
 *  y[i] = b[0]*x[i] + b[1]*x[i-1] + b[2]*x[i-2]
 *                   + a[1]*y[i-1] + a[2]*y[i-2];
 *
 *  short  b[3] = {3660, -7320,  3660};       in Q12
 *  short  a[3] = {4096,  7320, -3540};       in Q12
 *----------------------------------------------------------------------------------*/

const float b_hp400[3] = { 0.893554687f, -1.787109375f,  0.893554687f };
const float a_hp400[3] = { 1.000000000f,  1.787109375f, -0.864257812f };

/*----------------------------------------------------------------------------------*
 * 15th-order band-pass 6kHz to 7kHz FIR filter.
 *
 * frequency:  4kHz   5kHz  5.5kHz  6kHz  6.5kHz 7kHz  7.5kHz  8kHz
 * dB loss:   -60dB  -45dB  -13dB   -3dB   0dB   -3dB  -13dB  -45dB
 *
 * gain = 4.0
 *----------------------------------------------------------------------------------*/

const float fir_6k_7k[31] =
{
    -0.001005f,   0.001428f,   0.000965f,  -0.000863f,  -0.011296f,
    0.034231f,  -0.043397f,  -0.000000f,   0.115906f,  -0.271028f,
    0.376868f,  -0.335243f,   0.108276f,   0.237003f,  -0.549363f,
    0.675000f,  -0.549363f,   0.237003f,   0.108276f,  -0.335243f,
    0.376868f,  -0.271028f,   0.115906f,  -0.000000f,  -0.043397f,
    0.034231f,  -0.011296f,  -0.000863f,   0.000965f,   0.001428f,
    -0.001005f
};

/*----------------------------------------------------------------------------------*
 * Enhacer - 2.0 - 6.4 kHz impulse response with phase dispersion in freq. domain
 *----------------------------------------------------------------------------------*/

const float low_H[L_SUBFR] =
{
    1.000300f, 0.999812f, 1.000125f, 0.999868f, 0.999879f, 0.999935f, 0.999838f, 0.999992f, 1.000076f, 0.626554f, 0.619763f, 0.603882f, 0.857647f, 0.997470f, -0.032403f,
    0.806652f, 0.999300f, 0.946634f, 0.574139f, 0.973425f, 0.288464f, 0.890704f, 0.635021f, 0.597882f, -0.997076f, -0.110774f, -0.648392f, 0.771888f, 0.888411f, -0.774123f,
    0.695109f, 0.498998f, 0.999900f, -0.866525f, 0.719081f, 0.633481f, 0.458722f, 0.636210f, -0.761251f, 0.993932f, -0.073228f, -0.801816f, 0.772627f, -0.454461f, 0.957250f,
    -0.229682f, -0.818972f, -0.322274f, 0.031800f, -0.591141f, -0.999439f, -0.074385f, 0.514882f, -0.797032f, -0.784999f, -0.779712f, -0.000028f, 0.000164f, 0.000029f, -0.000135f,
    -0.000047f, -0.000033f, -0.000080f, 0.000099f
};

/*----------------------------------------------------------------------------------*
 * Enhancer - 3.2 - 6.4 kHz impulse response with phase dispersion in freq. domain
 *----------------------------------------------------------------------------------*/

const float mid_H[L_SUBFR] =
{
    0.999900f, 0.999848f, 1.000003f, 1.000048f, 1.000107f, 1.000242f, 1.000165f, 0.999909f, 1.000212f, 0.999933f, 1.000099f, 1.000100f, 1.000113f, 1.000018f, 0.999901f, 1.000267f,
    0.906200f, 0.587715f, 0.808629f, 0.884216f, 0.671089f, 0.039238f, 0.843369f, 0.841006f, 0.394788f, 0.528863f, 0.710110f, 0.596973f, -0.893309f, -0.059908f, 0.716925f, -0.044067f,
    1.000100f, -0.998848f, -0.697170f, 0.998190f, 0.449397f, 0.802480f, -0.704198f, -0.848591f, -0.918649f, -0.540881f, 0.537822f, -0.999200f, -0.741318f, 0.467580f, -0.588204f,
    -0.808928f, -0.422500f, 0.000219f, -0.000261f, -0.000086f, -0.000313f, 0.000080f, 0.000406f, 0.000351f, -0.000449f, -0.000065f, 0.000214f, -0.000254f, 0.000002f, -0.000090f,
    -0.000198f, 0.000193f
};

/*-------------------------------------------------------------------*
 * Low-pass FIR filter for low-freq post-filtering
 * response : 0dB @ 50Hz, -6dB @ 500Hz, -45dB @ 1kHz)
 * filter parameters: fs/2=8000, fc=500, gain=1.0, n=16
 *-------------------------------------------------------------------*/

const float tab_hup_l[SIZ_TAB_HUP_L] =
{
    -0.001246f,   0.002200f,  -0.004791f,  0.009621f,  -0.017685f,  0.031212f, -0.057225f,  0.135470f,  0.973955f, -0.103495f,  0.048663f, -0.027090f,  0.015280f, -0.008160f,
    0.003961f,  -0.001827f,  -0.002388f,  0.004479f,  -0.009715f,  0.019261f, -0.035118f,  0.061945f, -0.115187f,  0.294161f,  0.898322f, -0.170283f,  0.083211f, -0.046645f,
    0.026210f,  -0.013854f,   0.006641f, -0.003099f,  -0.003277f,  0.006456f, -0.013906f,  0.027229f, -0.049283f,  0.086990f, -0.164590f,  0.464041f,  0.780309f, -0.199879f,
    0.100795f,  -0.056792f,   0.031761f, -0.016606f,   0.007866f, -0.003740f, -0.003770f,  0.007714f, -0.016462f,  0.031849f, -0.057272f,  0.101294f, -0.195755f,  0.630993f,
    0.630993f,  -0.195755f,   0.101294f, -0.057272f,   0.031849f, -0.016462f,  0.007714f, -0.003770f, -0.003740f,  0.007866f, -0.016606f,  0.031761f, -0.056792f,  0.100795f,
    -0.199879f,   0.780309f,   0.464041f, -0.164590f,   0.086990f, -0.049283f,  0.027229f, -0.013906f,  0.006456f, -0.003277f, -0.003099f,  0.006641f, -0.013854f,  0.026210f,
    -0.046645f,   0.083211f,  -0.170283f,  0.898322f,   0.294161f, -0.115187f,  0.061945f, -0.035118f,  0.019261f, -0.009715f,  0.004479f, -0.002388f, -0.001827f,  0.003961f,
    -0.008160f,   0.015280f,  -0.027090f,  0.048663f,  -0.103495f,  0.973955f,  0.135470f, -0.057225f,  0.031212f, -0.017685f,  0.009621f, -0.004791f,  0.002200f, -0.001246f
};

const float tab_hup_s[SIZ_TAB_HUP_S] =
{
    -0.005772f,   0.087669f,   0.965882f, -0.048753f, -0.014793f,   0.214886f,  0.868791f, -0.065537f, -0.028507f,  0.374334f,  0.723418f, -0.060834f, -0.045567f,  0.550847f,
    0.550847f,  -0.045567f,  -0.060834f,  0.723418f,  0.374334f,  -0.028507f, -0.065537f,  0.868791f,  0.214886f, -0.014793f, -0.048753f,  0.965882f,  0.087669f, -0.005772f
};

/*-------------------------------------------------------------------*
 * Bass post-filter
 *-------------------------------------------------------------------*/

const float filt_lp[1+L_FILT] =
{
    0.088250f,  0.086410f,  0.081074f,  0.072768f,  0.062294f,  0.050623f,  0.038774f,  0.027692f,
    0.018130f,  0.010578f,  0.005221f,  0.001946f,  0.000385f
};

const float filt_lp_16kHz[1+L_FILT16k] =
{
    0.071410f, 0.070433f, 0.067568f, 0.062999f, 0.057020f, 0.050005f,
    0.042378f, 0.034577f, 0.027022f, 0.020078f, 0.014031f, 0.009070f,
    0.005276f, 0.002625f, 0.000999f, 0.000205f
};

/*-------------------------------------------------------------------*
 * Pulse indexing tables for ACELP innovation coding
 *-------------------------------------------------------------------*/

const int PI_select_table[23][8] =
{
    {1,     0,     0,     0,     0,     0,     0,       0},
    {1,     1,     0,     0,     0,     0,     0,       0},
    {1,     2,     1,     0,     0,     0,     0,       0},
    {1,     3,     3,     1,     0,     0,     0,       0},
    {1,     4,     6,     4,     1,     0,     0,       0},
    {1,     5,    10,    10,     5,     1,     0,       0},
    {1,     6,    15,    20,    15,     6,     1,       0},
    {1,     7,    21,    35,    35,    21,     7,       1},
    {1,     8,    28,    56,    70,    56,    28,       8},
    {1,     9,    36,    84,   126,   126,    84,      36},
    {1,    10,    45,   120,   210,   252,   210,     120},
    {1,    11,    55,   165,   330,   462,   462,     330},
    {1,    12,    66,   220,   495,   792,   924,     792},
    {1,    13,    78,   286,   715,  1287,  1716,    1716},
    {1,    14,    91,   364,  1001,  2002,  3003,    3432},
    {1,    15,   105,   455,  1365,  3003,  5005,    6435},
    {1,    16,   120,   560,  1820,  4368,  8008,   11440},
    {1,    17,   136,   680,  2380,  6188, 12376,   19448},
    {1,    18,   153,   816,  3060,  8568, 18564,   31824},
    {1,    19,   171,   969,  3876, 11628, 27132,   50388},
    {1,    20,   190,  1140,  4845, 15504, 38760,   77520},
    {1,    21,   210,  1330,  5985, 20349, 54264,  116280},
    {1,    22,   231,  1540,  7315, 26334, 74613, 1705444}
};

const int PI_offset[8][8] =
{
    /* for 0p(0). */
    {0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000},
    /* for 1p(1). */
    {0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000},
    /* for 2p(2,1). */
    {0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000},
    /* for 3p(3,2,1). */
    {0x00000,0x00000,0x01180,0x01540,0x00000,0x00000,0x00000,0x00000},
    /* for 4p(4,3,2,1). */
    {0x00000,0x00000,0x071C0,0x0A640,0x0ABE0,0x00000,0x00000,0x00000},
    /* for 5p(5,4,3,2,1). */
    {0x00000,0x00000,0x22200,0x3E900,0x45200,0x45980,0x00000,0x00000},
    /* for 6p(6,5,4,3,2,1). */
    {0x00000,0x00000,0x07d200,0x127c00,0x16ed80,0x179c80,0x17a5e0,0x00000},
    /* for 7p(7,6,5,4,3,2,1). */
    {0x00000,0x00000,0x165800,0x454400,0x654200,0x6E2500,0x6F2B80,0x6F36C0}
};

const short PI_factor[7] = {0,0,120,560,1820,4368,8008};

/*------------------------------------------------------------------------------*
 * EDCT tables
 *------------------------------------------------------------------------------*/

const float edct_table_80[80] =
{
    0.33433591f, 0.33420702f, 0.33394929f, 0.33356281f, 0.33304773f, 0.33240426f, 0.33163264f, 0.33073317f,
    0.32970620f, 0.32855212f, 0.32727137f, 0.32586446f, 0.32433192f, 0.32267434f, 0.32089236f, 0.31898668f,
    0.31695802f, 0.31480717f, 0.31253495f, 0.31014224f, 0.30762997f, 0.30499910f, 0.30225065f, 0.29938568f,
    0.29640528f, 0.29331062f, 0.29010288f, 0.28678330f, 0.28335316f, 0.27981378f, 0.27616653f, 0.27241281f,
    0.26855407f, 0.26459179f, 0.26052751f, 0.25636280f, 0.25209925f, 0.24773851f, 0.24328226f, 0.23873223f,
    0.23409016f, 0.22935784f, 0.22453710f, 0.21962979f, 0.21463782f, 0.20956310f, 0.20440759f, 0.19917327f,
    0.19386217f, 0.18847633f, 0.18301783f, 0.17748878f, 0.17189129f, 0.16622755f, 0.16049971f, 0.15471000f,
    0.14886065f, 0.14295391f, 0.13699206f, 0.13097739f, 0.12491224f, 0.11879892f, 0.11263981f, 0.10643727f,
    0.10019369f, 0.09391149f, 0.08759309f, 0.08124092f, 0.07485742f, 0.06844507f, 0.06200633f, 0.05554369f,
    0.04905963f, 0.04255666f, 0.03603728f, 0.02950402f, 0.02295937f, 0.01640588f, 0.00984606f, 0.00328244f
};

const float edct_table_120[120] =
{
    0.30212379f, 0.30207202f, 0.30196850f, 0.30181323f, 0.30160625f, 0.30134759f, 0.30103730f, 0.30067542f,
    0.30026203f, 0.29979718f, 0.29928097f, 0.29871348f, 0.29809481f, 0.29742505f, 0.29670434f, 0.29593279f,
    0.29511053f, 0.29423770f, 0.29331446f, 0.29234097f, 0.29131738f, 0.29024387f, 0.28912063f, 0.28794786f,
    0.28672574f, 0.28545450f, 0.28413434f, 0.28276550f, 0.28134821f, 0.27988271f, 0.27836926f, 0.27680811f,
    0.27519952f, 0.27354379f, 0.27184118f, 0.27009200f, 0.26829654f, 0.26645510f, 0.26456801f, 0.26263559f,
    0.26065816f, 0.25863608f, 0.25656968f, 0.25445931f, 0.25230535f, 0.25010815f, 0.24786810f, 0.24558558f,
    0.24326098f, 0.24089470f, 0.23848714f, 0.23603872f, 0.23354985f, 0.23102097f, 0.22845250f, 0.22584489f,
    0.22319858f, 0.22051402f, 0.21779168f, 0.21503203f, 0.21223553f, 0.20940267f, 0.20653392f, 0.20362979f,
    0.20069076f, 0.19771735f, 0.19471006f, 0.19166941f, 0.18859591f, 0.18549011f, 0.18235251f, 0.17918368f,
    0.17598414f, 0.17275445f, 0.16949515f, 0.16620682f, 0.16289000f, 0.15954528f, 0.15617322f, 0.15277439f,
    0.14934940f, 0.14589881f, 0.14242322f, 0.13892323f, 0.13539943f, 0.13185244f, 0.12828285f, 0.12469128f,
    0.12107835f, 0.11744467f, 0.11379087f, 0.11011757f, 0.10642540f, 0.10271499f, 0.09898699f, 0.09524203f,
    0.09148074f, 0.08770378f, 0.08391180f, 0.08010544f, 0.07628535f, 0.07245219f, 0.06860661f, 0.06474928f,
    0.06088086f, 0.05700200f, 0.05311338f, 0.04921565f, 0.04530949f, 0.04139557f, 0.03747456f, 0.03354713f,
    0.02961394f, 0.02567569f, 0.02173303f, 0.01778665f, 0.01383722f, 0.00988542f, 0.00593193f, 0.00197742f
};

const float edct_table_320[320] =
{
    0.23643389f, 0.23642819f, 0.23641680f, 0.23639971f, 0.23637692f, 0.23634844f, 0.23631426f, 0.23627439f,
    0.23622882f, 0.23617757f, 0.23612062f, 0.23605798f, 0.23598966f, 0.23591565f, 0.23583595f, 0.23575057f,
    0.23565951f, 0.23556278f, 0.23546036f, 0.23535227f, 0.23523852f, 0.23511909f, 0.23499400f, 0.23486324f,
    0.23472683f, 0.23458476f, 0.23443704f, 0.23428367f, 0.23412465f, 0.23396000f, 0.23378970f, 0.23361377f,
    0.23343222f, 0.23324504f, 0.23305223f, 0.23285382f, 0.23264979f, 0.23244015f, 0.23222492f, 0.23200409f,
    0.23177767f, 0.23154566f, 0.23130808f, 0.23106492f, 0.23081619f, 0.23056191f, 0.23030206f, 0.23003667f,
    0.22976573f, 0.22948926f, 0.22920726f, 0.22891974f, 0.22862670f, 0.22832815f, 0.22802410f, 0.22771455f,
    0.22739952f, 0.22707901f, 0.22675302f, 0.22642158f, 0.22608467f, 0.22574232f, 0.22539453f, 0.22504131f,
    0.22468267f, 0.22431861f, 0.22394915f, 0.22357429f, 0.22319405f, 0.22280842f, 0.22241743f, 0.22202108f,
    0.22161938f, 0.22121233f, 0.22079996f, 0.22038227f, 0.21995927f, 0.21953096f, 0.21909737f, 0.21865850f,
    0.21821436f, 0.21776496f, 0.21731032f, 0.21685044f, 0.21638533f, 0.21591501f, 0.21543948f, 0.21495877f,
    0.21447288f, 0.21398181f, 0.21348560f, 0.21298423f, 0.21247774f, 0.21196612f, 0.21144940f, 0.21092759f,
    0.21040069f, 0.20986872f, 0.20933169f, 0.20878962f, 0.20824252f, 0.20769041f, 0.20713328f, 0.20657117f,
    0.20600408f, 0.20543202f, 0.20485502f, 0.20427308f, 0.20368621f, 0.20309444f, 0.20249778f, 0.20189623f,
    0.20128983f, 0.20067857f, 0.20006247f, 0.19944156f, 0.19881584f, 0.19818532f, 0.19755004f, 0.19690999f,
    0.19626520f, 0.19561568f, 0.19496144f, 0.19430251f, 0.19363890f, 0.19297062f, 0.19229769f, 0.19162012f,
    0.19093794f, 0.19025116f, 0.18955980f, 0.18886386f, 0.18816338f, 0.18745836f, 0.18674883f, 0.18603479f,
    0.18531628f, 0.18459330f, 0.18386586f, 0.18313400f, 0.18239773f, 0.18165706f, 0.18091202f, 0.18016261f,
    0.17940887f, 0.17865080f, 0.17788842f, 0.17712176f, 0.17635084f, 0.17557566f, 0.17479625f, 0.17401263f,
    0.17322482f, 0.17243283f, 0.17163669f, 0.17083642f, 0.17003202f, 0.16922353f, 0.16841096f, 0.16759434f,
    0.16677367f, 0.16594899f, 0.16512031f, 0.16428765f, 0.16345103f, 0.16261047f, 0.16176600f, 0.16091763f,
    0.16006537f, 0.15920927f, 0.15834932f, 0.15748556f, 0.15661801f, 0.15574668f, 0.15487160f, 0.15399279f,
    0.15311027f, 0.15222405f, 0.15133417f, 0.15044065f, 0.14954350f, 0.14864274f, 0.14773840f, 0.14683051f,
    0.14591907f, 0.14500412f, 0.14408568f, 0.14316376f, 0.14223840f, 0.14130960f, 0.14037740f, 0.13944182f,
    0.13850288f, 0.13756060f, 0.13661501f, 0.13566613f, 0.13471397f, 0.13375858f, 0.13279995f, 0.13183813f,
    0.13087313f, 0.12990498f, 0.12893370f, 0.12795931f, 0.12698183f, 0.12600130f, 0.12501773f, 0.12403115f,
    0.12304158f, 0.12204905f, 0.12105357f, 0.12005518f, 0.11905390f, 0.11804974f, 0.11704275f, 0.11603293f,
    0.11502031f, 0.11400493f, 0.11298680f, 0.11196594f, 0.11094239f, 0.10991616f, 0.10888729f, 0.10785579f,
    0.10682169f, 0.10578502f, 0.10474580f, 0.10370406f, 0.10265981f, 0.10161310f, 0.10056393f, 0.09951234f,
    0.09845836f, 0.09740200f, 0.09634329f, 0.09528227f, 0.09421894f, 0.09315335f, 0.09208551f, 0.09101546f,
    0.08994321f, 0.08886879f, 0.08779223f, 0.08671356f, 0.08563280f, 0.08454997f, 0.08346511f, 0.08237823f,
    0.08128937f, 0.08019855f, 0.07910580f, 0.07801115f, 0.07691461f, 0.07581622f, 0.07471600f, 0.07361399f,
    0.07251019f, 0.07140466f, 0.07029740f, 0.06918844f, 0.06807783f, 0.06696557f, 0.06585169f, 0.06473623f,
    0.06361921f, 0.06250066f, 0.06138060f, 0.06025906f, 0.05913607f, 0.05801166f, 0.05688584f, 0.05575866f,
    0.05463013f, 0.05350029f, 0.05236916f, 0.05123676f, 0.05010313f, 0.04896830f, 0.04783228f, 0.04669511f,
    0.04555682f, 0.04441742f, 0.04327696f, 0.04213546f, 0.04099294f, 0.03984943f, 0.03870496f, 0.03755956f,
    0.03641326f, 0.03526607f, 0.03411804f, 0.03296919f, 0.03181954f, 0.03066912f, 0.02951797f, 0.02836610f,
    0.02721355f, 0.02606034f, 0.02490651f, 0.02375208f, 0.02259707f, 0.02144152f, 0.02028545f, 0.01912890f,
    0.01797188f, 0.01681443f, 0.01565658f, 0.01449834f, 0.01333976f, 0.01218086f, 0.01102166f, 0.00986220f,
    0.00870250f, 0.00754259f, 0.00638250f, 0.00522226f, 0.00406188f, 0.00290142f, 0.00174088f, 0.00058030f
};

const float edct_table_480[480] =
{
    0.21364290f, 0.21364061f, 0.21363603f, 0.21362917f, 0.21362002f, 0.21360858f, 0.21359485f, 0.21357884f,
    0.21356053f, 0.21353995f, 0.21351707f, 0.21349191f, 0.21346446f, 0.21343473f, 0.21340271f, 0.21336840f,
    0.21333181f, 0.21329294f, 0.21325178f, 0.21320833f, 0.21316261f, 0.21311460f, 0.21306431f, 0.21301173f,
    0.21295688f, 0.21289974f, 0.21284033f, 0.21277863f, 0.21271466f, 0.21264841f, 0.21257988f, 0.21250908f,
    0.21243600f, 0.21236064f, 0.21228301f, 0.21220311f, 0.21212093f, 0.21203649f, 0.21194977f, 0.21186078f,
    0.21176952f, 0.21167600f, 0.21158021f, 0.21148215f, 0.21138183f, 0.21127924f, 0.21117439f, 0.21106728f,
    0.21095791f, 0.21084628f, 0.21073239f, 0.21061625f, 0.21049785f, 0.21037720f, 0.21025429f, 0.21012913f,
    0.21000172f, 0.20987206f, 0.20974016f, 0.20960601f, 0.20946961f, 0.20933097f, 0.20919009f, 0.20904697f,
    0.20890161f, 0.20875401f, 0.20860417f, 0.20845211f, 0.20829781f, 0.20814128f, 0.20798252f, 0.20782153f,
    0.20765832f, 0.20749288f, 0.20732522f, 0.20715535f, 0.20698325f, 0.20680894f, 0.20663241f, 0.20645367f,
    0.20627271f, 0.20608955f, 0.20590418f, 0.20571661f, 0.20552684f, 0.20533486f, 0.20514068f, 0.20494431f,
    0.20474574f, 0.20454498f, 0.20434203f, 0.20413689f, 0.20392956f, 0.20372005f, 0.20350836f, 0.20329449f,
    0.20307844f, 0.20286022f, 0.20263983f, 0.20241726f, 0.20219253f, 0.20196563f, 0.20173657f, 0.20150535f,
    0.20127197f, 0.20103643f, 0.20079874f, 0.20055891f, 0.20031692f, 0.20007279f, 0.19982652f, 0.19957810f,
    0.19932755f, 0.19907486f, 0.19882005f, 0.19856310f, 0.19830403f, 0.19804283f, 0.19777951f, 0.19751407f,
    0.19724652f, 0.19697686f, 0.19670509f, 0.19643121f, 0.19615522f, 0.19587714f, 0.19559696f, 0.19531468f,
    0.19503031f, 0.19474386f, 0.19445531f, 0.19416469f, 0.19387199f, 0.19357720f, 0.19328035f, 0.19298143f,
    0.19268044f, 0.19237739f, 0.19207227f, 0.19176510f, 0.19145588f, 0.19114460f, 0.19083128f, 0.19051592f,
    0.19019851f, 0.18987907f, 0.18955759f, 0.18923409f, 0.18890856f, 0.18858100f, 0.18825143f, 0.18791983f,
    0.18758623f, 0.18725062f, 0.18691300f, 0.18657338f, 0.18623176f, 0.18588815f, 0.18554255f, 0.18519496f,
    0.18484539f, 0.18449384f, 0.18414031f, 0.18378481f, 0.18342734f, 0.18306791f, 0.18270651f, 0.18234316f,
    0.18197786f, 0.18161061f, 0.18124141f, 0.18087028f, 0.18049720f, 0.18012220f, 0.17974526f, 0.17936640f,
    0.17898562f, 0.17860292f, 0.17821831f, 0.17783179f, 0.17744336f, 0.17705304f, 0.17666082f, 0.17626671f,
    0.17587071f, 0.17547282f, 0.17507306f, 0.17467142f, 0.17426791f, 0.17386254f, 0.17345530f, 0.17304621f,
    0.17263526f, 0.17222246f, 0.17180782f, 0.17139134f, 0.17097303f, 0.17055288f, 0.17013091f, 0.16970711f,
    0.16928150f, 0.16885407f, 0.16842484f, 0.16799380f, 0.16756096f, 0.16712633f, 0.16668991f, 0.16625171f,
    0.16581172f, 0.16536996f, 0.16492642f, 0.16448113f, 0.16403406f, 0.16358525f, 0.16313468f, 0.16268236f,
    0.16222830f, 0.16177251f, 0.16131498f, 0.16085572f, 0.16039474f, 0.15993205f, 0.15946764f, 0.15900152f,
    0.15853370f, 0.15806419f, 0.15759298f, 0.15712008f, 0.15664550f, 0.15616924f, 0.15569131f, 0.15521171f,
    0.15473045f, 0.15424753f, 0.15376297f, 0.15327675f, 0.15278889f, 0.15229940f, 0.15180828f, 0.15131553f,
    0.15082115f, 0.15032517f, 0.14982757f, 0.14932837f, 0.14882757f, 0.14832518f, 0.14782120f, 0.14731564f,
    0.14680849f, 0.14629978f, 0.14578950f, 0.14527766f, 0.14476426f, 0.14424931f, 0.14373282f, 0.14321478f,
    0.14269522f, 0.14217412f, 0.14165151f, 0.14112737f, 0.14060173f, 0.14007458f, 0.13954592f, 0.13901578f,
    0.13848414f, 0.13795103f, 0.13741643f, 0.13688037f, 0.13634283f, 0.13580384f, 0.13526339f, 0.13472150f,
    0.13417816f, 0.13363339f, 0.13308718f, 0.13253955f, 0.13199050f, 0.13144003f, 0.13088816f, 0.13033489f,
    0.12978022f, 0.12922416f, 0.12866672f, 0.12810790f, 0.12754770f, 0.12698614f, 0.12642323f, 0.12585895f,
    0.12529333f, 0.12472637f, 0.12415807f, 0.12358845f, 0.12301749f, 0.12244523f, 0.12187165f, 0.12129676f,
    0.12072058f, 0.12014310f, 0.11956434f, 0.11898429f, 0.11840297f, 0.11782039f, 0.11723654f, 0.11665144f,
    0.11606508f, 0.11547749f, 0.11488866f, 0.11429859f, 0.11370731f, 0.11311480f, 0.11252109f, 0.11192617f,
    0.11133005f, 0.11073273f, 0.11013424f, 0.10953456f, 0.10893371f, 0.10833169f, 0.10772852f, 0.10712419f,
    0.10651871f, 0.10591209f, 0.10530434f, 0.10469546f, 0.10408546f, 0.10347434f, 0.10286212f, 0.10224879f,
    0.10163437f, 0.10101886f, 0.10040227f, 0.09978460f, 0.09916587f, 0.09854607f, 0.09792522f, 0.09730332f,
    0.09668037f, 0.09605639f, 0.09543139f, 0.09480536f, 0.09417831f, 0.09355026f, 0.09292121f, 0.09229116f,
    0.09166012f, 0.09102810f, 0.09039510f, 0.08976114f, 0.08912622f, 0.08849034f, 0.08785351f, 0.08721574f,
    0.08657704f, 0.08593742f, 0.08529687f, 0.08465540f, 0.08401304f, 0.08336977f, 0.08272561f, 0.08208056f,
    0.08143463f, 0.08078784f, 0.08014017f, 0.07949165f, 0.07884228f, 0.07819206f, 0.07754101f, 0.07688912f,
    0.07623641f, 0.07558289f, 0.07492855f, 0.07427342f, 0.07361748f, 0.07296076f, 0.07230326f, 0.07164499f,
    0.07098594f, 0.07032614f, 0.06966558f, 0.06900428f, 0.06834224f, 0.06767946f, 0.06701596f, 0.06635175f,
    0.06568682f, 0.06502119f, 0.06435487f, 0.06368785f, 0.06302015f, 0.06235178f, 0.06168274f, 0.06101304f,
    0.06034268f, 0.05967168f, 0.05900004f, 0.05832777f, 0.05765488f, 0.05698136f, 0.05630724f, 0.05563251f,
    0.05495719f, 0.05428128f, 0.05360479f, 0.05292772f, 0.05225009f, 0.05157189f, 0.05089315f, 0.05021386f,
    0.04953403f, 0.04885367f, 0.04817279f, 0.04749139f, 0.04680949f, 0.04612708f, 0.04544418f, 0.04476079f,
    0.04407692f, 0.04339258f, 0.04270778f, 0.04202252f, 0.04133681f, 0.04065065f, 0.03996406f, 0.03927704f,
    0.03858961f, 0.03790175f, 0.03721350f, 0.03652484f, 0.03583579f, 0.03514636f, 0.03445656f, 0.03376638f,
    0.03307584f, 0.03238495f, 0.03169371f, 0.03100213f, 0.03031022f, 0.02961799f, 0.02892544f, 0.02823258f,
    0.02753941f, 0.02684595f, 0.02615221f, 0.02545818f, 0.02476388f, 0.02406932f, 0.02337449f, 0.02267942f,
    0.02198411f, 0.02128856f, 0.02059278f, 0.01989678f, 0.01920056f, 0.01850415f, 0.01780753f, 0.01711072f,
    0.01641373f, 0.01571657f, 0.01501923f, 0.01432174f, 0.01362409f, 0.01292630f, 0.01222836f, 0.01153030f,
    0.01083211f, 0.01013381f, 0.00943540f, 0.00873688f, 0.00803828f, 0.00733959f, 0.00664081f, 0.00594197f,
    0.00524307f, 0.00454410f, 0.00384509f, 0.00314604f, 0.00244696f, 0.00174784f, 0.00104871f, 0.00034957f
};

const float edct_table_128[128] =
{
    0.29728989f, 0.29724512f, 0.29715558f, 0.29702130f, 0.29684228f, 0.29661856f, 0.29635017f, 0.29603715f,
    0.29567955f, 0.29527743f, 0.29483083f, 0.29433983f, 0.29380451f, 0.29322494f, 0.29260121f, 0.29193342f,
    0.29122167f, 0.29046605f, 0.28966670f, 0.28882372f, 0.28793724f, 0.28700741f, 0.28603435f, 0.28501821f,
    0.28395915f, 0.28285733f, 0.28171292f, 0.28052607f, 0.27929698f, 0.27802583f, 0.27671281f, 0.27535812f,
    0.27396196f, 0.27252454f, 0.27104609f, 0.26952681f, 0.26796694f, 0.26636672f, 0.26472638f, 0.26304618f,
    0.26132636f, 0.25956719f, 0.25776893f, 0.25593185f, 0.25405623f, 0.25214235f, 0.25019049f, 0.24820096f,
    0.24617405f, 0.24411007f, 0.24200932f, 0.23987213f, 0.23769882f, 0.23548971f, 0.23324513f, 0.23096543f,
    0.22865095f, 0.22630203f, 0.22391903f, 0.22150231f, 0.21905224f, 0.21656917f, 0.21405349f, 0.21150558f,
    0.20892581f, 0.20631458f, 0.20367228f, 0.20099931f, 0.19829606f, 0.19556296f, 0.19280040f, 0.19000881f,
    0.18718860f, 0.18434021f, 0.18146405f, 0.17856057f, 0.17563019f, 0.17267337f, 0.16969054f, 0.16668215f,
    0.16364867f, 0.16059054f, 0.15750822f, 0.15440219f, 0.15127290f, 0.14812083f, 0.14494646f, 0.14175026f,
    0.13853271f, 0.13529429f, 0.13203551f, 0.12875684f, 0.12545877f, 0.12214182f, 0.11880647f, 0.11545323f,
    0.11208260f, 0.10869509f, 0.10529122f, 0.10187148f, 0.09843641f, 0.09498651f, 0.09152231f, 0.08804432f,
    0.08455308f, 0.08104910f, 0.07753291f, 0.07400505f, 0.07046605f, 0.06691643f, 0.06335674f, 0.05978750f,
    0.05620926f, 0.05262256f, 0.04902793f, 0.04542591f, 0.04181706f, 0.03820191f, 0.03458100f, 0.03095489f,
    0.02732412f, 0.02368923f, 0.02005077f, 0.01640930f, 0.01276535f, 0.00911948f, 0.00547224f, 0.00182417f
};

const float edct_table_160[160] =
{
    0.28116346f, 0.28113637f, 0.28108217f, 0.28100088f, 0.28089251f, 0.28075707f, 0.28059457f, 0.28040502f,
    0.28018844f, 0.27994487f, 0.27967431f, 0.27937679f, 0.27905235f, 0.27870101f, 0.27832281f, 0.27791778f,
    0.27748597f, 0.27702741f, 0.27654216f, 0.27603024f, 0.27549173f, 0.27492666f, 0.27433510f, 0.27371709f,
    0.27307270f, 0.27240199f, 0.27170503f, 0.27098188f, 0.27023261f, 0.26945730f, 0.26865602f, 0.26782884f,
    0.26697585f, 0.26609713f, 0.26519276f, 0.26426283f, 0.26330743f, 0.26232665f, 0.26132059f, 0.26028934f,
    0.25923300f, 0.25815168f, 0.25704548f, 0.25591450f, 0.25475886f, 0.25357866f, 0.25237403f, 0.25114506f,
    0.24989190f, 0.24861465f, 0.24731343f, 0.24598838f, 0.24463962f, 0.24326728f, 0.24187150f, 0.24045240f,
    0.23901013f, 0.23754482f, 0.23605661f, 0.23454566f, 0.23301210f, 0.23145608f, 0.22987775f, 0.22827726f,
    0.22665478f, 0.22501045f, 0.22334443f, 0.22165688f, 0.21994797f, 0.21821787f, 0.21646673f, 0.21469472f,
    0.21290203f, 0.21108881f, 0.20925525f, 0.20740152f, 0.20552780f, 0.20363427f, 0.20172112f, 0.19978852f,
    0.19783667f, 0.19586574f, 0.19387594f, 0.19186746f, 0.18984048f, 0.18779520f, 0.18573183f, 0.18365055f,
    0.18155157f, 0.17943510f, 0.17730133f, 0.17515047f, 0.17298273f, 0.17079832f, 0.16859744f, 0.16638032f,
    0.16414716f, 0.16189818f, 0.15963359f, 0.15735362f, 0.15505848f, 0.15274840f, 0.15042360f, 0.14808429f,
    0.14573072f, 0.14336310f, 0.14098166f, 0.13858663f, 0.13617825f, 0.13375674f, 0.13132234f, 0.12887528f,
    0.12641580f, 0.12394414f, 0.12146053f, 0.11896521f, 0.11645843f, 0.11394042f, 0.11141144f, 0.10887171f,
    0.10632149f, 0.10376102f, 0.10119055f, 0.09861033f, 0.09602061f, 0.09342163f, 0.09081364f, 0.08819691f,
    0.08557167f, 0.08293818f, 0.08029671f, 0.07764749f, 0.07499079f, 0.07232686f, 0.06965596f, 0.06697834f,
    0.06429427f, 0.06160401f, 0.05890780f, 0.05620592f, 0.05349862f, 0.05078617f, 0.04806882f, 0.04534683f,
    0.04262048f, 0.03989002f, 0.03715571f, 0.03441782f, 0.03167662f, 0.02893236f, 0.02618532f, 0.02343575f,
    0.02068392f, 0.01793009f, 0.01517454f, 0.01241753f, 0.00965932f, 0.00690018f, 0.00414037f, 0.00138017f
};

const float edct_table_40[40] =
{
    0.39747255f, 0.39685967f, 0.39563487f, 0.39380003f, 0.39135797f, 0.38831247f, 0.38466823f, 0.38043085f,
    0.37560687f, 0.37020373f, 0.36422977f, 0.35769419f, 0.35060707f, 0.34297935f, 0.33482277f, 0.32614992f,
    0.31697417f, 0.30730967f, 0.29717132f, 0.28657476f, 0.27553631f, 0.26407301f, 0.25220253f, 0.23994317f,
    0.22731383f, 0.21433400f, 0.20102367f, 0.18740339f, 0.17349414f, 0.15931737f, 0.14489495f, 0.13024911f,
    0.11540244f, 0.10037782f, 0.08519843f, 0.06988767f, 0.05446914f, 0.03896663f, 0.02340404f, 0.00780536f
};

const float edct_table_20[20] =
{
    0.47209725f, 0.46918661f, 0.46338329f, 0.45472305f, 0.44325929f, 0.42906269f, 0.41222077f, 0.39283738f,
    0.37103202f, 0.34693912f, 0.32070722f, 0.29249806f, 0.26248555f, 0.23085473f, 0.19780061f, 0.16352698f,
    0.12824516f, 0.09217267f, 0.05553190f, 0.01854875f
};


const float edct_table_64[64] =
{
    0.35349683f, 0.35328389f, 0.35285816f, 0.35221987f, 0.35136942f, 0.35030732f, 0.34903420f, 0.34755084f,
    0.34585813f, 0.34395709f, 0.34184886f, 0.33953471f, 0.33701604f, 0.33429436f, 0.33137132f, 0.32824867f,
    0.32492830f, 0.32141220f, 0.31770249f, 0.31380142f, 0.30971132f, 0.30543466f, 0.30097402f, 0.29633209f,
    0.29151165f, 0.28651562f, 0.28134701f, 0.27600892f, 0.27050457f, 0.26483728f, 0.25901046f, 0.25302763f,
    0.24689238f, 0.24060841f, 0.23417951f, 0.22760955f, 0.22090248f, 0.21406235f, 0.20709328f, 0.19999946f,
    0.19278517f, 0.18545475f, 0.17801263f, 0.17046327f, 0.16281123f, 0.15506112f, 0.14721761f, 0.13928542f,
    0.13126933f, 0.12317417f, 0.11500482f, 0.10676618f, 0.09846324f, 0.09010099f, 0.08168446f, 0.07321873f,
    0.06470889f, 0.05616008f, 0.04757744f, 0.03896613f, 0.03033136f, 0.02167832f, 0.01301222f, 0.00433828f
};

const float edct_table_100[100] =
{
    0.31620704f, 0.31612902f, 0.31597300f, 0.31573902f, 0.31542714f, 0.31503742f, 0.31456998f, 0.31402492f,
    0.31340238f, 0.31270252f, 0.31192550f, 0.31107151f, 0.31014078f, 0.30913352f, 0.30804998f, 0.30689044f,
    0.30565518f, 0.30434451f, 0.30295874f, 0.30149822f, 0.29996331f, 0.29835439f, 0.29667186f, 0.29491612f,
    0.29308762f, 0.29118680f, 0.28921414f, 0.28717012f, 0.28505525f, 0.28287004f, 0.28061503f, 0.27829079f,
    0.27589789f, 0.27343691f, 0.27090847f, 0.26831318f, 0.26565169f, 0.26292465f, 0.26013275f, 0.25727665f,
    0.25435708f, 0.25137475f, 0.24833040f, 0.24522478f, 0.24205865f, 0.23883279f, 0.23554801f, 0.23220511f,
    0.22880491f, 0.22534827f, 0.22183602f, 0.21826903f, 0.21464819f, 0.21097439f, 0.20724854f, 0.20347155f,
    0.19964436f, 0.19576790f, 0.19184315f, 0.18787106f, 0.18385261f, 0.17978880f, 0.17568064f, 0.17152912f,
    0.16733529f, 0.16310016f, 0.15882480f, 0.15451024f, 0.15015756f, 0.14576784f, 0.14134215f, 0.13688158f,
    0.13238724f, 0.12786023f, 0.12330168f, 0.11871271f, 0.11409444f, 0.10944803f, 0.10477460f, 0.10007533f,
    0.09535137f, 0.09060388f, 0.08583403f, 0.08104300f, 0.07623198f, 0.07140215f, 0.06655470f, 0.06169084f,
    0.05681175f, 0.05191864f, 0.04701272f, 0.04209520f, 0.03716730f, 0.03223022f, 0.02728520f, 0.02233344f,
    0.01737617f, 0.01241461f, 0.00744999f, 0.00248354f
};


const float edct_table_200[200] =
{
    0.26591044f, 0.26589403f, 0.26586123f, 0.26581203f, 0.26574643f, 0.26566443f, 0.26556605f, 0.26545129f,
    0.26532015f, 0.26517265f, 0.26500879f, 0.26482859f, 0.26463205f, 0.26441918f, 0.26419000f, 0.26394453f,
    0.26368278f, 0.26340476f, 0.26311049f, 0.26279999f, 0.26247328f, 0.26213038f, 0.26177132f, 0.26139610f,
    0.26100476f, 0.26059732f, 0.26017381f, 0.25973424f, 0.25927866f, 0.25880708f, 0.25831954f, 0.25781606f,
    0.25729668f, 0.25676143f, 0.25621034f, 0.25564344f, 0.25506078f, 0.25446238f, 0.25384829f, 0.25321854f,
    0.25257317f, 0.25191222f, 0.25123573f, 0.25054374f, 0.24983629f, 0.24911344f, 0.24837522f, 0.24762168f,
    0.24685286f, 0.24606882f, 0.24526960f, 0.24445525f, 0.24362582f, 0.24278136f, 0.24192193f, 0.24104757f,
    0.24015834f, 0.23925430f, 0.23833551f, 0.23740201f, 0.23645386f, 0.23549113f, 0.23451388f, 0.23352215f,
    0.23251603f, 0.23149556f, 0.23046081f, 0.22941185f, 0.22834873f, 0.22727153f, 0.22618031f, 0.22507514f,
    0.22395608f, 0.22282321f, 0.22167659f, 0.22051630f, 0.21934241f, 0.21815499f, 0.21695411f, 0.21573985f,
    0.21451228f, 0.21327148f, 0.21201752f, 0.21075048f, 0.20947045f, 0.20817749f, 0.20687169f, 0.20555313f,
    0.20422189f, 0.20287806f, 0.20152171f, 0.20015293f, 0.19877180f, 0.19737841f, 0.19597285f, 0.19455519f,
    0.19312554f, 0.19168397f, 0.19023058f, 0.18876546f, 0.18728869f, 0.18580037f, 0.18430058f, 0.18278943f,
    0.18126701f, 0.17973340f, 0.17818870f, 0.17663302f, 0.17506644f, 0.17348906f, 0.17190097f, 0.17030229f,
    0.16869310f, 0.16707350f, 0.16544360f, 0.16380349f, 0.16215328f, 0.16049306f, 0.15882295f, 0.15714304f,
    0.15545343f, 0.15375424f, 0.15204556f, 0.15032750f, 0.14860017f, 0.14686367f, 0.14511812f, 0.14336361f,
    0.14160026f, 0.13982818f, 0.13804747f, 0.13625824f, 0.13446061f, 0.13265468f, 0.13084058f, 0.12901840f,
    0.12718826f, 0.12535028f, 0.12350456f, 0.12165123f, 0.11979039f, 0.11792217f, 0.11604667f, 0.11416401f,
    0.11227431f, 0.11037768f, 0.10847425f, 0.10656412f, 0.10464742f, 0.10272426f, 0.10079477f, 0.09885906f,
    0.09691726f, 0.09496947f, 0.09301583f, 0.09105645f, 0.08909145f, 0.08712096f, 0.08514509f, 0.08316397f,
    0.08117772f, 0.07918646f, 0.07719032f, 0.07518942f, 0.07318388f, 0.07117382f, 0.06915937f, 0.06714066f,
    0.06511781f, 0.06309094f, 0.06106018f, 0.05902565f, 0.05698748f, 0.05494580f, 0.05290072f, 0.05085238f,
    0.04880091f, 0.04674643f, 0.04468906f, 0.04262893f, 0.04056618f, 0.03850092f, 0.03643329f, 0.03436341f,
    0.03229142f, 0.03021743f, 0.02814157f, 0.02606398f, 0.02398478f, 0.02190411f, 0.01982208f, 0.01773883f,
    0.01565448f, 0.01356917f, 0.01148302f, 0.00939617f, 0.00730873f, 0.00522084f, 0.00313264f, 0.00104423f
};

const float edct_table_240[240] =
{
    0.25406349f, 0.25405260f, 0.25403084f, 0.25399819f, 0.25395466f, 0.25390025f, 0.25383497f, 0.25375881f,
    0.25367179f, 0.25357389f, 0.25346514f, 0.25334553f, 0.25321506f, 0.25307375f, 0.25292160f, 0.25275861f,
    0.25258479f, 0.25240016f, 0.25220471f, 0.25199846f, 0.25178142f, 0.25155358f, 0.25131498f, 0.25106561f,
    0.25080548f, 0.25053461f, 0.25025301f, 0.24996068f, 0.24965766f, 0.24934393f, 0.24901953f, 0.24868445f,
    0.24833873f, 0.24798236f, 0.24761538f, 0.24723778f, 0.24684960f, 0.24645084f, 0.24604153f, 0.24562167f,
    0.24519129f, 0.24475042f, 0.24429905f, 0.24383722f, 0.24336495f, 0.24288225f, 0.24238915f, 0.24188566f,
    0.24137181f, 0.24084762f, 0.24031312f, 0.23976832f, 0.23921325f, 0.23864793f, 0.23807239f, 0.23748665f,
    0.23689074f, 0.23628468f, 0.23566850f, 0.23504223f, 0.23440588f, 0.23375950f, 0.23310310f, 0.23243671f,
    0.23176037f, 0.23107410f, 0.23037794f, 0.22967190f, 0.22895603f, 0.22823035f, 0.22749489f, 0.22674968f,
    0.22599477f, 0.22523017f, 0.22445592f, 0.22367206f, 0.22287862f, 0.22207563f, 0.22126313f, 0.22044115f,
    0.21960972f, 0.21876889f, 0.21791869f, 0.21705915f, 0.21619032f, 0.21531222f, 0.21442490f, 0.21352839f,
    0.21262274f, 0.21170798f, 0.21078415f, 0.20985130f, 0.20890945f, 0.20795865f, 0.20699895f, 0.20603038f,
    0.20505298f, 0.20406680f, 0.20307188f, 0.20206825f, 0.20105598f, 0.20003509f, 0.19900563f, 0.19796764f,
    0.19692118f, 0.19586628f, 0.19480299f, 0.19373136f, 0.19265142f, 0.19156324f, 0.19046685f, 0.18936230f,
    0.18824963f, 0.18712891f, 0.18600017f, 0.18486346f, 0.18371883f, 0.18256633f, 0.18140601f, 0.18023792f,
    0.17906211f, 0.17787863f, 0.17668753f, 0.17548886f, 0.17428267f, 0.17306902f, 0.17184795f, 0.17061952f,
    0.16938379f, 0.16814079f, 0.16689060f, 0.16563326f, 0.16436882f, 0.16309734f, 0.16181887f, 0.16053347f,
    0.15924120f, 0.15794210f, 0.15663624f, 0.15532366f, 0.15400444f, 0.15267862f, 0.15134625f, 0.15000741f,
    0.14866213f, 0.14731049f, 0.14595254f, 0.14458834f, 0.14321795f, 0.14184141f, 0.14045881f, 0.13907018f,
    0.13767560f, 0.13627512f, 0.13486881f, 0.13345671f, 0.13203890f, 0.13061544f, 0.12918637f, 0.12775178f,
    0.12631171f, 0.12486623f, 0.12341540f, 0.12195929f, 0.12049795f, 0.11903145f, 0.11755985f, 0.11608321f,
    0.11460161f, 0.11311509f, 0.11162373f, 0.11012758f, 0.10862672f, 0.10712120f, 0.10561110f, 0.10409647f,
    0.10257739f, 0.10105391f, 0.09952610f, 0.09799402f, 0.09645775f, 0.09491735f, 0.09337288f, 0.09182441f,
    0.09027201f, 0.08871574f, 0.08715567f, 0.08559187f, 0.08402440f, 0.08245333f, 0.08087873f, 0.07930067f,
    0.07771920f, 0.07613441f, 0.07454636f, 0.07295511f, 0.07136074f, 0.06976332f, 0.06816290f, 0.06655956f,
    0.06495338f, 0.06334441f, 0.06173272f, 0.06011839f, 0.05850149f, 0.05688208f, 0.05526024f, 0.05363602f,
    0.05200951f, 0.05038078f, 0.04874988f, 0.04711689f, 0.04548189f, 0.04384494f, 0.04220611f, 0.04056547f,
    0.03892310f, 0.03727906f, 0.03563342f, 0.03398625f, 0.03233763f, 0.03068762f, 0.02903630f, 0.02738373f,
    0.02573000f, 0.02407516f, 0.02241928f, 0.02076245f, 0.01910473f, 0.01744619f, 0.01578690f, 0.01412694f,
    0.01246637f, 0.01080527f, 0.00914370f, 0.00748175f, 0.00581947f, 0.00415694f, 0.00249424f, 0.00083142f
};

const float edct_table_256[256] =
{
    0.24999750f, 0.24998809f, 0.24996926f, 0.24994103f, 0.24990338f, 0.24985633f, 0.24979987f, 0.24973400f,
    0.24965873f, 0.24957406f, 0.24948000f, 0.24937654f, 0.24926370f, 0.24914147f, 0.24900986f, 0.24886887f,
    0.24871852f, 0.24855880f, 0.24838972f, 0.24821129f, 0.24802352f, 0.24782640f, 0.24761996f, 0.24740419f,
    0.24717911f, 0.24694473f, 0.24670104f, 0.24644807f, 0.24618582f, 0.24591430f, 0.24563353f, 0.24534350f,
    0.24504424f, 0.24473575f, 0.24441805f, 0.24409114f, 0.24375505f, 0.24340977f, 0.24305534f, 0.24269175f,
    0.24231903f, 0.24193718f, 0.24154622f, 0.24114617f, 0.24073704f, 0.24031885f, 0.23989161f, 0.23945534f,
    0.23901005f, 0.23855576f, 0.23809249f, 0.23762026f, 0.23713908f, 0.23664898f, 0.23614996f, 0.23564205f,
    0.23512527f, 0.23459964f, 0.23406518f, 0.23352190f, 0.23296983f, 0.23240899f, 0.23183940f, 0.23126109f,
    0.23067406f, 0.23007835f, 0.22947398f, 0.22886097f, 0.22823934f, 0.22760912f, 0.22697033f, 0.22632299f,
    0.22566713f, 0.22500278f, 0.22432996f, 0.22364869f, 0.22295900f, 0.22226091f, 0.22155446f, 0.22083967f,
    0.22011656f, 0.21938516f, 0.21864551f, 0.21789762f, 0.21714153f, 0.21637726f, 0.21560485f, 0.21482432f,
    0.21403570f, 0.21323902f, 0.21243432f, 0.21162161f, 0.21080094f, 0.20997234f, 0.20913582f, 0.20829144f,
    0.20743921f, 0.20657917f, 0.20571136f, 0.20483580f, 0.20395252f, 0.20306157f, 0.20216298f, 0.20125677f,
    0.20034298f, 0.19942165f, 0.19849282f, 0.19755651f, 0.19661276f, 0.19566161f, 0.19470310f, 0.19373725f,
    0.19276411f, 0.19178371f, 0.19079609f, 0.18980129f, 0.18879934f, 0.18779029f, 0.18677416f, 0.18575100f,
    0.18472085f, 0.18368375f, 0.18263973f, 0.18158883f, 0.18053109f, 0.17946656f, 0.17839527f, 0.17731727f,
    0.17623259f, 0.17514127f, 0.17404336f, 0.17293890f, 0.17182793f, 0.17071048f, 0.16958661f, 0.16845636f,
    0.16731976f, 0.16617686f, 0.16502771f, 0.16387235f, 0.16271081f, 0.16154315f, 0.16036940f, 0.15918962f,
    0.15800385f, 0.15681212f, 0.15561450f, 0.15441101f, 0.15320171f, 0.15198664f, 0.15076585f, 0.14953939f,
    0.14830729f, 0.14706961f, 0.14582639f, 0.14457768f, 0.14332353f, 0.14206399f, 0.14079909f, 0.13952889f,
    0.13825344f, 0.13697279f, 0.13568698f, 0.13439606f, 0.13310008f, 0.13179909f, 0.13049313f, 0.12918227f,
    0.12786654f, 0.12654599f, 0.12522068f, 0.12389066f, 0.12255597f, 0.12121667f, 0.11987280f, 0.11852443f,
    0.11717159f, 0.11581433f, 0.11445272f, 0.11308680f, 0.11171662f, 0.11034223f, 0.10896369f, 0.10758105f,
    0.10619436f, 0.10480367f, 0.10340903f, 0.10201050f, 0.10060813f, 0.09920197f, 0.09779208f, 0.09637850f,
    0.09496130f, 0.09354052f, 0.09211622f, 0.09068845f, 0.08925727f, 0.08782272f, 0.08638487f, 0.08494377f,
    0.08349947f, 0.08205203f, 0.08060149f, 0.07914792f, 0.07769138f, 0.07623190f, 0.07476956f, 0.07330440f,
    0.07183648f, 0.07036586f, 0.06889259f, 0.06741672f, 0.06593832f, 0.06445743f, 0.06297412f, 0.06148844f,
    0.06000044f, 0.05851018f, 0.05701772f, 0.05552311f, 0.05402641f, 0.05252768f, 0.05102697f, 0.04952434f,
    0.04801985f, 0.04651354f, 0.04500549f, 0.04349574f, 0.04198435f, 0.04047138f, 0.03895689f, 0.03744094f,
    0.03592357f, 0.03440485f, 0.03288483f, 0.03136358f, 0.02984115f, 0.02831759f, 0.02679296f, 0.02526733f,
    0.02374075f, 0.02221327f, 0.02068496f, 0.01915586f, 0.01762605f, 0.01609557f, 0.01456449f, 0.01303286f,
    0.01150073f, 0.00996818f, 0.00843525f, 0.00690200f, 0.00536849f, 0.00383478f, 0.00230093f, 0.00076699f
};

const float edct_table_400[400] =
{
    0.22360588f, 0.22360243f, 0.22359554f, 0.22358519f, 0.22357140f, 0.22355416f, 0.22353347f, 0.22350934f,
    0.22348175f, 0.22345073f, 0.22341625f, 0.22337833f, 0.22333697f, 0.22329216f, 0.22324391f, 0.22319221f,
    0.22313708f, 0.22307850f, 0.22301648f, 0.22295103f, 0.22288213f, 0.22280980f, 0.22273403f, 0.22265483f,
    0.22257219f, 0.22248612f, 0.22239662f, 0.22230369f, 0.22220734f, 0.22210755f, 0.22200434f, 0.22189771f,
    0.22178765f, 0.22167418f, 0.22155728f, 0.22143697f, 0.22131325f, 0.22118611f, 0.22105556f, 0.22092160f,
    0.22078424f, 0.22064347f, 0.22049930f, 0.22035172f, 0.22020075f, 0.22004639f, 0.21988863f, 0.21972748f,
    0.21956294f, 0.21939501f, 0.21922370f, 0.21904901f, 0.21887095f, 0.21868950f, 0.21850469f, 0.21831650f,
    0.21812495f, 0.21793004f, 0.21773176f, 0.21753013f, 0.21732514f, 0.21711680f, 0.21690511f, 0.21669008f,
    0.21647170f, 0.21624999f, 0.21602494f, 0.21579656f, 0.21556486f, 0.21532983f, 0.21509147f, 0.21484981f,
    0.21460482f, 0.21435653f, 0.21410494f, 0.21385004f, 0.21359184f, 0.21333035f, 0.21306557f, 0.21279750f,
    0.21252616f, 0.21225153f, 0.21197363f, 0.21169247f, 0.21140803f, 0.21112034f, 0.21082939f, 0.21053520f,
    0.21023775f, 0.20993706f, 0.20963314f, 0.20932598f, 0.20901559f, 0.20870198f, 0.20838516f, 0.20806511f,
    0.20774186f, 0.20741541f, 0.20708576f, 0.20675291f, 0.20641688f, 0.20607766f, 0.20573527f, 0.20538970f,
    0.20504096f, 0.20468907f, 0.20433401f, 0.20397581f, 0.20361446f, 0.20324997f, 0.20288234f, 0.20251159f,
    0.20213771f, 0.20176072f, 0.20138061f, 0.20099740f, 0.20061109f, 0.20022169f, 0.19982920f, 0.19943362f,
    0.19903497f, 0.19863326f, 0.19822847f, 0.19782064f, 0.19740975f, 0.19699581f, 0.19657884f, 0.19615884f,
    0.19573581f, 0.19530977f, 0.19488071f, 0.19444865f, 0.19401358f, 0.19357553f, 0.19313449f, 0.19269047f,
    0.19224348f, 0.19179353f, 0.19134062f, 0.19088476f, 0.19042595f, 0.18996421f, 0.18949954f, 0.18903194f,
    0.18856143f, 0.18808802f, 0.18761170f, 0.18713249f, 0.18665039f, 0.18616542f, 0.18567757f, 0.18518686f,
    0.18469330f, 0.18419688f, 0.18369763f, 0.18319554f, 0.18269063f, 0.18218290f, 0.18167236f, 0.18115902f,
    0.18064289f, 0.18012397f, 0.17960227f, 0.17907781f, 0.17855058f, 0.17802060f, 0.17748787f, 0.17695240f,
    0.17641421f, 0.17587330f, 0.17532967f, 0.17478334f, 0.17423432f, 0.17368260f, 0.17312821f, 0.17257115f,
    0.17201143f, 0.17144906f, 0.17088404f, 0.17031639f, 0.16974611f, 0.16917321f, 0.16859770f, 0.16801960f,
    0.16743890f, 0.16685562f, 0.16626977f, 0.16568135f, 0.16509038f, 0.16449686f, 0.16390080f, 0.16330222f,
    0.16270112f, 0.16209751f, 0.16149140f, 0.16088280f, 0.16027172f, 0.15965817f, 0.15904216f, 0.15842369f,
    0.15780278f, 0.15717944f, 0.15655367f, 0.15592549f, 0.15529490f, 0.15466192f, 0.15402655f, 0.15338881f,
    0.15274870f, 0.15210624f, 0.15146143f, 0.15081429f, 0.15016482f, 0.14951304f, 0.14885894f, 0.14820256f,
    0.14754389f, 0.14688294f, 0.14621973f, 0.14555426f, 0.14488655f, 0.14421660f, 0.14354443f, 0.14287005f,
    0.14219346f, 0.14151468f, 0.14083372f, 0.14015058f, 0.13946529f, 0.13877784f, 0.13808825f, 0.13739654f,
    0.13670270f, 0.13600676f, 0.13530872f, 0.13460859f, 0.13390639f, 0.13320212f, 0.13249580f, 0.13178744f,
    0.13107704f, 0.13036462f, 0.12965019f, 0.12893376f, 0.12821535f, 0.12749495f, 0.12677259f, 0.12604828f,
    0.12532202f, 0.12459383f, 0.12386371f, 0.12313169f, 0.12239777f, 0.12166196f, 0.12092427f, 0.12018472f,
    0.11944332f, 0.11870007f, 0.11795500f, 0.11720810f, 0.11645940f, 0.11570890f, 0.11495662f, 0.11420256f,
    0.11344675f, 0.11268918f, 0.11192987f, 0.11116884f, 0.11040610f, 0.10964165f, 0.10887551f, 0.10810770f,
    0.10733821f, 0.10656707f, 0.10579429f, 0.10501988f, 0.10424384f, 0.10346620f, 0.10268696f, 0.10190614f,
    0.10112375f, 0.10033980f, 0.09955430f, 0.09876726f, 0.09797871f, 0.09718864f, 0.09639707f, 0.09560402f,
    0.09480949f, 0.09401350f, 0.09321606f, 0.09241718f, 0.09161688f, 0.09081516f, 0.09001205f, 0.08920754f,
    0.08840166f, 0.08759442f, 0.08678583f, 0.08597589f, 0.08516464f, 0.08435207f, 0.08353819f, 0.08272303f,
    0.08190660f, 0.08108890f, 0.08026995f, 0.07944976f, 0.07862835f, 0.07780572f, 0.07698190f, 0.07615688f,
    0.07533070f, 0.07450335f, 0.07367485f, 0.07284522f, 0.07201446f, 0.07118259f, 0.07034963f, 0.06951558f,
    0.06868046f, 0.06784427f, 0.06700705f, 0.06616879f, 0.06532951f, 0.06448922f, 0.06364793f, 0.06280567f,
    0.06196244f, 0.06111825f, 0.06027312f, 0.05942705f, 0.05858008f, 0.05773220f, 0.05688343f, 0.05603378f,
    0.05518327f, 0.05433190f, 0.05347970f, 0.05262667f, 0.05177284f, 0.05091820f, 0.05006278f, 0.04920659f,
    0.04834964f, 0.04749194f, 0.04663351f, 0.04577436f, 0.04491450f, 0.04405396f, 0.04319273f, 0.04233084f,
    0.04146829f, 0.04060511f, 0.03974129f, 0.03887687f, 0.03801185f, 0.03714624f, 0.03628005f, 0.03541331f,
    0.03454602f, 0.03367820f, 0.03280986f, 0.03194101f, 0.03107167f, 0.03020186f, 0.02933157f, 0.02846084f,
    0.02758966f, 0.02671806f, 0.02584605f, 0.02497364f, 0.02410084f, 0.02322767f, 0.02235414f, 0.02148027f,
    0.02060607f, 0.01973155f, 0.01885673f, 0.01798161f, 0.01710622f, 0.01623056f, 0.01535466f, 0.01447851f,
    0.01360215f, 0.01272557f, 0.01184880f, 0.01097184f, 0.01009472f, 0.00921744f, 0.00834001f, 0.00746246f,
    0.00658480f, 0.00570703f, 0.00482917f, 0.00395124f, 0.00307325f, 0.00219521f, 0.00131714f, 0.00043905f
};

const float edct_table_600[600] =
{
    0.20205118f, 0.20204980f, 0.20204703f, 0.20204287f, 0.20203734f, 0.20203041f, 0.20202210f, 0.20201241f,
    0.20200133f, 0.20198887f, 0.20197502f, 0.20195979f, 0.20194318f, 0.20192518f, 0.20190579f, 0.20188503f,
    0.20186288f, 0.20183934f, 0.20181442f, 0.20178812f, 0.20176044f, 0.20173137f, 0.20170092f, 0.20166909f,
    0.20163587f, 0.20160128f, 0.20156530f, 0.20152794f, 0.20148920f, 0.20144908f, 0.20140758f, 0.20136469f,
    0.20132043f, 0.20127479f, 0.20122777f, 0.20117936f, 0.20112958f, 0.20107842f, 0.20102589f, 0.20097197f,
    0.20091668f, 0.20086001f, 0.20080196f, 0.20074254f, 0.20068174f, 0.20061957f, 0.20055602f, 0.20049110f,
    0.20042480f, 0.20035713f, 0.20028809f, 0.20021767f, 0.20014588f, 0.20007272f, 0.19999819f, 0.19992228f,
    0.19984501f, 0.19976637f, 0.19968635f, 0.19960497f, 0.19952222f, 0.19943811f, 0.19935262f, 0.19926577f,
    0.19917756f, 0.19908798f, 0.19899703f, 0.19890472f, 0.19881105f, 0.19871602f, 0.19861962f, 0.19852186f,
    0.19842274f, 0.19832226f, 0.19822043f, 0.19811723f, 0.19801267f, 0.19790676f, 0.19779949f, 0.19769087f,
    0.19758089f, 0.19746956f, 0.19735687f, 0.19724283f, 0.19712744f, 0.19701070f, 0.19689261f, 0.19677317f,
    0.19665237f, 0.19653024f, 0.19640675f, 0.19628192f, 0.19615574f, 0.19602822f, 0.19589936f, 0.19576915f,
    0.19563760f, 0.19550471f, 0.19537048f, 0.19523491f, 0.19509800f, 0.19495976f, 0.19482018f, 0.19467926f,
    0.19453701f, 0.19439343f, 0.19424851f, 0.19410226f, 0.19395469f, 0.19380578f, 0.19365554f, 0.19350398f,
    0.19335109f, 0.19319688f, 0.19304134f, 0.19288448f, 0.19272630f, 0.19256679f, 0.19240597f, 0.19224383f,
    0.19208036f, 0.19191559f, 0.19174950f, 0.19158209f, 0.19141337f, 0.19124334f, 0.19107200f, 0.19089934f,
    0.19072538f, 0.19055012f, 0.19037354f, 0.19019566f, 0.19001648f, 0.18983600f, 0.18965421f, 0.18947113f,
    0.18928674f, 0.18910106f, 0.18891409f, 0.18872581f, 0.18853625f, 0.18834539f, 0.18815324f, 0.18795980f,
    0.18776508f, 0.18756906f, 0.18737176f, 0.18717318f, 0.18697331f, 0.18677217f, 0.18656974f, 0.18636603f,
    0.18616105f, 0.18595479f, 0.18574726f, 0.18553845f, 0.18532837f, 0.18511702f, 0.18490440f, 0.18469052f,
    0.18447537f, 0.18425895f, 0.18404127f, 0.18382233f, 0.18360213f, 0.18338067f, 0.18315796f, 0.18293399f,
    0.18270877f, 0.18248229f, 0.18225456f, 0.18202559f, 0.18179536f, 0.18156389f, 0.18133118f, 0.18109722f,
    0.18086202f, 0.18062558f, 0.18038791f, 0.18014900f, 0.17990885f, 0.17966747f, 0.17942486f, 0.17918102f,
    0.17893595f, 0.17868965f, 0.17844213f, 0.17819339f, 0.17794342f, 0.17769224f, 0.17743984f, 0.17718622f,
    0.17693139f, 0.17667534f, 0.17641808f, 0.17615962f, 0.17589995f, 0.17563907f, 0.17537698f, 0.17511370f,
    0.17484922f, 0.17458353f, 0.17431665f, 0.17404858f, 0.17377931f, 0.17350885f, 0.17323721f, 0.17296437f,
    0.17269035f, 0.17241515f, 0.17213876f, 0.17186120f, 0.17158245f, 0.17130253f, 0.17102144f, 0.17073917f,
    0.17045574f, 0.17017113f, 0.16988536f, 0.16959843f, 0.16931033f, 0.16902107f, 0.16873066f, 0.16843909f,
    0.16814636f, 0.16785248f, 0.16755745f, 0.16726127f, 0.16696395f, 0.16666548f, 0.16636587f, 0.16606511f,
    0.16576322f, 0.16546020f, 0.16515604f, 0.16485075f, 0.16454433f, 0.16423678f, 0.16392810f, 0.16361830f,
    0.16330738f, 0.16299534f, 0.16268219f, 0.16236791f, 0.16205253f, 0.16173603f, 0.16141843f, 0.16109972f,
    0.16077991f, 0.16045899f, 0.16013697f, 0.15981386f, 0.15948965f, 0.15916435f, 0.15883796f, 0.15851047f,
    0.15818191f, 0.15785225f, 0.15752152f, 0.15718971f, 0.15685682f, 0.15652285f, 0.15618781f, 0.15585170f,
    0.15551452f, 0.15517628f, 0.15483697f, 0.15449661f, 0.15415518f, 0.15381269f, 0.15346916f, 0.15312457f,
    0.15277893f, 0.15243224f, 0.15208451f, 0.15173574f, 0.15138592f, 0.15103507f, 0.15068319f, 0.15033027f,
    0.14997632f, 0.14962134f, 0.14926534f, 0.14890831f, 0.14855026f, 0.14819120f, 0.14783112f, 0.14747003f,
    0.14710792f, 0.14674481f, 0.14638069f, 0.14601557f, 0.14564945f, 0.14528233f, 0.14491421f, 0.14454510f,
    0.14417500f, 0.14380391f, 0.14343184f, 0.14305878f, 0.14268474f, 0.14230973f, 0.14193374f, 0.14155677f,
    0.14117884f, 0.14079994f, 0.14042007f, 0.14003924f, 0.13965745f, 0.13927471f, 0.13889101f, 0.13850635f,
    0.13812075f, 0.13773420f, 0.13734671f, 0.13695828f, 0.13656890f, 0.13617860f, 0.13578735f, 0.13539518f,
    0.13500208f, 0.13460805f, 0.13421311f, 0.13381724f, 0.13342045f, 0.13302275f, 0.13262414f, 0.13222462f,
    0.13182419f, 0.13142286f, 0.13102063f, 0.13061750f, 0.13021348f, 0.12980856f, 0.12940275f, 0.12899606f,
    0.12858848f, 0.12818002f, 0.12777069f, 0.12736047f, 0.12694939f, 0.12653743f, 0.12612461f, 0.12571092f,
    0.12529637f, 0.12488096f, 0.12446470f, 0.12404758f, 0.12362961f, 0.12321080f, 0.12279114f, 0.12237064f,
    0.12194930f, 0.12152712f, 0.12110411f, 0.12068027f, 0.12025561f, 0.11983012f, 0.11940381f, 0.11897668f,
    0.11854873f, 0.11811998f, 0.11769041f, 0.11726004f, 0.11682886f, 0.11639688f, 0.11596410f, 0.11553053f,
    0.11509617f, 0.11466102f, 0.11422508f, 0.11378836f, 0.11335086f, 0.11291258f, 0.11247353f, 0.11203371f,
    0.11159312f, 0.11115177f, 0.11070965f, 0.11026678f, 0.10982315f, 0.10937876f, 0.10893363f, 0.10848775f,
    0.10804113f, 0.10759376f, 0.10714566f, 0.10669683f, 0.10624726f, 0.10579696f, 0.10534594f, 0.10489420f,
    0.10444174f, 0.10398856f, 0.10353467f, 0.10308007f, 0.10262477f, 0.10216876f, 0.10171205f, 0.10125464f,
    0.10079654f, 0.10033775f, 0.09987827f, 0.09941811f, 0.09895726f, 0.09849574f, 0.09803354f, 0.09757067f,
    0.09710713f, 0.09664293f, 0.09617806f, 0.09571253f, 0.09524635f, 0.09477952f, 0.09431203f, 0.09384390f,
    0.09337513f, 0.09290571f, 0.09243566f, 0.09196498f, 0.09149366f, 0.09102172f, 0.09054915f, 0.09007597f,
    0.08960216f, 0.08912774f, 0.08865272f, 0.08817708f, 0.08770084f, 0.08722400f, 0.08674656f, 0.08626852f,
    0.08578990f, 0.08531068f, 0.08483089f, 0.08435051f, 0.08386955f, 0.08338802f, 0.08290591f, 0.08242324f,
    0.08194000f, 0.08145620f, 0.08097185f, 0.08048693f, 0.08000147f, 0.07951546f, 0.07902890f, 0.07854180f,
    0.07805416f, 0.07756599f, 0.07707729f, 0.07658806f, 0.07609830f, 0.07560802f, 0.07511722f, 0.07462591f,
    0.07413409f, 0.07364176f, 0.07314892f, 0.07265559f, 0.07216175f, 0.07166742f, 0.07117260f, 0.07067729f,
    0.07018150f, 0.06968522f, 0.06918847f, 0.06869125f, 0.06819355f, 0.06769539f, 0.06719676f, 0.06669767f,
    0.06619812f, 0.06569812f, 0.06519767f, 0.06469678f, 0.06419544f, 0.06369366f, 0.06319144f, 0.06268879f,
    0.06218571f, 0.06168220f, 0.06117828f, 0.06067393f, 0.06016916f, 0.05966399f, 0.05915840f, 0.05865241f,
    0.05814602f, 0.05763923f, 0.05713204f, 0.05662447f, 0.05611650f, 0.05560815f, 0.05509942f, 0.05459031f,
    0.05408083f, 0.05357097f, 0.05306075f, 0.05255017f, 0.05203922f, 0.05152792f, 0.05101627f, 0.05050426f,
    0.04999191f, 0.04947922f, 0.04896619f, 0.04845282f, 0.04793912f, 0.04742509f, 0.04691074f, 0.04639606f,
    0.04588107f, 0.04536576f, 0.04485014f, 0.04433422f, 0.04381799f, 0.04330146f, 0.04278463f, 0.04226751f,
    0.04175010f, 0.04123240f, 0.04071442f, 0.04019617f, 0.03967763f, 0.03915883f, 0.03863975f, 0.03812042f,
    0.03760082f, 0.03708096f, 0.03656085f, 0.03604049f, 0.03551988f, 0.03499902f, 0.03447793f, 0.03395660f,
    0.03343504f, 0.03291325f, 0.03239124f, 0.03186900f, 0.03134654f, 0.03082387f, 0.03030099f, 0.02977790f,
    0.02925460f, 0.02873111f, 0.02820741f, 0.02768353f, 0.02715945f, 0.02663519f, 0.02611075f, 0.02558613f,
    0.02506133f, 0.02453636f, 0.02401122f, 0.02348592f, 0.02296046f, 0.02243483f, 0.02190906f, 0.02138314f,
    0.02085706f, 0.02033085f, 0.01980450f, 0.01927801f, 0.01875139f, 0.01822464f, 0.01769776f, 0.01717076f,
    0.01664365f, 0.01611642f, 0.01558908f, 0.01506164f, 0.01453409f, 0.01400644f, 0.01347870f, 0.01295086f,
    0.01242294f, 0.01189493f, 0.01136683f, 0.01083866f, 0.01031042f, 0.00978211f, 0.00925372f, 0.00872528f,
    0.00819677f, 0.00766821f, 0.00713960f, 0.00661094f, 0.00608223f, 0.00555348f, 0.00502469f, 0.00449587f,
    0.00396701f, 0.00343813f, 0.00290923f, 0.00238031f, 0.00185137f, 0.00132241f, 0.00079345f, 0.00026448f
};

/*----------------------------------------------------------------------------------*
 * Mean ISF vector for active signal (only for AMR-WB IO mode)
 *----------------------------------------------------------------------------------*/

const float mean_isf_amr_wb[M] =
{
    288.411774f,
    518.149414f,
    912.352051f,
    1397.743652f,
    1795.418823f,
    2211.536133f,
    2621.461182f,
    3019.680176f,
    3417.989746f,
    3809.700928f,
    4181.547363f,
    4581.064941f,
    5012.819824f,
    5457.521484f,
    5876.145020f,
    1576.906494f
};

/*----------------------------------------------------------------------------------*
 * Mean ISF vector for SID frames (only in AMR-WB IO mode)
 *----------------------------------------------------------------------------------*/

const float mean_isf_noise_amr_wb[M] =
{
    186.625259f,
    429.613403f,
    864.525085f,
    1276.010254f,
    1648.228394f,
    2039.998535f,
    2420.943115f,
    2828.022461f,
    3214.584961f,
    3575.200195f,
    3944.685303f,
    4338.971191f,
    4743.657227f,
    5149.993164f,
    5533.081055f,
    1485.457031f
};

/*----------------------------------------------------------------------------------*
 * Initial LSF memory
 *----------------------------------------------------------------------------------*/

const float lsf_init[16] =
{
    375.0,  750.0, 1125.0, 1500.0, 1875.0, 2250.0, 2625.0, 3000.0,
    3375.0, 3750.0, 4125.0, 4500.0, 4875.0, 5250.0, 5625.0, 6000.0
};


/*----------------------------------------------------------------------------------*
 * Gaussian codebook
 *----------------------------------------------------------------------------------*/

const float gaus_dico[190] =
{
    -0.0973f, -0.0306f,  0.1278f, -0.1138f,  0.0744f, -0.1606f,
    -0.1976f,  0.0115f, -0.0344f, -0.0417f, -0.1424f, -0.0633f,
    0.0723f,  0.3257f, -0.0697f, -0.0978f, -0.1168f, -0.1021f,
    0.0342f, -0.1319f,  0.0431f, -0.2658f,  0.0317f, -0.0712f,
    0.0348f,  0.1200f, -0.0758f, -0.2104f, -0.0781f,  0.0947f,
    0.1333f,  0.0204f, -0.2934f,  0.0262f,  0.0264f,  0.0830f,
    0.0584f, -0.0318f,  0.2271f,  0.0835f,  0.0374f, -0.0645f,
    -0.1864f, -0.0277f,  0.0945f, -0.1306f,  0.0202f, -0.2090f,
    -0.0881f, -0.1029f,  0.0292f,  0.0966f, -0.0896f,  0.1563f,
    0.1994f,  0.0543f, -0.2482f, -0.0201f, -0.0294f,  0.2172f,
    0.0830f, -0.0938f,  0.0115f,  0.0827f, -0.1233f, -0.1051f,
    0.0394f,  0.2390f,  0.2172f, -0.0653f,  0.0253f,  0.1241f,
    -0.0366f, -0.0473f,  0.1080f,  0.0470f,  0.1009f, -0.0059f,
    0.0964f, -0.0105f, -0.0531f,  0.0169f, -0.0972f,  0.0408f,
    0.0283f, -0.2285f, -0.0232f,  0.3580f, -0.1063f,  0.1125f,
    0.2105f, -0.0331f, -0.0230f,  0.3200f, -0.0905f,  0.0166f,
    0.0328f, -0.0722f, -0.0380f, -0.1377f, -0.0118f, -0.1189f,
    0.1580f,  0.0769f,  0.1252f, -0.0247f, -0.1672f, -0.0777f,
    -0.0841f, -0.1573f, -0.0160f,  0.2078f,  0.1011f, -0.0070f,
    0.1242f,  0.1011f,  0.1225f,  0.0973f,  0.1361f,  0.1584f,
    -0.0729f,  0.1831f,  0.1332f, -0.1846f, -0.0029f, -0.0890f,
    0.1447f, -0.1727f,  0.0963f, -0.0321f, -0.0916f, -0.0151f,
    -0.2232f, -0.0624f, -0.1036f,  0.0157f,  0.1134f, -0.2782f,
    0.0684f,  0.0222f, -0.0202f, -0.0704f, -0.1342f,  0.0950f,
    0.0128f, -0.2999f,  0.0015f, -0.1051f,  0.0180f,  0.0500f,
    -0.1166f, -0.0361f, -0.1446f,  0.0688f, -0.0179f,  0.2959f,
    0.0102f,  0.1416f, -0.0815f,  0.1181f, -0.1867f,  0.1082f,
    0.1585f,  0.0661f, -0.1805f,  0.0915f,  0.1497f, -0.1124f,
    -0.0508f,  0.0573f, -0.0294f, -0.0119f, -0.0759f,  0.1477f,
    0.2136f,  0.1271f,  0.0492f, -0.1235f, -0.1337f, -0.2657f,
    -0.0106f, -0.0540f,  0.1642f, -0.0598f, -0.0065f,  0.1146f,
    0.0863f,  0.0129f,  0.1816f,  0.0672f
};

const float gaus_dico_swb[256] =
{
    0.02164473f,  0.35885197f, -0.16274954f, -0.08241354f,  0.07313631f, -0.00054929f, -0.13080014f,  0.07226136f,
    -0.13965981f, -0.04834007f, -0.02745908f, -0.02867859f,  0.11216793f,  0.16604294f, -0.00134274f,  0.06818508f,
    -0.17387933f,  0.09406016f, -0.08150196f,  0.05083200f, -0.01952806f, -0.10203217f, -0.03067050f, -0.05153965f,
    0.06250680f,  0.00859049f, -0.12008808f, -0.11361376f,  0.17176038f,  0.01174004f, -0.02275130f, -0.09895785f,
    -0.10167463f, -0.22059087f, -0.05334539f, -0.00629700f, -0.16706355f,  0.07795000f,  0.08731710f,  0.09669208f,
    0.15378080f,  0.01794813f, -0.01549965f, -0.24923822f,  0.19985947f, -0.10477958f,  0.06674605f, -0.11186616f,
    -0.17927034f,  0.08443811f,  0.25542912f,  0.03167623f,  0.19633667f,  0.19163096f,  0.01907267f,  0.12298489f,
    -0.03147158f,  0.05562247f,  0.30200079f, -0.04257871f,  0.08275045f, -0.03386311f, -0.02265750f,  0.18742503f,
    -0.13598505f, -0.32004824f, -0.00438390f, -0.15576170f,  0.06006401f, -0.00952147f,  0.18848655f,  0.06630960f,
    0.07121546f, -0.00733249f,  0.08277771f,  0.22764891f,  0.06772452f, -0.09509693f, -0.00172236f,  0.08452052f,
    0.17020901f, -0.03737585f,  0.02349647f,  0.10855560f,  0.06854416f,  0.07084806f,  0.09390105f,  0.00124924f,
    0.03026483f, -0.15169589f,  0.01347072f, -0.15377805f,  0.14992996f,  0.11630810f,  0.03483583f, -0.03914850f,
    -0.20075595f,  0.12728901f, -0.04495851f, -0.11576717f, -0.15281813f,  0.06055827f, -0.03471978f, -0.03617816f,
    0.17230885f,  0.03094525f, -0.15618153f,  0.21792564f,  0.08106838f, -0.22098514f, -0.10796417f,  0.07131225f,
    0.22092983f, -0.01539366f, -0.02876964f, -0.30910203f,  0.02143815f, -0.11630868f, -0.00922897f,  0.07431208f,
    0.15533504f,  0.11425125f,  0.07125455f, -0.11914105f, -0.04275274f, -0.05072749f, -0.22143129f,  0.19787727f,
    -0.20946717f, -0.16564523f,  0.05962536f, -0.22325630f, -0.04333350f, -0.04707248f,  0.16608582f,  0.00948954f,
    0.11283893f, -0.04097161f, -0.09076904f,  0.26722300f,  0.00987607f, -0.05807892f,  0.07872546f,  0.08040629f,
    0.12927419f, -0.05647410f,  0.09603068f, -0.02356448f, -0.02160797f, -0.11687102f,  0.07936122f, -0.05764586f,
    -0.10510305f, -0.02326054f,  0.12021790f,  0.09782617f, -0.22600858f, -0.02555378f, -0.03561033f, -0.01337216f,
    0.11311363f, -0.03096960f, -0.22801498f,  0.05643769f,  0.13053033f,  0.04452197f, -0.09299882f, -0.11475921f,
    0.02257649f, -0.21770498f, -0.11454470f, -0.09435777f,  0.00638951f, -0.36990553f,  0.04266735f,  0.06915011f,
    0.07644624f, -0.24336053f, -0.03421960f, -0.10622191f, -0.17223521f,  0.04054553f,  0.13831380f,  0.02925055f,
    0.16207848f, -0.12994884f, -0.09751288f, -0.05397306f, -0.09323815f,  0.13425350f, -0.00046960f,  0.31072289f,
    0.13740718f,  0.05835414f, -0.04803475f,  0.15423043f, -0.09652353f,  0.14896898f, -0.16368309f,  0.05875925f,
    -0.03678078f, -0.19627908f,  0.07034992f, -0.27213186f, -0.04338680f,  0.01567988f, -0.09158870f,  0.11987700f,
    0.07083926f,  0.01099900f, -0.01084446f,  0.04508050f, -0.10655984f, -0.13945042f,  0.05837287f,  0.08458713f,
    -0.04212087f, -0.15749574f,  0.11632511f,  0.07976698f,  0.06725866f, -0.09567240f,  0.03796997f, -0.09355708f,
    -0.13569611f, -0.19498724f,  0.14951572f, -0.16023041f,  0.04185898f,  0.06099325f,  0.03425207f,  0.16211477f,
    0.03998571f, -0.03629408f, -0.10099959f,  0.19540504f,  0.11653102f,  0.23601755f,  0.04943547f, -0.26040605f,
    0.02153429f,  0.22880882f, -0.13646534f,  0.03881640f, -0.02896636f,  0.09774253f, -0.13509314f, -0.08713179f,
    0.13485038f,  0.06968338f,  0.19561967f,  0.07884958f, -0.10365590f, -0.10321335f, -0.09081125f, -0.00147976f
};

/*----------------------------------------------------------------------------------*
 * CLDFB tables
 *----------------------------------------------------------------------------------*/

const int freqTable[2] = {20, 40};

/* SNR: 109.44, PHASE: 3.500000000000000 */
const float CLDFB80_10[100] =
{
    0.0000033382f, -0.0000023292f, -0.0000006582f, 0.0000001464f, -0.0000010899f, -0.0000009664f,
    -0.0000000104f, -0.0000018105f, -0.0000012856f, 0.0000017112f, 0.0000137155f, -0.0000084710f,
    -0.0000015748f, -0.0000002482f, 0.0000036294f, -0.0000043816f, 0.0000003906f, 0.0000043318f,
    0.0000049126f, -0.0000061826f, -0.0002270069f, -0.0000675402f, -0.0000158982f, 0.0000138120f,
    -0.0000220086f, -0.0000356560f, 0.0000171849f, -0.0000194504f, -0.0000058158f, -0.0002621811f,
    -0.0009969691f, -0.0001427984f, -0.0000188085f, -0.0000040399f, -0.0001954359f, 0.0001806872f,
    0.0000232574f, -0.0000047551f, -0.0000321009f, 0.0010723262f, -0.0020160153f, -0.0007751652f,
    0.0003508478f, 0.0015707671f, 0.0017180828f, 0.0015807568f, 0.0021944824f, 0.0028288425f,
    0.0030257006f, 0.0016570983f, -0.0014279413f, -0.0015962377f, 0.0007765516f, 0.0025625922f,
    0.0022554877f, 0.0002647332f, -0.0032977409f, -0.0065113932f, -0.0095444393f, -0.0136373114f,
    0.0186561662f, 0.0242546518f, 0.0320538418f, 0.0427742450f, 0.0565841171f, 0.0732940277f,
    0.0914110197f, 0.1082620545f, 0.1209072165f, 0.1269811579f, 0.1253574855f, 0.1136768387f,
    0.0887587689f, 0.0497640968f, -0.0031398279f, -0.0698373206f, -0.1494875982f, -0.2406007759f,
    -0.3411996303f, -0.4484628681f, 0.5579472269f, 0.6655527761f, 0.7669493517f, 0.8575328375f,
    0.9329386030f, 0.9892971917f, 1.0250167399f, 1.0397966587f, 1.0375221638f, 1.0163053398f,
    0.9610874400f, 0.8748972145f, 0.7783924293f, 0.6777346686f, 0.5724389618f, 0.4648620471f,
    0.3560337451f, 0.2485564060f, 0.1386438276f, 0.0416433203f,
};

/* SNR: 292.49, PHASE: 2.000000000000000 */
const float CLDFB80_16[160] =
{
    0.0000005510f, -0.0000007674f, -0.0000002340f, 0.0000000964f, 0.0000000593f, -0.0000000017f,
    -0.0000000178f, 0.0000021953f, 0.0000030004f, -0.0000000167f, -0.0000000019f, 0.0000000702f,
    0.0000000344f, -0.0000000765f, -0.0000005553f, 0.0000007526f, 0.0000020881f, -0.0000028263f,
    -0.0000007033f, 0.0000002370f, 0.0000001175f, -0.0000004048f, 0.0000000996f, -0.0000180207f,
    0.0000246292f, -0.0000000934f, 0.0000004489f, -0.0000001390f, -0.0000000845f, 0.0000002300f,
    0.0000020452f, -0.0000028520f, -0.0003204839f, -0.0001476489f, -0.0000626217f, -0.0000446346f,
    -0.0000202236f, 0.0000151160f, 0.0000057995f, 0.0000450017f, 0.0000433006f, 0.0000050745f,
    0.0000167005f, -0.0000314631f, -0.0000244547f, -0.0000125422f, -0.0000911863f, -0.0004371781f,
    -0.0012267106f, -0.0005247118f, -0.0001857576f, -0.0001103593f, -0.0000402931f, 0.0000108771f,
    -0.0000576360f, 0.0000602621f, -0.0002317927f, 0.0000520316f, 0.0000035090f, 0.0000625950f,
    0.0000603417f, 0.0000368907f, 0.0003220307f, 0.0016733998f, -0.0021551784f, -0.0015444660f,
    -0.0007592329f, -0.0001077355f, 0.0007091208f, 0.0015054295f, 0.0017984668f, 0.0011461500f,
    0.0015946160f, 0.0018157551f, 0.0022526599f, 0.0027665136f, 0.0029611644f, 0.0030474884f,
    0.0025509350f, 0.0012885692f, -0.0011048694f, -0.0019476595f, -0.0014849578f, -0.0000191307f,
    0.0014542427f, 0.0025014060f, 0.0026282341f, 0.0020896060f, 0.0009380930f, -0.0012303806f,
    -0.0035150110f, -0.0055687066f, -0.0074233361f, -0.0093371234f, -0.0117127490f, -0.0145175090f,
    0.0177813213f, 0.0209221310f, 0.0246700384f, 0.0293186424f, 0.0350939424f, 0.0420166741f,
    0.0501689083f, 0.0594973479f, 0.0699793095f, 0.0811978302f, 0.0925316969f, 0.1033039355f,
    0.1127998301f, 0.1202885467f, 0.1252446307f, 0.1272143872f, 0.1262547749f, 0.1217276780f,
    0.1125292370f, 0.0980647299f, 0.0780704213f, 0.0526074650f, 0.0217182187f, -0.0146037409f,
    -0.0563029259f, -0.1031675028f, -0.1548654211f, -0.2110103318f, -0.2711216615f, -0.3346791161f,
    -0.4009613796f, -0.4689983890f, 0.5374920358f, 0.6054498150f, 0.6721266919f, 0.7362374318f,
    0.7966023599f, 0.8522654625f, 0.9021245679f, 0.9450253190f, 0.9802630812f, 1.0075496836f,
    1.0265340754f, 1.0372359728f, 1.0407524022f, 1.0381397893f, 1.0284102813f, 1.0099196627f,
    0.9753688495f, 0.9254582964f, 0.8690385973f, 0.8090082031f, 0.7474414548f, 0.6841760105f,
    0.6189218236f, 0.5524001591f, 0.4851748506f, 0.4172433895f, 0.3492691242f, 0.2821066655f,
    0.2146356085f, 0.1455327617f, 0.0796914490f, 0.0278251946f,
};

/* SNR: 89.77, PHASE: 1.500000000000000 */
const float CLDFB80_20[200] =
{
    0.0000016461f, -0.0000046862f, -0.0000000815f, -0.0000001822f, 0.0000000240f, 0.0000001892f,
    -0.0000002365f, -0.0000007031f, -0.0000000079f, 0.0000048656f, 0.0000070490f, 0.0000000032f,
    0.0000001499f, -0.0000000944f, 0.0000004307f, -0.0000000787f, -0.0000001070f, 0.0000015376f,
    -0.0000025088f, 0.0000044280f, 0.0000046060f, -0.0000207092f, -0.0000004877f, -0.0000006126f,
    0.0000000605f, 0.0000004365f, -0.0000003741f, -0.0000009508f, 0.0000006700f, -0.0000087189f,
    0.0000114297f, -0.0000007710f, -0.0000002908f, 0.0000001583f, -0.0000010138f, 0.0000001875f,
    0.0000003789f, -0.0000065731f, 0.0000112115f, -0.0000036253f, -0.0003045828f, -0.0002068946f,
    -0.0000330428f, -0.0000658559f, -0.0000416668f, -0.0000207558f, -0.0000046097f, 0.0000096778f,
    -0.0000064960f, 0.0000515938f, 0.0000257367f, -0.0000068671f, 0.0000029284f, -0.0000209369f,
    -0.0000191720f, -0.0000235869f, -0.0000286778f, 0.0000594843f, -0.0001104448f, -0.0004947290f,
    -0.0011759540f, -0.0006581582f, -0.0001310136f, -0.0001782524f, -0.0001002354f, -0.0000465158f,
    -0.0000188237f, 0.0000285072f, -0.0001359344f, 0.0002814194f, -0.0004814411f, 0.0001302339f,
    -0.0000257394f, 0.0000578339f, 0.0000485628f, 0.0000543116f, 0.0000763443f, -0.0001495108f,
    0.0003492618f, 0.0018283780f, -0.0019931487f, -0.0018716309f, -0.0008617653f, -0.0006080124f,
    -0.0000337803f, 0.0006187704f, 0.0012478726f, 0.0016757046f, 0.0018115391f, 0.0007745483f,
    0.0016550121f, 0.0017032298f, 0.0019356593f, 0.0024080283f, 0.0027878510f, 0.0029379588f,
    0.0030637651f, 0.0028257202f, 0.0021943273f, 0.0010679683f, -0.0009250455f, -0.0017798333f,
    -0.0018826540f, -0.0011010583f, 0.0001463485f, 0.0013293069f, 0.0022974838f, 0.0027746423f,
    0.0025078917f, 0.0020425098f, 0.0011954954f, -0.0005741594f, -0.0024120809f, -0.0041653667f,
    -0.0057623702f, -0.0072425386f, -0.0087363677f, -0.0104237699f, -0.0125156239f, -0.0148077168f,
    0.0174398402f, 0.0199230411f, 0.0226649147f, 0.0259599813f, 0.0298434758f, 0.0344649815f,
    0.0398139569f, 0.0459314689f, 0.0528498740f, 0.0604788669f, 0.0688814001f, 0.0777923399f,
    0.0868947517f, 0.0958553537f, 0.1043243835f, 0.1119302041f, 0.1182880738f, 0.1231125873f,
    0.1261745561f, 0.1272284850f, 0.1264656300f, 0.1235525506f, 0.1177556666f, 0.1087635447f,
    0.0963144136f, 0.0803171444f, 0.0608146076f, 0.0378425383f, 0.0113896330f, -0.0185270856f,
    -0.0518892622f, -0.0885871716f, -0.1284318249f, -0.1712634880f, -0.2168508609f, -0.2649463144f,
    -0.3152867427f, -0.3675395959f, -0.4212350657f, -0.4758650706f, 0.5306725282f, 0.5851445237f,
    0.6390281696f, 0.6916889535f, 0.7424591009f, 0.7907617163f, 0.8361206884f, 0.8779983070f,
    0.9157691951f, 0.9489012228f, 0.9770929872f, 1.0002174168f, 1.0180999340f, 1.0305853696f,
    1.0378851378f, 1.0406826783f, 1.0395784114f, 1.0343061945f, 1.0237762412f, 1.0076524569f,
    0.9800034826f, 0.9411740407f, 0.8979145998f, 0.8512639848f, 0.8029102780f, 0.7536620391f,
    0.7033730373f, 0.6517679660f, 0.5990562278f, 0.5457078369f, 0.4919297136f, 0.4376796414f,
    0.3831842053f, 0.3290362900f, 0.2754121565f, 0.2214602867f, 0.1663238479f, 0.1115465981f,
    0.0622889538f, 0.0233593568f,
};

/* SNR: 89.29, PHASE: 0.833333333333333 */
const float CLDFB80_30[300] =
{
    -0.0000002772f, 0.0000033382f, 0.0000018078f, -0.0000007965f, -0.0000023292f, -0.0000000163f,
    0.0000001004f, -0.0000006582f, 0.0000000287f, 0.0000000140f, 0.0000001464f, 0.0000002826f,
    0.0000000427f, -0.0000010899f, 0.0000048488f, 0.0000070973f, -0.0000009664f, 0.0000000360f,
    0.0000004432f, -0.0000000104f, -0.0000000269f, -0.0000000107f, -0.0000018105f, 0.0000000543f,
    -0.0000000029f, -0.0000012856f, -0.0000006144f, 0.0000009806f, 0.0000017112f, -0.0000026992f,
    -0.0000120997f, 0.0000137155f, 0.0000075545f, -0.0000032372f, -0.0000084710f, -0.0000000206f,
    0.0000002472f, -0.0000015748f, 0.0000000428f, -0.0000000299f, -0.0000002482f, 0.0000005522f,
    0.0000001959f, 0.0000036294f, 0.0000084418f, -0.0000120850f, -0.0000043816f, -0.0000001651f,
    -0.0000010266f, 0.0000003906f, 0.0000001476f, 0.0000000560f, 0.0000043318f, -0.0000001327f,
    -0.0000000099f, 0.0000049126f, 0.0000025641f, -0.0000041212f, -0.0000061826f, 0.0000182899f,
    -0.0003177625f, -0.0002270069f, -0.0001470513f, -0.0000710867f, -0.0000675402f, -0.0000612052f,
    -0.0000458905f, -0.0000158982f, -0.0000198609f, -0.0000044865f, 0.0000138120f, 0.0000259521f,
    -0.0000014174f, -0.0000220086f, 0.0000046746f, -0.0000478217f, -0.0000356560f, -0.0000008176f,
    0.0000554471f, 0.0000171849f, -0.0000104782f, -0.0000342931f, -0.0000194504f, -0.0000247231f,
    -0.0000266321f, -0.0000058158f, -0.0000154718f, -0.0000860619f, -0.0002621811f, -0.0006329730f,
    -0.0010151313f, -0.0009969691f, -0.0006401095f, -0.0002347208f, -0.0001427984f, -0.0001657818f,
    -0.0001142242f, -0.0000188085f, -0.0000385187f, -0.0000275046f, -0.0000040399f, 0.0000495378f,
    -0.0001045437f, -0.0001954359f, 0.0005754000f, -0.0007487377f, 0.0001806872f, 0.0000995589f,
    -0.0000996504f, 0.0000232574f, 0.0000603268f, 0.0000660807f, -0.0000047551f, 0.0000619265f,
    0.0000723872f, -0.0000321009f, 0.0000223561f, 0.0003720504f, 0.0010723262f, 0.0019477029f,
    -0.0018122293f, -0.0020160153f, -0.0017426363f, -0.0010556444f, -0.0007751652f, -0.0005221317f,
    -0.0001347624f, 0.0003508478f, 0.0007386346f, 0.0011721899f, 0.0015707671f, 0.0017166805f,
    0.0018089705f, 0.0017180828f, 0.0002671723f, 0.0016677326f, 0.0015807568f, 0.0017534327f,
    0.0019075685f, 0.0021944824f, 0.0024875266f, 0.0027574445f, 0.0028288425f, 0.0029688585f,
    0.0030573770f, 0.0030257006f, 0.0027683197f, 0.0023855538f, 0.0016570983f, 0.0007261425f,
    -0.0006240877f, -0.0014279413f, -0.0018848796f, -0.0019263976f, -0.0015962377f, -0.0009120500f,
    -0.0000736785f, 0.0007765516f, 0.0014961634f, 0.0021524541f, 0.0025625922f, 0.0027460441f,
    0.0025688449f, 0.0022554877f, 0.0019970512f, 0.0015552223f, 0.0002647332f, -0.0008620885f,
    -0.0020865380f, -0.0032977409f, -0.0044403210f, -0.0055039505f, -0.0065113932f, -0.0074839181f,
    -0.0084786965f, -0.0095444393f, -0.0107566368f, -0.0121559845f, -0.0136373114f, -0.0152125941f,
    0.0169692165f, 0.0186561662f, 0.0203704498f, 0.0221787331f, 0.0242546518f, 0.0265582983f,
    0.0291465321f, 0.0320538418f, 0.0353059968f, 0.0388699993f, 0.0427742450f, 0.0470319574f,
    0.0516455579f, 0.0565841171f, 0.0617960053f, 0.0674208876f, 0.0732940277f, 0.0793036968f,
    0.0853757711f, 0.0914110197f, 0.0973085175f, 0.1029609938f, 0.1082620545f, 0.1130850459f,
    0.1173295323f, 0.1209072165f, 0.1237469292f, 0.1257934619f, 0.1269811579f, 0.1271703366f,
    0.1266559114f, 0.1253574855f, 0.1227915199f, 0.1189360593f, 0.1136768387f, 0.1069333476f,
    0.0986359173f, 0.0887587689f, 0.0773092890f, 0.0643073307f, 0.0497640968f, 0.0336765771f,
    0.0160401582f, -0.0031398279f, -0.0238366387f, -0.0460799881f, -0.0698373206f, -0.0950128018f,
    -0.1215783841f, -0.1494875982f, -0.1786760784f, -0.2090721736f, -0.2406007759f, -0.2731879051f,
    -0.3067537961f, -0.3411996303f, -0.3764015708f, -0.4122065782f, -0.4484628681f, -0.4850451997f,
    0.5215924710f, 0.5579472269f, 0.5941804962f, 0.6301135607f, 0.6655527761f, 0.7002994797f,
    0.7341550905f, 0.7669493517f, 0.7985389090f, 0.8287866009f, 0.8575328375f, 0.8845952462f,
    0.9097846281f, 0.9329386030f, 0.9539491421f, 0.9727435862f, 0.9892971917f, 1.0035676672f,
    1.0154927835f, 1.0250167399f, 1.0321480823f, 1.0370035227f, 1.0397966587f, 1.0407627030f,
    1.0400314908f, 1.0375221638f, 1.0329480648f, 1.0259438203f, 1.0163053398f, 1.0048344063f,
    0.9863956401f, 0.9610874400f, 0.9342743262f, 0.9054084925f, 0.8748972145f, 0.8432873810f,
    0.8110381808f, 0.7783924293f, 0.7453640666f, 0.7118431392f, 0.6777346686f, 0.6430470493f,
    0.6078972260f, 0.5724389618f, 0.5367746506f, 0.5009238704f, 0.4648620471f, 0.4286003322f,
    0.3922588980f, 0.3560337451f, 0.3200733025f, 0.2843378434f, 0.2485564060f, 0.2123552623f,
    0.1755742394f, 0.1386438276f, 0.1027751331f, 0.0698223020f, 0.0416433203f, 0.0171881989f,
};

/* SNR: 85.69, PHASE: 0.750000000000000 */
const float CLDFB80_32[320] =
{
    -0.0000010182f, 0.0000018812f, -0.0000013969f, 0.0000000702f, -0.0000030351f, -0.0000001862f,
    0.0000000017f, 0.0000000804f, -0.0000002859f, -0.0000000058f, -0.0000003463f, -0.0000003782f,
    0.0000006385f, 0.0000000365f, -0.0000015696f, 0.0000043896f, 0.0000063462f, -0.0000013860f,
    0.0000000439f, 0.0000007243f, -0.0000000373f, -0.0000001214f, 0.0000000228f, -0.0000008123f,
    0.0000002096f, -0.0000000043f, -0.0000001079f, -0.0000005174f, -0.0000001146f, -0.0000006991f,
    0.0000012420f, -0.0000054157f, -0.0000164806f, 0.0000076445f, -0.0000065087f, 0.0000002224f,
    -0.0000110942f, -0.0000006228f, 0.0000000012f, 0.0000001914f, -0.0000006876f, 0.0000000004f,
    -0.0000005395f, -0.0000007555f, 0.0000015057f, 0.0000005303f, 0.0000035648f, 0.0000094151f,
    -0.0000133505f, -0.0000042847f, -0.0000005848f, -0.0000018021f, 0.0000001676f, 0.0000001730f,
    -0.0000000645f, 0.0000019429f, -0.0000005012f, 0.0000000132f, 0.0000003799f, 0.0000014190f,
    0.0000005446f, 0.0000033533f, -0.0000041925f, 0.0000243728f, -0.0003249116f, -0.0002555667f,
    -0.0001781466f, -0.0000946691f, -0.0000512440f, -0.0000668181f, -0.0000538663f, -0.0000367589f,
    -0.0000153566f, -0.0000159763f, -0.0000043008f, 0.0000014360f, 0.0000256407f, -0.0000045056f,
    -0.0000224244f, -0.0000056258f, -0.0000573469f, -0.0000427838f, -0.0000040513f, 0.0000493530f,
    -0.0000199927f, -0.0000284530f, -0.0000443529f, -0.0000157197f, -0.0000152059f, -0.0000265666f,
    -0.0000286606f, 0.0000426372f, -0.0000445737f, -0.0000968212f, -0.0002992176f, -0.0006564777f,
    -0.0009923400f, -0.0010465131f, -0.0006586000f, -0.0003460162f, -0.0000803812f, -0.0001828317f,
    -0.0001374910f, -0.0000892170f, -0.0000247429f, -0.0000281266f, -0.0000112548f, -0.0000220216f,
    0.0000281030f, -0.0001241423f, -0.0001739019f, 0.0006003709f, -0.0007665771f, 0.0001545192f,
    0.0001183979f, -0.0000725009f, 0.0000709099f, 0.0000556600f, 0.0000787870f, 0.0000127551f,
    0.0000418355f, 0.0000676110f, 0.0000771386f, -0.0001678521f, 0.0001526165f, 0.0003591734f,
    0.0011851563f, 0.0019531880f, -0.0018073091f, -0.0020646655f, -0.0018286838f, -0.0012220764f,
    -0.0007555665f, -0.0006377868f, -0.0003093176f, 0.0000756312f, 0.0005274300f, 0.0009274213f,
    0.0012803192f, 0.0016235299f, 0.0017557598f, 0.0018111856f, 0.0016683303f, 0.0002150325f,
    0.0016540635f, 0.0015774318f, 0.0017217761f, 0.0018831036f, 0.0020842542f, 0.0023790930f,
    0.0026699692f, 0.0028034973f, 0.0028981065f, 0.0030135931f, 0.0030635897f, 0.0029615904f,
    0.0027120429f, 0.0022714745f, 0.0016059652f, 0.0006835412f, -0.0005828829f, -0.0013844400f,
    -0.0018243580f, -0.0019502151f, -0.0017356111f, -0.0011689841f, -0.0004229350f, 0.0003965073f,
    0.0011294169f, 0.0017707072f, 0.0023448371f, 0.0026728102f, 0.0027087051f, 0.0025324105f,
    0.0022209939f, 0.0019939538f, 0.0015995394f, 0.0003709522f, -0.0006814813f, -0.0018062812f,
    -0.0029774326f, -0.0040602444f, -0.0050788762f, -0.0060470476f, -0.0069716019f, -0.0078811278f,
    -0.0088339160f, -0.0098593061f, -0.0110571431f, -0.0123801308f, -0.0137829951f, -0.0152658987f,
    0.0169119551f, 0.0185130319f, 0.0200914127f, 0.0217670701f, 0.0236411334f, 0.0257401339f,
    0.0280588687f, 0.0306516429f, 0.0335396415f, 0.0367140220f, 0.0401734073f, 0.0439328404f,
    0.0480118471f, 0.0523958086f, 0.0570643279f, 0.0619617615f, 0.0672386055f, 0.0727386082f,
    0.0783586322f, 0.0840454562f, 0.0897239254f, 0.0953063133f, 0.1006989894f, 0.1058297221f,
    0.1105886458f, 0.1148828316f, 0.1186363019f, 0.1217873693f, 0.1242652074f, 0.1260376844f,
    0.1270428159f, 0.1271553981f, 0.1266717254f, 0.1255342565f, 0.1232765470f, 0.1198938969f,
    0.1153006197f, 0.1094250684f, 0.1021978763f, 0.0935850985f, 0.0835853025f, 0.0722146942f,
    0.0594803881f, 0.0453959671f, 0.0299515180f, 0.0131448092f, -0.0050174243f, -0.0245067664f,
    -0.0453599939f, -0.0675506175f, -0.0909864895f, -0.1156500318f, -0.1415054519f, -0.1685034579f,
    -0.1965824123f, -0.2256851924f, -0.2557490596f, -0.2867109877f, -0.3185003509f, -0.3510308710f,
    -0.3841878257f, -0.4178462189f, -0.4518783777f, -0.4861948985f, 0.5204589154f, 0.5545392477f,
    0.5885349528f, 0.6222881265f, 0.6556472882f, 0.6884462258f, 0.7205203255f, 0.7517187214f,
    0.7819150729f, 0.8109973423f, 0.8388462493f, 0.8653227793f, 0.8902717587f, 0.9135401037f,
    0.9350004724f, 0.9545704608f, 0.9721900670f, 0.9878415249f, 1.0014908046f, 1.0130877123f,
    1.0225821802f, 1.0299620942f, 1.0352930981f, 1.0387279035f, 1.0404656862f, 1.0406699226f,
    1.0393792732f, 1.0364602207f, 1.0316371259f, 1.0246094465f, 1.0152749279f, 1.0045111461f,
    0.9872243762f, 0.9634951727f, 0.9386029698f, 0.9118835665f, 0.8836131513f, 0.8542438147f,
    0.8241955864f, 0.7937396816f, 0.7629631733f, 0.7318123869f, 0.7001870615f, 0.6680338585f,
    0.6353919868f, 0.6023736401f, 0.5691034053f, 0.5356571527f, 0.5020472026f, 0.4682522004f,
    0.4342757821f, 0.4002060880f, 0.3661991567f, 0.3324016480f, 0.2988415427f, 0.2653598332f,
    0.2316572400f, 0.1974745970f, 0.1628547074f, 0.1283770554f, 0.0952404323f, 0.0650740936f,
    0.0392771501f, 0.0163785856f,
};

/* SNR: 81.55, PHASE: 0.500000000000000 */
const float CLDFB80_40[400] =
{
    -0.0000041528f, -0.0000003900f, -0.0000033779f, 0.0000013260f, -0.0000003143f, -0.0000019348f,
    0.0000002820f, 0.0000000171f, 0.0000000756f, 0.0000001478f, -0.0000006625f, 0.0000000082f,
    0.0000000114f, -0.0000002690f, -0.0000007281f, 0.0000005577f, -0.0000000239f, 0.0000002429f,
    -0.0000004091f, 0.0000026069f, 0.0000034995f, -0.0000001726f, 0.0000002145f, -0.0000000401f,
    0.0000006351f, -0.0000000199f, -0.0000000701f, -0.0000000269f, -0.0000000511f, -0.0000018158f,
    0.0000003875f, 0.0000000519f, 0.0000000148f, 0.0000002168f, 0.0000008257f, -0.0000004464f,
    0.0000006336f, -0.0000025316f, -0.0000005295f, -0.0000153180f, -0.0000308298f, -0.0000015398f,
    -0.0000152958f, 0.0000058438f, -0.0000013050f, -0.0000070187f, 0.0000011695f, 0.0000000763f,
    0.0000001881f, 0.0000003524f, -0.0000015865f, -0.0000000049f, -0.0000000249f, -0.0000006192f,
    -0.0000011121f, 0.0000012060f, -0.0000000166f, 0.0000001099f, -0.0000106587f, 0.0000106129f,
    -0.0000148286f, 0.0000149412f, 0.0000001626f, 0.0000000725f, -0.0000015409f, 0.0000000950f,
    0.0000003484f, 0.0000001231f, 0.0000001497f, 0.0000043429f, -0.0000009269f, -0.0000001280f,
    -0.0000000626f, -0.0000009033f, -0.0000040910f, 0.0000019169f, -0.0000028704f, 0.0000109325f,
    -0.0000009252f, 0.0000489011f, -0.0003468893f, -0.0003166165f, -0.0002216732f, -0.0001440458f,
    -0.0000849613f, -0.0000369773f, -0.0000635098f, -0.0000591070f, -0.0000486803f, -0.0000341989f,
    -0.0000120811f, -0.0000190275f, -0.0000064494f, 0.0000069162f, -0.0000021987f, 0.0000272330f,
    0.0000008567f, -0.0000105879f, 0.0000129785f, -0.0000391934f, -0.0000840231f, 0.0000041534f,
    -0.0000069437f, 0.0000002747f, 0.0000564106f, -0.0000335888f, -0.0000091603f, -0.0000220067f,
    -0.0000377648f, -0.0000212702f, -0.0000107779f, -0.0000254405f, -0.0000262093f, -0.0000203017f,
    0.0000691479f, -0.0000348713f, -0.0000882526f, -0.0001632241f, -0.0003897623f, -0.0007277920f,
    -0.0009273781f, -0.0011866370f, -0.0007657374f, -0.0005999553f, -0.0002985749f, -0.0000739204f,
    -0.0001965512f, -0.0001587267f, -0.0001222374f, -0.0000844484f, -0.0000080229f, -0.0000361957f,
    -0.0000240334f, 0.0000097698f, -0.0000196647f, 0.0000408240f, -0.0000873313f, -0.0001974888f,
    -0.0000745679f, 0.0006405856f, -0.0007833142f, -0.0000263740f, 0.0001825899f, 0.0000836328f,
    -0.0000919747f, 0.0000758216f, 0.0000210116f, 0.0000664122f, 0.0000716628f, -0.0000011497f,
    0.0000361513f, 0.0000644816f, 0.0000707314f, 0.0000692091f, -0.0002055217f, 0.0001007125f,
    0.0003613597f, 0.0005722141f, 0.0014928248f, 0.0019595151f, -0.0018123181f, -0.0021841686f,
    -0.0019313868f, -0.0016661118f, -0.0011520847f, -0.0007460794f, -0.0007200000f, -0.0004759622f,
    -0.0001911740f, 0.0001177745f, 0.0005112609f, 0.0007956582f, 0.0011317990f, 0.0014125904f,
    0.0016338868f, 0.0017396047f, 0.0018056445f, 0.0018052119f, 0.0014209425f, 0.0000970427f,
    0.0015804238f, 0.0015713347f, 0.0016260006f, 0.0017792934f, 0.0018939546f, 0.0020439435f,
    0.0023023017f, 0.0025264800f, 0.0027361034f, 0.0028056985f, 0.0028830887f, 0.0029840440f,
    0.0030499023f, 0.0030582362f, 0.0029323543f, 0.0027372045f, 0.0024602608f, 0.0018918251f,
    0.0014430869f, 0.0005567848f, -0.0004563602f, -0.0012376069f, -0.0015957612f, -0.0019181670f,
    -0.0019416943f, -0.0017732047f, -0.0013639015f, -0.0008131398f, -0.0001818974f, 0.0004785653f,
    0.0010577894f, 0.0015807496f, 0.0020750864f, 0.0024484891f, 0.0027097859f, 0.0027252487f,
    0.0025942388f, 0.0023933812f, 0.0021363139f, 0.0019878937f, 0.0017252901f, 0.0007007239f,
    -0.0001528669f, -0.0010081819f, -0.0019255759f, -0.0028704299f, -0.0037352063f, -0.0045760650f,
    -0.0053741521f, -0.0061399643f, -0.0068807053f, -0.0076055948f, -0.0083505693f, -0.0091327970f,
    -0.0099660466f, -0.0109276265f, -0.0119779770f, -0.0130668832f, -0.0142243967f, -0.0154284789f,
    0.0167425678f, 0.0180870259f, 0.0192629868f, 0.0205914974f, 0.0219419942f, 0.0234393525f,
    0.0250925019f, 0.0268648248f, 0.0288064481f, 0.0309261411f, 0.0332359672f, 0.0357337882f,
    0.0384058373f, 0.0412703873f, 0.0443254146f, 0.0475898752f, 0.0510512395f, 0.0546934731f,
    0.0585192825f, 0.0624617968f, 0.0666925081f, 0.0710800609f, 0.0755330962f, 0.0800607977f,
    0.0846155968f, 0.0891603964f, 0.0936468776f, 0.0980290565f, 0.1022710303f, 0.1063242147f,
    0.1101321383f, 0.1136484689f, 0.1168337639f, 0.1196454804f, 0.1220672782f, 0.1240474957f,
    0.1255837620f, 0.1266445580f, 0.1271706795f, 0.1271032514f, 0.1267122859f, 0.1259990302f,
    0.1245431141f, 0.1223810246f, 0.1194917271f, 0.1158164730f, 0.1113281486f, 0.1059821849f,
    0.0997598463f, 0.0926475473f, 0.0846476380f, 0.0757687538f, 0.0660180747f, 0.0553969977f,
    0.0439122033f, 0.0315571111f, 0.0183294511f, 0.0042339687f, -0.0107303776f, -0.0265261206f,
    -0.0432087461f, -0.0607651851f, -0.0791119955f, -0.0982585186f, -0.1181828257f, -0.1388675094f,
    -0.1602878821f, -0.1824109255f, -0.2052090118f, -0.2286494873f, -0.2527009969f, -0.2773319455f,
    -0.3025075323f, -0.3281859857f, -0.3543210024f, -0.3808473827f, -0.4077028160f, -0.4348259057f,
    -0.4621422068f, -0.4896449982f, 0.5170583948f, 0.5443118380f, 0.5715622296f, 0.5986919021f,
    0.6256446209f, 0.6523342207f, 0.6786749944f, 0.7045840109f, 0.7299779641f, 0.7547853740f,
    0.7789437691f, 0.8023962911f, 0.8250842263f, 0.8469401272f, 0.8678891784f, 0.8878500705f,
    0.9067442457f, 0.9245026353f, 0.9410725379f, 0.9564213901f, 0.9705164338f, 0.9833542233f,
    0.9949193206f, 1.0051881116f, 1.0141325299f, 1.0217280805f, 1.0279678321f, 1.0328759990f,
    1.0365142018f, 1.0389749476f, 1.0403626832f, 1.0407638661f, 1.0402158247f, 1.0386859218f,
    1.0360693875f, 1.0322135556f, 1.0269616972f, 1.0202228069f, 1.0121135675f, 1.0035354422f,
    0.9897053659f, 0.9706651118f, 0.9512828704f, 0.9307719520f, 0.9091186544f, 0.8864979484f,
    0.8631436896f, 0.8392834698f, 0.8150938957f, 0.7906763160f, 0.7660562253f, 0.7412033356f,
    0.7160643565f, 0.6905965223f, 0.6647900873f, 0.6386753533f, 0.6123109042f, 0.5857635917f,
    0.5590863635f, 0.5323035448f, 0.5054159767f, 0.4784116395f, 0.4512831657f, 0.4240582163f,
    0.3967995814f, 0.3695924504f, 0.3425141525f, 0.3155972383f, 0.2888001961f, 0.2620044852f,
    0.2350467488f, 0.2077866806f, 0.1801971236f, 0.1524510915f, 0.1249766396f, 0.0984509433f,
    0.0737154373f, 0.0515800648f, 0.0323408448f, 0.0138765961f,
};


/* SNR: 85.15, PHASE: 0.166666666666667 */
const float CLDFB80_60[600] =
{
    -0.0000108386f, 0.0000016461f, -0.0000001140f, 0.0000015161f, -0.0000046862f, -0.0000001825f,
    0.0000001498f, -0.0000000815f, -0.0000033014f, 0.0000001274f, -0.0000001822f, 0.0000000191f,
    0.0000000335f, 0.0000000240f, 0.0000001226f, -0.0000010507f, 0.0000001892f, 0.0000000108f,
    -0.0000000274f, -0.0000002365f, -0.0000000901f, -0.0000002666f, -0.0000007031f, 0.0000006413f,
    -0.0000000514f, -0.0000000079f, 0.0000002000f, -0.0000014744f, 0.0000048656f, -0.0000001578f,
    -0.0000005544f, 0.0000070490f, -0.0000012678f, 0.0000001774f, 0.0000000032f, -0.0000000624f,
    0.0000007343f, 0.0000001499f, -0.0000000401f, -0.0000000182f, -0.0000000944f, -0.0000000302f,
    -0.0000000091f, 0.0000004307f, -0.0000028538f, 0.0000002990f, -0.0000000787f, 0.0000000221f,
    0.0000000116f, -0.0000001070f, 0.0000001406f, -0.0000009019f, 0.0000015376f, -0.0000000209f,
    -0.0000002404f, -0.0000025088f, -0.0000000262f, 0.0000000630f, 0.0000044280f, -0.0000305498f,
    -0.0000482857f, 0.0000046060f, -0.0000005548f, 0.0000056679f, -0.0000207092f, -0.0000003611f,
    0.0000005381f, -0.0000004877f, -0.0000120827f, 0.0000006267f, -0.0000006126f, 0.0000000608f,
    0.0000000850f, 0.0000000605f, 0.0000002921f, -0.0000025140f, 0.0000004365f, 0.0000000116f,
    -0.0000000639f, -0.0000003741f, -0.0000004826f, -0.0000006420f, -0.0000009508f, 0.0000015544f,
    -0.0000000218f, 0.0000006700f, 0.0000004181f, -0.0000021629f, -0.0000087189f, 0.0000088821f,
    -0.0000126345f, 0.0000114297f, 0.0000034734f, -0.0000001464f, -0.0000007710f, 0.0000000568f,
    -0.0000018420f, -0.0000002908f, 0.0000001921f, 0.0000004300f, 0.0000001583f, 0.0000000782f,
    0.0000000378f, -0.0000010138f, 0.0000068268f, -0.0000007152f, 0.0000001875f, -0.0000000557f,
    -0.0000000384f, 0.0000003789f, -0.0000006147f, 0.0000030092f, -0.0000065731f, 0.0000001500f,
    0.0000007177f, 0.0000112115f, 0.0000001848f, -0.0000012026f, -0.0000036253f, 0.0000992289f,
    -0.0003607599f, -0.0003045828f, -0.0002977550f, -0.0001992588f, -0.0002068946f, -0.0001476180f,
    -0.0000980857f, -0.0000330428f, -0.0000555832f, -0.0000621497f, -0.0000658559f, -0.0000573785f,
    -0.0000513819f, -0.0000416668f, -0.0000295334f, -0.0000092197f, -0.0000207558f, -0.0000179295f,
    -0.0000092361f, -0.0000046097f, 0.0000131986f, 0.0000028970f, 0.0000096778f, 0.0000247417f,
    0.0000038052f, -0.0000064960f, -0.0000124163f, -0.0000092122f, 0.0000515938f, -0.0000831154f,
    -0.0001125238f, 0.0000257367f, -0.0000286390f, -0.0000087198f, -0.0000068671f, 0.0000026174f,
    0.0000461536f, 0.0000029284f, -0.0000148640f, 0.0000099199f, -0.0000209369f, -0.0000366334f,
    -0.0000401223f, -0.0000191720f, -0.0000276997f, -0.0000075415f, -0.0000235869f, -0.0000261427f,
    -0.0000261960f, -0.0000286778f, -0.0000147880f, 0.0000339128f, 0.0000594843f, -0.0000475296f,
    -0.0000916631f, -0.0001104448f, -0.0001832659f, -0.0003546036f, -0.0004947290f, -0.0008075304f,
    -0.0008607843f, -0.0011759540f, -0.0011280060f, -0.0008472242f, -0.0006581582f, -0.0005496107f,
    -0.0003610854f, -0.0001310136f, -0.0000843705f, -0.0001929211f, -0.0001782524f, -0.0001519136f,
    -0.0001298443f, -0.0001002354f, -0.0000721302f, 0.0000080280f, -0.0000465158f, -0.0000338343f,
    -0.0000199728f, -0.0000188237f, 0.0000123819f, -0.0000217824f, 0.0000285072f, 0.0000230642f,
    -0.0000681343f, -0.0001359344f, -0.0002126650f, -0.0001268185f, 0.0002814194f, 0.0005796200f,
    -0.0006917457f, -0.0004814411f, 0.0000740708f, 0.0001943933f, 0.0001302339f, 0.0000640566f,
    -0.0000644259f, -0.0000257394f, 0.0000673956f, 0.0000057778f, 0.0000578339f, 0.0000733133f,
    0.0000756517f, 0.0000485628f, -0.0000143756f, 0.0000258732f, 0.0000543116f, 0.0000662824f,
    0.0000694890f, 0.0000763443f, 0.0000515654f, -0.0001531987f, -0.0001495108f, 0.0001684928f,
    0.0003371435f, 0.0003492618f, 0.0007408282f, 0.0013614773f, 0.0018283780f, 0.0019512654f,
    -0.0018468584f, -0.0019931487f, -0.0021435886f, -0.0019354719f, -0.0018716309f, -0.0015855347f,
    -0.0012449413f, -0.0008617653f, -0.0007595430f, -0.0007484226f, -0.0006080124f, -0.0004298524f,
    -0.0002469285f, -0.0000337803f, 0.0001833366f, 0.0004827171f, 0.0006187704f, 0.0008525160f,
    0.0010861242f, 0.0012478726f, 0.0014766763f, 0.0016195479f, 0.0016757046f, 0.0017606977f,
    0.0018011194f, 0.0018115391f, 0.0017918594f, 0.0015514538f, 0.0007745483f, 0.0000722375f,
    0.0013858425f, 0.0016550121f, 0.0015724609f, 0.0016037139f, 0.0017032298f, 0.0018041572f,
    0.0018793499f, 0.0019356593f, 0.0020977586f, 0.0022698159f, 0.0024080283f, 0.0025652021f,
    0.0027100014f, 0.0027878510f, 0.0028094267f, 0.0028631331f, 0.0029379588f, 0.0029982766f,
    0.0030408094f, 0.0030637651f, 0.0030520617f, 0.0029707674f, 0.0028257202f, 0.0027032586f,
    0.0025230449f, 0.0021943273f, 0.0018058213f, 0.0015201289f, 0.0010679683f, 0.0003894925f,
    -0.0002840705f, -0.0009250455f, -0.0013074121f, -0.0015395618f, -0.0017798333f, -0.0019401547f,
    -0.0019524700f, -0.0018826540f, -0.0017220928f, -0.0014455464f, -0.0011010583f, -0.0007116751f,
    -0.0002892919f, 0.0001463485f, 0.0005842019f, 0.0009616845f, 0.0013293069f, 0.0016655901f,
    0.0019957600f, 0.0022974838f, 0.0024834913f, 0.0026599403f, 0.0027746423f, 0.0027031419f,
    0.0026172855f, 0.0025078917f, 0.0023497345f, 0.0021702568f, 0.0020425098f, 0.0019860915f,
    0.0018636567f, 0.0011954954f, 0.0005514571f, -0.0000141897f, -0.0005741594f, -0.0011558780f,
    -0.0017668142f, -0.0024120809f, -0.0030128714f, -0.0035882532f, -0.0041653667f, -0.0047110318f,
    -0.0052436287f, -0.0057623702f, -0.0062633358f, -0.0067586961f, -0.0072425386f, -0.0077278117f,
    -0.0082234072f, -0.0087363677f, -0.0092686369f, -0.0098240661f, -0.0104237699f, -0.0111004947f,
    -0.0118009488f, -0.0125156239f, -0.0132546394f, -0.0140277665f, -0.0148077168f, -0.0156486149f,
    0.0165211147f, 0.0174398402f, 0.0182775949f, 0.0190534138f, 0.0199230411f, 0.0208118290f,
    0.0217092634f, 0.0226649147f, 0.0237088141f, 0.0248100351f, 0.0259599813f, 0.0271764016f,
    0.0284714021f, 0.0298434758f, 0.0312965027f, 0.0328356927f, 0.0344649815f, 0.0361664394f,
    0.0379470806f, 0.0398139569f, 0.0417666458f, 0.0438027210f, 0.0459314689f, 0.0481532079f,
    0.0504618496f, 0.0528498740f, 0.0553180491f, 0.0578703090f, 0.0604788669f, 0.0631374695f,
    0.0659669298f, 0.0688814001f, 0.0718159332f, 0.0747835495f, 0.0777923399f, 0.0808186627f,
    0.0838554308f, 0.0868947517f, 0.0899116089f, 0.0929041126f, 0.0958553537f, 0.0987459119f,
    0.1015756668f, 0.1043243835f, 0.1069774737f, 0.1095164928f, 0.1119302041f, 0.1142027056f,
    0.1163273532f, 0.1182880738f, 0.1200768686f, 0.1216925159f, 0.1231125873f, 0.1243362384f,
    0.1253610086f, 0.1261745561f, 0.1267721689f, 0.1271241769f, 0.1272284850f, 0.1270239254f,
    0.1267589302f, 0.1264656300f, 0.1258046109f, 0.1248336057f, 0.1235525506f, 0.1219504858f,
    0.1200252469f, 0.1177556666f, 0.1151258716f, 0.1121348547f, 0.1087635447f, 0.1050067776f,
    0.1008590143f, 0.0963144136f, 0.0913759079f, 0.0860427416f, 0.0803171444f, 0.0742040884f,
    0.0677045255f, 0.0608146076f, 0.0535432746f, 0.0458874964f, 0.0378425383f, 0.0294132744f,
    0.0205946670f, 0.0113896330f, 0.0018004463f, -0.0081766098f, -0.0185270856f, -0.0292402963f,
    -0.0403618604f, -0.0518892622f, -0.0637672152f, -0.0759976007f, -0.0885871716f, -0.1015258403f,
    -0.1148084399f, -0.1284318249f, -0.1423873123f, -0.1566679827f, -0.1712634880f, -0.1861645588f,
    -0.2013636452f, -0.2168508609f, -0.2326166940f, -0.2486510515f, -0.2649463144f, -0.2814911369f,
    -0.2982752192f, -0.3152867427f, -0.3325116487f, -0.3499355632f, -0.3675395959f, -0.3853024154f,
    -0.4032065616f, -0.4212350657f, -0.4393672268f, -0.4575772736f, -0.4758650706f, -0.4942431738f,
    0.5125205124f, 0.5306725282f, 0.5488577283f, 0.5670276108f, 0.5851445237f, 0.6031984616f,
    0.6211684103f, 0.6390281696f, 0.6567504157f, 0.6743123793f, 0.6916889535f, 0.7088542063f,
    0.7257845309f, 0.7424591009f, 0.7588584440f, 0.7749648928f, 0.7907617163f, 0.8062324551f,
    0.8213587554f, 0.8361206884f, 0.8504967301f, 0.8644639148f, 0.8779983070f, 0.8910752510f,
    0.9036722755f, 0.9157691951f, 0.9273480313f, 0.9383949141f, 0.9489012228f, 0.9588586337f,
    0.9682545154f, 0.9770929872f, 0.9853708240f, 0.9930809758f, 1.0002174168f, 1.0067717565f,
    1.0127347711f, 1.0180999340f, 1.0228621525f, 1.0270212624f, 1.0305853696f, 1.0335685634f,
    1.0359921286f, 1.0378851378f, 1.0392782898f, 1.0402014380f, 1.0406826783f, 1.0407387739f,
    1.0403729933f, 1.0395784114f, 1.0383296408f, 1.0365863031f, 1.0343061945f, 1.0314399587f,
    1.0279374991f, 1.0237762412f, 1.0189593836f, 1.0135316260f, 1.0076524569f, 1.0021150619f,
    0.9928949328f, 0.9800034826f, 0.9674886109f, 0.9545877700f, 0.9411740407f, 0.9272370892f,
    0.9128016387f, 0.8979145998f, 0.8826491402f, 0.8670774704f, 0.8512639848f, 0.8352705212f,
    0.8191434022f, 0.8029102780f, 0.7865870046f, 0.7701746598f, 0.7536620391f, 0.7370346195f,
    0.7202763550f, 0.7033730373f, 0.6863185156f, 0.6691140098f, 0.6517679660f, 0.6342966925f,
    0.6167195326f, 0.5990562278f, 0.5813252524f, 0.5635402746f, 0.5457078369f, 0.5278295335f,
    0.5099048467f, 0.4919297136f, 0.4738984035f, 0.4558126317f, 0.4376796414f, 0.4195151253f,
    0.4013417258f, 0.3831842053f, 0.3650685616f, 0.3470163688f, 0.3290362900f, 0.3111247009f,
    0.2932627295f, 0.2754121565f, 0.2575267491f, 0.2395585877f, 0.2214602867f, 0.2032086383f,
    0.1848152793f, 0.1663238479f, 0.1478361334f, 0.1295133662f, 0.1115465981f, 0.0941771468f,
    0.0776828916f, 0.0622889538f, 0.0481725935f, 0.0353986404f, 0.0233593568f, 0.0103354077f,
};

const float rot_vec_ana_re_L10[5] =
{
    2.8262465099f,2.6536058227f,2.2212117088f,1.5713899168f,0.7677495312f,
};

const float rot_vec_ana_im_L10[5] =
{
    -0.1110435278f,-0.9789668726f,-1.7510621190f,-2.3517512048f,-2.7222344971f,
};

const float rot_vec_ana_re_L16[8] =
{
    2.2353945156f,2.1817362886f,2.0442351594f,1.8281752196f,1.5418595313f,1.1962910459f,
    0.8047497665f,0.3822824048f,
};

const float rot_vec_ana_im_L16[8] =
{
    -0.0548758552f,-0.4899252669f,-0.9061471254f,-1.2875462580f,-1.6194657100f,-1.8891500029f,
    -2.0862353207f,-2.2031477851f,
};

const float rot_vec_ana_re_L20[10] =
{
    1.9996144810f,1.9688531362f,1.8896120929f,1.7638425287f,1.5946413075f,1.3861747251f,
    1.1435759205f,0.8728184813f,0.5805693545f,0.2740246834f,
};

const float rot_vec_ana_im_L20[10] =
{
    -0.0392673849f,-0.3515925599f,-0.6552603591f,-0.9427934737f,-1.2071118839f,-1.4417071934f,
    -1.6408028871f,-1.7994965681f,-1.9138806715f,-1.9811386809f,
};

const float rot_vec_ana_re_L30[15] =
{
    1.6328532594f,1.6216739995f,1.5927273399f,1.5463304262f,1.4829915928f,1.4034047932f,
    1.3084419970f,1.1991436365f,1.0767072074f,0.9424741487f,0.7979151461f,0.6446140182f,
    0.4842503641f,0.3185811618f,0.1494215176f,
};

const float rot_vec_ana_im_L30[15] =
{
    -0.0213752201f,-0.1919377663f,-0.3603974022f,-0.5249084488f,-0.6836684885f,-0.8349381133f,
    -0.9770599813f,-1.1084769757f,-1.2277492644f,-1.3335700753f,-1.4247800133f,-1.5003797633f,
    -1.5595410387f,-1.6016156561f,-1.6261426373f,
};

const float rot_vec_ana_re_L32[16] =
{
    1.5810197732f,1.5715049038f,1.5468555830f,1.5073091974f,1.4532466002f,1.3851884438f,
    1.3037901655f,1.2098356752f,1.1042298059f,0.9879896000f,0.8622345142f,0.7281756387f,
    0.5871040336f,0.4403782958f,0.2894114743f,0.1356574621f,
};

const float rot_vec_ana_im_L32[16] =
{
    -0.0194030057f,-0.1742766119f,-0.3274718390f,-0.4775133334f,-0.6229561133f,-0.7623994853f,
    -0.8945005334f,-1.0179870525f,-1.1316697997f,-1.2344539482f,-1.3253496303f,-1.4034814709f,
    -1.4680970178f,-1.5185739878f,-1.5544262602f,-1.5753085580f,
};

const float rot_vec_ana_re_L40[20] =
{
    1.4141454099f,1.4086967623f,1.3945630307f,1.3718313542f,1.3406418813f,1.3011869053f,
    1.2537096794f,1.1985029164f,1.1359069844f,1.0663078081f,0.9901344896f,0.9078566627f,
    0.8199815976f,0.7270510733f,0.6296380373f,0.5283430735f,0.4237906989f,0.3166255137f,
    0.2075082270f,0.0971115830f,
};

const float rot_vec_ana_im_L40[20] =
{
    -0.0138837862f,-0.1247935572f,-0.2349339344f,-0.3436258658f,-0.4501992295f,-0.5539969652f,
    -0.6543791254f,-0.7507268207f,-0.8424460355f,-0.9289712904f,-1.0097691283f,-1.0843414038f,
    -1.1522283539f,-1.2130114331f,-1.2663158934f,-1.3118130952f,-1.3492225330f,-1.3783135652f,
    -1.3989068360f,-1.4108753809f,
};

const float rot_vec_ana_re_L60[30] =
{
    1.1546758066f,1.1526978375f,1.1475604038f,1.1392775867f,1.1278720890f,1.1133751723f,
    1.0958265716f,1.0752743865f,1.0517749490f,1.0253926695f,0.9961998600f,0.9642765358f,
    0.9297101968f,0.8925955867f,0.8530344341f,0.8111351735f,0.7670126477f,0.7207877935f,
    0.6725873102f,0.6225433117f,0.5707929653f,0.5174781151f,0.4627448933f,0.4067433200f,
    0.3496268915f,0.2915521599f,0.2326783042f,0.1731666934f,0.1131804447f,0.0528839763f,
};

const float rot_vec_ana_im_L60[30] =
{
    -0.0075574434f,-0.0679781487f,-0.1282125306f,-0.1880954908f,-0.2474628944f,-0.3061520194f,
    -0.3640020030f,-0.4208542824f,-0.4765530295f,-0.5309455779f,-0.5838828413f,-0.6352197224f,
    -0.6848155104f,-0.7325342668f,-0.7782451976f,-0.8218230124f,-0.8631482675f,-0.9021076931f,
    -0.9385945043f,-0.9725086932f,-1.0037573034f,-1.0322546845f,-1.0579227273f,-1.0806910775f,
    -1.1004973285f,-1.1172871929f,-1.1310146507f,-1.1416420760f,-1.1491403397f,-1.1534888896f,
};



const float rot_vec_syn_re_L10[5] =
{
    0.1117172025f,0.1048929802f,0.0878011021f,0.0621146404f,0.0303479649f,
};

const float rot_vec_syn_im_L10[5] =
{
    -0.0043893808f,-0.0386970634f,-0.0692168078f,-0.0929611287f,-0.1076057667f,
};

const float rot_vec_syn_re_L16[8] =
{
    0.1117697258f,0.1090868144f,0.1022117580f,0.0914087610f,0.0770929766f,0.0598145523f,
    0.0402374883f,0.0191141202f,
};

const float rot_vec_syn_im_L16[8] =
{
    -0.0027437928f,-0.0244962633f,-0.0453073563f,-0.0643773129f,-0.0809732855f,-0.0944575001f,
    -0.1043117660f,-0.1101573893f,
};

const float rot_vec_syn_re_L20[10] =
{
    0.1117818477f,0.1100622363f,0.1056325273f,0.0986017949f,0.0891431591f,0.0774895228f,
    0.0639278374f,0.0487920364f,0.0324548136f,0.0153184455f,
};

const float rot_vec_syn_im_L20[10] =
{
    -0.0021951135f,-0.0196546216f,-0.0366301676f,-0.0527037574f,-0.0674796057f,-0.0805938822f,
    -0.0917236698f,-0.1005949163f,-0.1069891821f,-0.1107490191f,
};

const float rot_vec_syn_re_L30[15] =
{
    0.1117938204f,0.1110284288f,0.1090465865f,0.1058700070f,0.1015334935f,0.0960845578f,
    0.0895828996f,0.0820997524f,0.0737171032f,0.0645267939f,0.0546295156f,0.0441337048f,
    0.0331543560f,0.0218117611f,0.0102301920f,
};

const float rot_vec_syn_im_L30[15] =
{
    -0.0014634613f,-0.0131410805f,-0.0246747234f,-0.0359380248f,-0.0468075816f,-0.0571643048f,
    -0.0668947240f,-0.0758922305f,-0.0840582459f,-0.0913033015f,-0.0975480191f,-0.1027239802f,
    -0.1067744758f,-0.1096551279f,-0.1113343755f,
};

const float rot_vec_syn_re_L32[16] =
{
    0.1117949803f,0.1111221774f,0.1093792072f,0.1065828555f,0.1027600526f,0.0979476142f,
    0.0921918867f,0.0855483010f,0.0780808384f,0.0698614146f,0.0609691872f,0.0514897932f,
    0.0415145243f,0.0311394479f,0.0204644816f,0.0095924311f,
};

const float rot_vec_syn_im_L32[16] =
{
    -0.0013719997f,-0.0123232174f,-0.0231557558f,-0.0337652916f,-0.0440496492f,-0.0539097846f,
    -0.0632507393f,-0.0719825548f,-0.0800211389f,-0.0872890758f,-0.0937163711f,-0.0992411265f,
    -0.1038101357f,-0.1073793965f,-0.1099145349f,-0.1113911364f,
};

const float rot_vec_syn_re_L40[20] =
{
    0.1117980110f,0.1113672575f,0.1102498879f,0.1084527911f,0.1059870468f,0.1028678571f,
    0.0991144528f,0.0947499750f,0.0898013320f,0.0842990340f,0.0782770044f,0.0717723711f,
    0.0648252372f,0.0574784342f,0.0497772575f,0.0417691875f,0.0335035965f,0.0250314447f,
    0.0164049658f,0.0076773447f,
};

const float rot_vec_syn_im_L40[20] =
{
    -0.0010976097f,-0.0098657969f,-0.0185731583f,-0.0271660100f,-0.0355913742f,-0.0437973057f,
    -0.0517332122f,-0.0593501664f,-0.0666012069f,-0.0734416290f,-0.0798292589f,-0.0857247149f,
    -0.0910916496f,-0.0958969739f,-0.1001110615f,-0.1037079311f,-0.1066654069f,-0.1089652549f,
    -0.1105932959f,-0.1115394925f,
};

const float rot_vec_syn_re_L60[30] =
{
    0.1118010042f,0.1116094882f,0.1111120583f,0.1103100780f,0.1092057454f,0.1078020875f,
    0.1061029516f,0.1041129948f,0.1018376715f,0.0992832183f,0.0964566367f,0.0933656741f,
    0.0900188027f,0.0864251961f,0.0825947039f,0.0785378255f,0.0742656803f,0.0697899780f,
    0.0651229863f,0.0602774970f,0.0552667912f,0.0501046030f,0.0448050816f,0.0393827526f,
    0.0338524782f,0.0282294165f,0.0225289799f,0.0167667930f,0.0109586494f,0.0051204690f,
};

const float rot_vec_syn_im_L60[30] =
{
    -0.0007317463f,-0.0065819559f,-0.0124141249f,-0.0182122676f,-0.0239604917f,-0.0296430418f,
    -0.0352443424f,-0.0407490407f,-0.0461420487f,-0.0514085845f,-0.0565342130f,-0.0615048852f,
    -0.0663069767f,-0.0709273254f,-0.0753532672f,-0.0795726710f,-0.0835739716f,-0.0873462018f,
    -0.0908790221f,-0.0941627493f,-0.0971883830f,-0.0999476301f,-0.1024329276f,-0.1046374636f,
    -0.1065551956f,-0.1081808673f,-0.1095100227f,-0.1105390187f,-0.1112650350f,-0.1116860815f,
};


const float bpf_weights_16[CLDFB_NO_COL_MAX] =
{
    1.000040f, 0.702561f, 0.208838f, 0.001553f, 0.001777f, 0.001370f, 0.000926f, 0.000554f,
    0.000270f, 0.000080f, 0.000030f, 0.000082f, 0.000081f, 0.000052f, 0.000017f, 0.000016f
};

/*-------------------------------------------------------------------*
 * LP CNG excitation details code book
 *-------------------------------------------------------------------*/
const float CNG_details_codebook[64][NUM_ENV_CNG]=
{
    {
        6.924306f,8.544082f,9.583108f,8.550549f,7.972679f,7.363361f,8.439027f,7.487016f,
        9.149983f,8.352748f,8.823824f,9.544188f,8.314853f,7.809112f,7.218567f,8.612295f,
        7.780142f,7.232745f,6.965988f,7.568601f
    },
    {
        9.374340f,7.795641f,7.379285f,8.396346f,9.895033f,10.221931f,10.015446f,10.087706f,
        10.536375f,10.581183f,10.733459f,10.821303f,10.822197f,10.777159f,10.746262f,10.936824f,
        10.820635f,10.881506f,9.992537f,8.925898f
    },
    {
        8.260058f,8.387338f,7.832300f,9.092162f,8.387571f,7.401807f,7.888559f,7.678440f,
        8.136854f,8.515383f,8.772667f,9.228788f,8.836490f,9.518608f,8.908790f,9.499302f,
        9.932305f,10.237994f,10.133189f,8.193151f
    },
    {
        10.124639f,10.788106f,10.767182f,10.692019f,10.830482f,9.359397f,10.431694f,11.161179f,
        10.356518f,10.541230f,8.185465f,8.116880f,11.338371f,10.284152f,10.511218f,10.880645f,
        10.220743f,11.179196f,11.066867f,10.445066f
    },
    {
        9.726912f,9.842380f,10.314793f,10.252558f,10.717097f,10.746290f,9.953682f,10.412869f,
        9.836176f,8.674436f,7.351096f,7.309156f,7.246638f,6.955070f,7.846981f,9.111964f,
        9.612611f,8.519944f,9.454450f,9.249232f
    },
    {
        10.298511f,10.439103f,10.451839f,9.763371f,10.337607f,10.939195f,10.938910f,10.824776f,
        10.976114f,10.974276f,10.754051f,10.581675f,10.222703f,9.126027f,8.198234f,7.695039f,
        6.968823f,7.457246f,9.904172f,9.612813f
    },
    {
        9.908430f,10.124971f,10.253873f,8.625096f,8.128853f,8.701863f,10.346726f,10.291558f,
        8.935132f,9.638033f,10.793781f,10.670537f,10.681151f,10.410478f,10.512748f,10.861156f,
        10.653567f,10.911621f,10.629312f,9.736268f
    },
    {
        11.810060f,11.612185f,11.468822f,11.083865f,11.406177f,11.832067f,11.661546f,11.277926f,
        7.555347f,8.622866f,12.176802f,10.751250f,10.721958f,9.523929f,9.626828f,11.701570f,
        11.848139f,10.849975f,11.640839f,11.392167f
    },
    {
        8.572747f,8.869074f,8.680323f,9.760900f,10.671435f,9.673125f,9.516179f,10.428748f,
        10.353197f,10.692994f,11.081258f,10.146167f,10.790188f,10.432859f,9.273769f,7.979839f,
        8.209611f,9.644866f,8.476103f,10.683167f
    },
    {
        8.595222f,7.301031f,8.322734f,11.874195f,11.543133f,10.814659f,12.073861f,11.818481f,
        11.602201f,12.035087f,11.952577f,12.363761f,12.167592f,12.254158f,12.108662f,12.373547f,
        11.860260f,9.014181f,10.036099f,8.638621f
    },
    {
        10.275646f,10.526311f,10.252750f,10.178793f,10.466885f,9.088381f,9.273152f,8.119694f,
        7.295121f,7.350810f,8.158489f,9.209213f,9.370357f,9.310070f,9.168746f,9.856857f,
        10.187559f,10.613888f,10.080095f,10.451872f
    },
    {
        12.318529f,11.945473f,12.303066f,12.451133f,12.272326f,12.478561f,12.303981f,12.279855f,
        12.189694f,10.818603f,10.013278f,8.600300f,7.832378f,8.014066f,11.346451f,11.673646f,
        10.466306f,10.728513f,11.475281f,12.085626f
    },
    {
        10.014422f,10.218554f,10.442979f,10.508470f,10.393559f,10.661362f,10.757983f,10.689740f,
        10.897243f,10.382886f,10.379339f,9.271018f,8.495484f,7.720114f,7.161139f,8.396199f,
        9.721141f,10.159747f,9.918998f,9.919149f
    },
    {
        11.034192f,11.766760f,11.903868f,11.195253f,11.683506f,11.900399f,12.318353f,12.368064f,
        12.271189f,12.306809f,12.485785f,12.136335f,12.220796f,11.960956f,11.879458f,11.099092f,
        11.004694f,7.854421f,8.103326f,11.485018f
    },
    {
        11.692872f,12.115354f,12.250820f,9.919422f,11.204221f,7.870928f,8.415102f,9.997985f,
        11.942008f,12.149603f,10.633919f,11.269428f,12.354749f,12.288899f,12.291698f,12.195188f,
        12.179792f,12.030136f,12.092098f,12.207270f
    },
    {
        11.755179f,8.064263f,9.749080f,12.185180f,11.136729f,11.763196f,8.889953f,8.555951f,
        12.034410f,12.245128f,11.697193f,11.559429f,10.780444f,11.789196f,12.130393f,11.689948f,
        11.623942f,11.399507f,11.981954f,10.904933f
    },
    {
        7.074471f,7.358261f,8.067513f,8.080610f,8.765159f,10.199254f,10.289200f,9.618623f,
        9.822992f,9.500810f,10.655619f,10.906424f,10.611357f,10.641397f,10.077725f,9.173571f,
        9.274541f,8.160206f,7.797956f,7.321218f
    },
    {
        9.641497f,8.341463f,7.913689f,9.615902f,12.212582f,12.373892f,11.788377f,12.044415f,
        11.569188f,12.302634f,12.361569f,12.119579f,12.223657f,12.303328f,12.384604f,12.306796f,
        12.109153f,12.154896f,10.165297f,11.492375f
    },
    {
        10.334753f,9.264669f,7.656600f,7.729103f,7.665664f,7.728192f,8.657525f,10.255910f,
        10.287778f,9.540968f,9.808374f,10.307826f,10.623036f,10.579712f,10.909159f,10.597071f,
        10.508566f,10.917792f,10.740663f,10.609496f
    },
    {
        12.464439f,12.387059f,12.281745f,12.415715f,12.481938f,12.064619f,12.051270f,10.871007f,
        9.753584f,8.710700f,7.918756f,8.510613f,11.316961f,11.829647f,11.667075f,12.037048f,
        12.184728f,12.269155f,12.388278f,12.256269f
    },
    {
        10.985455f,10.863164f,10.984641f,11.150430f,10.892216f,10.949295f,10.885633f,9.861358f,
        9.347205f,7.782274f,7.420996f,7.042737f,7.859407f,9.545682f,10.120652f,10.378402f,
        10.381286f,10.677829f,10.603589f,10.744861f
    },
    {
        11.619549f,10.501878f,10.291579f,11.911536f,12.263100f,11.638079f,11.827111f,11.886570f,
        11.885740f,11.982909f,11.279054f,11.820845f,11.897547f,11.508306f,10.922131f,7.355962f,
        9.090330f,12.035433f,11.309077f,11.814055f
    },
    {
        12.109969f,11.648486f,8.360036f,10.628968f,8.450899f,8.016151f,10.885192f,11.289871f,
        11.616718f,11.618735f,12.016033f,11.572757f,11.580486f,11.526383f,12.019007f,12.063487f,
        12.178980f,11.612581f,11.149741f,11.315678f
    },
    {
        11.982289f,12.039945f,10.895576f,11.808078f,11.972691f,11.752888f,11.100145f,7.459962f,
        9.401170f,12.240148f,11.661579f,11.968470f,10.817088f,11.060538f,12.236608f,12.217974f,
        11.888335f,12.158744f,12.290771f,12.263520f
    },
    {
        7.551557f,9.193432f,10.939713f,10.390559f,10.388751f,10.007786f,10.151727f,11.200849f,
        10.927567f,11.044189f,10.805322f,10.912845f,10.931647f,10.806228f,10.434938f,10.151430f,
        9.517872f,9.532900f,8.436217f,7.561033f
    },
    {
        7.914798f,9.662442f,12.315506f,11.969525f,11.779161f,10.819254f,11.074059f,12.259423f,
        12.310757f,12.028122f,12.393316f,12.259255f,12.478424f,12.251179f,11.982938f,12.119265f,
        12.321500f,11.854281f,11.885189f,7.733390f
    },
    {
        11.074573f,11.119295f,11.026623f,10.587306f,10.326489f,9.440902f,7.861374f,7.502906f,
        10.206084f,10.379787f,10.375632f,9.986627f,9.698876f,10.544230f,10.857472f,10.772952f,
        11.004036f,10.641294f,11.111090f,11.084974f
    },
    {
        12.312282f,11.569094f,12.027453f,11.997540f,12.050622f,12.124397f,11.441438f,11.697535f,
        11.553439f,11.941341f,11.153276f,7.695126f,8.494260f,12.226931f,11.163250f,11.056936f,
        11.197067f,8.736544f,11.552220f,11.995921f
    },
    {
        11.841222f,12.040383f,12.323356f,12.164479f,12.146215f,12.485503f,12.354469f,12.261094f,
        12.176959f,12.164176f,11.750998f,10.552405f,11.221596f,7.971972f,7.827245f,9.382548f,
        11.354092f,11.724841f,11.744237f,11.836000f
    },
    {
        11.863342f,11.946292f,10.565049f,10.276701f,12.088562f,11.987997f,11.516201f,11.701505f,
        12.013391f,12.254663f,12.160517f,11.530292f,11.789889f,12.011831f,12.307916f,11.817711f,
        7.388736f,8.277118f,12.146955f,11.330376f
    },
    {
        10.445749f,10.383992f,11.260086f,10.207924f,7.801878f,12.093586f,12.186577f,12.208809f,
        11.981275f,8.760727f,10.776209f,11.675901f,11.273578f,12.169944f,11.829489f,11.361869f,
        11.931891f,11.640718f,12.033961f,11.504183f
    },
    {
        11.418176f,11.996329f,11.634505f,12.108740f,12.232028f,12.223016f,11.168437f,11.585357f,
        12.287769f,10.519855f,11.961341f,12.135221f,11.941004f,11.400546f,12.083041f,12.021441f,
        12.087834f,12.196712f,12.153121f,11.933741f
    },
    {
        8.696248f,7.886807f,8.518339f,9.431623f,10.314435f,10.492967f,9.433606f,9.312992f,
        9.056099f,9.558634f,9.174564f,8.692657f,8.529263f,9.327991f,8.283659f,7.715106f,
        6.828506f,7.494133f,8.531253f,8.664100f
    },
    {
        8.749990f,9.185427f,7.974370f,7.730459f,9.471635f,11.246136f,11.225875f,11.585999f,
        11.810496f,11.799830f,11.983171f,12.095557f,12.123705f,12.150494f,12.057273f,12.058468f,
        12.128398f,12.119547f,11.788305f,9.252466f
    },
    {
        10.620537f,10.064924f,9.681692f,9.556549f,8.067345f,7.460412f,7.355683f,7.793144f,
        7.842898f,9.346528f,10.380497f,9.183150f,10.255505f,10.654870f,10.772358f,10.480097f,
        10.444176f,10.506150f,10.650716f,10.807790f
    },
    {
        11.832230f,12.163531f,12.210456f,12.488221f,12.106194f,11.716965f,12.486103f,11.839725f,
        12.333147f,12.101274f,7.643279f,9.040410f,12.480962f,11.550027f,12.089822f,11.299880f,
        10.714154f,12.309387f,12.290308f,12.153176f
    },
    {
        11.011459f,10.708299f,10.217109f,10.618895f,10.503453f,10.618390f,10.261137f,9.054105f,
        8.967848f,9.665904f,9.986521f,8.089101f,7.524849f,8.521540f,10.395278f,9.179631f,
        8.431019f,9.362102f,9.471244f,10.168259f
    },
    {
        11.385670f,11.988930f,11.979943f,12.082343f,12.240467f,12.163774f,12.389517f,12.076717f,
        12.254186f,12.165658f,11.824725f,11.992508f,10.716744f,10.217215f,10.610125f,8.819359f,
        7.553169f,8.576138f,7.663194f,8.161689f
    },
    {
        11.335433f,10.824145f,11.164507f,9.187079f,8.159495f,9.823243f,11.259155f,10.102992f,
        10.894949f,10.692467f,9.597807f,11.322961f,11.068228f,10.523948f,11.179681f,11.389847f,
        11.204894f,11.328845f,10.761085f,11.533332f
    },
    {
        12.452473f,12.226961f,12.414132f,12.453005f,12.224496f,11.829764f,9.932276f,9.747059f,
        7.944996f,8.074952f,10.982581f,11.711254f,11.656355f,11.826878f,12.063810f,12.048336f,
        12.100821f,12.339723f,12.171370f,12.491159f
    },
    {
        8.693851f,9.237082f,10.193584f,10.816728f,11.382530f,11.124274f,10.905251f,10.747824f,
        11.006325f,11.224193f,11.377479f,11.195903f,11.132830f,10.824033f,11.188758f,8.716391f,
        7.654446f,8.441257f,9.691014f,10.598401f
    },
    {
        8.319717f,9.639095f,12.133827f,12.102556f,11.919735f,12.334815f,11.993119f,12.259864f,
        12.158967f,12.356464f,12.374672f,12.379640f,12.396713f,12.146963f,12.203291f,11.311678f,
        8.605060f,10.391322f,8.431939f,7.948593f
    },
    {
        11.088415f,10.884553f,11.032227f,11.202397f,10.523194f,10.606202f,9.688022f,9.082882f,
        8.526981f,7.401042f,8.779226f,10.680804f,10.619134f,10.539470f,10.309608f,10.253415f,
        10.965061f,10.624226f,10.946682f,11.063556f
    },
    {
        12.049884f,12.395158f,12.315166f,12.298508f,12.409452f,12.353070f,12.369121f,12.232027f,
        12.363715f,12.371237f,11.460312f,12.028971f,8.312684f,8.200596f,10.810326f,11.885057f,
        12.140730f,11.769361f,11.470847f,11.374696f
    },
    {
        11.318600f,10.855831f,10.592196f,10.190356f,10.852498f,11.480312f,10.896217f,11.130247f,
        11.148643f,11.272378f,10.871895f,11.095495f,8.893303f,9.083083f,8.899607f,8.150163f,
        10.035096f,11.004933f,11.685496f,11.349737f
    },
    {
        12.437282f,11.779876f,12.273005f,12.224300f,11.436580f,12.714269f,12.546281f,12.410135f,
        12.488817f,12.347595f,12.661417f,12.587544f,12.405058f,12.452996f,11.808998f,11.644467f,
        11.697278f,7.908151f,11.580981f,12.178329f
    },
    {
        12.383582f,11.978909f,12.263449f,12.181010f,11.308676f,10.129762f,7.630591f,11.672964f,
        12.255041f,12.043112f,12.393015f,11.554902f,11.858689f,12.585340f,12.405621f,12.438987f,
        12.422440f,12.429326f,12.518377f,12.596020f
    },
    {
        12.294228f,7.930717f,10.000073f,12.115003f,11.276157f,12.374399f,12.087711f,11.020492f,
        12.205840f,12.519583f,12.094537f,12.497026f,12.274739f,12.595242f,12.627252f,12.238583f,
        12.414072f,12.458577f,12.250254f,12.212063f
    },
    {
        10.220644f,10.133038f,9.384470f,9.330061f,9.287414f,10.419335f,10.086744f,10.347366f,
        9.606766f,9.729086f,10.175982f,10.490002f,10.450778f,10.530566f,10.662402f,10.198713f,
        9.756838f,7.568992f,7.395587f,10.386068f
    },
    {
        12.338935f,11.958341f,7.484207f,8.228665f,11.650372f,11.382147f,12.027068f,11.762714f,
        11.266207f,12.095256f,12.402075f,12.538692f,12.335326f,12.212730f,12.551470f,12.419568f,
        11.941353f,12.565509f,12.164819f,12.121121f
    },
    {
        11.530771f,10.926392f,10.037753f,7.947472f,8.046108f,7.827244f,7.274969f,9.599776f,
        10.971369f,9.563985f,10.664629f,11.255960f,10.737041f,11.198854f,11.004945f,11.547729f,
        11.150601f,11.446258f,11.272099f,11.224279f
    },
    {
        12.154252f,12.426224f,12.362570f,12.276526f,11.848105f,12.233492f,12.238678f,11.606319f,
        11.630966f,8.226843f,8.663989f,12.324718f,11.910058f,11.977910f,11.282999f,11.276901f,
        12.135061f,12.316558f,12.126414f,12.222776f
    },
    {
        10.840468f,10.882261f,10.935246f,10.880699f,11.083740f,11.099067f,10.870871f,10.768135f,
        10.532293f,10.338410f,9.085450f,8.402101f,7.755022f,9.959888f,10.061506f,10.644034f,
        10.614702f,10.481884f,10.760615f,11.004514f
    },
    {
        12.122748f,12.306721f,11.587852f,12.430750f,12.175253f,11.815797f,12.308073f,12.320755f,
        12.218995f,12.463879f,12.424328f,12.559034f,12.042230f,11.765315f,8.922847f,9.539627f,
        7.874360f,8.521064f,9.272277f,12.165272f
    },
    {
        12.485865f,11.205798f,11.664264f,10.653128f,7.610178f,8.947474f,11.966330f,12.100983f,
        12.107791f,11.909583f,11.112039f,12.535769f,12.489249f,12.444782f,12.346417f,12.296227f,
        12.534035f,12.334972f,12.077379f,12.275601f
    },
    {
        12.425206f,12.450086f,12.341137f,12.568719f,12.320243f,12.361140f,12.099853f,11.035367f,
        8.319082f,12.032015f,12.280725f,11.606254f,12.321961f,11.066000f,11.799191f,12.266534f,
        12.556672f,12.545979f,12.602019f,12.030170f
    },
    {
        8.871724f,11.287228f,11.532060f,10.621922f,11.143099f,10.988887f,10.820709f,11.695601f,
        10.989671f,11.008445f,11.567303f,11.250048f,11.122625f,9.865336f,9.707122f,11.365924f,
        11.399251f,11.287416f,8.975295f,9.569743f
    },
    {
        9.780970f,11.908114f,11.473997f,12.024678f,11.860840f,11.723680f,12.367899f,12.108915f,
        12.340000f,12.381660f,12.315555f,12.282724f,12.359691f,11.991398f,12.220946f,12.155458f,
        12.413619f,11.642963f,7.867479f,8.503173f
    },
    {
        12.100057f,12.246774f,12.168076f,11.771790f,10.224229f,8.752139f,8.276130f,8.317601f,
        8.677964f,10.925248f,11.599258f,10.861567f,11.187905f,11.979478f,12.035626f,12.058556f,
        12.150581f,12.192816f,12.171208f,12.225122f
    },
    {
        12.205771f,12.205347f,12.351176f,12.237871f,12.382323f,12.461397f,12.301606f,12.369697f,
        11.959662f,11.558475f,10.953750f,8.388442f,8.819866f,12.077829f,11.983337f,11.818386f,
        12.286803f,12.458479f,12.329653f,12.507854f
    },
    {
        11.530513f,11.199886f,12.487312f,12.406390f,12.054689f,12.255518f,12.097314f,12.346512f,
        12.310920f,11.682766f,12.332119f,12.015944f,11.992967f,11.917038f,7.877818f,9.167294f,
        12.226696f,11.735081f,12.256387f,11.444395f
    },
    {
        12.132508f,12.328980f,11.918468f,12.068428f,12.493188f,12.275755f,12.524507f,12.294735f,
        12.582710f,12.488275f,12.132201f,12.076183f,12.373331f,11.888222f,11.716764f,10.961454f,
        8.318602f,11.632863f,12.609443f,11.484080f
    },
    {
        11.948422f,12.164044f,11.930634f,7.560744f,9.486037f,12.354504f,11.826571f,11.874330f,
        10.939306f,10.727631f,12.333044f,12.133337f,12.172671f,12.228312f,12.004416f,12.354714f,
        12.154241f,11.830939f,12.245022f,12.033812f
    },
    {
        12.494522f,12.883386f,12.105121f,12.216132f,12.821167f,10.613010f,12.572326f,12.881424f,
        11.754890f,12.876678f,12.439420f,12.258423f,12.945374f,12.765532f,12.874741f,12.539070f,
        12.711823f,12.611643f,11.904738f,12.176199f
    }
};
/*-------------------------------------------------------------------*
 * FD CNG
 *-------------------------------------------------------------------*/

const int   d_array[18] = { 1, 2, 5, 8, 10, 15, 20, 30, 40, 60, 80, 120, 140, 160, 180, 220, 260, 300 };
const float m_array[18] = { 0.000f, 0.260f, 0.480f, 0.580f, 0.610f, 0.668f, 0.705f, 0.762f, 0.800f, 0.841f, 0.865f, 0.890f, 0.900f, 0.910f, 0.920f, 0.930f, 0.935f, 0.940f };

const float msQeqInvAv_thresh[3] = { 0.01f, 0.03f, 0.05f };
const float msNoiseSlopeMax[4]   = { 2.f, 1.6f, 1.3f, 1.1f };

const SCALE_SETUP scaleTable[20] =
{
    { 0,     0,  8000, -5.5f },
    { 0,  8000,  9600, -5.0f },
    { 0,  9600, 13200, -4.0f },
    { 0, 13200, 16400, -3.0f },
    { 0, 16400, 24400, -1.5f },
    { 0, 24400,128000, -0.5f },

    { 1,     0,  8000, -5.5f },
    { 1,  8000,  9600, -5.0f },

    { 1,  9600, 13200, -1.55f},
    { 1, 13200, 16400, -3.0f },

    { 1, 16400, 24400, -0.6f },
    { 1, 24400, 64000, -0.2f },
    { 1, 32000,128000,  0.0f },


    { 2,     0,  8000, -0.9f },
    { 2,  8000,  9600, -0.65f},
    { 2,  9600, 13200, -2.0f },
    { 2, 13200, 16400, -3.0f },

    { 2, 16400, 24400, -0.8f },
    { 2, 24400, 32000, -0.25f},
    { 2, 32000,128000,  0.0f },
};

const SCALE_SETUP scaleTable_cn_only[18] =
{
    { 0,     0,  8000, -3.5f },
    { 0,  8000,  9600, -3.0f },
    { 0,  9600, 13200, -2.5f },
    { 0, 13200,16400, -2.0f },
    { 0, 16400,128001, 0.0f },

    { 1,     0,  8000, -3.0f },
    { 1,  8000,  9600, -2.5f },
    { 1,  9600, 13200, -1.5f },
    { 1, 13200, 16400, -2.5f },
    { 1, 16400, 24400, -0.5f },
    { 1, 24400, 128001,  0.0f },

    { 2,     0,  8000, -2.5f },
    { 2,  8000,  9600, -2.5f },
    { 2,  9600, 13200, -2.0f },
    { 2, 13200, 16400, -1.0f },

    { 2, 16400, 24400, -0.5f },
    { 2, 24400, 32000,  0.0f },
    { 2, 32000,128001,  0.0f },
};
const float scaleTable_cn_only_amrwbio[3][2] =
{
    { ACELP_6k60, -4.0f },
    { ACELP_8k85, -3.0f },
    { ACELP_12k65, -2.0f },
};


const int sidparts_encoder_noise_est[24] = { 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 58, 68, 80, 92, 108, 126, 148, 176, 212, 255, 259, 264, 269, 279 };

const int sidPartitions_nb[]   = { 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 58, 68, 80, 92, 108, 126, 159 };
const int sidPartitions_wb1[]  = { 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 58, 68, 80, 92, 108, 126, 148, 176, 212, 255 };
const int sidPartitions_wb2[]  = { 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 58, 68, 80, 92, 108, 126, 148, 176, 212, 255, 259 };
const int sidPartitions_wb3[]  = { 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 58, 68, 80, 92, 108, 126, 148, 176, 212, 255, 319 };
const int sidPartitions_swb1[] = { 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 58, 68, 80, 92, 108, 126, 148, 176, 212, 255, 259, 264, 269, 274 };
const int sidPartitions_swb2[] = { 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 58, 68, 80, 92, 108, 126, 148, 176, 212, 255, 319, 324, 329, 339 };

const int shapingPartitions_nb[]   = { 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 25, 28, 31, 34, 37, 40, 43, 47, 51, 55, 59, 64, 69, 74, 80, 86, 93, 100, 108, 117, 126, 136, 159 };
const int shapingPartitions_wb1[]  = { 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 25, 28, 31, 34, 37, 40, 43, 47, 51, 55, 59, 64, 69, 74, 80, 86, 93, 100, 108, 117, 126, 135, 148, 162, 176, 192, 212, 232, 255 };
const int shapingPartitions_wb2[]  = { 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 25, 28, 31, 34, 37, 40, 43, 47, 51, 55, 59, 64, 69, 74, 80, 86, 93, 100, 108, 117, 126, 135, 148, 162, 176, 192, 212, 232, 255 };
const int shapingPartitions_wb3[]  = { 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 25, 28, 31, 34, 37, 40, 43, 47, 51, 55, 59, 64, 69, 74, 80, 86, 93, 100, 108, 117, 126, 136, 148, 176, 212, 256, 308, 319 };
const int shapingPartitions_swb1[] = { 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 25, 28, 31, 34, 37, 40, 43, 47, 51, 55, 59, 64, 69, 74, 80, 86, 93, 100, 108, 117, 126, 135, 148, 162, 176, 192, 212, 232, 255 };
const int shapingPartitions_swb2[] = { 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 25, 28, 31, 34, 37, 40, 43, 47, 51, 55, 59, 64, 69, 74, 80, 86, 93, 100, 108, 117, 126, 136, 148, 176, 212, 256, 308, 319 };

const FD_CNG_SETUP FdCngSetup_nb   = { 512, 160,   sizeof(sidPartitions_nb)/sizeof(int),   sidPartitions_nb,   sizeof(shapingPartitions_nb)/sizeof(int),   shapingPartitions_nb };
const FD_CNG_SETUP FdCngSetup_wb1  = { 512, 256,  sizeof(sidPartitions_wb1)/sizeof(int),  sidPartitions_wb1,  sizeof(shapingPartitions_wb1)/sizeof(int),  shapingPartitions_wb1 };
const FD_CNG_SETUP FdCngSetup_wb2  = { 512, 256,  sizeof(sidPartitions_wb2)/sizeof(int),  sidPartitions_wb2,  sizeof(shapingPartitions_wb2)/sizeof(int),  shapingPartitions_wb2 };
const FD_CNG_SETUP FdCngSetup_wb3  = { 640, 320,  sizeof(sidPartitions_wb3)/sizeof(int),  sidPartitions_wb3,  sizeof(shapingPartitions_wb3)/sizeof(int),  shapingPartitions_wb3 };
const FD_CNG_SETUP FdCngSetup_swb1 = { 512, 256, sizeof(sidPartitions_swb1)/sizeof(int), sidPartitions_swb1, sizeof(shapingPartitions_swb1)/sizeof(int), shapingPartitions_swb1 };
const FD_CNG_SETUP FdCngSetup_swb2 = { 640, 320, sizeof(sidPartitions_swb2)/sizeof(int), sidPartitions_swb2, sizeof(shapingPartitions_swb2)/sizeof(int), shapingPartitions_swb2 };


const short maxN_37bits = 24;
const short maxC_37bits = 8;
const short stages_37bits = 6;
const int   levels_37bits[6] = { 128, 64, 64, 64, 64, 64 };
const short bits_37bits[6] = { 7, 6, 6, 6, 6, 6 };

const float cdk_37bits_1[3072] =
{
    2.95778982f , 10.56049102f , 13.09386355f , 11.08385962f , 10.88871781f , 10.92789554f , 9.47024852f , 7.50377851f , 7.19700973f , 4.42757028f , 1.25511814f , -2.60106001f , -6.04950165f , -7.63603604f , -10.41446639f , -11.12590625f , -13.84344441f , -18.68891181f , -23.55780389f , -29.45805147f , -31.65253302f , -32.27424892f , -35.22751137f , -36.90949842f ,
    17.21398978f , 22.50723507f , 17.78339684f , 15.22053850f , 11.61821405f , 7.94613723f , 7.75072026f , 6.23305331f , 5.76430087f , 4.13707869f , 0.16499081f , -2.39493762f , -1.55086212f , -3.50433708f , -8.18443711f , -11.97061123f , -16.00947999f , -20.53183145f , -25.24387497f , -29.42436369f , -32.38843392f , -36.11523183f , -39.31249120f , -40.92553153f ,
    16.16413908f , 12.51338319f , 10.81668845f , 7.51107282f , 8.58783122f , 9.70942586f , 8.90484747f , 7.74361213f , 8.38927229f , 6.09180806f , 2.25606211f , -1.80804139f , -5.77866789f , -6.64266134f , -10.11888694f , -12.07031815f , -15.26437992f , -20.26969656f , -25.12160881f , -31.11024903f , -33.35847205f , -33.13640725f , -35.95124987f , -37.90657962f ,
    33.31978298f , 27.26394617f , 24.25514764f , 20.23232332f , 16.65548737f , 15.67786748f , 13.12878045f , 12.68415364f , 8.46975797f , 6.86052690f , 1.44223072f , -3.05984201f , -6.92484285f , -10.16404365f , -13.70298321f , -18.48343165f , -22.58372752f , -26.62074680f , -30.39592772f , -34.37439216f , -36.06769058f , -38.82086191f , -40.35157222f , -41.14327920f ,
    -10.92203045f , 3.01052036f , 7.74241345f , 9.28295437f , 6.38021756f , 11.19483089f , 9.71179193f , 7.58317778f , 0.03720981f , 2.75397106f , -1.50772774f , -2.01443682f , -2.44887133f , -6.15187538f , -8.81821668f , -8.69151269f , -8.02852922f , -11.09910056f , -13.17097763f , -13.93076356f , -13.66079044f , -16.47777711f , -18.46333278f , -20.06869553f ,
    33.16037159f , 28.50574364f , 18.84668394f , 16.14503275f , 12.64238398f , 8.82733160f , 8.27164568f , 6.62567905f , 6.59003037f , 4.47312530f , 0.90824775f , -2.49975515f , -1.08141480f , -3.20431000f , -9.25248952f , -13.89338354f , -18.40719472f , -22.60361057f , -27.04357211f , -31.31499557f , -33.93185338f , -37.43894780f , -40.22405388f , -41.64367850f ,
    27.31804653f , 14.89045549f , 10.86226202f , 8.23925819f , 7.20277478f , 6.05860544f , 5.52091762f , 4.91558992f , 4.25466169f , 3.41244595f , 1.84809938f , 0.56793582f , -2.09446303f , -5.61345827f , -7.92063692f , -8.33385890f , -9.81872455f , -14.00821261f , -17.95712781f , -19.97458899f , -22.84515408f , -26.34052831f , -31.61432841f , -36.58172847f ,
    41.62594036f , 30.53353379f , 27.89510180f , 24.11265594f , 18.43485443f , 15.64729005f , 13.50845997f , 10.26280433f , 8.91720676f , 5.83154831f , 0.58848737f , -2.93497066f , -7.66347118f , -10.65504548f , -14.43162023f , -17.54532056f , -19.96025099f , -21.34714524f , -24.14933678f , -25.76118364f , -25.95869147f , -27.17577493f , -27.71455668f , -28.20012422f ,
    -2.78784194f , 8.02032552f , 10.68963597f , 6.42169471f , 8.39643500f , 5.92698403f , 3.72431779f , 2.34240994f , 2.84441568f , 2.28173308f , 0.51005528f , -0.63277332f , -1.88760888f , -3.64699895f , -6.19490118f , -6.91564436f , -6.74837856f , -9.01957311f , -13.08326862f , -15.61846381f , -17.51686622f , -20.98788704f , -24.84189318f , -27.88764499f ,
    15.22736138f , 21.67028596f , 22.69998521f , 19.32303652f , 16.57824995f , 14.43971050f , 12.86116984f , 12.06004138f , 8.96691160f , 5.75441483f , 0.69857059f , -2.99592995f , -6.37751956f , -10.52101418f , -13.54087476f , -17.17818777f , -20.74546985f , -23.38284886f , -27.16166346f , -32.39741856f , -34.96265685f , -38.29574314f , -40.21463793f , -40.97396233f ,
    9.26133859f , 10.07373727f , 10.66915549f , 8.57462295f , 7.07983445f , 6.08004124f , 5.43616008f , 4.66385278f , 4.13923283f , 3.46291473f , 2.00919193f , 0.41431808f , -2.15659988f , -5.73419766f , -7.77729962f , -8.10963302f , -9.50797759f , -13.76609560f , -17.88454433f , -20.18355620f , -22.78079775f , -26.25300986f , -31.65196065f , -36.72266405f ,
    26.92737845f , 27.50669000f , 26.91247977f , 21.31279552f , 16.15678270f , 12.72639800f , 8.67528477f , 8.63540827f , 6.12171634f , 5.39466263f , 2.40935018f , -2.03514541f , -5.98268282f , -9.33268447f , -11.64966136f , -14.87079782f , -16.24856435f , -18.12429449f , -20.78266693f , -23.71237445f , -24.73440188f , -27.34821266f , -28.25918906f , -28.93790683f ,
    4.90379335f , 9.93686137f , 10.91780723f , 9.09752074f , 8.60650951f , 8.80459898f , 8.14900070f , 8.09228751f , 4.14934489f , 1.56227390f , 0.22948186f , -2.11175133f , -3.74247153f , -6.07379086f , -7.30507236f , -9.28287821f , -11.07748811f , -12.71211521f , -13.84649241f , -14.34403824f , -15.35123200f , -17.12232100f , -20.33875194f , -23.90062854f ,
    34.56400510f , 28.64513545f , 19.89686686f , 16.71498339f , 14.13374646f , 9.59301176f , 8.64527668f , 7.89097544f , 7.45460471f , 4.94035649f , 1.12449009f , -1.91803209f , -2.36876539f , -4.85907115f , -10.96920929f , -15.11783181f , -18.54964139f , -22.92691742f , -27.54026485f , -32.37334407f , -34.34801279f , -37.11646404f , -38.85197445f , -40.08034397f ,
    21.85246210f , 14.72764339f , 11.27302628f , 9.14638512f , 8.54804115f , 8.77093797f , 8.12903725f , 8.26861602f , 4.19886932f , 1.54799726f , 0.20257140f , -1.95701999f , -3.69888430f , -6.13502639f , -7.32329151f , -9.38507779f , -11.16665977f , -12.74666897f , -13.89635990f , -14.42352149f , -15.69403582f , -17.31656047f , -20.46657786f , -24.00174177f ,
    42.72694479f , 31.23947048f , 24.43494280f , 19.72208465f , 15.30350682f , 10.47491489f , 7.32088994f , 10.21936673f , 9.85497717f , 5.26501746f , 1.65994049f , -1.03290160f , -4.60874619f , -8.54769573f , -14.17151340f , -15.71521704f , -16.02262568f , -18.90844987f , -24.28632557f , -26.72718508f , -27.02265332f , -28.78362362f , -30.43253072f , -32.28558858f ,
    -0.39765072f , 7.11128294f , 8.77607625f , 6.97094061f , 6.49768999f , 5.29876062f , 5.33292418f , 5.12420845f , 5.06120539f , 3.76514540f , 1.86852875f , 0.36828311f , -2.70182085f , -4.67846439f , -6.65927858f , -8.64219681f , -10.63500087f , -13.14101813f , -15.41381490f , -18.10176174f , -22.39767659f , -26.30065166f , -30.06922086f , -34.02575582f ,
    24.65122317f , 23.93886440f , 24.33639262f , 20.20634124f , 14.95533543f , 10.67440066f , 7.90685648f , 7.77227130f , 4.69229603f , 3.94984243f , 1.03135714f , -2.78561381f , -5.59708858f , -8.11252879f , -10.03836955f , -12.17557001f , -12.27299654f , -12.23090635f , -14.81077879f , -18.41474220f , -21.95921345f , -26.31237335f , -28.83347746f , -30.57799152f ,
    15.48674375f , 10.58586035f , 8.41258222f , 6.11115928f , 7.26712645f , 7.70076576f , 6.51745234f , 4.83537618f , 3.78315908f , 2.87162280f , 1.60923393f , 0.07194700f , -4.00474978f , -3.57899280f , -6.50550572f , -8.00337288f , -12.56429875f , -16.64572160f , -21.77660604f , -29.00324770f , -29.28924218f , -28.45842093f , -31.46000362f , -33.72961920f ,
    31.66756941f , 26.50681469f , 23.07696706f , 19.47940753f , 16.43776948f , 14.65422928f , 13.13762571f , 12.13565647f , 9.05541090f , 5.85409354f , 0.53053075f , -3.03585502f , -6.54517878f , -10.70179318f , -13.64861349f , -17.10229453f , -20.77152138f , -23.04102596f , -26.76284884f , -32.09288570f , -34.95454717f , -38.37953105f , -40.31456890f , -41.06305403f ,
    -4.57998646f , 6.78815016f , 11.60677893f , 12.12189632f , 10.03649399f , 6.73163226f , 5.60997256f , 3.61382681f , 1.07119505f , 1.44124760f , -0.36649688f , -1.93594310f , -2.67098539f , -3.97236341f , -4.49309238f , -7.67841048f , -7.38721745f , -9.04687595f , -10.64729812f , -12.35782845f , -15.80889240f , -18.10394377f , -20.75255913f , -23.16714596f ,
    32.06565538f , 26.34062469f , 17.62317465f , 14.54318257f , 11.33965592f , 7.22380894f , 6.69999570f , 5.16548324f , 5.32078994f , 3.68894995f , 0.21139809f , -1.89643313f , -1.43729232f , -3.38299704f , -8.16315990f , -10.90725548f , -13.86285241f , -19.27930679f , -24.24221687f , -29.37957484f , -32.97371289f , -37.01956565f , -40.64301363f , -42.42283871f ,
    27.34861464f , 17.35254831f , 14.71216625f , 11.21480476f , 9.71751794f , 8.92216110f , 7.88950008f , 4.72051984f , 2.08541644f , 1.24484417f , -0.29448212f , -3.22367745f , -4.12078688f , -4.51431029f , -5.02457729f , -7.46382757f , -9.93828200f , -11.94075167f , -14.42548881f , -16.83893529f , -20.57517980f , -23.86145012f , -26.35488436f , -28.09220448f ,
    43.77568289f , 30.35391726f , 27.63839793f , 23.39292280f , 18.14120263f , 16.09279111f , 13.38540751f , 10.06671431f , 7.94669649f , 4.12623028f , -0.90332148f , -3.32951717f , -7.24035516f , -10.01970377f , -13.39421641f , -16.33052649f , -18.54117920f , -19.77745925f , -22.77363614f , -24.12093907f , -24.21920369f , -25.28960607f , -25.77614399f , -26.25683024f ,
    5.79368652f , 12.51991626f , 14.00370768f , 11.32137999f , 9.77109082f , 8.98151357f , 7.49776119f , 4.79998026f , 2.33448317f , 1.18610607f , -0.35969383f , -2.93257557f , -4.07562790f , -4.76160858f , -5.42531466f , -7.40360649f , -9.61250822f , -11.03547938f , -13.14054419f , -15.06085658f , -17.47288279f , -20.42082642f , -22.95063518f , -25.16468847f ,
    16.09302292f , 22.55335432f , 23.75600812f , 20.07565839f , 16.86390794f , 15.22041485f , 13.34925505f , 12.47627523f , 8.78929960f , 6.22941075f , 0.65362548f , -3.19021243f , -6.62717988f , -10.64596960f , -13.82088718f , -17.58372103f , -21.71419292f , -24.30895894f , -26.77314588f , -28.87032013f , -30.13179973f , -31.71459259f , -32.84856396f , -33.50577477f ,
    16.44441330f , 12.31360615f , 9.71047235f , 7.21837937f , 6.79215980f , 5.58913206f , 5.23450348f , 5.31837117f , 5.47119664f , 3.91860558f , 2.00713858f , 0.29754081f , -2.62407946f , -4.75220497f , -6.96490868f , -9.09693835f , -11.19050998f , -13.60732328f , -15.96794842f , -18.87093112f , -23.15019536f , -27.14449468f , -31.05584505f , -35.00208930f ,
    21.56078764f , 25.60904841f , 27.31524375f , 24.74664217f , 19.15754045f , 16.48262030f , 13.62284337f , 10.32185769f , 7.82788054f , 4.56867787f , -0.55500429f , -3.54399244f , -7.74464129f , -10.04653026f , -13.91638701f , -16.89276027f , -19.28210045f , -21.11725885f , -23.80905063f , -25.61468851f , -25.54369860f , -26.75644280f , -27.40565527f , -27.80349551f ,
    11.75649526f , 11.59267300f , 11.85607639f , 12.09984636f , 10.17904946f , 6.68242306f , 5.49769393f , 3.62565532f , 1.04153359f , 1.37348105f , -0.36614776f , -1.85988088f , -2.65180489f , -3.95188781f , -4.54582064f , -7.65185164f , -7.37260518f , -8.94498668f , -10.57379044f , -12.29831281f , -15.91573373f , -18.15620068f , -20.77255846f , -23.17991063f ,
    35.63174061f , 30.87426279f , 20.05864161f , 16.98958650f , 13.11156738f , 9.37587068f , 8.39373792f , 6.91457513f , 7.06726843f , 4.45504564f , 0.31410924f , -2.55476072f , -1.55052341f , -3.58183174f , -10.02850753f , -13.83773408f , -18.07893844f , -21.87127412f , -26.40618053f , -30.05923316f , -32.16211735f , -34.97392895f , -36.96538585f , -38.31916152f ,
    22.45827967f , 18.85001245f , 13.60039332f , 10.10815816f , 9.34790218f , 6.59206524f , 5.06185868f , 4.27885917f , 3.12432252f , 2.43301895f , 0.16458112f , -0.87956151f , -3.52884867f , -4.30776590f , -5.96584396f , -7.24696688f , -9.07355786f , -10.64880142f , -12.04156041f , -13.57831230f , -16.13223545f , -19.28691238f , -20.73379126f , -22.35985284f ,
    45.50285910f , 30.56079275f , 25.12585245f , 19.34243209f , 14.67812492f , 11.09479624f , 7.62809337f , 7.36329508f , 5.02791068f , 4.57220923f , 1.95015079f , -1.57507512f , -5.20307171f , -7.99911947f , -9.95812261f , -13.13787688f , -14.44121237f , -16.19333355f , -19.15028237f , -22.75607672f , -25.37417688f , -27.76304019f , -28.42538941f , -29.09271083f ,
    -0.20862409f , 7.40922209f , 9.52611206f , 7.19556599f , 8.56285670f , 9.23113851f , 8.29119614f , 6.74033461f , 7.39436505f , 4.76996743f , 1.52467647f , -2.37784656f , -6.09813737f , -6.29918182f , -8.30626415f , -10.26550962f , -13.16761101f , -17.25290821f , -21.82832704f , -28.08208094f , -29.69995762f , -30.02997066f , -32.54067640f , -34.86791052f ,
    20.15336204f , 23.69787743f , 20.03743258f , 17.32388877f , 13.85816349f , 9.75929930f , 8.81062377f , 7.33399060f , 7.03590133f , 4.83049697f , 0.70944621f , -2.33770508f , -2.40423376f , -4.83395025f , -10.23084612f , -14.36365636f , -18.16750414f , -21.75786888f , -26.07319165f , -30.47064791f , -32.03827614f , -34.62324863f , -36.38403786f , -37.62380175f ,
    21.02807550f , 15.43123168f , 13.19159292f , 11.05909310f , 9.93532083f , 10.14330557f , 8.44788836f , 7.05092375f , 6.65547179f , 3.80156734f , 1.01028469f , -2.51036572f , -5.52907299f , -7.16917980f , -9.69618129f , -9.79583611f , -12.34407663f , -16.35321338f , -21.00738251f , -27.34102498f , -30.48319293f , -30.90104975f , -33.93924526f , -35.92883268f ,
    33.46103317f , 28.05909534f , 25.27576527f , 21.45366856f , 18.39016725f , 16.16268691f , 14.43168731f , 12.88073327f , 9.27668693f , 6.28692861f , 0.27771848f , -3.24264663f , -7.02703161f , -11.49310707f , -14.63223263f , -18.01065380f , -23.30098657f , -26.04536683f , -29.97889152f , -33.31061266f , -34.90527704f , -37.51005914f , -38.89607504f , -39.43668242f ,
    -6.19448103f , 7.00670386f , 6.42929262f , 11.44842292f , 10.59782711f , 3.51908910f , 5.03700693f , 11.99440282f , 2.46784279f , 2.52636549f , 0.19509676f , -0.66292825f , -3.57724994f , -4.27935354f , -7.71003982f , -9.31027578f , -10.79777387f , -12.03284160f , -14.50955075f , -15.24259860f , -15.04293408f , -17.84913152f , -19.24800026f , -20.43127990f ,
    34.36219386f , 29.15654122f , 17.89907772f , 15.96853719f , 12.24737290f , 8.58997407f , 8.02028124f , 6.73852407f , 6.68229615f , 4.41515543f , 0.31647818f , -2.71422396f , -1.11008623f , -3.15418403f , -8.78373906f , -13.46164937f , -17.78623382f , -22.03141049f , -26.52011865f , -30.42263732f , -32.88924845f , -36.52063092f , -39.44879402f , -41.00582791f ,
    28.59389870f , 16.57976885f , 11.69506951f , 9.00946677f , 6.59434708f , 5.58892350f , 5.15576244f , 4.26874238f , 3.83962965f , 3.10490992f , 1.74950191f , 0.21359494f , -2.34614415f , -5.90830965f , -7.32978245f , -6.79210755f , -8.13921426f , -12.39307835f , -16.42105838f , -17.81533132f , -20.43309456f , -23.50336304f , -28.11010949f , -32.19800165f ,
    42.18709382f , 31.66042119f , 28.18576191f , 24.02454209f , 17.80243401f , 14.32604318f , 12.38219020f , 9.68299766f , 9.84153789f , 7.22418488f , 1.90320264f , -0.79109427f , -7.30502888f , -10.99217358f , -15.03902326f , -18.25651222f , -20.77870269f , -22.27969332f , -25.21134893f , -26.73864852f , -26.81597564f , -28.06561283f , -28.74871236f , -29.19027505f ,
    3.14453423f , 9.82704694f , 10.42102234f , 7.53076819f , 6.65445918f , 5.42078795f , 4.35248487f , 3.38200688f , 3.34653224f , 2.23758939f , 0.98007038f , -0.82512415f , -3.06552968f , -3.74092446f , -5.19946109f , -6.26762478f , -7.27519640f , -9.56355666f , -11.49652218f , -12.93977382f , -15.16570550f , -17.89500321f , -20.88144101f , -24.27090982f ,
    16.89397941f , 22.41751392f , 23.75354684f , 20.15652247f , 16.71460178f , 15.68435339f , 13.05195327f , 12.59734003f , 8.36320984f , 6.61926140f , 1.34089883f , -3.04095047f , -6.87072914f , -10.11874127f , -13.60230073f , -18.32905014f , -22.40986754f , -26.40241648f , -30.22653356f , -34.35524827f , -35.82875887f , -38.56697745f , -40.04466299f , -40.77890542f ,
    14.06040489f , 12.38456984f , 11.38443857f , 6.43429982f , 8.36024783f , 5.74773204f , 3.64617779f , 2.27891511f , 2.88575114f , 2.28853033f , 0.47176709f , -0.58104559f , -1.80751192f , -3.57542575f , -6.25556579f , -6.84838146f , -6.61115232f , -8.86429480f , -13.12243997f , -15.53130507f , -17.39294606f , -20.82817234f , -24.80352676f , -27.90102832f ,
    29.08127657f , 30.25267470f , 28.50445786f , 22.88590940f , 16.95382919f , 12.99666306f , 9.24548766f , 10.17354633f , 7.44385880f , 5.98968070f , 1.98160871f , -1.99320988f , -6.45502374f , -10.08296200f , -12.58332338f , -15.94023376f , -17.72993147f , -19.46222023f , -22.64433239f , -25.73538061f , -25.10103202f , -27.34115443f , -28.00719352f , -28.71283003f ,
    10.44191657f , 11.89739900f , 6.63050752f , 11.66862838f , 10.95389970f , 3.62853936f , 5.27338772f , 12.22397146f , 2.38303236f , 2.27598761f , 0.20057759f , -0.69953882f , -3.74592500f , -4.11363308f , -7.73279200f , -9.56396050f , -11.08358715f , -12.21155490f , -14.86254610f , -15.45527754f , -15.28325702f , -17.98672312f , -19.17774681f , -20.23644212f ,
    35.53276331f , 29.79176377f , 19.61709874f , 16.86634001f , 13.09981576f , 9.35098387f , 8.47743299f , 7.04997634f , 7.03070014f , 4.96729480f , 0.92976195f , -2.31151272f , -1.83127970f , -4.34635324f , -9.67542557f , -14.26377116f , -18.47764765f , -22.80532113f , -27.40873215f , -31.63558241f , -33.75926234f , -36.57926085f , -38.64751733f , -39.92187198f ,
    19.57623370f , 14.52227951f , 10.90006748f , 7.46479458f , 6.57710504f , 5.35248052f , 4.32022732f , 3.44261943f , 3.11088406f , 2.14252838f , 0.91565155f , -0.88167185f , -3.01132437f , -3.66994851f , -5.19376018f , -6.09616750f , -7.00842420f , -9.47621384f , -11.55078876f , -12.93214130f , -15.11703243f , -17.74349778f , -20.81631949f , -24.26610975f ,
    45.46539087f , 33.65225910f , 27.04759024f , 20.37287228f , 15.20605258f , 10.95754596f , 8.25353280f , 10.41134779f , 9.16332898f , 5.00593619f , 1.56893245f , -0.96934543f , -4.76115225f , -9.35265480f , -13.96830603f , -15.58493281f , -15.93026458f , -18.72056170f , -22.62999991f , -24.01724401f , -24.13966976f , -25.75662986f , -27.30657872f , -29.31976842f ,
    3.35383892f , 10.46089277f , 12.67572651f , 10.67316057f , 8.86420657f , 7.41699857f , 6.40472576f , 5.55584594f , 4.78140149f , 3.39101090f , 1.64891901f , -0.88431535f , -3.41794053f , -5.52966105f , -7.12950981f , -9.73843277f , -11.36318390f , -12.90076410f , -15.02653519f , -17.80793193f , -20.85950171f , -24.60915288f , -28.33117068f , -31.97961671f ,
    24.16381226f , 26.61189391f , 24.86498593f , 19.87730202f , 15.18991454f , 10.98879994f , 7.42531150f , 10.49136744f , 9.62334804f , 4.97806393f , 1.38953872f , -1.07543238f , -4.87438861f , -8.84994346f , -14.12865608f , -15.38136709f , -15.77648418f , -18.65254160f , -24.07064465f , -26.65375941f , -26.62799211f , -28.37449714f , -30.00703668f , -31.95561063f ,
    16.73297197f , 13.40079340f , 11.36295685f , 8.12888004f , 8.67057438f , 9.98791316f , 7.17503401f , 3.41805962f , 3.84708100f , 3.38229324f , 1.69308513f , -2.44779633f , -7.15056120f , -5.22964233f , -5.71002448f , -7.24979808f , -10.38621901f , -12.40506839f , -16.88434384f , -24.40525376f , -27.96468183f , -28.87188624f , -31.73758135f , -34.45997553f ,
    36.82320664f , 30.14889839f , 24.36495733f , 19.95821910f , 17.28215670f , 15.34405446f , 12.71014649f , 11.84061146f , 8.74552404f , 5.19431776f , 0.62656711f , -3.30567052f , -7.09245555f , -11.63075940f , -14.43930927f , -16.55893715f , -18.71623060f , -21.39863923f , -24.41215684f , -27.71989721f , -29.44073312f , -31.13601153f , -33.00550113f , -35.01755294f ,
    -0.75323250f , -0.49333543f , -0.03686038f , 0.00580498f , -0.02595636f , -0.42521553f , -0.11620129f , 0.04925008f , -0.22349130f , -0.41036697f , -0.08797780f , -0.31029326f , -0.33370732f , -0.04414976f , -0.18188899f , -0.39067975f , -0.19015430f , -0.13924769f , -0.07489774f , -0.24338076f , 0.02616867f , -0.90654191f , -0.36674078f , -0.92659945f ,
    32.82257425f , 26.93225108f , 17.97275820f , 15.52062575f , 12.24580971f , 7.87298134f , 7.92790101f , 6.69153001f , 6.20377725f , 4.87524910f , 0.20987746f , -2.32068931f , -1.19022086f , -3.62043573f , -8.66527100f , -13.17653707f , -17.05395098f , -21.30672374f , -26.02442938f , -29.84148775f , -32.77866358f , -36.44067731f , -39.64793075f , -41.28669431f ,
    23.66104031f , 18.77341211f , 15.43023272f , 11.20366406f , 8.42366176f , 6.11675293f , 5.33405011f , 5.20406381f , 4.67626106f , 3.65065286f , 1.53469689f , -1.60771292f , -3.81129242f , -4.57130038f , -6.33850722f , -8.60971199f , -10.00167377f , -11.97538710f , -14.16507562f , -16.60464075f , -19.14351164f , -22.49496272f , -25.49215425f , -28.47836779f ,
    48.83791360f , 34.21172740f , 28.24854170f , 23.78581370f , 19.15275096f , 16.36583739f , 13.52652252f , 12.00825971f , 7.58820783f , 4.57182675f , -0.44096755f , -5.59444127f , -9.20335237f , -11.60423121f , -13.38376584f , -15.82699559f , -17.15943218f , -18.22349154f , -21.00159236f , -23.41802307f , -24.09185136f , -26.12025700f , -26.38389340f , -26.90015217f ,
    5.65030538f , 13.78536254f , 12.93384260f , 10.10554338f , 9.25200312f , 6.70079894f , 4.97946459f , 4.14010675f , 3.20266413f , 2.24703740f , 0.17096077f , -0.76854332f , -3.49746682f , -4.40509828f , -5.92984501f , -7.16813639f , -8.92390949f , -10.44235555f , -11.73970476f , -13.07525739f , -15.58860787f , -18.82754905f , -20.11226045f , -21.89670528f ,
    20.00764046f , 25.05163905f , 23.67903478f , 19.61532654f , 16.85580272f , 14.84943508f , 12.32422151f , 11.72685290f , 8.55557474f , 4.89724925f , 0.62350153f , -3.12200178f , -6.95129787f , -11.32051330f , -13.87728564f , -16.20738435f , -18.35417789f , -21.22501359f , -24.26412556f , -27.53754401f , -29.04562197f , -30.52655890f , -32.50623950f , -34.76405591f ,
    20.12464864f , 15.20430829f , 13.25055947f , 10.65904743f , 8.91134621f , 7.46363884f , 6.44402323f , 5.71195079f , 4.79807746f , 3.49335087f , 1.75260934f , -0.74115357f , -3.42285816f , -5.45747278f , -7.23479115f , -10.08709890f , -11.63154322f , -13.05708157f , -15.18339592f , -18.14822179f , -21.33849269f , -25.01926113f , -28.92560049f , -32.56657725f ,
    26.54656966f , 26.13227118f , 27.82488903f , 24.22335030f , 18.87683777f , 16.59425031f , 13.64047520f , 9.75915298f , 7.28698308f , 4.09515905f , -0.71835272f , -3.26926527f , -7.31384281f , -9.98624418f , -13.59589213f , -16.50790941f , -18.86147233f , -20.11404881f , -22.88197092f , -24.35845023f , -23.98592903f , -25.19061201f , -25.66357488f , -26.11120895f ,
    16.92428437f , 15.63926123f , 14.68264077f , 9.17511817f , 11.72199221f , 8.73358423f , 5.74525565f , 3.31019020f , 3.82744364f , 2.82061126f , 0.00479914f , -1.62974092f , -3.21227479f , -5.78430830f , -8.71508730f , -8.80926274f , -8.01316743f , -9.54120965f , -13.35104985f , -15.74348284f , -16.40121304f , -19.46521021f , -22.26957651f , -24.80475300f ,
    33.27372786f , 28.98123208f , 18.52554956f , 16.22324845f , 11.82428088f , 8.06497636f , 6.95248523f , 6.23909474f , 5.55428912f , 3.52189864f , 0.54297482f , -2.65061141f , -0.24235908f , -2.49418732f , -8.10730403f , -12.50952978f , -16.69612524f , -20.49938193f , -23.81401973f , -26.29697125f , -27.78204736f , -29.60465452f , -31.26624714f , -32.52437926f ,
    27.66207964f , 21.38029622f , 15.28817924f , 11.29865816f , 7.24050384f , 4.07114269f , 2.23434724f , 2.00312407f , 2.12063407f , 2.37092879f , 1.11181974f , -0.06676605f , -1.62128339f , -3.18849566f , -4.50247820f , -5.27330824f , -6.50012921f , -8.95962773f , -11.25753877f , -13.15591465f , -15.55510117f , -17.77008388f , -21.51057093f , -23.68928360f ,
    46.17063826f , 35.44350933f , 27.63882719f , 20.58749084f , 15.09358456f , 11.34450671f , 8.36303546f , 10.32329718f , 9.40828446f , 4.81846192f , 1.44590103f , -1.30265822f , -4.80681268f , -9.60995360f , -14.00088486f , -15.02315852f , -16.05368713f , -18.40913671f , -21.04455075f , -21.77101439f , -21.86714844f , -23.34699503f , -24.81999799f , -26.75598881f ,
    5.55447222f , 11.08900430f , 12.67418749f , 11.37730706f , 10.35233661f , 9.77194599f , 7.54804411f , 5.59512280f , 5.26611322f , 3.61130922f , 1.29867980f , -1.53794101f , -4.94548169f , -6.44099913f , -9.14750567f , -9.26394627f , -12.10780921f , -16.54821135f , -21.09601890f , -27.26975914f , -29.20341664f , -29.16031453f , -32.31338409f , -33.81412751f ,
    18.12507160f , 24.70366354f , 18.80553588f , 16.44619360f , 12.73212014f , 8.73243452f , 8.13965750f , 6.85564846f , 6.54211122f , 4.41684143f , 0.86730242f , -2.56492428f , -1.51931938f , -3.44405406f , -9.13992613f , -13.62181635f , -17.99613747f , -22.23637312f , -26.67002377f , -30.83211183f , -32.97908996f , -36.30619371f , -38.88768859f , -40.31682212f ,
    19.30313062f , 15.53926343f , 13.90808840f , 11.50585735f , 11.38433252f , 11.23569306f , 9.65078250f , 7.30888386f , 6.96318572f , 4.35594359f , 1.27768650f , -2.51618855f , -6.09345175f , -7.65932096f , -10.43421302f , -11.30754584f , -14.16597758f , -18.97180923f , -23.84334763f , -29.44331171f , -31.44436223f , -32.10318621f , -34.92490176f , -36.47617953f ,
    32.84070800f , 26.98843227f , 23.97706735f , 20.09690811f , 17.17772395f , 15.21303519f , 13.42060419f , 12.43874328f , 9.15968596f , 6.16038922f , 0.71905975f , -2.92001972f , -6.40947412f , -10.83784032f , -13.95928861f , -17.62432172f , -22.53835937f , -25.41550617f , -29.42258267f , -33.41667068f , -35.41334436f , -38.22281954f , -39.80199786f , -40.32675160f ,
    -9.91625093f , 4.80418237f , 9.08604693f , 11.01664820f , 7.24939971f , 12.00629737f , 10.14522962f , 7.79868426f , 0.03388286f , 3.22894410f , -1.49188110f , -1.77551920f , -5.08350600f , -6.11630690f , -8.19142417f , -8.31829806f , -9.48559967f , -10.78591755f , -12.34898021f , -13.04347069f , -12.86564050f , -16.09519878f , -17.66110352f , -20.13284843f ,
    33.93076696f , 29.73735327f , 19.23905822f , 17.23103235f , 12.77046694f , 8.83451844f , 8.23785020f , 7.11377423f , 6.72823159f , 4.05823561f , 1.17653434f , -2.62333502f , -1.84527480f , -3.46714831f , -9.29420158f , -13.72585514f , -17.96342825f , -22.04254130f , -26.29305138f , -30.25871596f , -32.43685342f , -36.04907640f , -39.16814132f , -40.73022661f ,
    30.53206150f , 19.40488473f , 12.75598255f , 9.25954864f , 6.70414010f , 5.72747123f , 5.03381227f , 4.01075984f , 3.61146616f , 3.58899760f , 2.32432976f , 0.53033441f , -2.14938224f , -5.59608713f , -7.14094606f , -7.65425973f , -8.99080383f , -12.95963757f , -17.18036927f , -19.46195053f , -21.56000305f , -24.52225545f , -30.08064474f , -35.71887681f ,
    43.21595883f , 30.91880384f , 28.28763915f , 25.00936743f , 19.09701763f , 16.45025980f , 13.97496410f , 11.13694940f , 8.55554358f , 4.99105536f , -0.75976252f , -4.26698912f , -8.42682321f , -9.48353121f , -14.21251069f , -17.24378853f , -19.81223810f , -21.34834559f , -23.80150703f , -25.40905846f , -25.28209830f , -26.22742436f , -26.66260243f , -27.01651200f ,
    -0.14361434f , 11.33097675f , 14.22933286f , 9.09701983f , 11.66148024f , 8.76183273f , 5.66551557f , 3.17860698f , 3.87061452f , 2.88805964f , 0.11657889f , -1.62298350f , -3.19956391f , -5.77861831f , -8.72933989f , -8.83773190f , -7.97439380f , -9.53621475f , -13.35824515f , -15.73862835f , -16.23732929f , -19.37222733f , -22.16495373f , -24.69705224f ,
    14.97516906f , 20.24358485f , 21.71690634f , 18.67539860f , 16.12099511f , 13.68136380f , 12.06765212f , 10.76593030f , 7.44448363f , 4.69310947f , 0.32375113f , -2.82379840f , -6.24406445f , -9.85549248f , -12.35464306f , -15.66193154f , -18.15727457f , -19.51476533f , -21.69116638f , -26.65585670f , -30.96969557f , -34.93908838f , -37.17487414f , -38.69523980f ,
    11.79211750f , 11.97065541f , 11.42461150f , 9.07103015f , 6.75482034f , 5.60897088f , 5.19878959f , 4.12715904f , 3.68541174f , 3.10916340f , 1.75493030f , 0.12722322f , -2.45721866f , -5.96134122f , -7.29240229f , -6.69634000f , -7.95934523f , -12.27446428f , -16.49521939f , -17.81789512f , -20.15378269f , -23.44933417f , -28.12142909f , -32.19480869f ,
    31.52643526f , 28.52259080f , 26.69926841f , 20.98459124f , 15.75207892f , 11.93364546f , 8.26555040f , 7.77743568f , 5.47651258f , 4.83040775f , 1.65268569f , -2.13370539f , -5.16522881f , -8.08709801f , -10.71942352f , -14.02185419f , -15.56110704f , -16.98333790f , -19.99452598f , -22.68342788f , -23.41377838f , -25.94358058f , -26.53240068f , -27.12327850f ,
    6.80087128f , 11.58644896f , 12.45313320f , 10.29597723f , 9.18481781f , 8.48775117f , 7.26614653f , 5.90419380f , 4.38057275f , 2.43656205f , 0.69276327f , -1.81218785f , -3.96339389f , -5.75303899f , -7.09187068f , -8.88618164f , -10.84611660f , -12.42796224f , -13.13959174f , -13.43223783f , -14.11628112f , -15.89113608f , -18.99839794f , -22.60584539f ,
    36.38520889f , 28.78012839f , 21.05496218f , 17.53636167f , 13.96758507f , 11.67472760f , 10.42791533f , 9.67412184f , 7.27606489f , 5.56430120f , 0.35452150f , -3.04945909f , -3.73479650f , -6.39521181f , -11.23696830f , -15.42073952f , -19.10245341f , -22.52588883f , -26.73438324f , -31.13547298f , -32.74648378f , -35.08411011f , -36.64862406f , -37.83303410f ,
    23.44391246f , 16.34449728f , 12.74386848f , 10.37728433f , 9.26531402f , 8.62835052f , 7.30803355f , 5.91607884f , 4.36863155f , 2.42037310f , 0.72270664f , -1.87419199f , -3.98816276f , -5.80775521f , -7.13994994f , -8.93853756f , -10.88091925f , -12.48019720f , -13.11652631f , -13.43063220f , -14.21381571f , -15.91218672f , -19.00174998f , -22.61508378f ,
    42.41685465f , 32.92785864f , 26.73527519f , 20.02657328f , 15.25763921f , 11.51912083f , 7.75120808f , 10.47560309f , 9.43865509f , 4.72161580f , 1.23456822f , -1.24509427f , -5.12070011f , -8.97924223f , -14.13085652f , -15.32553884f , -15.59705390f , -18.30233488f , -23.33478017f , -25.58695872f , -25.86117061f , -27.64564989f , -29.28904725f , -31.28074013f ,
    1.52342001f , 9.12417569f , 10.32715957f , 8.66545459f , 7.07445753f , 5.84320555f , 5.74305920f , 4.78929426f , 4.24381536f , 2.93093263f , 1.43577760f , -0.53860173f , -3.06985625f , -4.84378216f , -6.19218421f , -7.82485861f , -9.59127476f , -11.55775664f , -13.43280469f , -15.63550289f , -19.62772693f , -22.98849208f , -25.64470241f , -28.78809716f ,
    25.56643800f , 24.60767519f , 24.69578809f , 19.70646081f , 15.16249776f , 11.52050408f , 7.81769903f , 7.63275125f , 5.49767989f , 4.82720507f , 1.97596070f , -1.66260544f , -5.25016669f , -8.43401653f , -10.50840106f , -13.66164463f , -14.91737550f , -16.34161902f , -19.45629644f , -23.46159848f , -25.62249781f , -27.82515036f , -28.34414019f , -28.79284328f ,
    16.92655154f , 13.22739747f , 11.12354116f , 8.43784353f , 9.39924384f , 10.05896738f , 8.60043956f , 6.03413409f , 6.90507663f , 4.38541942f , 1.33274141f , -3.40564903f , -6.91513167f , -6.87459047f , -7.76883773f , -9.68917237f , -12.06267819f , -15.74184854f , -20.57971046f , -26.94266349f , -28.91713407f , -29.90809627f , -32.33980009f , -34.78712756f ,
    31.86686358f , 25.05708453f , 21.93386932f , 18.59721235f , 16.14828273f , 13.65996344f , 12.23768162f , 10.88830652f , 7.52143926f , 4.65925062f , 0.21911333f , -2.95634076f , -6.28361110f , -9.89608579f , -12.31443795f , -15.63623136f , -18.24730809f , -19.62072228f , -21.80325803f , -26.65045940f , -31.07260802f , -34.93098644f , -37.15982288f , -38.71632279f ,
    -1.13403660f , 8.44528954f , 11.51295187f , 14.00328114f , 13.22245841f , 6.86239877f , 5.34172769f , 2.20794235f , 0.66973127f , 0.80995393f , 0.18013549f , -1.34499371f , -2.89430852f , -4.11662287f , -4.87021345f , -7.99460808f , -8.07372401f , -10.75957729f , -12.01649380f , -13.25826273f , -16.07989264f , -18.05984187f , -19.66161990f , -20.39890287f ,
    34.47278093f , 29.24647924f , 19.01794852f , 15.12449850f , 12.02160432f , 7.97153847f , 7.45763494f , 5.89473413f , 5.37914684f , 4.00235938f , 0.64484508f , -2.70552406f , -1.74008061f , -3.83315860f , -8.38542072f , -11.12882737f , -15.57900872f , -20.44309400f , -25.22215650f , -30.01421316f , -32.58722714f , -35.83261388f , -38.09733270f , -39.57915419f ,
    26.99752631f , 17.33775755f , 13.92510612f , 10.93298244f , 9.54482419f , 7.98334199f , 6.83019538f , 4.82308161f , 2.24070293f , 0.99075525f , -1.02697127f , -2.29004143f , -3.77731663f , -5.16939314f , -6.16294107f , -6.18510893f , -7.80109455f , -10.31816129f , -12.42321458f , -14.13119051f , -16.75176785f , -19.57160270f , -22.21041760f , -24.43862133f ,
    42.61148531f , 31.03862448f , 28.85875173f , 25.19534132f , 19.51936632f , 17.22593169f , 13.88213981f , 9.45821554f , 6.10128356f , 3.64177773f , -0.92329563f , -2.97749460f , -7.09143508f , -9.90051943f , -13.44778189f , -16.62642688f , -18.86184149f , -20.09465179f , -22.86181406f , -24.16906530f , -24.29058326f , -25.46900644f , -25.99854039f , -26.44256368f ,
    11.21919787f , 12.93487301f , 14.44441998f , 11.21144561f , 9.65171981f , 8.40946672f , 7.55500249f , 5.20337067f , 2.41664302f , 1.45692356f , -0.41811214f , -3.03866042f , -4.18715822f , -4.62852017f , -5.34679829f , -7.37187974f , -9.70194778f , -11.87551235f , -14.41976938f , -16.77473090f , -20.18921925f , -23.53459021f , -26.08250760f , -28.00378414f ,
    20.34283034f , 23.93100647f , 23.37840521f , 19.69998040f , 16.97580649f , 15.22176840f , 12.49942414f , 11.65471077f , 8.40962769f , 5.04811003f , 0.69748903f , -3.16572674f , -7.04148304f , -11.24778876f , -13.98941379f , -16.42484438f , -18.63762955f , -20.97458282f , -23.23612236f , -25.18653947f , -26.21052089f , -27.41104425f , -28.62675281f , -29.47926632f ,
    16.10744102f , 12.46174606f , 9.67751113f , 7.41625956f , 6.37054729f , 5.04682742f , 5.17633155f , 4.68688374f , 3.91606026f , 3.15494649f , 1.41414217f , -0.14124367f , -2.67444251f , -4.50662805f , -5.84468690f , -7.56186331f , -9.03680543f , -11.41274706f , -13.28658702f , -15.69552507f , -20.26071976f , -23.69377768f , -26.71593694f , -30.31014067f ,
    23.92977739f , 27.36060494f , 28.84534340f , 25.31470096f , 19.06231769f , 15.59405931f , 13.34476843f , 10.49105930f , 10.02936877f , 7.13162822f , 1.31449322f , -2.20667410f , -8.24469533f , -11.78467489f , -15.48551597f , -18.43809063f , -20.80800912f , -22.21620783f , -24.85301893f , -26.38738069f , -25.80522754f , -27.00307256f , -27.56365136f , -28.00697638f ,
    14.20627416f , 13.22102035f , 12.02604633f , 14.08327071f , 13.26998454f , 6.88224307f , 5.35679783f , 2.25352772f , 0.65358807f , 0.88975002f , 0.25204959f , -1.26498593f , -2.99170955f , -4.16405714f , -4.90721314f , -8.09596924f , -8.13409888f , -10.82708078f , -12.07413388f , -13.34328963f , -16.41337023f , -18.35676002f , -19.98799588f , -20.75791138f ,
    35.53474913f , 29.48558719f , 19.65603645f , 16.46619256f , 12.12345599f , 8.85911530f , 8.44629251f , 7.05107660f , 6.71696658f , 4.07340114f , 1.41090109f , -2.86480122f , -1.47018231f , -3.19146903f , -9.63933408f , -13.43801687f , -18.07739816f , -21.62350791f , -25.40446924f , -28.56460703f , -30.18164019f , -32.53467864f , -34.28547688f , -35.28943834f ,
    25.00794399f , 21.33869877f , 16.33988340f , 13.32545569f , 11.45579996f , 9.10207550f , 5.25001638f , 3.47011991f , 4.05816364f , 1.86646664f , -0.86488053f , -3.00452324f , -3.76486650f , -4.79552937f , -6.02719617f , -7.73977293f , -9.00587006f , -9.73374090f , -11.85870497f , -14.34560315f , -16.77881295f , -19.01848975f , -21.05935919f , -22.79963588f ,
    43.77792792f , 31.32894231f , 26.45922262f , 21.35876446f , 15.14525981f , 10.71588831f , 8.36941090f , 8.13517319f , 4.60128461f , 4.27211986f , 0.48686102f , -2.99834845f , -5.70951224f , -8.40090526f , -10.59412598f , -12.10770405f , -11.91522373f , -11.91518882f , -14.41049054f , -17.78623890f , -21.49234475f , -25.81448584f , -28.36724870f , -30.21155944f ,
    1.50464115f , 9.93376270f , 11.74048494f , 9.30038969f , 9.79598610f , 10.20363220f , 7.85569223f , 4.26334672f , 4.97315307f , 3.54446278f , 1.25546594f , -3.09504089f , -6.84943958f , -5.99780503f , -6.73288678f , -8.33022105f , -10.88645558f , -13.74251357f , -18.59070672f , -25.24686013f , -27.59378675f , -28.40807602f , -30.81519883f , -33.03504083f ,
    19.29716892f , 22.72202601f , 17.97653030f , 16.27096251f , 12.41466110f , 8.84546373f , 8.15910118f , 6.66039787f , 6.35335478f , 4.08653893f , 0.72117759f , -2.80728034f , -1.28889621f , -3.09741558f , -8.84182975f , -13.43826617f , -17.76712819f , -21.05170423f , -24.61965449f , -27.56558965f , -28.70738278f , -30.61253475f , -32.09933492f , -32.92557847f ,
    22.91112025f , 16.28797584f , 13.32980234f , 11.77954583f , 11.10520613f , 9.60502556f , 6.99639805f , 4.92750381f , 4.37578890f , 3.30304792f , 1.59780404f , -0.85650398f , -4.51942915f , -6.12826489f , -9.01178894f , -9.24740841f , -12.14748862f , -16.76564804f , -21.19272621f , -27.28665412f , -29.08952731f , -28.60120961f , -31.88653060f , -33.18962566f ,
    33.45651993f , 27.28201548f , 24.14734641f , 20.06703472f , 17.00409549f , 15.37948573f , 13.16136491f , 12.54752730f , 8.51110832f , 6.15322442f , 1.01576259f , -3.20755791f , -6.86882472f , -10.60714935f , -13.86074399f , -17.81294984f , -21.41525794f , -23.90831312f , -26.23400053f , -28.17563657f , -29.78113366f , -31.33044221f , -32.48533160f , -33.17676836f ,
    -1.33562639f , 7.12695001f , 9.13702377f , 12.15068677f , 10.08162039f , 4.24738369f , 5.64945952f , 9.32178364f , 3.03127020f , 1.38560225f , -0.47615923f , -1.64981857f , -3.39596649f , -4.05192511f , -6.43198431f , -7.97537953f , -9.73574405f , -10.49517550f , -11.53586670f , -11.55974030f , -11.95164592f , -14.31159626f , -16.17106881f , -17.68912312f ,
    35.41108122f , 29.91060467f , 19.58523453f , 16.06777717f , 12.57822747f , 8.35950205f , 8.09246540f , 6.67806922f , 5.88366701f , 4.60628742f , 0.66866287f , -2.63518420f , -1.20919288f , -3.25276235f , -8.81348472f , -13.41243642f , -17.54390333f , -21.59153299f , -26.13142590f , -30.39899536f , -32.82264487f , -35.85023060f , -38.02784458f , -39.40873711f ,
    28.20606627f , 15.99154594f , 10.90529614f , 8.27787590f , 6.06401205f , 5.06158745f , 4.71175812f , 3.71857258f , 3.29421131f , 3.15470022f , 1.47961235f , -0.11358400f , -2.36135275f , -5.91849835f , -7.03135770f , -5.55512296f , -6.50513100f , -10.60214350f , -14.97482271f , -15.31088270f , -17.34686348f , -20.99732736f , -25.70312725f , -29.22139957f ,
    42.93694373f , 32.74699191f , 30.21736822f , 26.00007059f , 19.54808802f , 16.15153602f , 13.70906743f , 10.84988327f , 10.20654657f , 7.38885117f , 1.18592616f , -2.68553419f , -8.73683094f , -12.15884936f , -15.82753433f , -18.59595794f , -21.03522899f , -22.52642663f , -25.16717079f , -26.41557750f , -26.29502925f , -27.33330821f , -27.87099339f , -28.30239553f ,
    6.98493107f , 12.11140261f , 12.92505832f , 10.63602573f , 9.29436222f , 7.80676869f , 6.62557343f , 4.68392090f , 2.17174988f , 1.01311116f , -1.11858724f , -2.22498325f , -3.56605973f , -4.96869680f , -6.04787508f , -6.05424850f , -7.61493730f , -9.33729157f , -10.80071194f , -12.03282608f , -14.46539670f , -17.02917589f , -19.33639362f , -21.15590027f ,
    16.58485816f , 23.25532800f , 24.92928523f , 21.35853037f , 18.27283576f , 16.09710359f , 14.23738656f , 12.78815582f , 9.26070976f , 6.16634740f , 0.30018833f , -3.21368036f , -6.95869200f , -11.45995031f , -14.49141925f , -17.86218539f , -23.13676669f , -25.83259792f , -29.74871192f , -33.41994284f , -34.94573093f , -37.66843375f , -39.07414904f , -39.56312642f ,
    19.19373953f , 14.21085832f , 10.67306675f , 8.33934581f , 6.82717763f , 6.09582415f , 5.89997396f , 4.53145606f , 4.46589963f , 2.98486276f , 1.45382349f , -0.47196753f , -3.08165487f , -4.80601244f , -6.35558877f , -7.88794845f , -9.65590673f , -11.39978404f , -12.89635391f , -14.32655348f , -17.79398377f , -21.03259304f , -23.41750892f , -26.20513637f ,
    29.53404537f , 30.67650669f , 27.35804255f , 20.58387049f , 15.13774878f , 11.44742263f , 8.37085526f , 10.32676908f , 9.44758339f , 4.78688526f , 1.42891547f , -1.32094691f , -4.89316199f , -9.59224642f , -14.04691133f , -15.02972510f , -16.06330505f , -18.39580808f , -21.09539458f , -21.98720102f , -21.73206018f , -23.31133245f , -24.77510819f , -26.73382495f ,
    8.21213806f , 10.71817099f , 6.95322984f , 10.27747529f , 8.84487068f , 3.08387427f , 4.45029470f , 10.93157046f , 2.20726443f , 2.60772269f , 0.11878151f , -0.75484803f , -2.80874481f , -3.82230411f , -6.83748866f , -8.27100427f , -9.75013326f , -11.03913114f , -12.78391580f , -13.82412848f , -14.12344338f , -16.73927451f , -18.69924100f , -20.13526564f ,
    36.59329684f , 30.98184338f , 20.31505022f , 15.92064718f , 13.03648432f , 8.83096086f , 8.56348539f , 7.43266836f , 6.82375344f , 4.40627973f , 1.13184165f , -3.01500873f , -1.77040231f , -3.69259653f , -9.49579170f , -13.95449102f , -18.29710034f , -22.56971615f , -26.64665710f , -30.91115675f , -33.15396332f , -36.23947175f , -38.66101864f , -40.00954322f ,
    21.55198111f , 18.08013792f , 12.86298781f , 10.08865136f , 9.05061804f , 6.54215134f , 4.72951143f , 3.72642094f , 2.85320817f , 1.71125125f , -0.07271721f , -0.95539550f , -3.50605983f , -4.43298306f , -5.50932418f , -6.32571893f , -7.81088376f , -8.89702447f , -9.73519051f , -10.67801247f , -13.58487694f , -16.68643366f , -17.77012871f , -20.05291511f ,
    46.89729788f , 35.56958745f , 28.59584038f , 22.30896946f , 16.77464328f , 13.26417085f , 9.50081776f , 9.90989766f , 7.34552811f , 5.94667087f , 1.99541819f , -1.96361481f , -6.27398279f , -10.07653618f , -12.56282109f , -16.11090729f , -17.74907160f , -19.50939014f , -22.57118303f , -25.05439958f , -25.40229780f , -27.63187647f , -28.24619732f , -28.92835915f ,
    7.04882350f , 14.81563453f , 15.61978870f , 11.48753791f , 8.54260976f , 6.22345107f , 5.45372753f , 5.28049811f , 4.65171365f , 3.62223181f , 1.43071415f , -1.72597185f , -3.88591530f , -4.61140675f , -6.49788570f , -8.59851355f , -9.88533610f , -11.88847906f , -14.04273862f , -16.54736577f , -19.07821687f , -22.45007228f , -25.58564675f , -28.56726867f ,
    26.62300533f , 28.26693809f , 26.50090754f , 20.40002747f , 15.09430263f , 11.11188625f , 8.11413871f , 10.45873727f , 9.34406319f , 4.93078412f , 1.46033398f , -1.08739740f , -4.89307642f , -9.31800578f , -13.94736720f , -15.44189741f , -15.82638440f , -18.64996439f , -23.01530348f , -24.89778906f , -24.73159812f , -26.54494768f , -28.17985037f , -30.12506435f ,
    18.67019979f , 15.08336786f , 12.94476580f , 10.08150497f , 10.00925560f , 9.67310787f , 7.30307309f , 4.52404204f , 5.06127062f , 3.29409992f , 1.11564223f , -2.83692116f , -5.88020005f , -6.25987188f , -7.10071550f , -8.19345902f , -10.70954639f , -13.53857613f , -18.30301326f , -24.52520568f , -27.34703702f , -27.97535570f , -30.09726173f , -32.24832937f ,
    36.04980859f , 29.26056864f , 23.78078855f , 19.63374982f , 16.81000279f , 14.81984984f , 12.41523810f , 11.85197437f , 8.58759306f , 5.22704793f , 0.47511965f , -3.18839218f , -7.11099580f , -11.31735229f , -13.99002045f , -16.24783283f , -18.33216567f , -20.74910417f , -23.21510782f , -25.78954590f , -27.11200149f , -28.25034071f , -29.54019390f , -30.46288370f ,
    0.37670779f , 0.29687493f , -0.01730927f , 0.11726067f , 0.11179207f , 0.33596355f , 0.21138045f , -0.04339771f , -0.02563331f , 0.38427089f , 0.09512665f , -0.07913710f , -0.00292995f , 0.29039347f , 0.10659745f , 0.19430847f , 0.34841833f , 0.11527277f , -0.04865383f , 0.19615645f , 0.02847621f , 0.06718820f , -0.22446622f , 0.20364433f ,
    33.05884904f , 28.21806545f , 18.28672366f , 14.90465855f , 11.81838140f , 8.53018928f , 7.36436457f , 6.22819968f , 5.84887442f , 3.66847974f , 0.20260152f , -2.66704796f , -1.47894289f , -2.86302773f , -7.85434089f , -12.24209362f , -16.55564265f , -20.61195764f , -25.12237933f , -29.08693654f , -31.94525806f , -35.55122030f , -38.95909687f , -40.60633258f ,
    24.50578368f , 23.21164155f , 17.92457034f , 12.07933488f , 8.98364311f , 6.80371606f , 5.83939766f , 5.41161671f , 4.31883022f , 3.60077410f , 1.63582448f , -1.36979682f , -3.64312460f , -5.15824621f , -7.52882787f , -8.79219701f , -10.10176923f , -12.04124517f , -13.96520976f , -16.84553679f , -20.16579953f , -23.43856366f , -26.82374740f , -29.86100013f ,
    48.50819832f , 34.15289137f , 28.24457133f , 23.53440589f , 18.31072957f , 15.88776926f , 12.53987092f , 11.18245335f , 6.24944164f , 4.11493883f , -0.52409240f , -5.30803325f , -9.07637769f , -11.17513219f , -12.30672893f , -14.59517059f , -15.29955284f , -16.17617119f , -18.50798560f , -20.76566614f , -22.52791437f , -25.09691027f , -26.04976551f , -26.89355524f ,
    8.09511743f , 16.72934786f , 15.91762640f , 13.38776480f , 11.39996807f , 9.07169312f , 5.27363212f , 3.54887142f , 4.12516542f , 1.95190718f , -0.86304369f , -2.99361979f , -3.82488041f , -4.85774399f , -6.10028496f , -7.73781042f , -8.99385716f , -9.74269129f , -11.87311775f , -14.36412448f , -16.63984465f , -18.98401676f , -21.03949226f , -22.80551374f ,
    20.87378295f , 25.56786054f , 24.37761370f , 20.59749879f , 17.50210689f , 15.81599869f , 13.08379347f , 12.05910670f , 8.96864073f , 5.68078325f , 0.54144388f , -3.56427128f , -7.29664065f , -11.97853799f , -15.04589649f , -16.84207789f , -18.92440518f , -21.49140235f , -24.44638942f , -27.80142626f , -29.24580339f , -31.40581424f , -33.20452192f , -34.96038674f ,
    19.41104922f , 14.92637618f , 12.34176913f , 10.26196252f , 8.23856507f , 6.94579600f , 6.09672941f , 5.11937634f , 4.33940607f , 3.00270291f , 1.52448177f , -0.93710759f , -3.39576042f , -5.47615969f , -6.39919115f , -8.50931643f , -10.54951473f , -12.31607256f , -14.47860786f , -16.84616423f , -20.24052021f , -23.50168995f , -26.54506826f , -30.16170088f ,
    28.94913403f , 28.15793287f , 27.35445852f , 23.88021364f , 19.04664597f , 16.62782585f , 13.23041024f , 11.80165357f , 6.78531707f , 3.80696933f , -0.83387114f , -5.70452993f , -9.22126990f , -11.40351884f , -12.85584125f , -15.17252463f , -16.10728336f , -17.34847712f , -19.92401313f , -22.57735630f , -23.06177883f , -25.40758146f , -25.92714954f , -26.49459925f ,
    12.32069177f , 16.71685865f , 15.41594910f , 11.66621173f , 7.27561715f , 4.39258627f , 3.29820147f , 3.32758485f , 3.22734089f , 2.78470278f , 1.44650193f , -0.81598784f , -3.12521932f , -3.93668706f , -4.64477937f , -6.10317000f , -7.12681751f , -8.89530539f , -11.17332758f , -13.38366313f , -16.18909111f , -19.08724858f , -21.72257955f , -24.33222369f ,
    35.39248501f , 28.61432228f , 17.95058353f , 16.39813320f , 12.26449602f , 9.14706821f , 8.63032788f , 5.85616320f , 5.28119540f , 2.63526927f , -0.28717841f , -3.14181019f , -2.72478672f , -3.16234838f , -8.13078551f , -11.42272872f , -14.94525653f , -18.82791922f , -23.24088065f , -27.02082853f , -28.42092038f , -30.16472575f , -31.40325103f , -31.84491940f ,
    29.17417043f , 22.35669900f , 16.18973605f , 11.81596682f , 7.33020525f , 4.62573743f , 3.88471147f , 3.94864957f , 3.63555026f , 2.84599249f , 1.57602679f , -1.21735288f , -3.89478177f , -4.22974940f , -4.64250760f , -6.47171963f , -7.39065220f , -8.84922447f , -11.09964915f , -13.32068423f , -16.59227278f , -19.66683547f , -21.69504139f , -24.56742611f ,
    47.82535148f , 33.38325580f , 27.02560388f , 20.91023436f , 15.90238857f , 12.04933297f , 8.33681708f , 7.94847051f , 5.44070980f , 4.97685841f , 1.92697687f , -2.14584476f , -5.24005039f , -8.46045386f , -10.93596293f , -14.12648623f , -15.67279334f , -17.08482629f , -19.99575822f , -22.16249633f , -23.35032624f , -25.73870364f , -26.42301184f , -27.09098779f
};

const float cdk_37bits_2[1536] =
{
    -0.60245706f , -0.36895614f , -0.28565548f , -0.61568604f , -0.21106471f , 0.01679180f , -0.21655981f , -0.14874146f , 0.18445090f , 0.68365367f , 0.72441464f , 0.85147601f , 0.66205855f , 0.18971396f , -0.61367179f , -0.98009038f , -1.14245763f , -1.87659153f , -2.50979179f , -2.95026349f , -3.02743274f , -2.99854930f , -2.88275498f , -2.56850176f ,
    -5.65082964f , -2.53862673f , 0.40160897f , 2.96821191f , -0.14824038f , -1.30349223f , 2.28641587f , 2.52644085f , -0.74130153f , -0.58139293f , -0.40073314f , -0.35906410f , -1.19626114f , 0.06293193f , 0.64564279f , -0.28942601f , -0.50149314f , 0.15944196f , -0.49731843f , -1.16475251f , -1.23551169f , -1.75642099f , -1.69671673f , -3.27291796f ,
    -3.65205633f , -1.67292739f , -1.06391729f , -1.37244548f , -1.12591558f , -0.69120125f , -0.80026251f , -0.27722939f , -0.15083351f , -0.13788690f , 0.03718469f , 0.68916477f , 0.75420341f , 0.54895929f , 0.40054739f , 0.43983204f , 0.31332249f , 0.46565374f , 0.40388762f , 0.35105496f , -0.40253674f , -0.51485592f , -0.89858941f , -1.05731152f ,
    -2.11612178f , -1.68149840f , -1.39421377f , -0.97488811f , -0.68836346f , -0.25122725f , 0.16979554f , 0.57375560f , 1.03704438f , 0.52788495f , 0.50037128f , 0.36855698f , 0.00455631f , -0.09861634f , -0.62955146f , -0.58507783f , -0.92884745f , -1.12052521f , -1.30254994f , -1.47192536f , -1.44028535f , -1.35850941f , -1.34195842f , -1.31721028f ,
    0.25982061f , -1.32220193f , -0.47678762f , -0.12979514f , 0.86306107f , 0.97702394f , 0.51749416f , 0.16146949f , 0.02988918f , 0.04663050f , 0.16707804f , 0.08767141f , -0.04519466f , -0.62683764f , -0.72798866f , -0.62087439f , -0.82935248f , -1.03592460f , -1.01752567f , -0.84860483f , -0.97413949f , -0.96705657f , -0.88017027f , -0.73637371f ,
    -0.26891091f , -0.80936559f , -0.58294544f , -1.02346364f , -0.43822029f , 0.57696314f , 1.16119077f , 2.18526688f , 0.18783659f , -0.57134867f , -0.83284393f , -0.78823212f , -0.76995104f , -1.09940636f , -0.46951794f , 0.39805438f , 0.45964480f , -0.63039899f , -0.74118394f , -0.78835034f , 0.14868248f , 0.93250274f , 0.68897718f , 0.90075101f ,
    -1.66784004f , -0.50476115f , -0.02030205f , 0.46798248f , 0.49883263f , 1.17082801f , 0.80713467f , 1.16362509f , 0.81774163f , 0.49553337f , 0.11478912f , -0.22236563f , -0.67572086f , -1.30599465f , -1.03213159f , -0.97366307f , -0.85875427f , -0.98596121f , -0.74580950f , -0.40837319f , -0.08418331f , 0.86784028f , 1.43480309f , 1.64139207f ,
    2.27287621f , -0.58474310f , -0.69019045f , -0.47070058f , -0.61574738f , -0.51533540f , -0.29508852f , 0.10165453f , 0.36287882f , 0.55457305f , 0.57810155f , 0.47931307f , 0.43968104f , 0.06171771f , -0.25362137f , -0.47864384f , -0.41913420f , -0.68219417f , -0.57749295f , -0.73286321f , -0.88652778f , -1.14118878f , -1.17860702f , -1.07742659f ,
    -0.26605958f , -1.09199471f , -1.65740224f , -2.14201695f , -2.06186690f , -1.68936539f , -1.00901439f , -0.37549041f , -0.06256679f , 0.35513419f , 0.98053497f , 0.91466430f , 0.86530432f , 0.83552545f , 0.81062242f , 0.38603024f , 0.05045884f , -0.59611788f , -0.82572806f , -1.24150282f , -1.51280469f , -1.59822307f , -1.71808914f , -1.60728998f ,
    -1.09129709f , 0.06734422f , 0.07681791f , -1.25010854f , 0.11998545f , 0.44876184f , 0.34324970f , 0.19227749f , -0.14778119f , -0.08340870f , -0.08182976f , -0.20398755f , 0.06772352f , -0.09075007f , -0.02123454f , -0.25839401f , -0.28488980f , -0.64962465f , -0.75312989f , -1.01319788f , -1.29428363f , -1.46281777f , -1.48497336f , -1.34472564f ,
    -0.64660266f , -0.88691293f , -0.84393960f , -0.34552440f , 0.32824730f , -0.29728699f , -1.56066720f , -1.75726505f , -1.37935080f , -0.41983170f , 0.07847383f , 1.10763083f , 1.38831040f , 0.68960638f , 0.33240448f , 0.76690865f , 0.72333401f , 0.09227846f , -0.25578331f , 0.21326173f , 0.72267697f , 1.03823367f , 0.53396722f , 0.85492859f ,
    -0.66178264f , -0.72781507f , -1.16616398f , -0.61180318f , -0.13929383f , -0.36461939f , -0.18208278f , -0.01288829f , 0.07717647f , -0.10024019f , 0.07436033f , 0.26910493f , 0.35220120f , 0.08875997f , 0.10426474f , -0.03109220f , -0.13636337f , -0.22965524f , -0.32874358f , -0.25961753f , -0.26897008f , -0.21251566f , -0.09802804f , 0.02321489f ,
    0.68981472f , -1.15206563f , -2.29258605f , 2.55986100f , 0.37026158f , -2.06518041f , 0.29082193f , 1.93844641f , 0.99052150f , 0.20248720f , -0.02548929f , 0.16880347f , 0.07779328f , 0.02567656f , -0.88067113f , -0.62757477f , -0.46579846f , -0.15896606f , -0.60482751f , -0.61951099f , -0.93517849f , -1.57434405f , -2.41362494f , -3.62613249f ,
    0.10916433f , 0.43521512f , 1.56203262f , 2.28014034f , 2.45964989f , 1.28206740f , 0.62678461f , 0.76120906f , 0.64803676f , 0.26869080f , -0.47306419f , -0.43773939f , -0.62382319f , -1.07053542f , -0.92812261f , -1.19576823f , -1.31738270f , -1.36433226f , -1.44943362f , -1.75263554f , -1.79107934f , -1.65086642f , -1.63564703f , -1.48679794f ,
    -1.03508578f , -1.33591451f , -0.93011319f , -0.44471674f , 0.37500761f , 0.92138871f , 0.47036706f , -0.45250578f , -0.67117578f , -1.17172575f , -0.80474849f , -0.45208178f , 0.34756513f , 0.94484979f , 0.66316845f , 0.02661059f , -0.19689367f , 0.28637288f , 0.19763960f , -0.18457662f , -0.24564459f , -0.27740232f , -0.16466847f , -0.07240464f ,
    0.79283938f , 0.04072154f , -0.45284799f , 0.62520205f , 0.40461878f , 0.46378915f , 0.26074483f , -0.00916984f , 0.17535410f , 0.03167535f , -0.07586785f , 0.26470352f , -0.21568977f , -0.76557444f , -0.42590064f , -0.12909543f , 0.02061938f , 0.20821266f , 0.45608502f , 0.64917803f , 0.55163697f , 0.57240961f , 0.62231726f , 0.71731998f ,
    0.22967499f , -0.05073000f , 0.51257014f , 0.53635363f , 0.90936842f , -0.47960537f , -0.60503509f , -0.38078624f , 0.72254161f , 0.43714553f , 0.48654362f , 0.43714660f , 0.18700370f , 0.03007471f , -0.39817882f , -0.59285823f , -0.75351375f , -0.75107912f , -0.77902788f , -0.82750373f , -0.72882091f , -0.75427284f , -0.57531634f , -0.37148640f ,
    -2.32676805f , -0.68486879f , -0.28456416f , -0.36791144f , -0.29071024f , -0.01135526f , 0.16172201f , 0.27899421f , 0.23877415f , 0.01902860f , -0.32670357f , -0.28942004f , -0.25341926f , -0.28159658f , 0.07050306f , 0.26414188f , 0.42045388f , 0.49934376f , 0.55163730f , 0.80964449f , 0.41444864f , 0.21371086f , 0.07501103f , 0.11308696f ,
    -0.27305539f , -1.16787053f , -1.40565538f , -0.99925137f , -1.11970497f , -0.87627497f , -0.63268066f , -0.40045797f , -0.40525654f , -0.06010181f , 0.13266298f , 0.44378479f , 0.45144645f , 0.18695876f , 0.55290900f , 0.78041480f , 0.94641486f , 1.00887739f , 1.70081287f , 2.26350129f , 2.47817098f , 2.59918260f , 2.79591047f , 2.78437201f ,
    -0.32246249f , -1.71452730f , -2.64055100f , -2.67577145f , -0.92654110f , 0.26408617f , -0.25926943f , 0.02139616f , 0.33878547f , 0.06917466f , 0.02594366f , 0.24868381f , 0.39107983f , -0.01529301f , -0.20036110f , 0.01057045f , 0.03136854f , 0.09346079f , 0.22821765f , 0.33206417f , 0.01105828f , 0.17529667f , 0.88221791f , 0.89873292f ,
    0.93496823f , 0.51731100f , 0.04196463f , -0.75388451f , 0.47715970f , 0.54630853f , 0.18782570f , -0.38877496f , -0.07979449f , -0.12966809f , 0.12211422f , -0.22771599f , 0.03309780f , 0.02166307f , -0.05844436f , -0.17678384f , -0.32696150f , -0.45229639f , -0.40223728f , -0.45381663f , -0.55363514f , -0.44568304f , -0.41742550f , -0.27033009f ,
    1.24789723f , -0.16270145f , -0.23526508f , -0.91495192f , 0.09192658f , 0.94791314f , 0.99514796f , 1.48011022f , 1.18575675f , 0.34462249f , 0.08649944f , -0.30288071f , -0.33154349f , -0.62323828f , -1.23683351f , -1.35258474f , -1.28447604f , -1.39540423f , -1.48493397f , -1.22352799f , -0.64023287f , -0.31408935f , 0.05098542f , 0.60709035f ,
    -1.28296443f , 0.30739631f , 0.06005469f , 0.20911344f , 0.24839533f , 0.32438667f , 0.52129460f , -0.19296009f , 0.56893959f , 0.27689822f , 0.19535841f , -0.28910358f , -0.03222614f , -0.11973675f , -0.43887472f , -0.57077656f , -0.49160952f , -0.12962890f , 0.67632833f , 1.51844798f , 1.92676111f , 2.40049046f , 3.14497224f , 4.02974673f ,
    1.80516481f , -0.56393339f , -1.30448044f , -1.40495082f , -0.68191674f , -0.76180008f , -0.59977868f , -0.51019494f , -0.68339140f , -0.49281527f , -0.13376455f , 0.19985525f , 0.65099755f , 0.67547152f , 0.63174636f , 0.88059571f , 0.82474329f , 0.51834518f , 0.45799476f , 0.48269666f , 0.41156043f , 0.45527314f , 0.53753557f , 0.66268670f ,
    -1.55606025f , -0.20257947f , -0.14962756f , -0.99675497f , -1.37013665f , -1.22741192f , -0.99079753f , -0.49157059f , 1.03655475f , 1.41721212f , 0.93733685f , 0.23984335f , -0.04670573f , -0.46782519f , -0.11250628f , 0.37457349f , 0.70065238f , 0.30049206f , 0.12589128f , 0.00816302f , -0.30417620f , -0.55639550f , -0.97628459f , -1.33776955f ,
    -0.91978133f , 2.03647597f , 2.08783454f , -0.34357589f , -0.53113823f , -0.79082032f , -0.35484777f , -0.04415842f , -0.05569113f , 0.29670211f , 0.20802391f , 0.20847836f , 0.24786650f , 0.08187504f , 0.25883128f , 0.36261019f , 0.11231239f , 0.00938238f , 0.04224603f , -0.13883262f , -0.17357685f , 0.27783307f , 0.24645533f , 0.26199958f ,
    -0.61248405f , -0.07406218f , -0.61345974f , -1.32868141f , -1.08503963f , -0.61503512f , -0.40217073f , -0.50619739f , -0.34879559f , -0.33683180f , -0.13424100f , -0.05819325f , 0.01983650f , 0.38272624f , 0.44165965f , 1.08335723f , 1.55918521f , 0.91879734f , 0.66719572f , 0.40972477f , 0.11617552f , 0.02573831f , -0.13026683f , -0.32568351f ,
    0.31463364f , -0.03452175f , -0.04820884f , -0.36356998f , -1.78279482f , 0.33915182f , 0.23383962f , 0.10388632f , 0.30795414f , 0.18689800f , 0.20754344f , -0.09819817f , 0.32111428f , 0.28504616f , 0.07722536f , -0.01904677f , -0.16255073f , -0.15042754f , -0.03877674f , 0.01867447f , -0.00999362f , 0.02968441f , 0.12366541f , 0.24417438f ,
    1.09843253f , 0.09916156f , -0.26715787f , -0.21319307f , 0.17488666f , -0.03969684f , -0.42084276f , -0.26687268f , -0.54193150f , -0.73872758f , -0.38673483f , -0.31271029f , 0.04756063f , 0.03567565f , 0.10843090f , 1.00179157f , 1.33899024f , 0.51010916f , -0.26441522f , -0.71717032f , -1.14185896f , -1.44276220f , -1.62450955f , -1.61374667f ,
    -1.17644421f , -0.65722894f , -0.85514146f , -1.00555806f , 0.26053267f , 0.49309357f , -0.37877784f , -0.93210797f , -1.08883971f , -0.98901078f , -0.77758095f , -1.41471701f , -1.75752311f , 0.13457770f , 2.71551042f , 3.08606371f , 0.64870422f , 0.21086401f , -1.21315351f , -2.33440097f , 0.01456974f , 2.06478611f , 0.27046489f , 0.39813046f ,
    -0.48133789f , 0.05248478f , 0.15702810f , 1.09901110f , 1.05962736f , 1.17102152f , 1.55536593f , 0.44906344f , -0.41703175f , -1.12950682f , -0.93068802f , -1.09338708f , -0.91150200f , -0.48817666f , 0.10937607f , 0.37946930f , 0.24542719f , 0.26431763f , 0.67229593f , 0.65079198f , 0.00926221f , -0.87021868f , -1.26123155f , -1.41977363f ,
    1.54426896f , 1.64264747f , 1.49559347f , 0.46249745f , 0.93411099f , 1.07714355f , 0.81133504f , 0.18134510f , 0.47877461f , 0.29451902f , -0.11266912f , -0.50269456f , -0.69526938f , -0.66772091f , -0.81400219f , -0.48607791f , -0.49953687f , -0.35945370f , -0.41495272f , -0.22003468f , 0.19724418f , 0.40213003f , 0.75369682f , 0.99864576f ,
    0.09877598f , -0.24834930f , 0.70781761f , -0.02941638f , 0.04788121f , -0.17525416f , 0.24389545f , 1.27018837f , 1.54269729f , 1.25537489f , 1.40965823f , 0.83108228f , -0.00482938f , -0.57803168f , -1.40272349f , -2.04807395f , -2.39183907f , -2.28421278f , -1.59956397f , -1.84523910f , -1.49830221f , -1.32118632f , -1.41289179f , -1.07949145f ,
    -3.00057476f , -0.33414238f , 0.53147236f , 0.51026648f , 0.64656500f , 0.22188527f , 0.26159611f , -0.05358452f , 0.08996934f , -0.14007857f , -0.16740033f , 0.20548656f , 0.24617443f , -0.14274519f , -0.22696206f , -0.33493349f , -0.60597008f , -0.59551620f , -0.65068169f , -0.58018184f , -0.85498638f , -0.83283956f , -0.68903400f , -0.56704530f ,
    -1.80644488f , -2.09723761f , -2.47792833f , -2.51218612f , -1.89574511f , -1.52165564f , -1.43122992f , -1.31255781f , -1.17590463f , -0.75299628f , 0.13501040f , 1.04659662f , 0.78957362f , 1.33259798f , 1.48274046f , 1.92412844f , 1.37934388f , 1.51991312f , 1.53887225f , 1.07173430f , 0.52056336f , 0.89063725f , 0.75213286f , 0.48137117f ,
    -0.83123316f , -1.25502416f , -0.24000076f , -0.86042163f , -1.31788654f , -1.01630239f , -0.29559367f , 0.06110944f , 1.41025494f , 1.14012093f , 1.09233283f , 0.65906473f , 0.66635495f , 0.22542242f , -0.48939739f , -0.90887258f , -1.22778778f , -1.13528888f , -0.64749466f , -0.33117378f , -0.13886376f , 0.32663134f , 0.80397143f , 1.24264775f ,
    0.02879094f , -0.40518021f , 1.01153472f , 0.24919166f , 0.21717242f , 0.73565158f , 0.11322127f , 0.18792292f , -0.13373281f , -0.08074408f , -0.11253388f , -0.16098838f , 0.11676604f , -0.16172666f , -0.26254412f , -0.20650902f , -0.25114318f , -0.21747560f , -0.22020914f , -0.32979603f , -0.32478632f , -0.30167186f , -0.14634515f , 0.05782533f ,
    -0.47454777f , -0.56928151f , -1.15476553f , -0.09623004f , 2.88751281f , -0.14714366f , -0.88522957f , 4.22040983f , 1.39699412f , -1.50292392f , -0.43572570f , -0.83179815f , -0.31636548f , -0.93272549f , -0.76482978f , -1.38859059f , -1.29829764f , -0.15529744f , 0.26864398f , 0.27166310f , 0.10090808f , 0.27140121f , 0.10246642f , -0.11585636f ,
    -0.83199745f , 1.25871280f , 2.32976268f , 1.04422262f , 0.72052750f , 0.58033767f , 1.01197514f , -0.00356009f , 0.64222581f , 0.17810713f , -0.27271599f , -0.30971603f , -0.36262209f , -0.59621272f , -0.71907027f , -0.37465802f , -0.49493312f , -0.23002788f , 0.22678857f , 0.61676427f , 1.15089995f , 1.45602224f , 1.73714565f , 1.76230856f ,
    3.78596594f , 0.70843751f , 0.56143039f , 0.59983620f , 0.91117855f , 1.14938132f , 0.62640275f , 0.25328046f , 0.05444886f , -0.14074779f , -0.18351720f , -0.14467121f , -0.17323666f , -0.19046734f , -0.48709718f , -0.78123776f , -0.89375672f , -0.92818935f , -0.92156607f , -0.91479400f , -0.71603833f , -0.54172884f , -0.35025273f , -0.10097845f ,
    1.88294702f , 1.24216466f , -0.99369851f , -0.70762866f , -0.80134642f , -1.57956697f , -1.53644146f , -0.73206309f , -0.05717919f , 0.79275997f , 0.73656524f , 0.59776925f , 0.89457859f , 0.27389259f , 0.55266497f , 0.42166521f , 0.43646218f , 0.18667357f , -0.37565357f , -0.34247443f , -0.46905572f , -0.54608498f , -0.46535569f , -0.51501131f ,
    -0.47999037f , 1.00431088f , 0.73194666f , 0.53070406f , -0.01938612f , 0.03027495f , 0.40371180f , 0.67811524f , 0.70405966f , 0.58218726f , 0.21637318f , 0.01593260f , -0.21413948f , -0.51479804f , -0.67811458f , -0.52916655f , -0.67532514f , -0.70141319f , -0.64914555f , -0.67794975f , -0.70067665f , -0.79806639f , -0.63846191f , -0.48442451f ,
    1.27348348f , 0.96416420f , 0.39017217f , 0.71785608f , 1.03161791f , 0.22200744f , -0.65764394f , -1.59478709f , -0.95580133f , -0.45685571f , 0.24849072f , 0.90500271f , 0.94710102f , 0.11334884f , -0.15646077f , 0.15567420f , 0.19951531f , 0.06661949f , 0.16776497f , 0.92645175f , 1.51329143f , 1.99768327f , 2.23252155f , 2.82502657f ,
    -0.54469743f , 0.32018638f , 0.18026765f , -0.24717676f , 0.16334731f , 0.24119007f , -0.09150780f , -0.62258235f , -0.36174875f , -0.54007117f , -0.16902754f , 0.05782464f , 0.32844560f , 0.29531844f , 0.39903673f , 0.21807358f , 0.08243945f , 0.19009618f , 0.32130029f , 0.40374798f , 0.59707077f , 0.94425923f , 1.12228590f , 1.33995773f ,
    -0.11751559f , -0.41810808f , 0.01454897f , 0.64372292f , -0.51236310f , -1.28919088f , -0.27493502f , -0.15853449f , -0.26953216f , -0.08601421f , 0.47049578f , 0.62472064f , 0.47447185f , 0.17523033f , 0.30837586f , 0.34012918f , 0.19798450f , 0.18240973f , 0.24439643f , 0.37610178f , 0.25546586f , 0.34660852f , 0.25152738f , 0.33684884f ,
    0.11066744f , 1.19858921f , 0.91132496f , 1.17666312f , 1.24521727f , 0.96210985f , 0.48787188f , -0.08729327f , -0.75696449f , -0.61950811f , -0.12399623f , -0.05243043f , 0.12080690f , 0.07846342f , -0.05639926f , -0.49681521f , -0.70132533f , -0.85192537f , -0.82039718f , -0.85401537f , -0.76376214f , -0.65987739f , -0.48460153f , -0.15410472f ,
    0.35003846f , -1.71631424f , -2.46591563f , 0.87758858f , -1.81752528f , 3.13642054f , 1.73032547f , -0.09324163f , -4.01941823f , 1.53280929f , -1.80607033f , 0.38379815f , -0.60599486f , -0.15051943f , -1.06126256f , 0.92416849f , 1.84602853f , 1.75994867f , 0.99060749f , 0.70059849f , 1.55000269f , 0.30898296f , 1.89357287f , 3.39229864f ,
    2.30088406f , 0.92343676f , 0.99415615f , 0.95404596f , 0.50656674f , 0.93824653f , 0.48608406f , -0.08446928f , -0.62418615f , -0.92839590f , -0.72113820f , -0.52847345f , -0.12827999f , 0.09174440f , 0.46989097f , 0.23658785f , 0.28508481f , 0.46040256f , 0.61632907f , 0.95774580f , 1.12674250f , 1.33598604f , 1.41647487f , 1.55101744f ,
    1.37256353f , 0.97616384f , 0.91935645f , 0.81440269f , 0.66853976f , 0.62246830f , -0.20376912f , 0.03360847f , 0.43571616f , 0.50340338f , 0.23558369f , 0.34148923f , 0.26639247f , -0.42615485f , -0.66797929f , -0.78929117f , -1.01956966f , -1.04967706f , -0.83319766f , -0.38454933f , 0.01908745f , 0.54939284f , 1.31919448f , 1.91397573f ,
    -1.47177526f , -0.59088313f , -0.29040563f , -0.30391048f , -0.77025357f , -0.91705792f , -1.11779825f , -1.26663583f , -0.88813029f , -0.84447950f , -0.68067351f , -0.12550231f , 0.86719136f , 0.95700684f , 1.32696558f , 1.54042652f , 1.91879305f , 2.53765271f , 2.74382217f , 2.47883719f , 2.13313809f , 1.99482993f , 1.71839367f , 1.55253059f ,
    -2.18776004f , -2.01842604f , -2.26735458f , -1.91080096f , -2.94652547f , -2.30201691f , -2.55949436f , -2.06940788f , 0.81981691f , 0.88975503f , 1.36019848f , 1.20472608f , 1.42006397f , 0.61493222f , -1.18963425f , 0.41220219f , 4.34572607f , 4.43362932f , 4.07803194f , 5.02807593f , 3.44925570f , -0.33534871f , 0.49574672f , -0.89211792f ,
    1.62466606f , 0.12019975f , -0.38782369f , -0.93423193f , 0.16258521f , -0.01564732f , 0.49181187f , 0.20589834f , 0.27352752f , 0.19483395f , 0.32141824f , -0.11470920f , -0.19458687f , -0.27925271f , -0.50960055f , -0.21759523f , -0.31856471f , -0.25540294f , 0.10383356f , 0.63132905f , 1.12834639f , 1.54942785f , 2.10497109f , 2.44084721f ,
    1.80221933f , 1.34647425f , 0.68084866f , 0.26131343f , 0.06129242f , -0.20413381f , -0.25012623f , 0.26150026f , 0.34217016f , -0.25077441f , -0.03464205f , 0.00670185f , 0.11970509f , -0.18474450f , -0.02420872f , 0.04947295f , 0.10704821f , 0.12031899f , 0.25733107f , 0.20223825f , 0.14644252f , 0.05014131f , 0.25449839f , 0.53243125f ,
    2.46777249f , 2.31564554f , 1.57449051f , -0.02405359f , -0.50178606f , -0.75371618f , 0.14778503f , 0.92907656f , 1.77413761f , 1.44803582f , 0.79871587f , -0.06867376f , -0.36229444f , -0.24911098f , -0.80167236f , -1.29799461f , -1.06250807f , -1.04778427f , -0.99914314f , -1.09969569f , -0.87609022f , -0.93824122f , -0.95461855f , -0.91327026f ,
    0.43633316f , 0.85535629f , 0.60581035f , 0.16065427f , -0.07901143f , -0.12715680f , 0.03021654f , 0.07928964f , 0.11271867f , -0.14335296f , -0.24219156f , -0.11821250f , -0.20715557f , -0.14096772f , -0.04794024f , 0.21199596f , 0.67185756f , 1.28693268f , 1.69253449f , 2.02169124f , 2.03489721f , 2.18782692f , 2.32510550f , 2.13471256f ,
    5.19702515f , 0.11666770f , -0.23856561f , -0.40839191f , -0.43762919f , -0.47738566f , -0.08391318f , -0.28626545f , 0.00298357f , 0.04540739f , 0.31909785f , 0.21196383f , 0.24548536f , -0.08426235f , 0.13111045f , 0.13639205f , 0.27647873f , 0.33171126f , 0.46017809f , 0.54387048f , 0.61603267f , 0.57095620f , 0.68776632f , 0.65010973f ,
    0.58235537f , 0.52562482f , 1.05922702f , 1.60193935f , 0.43144897f , -2.92550999f , -2.57110854f , -1.17753807f , 0.19698968f , 1.02966008f , 0.68834236f , -0.11567313f , -1.07423611f , 1.53722962f , 2.83106005f , 0.31270547f , 0.83691800f , 0.60620087f , 0.21605402f , -0.37564956f , 0.38963810f , -0.55569948f , -0.83510003f , -0.45007941f ,
    -0.90035383f , 0.70316556f , 1.58896986f , 2.00202833f , 0.66804071f , -0.32729105f , 0.20493044f , -0.45491115f , -0.51617330f , -0.18761885f , -0.13361848f , 0.06806675f , -0.08803656f , -0.27485407f , -0.08086164f , 0.47587476f , 0.64596634f , 1.37554511f , 1.64271082f , 1.13804275f , 0.62642705f , 0.27157260f , 0.15530333f , -0.04178223f ,
    2.19562225f , 0.68349947f , 0.14785409f , 0.07266666f , -0.11144618f , -0.52658551f , -0.77916859f , -0.76098098f , -0.55947105f , -0.61767060f , -0.18020839f , -0.26320634f , -0.03154415f , 0.41832030f , 0.98036861f , 1.17153463f , 1.26081153f , 1.58669565f , 1.96844912f , 2.21868662f , 1.28843850f , 0.48905790f , 0.12804274f , -0.25383240f ,
    0.96587648f , 1.45558990f , 0.31977941f , -0.95024822f , -1.59243377f , -0.35590271f , -0.57251864f , -0.20900643f , 0.39660737f , 0.51169138f , 0.41734874f , -0.03711820f , 0.43311570f , 0.50214417f , 0.08955252f , 0.09513494f , 0.32141616f , 0.43401876f , 0.86976131f , 1.39503347f , 1.54833843f , 1.52864127f , 1.46114291f , 1.21933526f ,
    1.78766271f , 1.61870712f , 2.29243952f , 1.45106025f , -0.02202545f , 0.12396735f , 0.05180173f , -0.74274249f , -0.04132082f , -0.01646827f , 0.04051846f , 0.10680231f , 0.03361298f , -0.26263042f , 0.29610433f , 0.25222625f , 0.18019271f , -0.22323513f , -0.68162437f , -0.96880693f , -1.29349030f , -1.78825246f , -2.63819014f , -3.24193152f ,
    -5.14372601f , 2.35480301f , 2.57594417f , 3.31674200f , 5.64389287f , 5.57674458f , 3.59322110f , -1.28598587f , -1.68632976f , -2.12796852f , -2.98396833f , -4.09489145f , -4.00821759f , -0.23400052f , 1.27890396f , 0.77129006f , -0.44287462f , -1.47029001f , -2.18546499f , -2.54400987f , -3.37996978f , -1.92988631f , -3.15537156f , -4.51816327f ,
    -0.35333284f , 0.05714033f , 1.24834935f , 0.52566638f , 0.41396899f , 0.74990328f , 0.95628046f , 0.44418709f , -0.34231956f , -0.14250584f , -0.59768493f , -0.64758317f , -0.22890844f , 1.10009034f , 0.66447430f , -1.03679499f , -1.33177125f , 1.17542516f , 2.21270353f , 1.90162759f , 1.20419817f , 0.83319667f , -0.52929949f , -2.16298435f ,
    5.19114552f , 3.69595577f , 2.40462618f , 1.01495594f , 0.03903091f , 0.32991808f , -0.22330707f , -0.60000816f , -0.42237486f , -0.09093864f , 0.19458627f , 0.42022925f , 0.27603710f , 0.12695518f , 0.13428003f , -0.11234558f , -0.07201685f , -0.08582543f , -0.00938781f , 0.00835335f , 0.26546185f , 0.48668790f , 0.55514085f , 0.42743906f
};

const float cdk_37bits_3[1536] =
{
    -0.39555686f , -0.03651739f , -0.44779209f , 0.28023722f , 0.00089126f , -0.66214790f , 2.59448215f , -0.79382669f , -0.12742901f , -0.11647842f , 0.01833394f , 0.16500005f , -0.09845495f , -0.28459353f , -0.36237538f , 0.11970795f , -0.45285373f , -0.10504899f , -0.11812969f , 0.38858637f , 0.86990072f , 0.65514891f , 1.11998296f , 1.21258496f ,
    0.22127561f , 0.04345828f , -0.01534097f , -0.09898785f , -0.26169093f , -1.42940674f , -0.62833523f , -0.43722472f , -0.03759617f , -0.48777744f , -0.21315437f , -0.50978248f , -0.03448283f , 1.37885110f , 2.31984917f , 0.94767797f , -0.60793975f , -1.49725519f , -0.82404584f , -0.79191239f , -0.41285081f , -0.57794113f , -0.59258055f , -0.52142849f ,
    -2.04397465f , -0.73672438f , -1.22406020f , -0.60820965f , -0.66350776f , -0.63508874f , 0.11396081f , 0.27852903f , 0.02122066f , -0.36929472f , -0.09692458f , -0.59306388f , -0.03445818f , 0.22347759f , 0.50874437f , 0.79690333f , 0.44886168f , -0.21185937f , -0.22593929f , 0.10528155f , 0.46293555f , 0.91816687f , 0.81749785f , 0.52952675f ,
    -0.83745738f , -1.08740279f , -0.81741019f , -0.19035650f , 0.26494816f , -0.53562479f , 0.07089504f , 0.57372383f , 0.54761482f , 0.03039794f , -0.04447253f , 0.12483594f , 0.21652272f , -0.29093744f , -0.18196704f , -0.42015965f , -0.35529408f , -0.64256034f , -0.65492788f , -0.67987885f , -0.90903026f , -1.04259245f , -1.11997561f , -1.06502927f ,
    0.35909764f , -0.87235994f , -0.84471723f , -0.71941795f , -0.63106065f , -0.13584873f , 0.00035122f , 0.92117956f , 0.23226720f , 0.38257788f , 0.53266968f , 1.00892757f , -0.01254911f , -0.72578637f , -0.87564652f , -0.59001429f , -0.10713772f , 0.64583948f , 2.23457520f , 2.05203337f , -1.05813794f , -0.53728713f , -0.98376127f , -2.32960660f ,
    -0.37609544f , 0.57819159f , 0.36973473f , -1.59244337f , -1.38928585f , 0.17356612f , 0.05708517f , 0.55433790f , 0.59850517f , 0.28868283f , 0.11861574f , 0.18433235f , -0.05806802f , -0.05763413f , -0.27751060f , -0.18177730f , -0.00964178f , -0.38778247f , -0.57380279f , -0.56566098f , -0.62571613f , -0.59413960f , -0.61423645f , -0.79876589f ,
    0.83478463f , -0.27534215f , 0.01524335f , -0.21639948f , -0.24423974f , -0.23618527f , -0.33317320f , -0.47935624f , -0.15249438f , -0.20363495f , 0.10344548f , -0.31742304f , -0.80171882f , -0.52313955f , 0.00839865f , 1.52844134f , 1.65181493f , -1.32088237f , -0.92249349f , -1.06298456f , -0.07484235f , -0.16968152f , -0.27904781f , -0.28263495f ,
    -0.35596324f , 0.22314830f , 0.17976713f , 0.03198763f , -0.12387166f , 0.15347508f , -0.07824379f , -1.73831583f , 0.24945724f , 0.50825939f , 0.37505775f , 0.09671258f , -0.42450737f , -0.00807859f , 0.43247130f , 0.47374177f , 0.08198413f , -0.17182369f , -0.24951122f , -0.40607268f , -0.34400714f , -0.49624679f , -0.37255649f , -0.39973249f ,
    -1.17006196f , -0.13172492f , -0.00974038f , 0.34580927f , -0.44057385f , 0.93062397f , 0.69327166f , 0.08607482f , -0.08210773f , -0.04718499f , -0.07694656f , -0.11915558f , -0.27321781f , -0.38372565f , -0.17058554f , -0.11705279f , 0.00039928f , -0.05191028f , -0.21529579f , -0.57393337f , -0.82568921f , -1.24107379f , -1.47599343f , -1.53248379f ,
    -0.21719645f , -0.19291913f , -0.75004495f , -0.71951649f , 0.47553953f , 1.38096577f , 1.04033311f , -0.03221815f , -0.86572179f , -0.39911324f , 0.01402460f , 0.13262858f , -0.09635214f , 0.32714710f , -0.23837385f , -0.85773163f , -0.88110961f , -0.98073890f , -0.79564795f , -0.61482268f , -0.51303751f , -0.17108237f , 0.13139182f , 0.33062304f ,
    -0.65971615f , -0.36376531f , -0.48204612f , -0.96580829f , -0.38529047f , -0.02620179f , -0.58558478f , -0.71688128f , -0.19952990f , -0.35258890f , 0.23812036f , 0.76018967f , 0.76511691f , -0.04406894f , 0.27021687f , 0.17352452f , 0.10253468f , 0.11128335f , 0.11180254f , 0.02374565f , 0.06920751f , 0.16750231f , 0.07976935f , 0.01873091f ,
    -0.56879426f , -0.30163117f , -0.21853853f , -0.53731934f , 1.94762983f , -0.40486765f , -0.45665477f , -0.68446479f , 0.29429121f , 0.03909750f , 0.15870855f , 0.44189594f , 0.50054032f , -0.21856641f , -1.18939515f , -0.79884717f , 0.37048428f , 0.68697692f , -0.60894758f , 0.22049746f , -0.40599348f , -0.85599586f , -1.02469575f , -1.24963523f ,
    -0.59195437f , -0.70945563f , -0.15260636f , -0.11149946f , -0.27565596f , -0.07645921f , 0.39497828f , 1.24678661f , 1.18358424f , 0.31430952f , -0.55975403f , -1.31101207f , -0.69091358f , 0.28078628f , -0.21792173f , -0.25137229f , -0.03764299f , -0.16055917f , -0.23425462f , -0.30830760f , -0.03132299f , -0.07131420f , 0.12064408f , 0.03452070f ,
    0.64730537f , 0.25294955f , 0.59073653f , -0.02889400f , 0.46909137f , 0.64173464f , 0.30648456f , 0.11024926f , 0.62116350f , 0.28226056f , 0.21516616f , -0.18069190f , -0.26872093f , -0.28573023f , -0.55069608f , -0.59818666f , -0.76225667f , -0.64631598f , -0.73617734f , -0.72489209f , -0.60849158f , -0.66871466f , -0.59332250f , -0.53455648f ,
    -0.07107892f , -0.12362226f , -0.21667130f , 0.08342061f , -0.26377510f , -0.22955671f , 0.28415481f , -0.59587984f , 0.76501116f , 0.53927870f , -0.41773182f , -0.62604889f , 1.72550145f , 0.83771852f , -1.09720899f , -0.92889980f , 0.00835226f , -0.53818200f , -0.40166509f , -0.77584442f , -0.86058879f , -1.07506625f , -0.75645733f , -0.37900991f ,
    -0.86391437f , -1.56875806f , -0.59737022f , 1.47103303f , 0.58013388f , -0.61125685f , 0.21215056f , -0.82381155f , -1.02435909f , 0.44360022f , 0.46674660f , -0.24399003f , 0.05535292f , -0.13537148f , 0.53716959f , 0.38570703f , 0.15789830f , 0.82344300f , 0.71725375f , -0.08478097f , -0.19045110f , -0.30913951f , -0.71208241f , -0.41211249f ,
    0.28300838f , 0.07819052f , -2.59554850f , 0.01513969f , 0.02275068f , -0.41900901f , 0.35308403f , -0.22328483f , -0.08406000f , -0.23448738f , -0.01463282f , 0.10979483f , 0.06169874f , 0.11653196f , 0.19591528f , 0.38801499f , -0.27219161f , -0.03580387f , -0.39412610f , -0.54966348f , -0.43187400f , -0.26346025f , 0.10805189f , 0.47603876f ,
    -0.44926755f , -0.27303642f , -0.70688129f , -0.60385437f , 2.03834457f , -0.29886385f , -0.37220015f , -0.40157890f , 0.00114372f , -0.55682607f , 0.18940701f , -0.90851567f , -0.11558088f , -0.30509965f , 0.37725906f , 0.36395947f , -0.01158594f , -0.11778388f , -0.08166158f , -0.00099729f , -0.03361890f , 0.17877023f , 0.46953351f , 0.60661120f ,
    -2.32090231f , 0.31006497f , 0.43589911f , 0.16050441f , 0.04916749f , -0.07132427f , -0.10907864f , -0.15235030f , -0.34310944f , -0.38589894f , -0.22420356f , 0.28262581f , 0.26288112f , 0.10104567f , 0.30661547f , 0.15586639f , 0.12838052f , 0.16339047f , 0.31122445f , 0.21703946f , 0.05094335f , -0.36066770f , -0.52001051f , -0.85195920f ,
    0.81157773f , -0.87377611f , 0.35897335f , 0.97922466f , 0.21161336f , 0.61189108f , 0.09975497f , 0.85557541f , 0.44633554f , -0.06799683f , -0.82196168f , 0.18733624f , -0.11555839f , -0.46227977f , -0.84455317f , -0.28718848f , 0.18823232f , 0.02081597f , 0.20496005f , -0.18321698f , -0.53186346f , -0.76751019f , -0.82707771f , -0.93511852f ,
    -0.62789782f , -1.02899916f , -0.83398776f , 0.34736659f , -0.82847318f , -0.55517102f , 0.73944715f , 0.51603042f , -0.17541205f , -0.51297491f , -0.28031225f , 0.37534747f , 1.33255256f , 0.85299363f , -0.49866574f , -0.70931713f , -0.25347802f , 1.18650471f , 0.96320283f , 0.17951998f , 0.50223738f , 0.94745145f , 0.71031145f , 0.35981922f ,
    0.25960499f , 0.20085615f , 0.66071489f , -0.39300998f , -1.04584452f , 0.68763487f , 0.24341422f , -0.44681709f , -0.42478638f , 0.35809846f , 0.23651606f , 0.24690213f , 0.02840220f , 0.15533695f , 0.09128538f , -0.06270472f , -0.06713015f , -0.25335122f , -0.38172369f , -0.13095063f , 1.38549753f , 1.56595584f , -0.79491152f , -1.69456364f ,
    0.10124015f , 0.44268052f , 0.41947170f , 0.06998858f , -0.44403538f , -0.53833083f , -0.18012515f , 0.19801548f , 0.02848198f , 0.10328039f , 0.05547373f , -0.08134220f , -0.11347284f , 0.18716972f , 0.15052121f , 0.45578915f , 0.17825613f , -0.62982728f , -1.25893192f , -1.72372974f , -1.52843742f , -1.14720248f , -0.59782030f , 0.41304965f ,
    -0.65791072f , 0.50448348f , -0.22790188f , 0.65577284f , -0.41604305f , 0.48294798f , -0.01782262f , 0.11258538f , 0.45414723f , 0.46990532f , 0.18373223f , -0.25480101f , -0.03967844f , 0.14242292f , -0.18186310f , -0.44759830f , -0.48848859f , -0.23499694f , -0.00449827f , 0.06947204f , 0.24366262f , 0.18799436f , 0.16493984f , 0.07341900f ,
    -0.17084500f , -0.52693384f , -0.15426250f , -0.36638752f , -0.08888879f , 0.42508938f , 0.70488045f , 0.35337658f , -0.31440288f , -0.95905412f , -1.39777356f , -0.73044215f , -0.21780251f , 0.16276937f , 1.17947648f , 0.62166831f , 0.26018916f , -0.29948472f , -0.58195133f , 0.45241574f , -0.06192729f , -0.35749657f , -0.32541389f , -0.31290178f ,
    1.03333306f , -1.91050021f , -0.13109130f , -0.32248959f , -0.38101335f , 0.00494321f , -0.25107010f , -0.01681079f , 0.21943144f , 0.25121705f , 0.18563785f , 0.03636768f , -0.10100837f , 0.06649688f , -0.00664293f , 0.05595170f , -0.06422094f , -0.11002354f , -0.10109236f , 0.01090687f , 0.06631093f , 0.07976458f , 0.15739108f , 0.10857007f ,
    -0.33199571f , -0.56448889f , -0.45287501f , -0.05693402f , 0.05942782f , -0.02093585f , -0.20271071f , 0.55906399f , -1.15218041f , 0.70760814f , 0.15200578f , 0.36721991f , -0.31006992f , 0.02414406f , 0.01873367f , -0.06168544f , -0.14084190f , 0.06391549f , -0.04024367f , -0.07702959f , -0.02899824f , -0.00754099f , 0.01931078f , 0.01310811f ,
    0.69225346f , 0.84703204f , -0.19222695f , 0.59171381f , 0.90355259f , 1.04460186f , 0.42894358f , -0.70178829f , -0.37391764f , -0.32821766f , -0.50107079f , -0.39470843f , -0.47521936f , -0.30884997f , -0.01935248f , 0.29822241f , 0.42715252f , 0.30438803f , 0.02378992f , -0.17775730f , -0.46267559f , -0.55927080f , -0.39468999f , -0.38547224f ,
    0.04236230f , 0.43024591f , 0.23320886f , -0.03322528f , 0.26547627f , 0.40419917f , -1.88256953f , 0.33336965f , 0.43032431f , 0.34945524f , 0.14640688f , 0.26111890f , 0.09050959f , 0.02378679f , 0.10374918f , -0.14167201f , -0.38323030f , -0.20424346f , -0.07877651f , -0.15358523f , -0.29084030f , -0.28534203f , -0.27854188f , -0.38414543f ,
    -1.35067299f , 0.93458694f , 1.52963743f , -0.47674751f , 0.63038639f , 0.04082455f , 0.01396927f , 0.26394766f , 0.21929233f , 0.30917185f , -0.05098944f , -0.21646126f , -0.06968916f , -0.21403511f , -0.42684368f , -0.24236372f , -0.25734336f , -0.24137196f , -0.18847818f , 0.05790433f , 0.47029098f , 0.74262516f , 1.02334770f , 1.07200952f ,
    1.83813338f , 0.07329820f , -0.57353904f , -1.04253446f , -0.37247340f , 0.27885340f , -0.44127016f , -0.52596624f , -0.25949219f , -0.21831662f , -0.08737252f , 0.35876725f , 0.27309909f , 0.22976268f , 0.34570166f , 0.21284816f , 0.20626047f , -0.06110003f , -0.17056277f , -0.33205968f , -0.17877150f , -0.36375995f , -0.42667310f , -0.49148755f ,
    -0.22303223f , -0.61782734f , 0.07221479f , 1.17445515f , 2.13609068f , 1.76589885f , -0.17154121f , -0.54143140f , 0.11077396f , -0.12473649f , -0.52786787f , -0.05194147f , -0.44717763f , -0.76381778f , -0.72611078f , -0.52076079f , -0.13782787f , 0.23657528f , 0.01943847f , 0.24767381f , 0.39174174f , 0.63263104f , 0.63997347f , 0.76935917f ,
    0.38916423f , 0.50423553f , -0.21980701f , -0.78548685f , 0.21972204f , -1.43872473f , -0.00193477f , 0.36744541f , 0.16700668f , 0.15377980f , 0.47950705f , 0.29978828f , -0.11417606f , 0.16176485f , -0.11482538f , -0.05361745f , -0.12586636f , -0.09325236f , -0.14811836f , -0.05048373f , 0.10243041f , 0.21861802f , 0.33250117f , 0.27345191f ,
    -0.16468513f , -0.37910979f , 0.57141664f , 0.42620144f , 0.44428971f , -0.54448346f , -0.05612505f , -0.02298608f , 0.53916950f , 0.25456592f , -1.10661655f , 0.40146315f , 0.12765698f , 0.17879679f , -0.07731271f , 0.01866167f , -0.15740825f , -0.28894193f , -0.34340439f , -0.43682656f , -0.22326149f , -0.09309579f , 0.16725751f , 0.19673331f ,
    -0.65757909f , -0.55769769f , 0.11252773f , -0.72975912f , -0.94079760f , -0.62713476f , -0.11981244f , -0.17247533f , -0.14738685f , -0.31158412f , 0.07368734f , 0.03103339f , -0.13215125f , 0.34103810f , 0.63393867f , 0.60552884f , 0.76554800f , 0.90960605f , 0.91659500f , 0.66527593f , 0.30424524f , 0.11961615f , -0.11209393f , -0.30051986f ,
    -0.82645253f , -0.59100209f , 0.39970568f , 0.22244794f , -1.28440435f , -0.46429652f , -0.43824168f , -0.32298820f , 0.10465933f , 0.69271672f , 0.92760147f , 0.82494517f , 0.34287482f , 0.34953026f , 0.02628626f , -0.35943701f , -0.39877485f , -0.31291814f , -0.37557165f , -0.14676958f , -0.17425675f , -0.18461930f , -0.05110559f , -0.07497296f ,
    0.63983165f , -0.34339191f , -1.28647231f , -0.91450456f , -0.67728709f , 0.49126298f , 0.96821534f , 0.31300605f , 0.20917849f , 0.12659990f , -0.36342261f , -0.39963395f , 0.03244120f , -0.41837324f , -0.14271340f , -0.19770449f , 0.05878109f , 0.55231761f , 1.04404725f , 1.05536545f , 0.78016416f , 0.27780151f , 0.09224589f , -0.32156570f ,
    1.30003273f , 1.10615566f , 0.93319181f , -0.31410562f , -1.16956697f , 0.45520743f , 0.46104645f , 0.18090068f , 0.31535574f , 0.12164263f , -0.04591607f , -0.26863484f , -0.02921210f , -0.15765476f , -0.25295046f , 0.08951494f , 0.29990800f , 0.46529486f , 0.49388104f , 0.48334578f , 0.56975339f , 0.86976618f , 0.99832143f , 1.00030209f ,
    -0.55945569f , -0.48562099f , -0.51312465f , 0.17718364f , -0.05557705f , -0.12420531f , -0.24644329f , -0.21879889f , 0.30085953f , 0.00211036f , -0.18180571f , 1.26296385f , 0.36245046f , -1.20467536f , -1.38107334f , 0.51651968f , 0.96691210f , -0.21489415f , -0.08106702f , 0.07733171f , 0.44486220f , 0.65985117f , 0.65337579f , 0.40205936f ,
    -0.30605618f , 0.02127030f , 0.13771863f , 0.12191376f , 0.08563477f , -0.00381708f , -0.81881216f , -0.82260335f , -0.43603699f , 1.36965455f , 4.16686363f , -1.70970343f , -0.32019699f , -0.11951735f , -0.80947648f , -0.47446757f , -0.10775129f , 0.04114059f , -0.30054633f , 0.64175035f , 0.82115142f , 0.62944370f , 1.08179899f , 1.57667179f ,
    -0.66788387f , -0.77237720f , 1.52623021f , 0.85040444f , 0.35492746f , 0.85358404f , 0.78207517f , 0.43130368f , -0.54845102f , -0.71654944f , -0.60068901f , -0.12408427f , -0.01179498f , 0.53882278f , 0.31915828f , -0.32987316f , -0.94788725f , -0.40099308f , -0.01063294f , -0.38326806f , -0.01161978f , -0.21941390f , 0.02258487f , 0.25904448f ,
    0.79869030f , -0.85517012f , -0.65115608f , -0.04355956f , -0.43731619f , -0.71616470f , -0.30302847f , 0.88809204f , 0.05112801f , 0.10303432f , 0.13671577f , 0.57965072f , 0.32487238f , 0.33649929f , 0.01540811f , -0.25814148f , -0.72026311f , -1.15836561f , -1.20004844f , -0.81812408f , 0.41446837f , 1.03057194f , 1.42461866f , 1.82616342f ,
    0.17675536f , -0.27924845f , 0.71723708f , 0.57533161f , -0.11526653f , 0.43395839f , -0.24166179f , -0.76071716f , -1.50945411f , -1.22484500f , -0.26852216f , 1.13903054f , 1.01376035f , 0.64844913f , 0.40121308f , 0.49004723f , -0.00594971f , -0.16285024f , -0.35446584f , -0.43396060f , -0.49929653f , -0.30312166f , -0.52537515f , -0.70337166f ,
    -0.01631724f , 0.04545139f , 0.53843851f , -1.98110624f , 0.42385228f , 1.10982161f , 0.08204933f , -0.22120343f , 0.22170428f , -0.13084571f , -0.38312127f , -0.33942169f , -0.35304155f , -0.04620752f , -0.20644844f , -0.11783954f , -0.03944293f , 0.22733974f , 0.19411990f , 0.20591734f , 0.35857215f , 0.26680777f , 0.13225980f , 0.03751274f ,
    1.65876005f , 0.44487285f , 0.74939639f , 0.18365303f , -0.43020202f , -0.60237220f , -0.25419435f , 0.68333923f , 1.41188058f , 0.97222943f , 0.24472516f , -1.22113362f , -0.78612825f , -0.11991861f , 0.13256744f , -0.36248959f , 0.33181909f , 0.32143886f , 0.23857089f , 0.00232431f , 0.32728111f , 0.18236067f , 0.19458883f , -0.13449373f ,
    1.01250205f , 0.78159362f , 0.01261799f , 0.68249798f , 0.04319542f , 0.35059328f , 0.74464616f , 0.84844350f , -0.11329224f , 0.41294739f , 0.18293144f , 0.20984708f , -0.58769014f , -0.80150375f , -0.51500468f , -0.35048400f , -0.42362303f , -0.36779032f , -0.28994050f , -0.23359131f , -0.06578403f , -0.05881381f , 0.08966738f , 0.00019544f ,
    0.70403072f , 0.78285193f , 0.28511894f , 0.00755209f , -0.37995087f , -0.72155263f , -0.99707384f , -0.74737344f , -0.22877183f , -0.13565785f , -0.46966212f , 0.04900542f , 0.26640966f , 1.14596859f , 0.60401715f , 0.82513938f , 0.79006003f , 0.37851130f , 0.22098744f , 0.20295618f , 0.31645545f , 0.57600633f , 0.77757957f , 0.75482137f ,
    -0.31257984f , -0.82866492f , 0.10257062f , 1.11051690f , -0.28919177f , -0.56055958f , -0.92349260f , 0.14536629f , 0.59860128f , 0.38979660f , 0.36223511f , -0.54044378f , -0.36717720f , -0.11683797f , 0.76699709f , 0.24571187f , 0.28893468f , 0.47314073f , 0.42211323f , 0.40023200f , 1.13398057f , 1.09318885f , 0.78306966f , 0.51052587f ,
    0.64453179f , 0.37582288f , -1.11900539f , 0.74031316f , 1.04873921f , -0.40828504f , -0.81838582f , -0.17966094f , -0.05226590f , -0.65864031f , -0.31516753f , 0.18237239f , -0.05159927f , 0.21789484f , 0.08749049f , 0.24120803f , 0.70600965f , 0.64124786f , 0.42083380f , -0.09773141f , -0.23606513f , -0.38900548f , -0.47036719f , -0.54328594f ,
    0.19215906f , 0.37207957f , 0.52832092f , -0.35006098f , 0.09333668f , -0.08723831f , 0.13342910f , 0.37870962f , 0.31836369f , -1.28479417f , 0.33703877f , 0.14237789f , 0.05993876f , 0.02873350f , 0.23865068f , -0.04501394f , -0.31343410f , -0.18101341f , -0.24548541f , -0.25187640f , -0.07255855f , -0.10957046f , -0.11231929f , -0.28412748f ,
    -0.68394190f , 1.32649088f , -0.20251428f , 0.26341125f , 0.12047780f , -0.18276225f , 0.16509523f , 0.52338615f , 0.59701878f , -0.23303681f , -0.39329168f , -0.08757063f , -0.16628726f , -0.65649992f , -0.39211601f , 0.17386600f , 0.53243333f , 0.71723255f , 0.49078614f , 0.24827219f , 0.06289971f , -0.05734434f , -0.11833561f , -0.22187979f ,
    0.39633308f , 0.04156044f , 1.06101733f , 0.27315319f , 0.59336180f , -0.53703174f , 0.16228868f , 0.13114487f , 0.27822076f , 0.36752801f , 0.19860881f , 0.02973693f , -0.43825412f , -0.58401569f , -0.28187681f , 0.04818616f , 0.03285983f , 0.13037889f , 0.11038839f , 0.02272515f , -0.23535124f , -0.61140662f , -0.80591081f , -1.04033145f ,
    -0.13968644f , -0.06564459f , 0.18157254f , 0.33968636f , -1.65427724f , -0.73513587f , 1.04378907f , 1.88232308f , -0.37664399f , -0.27362352f , -0.33476530f , 0.38907833f , 0.34755286f , -0.33257534f , -0.02008915f , 0.33980081f , -0.27671777f , -0.19240561f , -0.07016053f , 0.46780800f , 0.13346733f , 0.34947591f , 0.60154010f , 0.24323917f ,
    -0.39262699f , 0.20645882f , 0.64129296f , -0.83583673f , -0.02829965f , -0.15644726f , 0.05838216f , 0.14551091f , 0.14988963f , 0.11803820f , -0.32326940f , 0.68272158f , 0.31487041f , 0.19785659f , -0.39751586f , -0.35328008f , -0.40849303f , -0.08677978f , 0.86709071f , 2.23822727f , 1.53306955f , 0.78362429f , -0.23530753f , -0.72391215f ,
    0.65081318f , -0.18880278f , -0.46498433f , 0.26852197f , -0.77114484f , 0.03361544f , -0.35148506f , 0.22060019f , 0.18248041f , -0.12293613f , -0.11807126f , 0.14429704f , 0.05679295f , 0.22972542f , 0.12354306f , 0.16318102f , 0.20910602f , 0.08354589f , -0.24387542f , -0.29604028f , -0.70475015f , -1.05341049f , 0.01797512f , 4.10874675f ,
    0.45835477f , 0.01993812f , -0.04065773f , -0.15665852f , -0.42264630f , -0.36060614f , -0.43907429f , -0.66069837f , -0.24237031f , 0.15215315f , 0.03612217f , 0.24708032f , 0.55884560f , 0.72918318f , 1.75786010f , -0.70099106f , -0.65499421f , 0.89851270f , 1.07676113f , 0.70864260f , -0.27784651f , -0.35596115f , -0.12995875f , 0.20579609f ,
    0.41191636f , 0.62621815f , 0.09298962f , 0.55341001f , 0.56857786f , 0.43563939f , 0.36112747f , 0.91004762f , -0.20875537f , -0.76286980f , -0.80355493f , -0.57667740f , -0.12055277f , 0.03202311f , 0.30982039f , 0.02801005f , -0.17407837f , 0.00238884f , -0.00072431f , 0.20627903f , 0.75917669f , 0.94538134f , 1.07598898f , 1.25330200f ,
    1.62660683f , -0.09939473f , 0.66227464f , 0.58551798f , 0.70671700f , 0.17084690f , -0.20901679f , -0.40736809f , -0.48424703f , 0.03110675f , 0.17837373f , 0.15654547f , 0.05523718f , -0.00011673f , -0.03885655f , -0.10282160f , -0.05607837f , -0.02472319f , -0.02603773f , 0.16068736f , 0.49195589f , 0.53877406f , 0.64916929f , 0.58349185f ,
    -0.19541004f , 0.72348145f , 0.18424396f , -0.24664098f , -0.06871482f , 0.69420972f , 0.47406100f , -0.17312110f , -2.04415513f , -0.25411034f , -0.27524224f , 0.06647737f , 0.24326809f , 0.16942888f , 0.40718778f , 0.35988573f , 0.40128652f , 0.49142944f , 0.60191512f , 0.34882977f , 0.16989975f , 0.24984840f , 0.27163863f , 0.15321543f ,
    -0.44196663f , -0.26819397f , 0.67190611f , -0.18646133f , 0.45381660f , 1.11913414f , -0.16504930f , -0.57004245f , 0.12959909f , 0.01138749f , -0.36040681f , -0.97442716f , -0.87831396f , -0.14292832f , 0.42648657f , 0.25148162f , 0.69831357f , 1.48191698f , 1.27272976f , 0.11336886f , -0.87051097f , -0.59490814f , -0.81852032f , -1.19619968f ,
    -0.25757408f , 0.54305128f , -0.79688385f , -0.60924273f , -0.12316087f , 0.11158591f , -0.87972153f , -0.44243737f , 0.18336137f , 0.70958050f , 0.65996224f , -0.03788380f , -0.46562482f , -0.32237563f , -0.18491199f , 0.26669422f , 0.52467917f , 0.59451930f , 0.79600063f , 0.90689924f , 1.13895471f , 1.44288125f , 1.66630190f , 1.46406996f ,
    0.88003703f , 2.56458597f , 1.71193850f , 1.65285002f , 0.72084892f , 0.38643126f , 0.14318446f , 0.28667315f , -0.19288261f , -0.16566274f , -0.31005972f , -0.49025502f , -0.18453165f , -0.14612403f , -0.04808515f , 0.01128747f , -0.01064585f , -0.12855927f , -0.22958706f , -0.19555403f , 0.02963856f , -0.01023782f , -0.12652262f , -0.10513883f ,
    0.66279753f , 2.42221261f , -0.08766251f , -0.72413474f , -0.21245882f , -0.28173391f , -0.45644329f , -0.27322613f , -0.26135706f , -0.00095259f , 0.27722008f , 0.50181970f , 0.53741922f , 0.02301582f , 0.05101261f , 0.08308112f , 0.01205931f , 0.03237543f , -0.19025538f , -0.25886072f , -0.65187116f , -0.67398548f , -1.14025176f , -1.58932661f ,
    0.17921058f , 0.08258647f , 0.33959227f , 1.72037280f , 1.38344521f , -0.23430972f , -0.50065409f , 0.00856925f , 0.28114664f , 0.27461748f , 0.31709158f , 0.82901212f , -0.15113492f , -0.25813352f , -0.41877594f , -0.81233724f , -0.71788760f , -0.16907758f , 0.19973863f , 0.33985209f , 0.02718327f , 0.32739235f , 0.74128769f , 0.93245569f
};

const float cdk_37bits_4[1536] =
{
    -0.08826527f , -0.68186913f , 0.10838073f , -0.43643363f , -0.41527175f , -0.55730727f , -0.34319791f , -0.40335689f , -0.41236590f , -0.43762241f , -0.34979692f , 0.20670516f , 0.56648629f , 0.45153526f , 0.24057949f , 0.52851143f , 0.92657151f , 0.59941681f , -0.15803439f , -0.97113347f , -0.53306250f , -0.15122053f , -0.25212109f , -0.21018566f ,
    0.39520775f , -0.06876283f , -0.05296158f , 0.73104266f , 1.42403499f , 0.45421406f , -0.17043922f , -0.74733849f , -0.66305214f , -0.55365607f , -0.35289753f , -0.04055727f , -0.10593728f , -0.05024752f , 0.12627425f , 0.32227232f , 0.35862945f , -0.33025092f , -0.42097571f , -0.51789189f , -0.43150446f , -0.42237163f , -0.31356874f , -0.35919061f ,
    -1.66468995f , 0.28333893f , -0.63138470f , 0.25282895f , 0.81464016f , 0.43544261f , 0.16598498f , 0.21343499f , 0.04430694f , 0.04005313f , -0.09506983f , -0.40633891f , -0.37109338f , -0.10155129f , -0.25586130f , -0.50829977f , 0.02467106f , -0.22449907f , 0.00822338f , 0.18455191f , 0.25447269f , 0.12288496f , -0.09567011f , -0.30095943f ,
    -1.15666522f , -0.30930290f , 0.13432561f , -0.59224171f , -0.36982119f , -0.52250238f , 0.01911206f , -0.29889977f , 0.45230096f , 0.40142558f , 0.43793893f , 0.22627276f , 0.37598261f , 0.32984874f , -0.34803841f , -0.44638526f , -0.25723637f , -0.50369445f , -0.26783820f , -0.30872225f , -0.55499601f , -0.40533391f , -0.26323584f , -0.01148310f ,
    -0.04584967f , -0.38971238f , -0.56823951f , -0.32006352f , 0.38538708f , 0.18254611f , -0.62235892f , 0.18540613f , 0.48716625f , 0.35551317f , -0.19313758f , 1.16846919f , -0.41238633f , -0.43448740f , -0.28924472f , -0.56314872f , -0.24952920f , -0.08133851f , -0.17676199f , -0.70674324f , -0.52120829f , -0.49147628f , -0.40464508f , -0.25295616f ,
    -0.12422787f , -0.29459301f , -0.33474318f , 0.11311031f , -0.95766270f , 2.14261486f , -0.53791490f , -0.26163905f , -0.11342229f , -0.12540336f , -0.14724319f , -0.04078408f , -0.08162598f , 0.06846590f , 0.12489534f , -0.11390681f , 0.04214135f , -0.23484961f , -0.25483115f , 0.02702444f , -0.54449830f , 0.02294024f , -0.03270780f , -0.30881716f ,
    -0.51664184f , 0.87599163f , -0.82321314f , -0.48734917f , -0.18432637f , -0.09096773f , 0.20625230f , -0.20173932f , -0.40150868f , -0.29584636f , -0.57602568f , 0.25241069f , 0.25168301f , 0.41489722f , -0.15401326f , 0.31749293f , 0.46187393f , 0.14218968f , 0.29387424f , 0.35642876f , -0.05757794f , -0.25296762f , -0.36044236f , -0.53221886f ,
    0.51447760f , -0.80338660f , -0.87861055f , 0.14544497f , 0.05095110f , -0.51385736f , 0.05449902f , 0.17409103f , 0.19329486f , -0.46366308f , -0.07068299f , 0.20485704f , -0.47646816f , 0.35635013f , 0.34452862f , 0.42683101f , -0.28134904f , -0.21080113f , 0.00849886f , 0.33035851f , 0.26195824f , 0.51184835f , 0.52439902f , 0.46235637f ,
    0.32433320f , -0.77116443f , -0.37467928f , -0.05050502f , -0.47203456f , 0.07970732f , 0.03804198f , -0.34236150f , 0.41937760f , 0.42124343f , -0.03903765f , -0.03019702f , -0.13800061f , -0.47850547f , -0.79736222f , 0.61109423f , 0.72782314f , -0.09672306f , -0.16557727f , 0.16492016f , -0.11908040f , -0.37060885f , -0.80248368f , -1.06315439f ,
    0.61844207f , -0.52687155f , -0.68500569f , 0.65092780f , 0.43851285f , -0.21063978f , -0.35770140f , 0.29858871f , -0.24062148f , 0.02631244f , -0.33422324f , -0.66271400f , 0.44374236f , 0.53668473f , 0.31036600f , -0.08124190f , -0.16668944f , -0.32551675f , -0.33450272f , -0.55269795f , -0.29912814f , -0.14136754f , 0.00094991f , 0.10863138f ,
    -1.02908550f , -1.08600196f , -0.00829438f , -0.14868032f , -0.00876750f , 0.35258516f , 0.23126957f , -0.61722565f , 0.07518664f , 0.16350336f , -0.12544307f , -0.06302285f , -0.20747087f , 0.16364178f , 0.11301830f , 0.14409114f , -0.22179807f , 0.02183975f , 0.08651544f , 0.10457808f , 0.28231708f , 0.45543402f , 0.44769940f , 0.39725637f ,
    -0.54707227f , -0.02419958f , -0.37616905f , -0.46877412f , -0.64214865f , 0.24761536f , 0.28016618f , 0.62399842f , -0.01700123f , -0.06949885f , -0.19266995f , 0.09365999f , 0.49890228f , 0.24080752f , 0.23087678f , -0.34184149f , -0.95236318f , -0.94491904f , -0.91565308f , -0.37099678f , 0.27911164f , 0.41946017f , -0.09527805f , -0.32953030f ,
    -0.01218671f , 0.22317147f , 0.12463154f , -0.28374239f , -0.37139030f , -0.11082455f , -0.20149460f , 0.02373646f , -0.33497796f , -0.14613409f , 0.84054162f , -0.89918850f , 0.07544184f , 0.26598709f , 0.27674891f , 0.20394454f , 0.37767382f , -0.42106119f , -0.34271983f , -0.11246076f , 0.03134837f , -0.21267097f , -0.66433234f , -0.79249183f ,
    0.68565476f , -0.34282863f , -0.68036436f , -0.63475767f , -0.29231604f , -0.10656705f , 0.47040998f , 1.11298872f , 0.05838917f , -0.14239264f , -0.38985619f , -0.25211584f , -0.07283441f , -0.47047779f , -0.10102956f , -0.06816871f , 0.25442684f , 0.17135717f , 0.18068089f , 0.10725115f , -0.11463252f , -0.09624811f , 0.03206543f , 0.07087342f ,
    -0.29936977f , -0.49951612f , 0.56346184f , 1.11727567f , 0.05118005f , -0.78169038f , -0.22318233f , -0.13012064f , 0.42376494f , 0.27511994f , -0.06809198f , 0.10660060f , -0.13063709f , -0.08794603f , 0.26570905f , 0.03292540f , 0.26637413f , -0.19894586f , -0.46401960f , -0.28512188f , -0.39238542f , -0.32134023f , -0.64138162f , -0.88237115f ,
    -0.84203625f , 0.64837205f , -0.17913585f , -0.02044868f , 0.01755708f , 0.10928040f , -0.42224314f , -0.62418953f , -0.76712318f , 0.28173569f , 0.49961967f , 0.56539632f , 0.38946613f , -0.52975196f , -0.01398100f , 0.29168654f , 0.20212686f , -0.45414046f , -0.32780637f , -0.17832453f , -0.04055271f , 0.14063062f , 0.09399186f , 0.04073656f ,
    -0.59723568f , -0.77426417f , 0.23870880f , -1.09302554f , -0.22352372f , -0.10808799f , -0.30228652f , 0.70554939f , 0.06689791f , -0.27543124f , -0.16109074f , 0.39983998f , 0.14600029f , 0.02701649f , -0.30161728f , -0.00219904f , 0.02886825f , -0.00025967f , 0.06332021f , 0.53722019f , 0.26361456f , 0.43646772f , 0.61394343f , 0.42109711f ,
    -0.43760700f , -0.21770975f , -0.32449972f , 0.91826996f , 0.24783245f , -0.14194616f , 0.59717550f , -0.04725228f , -0.61148813f , 0.06530696f , 0.35852872f , 0.21424802f , 0.01537298f , -0.15430889f , -0.27459726f , -0.13011870f , -0.13872373f , -0.36362740f , -0.43974823f , -0.43751521f , -0.54202762f , -0.19719673f , 0.06386372f , 0.18442456f ,
    -0.08864543f , -0.55051998f , 0.10076329f , 0.20816090f , 0.53932942f , 0.15080000f , 0.00551145f , 0.12469664f , 0.10528548f , -0.05291477f , 0.52671815f , 0.10465375f , -0.40110729f , -0.11191133f , 0.98775607f , -0.67510753f , -1.30383213f , 1.28526656f , 0.19125450f , -0.16824100f , -0.63934107f , -0.41185818f , -0.34166262f , 0.14722503f ,
    -0.16958138f , -0.70266121f , -0.61550966f , -0.70951491f , 0.42067433f , -0.58598257f , -0.58567156f , -0.37146356f , -0.36153853f , 0.34830089f , 0.34255947f , 0.14665779f , -0.08274605f , 0.14596150f , 0.21786608f , 0.24560479f , 0.11959326f , 0.23920513f , 0.20309485f , 0.35852167f , 0.22083612f , -0.09433997f , -0.51773984f , -0.76810711f ,
    0.09032751f , 0.42679636f , -0.28534103f , 0.21660665f , 0.47417813f , -0.81135171f , -0.99303930f , 1.17719925f , 0.70112272f , 0.00612786f , -0.26326442f , -0.41083270f , 0.28491165f , -0.02087201f , -0.14822163f , 0.12923365f , -0.12446203f , -0.33986599f , -0.41895285f , -0.31072727f , -0.31061808f , -0.24015583f , -0.23486759f , -0.36395849f ,
    -0.07413177f , -0.34521290f , -0.06577322f , -0.64923405f , 0.33496936f , 0.33223433f , -0.43032623f , -0.15153657f , -0.14532386f , 0.04384948f , -0.14353961f , -0.38067294f , -0.90445571f , 0.05745547f , 0.26321275f , 0.13427661f , 0.99048885f , 0.70150503f , 0.21638320f , -0.53518619f , -0.89368294f , -0.06732509f , 1.44618313f , 1.52346980f ,
    -0.28620228f , -0.41428071f , 0.03283058f , 0.28330900f , 0.28721719f , 0.17075826f , 0.19511151f , -0.13348216f , -0.35836936f , -0.41912925f , -0.65172261f , -0.20553457f , -0.41361716f , 0.03912969f , 0.74818546f , 0.38929433f , 0.35198685f , -0.18892266f , -0.42973273f , -0.08121690f , 2.93312199f , -0.89377191f , -1.04200958f , -0.38574966f ,
    -0.45622789f , 0.07453795f , -0.34784213f , -0.29222109f , -0.09713884f , -0.10453434f , 0.40596355f , -0.23133264f , 0.41138969f , -1.10624661f , 0.19522464f , -0.26295831f , 0.14668871f , 0.07972137f , 0.02069833f , 0.17917700f , 0.36376602f , 0.04686613f , 0.14326025f , -0.04095238f , -0.08246401f , 0.10201219f , 0.02758839f , -0.05655397f ,
    0.29630435f , 0.03831385f , -0.10935451f , -0.91468053f , -0.14403908f , 0.12338524f , -0.16558686f , -0.53411536f , 0.34582072f , 0.52105737f , -0.73269102f , 0.15549081f , 0.34042874f , -0.08059104f , 0.05497700f , -0.00373706f , 0.11991085f , -0.06473005f , -0.19246960f , -0.28678310f , -0.43241128f , -0.23538086f , -0.03713469f , 0.08379386f ,
    0.24034079f , -0.09568759f , -0.02338538f , -0.28961237f , 0.06180378f , 0.64449270f , -0.53964132f , -0.44965638f , 0.57702251f , -0.03990858f , 0.57093562f , -0.24702367f , 0.69686569f , -0.17564347f , -0.35201424f , -0.37152787f , -0.37484725f , -0.30144848f , -0.16064783f , -0.31374403f , -0.12815488f , 0.29541890f , 1.03104505f , 1.30178989f ,
    -0.18534500f , -0.41427735f , 0.20831804f , 0.44386174f , 0.06978829f , -0.00025745f , 0.37126911f , 0.56198427f , 0.54344631f , 0.75983386f , 0.08924900f , -0.25144457f , -0.16739214f , -0.47225391f , -0.61115204f , -0.61044836f , -0.28294647f , -0.15658827f , 0.07254076f , 0.04689538f , -0.03222463f , 0.00609252f , -0.03612525f , -0.09035452f ,
    0.60889737f , 0.57807827f , 0.48410386f , -0.25108080f , -0.40924958f , 0.41713615f , 0.28334831f , 0.28268008f , 0.18075099f , -0.57117890f , -0.14971473f , 0.56189026f , -0.05567028f , 0.08252752f , -0.38305721f , -0.11908417f , -0.11953224f , -0.37400723f , -0.53048221f , -0.67201768f , -0.81958382f , -0.72027064f , -0.69311476f , -0.64712434f ,
    0.22806651f , -0.36466423f , 0.42139538f , -0.34809071f , 0.16113471f , 0.17305177f , 0.79041909f , 0.11514622f , 0.04984584f , -0.14552208f , -0.37364685f , -0.61589400f , -0.26900080f , 0.26941075f , 0.20621872f , 0.13740956f , -0.49840209f , -0.54283296f , -0.52674918f , -0.53961784f , -0.37838808f , -0.22626697f , -0.23072639f , -0.20714483f ,
    0.22144144f , 0.45530098f , 0.02934419f , -0.39899990f , 0.47181905f , 0.60295507f , -0.31589266f , 0.03503805f , 0.49654681f , -0.28248396f , -0.72402223f , -0.56858893f , 0.36486216f , 0.18158649f , -0.28256161f , -0.05020847f , 0.07122169f , 0.39556004f , 0.21779191f , 0.05943418f , 0.03455314f , -0.20122464f , -0.56175660f , -0.70861941f ,
    -0.12710089f , -0.34168755f , 0.51452312f , -0.34309463f , -0.18691030f , 0.49423846f , 0.78364805f , -0.16785659f , -0.68812345f , -0.24302951f , 0.18166059f , 0.09288723f , 0.25148875f , -0.56074443f , -0.33594006f , 0.09135379f , 0.28739172f , 0.63070785f , 0.16827578f , -0.09962802f , -0.38532235f , -0.56717197f , -0.69999986f , -0.97131938f ,
    -0.20318779f , -0.43550878f , 0.28264744f , -0.23992796f , 0.53190281f , -1.67612143f , 0.16592080f , 0.32242290f , 0.02740567f , 0.27409947f , -0.33298480f , -0.17137320f , 0.21066429f , 0.33840225f , -0.04092118f , 0.12976302f , 0.22063896f , 0.16238007f , 0.17740193f , 0.08810713f , -0.07588522f , 0.07136235f , 0.03907713f , 0.05669444f ,
    0.74722369f , -0.21436950f , 0.74573008f , -0.38452217f , -0.62996036f , -0.61276966f , -0.34962832f , 0.01277742f , -0.04862746f , -0.36596994f , 0.22701717f , 0.22604413f , 0.19192867f , 0.43170927f , 0.32434957f , 0.29115238f , 0.30256436f , 0.32053789f , 0.47183832f , 0.56834074f , 0.41355131f , 0.30787160f , -0.05129232f , -0.37603415f ,
    0.80624702f , -0.27464628f , 0.11826867f , 0.51984849f , 0.30134746f , 0.32731312f , 0.63578587f , -1.05098699f , -0.28256566f , 0.33641143f , 0.13788720f , 0.12207550f , 0.20964871f , -0.01396386f , -0.00315097f , -0.38868646f , -0.33190516f , 0.01254611f , 0.31412245f , 0.37172503f , -0.22028709f , -0.31539130f , -0.40227820f , -0.43477628f ,
    0.48923265f , 0.77885034f , 0.09105701f , 0.57339326f , 0.40328303f , 0.76432879f , 0.86958428f , 0.61756568f , 0.03118874f , -0.56167934f , 0.04763708f , -0.27535056f , -0.56173692f , -0.35211845f , -0.21863091f , -0.57438481f , -0.18963688f , -0.01259367f , 0.18407625f , 0.57694011f , 0.26272878f , -0.04854515f , -0.05438820f , -0.03358252f ,
    -0.32142589f , 0.79436655f , -0.02373648f , 0.14911871f , 0.27451076f , -0.21064653f , -0.58233970f , -0.20841755f , -0.04707995f , 0.10160263f , 0.52370023f , 0.13469981f , 0.48437770f , 1.02370491f , -0.06404425f , -0.46008443f , -0.96962303f , 0.11051949f , 0.15222102f , -0.53779110f , -0.69372709f , -0.56309673f , -0.29040815f , -0.29949982f ,
    -0.02231366f , 0.22164658f , -0.18303626f , 0.03930299f , 0.85381138f , -0.35733905f , 0.09213505f , 0.01422806f , 0.45077065f , 0.33125549f , 0.13969212f , 0.00376337f , -1.11355683f , -0.42167326f , -0.19924204f , 0.06780255f , 0.13817913f , -0.13055957f , -0.04191829f , -0.08880165f , 0.10967999f , 0.21611496f , 0.31814813f , 0.31439510f ,
    0.42170246f , 0.33624593f , -0.22613320f , 0.60027671f , -1.43986794f , 0.19361445f , 0.38787661f , 0.02591482f , 0.79456209f , 0.02551988f , -0.24845033f , -0.02790537f , 0.03271750f , -0.04445081f , 0.20502713f , 0.08570910f , 0.00909955f , -0.01248239f , -0.03298340f , -0.22777710f , -0.18913055f , 0.02764977f , 0.28305459f , 0.38851360f ,
    0.25563805f , 0.33212894f , -0.80098121f , 0.09743245f , 0.06159913f , 0.59881048f , -0.33440346f , -0.49422089f , -0.26800689f , -0.34799111f , 0.00914211f , -0.24239391f , -0.35363956f , 0.18782859f , 0.53150753f , 0.27966626f , 0.37170277f , 0.02903349f , 0.11708475f , 0.18129252f , 0.35350094f , 0.51909923f , 0.57702624f , 0.56023430f ,
    -0.25681505f , 0.10481743f , 0.07691052f , -0.09602954f , -0.12447488f , -0.40272478f , -0.23240515f , -0.09172820f , -0.10406663f , 0.06799629f , 0.27877064f , 0.65360435f , 0.03477472f , -0.16610473f , 0.19640957f , 1.14225362f , -1.25460658f , -0.02280781f , 0.26718410f , 0.23326014f , -0.33868542f , -0.77563600f , -0.57910551f , 0.35682550f ,
    -0.44901076f , -0.41537996f , -0.76495288f , 0.42209785f , -0.90605030f , -0.39625885f , -0.28278183f , -0.06062198f , 0.12423915f , 0.20756261f , 0.19484825f , 0.03259953f , 0.41379186f , 0.19062025f , -0.02691834f , 0.12202985f , 0.38700297f , 0.61084418f , 0.41389101f , 0.42854542f , 0.07894843f , -0.08730420f , -0.19947308f , -0.20746447f ,
    0.35263591f , -0.04388326f , -0.07294209f , -0.12542102f , -0.45217599f , -0.41959012f , -0.16900409f , 0.23194458f , 0.50540516f , 0.34564113f , -0.05519304f , -0.13052083f , -0.52610268f , 1.51200111f , 0.14243612f , -0.89107328f , -0.09550049f , -0.11976748f , 0.61738910f , 0.29385419f , -0.11218523f , -0.32931430f , -0.63743116f , -0.70832695f ,
    -0.52572193f , -0.16054333f , 0.67450855f , -0.68123993f , -1.06059852f , 0.25289129f , 0.72282093f , -0.17789928f , -0.04826238f , 0.65623860f , 0.30053556f , -0.04214508f , -0.65996229f , -0.19030221f , -0.07583416f , -0.15972053f , 0.48267006f , 0.29268192f , 0.54289151f , 0.30262687f , 0.55040148f , 0.38139609f , 0.22629776f , -0.10333201f ,
    -0.27722537f , 0.16931190f , -0.18986341f , 0.46255996f , 0.03451865f , 0.64648839f , 0.27927689f , -0.04817246f , -0.29637504f , 0.15848257f , -1.17177626f , 0.76705595f , 0.04986266f , -0.23619169f , 0.02130871f , -0.09247797f , -0.11246955f , -0.06979877f , -0.02858714f , 0.14146741f , 0.19316987f , 0.19281260f , 0.10108870f , 0.10991318f ,
    0.57222024f , -0.09056345f , 0.31630312f , 0.09441631f , -0.48881639f , -0.26079169f , 0.28649904f , 0.47374236f , -0.92331796f , 0.56274886f , 0.19988114f , -0.33923171f , 0.45935192f , 0.66439754f , 0.09172813f , -0.58992377f , -0.13650098f , -0.00871775f , 0.05177348f , 0.29646543f , 0.22271673f , 0.29255650f , 0.32416359f , 0.37254208f ,
    0.69873728f , 0.67827523f , -0.09873129f , -0.19519793f , -0.20388503f , -1.14639862f , 1.00268628f , -0.34199196f , 0.32858454f , 0.30752466f , -0.20180165f , -0.78353972f , -0.46150042f , 0.07066704f , 0.27017563f , 0.59315620f , 0.56514267f , 0.61730776f , -0.04109619f , -0.10375384f , 0.17107510f , 0.00671267f , -0.14460000f , -0.15704504f ,
    -1.08061540f , 0.25499966f , 1.21906248f , 0.18773257f , -0.32071123f , 0.34341071f , -0.31815992f , -0.09070897f , 0.28772196f , -0.36343715f , -0.43262838f , -0.03519430f , -0.08578842f , 0.04235681f , 0.22568464f , 0.41761967f , 0.33042161f , -0.16644760f , -0.20508813f , -0.34930117f , -0.25591130f , -0.03775689f , -0.04290093f , -0.14027967f ,
    0.08954841f , 0.28400971f , 0.09640325f , 0.28015051f , -0.28901197f , -0.15938324f , -0.08647304f , 0.07096579f , -0.01533652f , 0.16784761f , 0.40365967f , 0.69056044f , -0.07072517f , -1.35839862f , 0.69003689f , 0.27081222f , -0.31318076f , -0.34628327f , -0.20433566f , -0.03988210f , 0.00227372f , 0.31880868f , 0.48586232f , 0.50530210f ,
    -0.10787652f , -0.54593003f , -0.06872456f , 0.08196332f , 0.32589906f , 0.59080671f , -0.46869291f , 0.51602298f , -0.65588957f , -1.15841782f , 0.46249030f , 0.28794341f , 0.03773606f , -0.22824300f , 0.08237000f , 0.11514488f , 0.09347876f , 0.31037616f , 0.25764090f , 0.16707290f , -0.00830484f , -0.01436382f , 0.04324129f , 0.08340130f ,
    0.03635043f , 0.84751295f , 0.19029027f , 0.81160060f , 0.30403111f , -0.74745208f , 0.29141206f , 0.02554821f , -0.18681161f , -0.31641374f , -0.22117775f , 0.29307885f , 0.09884843f , -0.01001690f , 0.22991570f , 0.23960184f , -0.00030044f , -0.15515938f , -0.08622738f , 0.18116527f , 0.27032171f , 0.46691225f , 0.50791118f , 0.39209784f ,
    -0.58545217f , 0.80964945f , -0.18596625f , 0.05021434f , -0.60299753f , 0.01922541f , -0.09160450f , 0.71858494f , -0.20405914f , 0.12967029f , -0.19928245f , -0.41958358f , -0.73480796f , 0.27037925f , 0.59526072f , 0.43722623f , 0.08228142f , 0.13617314f , 0.16733195f , -0.17519530f , -0.15926519f , -0.04255070f , 0.08047599f , 0.02040241f ,
    -0.00463376f , 0.49611447f , -1.05764249f , -0.45817246f , 0.34650208f , -0.41315007f , 0.05117591f , -0.11590274f , 0.37210637f , 0.48788495f , 0.24580028f , -0.23874213f , 0.25067272f , 0.14486146f , -0.39195005f , -0.32974271f , -0.40998318f , -0.01004687f , 0.30386464f , 0.58853426f , 0.58687081f , 0.54124172f , 0.43891894f , 0.42482843f ,
    0.06344340f , -0.06291464f , 0.30075410f , -0.01321988f , 0.11824609f , -0.36844623f , -0.22861175f , 0.44459133f , -0.10414380f , -0.41394982f , -0.26948513f , 0.10771022f , 2.01283344f , -0.48227800f , -0.85226571f , -0.05678206f , 0.09386327f , -0.32036269f , -0.09589284f , 0.11469854f , -0.02254415f , 0.26286370f , 0.24740398f , 0.30259810f ,
    0.33675212f , 0.40803791f , 0.04656053f , 0.26235019f , 0.19124535f , 0.26174937f , -0.25007840f , -0.02874094f , 0.42657886f , 0.23713035f , 0.49137649f , -0.40631813f , -0.19729730f , -0.47353514f , -0.68684985f , -0.22225676f , 0.65537217f , 0.85454345f , 0.28736774f , -0.76858865f , -0.51993839f , -0.41223097f , -0.20210503f , 0.20680273f ,
    -0.32962876f , 0.99852252f , 0.90359799f , -0.72414673f , 0.40343042f , -0.04753735f , 0.12703283f , -0.50454354f , -0.49092182f , 0.07106628f , 0.04340118f , -0.20701432f , -0.00051299f , 0.41281149f , 0.48992497f , -0.07229812f , -0.22500199f , -0.38166508f , 0.00136486f , 0.19527238f , 0.46266022f , 0.52478433f , 0.49346943f , 0.55712590f ,
    0.31231089f , -0.39507041f , 0.09233836f , 0.29644040f , 0.63936696f , -0.05632462f , 0.45315617f , -0.80271529f , 0.87935975f , -0.65177909f , -0.03975780f , 0.24344094f , 0.09139584f , -0.12641456f , -0.28974809f , -0.00440121f , -0.33446897f , 0.27455940f , 0.26598867f , 0.38959619f , 0.56355605f , 0.28858433f , -0.01329721f , -0.28521977f ,
    1.21529134f , 0.05567950f , 0.26633834f , 0.01854368f , -0.56750884f , -0.64133765f , 0.12896192f , -0.25287368f , 0.00098562f , 0.46355571f , 0.30342317f , 0.60024559f , 0.45154622f , -0.23111479f , -0.07558175f , 0.04573468f , -0.22655397f , -0.38765071f , -0.39593191f , -0.33701184f , -0.03367326f , -0.00117395f , -0.08805175f , -0.08317989f ,
    0.50206060f , -0.26397493f , 0.62403702f , 0.18840209f , -0.03554397f , 0.51126843f , -0.93620939f , 0.11466485f , -0.32354822f , 0.83573095f , 0.44043951f , -0.03326486f , -0.30990227f , -0.17807718f , -0.15678795f , 0.05137581f , 0.01928613f , 0.10898749f , 0.05153834f , 0.41224367f , 0.33750201f , 0.31515600f , 0.18742162f , -0.00543668f ,
    -0.32506550f , 1.39874024f , 1.05365357f , 0.20758975f , -0.52204159f , 0.23139865f , 0.89916776f , 0.88500307f , 0.58319149f , 0.64447478f , 0.60029914f , -0.39017287f , -0.48396982f , -0.45642499f , -0.41136891f , -0.85726305f , -0.72300890f , -0.76044173f , -0.54961686f , 0.13241207f , -0.38074475f , -0.31668368f , 0.18757575f , 0.89325609f ,
    0.91423867f , 0.16949588f , -0.34930052f , -0.67767124f , 0.56381557f , 0.23625492f , 0.19384698f , 0.11556592f , -0.81768557f , -0.12373743f , 0.28726562f , 0.47434410f , 0.01976064f , -0.20909300f , -0.17968366f , -0.16456765f , -0.39581902f , -0.17030977f , -0.12522965f , 0.10547945f , 0.19050607f , 0.32547806f , 0.37610928f , 0.47194674f ,
    0.50904911f , -0.87540838f , 0.44606989f , 0.16315214f , 0.04897779f , 0.44593548f , 0.58835263f , 0.23188759f , -0.04829018f , -0.47929534f , 0.01140653f , -0.52090906f , -0.08282465f , -0.47750687f , 0.00555375f , -0.02147925f , 0.29824067f , -0.09639830f , 0.04586002f , 0.81704610f , 1.02414420f , 1.00254358f , 0.93128379f , 0.86145793f ,
    1.39640260f , 0.48600888f , 0.05812317f , 0.43032939f , 0.28626623f , -0.02572580f , -0.71026460f , -0.08052560f , -0.00321850f , -0.06166357f , -0.14918683f , 0.02044791f , 0.20449299f , -0.07389050f , 0.20856068f , 0.37499893f , 0.00961555f , 0.34856300f , 0.38826685f , 0.17380148f , 0.08518823f , 0.24834931f , 0.18030421f , 0.02885498f ,
    -0.14822571f , 0.59831391f , 0.80084782f , 0.65079236f , -0.37659866f , 0.02590007f , -0.43987457f , -0.47916614f , -0.09009334f , 0.00944784f , 0.38989625f , 0.72812391f , -0.25740561f , 0.30660597f , -0.10786678f , -0.04283082f , 0.33341247f , 0.56382527f , 0.36883485f , 0.19482792f , 0.20864518f , 0.30357803f , 0.21469035f , -0.00709814f ,
    -0.55721230f , -0.02926194f , 0.02222842f , 0.65955295f , 0.85507986f , 0.02606033f , -0.38236616f , 0.08681374f , -0.37079998f , 0.08312060f , -0.32595363f , -0.28424983f , 0.08744855f , 0.15171748f , -0.41262446f , 0.16415023f , 0.32175904f , 0.54372269f , 1.03276331f , 0.88586548f , 0.61435324f , 0.53755072f , 0.50108183f , 0.43471867f
};

const float cdk_37bits_5[1536] =
{
    -0.08458486f , 0.28094300f , -0.74427850f , -0.27121451f , 0.26225532f , 0.58828870f , 0.49469996f , 0.00671892f , 0.49956583f , -0.09194914f , -0.14439356f , -0.21589493f , -0.71932281f , -0.31712426f , -0.17322443f , -0.02668573f , -0.16316907f , -0.26011802f , -0.29961334f , -0.04510044f , -0.03045680f , -0.07408609f , -0.04966348f , 0.02019735f ,
    0.16785217f , -0.12154415f , -0.11294764f , -0.50188502f , 0.37048745f , 0.01220048f , -0.42438767f , -0.39739743f , -0.09963068f , -0.01937236f , -0.38029066f , -0.09631205f , 0.17779303f , 0.55220057f , -0.27361767f , -0.01993755f , 0.59841836f , -0.81488799f , -0.50629196f , 0.04276219f , 0.50927647f , 0.32204460f , -0.05252335f , 0.00479347f ,
    -0.70183618f , -0.55990950f , -0.21828823f , 0.06948525f , -0.25175959f , 0.38514843f , 0.03565709f , -0.02286728f , -0.65965565f , -0.11708316f , 0.08641334f , -0.03958833f , -0.28740740f , 0.11907652f , 0.76730012f , 0.00002225f , -0.01526722f , 0.19057067f , -0.00116506f , -0.29043894f , -0.20613074f , -0.36670968f , -0.38149597f , -0.21397652f ,
    -0.20108924f , 0.01696758f , -0.63540490f , 0.48931316f , -0.10610658f , -0.30699680f , 0.42198382f , -0.11596909f , 0.56113924f , -0.19428230f , -0.31623064f , 0.01575740f , 0.47412599f , 0.01231773f , 0.03554178f , 0.04445166f , -0.52597131f , -0.38112781f , -0.41082892f , 0.02325108f , -0.03762488f , -0.10886600f , -0.30284977f , -0.25935547f ,
    -0.06153986f , -0.50865639f , 0.00873904f , -0.53985972f , -0.17321488f , -0.20024719f , -0.43903590f , 0.30867295f , 0.15257025f , 0.50412756f , 0.15585453f , 0.18716871f , 0.04465249f , 0.05395055f , 0.02286270f , -0.10569980f , -0.51109990f , -0.62598156f , -0.29411790f , -0.40475676f , -0.34305943f , -0.21692205f , -0.39934499f , -0.51704391f ,
    -0.73658870f , -0.68665226f , -0.06126038f , 0.66114991f , 0.35329723f , -0.17434640f , -0.20490335f , 0.00027985f , 0.04182559f , -0.12920453f , 0.35128407f , 0.36339554f , 0.47399902f , -0.25062146f , -0.38289190f , -0.23332452f , -0.20826575f , -0.16079639f , -0.14129191f , 0.18519827f , 0.08984042f , 0.01018800f , -0.07526643f , 0.16613248f ,
    0.24459641f , -0.54593305f , -0.17413054f , 0.01221675f , -0.28335532f , -0.03597407f , -0.12785960f , -0.20546625f , 0.69946433f , 0.14655906f , -0.07567982f , -0.41903852f , -0.05404835f , -0.57786831f , 0.75099347f , 0.04385018f , 0.13817541f , 0.54561726f , 0.22589567f , 0.09746529f , 0.26583628f , 0.26558035f , 0.21082406f , 0.14352723f ,
    -0.61059536f , 0.25826720f , 0.08276875f , -0.29062272f , -0.22379136f , 0.27302107f , -0.39399985f , -0.90988239f , 0.68577814f , -0.07398823f , 0.29343711f , -0.02555969f , 0.17350828f , 0.10446548f , 0.05915310f , -0.12814425f , 0.16515519f , 0.23084429f , -0.07631257f , -0.12135962f , -0.32154020f , -0.35925975f , -0.31657161f , -0.17517095f ,
    -0.31345423f , 0.04713846f , -1.07240463f , 0.55819357f , 0.25919851f , -0.17080554f , -0.44683706f , 0.42549491f , -0.24160926f , 0.39135254f , -0.27273104f , -0.08747624f , -0.17073595f , -0.64858648f , 0.31353107f , 0.40731596f , 0.24294678f , -0.16681178f , 0.01469568f , -0.30776696f , -0.15317629f , -0.18218388f , -0.16911268f , -0.19813229f ,
    0.25482069f , -0.02943669f , -0.39498625f , -0.32329009f , 0.10426426f , -0.22095104f , 0.29062234f , -0.15434571f , -0.12708599f , -0.10669553f , 0.33786459f , -0.20904693f , 0.49652844f , -0.62850056f , 0.21568910f , -0.21446226f , 0.21630725f , -0.08720906f , -0.52065307f , -0.35255320f , -0.59625366f , -0.43541450f , -0.28092364f , -0.00125747f ,
    0.31917512f , -0.03488145f , -0.21380884f , -0.22835427f , -0.66217994f , -0.29555406f , 0.17821074f , -0.34530315f , -0.20166763f , -0.01021963f , 0.39444938f , -0.06786073f , -0.22698498f , 0.34432475f , 0.51326058f , 0.57986123f , -0.20027416f , -0.13834155f , -0.20880162f , 0.06494356f , -0.27871271f , -0.15747416f , -0.07939462f , 0.08519511f ,
    -0.57600983f , 0.33019806f , 0.38068317f , 0.13486793f , 0.61770011f , -0.42574210f , -0.17565397f , 0.32588004f , -0.07069465f , -0.12991907f , 0.10503579f , -0.53981949f , 0.27628270f , -0.40433813f , 0.56048034f , -0.11134494f , -0.02721288f , -0.02679116f , -0.03457161f , 0.00691900f , 0.35272657f , 0.02987130f , -0.37220393f , -0.73576355f ,
    -0.31901782f , -0.23550305f , 0.50511762f , 0.07681936f , -0.20832096f , -0.16180683f , 0.33639474f , 0.24607809f , 0.51978014f , -0.51511613f , 0.53433180f , -0.38461866f , -0.30344206f , 0.21738925f , 0.23262923f , -0.26642016f , -0.24689764f , -0.35119228f , -0.37163953f , -0.19926461f , -0.12294480f , -0.07264335f , -0.14869303f , 0.01600622f ,
    -0.32318991f , -0.06337691f , -0.16327790f , 0.01679607f , 0.54615398f , -0.13948782f , -0.07235812f , -0.31344026f , 0.21344099f , -0.56249237f , -0.54817142f , -0.38900153f , 0.08560375f , 0.51752999f , 0.09695531f , 0.45163870f , 0.11365917f , -0.03998578f , -0.10961891f , -0.25154202f , -0.53037031f , -0.51729631f , -0.12010728f , 0.27211617f ,
    -0.21869866f , -0.20612331f , -0.17148894f , -0.69131811f , -0.48874096f , 0.17532938f , 0.65606235f , 0.17337859f , 0.21369284f , -0.02261284f , -0.23113547f , -0.37691677f , 0.06425787f , 0.33138072f , -0.19000900f , -0.50235478f , 0.19744901f , -0.01426938f , 0.25673560f , 0.14800389f , 0.08629656f , -0.05995416f , -0.01856833f , 0.09638624f ,
    -0.68051548f , 0.42111210f , 0.16966116f , -0.18012337f , -0.66642379f , 0.11078652f , 0.51684818f , 0.04482584f , -0.37389220f , 0.07070225f , -0.22594402f , -0.24882296f , 0.28791258f , 0.16045673f , 0.13211217f , 0.30258098f , -0.11104291f , -0.34144481f , -0.61517912f , -0.45406688f , 0.24175899f , 0.43530490f , 0.33387051f , 0.31684453f ,
    -0.12348130f , 0.28844356f , -0.15230272f , -0.92611369f , 0.15595514f , 0.40309213f , -0.21089949f , -0.12710732f , -0.20149432f , 0.08709137f , 0.79880608f , 0.16826794f , -0.10477000f , -0.40397699f , -0.33124317f , -0.16915306f , -0.06502590f , 0.05657812f , 0.16028923f , 0.14994150f , 0.07722317f , 0.24695981f , 0.20225272f , 0.10946385f ,
    -0.31130776f , 0.09164996f , -0.10763487f , 0.00805002f , -0.37620293f , 0.04961005f , 0.18879671f , 0.12802431f , -0.14881133f , 0.00106507f , 0.20381895f , -0.01208542f , -0.02377667f , 0.48285147f , -1.19207093f , 0.60998154f , 0.08913394f , 0.16312199f , -0.15986004f , -0.18489974f , -0.26700574f , -0.10480556f , -0.03699614f , 0.39930124f ,
    -0.45078318f , -0.11456599f , -0.27898753f , -0.42503588f , 0.17516712f , -0.19617643f , 0.31818611f , -0.08178737f , -0.05417727f , -0.23405407f , -0.39611520f , 0.32937074f , -0.20757027f , -0.46769544f , 0.04745269f , 0.30856677f , 0.45826247f , 0.41349579f , 0.21491292f , 0.22174480f , 0.16553832f , 0.28625395f , 0.24514041f , 0.37926658f ,
    0.24936771f , -0.04104704f , 0.27238824f , 0.16392268f , -0.06110497f , -0.02187308f , -0.14403711f , 0.49428075f , 0.66634565f , 0.04308588f , 0.20773125f , -0.07283823f , -0.03584369f , -0.15180729f , -0.21954145f , -0.16147124f , -0.54353183f , 0.31850719f , 0.70992696f , 0.77482366f , -0.73614329f , -0.70442321f , -0.77208369f , -0.52036749f ,
    -0.40407749f , -0.55580682f , 0.40834797f , 0.13313598f , 0.11194755f , -0.02575282f , 0.56373574f , -0.17680698f , -0.31347570f , 0.88388781f , -0.66229966f , 0.14478038f , -0.15586756f , -0.36242692f , -0.35125580f , -0.05976233f , 0.40268536f , -0.01780960f , -0.30415813f , -0.40711933f , -0.20657081f , -0.11416314f , -0.11392091f , 0.03499209f ,
    -0.02442649f , 0.00289107f , -0.42318484f , -0.77861141f , -0.21018343f , -0.02530250f , -0.05457845f , 0.29013785f , 0.27545606f , -0.54534532f , -0.28075430f , 0.48908889f , 0.44803264f , -0.23493075f , 0.30537914f , -0.17571639f , -0.28136367f , 0.41087545f , 0.06067306f , -0.07891926f , 0.13675464f , -0.23523981f , -0.64950230f , -0.84513939f ,
    0.33320458f , -0.21239429f , 0.16584185f , 0.20947136f , -0.84373112f , -0.18662477f , -0.39277353f , 0.27160507f , 0.33045634f , -0.07972757f , 0.26989965f , -0.31828606f , 0.29166908f , 0.02792893f , -0.23589507f , 0.24680072f , 0.61805079f , 0.29297283f , -0.46279502f , -0.38853021f , -0.06845241f , 0.13809046f , 0.18584514f , 0.19851158f ,
    -0.01509547f , -0.42006585f , -0.02742765f , 0.01387587f , 0.04496372f , 0.33032099f , -1.33568146f , 0.04497330f , -0.13953978f , 0.17866902f , -0.22504135f , 0.03714148f , 0.42265213f , 0.48557283f , 0.09517080f , 0.08189501f , -0.02136855f , 0.18181835f , 0.26310442f , 0.14522422f , -0.00551997f , -0.08059227f , -0.01368360f , 0.19964321f ,
    0.06879672f , -0.16572126f , -0.21275410f , -0.00047311f , 0.38956134f , 0.68791295f , 0.06981244f , 0.44725155f , -0.37536280f , -0.07016804f , -0.31450647f , -0.12757190f , 0.15884699f , -0.28116715f , -0.24072947f , 0.06964482f , -0.41365933f , -0.30556059f , 0.01412066f , 0.09088293f , -0.05730716f , 0.11902320f , 0.49328583f , 0.76218521f ,
    0.14607820f , 0.36882839f , 0.31158718f , -0.18015097f , 0.37885733f , 0.09807226f , -0.69643398f , 0.00209062f , 0.07841871f , -0.15108867f , -0.16550965f , 0.49051298f , -0.13918703f , -0.16017141f , 0.15622856f , 0.32246753f , -0.21434589f , -0.12839098f , -0.62492818f , -0.41789280f , -0.33687252f , 0.15910414f , 0.40538907f , 0.45768888f ,
    -0.18246786f , 0.69660292f , -0.53239726f , -0.39785530f , 0.09269434f , -0.20090783f , 0.24169380f , 0.14920210f , -0.20929912f , 0.37639575f , -0.02298151f , 0.29037766f , -0.30134500f , 0.12924066f , 0.34148084f , -0.65422266f , -0.23263549f , 0.15293804f , -0.12172724f , -0.29655807f , -0.15215394f , -0.01750734f , -0.02878360f , 0.05063806f ,
    -0.26703187f , -0.12751254f , -0.03617813f , 0.00622364f , 0.22547815f , -0.57779029f , -0.13343456f , 1.59832374f , -0.86975741f , -0.37492672f , -0.39567028f , 0.18249899f , 0.04481957f , 0.29481366f , 0.13046647f , -0.10097157f , -0.02397564f , 0.04106330f , -0.32215387f , -0.06647077f , -0.19483820f , -0.47627356f , -0.28788121f , -0.35042823f ,
    0.02227780f , -0.19386416f , -0.30157912f , 0.12610552f , 0.56722223f , -0.09994132f , -0.02285657f , -0.61753835f , 0.08410488f , 0.73128591f , 0.37298647f , -0.77570729f , -0.22843919f , 0.11891633f , -0.03551507f , -0.10041180f , 0.00489754f , -0.03082396f , -0.09347646f , -0.15507942f , -0.14360267f , -0.08927711f , -0.16377833f , -0.01469311f ,
    0.56852461f , 0.23796399f , 0.13182028f , -0.25577917f , -0.33910792f , 0.34056262f , -0.02495276f , -0.05880465f , 0.05430314f , -0.53287936f , -0.34110034f , 0.15113928f , 0.54187888f , -0.26468157f , -0.01685372f , 0.57037827f , -0.07951393f , -0.27830922f , -0.20152098f , -0.00077798f , -0.04509011f , -0.12945183f , -0.22631022f , -0.11626274f ,
    -0.25019709f , 0.07915240f , 0.19342024f , 0.04977732f , -0.10307638f , -0.04911927f , 0.08460541f , 0.35299883f , 0.10558745f , 0.32964006f , 0.16392423f , -0.03030527f , -0.17918726f , -0.50040107f , 0.40349289f , -0.25886676f , -0.31911232f , -0.10072948f , 0.17941945f , 0.11358761f , -0.65821799f , -0.13049456f , 2.00511443f , -1.24662935f ,
    -0.25357033f , -0.52592150f , 0.49923249f , -0.16543271f , -0.00633755f , -0.23552079f , -0.33411617f , -0.24207035f , -0.05030731f , -0.07071177f , -0.09419244f , 0.02464220f , -0.01943557f , -0.41801617f , 0.03064668f , 1.18121471f , 0.23528827f , -0.79209131f , -0.20405955f , 1.14624028f , 0.39747635f , 0.85849404f , -0.04127540f , -0.50865399f ,
    0.42229826f , -0.01473649f , 0.33422709f , 0.02941697f , 0.19965112f , 0.72713450f , 0.30384642f , -0.11286505f , 0.14747407f , 0.14751665f , 0.11932647f , -0.00264711f , -0.31504995f , -0.56415263f , -0.31330112f , 0.01942224f , -0.35638639f , 0.03432383f , -0.11977819f , -0.30638549f , 0.34671321f , 0.83570186f , 0.17469280f , -1.01495899f ,
    -0.01251236f , -0.01487474f , -0.16676968f , 0.08574318f , 0.11892522f , 0.84392270f , 0.07864696f , -0.91941698f , -0.54281393f , -0.10333463f , -0.18582849f , -0.26050308f , 0.66395133f , 0.42733714f , -0.24646344f , -0.19052737f , 0.31638957f , 0.07897013f , 0.04027109f , -0.25458239f , 0.20940366f , 0.17480388f , 0.16462327f , 0.22726978f ,
    -0.02974486f , -0.54604962f , 0.16929759f , -0.25102018f , 0.23723617f , -0.34661947f , -0.07598653f , -0.25231308f , -0.73500058f , -0.06708141f , 0.18697737f , 0.14282300f , 0.66886685f , 0.39198866f , 0.20429507f , -0.16054968f , -0.19399421f , 0.25548963f , -0.01871442f , 0.24332515f , 0.11001194f , 0.17128458f , 0.05301268f , 0.13370518f ,
    0.06218397f , -0.11075064f , -0.47179494f , 0.44241371f , 0.02355115f , -0.03595332f , 0.06122175f , -0.89128427f , 0.30088747f , -0.16859130f , 0.25866312f , 0.50627502f , -0.10794532f , -0.21779689f , 0.18817072f , 0.03690803f , 0.04519087f , 0.11081125f , -0.16063397f , -0.29465752f , 0.07392634f , 0.19278544f , 0.34698486f , 0.61990484f ,
    0.93310946f , -0.16003930f , -0.20232301f , -0.09149716f , -0.07742202f , 0.10544444f , 0.21543944f , -0.23192273f , 0.37584518f , 0.41668097f , 0.03315939f , -0.08464584f , 0.23874101f , 0.46904518f , -0.37717436f , -0.46519362f , -0.61713348f , 0.00253734f , -0.05435577f , -0.08905407f , -0.16726849f , -0.06183335f , -0.05902828f , -0.03528791f ,
    0.27678118f , -1.22172710f , 0.33045954f , 0.00746992f , 0.02805380f , 0.37593685f , 0.03388730f , -0.30662300f , 0.20852594f , -0.26058111f , -0.05686500f , 0.26594392f , 0.13317456f , -0.21898256f , -0.24070719f , -0.23323971f , 0.27086818f , 0.15492204f , 0.28738611f , -0.10515406f , -0.17282966f , -0.16200061f , -0.15211483f , -0.08975717f ,
    0.59311421f , -0.26642352f , -0.18351175f , 0.27817437f , 0.89836102f , -0.16570591f , -0.42252147f , 0.18559697f , 0.28409112f , -0.18921990f , 0.26375529f , -0.31791665f , -0.33115116f , -0.01469640f , -0.21691511f , -0.04101336f , 0.06816547f , -0.25758291f , 0.10261781f , 0.06210271f , 0.13856623f , 0.09669133f , 0.13691740f , 0.19601167f ,
    -0.47155089f , 0.72985836f , 0.20031390f , 0.60596157f , 0.37698777f , 0.31374835f , -0.04335831f , -0.19781138f , -0.35092304f , -0.19434376f , 0.20558302f , 0.09649664f , -0.41125462f , -0.31417023f , 0.14557422f , 0.13059497f , 0.24351408f , 0.45606066f , 0.19630429f , 0.04599059f , -0.10842569f , -0.01246157f , 0.09745947f , 0.19255215f ,
    -0.00592573f , 0.30808529f , -0.82755020f , 0.27196540f , -0.04397044f , 0.35031490f , -0.46245949f , 0.43218639f , 0.08949413f , -0.33531101f , 0.30153585f , -0.06912019f , 0.05157704f , 0.21559056f , -0.09478249f , -0.29283107f , -0.14210772f , 0.16107997f , -0.05714190f , -0.07436813f , -0.17587718f , -0.17911354f , -0.01118712f , 0.30263406f ,
    0.59479190f , 0.43737796f , -0.53906079f , -0.09284007f , 0.11222222f , -0.70909913f , -0.32143749f , -0.10079180f , -0.20953687f , -0.04742476f , 0.16795483f , 0.54332818f , 0.27138756f , -0.04876020f , -0.15045069f , 0.12165485f , 0.37118663f , 0.28905161f , 0.48206821f , 0.04496926f , -0.32548961f , -0.26704421f , -0.14151166f , 0.04643725f ,
    0.01857789f , 0.22380572f , -0.47831518f , 0.10523282f , -0.02303693f , 0.06579947f , 0.64486948f , -0.30766532f , -0.74577310f , -0.77953682f , 0.57447145f , 0.39403713f , -0.58964771f , 0.62821123f , -0.11929129f , 0.10954929f , 0.14699721f , -0.32854065f , -0.04573394f , -0.09611846f , -0.01925603f , -0.17973013f , -0.39814740f , -0.46576115f ,
    0.35954529f , 0.21214434f , 0.29992890f , -0.43470418f , 0.22297513f , -0.74780053f , 0.29579016f , 0.38031695f , 0.70929833f , 0.17791374f , -0.31068973f , 0.03106903f , 0.02159010f , -0.32680013f , -0.05137091f , -0.35753644f , -0.04484695f , -0.12900523f , -0.08431778f , -0.06684064f , -0.13653506f , 0.11526736f , 0.41857603f , 0.60634687f ,
    -0.39857847f , 0.04884917f , 0.23406115f , 0.05538860f , 0.28382844f , -0.00189639f , 0.13911105f , 0.08498889f , 0.38084943f , -0.04839120f , 0.03137059f , 0.61768252f , -0.60458777f , 0.17599675f , -0.38910593f , -0.29574408f , -0.37344875f , -0.20375998f , -0.20238216f , 0.44496885f , 0.52761883f , 0.49054914f , 0.28209688f , 0.15957444f ,
    -0.09304443f , -0.24829008f , 0.01258115f , 0.25256399f , -0.33883889f , -0.24896392f , -0.05437653f , 0.19084219f , 0.57863216f , 0.39405103f , -0.77089337f , 0.12169591f , -0.54527825f , 0.19831126f , 0.08552984f , 0.24274638f , 0.14652491f , -0.01698693f , 0.17500050f , -0.05044189f , -0.10649361f , -0.14945507f , -0.17028214f , -0.02330724f ,
    0.03708941f , -0.24037606f , 0.02610502f , 0.50618133f , 0.10793551f , -0.09837616f , 0.62190481f , 0.34616106f , -0.28267161f , -0.14290071f , 0.01530348f , -0.83226343f , 0.23366780f , 0.04347097f , -0.00300625f , -0.02718166f , 0.01892830f , 0.11549693f , 0.36192046f , 0.50541829f , 0.06636938f , -0.09251533f , -0.22221864f , -0.12965501f ,
    -0.47277684f , 0.24188752f , 0.24883904f , -0.02549111f , -0.17021090f , 0.26120838f , -0.17437786f , -0.12898937f , -0.09122841f , 0.58977574f , 0.11843505f , -0.68052107f , 0.69093722f , -0.45942130f , -0.33210729f , 0.59582125f , -0.21973689f , 0.45672258f , 0.17061853f , 0.09529478f , -0.14791095f , 0.22877969f , 0.23364199f , 0.17934426f ,
    0.16186852f , 0.95532223f , 0.24207322f , -0.28038649f , -0.16606584f , 0.28705368f , -0.00385633f , 0.10024520f , 0.38606721f , 0.00630603f , -0.08918537f , -0.48762895f , -0.25520072f , -0.07233131f , -0.06791555f , 0.02988899f , 0.33242516f , 0.31840295f , 0.31437593f , 0.28920587f , 0.20710554f , 0.12154078f , 0.09165915f , 0.13540520f ,
    -0.13814042f , 0.76333362f , 0.47866377f , 0.69056795f , 0.37920652f , -0.08336837f , 0.11207624f , 0.09821375f , 0.10128568f , 0.04094478f , -0.15253392f , -0.11078606f , 0.25057753f , 0.22663675f , -0.61364190f , -0.15546409f , -0.09300050f , -0.16430823f , -0.19195716f , -0.31084762f , -0.10423817f , -0.12525492f , -0.23057864f , -0.28477374f ,
    0.19153891f , -0.50596450f , -0.06105779f , 0.12200239f , -0.10106136f , -0.25277965f , 0.30874573f , 0.40660354f , -0.20056468f , 0.17407976f , 0.60265008f , -0.00174689f , -0.44985204f , -0.31371702f , -0.45581285f , 0.36180230f , -0.07689721f , 0.80922589f , 0.34920387f , -0.21634606f , 0.06852205f , 0.36029737f , 0.53860772f , 0.69593094f ,
    0.15218961f , 0.07083646f , 0.38471465f , 0.14311856f , 0.51050633f , 0.02631960f , 0.07150340f , -0.05204054f , 0.01036712f , 0.03753337f , 0.12604818f , 0.04316599f , -0.04454527f , 0.25901986f , 0.20620898f , -0.25183978f , -0.94415183f , -0.48608996f , 1.99323108f , -0.11741995f , 0.09381593f , 0.24836984f , -0.11990959f , 0.40198786f ,
    0.35937586f , 0.05698778f , 0.55993579f , -0.68942177f , -0.00843969f , 0.47116294f , -0.17925245f , -0.41881521f , -0.20778331f , 0.27187634f , -0.19950871f , 0.56109975f , -0.73314410f , 0.36645381f , 0.13542026f , -0.12859018f , 0.07003305f , 0.17282595f , 0.33447531f , 0.32716011f , -0.39068553f , -0.25495327f , -0.44464316f , -0.44631278f ,
    -0.24788508f , 0.44993219f , 0.49633852f , 0.14573879f , -0.82145522f , 0.08447045f , 0.24653278f , 0.20233825f , -0.08079227f , -0.31036126f , 0.09619263f , 0.78127448f , 0.27956930f , -0.05376367f , -0.24537081f , -0.24071734f , 0.06264366f , -0.00648643f , 0.14649115f , 0.22075554f , 0.00215430f , -0.16835304f , -0.14400020f , 0.05455559f ,
    0.51475177f , -0.19511684f , -0.41661102f , 0.02887458f , -0.64696667f , 0.12493084f , 0.01019607f , 0.19888837f , -0.37880058f , 0.64135459f , 0.11055137f , 0.09557428f , -0.07711050f , 0.13238949f , -0.18005007f , -0.18262300f , 0.15084340f , -0.21503629f , 0.15653282f , 0.45708075f , 0.39918436f , 0.40428185f , 0.37849166f , 0.37443886f ,
    -0.37551659f , 0.34117536f , 0.04118741f , -0.11257164f , -0.12653529f , -0.87344655f , -0.56010800f , -0.07645484f , 0.14471437f , 0.20262780f , 0.29380185f , -0.02943048f , 0.10854716f , 0.43270966f , 0.25877519f , 0.11175582f , 0.11265276f , 0.12112616f , 0.32109879f , 0.25352173f , 0.28658481f , 0.29681278f , 0.39509407f , 0.43777195f ,
    0.17504785f , 0.10160864f , -0.32996848f , 0.33545472f , 0.10088654f , 0.32002010f , -0.06513018f , 0.09378440f , 0.30444515f , 0.06564463f , -0.59311997f , 0.13934191f , 0.17049039f , -0.38526222f , -0.13285144f , -0.34127257f , 0.32308732f , 0.29646451f , -0.08667292f , 1.27873237f , 1.21492697f , -3.11928954f , 0.45762280f , -0.93594879f ,
    0.17132808f , 0.08085753f , 0.26151050f , 1.03721715f , -0.25337638f , 0.26779752f , -0.61935064f , 0.10496638f , -0.18282397f , 0.00232460f , 0.17820442f , 0.20638928f , 0.07611441f , 0.12056159f , 0.20529210f , -0.06270324f , -0.04360808f , -0.42305491f , -0.41339045f , -0.00383610f , -0.19449359f , -0.25682704f , -0.37569311f , -0.21433847f ,
    0.64365986f , 0.31456070f , -0.39495602f , -0.24863426f , 0.09837217f , -0.36609886f , 0.17111936f , 0.24419541f , -0.24359150f , -0.27882768f , -0.09002564f , -0.30691102f , -0.22673738f , 0.56321328f , 0.22388027f , 0.03208856f , 0.17981274f , 0.06991222f , -0.67356769f , -0.64900669f , 1.15113193f , 0.72776059f , 0.27327753f , 1.08582469f ,
    0.41187807f , 0.20392498f , 1.09655483f , -0.34930742f , 0.20771295f , -0.06429869f , 0.08115226f , 0.22625148f , -0.72095719f , -0.02848530f , 0.42792136f , -0.04720602f , -0.22585980f , -0.29439740f , 0.06057192f , 0.13137013f , 0.24620234f , -0.13734663f , -0.12645317f , -0.30625075f , -0.14167838f , -0.11199965f , -0.18411244f , 0.12411211f ,
    0.52310170f , 0.17749282f , 0.93116306f , 0.43734813f , -0.11189475f , -0.12583315f , -0.15636518f , -0.45970964f , 0.29811984f , 0.05623999f , 0.26734923f , -0.16388298f , -0.04470326f , 0.13948379f , 0.11499794f , 0.17243067f , 0.01441213f , -0.18039908f , -0.09565125f , 0.16544291f , 0.06548930f , 0.22771091f , 0.45780362f , 0.52809090f ,
    0.28956302f , -0.16486587f , 0.29599013f , 0.32685118f , -0.28935868f , -0.00152686f , 0.55430159f , 0.03727197f , 0.10804969f , -0.54544071f , -0.79114628f , 0.10752299f , 0.05522333f , 0.63833259f , 0.49017560f , 0.02881627f , -0.39313059f , 0.50983607f , 0.34015996f , -0.08459223f , -0.28493761f , 0.10604944f , 0.27351683f , 0.32437791f ,
    -0.25283796f , -0.04532098f , 0.15075344f , 0.11408519f , 0.00916449f , -0.10310231f , 0.19258483f , 0.02635541f , -0.27218167f , 0.12402945f , 0.03511427f , 0.17636894f , -0.54939311f , 0.33454589f , -0.06691437f , -0.76895070f , 0.86149576f , -0.11074096f , 0.14506447f , -0.65269171f , 0.42690885f , 2.34010106f , -0.53713287f , -0.56076371f ,
    0.34158378f , 0.24525259f , 0.18233515f , -0.01918052f , -0.38850956f , -0.10382009f , 0.23314099f , -0.44393411f , -0.22817265f , 0.43890661f , -0.35766222f , 0.12772962f , 0.29184572f , -0.35914868f , 0.41036163f , 0.13940763f , 0.24037289f , 0.31034789f , 0.39892172f , 0.45673361f , 0.25700279f , -0.23583305f , -0.56430632f , -0.63542661f
};

const float cdk_37bits_6[1536] =
{
    0.02199370f , -0.29796617f , 0.05716792f , 0.13680255f , 0.26597120f , -0.02744179f , 0.20163618f , 0.55538992f , 0.22634719f , 0.31737301f , 0.16680373f , -0.09734626f , -0.23572572f , -0.44456075f , -0.32174953f , -0.27927807f , -0.32748565f , -0.18735586f , -0.18267408f , -0.46321102f , -0.04612331f , 0.01365363f , 0.19391054f , 0.39090135f ,
    -0.78693393f , -0.13121488f , -0.28380698f , -0.26404304f , -0.10486512f , 0.28404174f , -0.20661527f , -0.42204880f , -0.30458489f , 0.08583926f , 0.07085793f , 0.33480410f , -0.03611454f , 0.07957323f , -0.24515140f , -0.07119076f , 0.53589973f , -0.22960446f , 0.07406971f , -0.05459778f , -0.34032829f , -0.26754071f , 0.22258555f , 0.30461029f ,
    -0.40719188f , -0.52149744f , -0.06225098f , -0.58002850f , 0.18087742f , 0.16048132f , 0.33633101f , -0.27793274f , 0.29766130f , 0.23267788f , -0.40627837f , -0.11859464f , -0.33658426f , -0.08944806f , 0.07416164f , 0.12096620f , -0.17419709f , -0.33394555f , -0.01993099f , 0.18415306f , -0.00706952f , -0.18114484f , -0.17223192f , -0.00314600f ,
    0.09136000f , 0.34482257f , -0.38038690f , 0.51845639f , 0.22194266f , -0.06195248f , 0.01057897f , -0.25864445f , -0.13813348f , 0.15711108f , 0.37305034f , -0.46508572f , 0.21910366f , 0.14590390f , -0.15011887f , -0.08081632f , 0.02686570f , -0.52447967f , -0.44642803f , -0.09356439f , 0.07841264f , -0.09014590f , -0.08406397f , -0.21549966f ,
    -0.10973105f , -0.34775792f , -0.20573880f , -0.13604716f , 0.02371719f , -0.25091561f , -0.39884717f , -0.11293660f , 0.35125293f , -0.23847405f , 0.75991690f , -0.00398242f , -0.37499879f , -0.16571879f , -0.17163070f , 0.28161005f , 0.30079809f , 0.08127173f , -0.21076595f , -0.41977393f , -0.20607863f , -0.13121646f , -0.05219850f , -0.20041567f ,
    -0.23929288f , 0.00328474f , -0.16404527f , 0.13343873f , -0.04468995f , -0.12674227f , 0.28141003f , 0.18544988f , 0.02601550f , -0.21845606f , -0.11057949f , -0.08909572f , -0.13195824f , -0.18487778f , 0.09887948f , 0.53205644f , -0.22134305f , -0.05746605f , -0.44707332f , -0.06333598f , -0.98347835f , 1.60965371f , -0.38440494f , 0.37345285f ,
    0.18956874f , -0.63812607f , 0.04131005f , -0.45442314f , -0.54875750f , 0.04287724f , 0.25537551f , 0.08570099f , -0.08813623f , -0.09284444f , 0.03722275f , 0.36512077f , -0.09165936f , -0.03956157f , -0.01444716f , 0.03320064f , 0.05602971f , 0.12944547f , -0.08791108f , -0.21281390f , 0.02256362f , 0.21794416f , 0.49420878f , 0.51874581f ,
    -0.61939062f , -0.36501718f , 0.13770557f , -0.03873456f , 0.24524354f , -0.22114161f , 0.17262135f , -0.01018526f , 0.00734267f , -0.03028249f , -0.10222293f , -0.56027275f , 0.21981567f , 0.30177736f , -0.00599960f , -0.13637831f , 0.12005585f , 0.21762903f , 0.21013194f , -0.29453710f , 0.06570005f , 0.02671005f , 0.18952852f , 0.33755592f ,
    0.14788881f , 0.00059595f , 0.03869057f , -0.08077903f , -0.12203289f , -0.84498958f , 0.47581358f , 0.02514588f , 0.04825696f , -0.01455508f , -0.01746364f , 0.27725910f , 0.12457264f , 0.11218197f , 0.26527797f , -0.25741487f , -0.07216861f , -0.32943112f , -0.08385290f , -0.36172079f , -0.42572896f , -0.53073631f , -0.32133031f , -0.11301412f ,
    -0.35066897f , -0.11415958f , -0.59117357f , -0.14095716f , -0.42297703f , -0.39599254f , 0.11101885f , 0.54908359f , 0.00983404f , -0.16570627f , 0.35167384f , 0.03659831f , 0.00451556f , 0.13297592f , -0.03455431f , 0.05151250f , -0.22783505f , -0.26878480f , -0.09719185f , 0.26294703f , 0.24726886f , 0.09052345f , -0.07129501f , -0.20450022f ,
    -0.04472087f , -0.37269265f , 0.03231240f , 0.03463392f , -0.33039098f , 0.03217782f , -0.35545027f , 0.13915732f , 0.21687252f , -0.70171718f , -0.39380045f , 0.29808315f , -0.10154988f , 0.58687688f , 0.36738223f , -0.01455050f , 0.25767865f , -0.13939968f , -0.18503719f , 0.06199296f , 0.11118295f , 0.01396018f , 0.09425776f , -0.03092734f ,
    -0.25728637f , 0.47463459f , 0.06581158f , -0.61445073f , 0.28805874f , 0.07087341f , 0.22849783f , 0.14652334f , -0.17916038f , -0.45793031f , -0.13375702f , 0.04741016f , 0.34305011f , 0.18609517f , 0.15796519f , -0.32119576f , -0.37724212f , -0.29019392f , -0.16584456f , 0.06247499f , -0.17973441f , -0.11871502f , 0.07256450f , 0.13822121f ,
    0.20531600f , -0.09627213f , -0.35132620f , -0.03667359f , -0.25798228f , 0.21115819f , 0.03354110f , -0.02417022f , 0.43198429f , -0.23070254f , -0.12670631f , 0.15840355f , -0.09384404f , -0.11238464f , -0.08953585f , 0.10896049f , -0.00837215f , -0.46861227f , 1.49760729f , -0.67351773f , -0.52192511f , 0.01262532f , 0.20121502f , -0.39083539f ,
    0.10656396f , -0.26831105f , -0.81601202f , 0.26397269f , 0.26863321f , -0.04846112f , 0.40399165f , -0.08820703f , 0.14718938f , -0.29278618f , -0.38479467f , 0.02420765f , -0.10191832f , -0.03998542f , 0.09718148f , -0.38999213f , 0.40517232f , 0.29658010f , 0.07025753f , -0.06541290f , -0.17956727f , -0.20362973f , -0.10716584f , -0.04799112f ,
    -0.08098934f , 0.01809647f , -0.31889640f , 0.20306658f , 0.05187569f , 0.03260165f , -0.28014725f , -0.09888837f , 0.24610335f , 0.17700122f , -0.30915327f , -0.08942879f , -0.50003116f , 0.85468538f , -0.27952271f , 0.40219755f , -0.20697633f , -0.22376407f , -0.24075343f , -0.23806655f , 0.09503069f , 0.19400941f , 0.29979874f , 0.26995405f ,
    -0.27054449f , 0.39277758f , -0.03760489f , 0.02099845f , -0.35791555f , -0.28760379f , 0.22223327f , -0.11251071f , -0.02563508f , 0.46326287f , -0.14502000f , -0.07375028f , -0.32793294f , -0.56372840f , 0.30213757f , 0.47683337f , 0.42993785f , 0.02200265f , -0.43110723f , -0.31763877f , 0.25984030f , 0.13257308f , 0.23346193f , -0.17362047f ,
    -0.12926955f , 0.23035254f , 0.14954128f , -0.15270953f , 0.01666258f , 0.25669412f , 0.26953793f , 0.47425752f , -0.09722404f , -0.12678088f , -0.27006791f , 0.06245438f , 0.11482178f , -0.51002017f , -0.55002144f , -0.13134853f , 0.49162370f , -0.20822342f , -0.09189974f , -0.03360844f , 0.08050459f , 0.08539808f , -0.01338071f , -0.32112911f ,
    -0.07384309f , 0.14700645f , -0.33549907f , -0.17107820f , -0.36567878f , 0.28540929f , -0.11645077f , -0.06093537f , 0.10704230f , 0.60475923f , 0.31110592f , 0.03294181f , 0.24602888f , -0.16878060f , -0.37308097f , -0.38852147f , -0.11457933f , -0.01155936f , -0.20566079f , -0.11646696f , -0.43156667f , -0.48332839f , -0.40869530f , -0.30176313f ,
    -0.04009388f , -0.48515311f , -0.01564117f , -0.22107208f , 0.26498770f , 0.32028506f , -0.06025879f , 0.53444487f , -0.52361462f , -0.13790355f , -0.00869928f , -0.37067541f , -0.00525305f , 0.34369466f , -0.11140079f , -0.21802883f , -0.02738621f , 0.09487138f , -0.18305111f , 0.21257672f , 0.19224339f , 0.13669179f , -0.07833677f , -0.43596981f ,
    -0.31269603f , 0.18817889f , -0.14017449f , -0.36643116f , 0.51493670f , -0.26894972f , 0.38067942f , -0.47165660f , -0.03935884f , -0.15393758f , 0.33966349f , -0.07858441f , 0.08218318f , -0.14083074f , -0.39968104f , 0.46984889f , -0.23459315f , -0.01561374f , 0.04443121f , -0.08906745f , -0.05813711f , -0.21827283f , -0.17460819f , -0.22917539f ,
    -0.32481184f , 0.18110865f , -0.03288883f , -0.13973233f , 0.27902282f , -0.11023560f , -0.16625632f , 0.02743534f , 0.10865317f , -0.10518495f , 0.26027757f , -0.15223339f , -0.35257469f , -0.01938217f , 0.46256528f , -0.27598628f , 0.04443960f , 1.07920395f , -1.13925232f , 0.36635637f , 0.35955458f , 0.25146378f , 0.11693719f , -0.28918251f ,
    -0.01140797f , -0.00108123f , 0.53664312f , -0.07884630f , 0.06610974f , 0.46994377f , -0.21062843f , -0.06753632f , -0.27422686f , -0.02290268f , -0.18794805f , -0.46650251f , -0.14397198f , -0.00227405f , 0.10488283f , 0.31441692f , 0.42101389f , 0.25235460f , -0.29244026f , -0.56175069f , -0.28002115f , -0.17549467f , -0.12071683f , -0.23331646f ,
    -0.14210038f , 0.15898131f , 0.34745032f , -0.39617165f , -0.04076848f , 0.18838182f , -0.13777208f , 0.22936475f , 0.41604669f , -0.29976263f , 0.25071099f , -0.15777986f , 0.01895400f , -0.00797168f , -0.55609191f , 0.33651175f , -0.23976909f , -0.55267202f , -0.20759468f , 0.05624592f , 0.01093081f , 0.08073438f , 0.28567820f , 0.30232551f ,
    0.28315788f , -0.74308327f , 0.25294543f , 0.19940974f , 0.24760844f , -0.02307767f , 0.00394023f , -0.27240988f , -0.55346147f , 0.06135889f , -0.10476035f , 0.49139353f , 0.02862492f , 0.14164419f , -0.26209567f , 0.29521976f , -0.05334845f , -0.16688330f , -0.02634194f , -0.01985854f , -0.11432133f , -0.12121091f , -0.13386215f , -0.39429955f ,
    0.01675275f , -0.07538106f , -0.33922440f , 0.34966904f , 0.15763570f , 0.08306612f , 0.62591343f , -0.03583112f , -0.43789635f , -0.06885643f , -0.00346875f , -0.06640113f , -0.32232724f , -0.18063079f , 0.53312831f , -0.00572204f , -0.27992509f , -0.50312951f , 0.12672777f , 0.16960075f , -0.11581876f , 0.02517662f , 0.13602646f , 0.24387275f ,
    -0.35732816f , -0.22019513f , -0.26829496f , 0.31166748f , -0.23832104f , 0.56149308f , 0.20096730f , -0.14980617f , 0.04728897f , -0.22598474f , -0.36740325f , 0.14028484f , 0.32691879f , 0.00451707f , -0.11546712f , 0.20652154f , -0.39073278f , 0.05148622f , -0.29347409f , -0.21830651f , 0.40790228f , -0.24466325f , -0.37143514f , -0.35725594f ,
    -0.34807000f , -0.00324691f , -0.06021802f , 0.27592230f , 0.20065100f , -0.31797201f , -0.48602388f , 0.05361142f , 0.30839620f , 0.41057671f , -0.47412603f , 0.10542789f , 0.20596832f , -0.20747184f , 0.40038595f , -0.20068089f , 0.00240007f , -0.38309980f , -0.05001577f , 0.17124043f , 0.09018175f , 0.07050526f , 0.22914929f , 0.15810766f ,
    0.15361042f , 0.16095058f , 0.11590520f , -0.10531069f , -0.54075671f , 0.33490327f , 0.37034921f , -0.22227724f , -0.09516189f , -0.12944095f , 0.61220382f , -0.39342831f , 0.07187587f , 0.14034139f , 0.15782975f , 0.06333909f , -0.37017017f , 0.21683365f , 0.12401762f , -0.25136319f , -0.14144992f , -0.11683977f , 0.08998918f , 0.02907554f ,
    -0.75114647f , 0.03978493f , 0.76048864f , 0.09830364f , -0.18442047f , -0.01149302f , -0.08377934f , 0.01287934f , -0.10587886f , 0.02074821f , 0.24442453f , 0.25099252f , 0.04656507f , 0.10263959f , -0.00445999f , -0.09991211f , -0.18874159f , -0.04573901f , 0.12928997f , 0.08644625f , -0.19611160f , -0.27382974f , -0.29394396f , -0.47761274f ,
    0.14765675f , 0.26358158f , -0.29464188f , 0.01676762f , -0.12098202f , 0.56991418f , -0.43628314f , 0.29279445f , -0.51684512f , -0.06979763f , 0.22084398f , 0.33328609f , -0.44667171f , -0.13234452f , 0.03221020f , 0.34402421f , -0.06995129f , -0.10237066f , -0.03757679f , 0.08387845f , 0.07625326f , -0.18566472f , -0.25481511f , -0.35690924f ,
    0.36027465f , -0.14361307f , -0.01060078f , -0.14321892f , 0.47607774f , -0.21917094f , -0.19024330f , 0.35483351f , 0.00343023f , 0.16704908f , 0.09217343f , -0.36458287f , -0.68525894f , -0.06920128f , 0.13485445f , 0.16439202f , 0.13577501f , -0.06075085f , 0.02266803f , 0.26611340f , -0.37850955f , -0.49541492f , -0.48481104f , -0.30493937f ,
    0.04767197f , 0.17098898f , -0.03724685f , -0.76939534f , -0.52710450f , -0.26151755f , -0.36749599f , 0.19673299f , 0.11499191f , 0.25563946f , -0.18105024f , -0.11440595f , 0.27962189f , 0.12349943f , 0.04827891f , 0.17421978f , 0.25830670f , 0.15467508f , 0.17983330f , 0.17053327f , 0.01501125f , -0.21006919f , -0.24807426f , -0.27314815f ,
    -0.24896720f , 0.19371740f , 0.06879568f , 0.44049451f , 0.14914746f , 0.03856987f , 0.06978715f , 0.40612007f , 0.28010982f , -0.56749281f , -0.01993429f , 0.46728351f , -0.36770014f , -0.15189625f , -0.02595528f , -0.16408195f , -0.11358236f , 0.34475368f , 0.37996789f , -0.23334622f , -0.02333946f , -0.29586512f , -0.08357343f , 0.01075083f ,
    0.01442941f , -0.19995191f , -0.25851229f , -0.29267926f , 0.50501148f , 0.07809462f , -0.35000787f , 0.00232180f , 0.25576742f , 0.22026677f , -0.28505912f , 0.32678020f , 0.14230208f , -0.25462591f , -0.52430874f , 0.00733528f , -0.12371759f , 0.46221140f , 0.03726347f , 0.06724595f , 0.38257606f , 0.29300802f , 0.20146742f , 0.05769846f ,
    0.46566196f , -0.22129182f , 0.48408131f , -0.08771705f , 0.34179928f , -0.03570483f , 0.28260230f , -0.37152490f , 0.24002550f , -0.37004615f , 0.04007914f , 0.14066291f , 0.03156739f , -0.40473859f , 0.24504260f , -0.12061618f , -0.01911784f , -0.09587775f , -0.20311630f , 0.25305578f , -0.02444684f , -0.17360130f , -0.33200194f , -0.56919023f ,
    0.40911162f , -0.26402836f , -0.43905076f , -0.53557497f , 0.19016209f , -0.01532019f , -0.46281760f , -0.26868248f , 0.12319043f , -0.03526231f , 0.14611501f , -0.35525234f , 0.34301743f , 0.10756893f , 0.38690216f , 0.01304076f , -0.17233959f , -0.26353334f , -0.32623011f , -0.13634929f , 0.06881118f , -0.03647389f , 0.13860696f , 0.21618306f ,
    0.58044419f , -0.31542590f , 0.13749045f , 0.15061296f , -0.24506767f , -0.10488291f , -0.37675292f , -0.04226534f , -0.16466027f , 0.20334112f , 0.62047117f , -0.07748292f , -0.23123208f , 0.22647883f , 0.46423202f , -0.53987978f , 0.26867801f , 0.17570387f , 0.22624788f , -0.06808559f , -0.09873793f , 0.00241821f , 0.05209155f , 0.02604012f ,
    -0.18720130f , -0.00619393f , 0.08934188f , 0.18479801f , 0.00631687f , 0.35401594f , -0.22430546f , -0.17052726f , -0.27404318f , 0.34842459f , 0.06523245f , -0.22607999f , 0.38438344f , 0.31775172f , 0.00274227f , -0.32430710f , -0.25886046f , -0.22780138f , 0.00599115f , 1.13173049f , -1.16090310f , 0.31502644f , 0.39054668f , -0.12545157f ,
    0.08495448f , -0.08111156f , 0.13201128f , 0.10631004f , -0.62508184f , 0.49447676f , 0.05698153f , 0.57661737f , 0.16100334f , 0.29281953f , -0.42535641f , -0.34334011f , -0.21130696f , -0.11053404f , 0.29449021f , -0.00923741f , -0.15178458f , -0.03327836f , 0.04623104f , 0.06728107f , 0.07479295f , -0.09249471f , -0.01129765f , -0.02381652f ,
    0.58733539f , 0.15083492f , -0.07170902f , 0.07265805f , 0.25686979f , -0.00362956f , 0.16478015f , 0.10189929f , -0.35758569f , 0.34626172f , -0.76537636f , -0.14748849f , 0.23675893f , 0.10373267f , 0.09933094f , -0.01851098f , -0.01787937f , -0.12160932f , -0.09891368f , -0.10410372f , 0.04554984f , 0.08997877f , 0.12949773f , 0.02665334f ,
    0.29472382f , 0.55621057f , -0.25157141f , -0.08071915f , -0.33720618f , -0.07969815f , -0.09542065f , -0.03385662f , 0.57363003f , 0.21066071f , -0.26291676f , 0.64510933f , -0.24141325f , -0.10243829f , -0.10243462f , 0.03275380f , -0.20748095f , -0.21739693f , -0.02629787f , 0.14996425f , -0.18327383f , 0.03844543f , -0.12298422f , -0.48155671f ,
    -0.03002892f , 0.10542293f , 0.06159204f , 0.27084880f , 0.33088023f , -0.39709374f , 0.40602594f , 0.01355505f , -0.21134955f , 0.38680071f , 0.42354405f , 0.13430508f , 0.04568189f , -0.43410657f , -0.13995521f , -0.32088491f , -0.23742271f , 0.13613850f , 0.22766366f , 0.52067443f , 0.36422193f , -0.09820343f , -0.25055881f , -0.32764668f ,
    -0.03031539f , 0.33911970f , 0.00121262f , 0.23395660f , 0.10188493f , 0.35700308f , -0.26121354f , 0.04562318f , 0.08861375f , -0.19333300f , -0.17460139f , -0.06438315f , 0.08512698f , -0.28212770f , 0.58969600f , -1.01876488f , 0.72771298f , -0.24186158f , -0.25474736f , -0.05188159f , 0.35800295f , -0.07855298f , -0.01848759f , 0.30122272f ,
    -0.16488121f , 0.39899154f , -0.43527753f , 0.06350178f , -0.25145471f , -0.13442742f , -0.05695327f , 0.05515276f , -0.53947634f , 0.10452757f , -0.00613783f , 0.09941644f , 0.48768605f , 0.23880974f , 0.15991320f , -0.08188036f , -0.07454521f , 0.46447496f , 0.20306282f , -0.35729603f , -0.19729891f , 1.15029004f , 0.78677730f , -0.96063281f ,
    0.31021050f , -0.38542028f , 0.38342353f , 0.13604497f , -0.07567226f , -0.23168737f , -0.02250859f , -0.04684466f , 0.02122357f , 0.36396360f , -0.03570663f , -0.41257090f , 0.57597067f , 0.13936689f , -0.44959133f , -0.14512843f , 0.31888158f , -0.68434472f , 0.36855275f , 0.34229507f , 0.14749025f , -0.13593595f , -0.02198259f , 0.03092032f ,
    0.04127156f , -0.30338390f , -0.36945017f , 0.09750128f , 0.03159281f , -0.09756566f , -0.00189927f , -0.12775820f , 0.11355232f , -0.16024788f , 0.32150415f , 0.19535993f , 0.22702237f , 0.26433052f , -0.08518964f , -0.13355330f , -0.54717674f , 0.18386017f , 0.53068186f , 0.35196477f , -0.36756679f , -0.69260204f , 0.19830746f , 0.92671624f ,
    -0.09461538f , 0.67447380f , 0.12354656f , 0.17963388f , 0.15317263f , 0.19433224f , 0.16035999f , -0.50697166f , 0.22832688f , -0.03638860f , -0.31139766f , -0.15364902f , -0.16277929f , 0.09079846f , 0.36114558f , 0.19448427f , -0.21078568f , -0.04243481f , 0.26104266f , 0.46369813f , 0.26334525f , -0.14251361f , -0.10575649f , -0.10844448f ,
    -0.04642582f , -0.10287474f , 0.07590817f , 0.04960837f , -0.05287987f , -0.15988848f , -0.08701719f , 0.14028344f , -0.27072892f , -0.02715588f , 0.24338776f , 0.20341433f , 0.43004675f , -1.02991828f , 0.27940707f , 0.21700241f , 0.11492563f , 0.27903919f , 0.26058323f , -0.34700893f , 0.07076686f , -0.10221847f , 0.05257812f , 0.55040312f ,
    -0.00947855f , 0.16201946f , 0.01530995f , 0.21655645f , -0.39190608f , -0.53475683f , 0.27626723f , -0.10828040f , -0.11491983f , -0.37356045f , 0.23110876f , 0.23915995f , 0.26409657f , 0.05516764f , -0.26520423f , 0.23157479f , 0.49045853f , 0.07154379f , 0.24906795f , 0.48215117f , 0.36682427f , 0.30977279f , 0.41199849f , 0.35374660f ,
    0.11035037f , 0.12792077f , 0.34911446f , 0.03095177f , -0.26708115f , 0.01926537f , 0.06581393f , -0.83391569f , 0.11407886f , 0.34947774f , -0.06272482f , 0.45584926f , 0.35208593f , 0.02210972f , 0.03663452f , -0.16326364f , -0.08863411f , -0.12989747f , -0.24846516f , 0.02403637f , 0.24144266f , 0.21460052f , 0.21802777f , 0.17582350f ,
    0.17586580f , -0.03883077f , 0.41247141f , 0.20117164f , 0.49169701f , 0.55456607f , -0.33339198f , -0.15935525f , 0.11000758f , 0.03881595f , -0.08086591f , 0.08127779f , -0.21850527f , 0.25204265f , 0.02918388f , -0.46406159f , -0.30149637f , -0.28716264f , -0.01652976f , -0.21430167f , -0.05257479f , -0.11894064f , 0.12104770f , 0.21200677f ,
    0.05077562f , 0.64049606f , 0.29166977f , -0.14882998f , 0.23041791f , -0.17570776f , -0.25126896f , 0.15320959f , -0.50542113f , 0.51581805f , 0.29050952f , 0.02906798f , -0.21707118f , 0.08731647f , -0.26192461f , 0.08930377f , 0.01540895f , -0.11515550f , -0.13173228f , 0.04443261f , 0.14861127f , 0.15145403f , 0.38816557f , 0.40757716f ,
    0.31175167f , 0.17090647f , 0.17998268f , -0.19899135f , 0.28615557f , -0.13419397f , 0.07062408f , -0.18842182f , -0.15533919f , -0.48813043f , 0.33410690f , 0.14699633f , 0.07321804f , 0.60685754f , -0.42827502f , -0.43054167f , 0.30547944f , 0.50321733f , -0.20117562f , -0.07447133f , -0.00135400f , 0.05786543f , -0.01808385f , -0.10533247f ,
    0.05054332f , -0.14047735f , -0.07415119f , 0.44066546f , -0.02324372f , -0.09192828f , -0.18097335f , 0.09834903f , -0.26580813f , -0.02556763f , -0.37105934f , 0.12150755f , -0.11848442f , 0.04784313f , -0.11220379f , 0.39803073f , 0.52224090f , 0.10595610f , 0.18711063f , 0.29425741f , -0.12712275f , -0.75269106f , -0.62164375f , 1.49229636f ,
    -0.05263376f , 0.01551319f , -0.01862667f , 0.39621319f , 0.00775791f , 0.19443440f , -0.37005598f , 0.09947225f , 0.17067061f , -0.59100529f , -0.09194870f , -0.41824230f , 0.54676965f , 0.01393038f , 0.32793066f , 0.12752974f , -0.01761483f , 0.26099604f , 0.18632115f , 0.17752999f , -0.12037572f , -0.19613144f , -0.11840061f , -0.09740210f ,
    0.09912611f , -0.24884033f , 0.19434008f , 0.16192972f , 0.05004326f , -0.59081926f , -0.41278435f , 0.10837713f , 0.06286063f , 0.17897341f , -0.09549655f , -0.11946937f , 0.19636290f , 0.10840741f , 0.12514136f , 0.91209643f , -0.52293308f , 0.24102239f , 0.14117183f , -0.19578756f , 0.29083443f , 0.08063250f , -0.15288813f , -0.30169128f ,
    0.01584630f , -0.11259531f , 0.39416192f , 0.56959415f , -0.29736651f , 0.10790402f , 0.64124109f , -0.30225328f , 0.10444127f , 0.04559679f , 0.04662132f , -0.13559913f , -0.47705291f , 0.24948308f , -0.09175683f , -0.12182940f , 0.23087559f , -0.04229615f , -0.10186917f , 0.07827786f , 0.09243493f , 0.11202796f , 0.04243676f , 0.08887602f ,
    -0.38219650f , -0.11461189f , -0.18648336f , 0.19816038f , -0.09732223f , 0.52544356f , -0.13255010f , -0.13256714f , 0.46163208f , -0.08822080f , 0.30489642f , -0.27441353f , -0.17900853f , -0.37170730f , -0.16593309f , -0.05832152f , 0.20792097f , 0.02230373f , 0.39776652f , 0.32480143f , 0.56771378f , 0.28147085f , 0.12035847f , -0.06198797f ,
    0.16289063f , 0.29806667f , 0.12344487f , 0.11272351f , 0.03410954f , -0.30062456f , 0.06877076f , -0.06004153f , 0.62082084f , 0.47068710f , -0.30298966f , -0.26674229f , -0.10333087f , 0.13814787f , -0.18170023f , -0.26286846f , 0.14643367f , 0.69028091f , 0.12706668f , -0.06000300f , -0.15983614f , -0.16308927f , 0.06054026f , 0.24605632f ,
    0.71272052f , 0.52242539f , -0.04818476f , 0.31193593f , -0.15987333f , -0.06222937f , -0.05672104f , 0.53241922f , 0.05925126f , -0.20570464f , 0.11569695f , -0.11659635f , 0.17015156f , 0.03835440f , -0.10022938f , 0.00626121f , -0.22082679f , -0.10482121f , -0.03046492f , -0.07362554f , 0.16480680f , -0.02745797f , -0.23714652f , -0.40036483f ,
    0.00774041f , 0.02630024f , 0.85679294f , -0.16620543f , 0.13390597f , -0.43418821f , 0.27099640f , 0.29601681f , -0.05468039f , 0.00123578f , -0.34476791f , 0.20548883f , 0.12690026f , -0.12125541f , -0.24822526f , 0.32121761f , -0.15281912f , 0.18448249f , 0.30215241f , 0.12566250f , 0.06993898f , -0.03997524f , 0.17346822f , 0.40869366f ,
    0.50810094f , 0.24316475f , -0.32829494f , -0.52128186f , 0.13028426f , 0.29952885f , 0.46293804f , -0.26433277f , -0.37140799f , -0.12921967f , -0.20423017f , -0.11719085f , 0.08305804f , -0.12334944f , -0.23731075f , 0.22837853f , 0.24340316f , 0.43535913f , 0.30959620f , 0.04173569f , -0.57982693f , -0.34522367f , 0.14683522f , 0.05595596f ,
    0.02237034f , -0.06316542f , -0.01048143f , -0.27361876f , 0.01327775f , 0.01156603f , -0.02656291f , -0.30384147f , -0.39207165f , 0.02401410f , -0.01835587f , 0.05743541f , -0.37923460f , 0.21265931f , 0.57306648f , 0.29538200f , -0.06625719f , 0.44038905f , 0.54409558f , 0.06943242f , 0.86241612f , 0.52782911f , 0.13063215f , -0.00969728f ,
    0.11622122f , 0.02224264f , 0.32680233f , 0.00674035f , -0.18269996f , -0.07149903f , -0.38216845f , 0.11519523f , 0.15289458f , 0.02026007f , 0.31202256f , 0.38286848f , 0.06066707f , -0.11169249f , -0.10677312f , -0.20147411f , 0.01167547f , 0.11246367f , -0.70525138f , -0.69991387f , 1.00946560f , 0.95344512f , -0.75251996f , 0.27342287f
};

const float * const cdk_37bits[] = { cdk_37bits_1, cdk_37bits_2, cdk_37bits_3, cdk_37bits_4, cdk_37bits_5, cdk_37bits_6 };


/* Sine tables for FFT */
/* for (j=0 ; j<hs->fftlen/2+1 ; j++) hs->fftSineTab[j] = (float)sin(2.0*EVS_PI*j/hs->fftlen); */


const float fftSineTab640[321] =
{
    0.0000000000000000000000000f,    0.0098173199221491814000000f,    0.0196336936205625530000000f,    0.0294481739401817320000000f,    0.0392598174512386320000000f,    0.0490676760673522950000000f,    0.0588708035647869110000000f,    0.0686682611703872680000000f,    0.0784590989351272580000000f,    0.0882423743605613710000000f,
    0.0980171412229537960000000f,    0.1077824681997299200000000f,    0.1175374016165733300000000f,    0.1272810101509094200000000f,    0.1370123475790023800000000f,    0.1467304825782775900000000f,    0.1564344763755798300000000f,    0.1661233752965927100000000f,    0.1757962852716445900000000f,    0.1854522377252578700000000f,
    0.1950903236865997300000000f,    0.2047096043825149500000000f,    0.2143091559410095200000000f,    0.2238880544900894200000000f,    0.2334453761577606200000000f,    0.2429801821708679200000000f,    0.2524915933609008800000000f,    0.2619786560535430900000000f,    0.2714404463768005400000000f,    0.2808761000633239700000000f,
    0.2902846932411193800000000f,    0.2996652722358703600000000f,    0.3090170025825500500000000f,    0.3183389306068420400000000f,    0.3276301920413970900000000f,    0.3368898630142211900000000f,    0.3461170792579650900000000f,    0.3553109169006347700000000f,    0.3644705116748809800000000f,    0.3735949695110321000000000f,
    0.3826834559440612800000000f,    0.3917350172996521000000000f,    0.4007488489151001000000000f,    0.4097240269184112500000000f,    0.4186597466468811000000000f,    0.4275551140308380100000000f,    0.4364092648029327400000000f,    0.4452213346958160400000000f,    0.4539905190467834500000000f,    0.4627159237861633300000000f,
    0.4713967442512512200000000f,    0.4800321459770202600000000f,    0.4886212646961212200000000f,    0.4971632659435272200000000f,    0.5056573748588562000000000f,    0.5141027569770813000000000f,    0.5224985480308532700000000f,    0.5308440327644348100000000f,    0.5391383171081543000000000f,    0.5473806858062744100000000f,
    0.5555702447891235400000000f,    0.5637062788009643600000000f,    0.5717879533767700200000000f,    0.5798145532608032200000000f,    0.5877852439880371100000000f,    0.5956993103027343800000000f,    0.6035559773445129400000000f,    0.6113544106483459500000000f,    0.6190939545631408700000000f,    0.6267738342285156300000000f,
    0.6343932747840881300000000f,    0.6419516205787658700000000f,    0.6494480371475219700000000f,    0.6568819284439086900000000f,    0.6642524600028991700000000f,    0.6715589761734008800000000f,    0.6788007616996765100000000f,    0.6859771013259887700000000f,    0.6930873990058898900000000f,    0.7001308202743530300000000f,
    0.7071067690849304200000000f,    0.7140145897865295400000000f,    0.7208536267280578600000000f,    0.7276231050491333000000000f,    0.7343225479125976600000000f,    0.7409511208534240700000000f,    0.7475083470344543500000000f,    0.7539935111999511700000000f,    0.7604059576988220200000000f,    0.7667451500892639200000000f,
    0.7730104923248291000000000f,    0.7792012691497802700000000f,    0.7853169441223144500000000f,    0.7913569211959838900000000f,    0.7973206639289856000000000f,    0.8032075762748718300000000f,    0.8090170025825500500000000f,    0.8147485256195068400000000f,    0.8204014301300048800000000f,    0.8259753584861755400000000f,
    0.8314696550369262700000000f,    0.8368837833404541000000000f,    0.8422172665596008300000000f,    0.8474695682525634800000000f,    0.8526401519775390600000000f,    0.8577286005020141600000000f,    0.8627343773841857900000000f,    0.8676570057868957500000000f,    0.8724960088729858400000000f,    0.8772509098052978500000000f,
    0.8819212913513183600000000f,    0.8865066170692443800000000f,    0.8910065293312072800000000f,    0.8954205513000488300000000f,    0.8997483253479003900000000f,    0.9039893150329589800000000f,    0.9081431627273559600000000f,    0.9122095108032226600000000f,    0.9161879420280456500000000f,    0.9200780987739563000000000f,
    0.9238795638084411600000000f,    0.9275919198989868200000000f,    0.9312149286270141600000000f,    0.9347481727600097700000000f,    0.9381913542747497600000000f,    0.9415440559387207000000000f,    0.9448060393333435100000000f,    0.9479769468307495100000000f,    0.9510565400123596200000000f,    0.9540444016456604000000000f,
    0.9569403529167175300000000f,    0.9597440361976623500000000f,    0.9624552726745605500000000f,    0.9650737047195434600000000f,    0.9675990939140319800000000f,    0.9700312614440918000000000f,    0.9723699092864990200000000f,    0.9746148586273193400000000f,    0.9767658710479736300000000f,    0.9788227677345275900000000f,
    0.9807853102684021000000000f,    0.9826532602310180700000000f,    0.9844265580177307100000000f,    0.9861049652099609400000000f,    0.9876883625984191900000000f,    0.9891765117645263700000000f,    0.9905693531036377000000000f,    0.9918667078018188500000000f,    0.9930684566497802700000000f,    0.9941744804382324200000000f,
    0.9951847195625305200000000f,    0.9960990548133850100000000f,    0.9969173073768615700000000f,    0.9976395368576049800000000f,    0.9982656240463256800000000f,    0.9987954497337341300000000f,    0.9992290139198303200000000f,    0.9995663166046142600000000f,    0.9998072385787963900000000f,    0.9999517798423767100000000f,
    1.0000000000000000000000000f,    0.9999517798423767100000000f,    0.9998072385787963900000000f,    0.9995663166046142600000000f,    0.9992290139198303200000000f,    0.9987954497337341300000000f,    0.9982656240463256800000000f,    0.9976395368576049800000000f,    0.9969173073768615700000000f,    0.9960990548133850100000000f,
    0.9951847195625305200000000f,    0.9941744804382324200000000f,    0.9930684566497802700000000f,    0.9918667078018188500000000f,    0.9905693531036377000000000f,    0.9891765117645263700000000f,    0.9876883625984191900000000f,    0.9861049652099609400000000f,    0.9844265580177307100000000f,    0.9826532602310180700000000f,
    0.9807852506637573200000000f,    0.9788227677345275900000000f,    0.9767658710479736300000000f,    0.9746148586273193400000000f,    0.9723699092864990200000000f,    0.9700312614440918000000000f,    0.9675990939140319800000000f,    0.9650736451148986800000000f,    0.9624552130699157700000000f,    0.9597440361976623500000000f,
    0.9569402933120727500000000f,    0.9540444016456604000000000f,    0.9510564804077148400000000f,    0.9479769468307495100000000f,    0.9448060393333435100000000f,    0.9415440559387207000000000f,    0.9381912946701049800000000f,    0.9347481727600097700000000f,    0.9312149286270141600000000f,    0.9275919198989868200000000f,
    0.9238795042037963900000000f,    0.9200780391693115200000000f,    0.9161879420280456500000000f,    0.9122095108032226600000000f,    0.9081431627273559600000000f,    0.9039892554283142100000000f,    0.8997482657432556200000000f,    0.8954205513000488300000000f,    0.8910064697265625000000000f,    0.8865066170692443800000000f,
    0.8819212317466735800000000f,    0.8772509098052978500000000f,    0.8724959492683410600000000f,    0.8676570057868957500000000f,    0.8627343773841857900000000f,    0.8577286005020141600000000f,    0.8526401519775390600000000f,    0.8474695086479187000000000f,    0.8422172069549560500000000f,    0.8368837237358093300000000f,
    0.8314695954322814900000000f,    0.8259752988815307600000000f,    0.8204014301300048800000000f,    0.8147484660148620600000000f,    0.8090169429779052700000000f,    0.8032075166702270500000000f,    0.7973206043243408200000000f,    0.7913568615913391100000000f,    0.7853168845176696800000000f,    0.7792012095451355000000000f,
    0.7730104327201843300000000f,    0.7667450904846191400000000f,    0.7604058980941772500000000f,    0.7539934515953064000000000f,    0.7475082874298095700000000f,    0.7409510612487793000000000f,    0.7343224883079528800000000f,    0.7276230454444885300000000f,    0.7208535671234130900000000f,    0.7140145301818847700000000f,
    0.7071067094802856400000000f,    0.7001307606697082500000000f,    0.6930873394012451200000000f,    0.6859770417213439900000000f,    0.6788007020950317400000000f,    0.6715589165687561000000000f,    0.6642524003982543900000000f,    0.6568818688392639200000000f,    0.6494479775428772000000000f,    0.6419515609741210900000000f,
    0.6343932151794433600000000f,    0.6267737746238708500000000f,    0.6190938949584960900000000f,    0.6113543510437011700000000f,    0.6035558581352233900000000f,    0.5956992506980896000000000f,    0.5877851843833923300000000f,    0.5798144936561584500000000f,    0.5717878937721252400000000f,    0.5637062191963195800000000f,
    0.5555701851844787600000000f,    0.5473806262016296400000000f,    0.5391382575035095200000000f,    0.5308439731597900400000000f,    0.5224984884262085000000000f,    0.5141026973724365200000000f,    0.5056573152542114300000000f,    0.4971632063388824500000000f,    0.4886211752891540500000000f,    0.4800320565700531000000000f,
    0.4713966846466064500000000f,    0.4627158641815185500000000f,    0.4539904296398162800000000f,    0.4452212452888488800000000f,    0.4364091753959655800000000f,    0.4275550246238708500000000f,    0.4186596572399139400000000f,    0.4097239673137664800000000f,    0.4007487595081329300000000f,    0.3917349278926849400000000f,
    0.3826833665370941200000000f,    0.3735949099063873300000000f,    0.3644704222679138200000000f,    0.3553108274936676000000000f,    0.3461169898509979200000000f,    0.3368897736072540300000000f,    0.3276301026344299300000000f,    0.3183388411998748800000000f,    0.3090169131755828900000000f,    0.2996652126312255900000000f,
    0.2902846038341522200000000f,    0.2808760106563568100000000f,    0.2714403867721557600000000f,    0.2619785666465759300000000f,    0.2524915039539337200000000f,    0.2429801076650619500000000f,    0.2334452867507934600000000f,    0.2238879650831222500000000f,    0.2143090665340423600000000f,    0.2047095298767089800000000f,
    0.1950902342796325700000000f,    0.1854521632194519000000000f,    0.1757961958646774300000000f,    0.1661233007907867400000000f,    0.1564343869686126700000000f,    0.1467303931713104200000000f,    0.1370122581720352200000000f,    0.1272809207439422600000000f,    0.1175373122096061700000000f,    0.1077823787927627600000000f,
    0.0980170592665672300000000f,    0.0882422849535942080000000f,    0.0784590095281600950000000f,    0.0686681717634201050000000f,    0.0588707178831100460000000f,    0.0490675866603851320000000f,    0.0392597280442714690000000f,    0.0294480863958597180000000f,    0.0196336060762405400000000f,    0.0098172323778271675000000f,
    -0.0000000874227765734758580f
};

/* Analysis windows for overlap-add */
/* ener = 0.f;
  for (j=0 ; j<hs->fftlen ; j++)
  {
    hs->olapWinAna[j] = (float)sin(EVS_PI*((float)j+0.5f)/(float)(hs->fftlen));
    ener += hs->olapWinAna[j]*hs->olapWinAna[j];
  }
  ener = (float)sqrt( ener / (float)hs->fftlen );
  for (j=0 ; j<hs->fftlen ; j++)
  {
    hs->olapWinAna[j] /= ener;
  } */
const float olapWinAna512[512] =
{
    0.0043387459591031075000000f,    0.0130160758271813390000000f,    0.0216929148882627490000000f,    0.0303689353168010710000000f,    0.0390438176691532140000000f,    0.0477172248065471650000000f,    0.0563888400793075560000000f,    0.0650583282113075260000000f,    0.0737253651022911070000000f,    0.0823896303772926330000000f,
    0.0910507962107658390000000f,    0.0997085273265838620000000f,    0.1083625108003616300000000f,    0.1170124113559722900000000f,    0.1256579011678695700000000f,    0.1342986673116684000000000f,    0.1429343819618225100000000f,    0.1515647023916244500000000f,    0.1601893156766891500000000f,    0.1688079088926315300000000f,
    0.1774201542139053300000000f,    0.1860256940126419100000000f,    0.1946242451667785600000000f,    0.2032154798507690400000000f,    0.2117990404367446900000000f,    0.2203746438026428200000000f,    0.2289419323205947900000000f,    0.2375006377696991000000000f,    0.2460503578186035200000000f,    0.2545908391475677500000000f,
    0.2631217241287231400000000f,    0.2716427147388458300000000f,    0.2801534831523895300000000f,    0.2886536717414856000000000f,    0.2971430122852325400000000f,    0.3056211769580841100000000f,    0.3140878379344940200000000f,    0.3225426375865936300000000f,    0.3309853076934814500000000f,    0.3394155502319335900000000f,
    0.3478329777717590300000000f,    0.3562373220920562700000000f,    0.3646282255649566700000000f,    0.3730054795742034900000000f,    0.3813686370849609400000000f,    0.3897174298763275100000000f,    0.3980515301227569600000000f,    0.4063706994056701700000000f,    0.4146745502948761000000000f,    0.4229627549648284900000000f,
    0.4312350451946258500000000f,    0.4394911527633667000000000f,    0.4477306604385376000000000f,    0.4559533298015594500000000f,    0.4641588330268859900000000f,    0.4723468720912933300000000f,    0.4805171191692352300000000f,    0.4886692464351654100000000f,    0.4968029856681823700000000f,    0.5049180388450622600000000f,
    0.5130140781402587900000000f,    0.5210908055305481000000000f,    0.5291479229927063000000000f,    0.5371851325035095200000000f,    0.5452020764350891100000000f,    0.5531984567642211900000000f,    0.5611740946769714400000000f,    0.5691285729408264200000000f,    0.5770615935325622600000000f,    0.5849729180335998500000000f,
    0.5928622484207153300000000f,    0.6007292270660400400000000f,    0.6085735559463501000000000f,    0.6163949966430664100000000f,    0.6241932511329650900000000f,    0.6319679617881774900000000f,    0.6397189497947692900000000f,    0.6474457979202270500000000f,    0.6551482677459716800000000f,    0.6628261208534240700000000f,
    0.6704789996147155800000000f,    0.6781066060066223100000000f,    0.6857087016105651900000000f,    0.6932849884033203100000000f,    0.7008351087570190400000000f,    0.7083588838577270500000000f,    0.7158560752868652300000000f,    0.7233262658119201700000000f,    0.7307691574096679700000000f,    0.7381845116615295400000000f,
    0.7455722093582153300000000f,    0.7529317140579223600000000f,    0.7602629661560058600000000f,    0.7675655484199523900000000f,    0.7748392224311828600000000f,    0.7820837497711181600000000f,    0.7892987728118896500000000f,    0.7964841723442077600000000f,    0.8036395311355590800000000f,    0.8107646703720092800000000f,
    0.8178592920303344700000000f,    0.8249230980873107900000000f,    0.8319557905197143600000000f,    0.8389572501182556200000000f,    0.8459270596504211400000000f,    0.8528650403022766100000000f,    0.8597708344459533700000000f,    0.8666443228721618700000000f,    0.8734852671623230000000000f,    0.8802932500839233400000000f,
    0.8870680332183837900000000f,    0.8938094973564147900000000f,    0.9005173444747924800000000f,    0.9071912169456481900000000f,    0.9138309359550476100000000f,    0.9204362630844116200000000f,    0.9270069003105163600000000f,    0.9335426688194274900000000f,    0.9400433301925659200000000f,    0.9465085864067077600000000f,
    0.9529381394386291500000000f,    0.9593318104743957500000000f,    0.9656894207000732400000000f,    0.9720106720924377400000000f,    0.9782953858375549300000000f,    0.9845431447029113800000000f,    0.9907538890838623000000000f,    0.9969274401664733900000000f,    1.0030633211135864000000000f,    1.0091614723205566000000000f,
    1.0152215957641602000000000f,    1.0212435722351074000000000f,    1.0272270441055298000000000f,    1.0331718921661377000000000f,    1.0390777587890625000000000f,    1.0449445247650146000000000f,    1.0507719516754150000000000f,    1.0565599203109741000000000f,    1.0623079538345337000000000f,    1.0680160522460937000000000f,
    1.0736839771270752000000000f,    1.0793114900588989000000000f,    1.0848982334136963000000000f,    1.0904443264007568000000000f,    1.0959492921829224000000000f,    1.1014128923416138000000000f,    1.1068351268768311000000000f,    1.1122156381607056000000000f,    1.1175543069839478000000000f,    1.1228508949279785000000000f,
    1.1281052827835083000000000f,    1.1333171129226685000000000f,    1.1384862661361694000000000f,    1.1436126232147217000000000f,    1.1486958265304565000000000f,    1.1537358760833740000000000f,    1.1587324142456055000000000f,    1.1636853218078613000000000f,    1.1685944795608521000000000f,    1.1734596490859985000000000f,
    1.1782805919647217000000000f,    1.1830571889877319000000000f,    1.1877892017364502000000000f,    1.1924765110015869000000000f,    1.1971189975738525000000000f,    1.2017163038253784000000000f,    1.2062685489654541000000000f,    1.2107752561569214000000000f,    1.2152363061904907000000000f,    1.2196516990661621000000000f,
    1.2240210771560669000000000f,    1.2283445596694946000000000f,    1.2326216697692871000000000f,    1.2368522882461548000000000f,    1.2410365343093872000000000f,    1.2451739311218262000000000f,    1.2492644786834717000000000f,    1.2533079385757446000000000f,    1.2573043107986450000000000f,    1.2612532377243042000000000f,
    1.2651547193527222000000000f,    1.2690086364746094000000000f,    1.2728147506713867000000000f,    1.2765728235244751000000000f,    1.2802829742431641000000000f,    1.2839449644088745000000000f,    1.2875584363937378000000000f,    1.2911235094070435000000000f,    1.2946400642395020000000000f,    1.2981077432632446000000000f,
    1.3015266656875610000000000f,    1.3048964738845825000000000f,    1.3082171678543091000000000f,    1.3114887475967407000000000f,    1.3147107362747192000000000f,    1.3178833723068237000000000f,    1.3210064172744751000000000f,    1.3240796327590942000000000f,    1.3271030187606812000000000f,    1.3300764560699463000000000f,
    1.3329998254776001000000000f,    1.3358730077743530000000000f,    1.3386958837509155000000000f,    1.3414683341979980000000000f,    1.3441903591156006000000000f,    1.3468616008758545000000000f,    1.3494822978973389000000000f,    1.3520522117614746000000000f,    1.3545711040496826000000000f,    1.3570390939712524000000000f,
    1.3594559431076050000000000f,    1.3618216514587402000000000f,    1.3641359806060791000000000f,    1.3663990497589111000000000f,    1.3686106204986572000000000f,    1.3707706928253174000000000f,    1.3728791475296021000000000f,    1.3749359846115112000000000f,    1.3769409656524658000000000f,    1.3788940906524658000000000f,
    1.3807953596115112000000000f,    1.3826445341110229000000000f,    1.3844418525695801000000000f,    1.3861869573593140000000000f,    1.3878798484802246000000000f,    1.3895204067230225000000000f,    1.3911087512969971000000000f,    1.3926446437835693000000000f,    1.3941282033920288000000000f,    1.3955593109130859000000000f,
    1.3969377279281616000000000f,    1.3982635736465454000000000f,    1.3995368480682373000000000f,    1.4007574319839478000000000f,    1.4019253253936768000000000f,    1.4030404090881348000000000f,    1.4041025638580322000000000f,    1.4051119089126587000000000f,    1.4060683250427246000000000f,    1.4069718122482300000000000f,
    1.4078224897384644000000000f,    1.4086199998855591000000000f,    1.4093644618988037000000000f,    1.4100558757781982000000000f,    1.4106942415237427000000000f,    1.4112794399261475000000000f,    1.4118115901947021000000000f,    1.4122905731201172000000000f,    1.4127163887023926000000000f,    1.4130889177322388000000000f,
    1.4134082794189453000000000f,    1.4136744737625122000000000f,    1.4138875007629395000000000f,    1.4140472412109375000000000f,    1.4141536951065063000000000f,    1.4142069816589355000000000f,    1.4142069816589355000000000f,    1.4141536951065063000000000f,    1.4140472412109375000000000f,    1.4138875007629395000000000f,
    1.4136744737625122000000000f,    1.4134082794189453000000000f,    1.4130889177322388000000000f,    1.4127163887023926000000000f,    1.4122905731201172000000000f,    1.4118115901947021000000000f,    1.4112794399261475000000000f,    1.4106942415237427000000000f,    1.4100558757781982000000000f,    1.4093644618988037000000000f,
    1.4086199998855591000000000f,    1.4078224897384644000000000f,    1.4069718122482300000000000f,    1.4060683250427246000000000f,    1.4051119089126587000000000f,    1.4041025638580322000000000f,    1.4030402898788452000000000f,    1.4019252061843872000000000f,    1.4007574319839478000000000f,    1.3995368480682373000000000f,
    1.3982635736465454000000000f,    1.3969377279281616000000000f,    1.3955591917037964000000000f,    1.3941282033920288000000000f,    1.3926446437835693000000000f,    1.3911087512969971000000000f,    1.3895204067230225000000000f,    1.3878798484802246000000000f,    1.3861868381500244000000000f,    1.3844418525695801000000000f,
    1.3826445341110229000000000f,    1.3807953596115112000000000f,    1.3788940906524658000000000f,    1.3769409656524658000000000f,    1.3749359846115112000000000f,    1.3728791475296021000000000f,    1.3707706928253174000000000f,    1.3686106204986572000000000f,    1.3663990497589111000000000f,    1.3641359806060791000000000f,
    1.3618216514587402000000000f,    1.3594559431076050000000000f,    1.3570389747619629000000000f,    1.3545711040496826000000000f,    1.3520520925521851000000000f,    1.3494822978973389000000000f,    1.3468616008758545000000000f,    1.3441903591156006000000000f,    1.3414683341979980000000000f,    1.3386958837509155000000000f,
    1.3358730077743530000000000f,    1.3329998254776001000000000f,    1.3300764560699463000000000f,    1.3271030187606812000000000f,    1.3240796327590942000000000f,    1.3210062980651855000000000f,    1.3178833723068237000000000f,    1.3147107362747192000000000f,    1.3114886283874512000000000f,    1.3082171678543091000000000f,
    1.3048964738845825000000000f,    1.3015265464782715000000000f,    1.2981077432632446000000000f,    1.2946399450302124000000000f,    1.2911235094070435000000000f,    1.2875584363937378000000000f,    1.2839448451995850000000000f,    1.2802829742431641000000000f,    1.2765728235244751000000000f,    1.2728147506713867000000000f,
    1.2690086364746094000000000f,    1.2651547193527222000000000f,    1.2612532377243042000000000f,    1.2573041915893555000000000f,    1.2533078193664551000000000f,    1.2492643594741821000000000f,    1.2451738119125366000000000f,    1.2410364151000977000000000f,    1.2368522882461548000000000f,    1.2326216697692871000000000f,
    1.2283444404602051000000000f,    1.2240210771560669000000000f,    1.2196515798568726000000000f,    1.2152363061904907000000000f,    1.2107751369476318000000000f,    1.2062684297561646000000000f,    1.2017163038253784000000000f,    1.1971189975738525000000000f,    1.1924765110015869000000000f,    1.1877892017364502000000000f,
    1.1830570697784424000000000f,    1.1782804727554321000000000f,    1.1734595298767090000000000f,    1.1685943603515625000000000f,    1.1636853218078613000000000f,    1.1587324142456055000000000f,    1.1537357568740845000000000f,    1.1486958265304565000000000f,    1.1436125040054321000000000f,    1.1384861469268799000000000f,
    1.1333171129226685000000000f,    1.1281051635742187000000000f,    1.1228507757186890000000000f,    1.1175541877746582000000000f,    1.1122155189514160000000000f,    1.1068350076675415000000000f,    1.1014127731323242000000000f,    1.0959491729736328000000000f,    1.0904442071914673000000000f,    1.0848982334136963000000000f,
    1.0793113708496094000000000f,    1.0736838579177856000000000f,    1.0680160522460937000000000f,    1.0623078346252441000000000f,    1.0565598011016846000000000f,    1.0507718324661255000000000f,    1.0449445247650146000000000f,    1.0390776395797729000000000f,    1.0331717729568481000000000f,    1.0272269248962402000000000f,
    1.0212434530258179000000000f,    1.0152214765548706000000000f,    1.0091613531112671000000000f,    1.0030632019042969000000000f,    0.9969273209571838400000000f,    0.9907538294792175300000000f,    0.9845430850982666000000000f,    0.9782953262329101600000000f,    0.9720106124877929700000000f,    0.9656893610954284700000000f,
    0.9593317508697509800000000f,    0.9529380798339843800000000f,    0.9465084671974182100000000f,    0.9400432705879211400000000f,    0.9335426092147827100000000f,    0.9270067811012268100000000f,    0.9204362034797668500000000f,    0.9138308763504028300000000f,    0.9071910977363586400000000f,    0.9005171656608581500000000f,
    0.8938094377517700200000000f,    0.8870679140090942400000000f,    0.8802930712699890100000000f,    0.8734850883483886700000000f,    0.8666442632675170900000000f,    0.8597707748413085900000000f,    0.8528649210929870600000000f,    0.8459268808364868200000000f,    0.8389570713043212900000000f,    0.8319557309150695800000000f,
    0.8249229192733764600000000f,    0.8178591728210449200000000f,    0.8107645511627197300000000f,    0.8036394119262695300000000f,    0.7964840531349182100000000f,    0.7892987132072448700000000f,    0.7820836901664733900000000f,    0.7748391628265380900000000f,    0.7675654292106628400000000f,    0.7602628469467163100000000f,
    0.7529316544532775900000000f,    0.7455720901489257800000000f,    0.7381844520568847700000000f,    0.7307690382003784200000000f,    0.7233260869979858400000000f,    0.7158559560775756800000000f,    0.7083588242530822800000000f,    0.7008350491523742700000000f,    0.6932848691940307600000000f,    0.6857085824012756300000000f,
    0.6781064867973327600000000f,    0.6704788804054260300000000f,    0.6628260016441345200000000f,    0.6551482081413269000000000f,    0.6474456787109375000000000f,    0.6397188305854797400000000f,    0.6319679021835327100000000f,    0.6241931319236755400000000f,    0.6163948774337768600000000f,    0.6085734367370605500000000f,
    0.6007291078567504900000000f,    0.5928621292114257800000000f,    0.5849727988243103000000000f,    0.5770615339279174800000000f,    0.5691284537315368700000000f,    0.5611739754676818800000000f,    0.5531983971595764200000000f,    0.5452019572257995600000000f,    0.5371850132942199700000000f,    0.5291478037834167500000000f,
    0.5210906863212585400000000f,    0.5130139589309692400000000f,    0.5049179196357727100000000f,    0.4968028664588928200000000f,    0.4886691272258758500000000f,    0.4805169999599456800000000f,    0.4723467230796814000000000f,    0.4641586840152740500000000f,    0.4559532105922699000000000f,    0.4477305412292480500000000f,
    0.4394910335540771500000000f,    0.4312349855899810800000000f,    0.4229626357555389400000000f,    0.4146744310855865500000000f,    0.4063705503940582300000000f,    0.3980514407157897900000000f,    0.3897172808647155800000000f,    0.3813685178756713900000000f,    0.3730053603649139400000000f,    0.3646281659603118900000000f,
    0.3562372326850891100000000f,    0.3478328585624694800000000f,    0.3394154310226440400000000f,    0.3309852182865142800000000f,    0.3225425183773040800000000f,    0.3140876889228820800000000f,    0.3056210577487945600000000f,    0.2971428930759429900000000f,    0.2886535525321960400000000f,    0.2801533639430999800000000f,
    0.2716425955295562700000000f,    0.2631216049194335900000000f,    0.2545907199382782000000000f,    0.2460502535104751600000000f,    0.2375005036592483500000000f,    0.2289418131113052400000000f,    0.2203745096921920800000000f,    0.2117989212274551400000000f,    0.2032153606414794900000000f,    0.1946241259574890100000000f,
    0.1860255748033523600000000f,    0.1774200350046157800000000f,    0.1688077896833419800000000f,    0.1601892113685607900000000f,    0.1515645831823349000000000f,    0.1429342478513717700000000f,    0.1342985481023788500000000f,    0.1256577819585800200000000f,    0.1170122846961021400000000f,    0.1083623841404914900000000f,
    0.0997084006667137150000000f,    0.0910506695508956910000000f,    0.0823895111680030820000000f,    0.0737252458930015560000000f,    0.0650582015514373780000000f,    0.0563887134194374080000000f,    0.0477171018719673160000000f,    0.0390436910092830660000000f,    0.0303688123822212220000000f,    0.0216927900910377500000000f,
    0.0130159519612789150000000f,    0.0043386225588619709000000f
};

const float olapWinAna640[640] =
{
    0.0034709984902292490000000f,    0.0104129118844866750000000f,    0.0173545740544795990000000f,    0.0242958199232816700000000f,    0.0312364790588617320000000f,    0.0381763875484466550000000f,    0.0451153740286827090000000f,    0.0520532727241516110000000f,    0.0589899159967899320000000f,    0.0659251436591148380000000f,
    0.0728587806224823000000000f,    0.0797906517982482910000000f,    0.0867206156253814700000000f,    0.0936484783887863160000000f,    0.1005740910768508900000000f,    0.1074972823262214700000000f,    0.1144178733229637100000000f,    0.1213357225060463000000000f,    0.1282506436109542800000000f,    0.1351624578237533600000000f,
    0.1420710384845733600000000f,    0.1489761769771575900000000f,    0.1558777391910553000000000f,    0.1627755314111709600000000f,    0.1696694195270538300000000f,    0.1765592098236084000000000f,    0.1834447383880615200000000f,    0.1903258562088012700000000f,    0.1972023993730545000000000f,    0.2040741592645645100000000f,
    0.2109410166740417500000000f,    0.2178028076887130700000000f,    0.2246593385934829700000000f,    0.2315104454755783100000000f,    0.2383559793233871500000000f,    0.2451957911252975500000000f,    0.2520296573638916000000000f,    0.2588574886322021500000000f,    0.2656790614128112800000000f,    0.2724942266941070600000000f,
    0.2793028354644775400000000f,    0.2861047089099884000000000f,    0.2928997278213501000000000f,    0.2996876239776611300000000f,    0.3064683377742767300000000f,    0.3132416605949401900000000f,    0.3200074136257171600000000f,    0.3267655074596405000000000f,    0.3335156738758087200000000f,    0.3402578532695770300000000f,
    0.3469918072223663300000000f,    0.3537174165248870800000000f,    0.3604344725608825700000000f,    0.3671428561210632300000000f,    0.3738423883914947500000000f,    0.3805329203605651900000000f,    0.3872142732143402100000000f,    0.3938862979412078900000000f,    0.4005488157272338900000000f,    0.4072017371654510500000000f,
    0.4138447940349578900000000f,    0.4204779267311096200000000f,    0.4271008670330047600000000f,    0.4337135851383209200000000f,    0.4403158128261566200000000f,    0.4469074010848999000000000f,    0.4534882903099060100000000f,    0.4600581824779510500000000f,    0.4666170477867126500000000f,    0.4731646478176116900000000f,
    0.4797008633613586400000000f,    0.4862254858016967800000000f,    0.4927383959293365500000000f,    0.4992394745349884000000000f,    0.5057284832000732400000000f,    0.5122053027153015100000000f,    0.5186697840690612800000000f,    0.5251218080520629900000000f,    0.5315611362457275400000000f,    0.5379876494407653800000000f,
    0.5444012284278869600000000f,    0.5508016943931579600000000f,    0.5571888685226440400000000f,    0.5635626316070556600000000f,    0.5699228048324585000000000f,    0.5762692093849182100000000f,    0.5826017856597900400000000f,    0.5889202952384948700000000f,    0.5952246189117431600000000f,    0.6015146374702453600000000f,
    0.6077901124954223600000000f,    0.6140509843826293900000000f,    0.6202970147132873500000000f,    0.6265281438827514600000000f,    0.6327440738677978500000000f,    0.6389448642730712900000000f,    0.6451302766799926800000000f,    0.6513000726699829100000000f,    0.6574541926383972200000000f,    0.6635924577713012700000000f,
    0.6697147488594055200000000f,    0.6758209466934204100000000f,    0.6819108128547668500000000f,    0.6879842281341552700000000f,    0.6940411329269409200000000f,    0.7000812292098999000000000f,    0.7061045169830322300000000f,    0.7121107578277587900000000f,    0.7180998921394348100000000f,    0.7240716814994812000000000f,
    0.7300260066986084000000000f,    0.7359628081321716300000000f,    0.7418818473815918000000000f,    0.7477830052375793500000000f,    0.7536661028861999500000000f,    0.7595310807228088400000000f,    0.7653777003288269000000000f,    0.7712059617042541500000000f,    0.7770156264305114700000000f,    0.7828065156936645500000000f,
    0.7885786294937133800000000f,    0.7943316698074340800000000f,    0.8000655770301818800000000f,    0.8057801723480224600000000f,    0.8114753961563110400000000f,    0.8171511292457580600000000f,    0.8228070735931396500000000f,    0.8284432291984558100000000f,    0.8340594172477722200000000f,    0.8396555185317993200000000f,
    0.8452314138412475600000000f,    0.8507869243621826200000000f,    0.8563219308853149400000000f,    0.8618362545967102100000000f,    0.8673298358917236300000000f,    0.8728026151657104500000000f,    0.8782541751861572300000000f,    0.8836847543716430700000000f,    0.8890939354896545400000000f,    0.8944817185401916500000000f,
    0.8998479843139648400000000f,    0.9051925539970397900000000f,    0.9105152487754821800000000f,    0.9158160686492919900000000f,    0.9210947751998901400000000f,    0.9263513088226318400000000f,    0.9315855503082275400000000f,    0.9367973208427429200000000f,    0.9419865608215332000000000f,    0.9471529722213745100000000f,
    0.9522966742515564000000000f,    0.9574174284934997600000000f,    0.9625151157379150400000000f,    0.9675895571708679200000000f,    0.9726406931877136200000000f,    0.9776684641838073700000000f,    0.9826726913452148400000000f,    0.9876530766487121600000000f,    0.9926097989082336400000000f,    0.9975425601005554200000000f,
    1.0024513006210327000000000f,    1.0073359012603760000000000f,    1.0121961832046509000000000f,    1.0170321464538574000000000f,    1.0218435525894165000000000f,    1.0266302824020386000000000f,    1.0313923358917236000000000f,    1.0361295938491821000000000f,    1.0408418178558350000000000f,    1.0455290079116821000000000f,
    1.0501909255981445000000000f,    1.0548275709152222000000000f,    1.0594388246536255000000000f,    1.0640245676040649000000000f,    1.0685845613479614000000000f,    1.0731189250946045000000000f,    1.0776274204254150000000000f,    1.0821099281311035000000000f,    1.0865663290023804000000000f,    1.0909965038299561000000000f,
    1.0954004526138306000000000f,    1.0997780561447144000000000f,    1.1041290760040283000000000f,    1.1084536314010620000000000f,    1.1127513647079468000000000f,    1.1170222759246826000000000f,    1.1212662458419800000000000f,    1.1254832744598389000000000f,    1.1296732425689697000000000f,    1.1338359117507935000000000f,
    1.1379711627960205000000000f,    1.1420791149139404000000000f,    1.1461595296859741000000000f,    1.1502122879028320000000000f,    1.1542373895645142000000000f,    1.1582345962524414000000000f,    1.1622040271759033000000000f,    1.1661453247070312000000000f,    1.1700586080551147000000000f,    1.1739436388015747000000000f,
    1.1778002977371216000000000f,    1.1816288232803345000000000f,    1.1854286193847656000000000f,    1.1892000436782837000000000f,    1.1929427385330200000000000f,    1.1966567039489746000000000f,    1.2003418207168579000000000f,    1.2039979696273804000000000f,    1.2076252698898315000000000f,    1.2112232446670532000000000f,
    1.2147921323776245000000000f,    1.2183318138122559000000000f,    1.2218420505523682000000000f,    1.2253229618072510000000000f,    1.2287741899490356000000000f,    1.2321958541870117000000000f,    1.2355878353118896000000000f,    1.2389501333236694000000000f,    1.2422825098037720000000000f,    1.2455849647521973000000000f,
    1.2488573789596558000000000f,    1.2520997524261475000000000f,    1.2553119659423828000000000f,    1.2584939002990723000000000f,    1.2616454362869263000000000f,    1.2647666931152344000000000f,    1.2678573131561279000000000f,    1.2709175348281860000000000f,    1.2739471197128296000000000f,    1.2769459486007690000000000f,
    1.2799140214920044000000000f,    1.2828512191772461000000000f,    1.2857576608657837000000000f,    1.2886329889297485000000000f,    1.2914773225784302000000000f,    1.2942904233932495000000000f,    1.2970724105834961000000000f,    1.2998231649398804000000000f,    1.3025425672531128000000000f,    1.3052306175231934000000000f,
    1.3078873157501221000000000f,    1.3105123043060303000000000f,    1.3131058216094971000000000f,    1.3156676292419434000000000f,    1.3181978464126587000000000f,    1.3206962347030640000000000f,    1.3231627941131592000000000f,    1.3255974054336548000000000f,    1.3280001878738403000000000f,    1.3303710222244263000000000f,
    1.3327096700668335000000000f,    1.3350162506103516000000000f,    1.3372906446456909000000000f,    1.3395328521728516000000000f,    1.3417427539825439000000000f,    1.3439202308654785000000000f,    1.3460655212402344000000000f,    1.3481782674789429000000000f,    1.3502584695816040000000000f,    1.3523062467575073000000000f,
    1.3543214797973633000000000f,    1.3563039302825928000000000f,    1.3582537174224854000000000f,    1.3601709604263306000000000f,    1.3620551824569702000000000f,    1.3639067411422729000000000f,    1.3657253980636597000000000f,    1.3675111532211304000000000f,    1.3692638874053955000000000f,    1.3709838390350342000000000f,
    1.3726705312728882000000000f,    1.3743242025375366000000000f,    1.3759448528289795000000000f,    1.3775322437286377000000000f,    1.3790863752365112000000000f,    1.3806074857711792000000000f,    1.3820952177047729000000000f,    1.3835495710372925000000000f,    1.3849706649780273000000000f,    1.3863584995269775000000000f,
    1.3877127170562744000000000f,    1.3890335559844971000000000f,    1.3903210163116455000000000f,    1.3915749788284302000000000f,    1.3927953243255615000000000f,    1.3939821720123291000000000f,    1.3951354026794434000000000f,    1.3962548971176147000000000f,    1.3973408937454224000000000f,    1.3983932733535767000000000f,
    1.3994117975234985000000000f,    1.4003967046737671000000000f,    1.4013478755950928000000000f,    1.4022653102874756000000000f,    1.4031487703323364000000000f,    1.4039986133575439000000000f,    1.4048146009445190000000000f,    1.4055966138839722000000000f,    1.4063447713851929000000000f,    1.4070591926574707000000000f,
    1.4077396392822266000000000f,    1.4083861112594604000000000f,    1.4089987277984619000000000f,    1.4095773696899414000000000f,    1.4101220369338989000000000f,    1.4106327295303345000000000f,    1.4111093282699585000000000f,    1.4115520715713501000000000f,    1.4119608402252197000000000f,    1.4123353958129883000000000f,
    1.4126759767532349000000000f,    1.4129825830459595000000000f,    1.4132552146911621000000000f,    1.4134936332702637000000000f,    1.4136980772018433000000000f,    1.4138684272766113000000000f,    1.4140048027038574000000000f,    1.4141069650650024000000000f,    1.4141751527786255000000000f,    1.4142091274261475000000000f,
    1.4142091274261475000000000f,    1.4141751527786255000000000f,    1.4141069650650024000000000f,    1.4140048027038574000000000f,    1.4138684272766113000000000f,    1.4136980772018433000000000f,    1.4134936332702637000000000f,    1.4132550954818726000000000f,    1.4129825830459595000000000f,    1.4126759767532349000000000f,
    1.4123353958129883000000000f,    1.4119607210159302000000000f,    1.4115520715713501000000000f,    1.4111093282699585000000000f,    1.4106327295303345000000000f,    1.4101220369338989000000000f,    1.4095773696899414000000000f,    1.4089987277984619000000000f,    1.4083861112594604000000000f,    1.4077396392822266000000000f,
    1.4070591926574707000000000f,    1.4063447713851929000000000f,    1.4055966138839722000000000f,    1.4048146009445190000000000f,    1.4039986133575439000000000f,    1.4031487703323364000000000f,    1.4022653102874756000000000f,    1.4013477563858032000000000f,    1.4003967046737671000000000f,    1.3994117975234985000000000f,
    1.3983932733535767000000000f,    1.3973408937454224000000000f,    1.3962548971176147000000000f,    1.3951354026794434000000000f,    1.3939821720123291000000000f,    1.3927953243255615000000000f,    1.3915748596191406000000000f,    1.3903210163116455000000000f,    1.3890335559844971000000000f,    1.3877127170562744000000000f,
    1.3863583803176880000000000f,    1.3849706649780273000000000f,    1.3835495710372925000000000f,    1.3820950984954834000000000f,    1.3806074857711792000000000f,    1.3790863752365112000000000f,    1.3775322437286377000000000f,    1.3759448528289795000000000f,    1.3743242025375366000000000f,    1.3726705312728882000000000f,
    1.3709837198257446000000000f,    1.3692638874053955000000000f,    1.3675111532211304000000000f,    1.3657253980636597000000000f,    1.3639067411422729000000000f,    1.3620551824569702000000000f,    1.3601708412170410000000000f,    1.3582537174224854000000000f,    1.3563039302825928000000000f,    1.3543213605880737000000000f,
    1.3523062467575073000000000f,    1.3502584695816040000000000f,    1.3481782674789429000000000f,    1.3460655212402344000000000f,    1.3439202308654785000000000f,    1.3417427539825439000000000f,    1.3395328521728516000000000f,    1.3372905254364014000000000f,    1.3350161314010620000000000f,    1.3327096700668335000000000f,
    1.3303709030151367000000000f,    1.3280001878738403000000000f,    1.3255974054336548000000000f,    1.3231626749038696000000000f,    1.3206962347030640000000000f,    1.3181978464126587000000000f,    1.3156676292419434000000000f,    1.3131058216094971000000000f,    1.3105123043060303000000000f,    1.3078871965408325000000000f,
    1.3052306175231934000000000f,    1.3025425672531128000000000f,    1.2998231649398804000000000f,    1.2970724105834961000000000f,    1.2942904233932495000000000f,    1.2914772033691406000000000f,    1.2886328697204590000000000f,    1.2857575416564941000000000f,    1.2828512191772461000000000f,    1.2799140214920044000000000f,
    1.2769459486007690000000000f,    1.2739471197128296000000000f,    1.2709175348281860000000000f,    1.2678573131561279000000000f,    1.2647665739059448000000000f,    1.2616454362869263000000000f,    1.2584937810897827000000000f,    1.2553118467330933000000000f,    1.2520996332168579000000000f,    1.2488572597503662000000000f,
    1.2455849647521973000000000f,    1.2422825098037720000000000f,    1.2389501333236694000000000f,    1.2355878353118896000000000f,    1.2321958541870117000000000f,    1.2287741899490356000000000f,    1.2253228425979614000000000f,    1.2218420505523682000000000f,    1.2183316946029663000000000f,    1.2147921323776245000000000f,
    1.2112232446670532000000000f,    1.2076251506805420000000000f,    1.2039978504180908000000000f,    1.2003417015075684000000000f,    1.1966565847396851000000000f,    1.1929427385330200000000000f,    1.1891999244689941000000000f,    1.1854286193847656000000000f,    1.1816287040710449000000000f,    1.1778002977371216000000000f,
    1.1739435195922852000000000f,    1.1700584888458252000000000f,    1.1661452054977417000000000f,    1.1622039079666138000000000f,    1.1582344770431519000000000f,    1.1542372703552246000000000f,    1.1502121686935425000000000f,    1.1461594104766846000000000f,    1.1420789957046509000000000f,    1.1379710435867310000000000f,
    1.1338357925415039000000000f,    1.1296731233596802000000000f,    1.1254831552505493000000000f,    1.1212662458419800000000000f,    1.1170221567153931000000000f,    1.1127512454986572000000000f,    1.1084535121917725000000000f,    1.1041289567947388000000000f,    1.0997780561447144000000000f,    1.0954004526138306000000000f,
    1.0909965038299561000000000f,    1.0865662097930908000000000f,    1.0821098089218140000000000f,    1.0776273012161255000000000f,    1.0731188058853149000000000f,    1.0685844421386719000000000f,    1.0640244483947754000000000f,    1.0594387054443359000000000f,    1.0548274517059326000000000f,    1.0501908063888550000000000f,
    1.0455288887023926000000000f,    1.0408416986465454000000000f,    1.0361294746398926000000000f,    1.0313922166824341000000000f,    1.0266302824020386000000000f,    1.0218434333801270000000000f,    1.0170320272445679000000000f,    1.0121960639953613000000000f,    1.0073357820510864000000000f,    1.0024513006210327000000000f,
    0.9975425004959106400000000f,    0.9926097393035888700000000f,    0.9876530170440673800000000f,    0.9826725125312805200000000f,    0.9776684045791626000000000f,    0.9726406335830688500000000f,    0.9675894975662231400000000f,    0.9625149965286254900000000f,    0.9574173688888549800000000f,    0.9522966146469116200000000f,
    0.9471529126167297400000000f,    0.9419864416122436500000000f,    0.9367972612380981400000000f,    0.9315854907035827600000000f,    0.9263512492179870600000000f,    0.9210947155952453600000000f,    0.9158159494400024400000000f,    0.9105151891708374000000000f,    0.9051924347877502400000000f,    0.8998478651046752900000000f,
    0.8944816589355468800000000f,    0.8890938758850097700000000f,    0.8836846351623535200000000f,    0.8782541155815124500000000f,    0.8728024363517761200000000f,    0.8673297166824340800000000f,    0.8618361353874206500000000f,    0.8563218116760253900000000f,    0.8507867455482482900000000f,    0.8452312946319580100000000f,
    0.8396554589271545400000000f,    0.8340593576431274400000000f,    0.8284431099891662600000000f,    0.8228070139884948700000000f,    0.8171509504318237300000000f,    0.8114752769470214800000000f,    0.8057801127433776900000000f,    0.8000654578208923300000000f,    0.7943315505981445300000000f,    0.7885785102844238300000000f,
    0.7828064560890197800000000f,    0.7770155668258667000000000f,    0.7712058424949646000000000f,    0.7653776407241821300000000f,    0.7595309019088745100000000f,    0.7536660432815551800000000f,    0.7477828264236450200000000f,    0.7418816685676574700000000f,    0.7359626293182373000000000f,    0.7300259470939636200000000f,
    0.7240716218948364300000000f,    0.7180998325347900400000000f,    0.7121106386184692400000000f,    0.7061043977737426800000000f,    0.7000811696052551300000000f,    0.6940410137176513700000000f,    0.6879841089248657200000000f,    0.6819106936454772900000000f,    0.6758208274841308600000000f,    0.6697146296501159700000000f,
    0.6635923385620117200000000f,    0.6574540734291076700000000f,    0.6512999534606933600000000f,    0.6451301574707031300000000f,    0.6389448046684265100000000f,    0.6327440142631530800000000f,    0.6265279650688171400000000f,    0.6202968955039978000000000f,    0.6140508651733398400000000f,    0.6077899932861328100000000f,
    0.6015145182609558100000000f,    0.5952244997024536100000000f,    0.5889201760292053200000000f,    0.5826016664505004900000000f,    0.5762690901756286600000000f,    0.5699226856231689500000000f,    0.5635625123977661100000000f,    0.5571887493133544900000000f,    0.5508015751838684100000000f,    0.5444011092185974100000000f,
    0.5379875302314758300000000f,    0.5315610170364379900000000f,    0.5251216888427734400000000f,    0.5186696648597717300000000f,    0.5122051835060119600000000f,    0.5057283639907836900000000f,    0.4992393255233764600000000f,    0.4927382767200470000000000f,    0.4862253665924072300000000f,    0.4797007441520690900000000f,
    0.4731644988059997600000000f,    0.4666169285774231000000000f,    0.4600581228733062700000000f,    0.4534881711006164600000000f,    0.4469073116779327400000000f,    0.4403156936168670700000000f,    0.4337134659290313700000000f,    0.4271008074283599900000000f,    0.4204778075218200700000000f,    0.4138446748256683300000000f,
    0.4072016179561615000000000f,    0.4005487561225891100000000f,    0.3938861787319183300000000f,    0.3872141540050506600000000f,    0.3805327713489532500000000f,    0.3738422691822052000000000f,    0.3671427369117736800000000f,    0.3604343533515930200000000f,    0.3537172675132751500000000f,    0.3469916582107543900000000f,
    0.3402577340602874800000000f,    0.3335155844688415500000000f,    0.3267653882503509500000000f,    0.3200073242187500000000000f,    0.3132415413856506300000000f,    0.3064682185649871800000000f,    0.2996875047683715800000000f,    0.2928995788097381600000000f,    0.2861045897006988500000000f,    0.2793027162551879900000000f,
    0.2724941074848175000000000f,    0.2656789422035217300000000f,    0.2588573694229126000000000f,    0.2520295381546020500000000f,    0.2451956570148468000000000f,    0.2383558601140976000000000f,    0.2315103262662887600000000f,    0.2246592044830322300000000f,    0.2178026735782623300000000f,    0.2109408974647522000000000f,
    0.2040740400552749600000000f,    0.1972022652626037600000000f,    0.1903257369995117200000000f,    0.1834446042776107800000000f,    0.1765590757131576500000000f,    0.1696692854166030900000000f,    0.1627754122018814100000000f,    0.1558776050806045500000000f,    0.1489760577678680400000000f,    0.1420709043741226200000000f,
    0.1351623386144638100000000f,    0.1282505095005035400000000f,    0.1213355958461761500000000f,    0.1144177615642547600000000f,    0.1074971556663513200000000f,    0.1005739644169807400000000f,    0.0936483591794967650000000f,    0.0867204889655113220000000f,    0.0797905325889587400000000f,    0.0728586539626121520000000f,
    0.0659250169992446900000000f,    0.0589897930622100830000000f,    0.0520531460642814640000000f,    0.0451152473688125610000000f,    0.0381762608885765080000000f,    0.0312363542616367340000000f,    0.0242956969887018200000000f,    0.0173544511198997500000000f,    0.0104127889499068260000000f,    0.0034708750899881124000000f
};

/* Synthesis windows for overlap-add */
/* for (j=0 ; j<hs->fftlen ; j++) hs->olapWinSyn[j] = (float)sin(EVS_PI*((float)j+0.5f)/(float)(hs->fftlen); */
const float olapWinSyn256[256] =
{
    0.0061358846f,
    0.0184067299f,
    0.0306748032f,
    0.0429382569f,
    0.0551952443f,
    0.0674439196f,
    0.0796824380f,
    0.0919089565f,
    0.1041216339f,
    0.1163186309f,
    0.1284981108f,
    0.1406582393f,
    0.1527971853f,
    0.1649131205f,
    0.1770042204f,
    0.1890686641f,
    0.2011046348f,
    0.2131103199f,
    0.2250839114f,
    0.2370236060f,
    0.2489276057f,
    0.2607941179f,
    0.2726213554f,
    0.2844075372f,
    0.2961508882f,
    0.3078496400f,
    0.3195020308f,
    0.3311063058f,
    0.3426607173f,
    0.3541635254f,
    0.3656129978f,
    0.3770074102f,
    0.3883450467f,
    0.3996241998f,
    0.4108431711f,
    0.4220002708f,
    0.4330938189f,
    0.4441221446f,
    0.4550835871f,
    0.4659764958f,
    0.4767992301f,
    0.4875501601f,
    0.4982276670f,
    0.5088301425f,
    0.5193559902f,
    0.5298036247f,
    0.5401714727f,
    0.5504579729f,
    0.5606615762f,
    0.5707807459f,
    0.5808139581f,
    0.5907597019f,
    0.6006164794f,
    0.6103828063f,
    0.6200572118f,
    0.6296382389f,
    0.6391244449f,
    0.6485144010f,
    0.6578066933f,
    0.6669999223f,
    0.6760927036f,
    0.6850836678f,
    0.6939714609f,
    0.7027547445f,
    0.7114321957f,
    0.7200025080f,
    0.7284643904f,
    0.7368165689f,
    0.7450577854f,
    0.7531867990f,
    0.7612023855f,
    0.7691033376f,
    0.7768884657f,
    0.7845565972f,
    0.7921065773f,
    0.7995372691f,
    0.8068475535f,
    0.8140363297f,
    0.8211025150f,
    0.8280450453f,
    0.8348628750f,
    0.8415549774f,
    0.8481203448f,
    0.8545579884f,
    0.8608669386f,
    0.8670462455f,
    0.8730949784f,
    0.8790122264f,
    0.8847970984f,
    0.8904487232f,
    0.8959662498f,
    0.9013488470f,
    0.9065957045f,
    0.9117060320f,
    0.9166790599f,
    0.9215140393f,
    0.9262102421f,
    0.9307669611f,
    0.9351835099f,
    0.9394592236f,
    0.9435934582f,
    0.9475855910f,
    0.9514350210f,
    0.9551411683f,
    0.9587034749f,
    0.9621214043f,
    0.9653944417f,
    0.9685220943f,
    0.9715038910f,
    0.9743393828f,
    0.9770281427f,
    0.9795697657f,
    0.9819638691f,
    0.9842100924f,
    0.9863080972f,
    0.9882575677f,
    0.9900582103f,
    0.9917097537f,
    0.9932119492f,
    0.9945645707f,
    0.9957674145f,
    0.9968202993f,
    0.9977230666f,
    0.9984755806f,
    0.9990777278f,
    0.9995294175f,
    0.9998305818f,
    0.9999811753f,
    0.9999811753f,
    0.9998305818f,
    0.9995294175f,
    0.9990777278f,
    0.9984755806f,
    0.9977230666f,
    0.9968202993f,
    0.9957674145f,
    0.9945645707f,
    0.9932119492f,
    0.9917097537f,
    0.9900582103f,
    0.9882575677f,
    0.9863080972f,
    0.9842100924f,
    0.9819638691f,
    0.9795697657f,
    0.9770281427f,
    0.9743393828f,
    0.9715038910f,
    0.9685220943f,
    0.9653944417f,
    0.9621214043f,
    0.9587034749f,
    0.9551411683f,
    0.9514350210f,
    0.9475855910f,
    0.9435934582f,
    0.9394592236f,
    0.9351835099f,
    0.9307669611f,
    0.9262102421f,
    0.9215140393f,
    0.9166790599f,
    0.9117060320f,
    0.9065957045f,
    0.9013488470f,
    0.8959662498f,
    0.8904487232f,
    0.8847970984f,
    0.8790122264f,
    0.8730949784f,
    0.8670462455f,
    0.8608669386f,
    0.8545579884f,
    0.8481203448f,
    0.8415549774f,
    0.8348628750f,
    0.8280450453f,
    0.8211025150f,
    0.8140363297f,
    0.8068475535f,
    0.7995372691f,
    0.7921065773f,
    0.7845565972f,
    0.7768884657f,
    0.7691033376f,
    0.7612023855f,
    0.7531867990f,
    0.7450577854f,
    0.7368165689f,
    0.7284643904f,
    0.7200025080f,
    0.7114321957f,
    0.7027547445f,
    0.6939714609f,
    0.6850836678f,
    0.6760927036f,
    0.6669999223f,
    0.6578066933f,
    0.6485144010f,
    0.6391244449f,
    0.6296382389f,
    0.6200572118f,
    0.6103828063f,
    0.6006164794f,
    0.5907597019f,
    0.5808139581f,
    0.5707807459f,
    0.5606615762f,
    0.5504579729f,
    0.5401714727f,
    0.5298036247f,
    0.5193559902f,
    0.5088301425f,
    0.4982276670f,
    0.4875501601f,
    0.4767992301f,
    0.4659764958f,
    0.4550835871f,
    0.4441221446f,
    0.4330938189f,
    0.4220002708f,
    0.4108431711f,
    0.3996241998f,
    0.3883450467f,
    0.3770074102f,
    0.3656129978f,
    0.3541635254f,
    0.3426607173f,
    0.3311063058f,
    0.3195020308f,
    0.3078496400f,
    0.2961508882f,
    0.2844075372f,
    0.2726213554f,
    0.2607941179f,
    0.2489276057f,
    0.2370236060f,
    0.2250839114f,
    0.2131103199f,
    0.2011046348f,
    0.1890686641f,
    0.1770042204f,
    0.1649131205f,
    0.1527971853f,
    0.1406582393f,
    0.1284981108f,
    0.1163186309f,
    0.1041216339f,
    0.0919089565f,
    0.0796824380f,
    0.0674439196f,
    0.0551952443f,
    0.0429382569f,
    0.0306748032f,
    0.0184067299f,
    0.0061358846f
};
const float olapWinSyn320[320] =
{
    0.0049087191000580788000000f,    0.0147256832569837570000000f,    0.0245412290096282960000000f,    0.0343544110655784610000000f,    0.0441642776131629940000000f,    0.0539698898792266850000000f,    0.0637703016400337220000000f,    0.0735645666718482970000000f,    0.0833517387509346010000000f,    0.0931308791041374210000000f,
    0.1029010415077209500000000f,    0.1126612871885299700000000f,    0.1224106773734092700000000f,    0.1321482658386230500000000f,    0.1418731212615966800000000f,    0.1515842974185943600000000f,    0.1612808704376220700000000f,    0.1709618866443634000000000f,    0.1806264370679855300000000f,    0.1902735829353332500000000f,
    0.1999023705720901500000000f,    0.2095119059085845900000000f,    0.2191012501716613800000000f,    0.2286694645881652800000000f,    0.2382156550884246800000000f,    0.2477388679981231700000000f,    0.2572382092475891100000000f,    0.2667127549648284900000000f,    0.2761616110801696800000000f,    0.2855838239192962600000000f,
    0.2949785292148590100000000f,    0.3043448030948638900000000f,    0.3136817514896392800000000f,    0.3229884505271911600000000f,    0.3322640359401702900000000f,    0.3415075838565826400000000f,    0.3507182002067565900000000f,    0.3598950505256652800000000f,    0.3690371811389923100000000f,    0.3781437575817108200000000f,
    0.3872138857841491700000000f,    0.3962467014789581300000000f,    0.4052413105964660600000000f,    0.4141968786716461200000000f,    0.4231125116348266600000000f,    0.4319873750209808300000000f,    0.4408206045627594000000000f,    0.4496113359928131100000000f,    0.4583587348461151100000000f,    0.4670619666576385500000000f,
    0.4757201671600341800000000f,    0.4843325316905975300000000f,    0.4928981959819793700000000f,    0.5014163851737976100000000f,    0.5098862051963806200000000f,    0.5183069109916687000000000f,    0.5266776680946350100000000f,    0.5349976420402526900000000f,    0.5432660579681396500000000f,    0.5514820814132690400000000f,
    0.5596449971199035600000000f,    0.5677539706230163600000000f,    0.5758082270622253400000000f,    0.5838069319725036600000000f,    0.5917494297027587900000000f,    0.5996348857879638700000000f,    0.6074625253677368200000000f,    0.6152316331863403300000000f,    0.6229414343833923300000000f,    0.6305911540985107400000000f,
    0.6381801366806030300000000f,    0.6457076072692871100000000f,    0.6531728506088256800000000f,    0.6605751514434814500000000f,    0.6679137349128723100000000f,    0.6751880049705505400000000f,    0.6823971867561340300000000f,    0.6895405650138855000000000f,    0.6966174840927124000000000f,    0.7036272883415222200000000f,
    0.7105692625045776400000000f,    0.7174427509307861300000000f,    0.7242470979690551800000000f,    0.7309816479682922400000000f,    0.7376457452774047900000000f,    0.7442387342453002900000000f,    0.7507599592208862300000000f,    0.7572088837623596200000000f,    0.7635847926139831500000000f,    0.7698870897293090800000000f,
    0.7761152386665344200000000f,    0.7822685241699218800000000f,    0.7883464694023132300000000f,    0.7943483591079711900000000f,    0.8002737760543823200000000f,    0.8061220049858093300000000f,    0.8118925094604492200000000f,    0.8175848126411438000000000f,    0.8231983184814453100000000f,    0.8287324905395507800000000f,
    0.8341867327690124500000000f,    0.8395606279373168900000000f,    0.8448535799980163600000000f,    0.8500651121139526400000000f,    0.8551946878433227500000000f,    0.8602418899536132800000000f,    0.8652061223983764600000000f,    0.8700870275497436500000000f,    0.8748840093612670900000000f,    0.8795967102050781300000000f,
    0.8842245936393737800000000f,    0.8887673020362854000000000f,    0.8932242989540100100000000f,    0.8975952267646789600000000f,    0.9018796682357788100000000f,    0.9060771465301513700000000f,    0.9101873040199279800000000f,    0.9142097830772399900000000f,    0.9181441068649292000000000f,    0.9219899177551269500000000f,
    0.9257469177246093800000000f,    0.9294146299362182600000000f,    0.9329928159713745100000000f,    0.9364810585975647000000000f,    0.9398790597915649400000000f,    0.9431864023208618200000000f,    0.9464029073715210000000000f,    0.9495282173156738300000000f,    0.9525619745254516600000000f,    0.9555038809776306200000000f,
    0.9583537578582763700000000f,    0.9611112475395202600000000f,    0.9637760519981384300000000f,    0.9663480520248413100000000f,    0.9688268303871154800000000f,    0.9712122678756713900000000f,    0.9735041260719299300000000f,    0.9757021665573120100000000f,    0.9778060913085937500000000f,    0.9798158407211303700000000f,
    0.9817311167716980000000000f,    0.9835518002510070800000000f,    0.9852776527404785200000000f,    0.9869085550308227500000000f,    0.9884443283081054700000000f,    0.9898848533630371100000000f,    0.9912299513816833500000000f,    0.9924795627593994100000000f,    0.9936334490776062000000000f,    0.9946916103363037100000000f,
    0.9956538677215576200000000f,    0.9965202212333679200000000f,    0.9972904324531555200000000f,    0.9979646205902099600000000f,    0.9985425472259521500000000f,    0.9990242719650268600000000f,    0.9994097352027893100000000f,    0.9996988177299499500000000f,    0.9998915791511535600000000f,    0.9999879598617553700000000f,
    0.9999879598617553700000000f,    0.9998915791511535600000000f,    0.9996988177299499500000000f,    0.9994097352027893100000000f,    0.9990242719650268600000000f,    0.9985425472259521500000000f,    0.9979646205902099600000000f,    0.9972904324531555200000000f,    0.9965201616287231400000000f,    0.9956538677215576200000000f,
    0.9946916103363037100000000f,    0.9936334490776062000000000f,    0.9924795031547546400000000f,    0.9912299513816833500000000f,    0.9898848533630371100000000f,    0.9884443283081054700000000f,    0.9869085550308227500000000f,    0.9852776527404785200000000f,    0.9835517406463623000000000f,    0.9817311167716980000000000f,
    0.9798157811164856000000000f,    0.9778060913085937500000000f,    0.9757021069526672400000000f,    0.9735041260719299300000000f,    0.9712122678756713900000000f,    0.9688268303871154800000000f,    0.9663479924201965300000000f,    0.9637760519981384300000000f,    0.9611111879348754900000000f,    0.9583536982536315900000000f,
    0.9555038809776306200000000f,    0.9525619149208068800000000f,    0.9495281577110290500000000f,    0.9464029073715210000000000f,    0.9431864023208618200000000f,    0.9398790001869201700000000f,    0.9364809989929199200000000f,    0.9329927563667297400000000f,    0.9294146299362182600000000f,    0.9257468581199646000000000f,
    0.9219899177551269500000000f,    0.9181440472602844200000000f,    0.9142097234725952100000000f,    0.9101873040199279800000000f,    0.9060771465301513700000000f,    0.9018796086311340300000000f,    0.8975952267646789600000000f,    0.8932242989540100100000000f,    0.8887672424316406300000000f,    0.8842245936393737800000000f,
    0.8795966506004333500000000f,    0.8748839497566223100000000f,    0.8700869679450988800000000f,    0.8652060627937316900000000f,    0.8602418303489685100000000f,    0.8551946878433227500000000f,    0.8500650525093078600000000f,    0.8448535203933715800000000f,    0.8395605683326721200000000f,    0.8341866731643676800000000f,
    0.8287324309349060100000000f,    0.8231982588768005400000000f,    0.8175847530364990200000000f,    0.8118925094604492200000000f,    0.8061219453811645500000000f,    0.8002737164497375500000000f,    0.7943482995033264200000000f,    0.7883464097976684600000000f,    0.7822684645652771000000000f,    0.7761151790618896500000000f,
    0.7698870301246643100000000f,    0.7635847330093383800000000f,    0.7572088241577148400000000f,    0.7507598996162414600000000f,    0.7442386746406555200000000f,    0.7376456856727600100000000f,    0.7309815883636474600000000f,    0.7242470383644104000000000f,    0.7174426913261413600000000f,    0.7105692028999328600000000f,
    0.7036272287368774400000000f,    0.6966174244880676300000000f,    0.6895405054092407200000000f,    0.6823971271514892600000000f,    0.6751879453659057600000000f,    0.6679136753082275400000000f,    0.6605750918388366700000000f,    0.6531727910041809100000000f,    0.6457075476646423300000000f,    0.6381800770759582500000000f,
    0.6305910944938659700000000f,    0.6229413151741027800000000f,    0.6152315139770507800000000f,    0.6074624657630920400000000f,    0.5996347665786743200000000f,    0.5917493700981140100000000f,    0.5838068723678588900000000f,    0.5758081078529357900000000f,    0.5677539110183715800000000f,    0.5596449375152587900000000f,
    0.5514820218086242700000000f,    0.5432659983634948700000000f,    0.5349975824356079100000000f,    0.5266776084899902300000000f,    0.5183068513870239300000000f,    0.5098861455917358400000000f,    0.5014163255691528300000000f,    0.4928981363773345900000000f,    0.4843324422836303700000000f,    0.4757201075553894000000000f,
    0.4670618772506713900000000f,    0.4583586752414703400000000f,    0.4496112763881683300000000f,    0.4408205151557922400000000f,    0.4319873154163360600000000f,    0.4231124520301818800000000f,    0.4141968190670013400000000f,    0.4052412509918212900000000f,    0.3962466120719909700000000f,    0.3872138261795043900000000f,
    0.3781436979770660400000000f,    0.3690371215343475300000000f,    0.3598949611186981200000000f,    0.3507181406021118200000000f,    0.3415074944496154800000000f,    0.3322639465332031300000000f,    0.3229883611202240000000000f,    0.3136816620826721200000000f,    0.3043447136878967300000000f,    0.2949784696102142300000000f,
    0.2855837643146514900000000f,    0.2761615216732025100000000f,    0.2667126953601837200000000f,    0.2572381198406219500000000f,    0.2477387785911560100000000f,    0.2382155656814575200000000f,    0.2286693751811981200000000f,    0.2191011607646942100000000f,    0.2095118165016174300000000f,    0.1999022960662841800000000f,
    0.1902734935283660900000000f,    0.1806263476610183700000000f,    0.1709618121385574300000000f,    0.1612807810306549100000000f,    0.1515842080116272000000000f,    0.1418730318546295200000000f,    0.1321481764316558800000000f,    0.1224105954170227100000000f,    0.1126612052321434000000000f,    0.1029009595513343800000000f,
    0.0931307896971702580000000f,    0.0833516493439674380000000f,    0.0735644772648811340000000f,    0.0637702122330665590000000f,    0.0539698041975498200000000f,    0.0441641919314861300000000f,    0.0343543216586112980000000f,    0.0245411414653062820000000f,    0.0147255966439843180000000f,    0.0049086315557360649000000f
};


/*-------------------------------------------------------------------*
 * AMR-WB ISF codebook - common 1st stage for 46bit and 36bit codebooks,
 *                       2 splits
 *
 *  codebook   vector dimension    number of vectors
 *  ~~~~~~~~   ~~~~~~~~~~~~~~~~    ~~~~~~~~~~~~~~~~~
 *     1_1            9                  256
 *     1_2            7                  256
 *-------------------------------------------------------------------*/

/*-------------------------------------------------------------------*
 * 1nd stage, 1st split: ISF0 to ISF8
 *-------------------------------------------------------------------*/

const float dico1_isf[] =
{
    226.1477f,       422.2338f,       404.4563f,      152.3442f,         1.2553f,     -102.5648f,      -77.5073f,      -32.1403f,       14.9134f,
    6.9890f,       -26.5711f,        -4.8001f,      122.2654f,       297.4533f,      158.0168f,       97.1963f,       43.4786f,      -29.4927f,
    289.1461f,       493.4574f,       504.5048f,      393.1421f,       389.3840f,      397.8990f,      397.4072f,      381.0959f,      360.5083f,
    -35.6482f,       323.0566f,       370.2882f,      252.9499f,       239.6172f,      209.0563f,      203.9713f,      191.4865f,      164.6219f,
    16.1026f,       -17.1264f,      -109.6817f,     -184.2085f,       254.5133f,      208.7087f,       75.3774f,       52.8718f,      -35.2364f,
    15.8336f,       -47.0775f,      -139.1713f,      -23.5561f,       259.0049f,      120.0214f,       23.8825f,      -18.5948f,     -134.3813f,
    217.4017f,       369.5988f,       409.6801f,      338.5433f,       330.4056f,      386.7012f,      434.5276f,      492.7760f,      484.6164f,
    -46.1429f,       -79.6218f,       128.1106f,      199.9543f,       339.7710f,      309.8338f,      238.4430f,      156.8895f,       72.7742f,
    61.1308f,       114.6106f,        28.7939f,     -131.9070f,      -185.5015f,     -350.3943f,     -232.0556f,      -62.9803f,     -194.0513f,
    88.2757f,        51.2294f,       -53.9555f,      120.0698f,        65.9863f,     -105.8813f,      -64.0929f,     -151.0651f,     -243.7652f,
    24.1201f,       -12.6302f,       -23.7808f,      -98.2577f,      -211.1396f,     -323.5447f,     -401.0499f,     -204.4768f,     -258.4671f,
    39.7202f,       -23.9607f,        55.2442f,       43.6804f,      -105.4100f,      -97.8749f,     -211.3002f,        9.7097f,      -58.7138f,
    2.1766f,       -51.7480f,      -138.9340f,     -268.1601f,       -37.5098f,     -125.8675f,     -203.7929f,      -12.2603f,     -127.2472f,
    -14.0622f,       -81.7822f,      -203.4806f,      -89.5766f,       119.8931f,      -51.7010f,       -2.1055f,      -38.5536f,     -149.8808f,
    23.6196f,       -19.7370f,       -92.7527f,     -260.9933f,      -380.1402f,     -158.8319f,     -276.5396f,      -29.3644f,      -67.0346f,
    10.0869f,       -54.0238f,      -104.0772f,       43.4993f,      -118.0066f,       16.7674f,     -108.4172f,     -138.9907f,     -140.3299f,
    222.5364f,       321.1411f,       193.8368f,      -60.0340f,      -121.7460f,      -35.9078f,       53.6514f,      109.0639f,      145.0366f,
    -57.1173f,       143.6362f,       159.6491f,       26.6189f,         2.3305f,       30.0608f,       65.3329f,       78.8683f,       63.4622f,
    247.1436f,       350.7171f,       389.0685f,      295.2953f,       258.6614f,      266.7955f,      305.9202f,      355.1905f,      389.1698f,
    -40.0882f,       114.6876f,       237.0104f,      161.9769f,       188.5636f,      180.3751f,      187.4189f,      168.3521f,      159.5175f,
    -46.7654f,      -132.1011f,      -238.9261f,     -204.8685f,       228.1911f,      129.1599f,       36.0960f,      169.1651f,      107.7902f,
    -69.5087f,      -114.5055f,       -60.0494f,      -15.9078f,       105.1520f,       39.1060f,       -3.6140f,       83.1345f,       62.4498f,
    324.4036f,       287.6214f,       108.7328f,      320.4871f,       489.7306f,      267.9902f,      278.2168f,      405.7287f,      184.7344f,
    -85.2571f,      -118.8197f,       180.9905f,      177.4239f,       154.8864f,      106.5995f,       78.7528f,      111.5907f,      106.4840f,
    -90.5891f,         2.5823f,         2.5231f,     -151.4854f,      -184.4761f,     -166.9757f,     -147.6148f,      -65.2055f,      -39.1239f,
    -114.9974f,       -71.3698f,        52.3087f,      -18.1814f,        39.4264f,      -34.2483f,      -32.8691f,      -45.8165f,       -1.2029f,
    22.1063f,         6.7469f,       -79.0146f,     -247.7831f,      -386.2835f,     -437.2287f,     -208.2931f,       68.6375f,      -14.1447f,
    46.7840f,       -11.0692f,         9.1612f,       43.4278f,      -124.5574f,      124.1172f,       -8.5368f,      -30.1898f,      103.7909f,
    -105.9007f,      -181.3862f,      -169.7189f,     -257.0920f,      -250.0032f,     -150.2815f,     -150.4918f,      -38.5650f,      -26.7658f,
    -77.3138f,      -101.1008f,      -103.9903f,      -17.1337f,       -15.2577f,      -54.2134f,      -53.5373f,       66.9219f,       25.6872f,
    3.6265f,       -56.7222f,      -147.2143f,     -330.5455f,      -390.5518f,      -43.3139f,     -126.9112f,      133.5488f,       52.7399f,
    -31.5816f,      -111.6706f,      -148.4743f,       75.1588f,       -22.0969f,      119.9764f,       29.6891f,       -9.5309f,      -54.7378f,
    264.5383f,       274.1302f,        96.5690f,       21.7008f,        97.2691f,       55.1255f,      -40.9705f,      -92.2272f,      -38.6482f,
    13.8969f,       -15.1538f,       -27.1357f,      135.8413f,        77.4989f,      -36.1739f,      125.8114f,       35.5744f,      -28.2436f,
    196.2991f,       345.8166f,       588.9347f,      510.5197f,       500.8432f,      457.6244f,      436.9384f,      472.1788f,      414.4815f,
    162.4519f,       280.7038f,       386.4482f,      479.3623f,       390.8287f,      411.1292f,      372.5701f,      289.3485f,      407.8594f,
    -49.5343f,      -147.0080f,      -256.8338f,       54.1618f,       243.5530f,       87.1110f,      195.7264f,      119.5070f,       85.9479f,
    -43.9641f,      -150.1866f,      -310.9041f,      196.7455f,       171.2780f,       33.0834f,       83.3645f,      -32.4579f,      -75.7126f,
    228.4330f,       442.3277f,       481.6548f,      426.3000f,       487.1132f,      559.8019f,      590.4699f,      565.5949f,      513.3911f,
    -68.0544f,      -164.7799f,         2.8141f,      451.2739f,       425.3554f,      461.7245f,      391.6532f,      369.1004f,      314.9413f,
    3.2743f,       -49.3561f,      -123.9568f,      -40.1754f,      -137.2377f,     -271.6588f,      -38.4305f,     -104.5226f,     -209.8071f,
    12.8092f,       -40.2922f,      -113.2953f,       65.4057f,       -15.2443f,     -159.0118f,       17.0998f,      -81.3044f,     -146.3446f,
    40.4305f,        -8.9102f,       -24.9719f,     -113.7701f,      -248.7160f,     -332.5068f,     -423.4328f,      -23.8073f,      -43.9266f,
    -29.4866f,      -119.6504f,      -169.5775f,       85.2585f,       -57.7724f,     -138.3062f,     -265.4940f,      -52.0935f,      -84.4635f,
    -47.3285f,      -147.4516f,      -280.5169f,      -38.0164f,       -50.7237f,     -141.1316f,      -60.9737f,     -147.8608f,     -233.9212f,
    -22.0146f,       -99.1479f,      -228.8716f,       91.6618f,        61.1343f,      -83.5247f,        4.2834f,     -101.7035f,      -58.0283f,
    -48.6094f,      -104.2664f,      -155.2664f,     -226.4858f,      -231.7223f,     -205.7180f,     -314.6280f,     -150.3995f,      135.1819f,
    -75.2552f,      -171.9896f,      -276.5969f,     -137.0060f,       -55.2086f,      -99.5797f,     -195.1097f,      -57.2647f,      -72.3255f,
    174.9245f,       258.0028f,       192.8297f,       81.3562f,       198.8450f,      180.2081f,      132.0824f,      113.5126f,       58.1412f,
    -87.2559f,        34.2946f,       130.7081f,       62.1078f,        82.7816f,       74.4854f,      111.6818f,      120.3099f,       80.1334f,
    -11.9671f,       183.3834f,       313.7754f,      257.2813f,       241.7612f,      256.9710f,      329.4492f,      385.5374f,      434.7875f,
    -66.8195f,       -94.6890f,       200.6887f,      141.3063f,       115.2635f,      204.7280f,      215.7973f,      270.9673f,      228.4647f,
    -24.9070f,      -120.1441f,      -175.1481f,       -8.0896f,       110.9215f,      307.0280f,      174.2457f,      112.7169f,       35.9639f,
    -85.1717f,      -152.2496f,        -2.5803f,       66.0904f,        80.5138f,      128.8919f,      137.5303f,      159.4245f,      139.7766f,
    -14.1396f,       274.4125f,       374.6268f,      335.3957f,       336.4666f,      435.5791f,      495.5083f,      529.9642f,      509.9389f,
    -51.7794f,      -133.3125f,       -25.4473f,      264.8054f,       162.9175f,      171.9332f,      189.6735f,      202.1561f,      304.5228f,
    12.7820f,       -17.2653f,       -74.5083f,     -134.5510f,      -180.1133f,     -294.9349f,      -78.6120f,       84.8225f,      -12.0772f,
    -137.7282f,      -213.7303f,       -17.3509f,       48.2225f,       -23.9524f,      -26.4293f,      -30.7054f,       11.1575f,       23.4229f,
    28.3886f,       -22.3550f,      -158.4269f,     -299.3692f,      -485.7126f,     -469.8884f,       93.8213f,      156.3351f,       64.4156f,
    -28.7029f,      -110.1881f,      -234.8032f,      -83.3735f,       -66.7772f,     -146.3531f,      129.8178f,       13.7979f,      -40.1959f,
    -11.2220f,       -81.0542f,      -215.8795f,     -186.0052f,      -249.1487f,     -354.7951f,       67.0249f,       -8.7287f,      -52.7080f,
    -75.1895f,       -93.5102f,       -63.8842f,      -40.2971f,       -43.3423f,      -18.3122f,       59.9384f,       48.9469f,       42.9198f,
    -0.3036f,       -79.3921f,      -222.4614f,     -402.4193f,      -556.4007f,     -208.9512f,       60.4822f,        0.2592f,       57.2596f,
    -130.2469f,      -254.9911f,      -337.7263f,      -76.9102f,       -61.5888f,       -8.3782f,      -17.2822f,       37.1637f,       42.0772f,
    151.9460f,       229.6417f,       191.5279f,       12.9809f,       -92.7110f,     -204.7091f,     -245.2630f,      -53.2589f,     -101.3680f,
    15.8084f,       -69.0148f,      -180.2926f,      176.9411f,       336.6405f,      148.3504f,       51.2260f,      -50.6708f,     -158.2893f,
    328.7315f,       655.2856f,       719.0299f,      605.1412f,       575.6907f,      490.5742f,      422.8277f,      353.4364f,      289.8675f,
    144.5240f,       474.8398f,       690.7612f,      638.0545f,       473.3627f,      248.6244f,        8.4810f,     -128.9032f,       27.8837f,
    -29.8052f,      -109.6768f,      -289.4402f,     -289.9344f,       350.9098f,      241.8981f,      108.0220f,       27.7568f,      -86.8368f,
    -12.5998f,      -103.5273f,      -217.2510f,       -9.8401f,       388.4400f,      266.5437f,      118.9818f,       49.1643f,      -64.3603f,
    28.5445f,       288.4229f,       348.8730f,      378.0052f,       387.8595f,      690.6161f,      887.8799f,      718.7092f,      543.2699f,
    -27.0127f,      -136.3472f,      -228.6534f,       91.4073f,       452.4637f,      352.8853f,      244.5759f,      199.3164f,       97.9452f,
    -0.2574f,       -38.8124f,      -106.0784f,      -81.9691f,      -235.3859f,     -136.9961f,     -210.8024f,     -316.9619f,     -149.7671f,
    -6.3268f,       -89.9384f,      -197.0412f,      160.1820f,        58.3899f,      -80.1867f,     -134.0614f,     -254.4108f,     -249.4793f,
    40.1439f,        -3.4822f,       -88.7857f,      -80.2522f,      -219.3521f,     -305.1500f,     -421.5967f,     -471.9935f,      -60.7522f,
    55.8529f,        24.5260f,       -52.9174f,      -26.1113f,      -123.8744f,     -235.0002f,     -306.0707f,     -450.7246f,     -249.8812f,
    -56.2297f,      -152.7118f,      -263.1169f,     -243.0294f,       -78.2260f,      -99.3225f,     -257.7953f,     -369.9445f,     -154.2971f,
    -15.4570f,       -97.8124f,      -244.1879f,       10.4628f,       212.1971f,       36.6411f,      -51.0200f,     -150.9477f,     -262.8206f,
    -47.9169f,      -145.0780f,      -295.8412f,     -176.3119f,      -220.4176f,     -239.8767f,     -162.2583f,     -277.5646f,      -13.5098f,
    -45.4312f,      -120.7871f,      -231.7391f,     -104.6837f,        93.3399f,      -13.0435f,     -131.8873f,     -253.9684f,      -52.8010f,
    36.7261f,        97.8902f,       216.2452f,       22.2667f,      -121.9688f,     -165.2371f,      -60.1795f,      -22.1111f,       91.7368f,
    -104.8126f,       -27.6777f,       148.6412f,       44.3956f,       -17.0786f,      -34.0943f,       48.6552f,       67.5896f,       52.1341f,
    590.8627f,       669.3461f,       483.5975f,      208.4471f,       107.7190f,      123.1392f,      179.9797f,      179.2124f,      198.5541f,
    -51.3512f,        -7.3050f,       448.6575f,      261.8456f,       189.7417f,      139.0593f,      120.8041f,      144.0752f,      115.5179f,
    -87.2434f,      -195.6786f,      -351.1762f,     -282.1990f,       -27.3961f,        2.1866f,       51.0065f,      120.9792f,      154.0704f,
    -38.7878f,      -118.5436f,      -201.9035f,       97.1421f,        24.9785f,      -20.8748f,       52.5830f,       -4.3230f,      177.0334f,
    -57.4864f,      -155.8205f,      -285.0674f,     -156.5139f,       319.0307f,      288.4199f,      313.3522f,      292.7644f,      224.7193f,
    -60.1766f,      -170.1086f,      -288.5482f,      312.6666f,       231.6275f,      142.7810f,      206.6260f,      124.0985f,      127.5073f,
    -87.3474f,        17.7221f,       -15.2086f,     -151.2513f,      -201.3116f,     -202.2629f,     -237.4979f,     -150.1082f,     -125.3288f,
    -123.1549f,      -147.2588f,        55.9560f,      -39.6018f,       -44.1818f,     -147.1130f,      -69.1241f,      -56.1722f,       -4.4924f,
    45.5201f,        15.5222f,       -93.3382f,     -254.1893f,      -410.5618f,     -226.8515f,     -287.7839f,     -386.6172f,     -128.1340f,
    10.1233f,       -19.6005f,       -61.5127f,       -8.8349f,      -177.1218f,     -110.5849f,     -207.5041f,     -213.2586f,       74.8075f,
    -98.2741f,      -195.7624f,      -290.1091f,     -230.1600f,      -244.7515f,     -194.7701f,     -128.1076f,      -46.1729f,      -28.2903f,
    -126.3800f,      -193.1177f,       -95.3231f,     -119.6219f,       -56.1586f,      -69.0881f,     -102.1922f,      -52.5595f,      -30.4027f,
    -13.9604f,       -91.5188f,      -202.7529f,     -375.3352f,      -503.8488f,     -122.5019f,     -187.2047f,     -144.9473f,      -17.6464f,
    -37.1158f,      -113.9219f,      -208.9531f,       -3.1283f,      -117.0010f,       43.6858f,      -64.0984f,     -108.2942f,       77.5131f,
    -38.6401f,       -49.9736f,       343.9084f,      326.3879f,       226.1680f,      136.9212f,        9.0736f,      -37.1756f,      -84.7974f,
    -10.5004f,      -100.6890f,        48.4106f,      394.7867f,       233.0419f,      165.9509f,       56.3291f,        2.7924f,      -28.5845f,
    164.3221f,       505.0226f,       640.4844f,      633.9930f,       680.5828f,      631.7908f,      585.4574f,      501.5025f,      393.1295f,
    -37.0300f,       293.6539f,       656.3401f,      612.9729f,       632.0821f,      560.9024f,      468.8401f,      382.9867f,      278.2211f,
    -26.9959f,      -117.0381f,      -266.9459f,     -169.9414f,       442.3678f,      351.1593f,      196.7216f,      129.6217f,       42.5401f,
    -28.9160f,      -126.1295f,      -248.8180f,      219.9974f,       419.6462f,      237.5276f,      144.8018f,       41.0794f,      -19.0438f,
    -30.6524f,       324.5342f,       466.4269f,      433.6403f,       538.3355f,      578.5025f,      582.9940f,      533.2873f,      475.3817f,
    -101.0867f,       -47.3945f,       562.3863f,      521.2437f,       635.9947f,      581.9960f,      561.7294f,      477.7560f,      364.4759f,
    -32.1078f,      -119.5424f,      -239.6324f,      -86.9073f,      -147.6602f,     -263.4799f,     -212.9377f,     -261.9229f,     -330.2635f,
    20.8260f,       -48.5704f,      -135.4246f,      164.8506f,        20.4817f,      -48.8885f,     -105.4348f,     -206.6621f,        3.6375f,
    30.9311f,       -34.7599f,      -124.8998f,     -258.7565f,      -390.0532f,     -468.4556f,     -485.3543f,     -264.1984f,     -115.9895f,
    -26.5921f,      -106.6166f,      -238.7686f,       53.4977f,       -56.8913f,     -155.1848f,     -245.0791f,     -329.9394f,      -85.9503f,
    -43.8040f,      -135.2615f,      -311.2635f,     -322.8195f,        91.5184f,      -51.5741f,      -73.3097f,     -108.7735f,     -204.0501f,
    -61.9589f,      -158.0212f,      -286.8211f,     -163.7011f,       114.5577f,       29.0545f,      -65.0919f,      -65.1646f,       71.9506f,
    -59.8760f,      -170.6047f,      -325.2270f,     -421.8182f,      -131.3054f,     -184.2594f,     -219.1312f,     -132.9352f,      -98.8301f,
    -65.8626f,      -165.1987f,      -320.2537f,     -353.1492f,       -51.0331f,       -7.3456f,     -135.3074f,     -235.8573f,       12.1485f,
    12.8460f,       -11.9241f,       121.7405f,       24.2470f,       -57.8971f,       19.1365f,      -23.0243f,      220.3897f,      189.9156f,
    -119.6102f,      -129.9914f,        75.9549f,      -17.3359f,        26.2798f,       28.0181f,       57.3185f,       79.8925f,       95.0199f,
    -81.0524f,       -19.0879f,       531.3251f,      384.0082f,       378.6000f,      387.1200f,      396.1896f,      433.4382f,      379.9696f,
    -82.3204f,       -67.1148f,       345.0646f,      244.9884f,       277.8043f,      263.1406f,      275.4622f,      311.7924f,      291.4141f,
    -34.2889f,      -127.1388f,      -298.1820f,     -380.4511f,       268.4245f,      354.6007f,      200.7670f,      149.3555f,       67.1469f,
    -114.0830f,      -239.0252f,      -314.3921f,       24.6004f,        51.2722f,      105.4223f,      101.1157f,      137.3569f,      135.9245f,
    -91.7432f,       -32.7591f,       373.1560f,      319.3955f,       437.4347f,      503.4907f,      608.7997f,      578.2119f,      502.0230f,
    -70.3367f,      -179.9099f,      -239.7652f,      256.5794f,       269.9891f,      291.1810f,      333.6932f,      305.8695f,      278.4421f,
    -38.0671f,      -120.8247f,      -186.4547f,     -239.7784f,      -303.6527f,     -286.7954f,     -300.0361f,     -205.3057f,     -184.5087f,
    -134.2125f,      -185.9339f,       -13.8119f,      -65.8529f,        19.0133f,      -30.1823f,      -58.4970f,      -93.5678f,      -55.1841f,
    -20.3990f,      -104.7817f,      -249.4716f,     -358.9899f,      -499.3363f,     -434.6861f,     -133.7299f,     -130.1813f,      -59.0671f,
    -26.7201f,       -94.4739f,      -228.6340f,      -28.5857f,       -81.7289f,     -186.7961f,      -62.0135f,     -167.5409f,       51.9732f,
    -76.8652f,      -194.8085f,      -392.5224f,     -495.1741f,      -106.3757f,      -87.6781f,      -40.9442f,      -25.9922f,        6.6919f,
    -141.6526f,      -241.2805f,      -161.8672f,      -45.4915f,       -24.1067f,        7.6906f,        3.7741f,       45.2149f,       42.3436f,
    -76.2028f,      -185.3649f,      -353.8127f,     -492.3104f,      -348.1328f,     -172.4144f,     -108.0814f,      -55.5374f,      -10.8210f,
    -88.1331f,      -202.9139f,      -371.2243f,     -273.3005f,      -107.5773f,     -103.9134f,      -45.1607f,      -40.9613f,       31.8985f,
    157.9412f,       199.7964f,       203.2689f,      127.6304f,         6.7547f,      -75.7475f,     -130.0489f,     -209.2208f,     -228.8015f,
    -44.6527f,       -50.6749f,       107.6295f,       92.4422f,        79.8121f,      133.5672f,       52.5620f,       -6.2270f,      -43.2877f,
    261.9115f,       472.0228f,       456.3473f,      335.7553f,       289.8814f,      234.7976f,      206.1187f,      157.4174f,      120.7698f,
    155.2229f,       242.6315f,       377.1642f,      293.6065f,       226.0318f,      155.2748f,      156.4116f,      128.6701f,       98.5061f,
    74.5256f,        70.1303f,       -53.6869f,     -182.3488f,       106.1648f,       41.5585f,      -37.0232f,        6.5336f,      -75.1722f,
    -31.2252f,      -113.3890f,      -244.5892f,       75.8334f,       233.5228f,       76.5742f,        8.2886f,     -109.6154f,       29.9907f,
    199.0678f,       337.3158f,       432.8418f,      315.2969f,       366.8018f,      352.4917f,      361.4405f,      280.1715f,      187.7336f,
    53.4911f,       143.3279f,       208.4704f,      298.2910f,       261.7387f,      149.2119f,      115.7060f,       59.9002f,       32.6898f,
    118.3519f,       194.3090f,        56.3174f,      -33.3258f,       -48.8783f,     -210.5418f,     -188.4141f,     -181.0565f,     -298.4099f,
    91.1937f,       135.5274f,        26.3852f,      -57.5649f,        66.0117f,      -82.2194f,      -94.6889f,      -88.3680f,     -188.1230f,
    119.8292f,       164.8051f,        60.2985f,      -68.4990f,      -150.8028f,     -282.2156f,     -282.8785f,     -353.0452f,     -396.4856f,
    120.5806f,       120.4464f,        62.5068f,      -23.5466f,      -183.4260f,     -164.0083f,     -233.7240f,     -309.0768f,      -85.4341f,
    26.4925f,        47.3529f,       -53.5415f,     -218.9011f,       -56.8672f,     -174.1118f,     -201.0902f,     -193.1382f,     -284.6390f,
    50.9597f,        20.8274f,       -88.6445f,       17.8450f,       185.2710f,       12.4814f,      -62.7698f,      -74.9989f,     -191.3486f,
    83.3881f,        63.9878f,       -27.8680f,     -181.7226f,      -342.0545f,      -62.8876f,     -178.1327f,     -229.1320f,      -18.6240f,
    85.1419f,        45.8095f,        15.3667f,       69.0366f,       -75.9137f,      -34.4539f,      -88.4330f,     -163.4411f,       19.3370f,
    81.8880f,       213.5459f,       222.3313f,      109.1533f,        47.1884f,      -17.2578f,      -19.4486f,        3.7457f,      -32.8905f,
    22.8266f,        54.6145f,        70.9314f,       -2.0301f,       104.3592f,       45.7102f,       41.3375f,       82.5320f,       77.2795f,
    210.7176f,       326.3462f,       356.6618f,      280.9097f,       240.9705f,      212.4392f,      230.9905f,      220.8317f,      250.9306f,
    59.6089f,       218.2601f,       340.5622f,      179.8372f,        86.7106f,       42.1021f,       73.5578f,       70.2340f,       71.3620f,
    61.9071f,        46.6476f,       111.0709f,      -59.8230f,      -105.9862f,       89.4424f,       34.0065f,       42.7793f,      -22.3657f,
    -71.5290f,        31.9224f,        46.2106f,        8.2769f,         5.2717f,       15.6736f,       45.9446f,       74.5921f,       72.2933f,
    63.1228f,       347.0971f,       255.3817f,       42.2624f,       -13.4026f,       95.4917f,      190.7911f,      219.1920f,      207.8866f,
    63.7817f,        21.7322f,       237.9311f,      133.1283f,        19.5484f,      128.6760f,       26.4302f,      103.7761f,       85.3130f,
    39.2312f,        80.2880f,         7.1932f,     -118.9054f,       -41.8213f,     -170.3956f,     -190.1681f,      -25.3174f,     -119.5246f,
    -33.4058f,        60.1838f,        52.1765f,      -11.5418f,       -17.6690f,      -28.5228f,      -40.5342f,      -31.3702f,      -37.5340f,
    95.6257f,       128.8044f,         3.7503f,     -171.8902f,      -331.7014f,     -422.7089f,       30.8156f,       15.6229f,     -103.6316f,
    76.5623f,       145.2620f,       106.4321f,      -70.8798f,      -192.7731f,     -152.0614f,      107.2952f,       31.2426f,      -23.0299f,
    0.9016f,        -4.6471f,       -96.0447f,     -197.1141f,       -39.1036f,     -170.4243f,        8.3031f,      -73.0702f,     -168.4342f,
    -86.2673f,       -18.7660f,        13.9540f,     -105.8362f,       -72.7468f,      -57.3178f,      -42.7630f,       10.3291f,       27.6536f,
    83.1109f,        54.8163f,        28.1776f,     -137.0164f,      -242.1605f,      -32.9744f,     -141.6118f,       26.8712f,       17.8517f,
    35.5325f,        65.1065f,        -1.1122f,      -37.2264f,       -38.7638f,      -41.0658f,      -18.6295f,       44.3877f,       57.2718f,
    101.1713f,        97.2361f,        67.3819f,      236.9884f,       158.4350f,       20.2720f,       23.0851f,      -73.7010f,     -124.8067f,
    44.9800f,       -33.1049f,       -21.2276f,      224.2546f,        49.9567f,       88.2466f,      -23.1899f,      -98.6740f,       50.9732f,
    -24.3959f,       403.6523f,       511.0127f,      404.3978f,       440.2577f,      428.9172f,      401.8223f,      375.5111f,      321.4924f,
    15.1345f,       142.1195f,       295.8327f,      367.1741f,       284.5674f,      257.7681f,      257.3533f,      227.7437f,      300.6506f,
    -44.9562f,      -131.9449f,      -296.8129f,     -184.1626f,       153.8183f,       14.5297f,      172.3343f,       69.5618f,        2.2208f,
    -22.2475f,      -119.2772f,      -205.2499f,      310.9423f,       177.0844f,       73.5587f,       -1.5010f,      -44.3403f,       96.9000f,
    27.7742f,       173.5793f,       311.4776f,      285.5815f,       427.9854f,      452.0145f,      477.2097f,      401.7775f,      316.6574f,
    52.6696f,       140.2801f,       215.3995f,      166.1714f,       292.6204f,      318.2898f,      341.5682f,      274.8850f,      196.1860f,
    51.5561f,        96.4057f,        -0.0610f,      -80.6567f,      -175.2689f,     -292.8310f,     -100.7723f,     -200.9591f,     -247.1591f,
    96.6859f,        97.0977f,        35.4401f,       47.1563f,       -76.2811f,     -194.8284f,      -34.9894f,     -110.1535f,     -169.8929f,
    30.4654f,         7.6447f,      -108.2569f,     -243.2014f,      -383.8708f,     -478.0505f,     -162.0353f,     -178.7682f,     -249.4727f,
    135.4580f,       198.9998f,        81.4247f,      -69.9475f,      -181.4226f,     -284.4768f,      -29.8270f,      -92.7044f,     -189.7940f,
    -40.1188f,      -133.9427f,      -295.2091f,     -278.5829f,      -103.4496f,     -237.8449f,      -74.7856f,     -155.3338f,     -248.5054f,
    -47.4470f,      -149.6037f,      -292.4242f,      221.6694f,        98.4280f,      -14.0849f,     -138.2963f,     -163.0445f,      -19.4243f,
    79.5896f,        39.1792f,       -58.2936f,     -253.9809f,      -422.3516f,      -18.3412f,       -2.7302f,     -102.9275f,       43.5500f,
    -17.9005f,       -70.1182f,      -104.1536f,     -126.4881f,      -219.3935f,     -153.8877f,     -270.2488f,      155.3837f,      114.2388f,
    188.3484f,       261.8459f,       266.6991f,      243.5570f,       172.7795f,       64.3333f,       45.3547f,       14.1479f,      -58.3812f,
    42.3610f,        96.6123f,       113.8369f,       96.5219f,       138.7232f,       47.5273f,       42.4855f,       87.4416f,      115.5724f,
    -5.4013f,       368.9961f,       386.7844f,      312.8328f,       294.8554f,      318.4847f,      330.7657f,      356.5357f,      348.3268f,
    113.9440f,       136.1339f,       283.1776f,      188.4109f,       151.5282f,      128.5029f,      167.5631f,      242.2409f,      260.3565f,
    -13.3113f,        76.9204f,        83.0527f,      -49.6054f,        32.9182f,      193.1624f,      242.1413f,      224.6298f,      146.4784f,
    49.3300f,        80.8438f,        67.2940f,       65.3665f,       141.4567f,       78.9471f,      115.6802f,      154.3108f,      177.7814f,
    -2.1684f,        97.5184f,       210.7061f,      182.4635f,       248.3353f,      312.9833f,      448.6478f,      502.5403f,      436.6044f,
    10.4934f,        93.6577f,       144.0456f,      109.2677f,       171.7553f,      160.5641f,      247.6292f,      348.4738f,      372.3836f,
    62.0393f,        66.4595f,       -22.8432f,     -154.2429f,      -311.1715f,     -269.7167f,       30.1724f,      -82.4276f,     -130.4250f,
    -1.8658f,       -10.8456f,        -5.2486f,      -28.7596f,      -130.9176f,     -235.6978f,      116.9998f,       34.2436f,      -79.9885f,
    32.1393f,       -12.8439f,      -142.0784f,     -272.6861f,      -469.8031f,     -450.3773f,       42.8701f,      -56.9028f,     -113.0164f,
    44.2438f,         0.5177f,       -95.0709f,     -229.7896f,      -388.2228f,     -193.8794f,      161.5550f,       62.3152f,       16.3412f,
    -21.7573f,       -96.5696f,      -171.8374f,     -270.5201f,      -389.2275f,     -187.1907f,        4.2880f,      -69.4009f,     -139.6222f,
    -59.1336f,      -137.9044f,      -127.8821f,      -82.4177f,      -132.8951f,       55.2591f,       25.2046f,      165.8443f,      176.7896f,
    13.1713f,       -65.9463f,      -177.8707f,     -363.8923f,      -474.4700f,       53.7845f,      194.7626f,       99.8684f,      126.7437f,
    26.4565f,        54.2781f,        -5.8084f,     -213.5320f,      -186.7453f,        6.5259f,      119.4530f,      196.2039f,      188.0246f,
    -12.3442f,       -52.3945f,       174.0135f,       50.5399f,       -55.6784f,      -95.2558f,     -196.2955f,     -198.2056f,     -234.0973f,
    23.6446f,       -54.5462f,      -134.7219f,      193.6175f,       178.7128f,       -0.9450f,        7.7510f,      -88.8611f,     -200.7396f,
    154.0881f,       689.2718f,       650.6971f,      522.8596f,       436.5025f,      314.9000f,      250.7824f,      187.1628f,      148.5410f,
    83.9959f,       202.8234f,       359.2843f,      411.3538f,       425.6817f,      308.8017f,      206.3666f,      113.2320f,       60.3929f,
    -21.1689f,       -91.1694f,      -252.6742f,     -235.0333f,       249.5398f,      114.6655f,       -0.7796f,      -65.2547f,     -172.8182f,
    -30.5567f,      -123.2070f,      -309.0227f,      -44.0884f,       320.4634f,      157.6161f,       61.6828f,      -45.3025f,     -139.1032f,
    206.4974f,       723.0883f,       782.3015f,      479.5419f,       242.9557f,      -15.8222f,     -162.4184f,      134.4517f,      319.9661f,
    -41.0232f,      -148.1419f,       -92.0839f,      478.0700f,       348.8458f,      292.6417f,      221.8808f,      139.1332f,       83.7320f,
    -6.8324f,       -77.6477f,       -56.3444f,       19.3478f,      -110.6184f,      -96.5414f,     -225.9007f,     -330.6617f,     -424.5623f,
    26.9337f,        -4.4548f,      -148.8763f,      -80.3516f,        81.8311f,     -110.8947f,     -150.9911f,     -162.4880f,     -279.5481f,
    15.4135f,        -1.8583f,       -56.8319f,     -146.1688f,      -266.5346f,     -355.1809f,     -419.6793f,     -456.7536f,     -416.2208f,
    112.1756f,        88.2059f,        26.0259f,      -86.2333f,      -258.4741f,      -66.9660f,     -164.5662f,     -250.9281f,     -276.0475f,
    -51.5026f,      -135.9180f,      -210.3467f,     -175.0943f,        -7.7200f,       -1.5529f,     -138.1960f,     -292.0197f,     -364.5311f,
    1.6098f,       -29.3697f,      -112.8375f,     -233.4716f,       123.6812f,       20.4676f,      -81.0632f,     -116.0258f,     -218.5294f,
    -34.1878f,      -103.0825f,      -139.6876f,     -229.9859f,      -246.3806f,      -96.8411f,     -204.4168f,     -321.0166f,     -418.4522f,
    27.1891f,        -2.9717f,        21.2254f,     -122.5167f,      -201.1399f,       36.0115f,      -56.9192f,     -106.8464f,     -192.5580f,
    77.7097f,        24.2840f,       152.6398f,       61.5673f,       -54.9359f,       27.7810f,      -85.7347f,      -79.4392f,      -81.0366f,
    59.2315f,        15.7636f,       128.6461f,       63.2966f,       -11.4618f,       18.7670f,      -58.2229f,       42.0642f,       49.7434f,
    247.9855f,       413.3163f,       345.0402f,      192.3750f,       145.4847f,      121.6956f,      123.6805f,      107.2007f,       94.2462f,
    104.2558f,       282.0381f,       490.4723f,      344.7097f,       244.1310f,       96.7224f,        2.9896f,      -31.7180f,      -23.3323f,
    -22.5118f,       -53.8832f,      -113.5013f,     -234.2837f,        -4.7630f,       -0.8369f,      -15.3972f,       57.4113f,       45.6486f,
    -41.6155f,      -134.7804f,      -200.2841f,      179.2444f,        29.8214f,       36.0840f,     -106.4028f,      151.5328f,      102.1621f,
    141.5078f,       201.5805f,        79.4698f,     -159.8402f,      -279.6548f,     -324.4731f,     -129.3751f,       72.2403f,       81.4769f,
    -45.8403f,      -152.7728f,      -116.5580f,      262.2678f,       114.2470f,      210.0651f,      100.2266f,       64.9777f,      -14.6634f,
    -39.9272f,      -124.8000f,       -75.7294f,     -110.6360f,      -223.7299f,     -102.2257f,     -226.1053f,      -85.4944f,     -173.4764f,
    -91.6640f,        30.6543f,         4.1065f,      -65.4408f,       -39.3890f,      -89.5364f,     -102.5911f,     -125.5036f,      -48.1974f,
    27.2660f,        19.3735f,       -66.4810f,     -233.9350f,      -388.9383f,     -229.7098f,     -102.6715f,     -201.6806f,     -177.6036f,
    153.9685f,       141.8902f,        89.4281f,      -53.1892f,      -209.9941f,        8.0810f,      -71.3509f,     -135.8233f,      -78.6157f,
    -48.4004f,      -143.6756f,      -250.1705f,     -343.5184f,      -330.9693f,      -81.7413f,     -159.8642f,     -192.9882f,     -201.0525f,
    -49.7401f,      -133.3727f,      -211.5154f,     -166.0789f,      -199.3352f,       -4.0380f,      -98.3591f,     -184.6634f,     -113.6087f,
    32.7128f,       -26.7812f,       -78.3951f,     -264.0457f,      -339.2219f,       40.1904f,     -121.6728f,      -51.6241f,     -125.0696f,
    1.8568f,       -67.7562f,       -73.4413f,     -115.9242f,      -245.2522f,       77.1352f,      -22.1839f,        2.7514f,       -4.3203f,
    19.0296f,       -62.4543f,        21.8088f,      217.8850f,        43.1886f,       12.7766f,     -121.5772f,     -171.9543f,     -180.7850f,
    -0.3986f,       -96.1580f,      -120.0616f,      336.5914f,       176.9306f,       54.3062f,      -66.4501f,     -138.8101f,      -90.7495f,
    109.0295f,       377.1798f,       641.5853f,      577.4881f,       571.3625f,      438.8002f,      310.6432f,      204.9863f,      132.6160f,
    -76.9013f,       -15.0371f,       664.7503f,      520.0686f,       489.1051f,      371.2256f,      270.3431f,      196.9454f,      166.5973f,
    -42.2498f,      -134.3667f,      -336.4376f,     -457.6409f,       173.4562f,      138.1508f,       34.3921f,      -18.1609f,      -85.9677f,
    -20.8727f,      -125.4622f,      -192.7956f,      434.5861f,       290.6413f,      142.0824f,       77.1623f,      -13.2305f,      -29.4274f,
    178.7104f,       373.0402f,       459.7581f,      474.3989f,       557.5211f,      569.2194f,      525.4768f,      358.3187f,      210.4229f,
    -26.8194f,        77.7574f,       350.3222f,      445.4183f,       524.4524f,      462.1511f,      381.7293f,      289.9692f,      204.0649f,
    47.7632f,        17.1803f,      -105.1057f,       10.4223f,       -60.5128f,     -219.3625f,     -119.8198f,     -230.6158f,     -301.9153f,
    60.2078f,        16.2198f,       -62.5382f,       98.4891f,       -50.3729f,     -119.2299f,     -183.9794f,     -286.1903f,     -145.0719f,
    52.5866f,        72.1675f,       -32.1273f,     -162.5446f,      -282.0867f,     -356.6873f,     -196.9938f,     -290.2792f,     -343.8752f,
    58.1756f,        83.5942f,       -32.7989f,     -128.5429f,      -265.7008f,     -326.2490f,     -166.5130f,     -258.2744f,      -31.7978f,
    -49.8436f,      -148.3240f,      -287.2763f,     -389.7832f,      -131.7967f,        6.5863f,      -71.1640f,     -182.3324f,     -272.4139f,
    -32.6407f,      -113.2022f,      -199.3120f,     -231.3794f,         5.2103f,      172.0263f,       60.2526f,      -14.7182f,     -108.9096f,
    27.2077f,       -23.7367f,       -95.9858f,     -283.8613f,      -409.0134f,      -31.3871f,     -148.6489f,     -208.9727f,     -274.8275f,
    69.4333f,        -0.7143f,       -57.0494f,     -261.8966f,      -366.3107f,      188.4734f,       53.9671f,       24.5447f,       25.3948f,
    -4.4283f,         5.6792f,       301.6043f,      172.8969f,        55.6507f,       -7.7604f,      -81.7609f,      -49.2316f,      -63.0654f,
    -12.4033f,       -97.3530f,        37.2340f,      215.5548f,        48.4286f,       11.6666f,     -133.9813f,       32.1272f,      -33.6059f,
    57.9103f,       293.2768f,       591.9909f,      431.5314f,       338.6320f,      236.6151f,      185.2476f,      175.1540f,      156.0322f,
    -63.6185f,      -100.3640f,       351.1546f,      428.5004f,       353.7403f,      293.3142f,      196.1020f,      152.1965f,      114.6518f,
    -20.0721f,      -100.8514f,      -174.7278f,     -314.6773f,      -143.5646f,      298.1905f,      181.1825f,      142.0341f,       71.3729f,
    -64.7951f,      -146.2021f,      -143.2170f,       33.9854f,        13.8056f,      156.0337f,      163.4005f,      334.1913f,      325.3497f,
    -79.9064f,      -121.2133f,       229.6626f,      303.8755f,       306.8218f,      415.8466f,      436.8824f,      486.2830f,      451.8081f,
    -67.6130f,      -122.0631f,        41.7635f,      134.7727f,       156.2778f,      308.4236f,      340.0357f,      434.5742f,      391.1108f,
    -2.6037f,       -46.9405f,      -151.3320f,     -160.0405f,      -239.8193f,     -368.3138f,      -88.0921f,     -150.1500f,     -191.7920f,
    -79.3309f,      -112.6262f,       -20.0215f,     -129.1640f,       -35.3227f,      -69.4806f,     -159.3188f,     -223.7142f,     -132.1779f,
    21.9835f,       -11.3374f,      -106.7910f,     -244.8813f,      -406.4640f,     -311.7320f,      -96.4711f,     -182.5312f,       57.8956f,
    25.8713f,        -0.7151f,       -79.9440f,      -80.0111f,      -224.4878f,     -136.2209f,      -22.1062f,     -137.4635f,      -22.6838f,
    -17.4638f,       -88.0421f,      -183.7897f,     -361.0791f,      -194.1127f,       29.9571f,      -12.3110f,       17.3506f,      -52.9132f,
    -108.1431f,      -191.9295f,      -193.9598f,     -196.0948f,      -165.6809f,      -79.0258f,      -53.5949f,       30.1916f,       37.3619f,
    10.0420f,       -70.0023f,      -183.1197f,     -393.7681f,      -492.0758f,      102.2096f,      -13.6587f,      -51.6821f,     -101.1752f,
    -25.8195f,       -90.5090f,      -174.4579f,     -208.3670f,      -308.3139f,      -74.5783f,      -38.9631f,     -104.3672f,      142.1591f
};

/*-------------------------------------------------------------------*
 * 1nd stage, 2nd split: ISF9 to ISF15
 *-------------------------------------------------------------------*/

const float dico2_isf[] =
{
    530.1115f,      512.7983f,      443.8771f,      306.1447f,      171.2327f,       70.8250f,       56.8183f,
    248.5479f,      252.9719f,      260.5429f,      221.7305f,      172.6754f,       84.8419f,      141.5120f,
    166.9014f,      171.9745f,      263.4265f,      204.8570f,      129.5061f,       45.8705f,     -162.9417f,
    47.0761f,      115.3926f,      182.9788f,      181.5048f,       89.7111f,       17.3276f,      -86.2999f,
    -57.3148f,      -93.7950f,       58.2071f,       31.0844f,      152.3217f,      108.6931f,       41.3677f,
    -163.1767f,     -217.0378f,      215.5667f,      199.7393f,       91.8320f,       56.3535f,      -37.1534f,
    16.9371f,       75.2105f,      106.8429f,       58.4518f,       26.0167f,       13.3113f,     -106.5544f,
    -16.6336f,      -49.0904f,       66.7054f,      162.6404f,      110.2851f,       24.4686f,     -138.4124f,
    -145.3240f,      -33.7683f,     -134.5548f,      -42.3167f,      -36.8413f,      -70.9451f,      -34.7360f,
    -234.5519f,     -328.1575f,      -78.2304f,      181.4482f,      100.8272f,       -4.3886f,      -98.7986f,
    -18.7314f,      128.6640f,       38.0685f,     -113.4033f,     -211.9919f,     -310.5748f,     -138.0866f,
    -222.6271f,      -45.5429f,       72.9616f,        3.9276f,      -52.1214f,     -162.3586f,      -29.6134f,
    -241.3416f,      -50.3196f,      -96.3331f,     -145.0456f,       17.4087f,      -29.8105f,      108.3555f,
    -399.1142f,     -421.4348f,       49.0965f,      185.0085f,       99.2830f,       49.7543f,       20.2726f,
    -109.7596f,       29.7695f,      -65.3607f,     -141.1745f,     -110.3974f,     -215.1475f,     -110.3518f,
    -46.4209f,      -20.4624f,       -0.5266f,       52.1919f,      -12.3074f,      -79.8395f,     -162.1720f,
    415.6808f,      323.0418f,      248.6461f,      267.3440f,      181.1869f,       81.5855f,        4.8347f,
    188.1995f,      162.5893f,      175.4467f,      144.9775f,      131.0177f,      114.8023f,       75.6850f,
    280.8494f,      225.0358f,      142.4128f,       52.8503f,       44.0619f,       35.6548f,      -77.7252f,
    116.2722f,       68.6422f,      192.5792f,      142.9262f,       75.7274f,       63.5846f,       13.9314f,
    -13.4854f,      -92.0420f,     -101.3018f,      -13.9503f,       -1.5377f,       38.4848f,       59.2146f,
    -38.0921f,     -119.6284f,      -10.4956f,       88.8682f,       35.1836f,       43.2013f,      -33.7051f,
    35.4547f,        5.0305f,      -82.4376f,     -100.9264f,      -41.5222f,       33.5725f,      -24.8381f,
    28.3963f,      -13.4840f,      -22.4480f,      -11.9734f,       63.1961f,       13.8177f,      -75.0030f,
    -42.4115f,     -130.9516f,     -245.5204f,      -25.9129f,      -23.6896f,      -49.8110f,      125.7094f,
    -193.2334f,     -261.3991f,     -284.3770f,       75.4337f,       11.9830f,      -86.1044f,       47.5069f,
    126.4967f,       37.0484f,      -34.7501f,      -35.5687f,     -159.6523f,     -277.2735f,      -60.1203f,
    -0.1156f,      -91.4527f,       35.7808f,       12.8593f,     -134.0804f,     -237.8749f,      -85.9030f,
    -134.0644f,     -159.5199f,     -185.8239f,     -255.9559f,      -59.8235f,       31.9001f,       86.5795f,
    -191.3466f,     -290.9137f,      -99.7657f,       18.9475f,      -18.6283f,       52.5484f,      -49.6458f,
    46.4725f,      -26.2220f,     -128.3100f,     -152.1911f,     -106.3316f,     -212.7650f,      -21.8051f,
    -22.1899f,      -50.6587f,       -4.0987f,       -2.7160f,      -63.9780f,      -18.1671f,       -8.5809f,
    384.5044f,      415.7100f,      375.3419f,      221.7875f,       82.0605f,      -10.5889f,        6.1831f,
    316.8826f,      269.9225f,      294.6225f,      200.5877f,       87.3740f,      -13.6950f,       64.9923f,
    258.7122f,      274.8100f,      241.2115f,      150.6316f,       22.2879f,      -82.2525f,     -100.3677f,
    199.2028f,      140.2225f,      163.4630f,      153.3341f,       35.3954f,      -56.3718f,       -6.8714f,
    -75.2059f,      -12.0741f,      -10.5019f,       87.1330f,       34.8811f,      -55.7089f,        9.3485f,
    -43.9131f,      -38.3306f,      184.0508f,      124.7862f,       72.2168f,        1.2740f,       68.2432f,
    98.5331f,       56.9808f,      -18.2386f,      106.3234f,       18.7400f,      -82.2337f,      -91.2981f,
    56.8543f,       26.8486f,       79.2505f,      142.2529f,       26.5547f,      -20.1961f,       20.0251f,
    -101.2805f,     -186.8430f,     -272.0712f,     -136.2303f,     -296.2366f,     -195.7741f,       24.4320f,
    -195.6167f,     -300.4726f,     -112.7403f,       30.7313f,     -121.6459f,     -194.0080f,      -41.2612f,
    98.2285f,       20.7275f,      -91.7240f,     -183.2970f,     -349.5879f,     -345.3007f,       56.7721f,
    -162.4512f,     -215.0840f,       54.6896f,      -51.9437f,     -204.1752f,     -302.6133f,       17.1211f,
    -127.3559f,     -165.3954f,     -278.6780f,     -194.2370f,      -33.4488f,     -168.4021f,       38.6555f,
    -295.7049f,     -301.6402f,      -62.3113f,      -29.8345f,      -17.8150f,      -12.4093f,      147.9211f,
    33.3799f,      -13.6109f,      -78.2303f,     -156.7363f,     -259.0581f,     -406.3858f,      -96.3685f,
    -70.3287f,     -128.8603f,      -35.8870f,     -146.8926f,       10.7114f,      -71.6699f,      -42.8127f,
    499.4422f,      424.3595f,      305.0398f,      196.0019f,      126.5760f,       63.9795f,       61.1516f,
    266.3734f,      181.9720f,      175.4860f,      108.0995f,       56.9864f,       10.7695f,      159.6035f,
    247.9333f,      184.5145f,      152.3734f,       41.9318f,      -90.6959f,     -210.2689f,      -54.1531f,
    76.7519f,      154.5846f,      129.7565f,       83.0209f,       81.7690f,      -11.2691f,      -31.6182f,
    58.5084f,      -37.0541f,     -121.7467f,       29.7202f,      -30.0062f,     -124.9186f,      -19.6730f,
    18.1514f,        3.4725f,       18.4977f,       68.3406f,       54.2768f,       11.6546f,      150.1885f,
    85.0507f,       80.6332f,       -9.5051f,      -97.5608f,      -37.4477f,     -107.8952f,      -71.4574f,
    10.1458f,       46.5077f,       14.7448f,        5.4868f,       -1.5563f,      -51.9743f,      -20.1740f,
    -186.2883f,     -239.8358f,     -385.3964f,     -279.2732f,     -246.3584f,     -317.5150f,       77.9409f,
    -290.8109f,     -394.1977f,     -416.1625f,     -291.0747f,     -246.4900f,      -66.6275f,        7.0910f,
    -53.3572f,      -98.2187f,     -188.6130f,     -239.5862f,     -382.9682f,     -469.8791f,        4.8130f,
    -236.2064f,     -299.8000f,     -219.3447f,     -267.9179f,     -424.8446f,     -200.9900f,       22.5746f,
    -78.8698f,     -167.2648f,     -305.5687f,     -418.8565f,      -37.5231f,      -91.3323f,      -69.9264f,
    -187.4632f,     -276.9708f,     -417.8298f,     -350.3085f,      -51.2638f,      -35.7869f,      125.5794f,
    -56.7695f,      -75.4877f,     -200.1077f,     -284.6027f,     -223.5758f,     -298.6907f,      -81.9158f,
    -129.2158f,     -228.6000f,     -204.9319f,     -246.4877f,     -109.8989f,      -81.0975f,     -118.3144f,
    455.1133f,      431.3343f,      366.9250f,      323.3162f,      279.7654f,      166.3696f,       60.4075f,
    2.2427f,      -42.4551f,      320.2264f,      303.9626f,      161.9218f,       44.0682f,      -10.4932f,
    148.9215f,      132.3074f,      122.6564f,      103.3307f,       47.4590f,       -3.4202f,     -185.0445f,
    -145.6115f,       18.4827f,      228.0817f,      172.5267f,       38.5907f,      -90.1562f,      -43.9888f,
    -193.6085f,      -14.9922f,     -111.3547f,      102.4688f,      119.0297f,       66.3613f,        1.6199f,
    -229.1052f,     -217.2523f,       26.9406f,       25.7113f,      183.7947f,      138.0997f,        4.9246f,
    -54.0735f,       27.3595f,       -6.9751f,       41.3897f,       26.0272f,       65.3047f,     -117.9287f,
    -173.6861f,      -55.0424f,       72.3582f,       74.4772f,       59.1275f,       32.2629f,      -52.0966f,
    -100.2805f,     -203.3997f,     -281.1161f,      -77.1917f,       52.4149f,      -18.1558f,      -70.9170f,
    -319.7560f,     -456.2388f,     -303.5891f,      199.8376f,      140.0785f,       37.0556f,      -44.1020f,
    53.3338f,       -0.8373f,      -29.0162f,      -53.8806f,     -156.4895f,      -44.6551f,     -144.9031f,
    -94.4005f,     -181.9505f,       79.8505f,       87.0198f,      -12.1349f,      -82.6727f,      -75.0313f,
    -207.6459f,     -248.8868f,     -181.9412f,     -267.7931f,      100.0395f,      108.0778f,      -54.3928f,
    -445.8355f,     -486.1193f,     -148.8008f,      -29.2654f,      -20.9138f,        5.3055f,       34.4656f,
    -121.3450f,       45.0588f,      -55.9190f,     -194.9437f,     -134.0013f,       48.6244f,     -162.3284f,
    -240.5215f,      -57.3889f,      -52.6141f,       16.9554f,       -1.6593f,       47.0915f,     -144.2315f,
    326.1222f,      306.0203f,      250.4581f,      152.3629f,      138.5136f,      136.6061f,       24.8198f,
    27.9826f,       75.7094f,      172.8544f,      182.3980f,      170.1943f,       85.7041f,      145.3514f,
    181.4035f,      144.2242f,       74.8556f,        1.4272f,      -61.0836f,      -28.1913f,      -88.2541f,
    22.2453f,       80.4679f,      118.3400f,       80.0672f,       73.2458f,       39.5447f,      103.6288f,
    -15.5237f,      -80.2624f,     -190.5397f,      -72.0487f,      107.7333f,       24.8407f,       -9.9839f,
    -84.5773f,     -169.2563f,     -115.8907f,       53.5535f,      128.0731f,      120.4292f,     -112.8952f,
    147.5641f,       31.5040f,     -120.2366f,     -181.4932f,       22.0867f,      -14.3306f,       88.8276f,
    -38.8943f,        9.5208f,      -14.2124f,      -59.1263f,       77.8884f,        3.1099f,       55.9227f,
    -166.2941f,     -272.4271f,     -413.5079f,      -51.9034f,      151.3775f,       62.8211f,      125.4737f,
    -251.4761f,     -399.5025f,     -496.4470f,       15.1387f,       25.6129f,      -47.9447f,       27.2588f,
    145.3730f,       69.2023f,      -67.5157f,     -217.2383f,     -216.1160f,     -118.5795f,      -73.6690f,
    -45.7917f,     -144.0127f,     -166.1374f,      -47.5218f,     -180.4311f,      -59.2610f,      -28.7005f,
    -253.6976f,     -332.1650f,     -464.5507f,     -299.7163f,      194.1511f,      140.7432f,       86.8261f,
    -311.8663f,     -444.9106f,     -568.2597f,      -74.2214f,      168.0938f,       91.5796f,       69.8801f,
    16.2576f,      -36.8680f,     -158.1385f,     -270.2551f,       14.7501f,      -79.0270f,      -96.1519f,
    -66.0490f,     -143.0125f,     -113.3699f,      -34.3890f,      -25.0086f,       12.5482f,     -114.0537f,
    394.4650f,      360.5732f,      366.5918f,      277.4828f,      181.5850f,       89.9984f,      133.6822f,
    84.7064f,      117.2216f,      411.7273f,      263.7720f,       26.7575f,     -178.8131f,      -69.9364f,
    30.5200f,      177.1075f,      123.5531f,        7.2231f,      -92.4543f,     -193.6012f,      -94.9796f,
    65.2717f,        8.1559f,      165.7135f,       84.0440f,      -35.7379f,     -118.5377f,      -66.5232f,
    -113.0977f,      -31.5885f,      -27.3286f,      -26.0692f,       15.5114f,       21.2791f,      -23.2414f,
    -138.0497f,     -166.9724f,      -35.1916f,       20.7464f,       36.6236f,        3.5627f,       20.9882f,
    -11.0900f,      124.4114f,      110.4337f,        5.6888f,      -93.7853f,      -22.5026f,       30.8623f,
    -29.4226f,      -47.2009f,       89.3512f,       13.6996f,       22.5131f,        2.3075f,      -51.7825f,
    -137.2009f,     -200.8273f,     -290.6017f,     -325.7113f,     -275.5810f,      -53.4554f,       64.1025f,
    -438.9569f,     -542.2731f,     -412.1423f,      -89.9884f,      -28.4069f,       15.6647f,       13.8672f,
    -63.4932f,      -90.8672f,     -207.9037f,     -306.7191f,     -456.9608f,     -272.1003f,       37.6908f,
    -307.9492f,     -374.7438f,      -96.2506f,     -168.0490f,     -243.8695f,      -64.5296f,       -3.1349f,
    -334.4494f,     -210.9558f,     -246.0072f,     -354.2072f,     -131.6393f,      -27.1645f,       29.5091f,
    -366.0860f,     -407.0811f,     -257.3381f,     -286.1801f,      -81.4441f,       77.6511f,      -10.1480f,
    -204.4162f,       30.5330f,      -38.3922f,     -195.6373f,     -339.5407f,     -347.7475f,      -31.6897f,
    -243.6551f,     -274.7409f,      -17.3959f,     -136.0264f,       -9.8248f,       34.1080f,      -72.7180f,
    392.4115f,      321.3055f,      213.3703f,       97.3249f,       35.2497f,       -8.7278f,       80.8223f,
    116.4944f,      155.2541f,      148.9464f,      124.6089f,       78.0606f,       24.1574f,      118.5191f,
    184.6981f,      148.0850f,       51.9562f,      -96.3499f,     -247.0329f,     -172.3801f,       29.4305f,
    110.9024f,       81.4259f,      152.8654f,       45.1114f,       -9.8257f,       17.3401f,       36.9414f,
    -27.9329f,       30.8783f,      -37.1648f,      -24.5270f,      -50.2764f,     -114.4973f,       79.3175f,
    -64.1897f,     -136.2614f,       44.8825f,       47.6375f,       26.8591f,       -0.2729f,      147.6527f,
    135.7539f,       66.4931f,       38.8074f,       22.5599f,      -70.1020f,     -117.9085f,       73.4314f,
    -74.1601f,       -0.9165f,       58.6634f,        8.8413f,      -20.0486f,       -4.3857f,       84.5215f,
    -240.3710f,     -336.9822f,     -425.7879f,     -557.5921f,     -313.4519f,      -18.6503f,       -2.2911f,
    -375.5428f,     -498.5622f,     -604.7405f,     -284.0899f,      -22.5439f,       21.7506f,       87.1215f,
    -48.5853f,      -99.7448f,     -219.1610f,     -385.9877f,     -498.9206f,      -58.0072f,      -32.0391f,
    -187.4733f,     -257.8106f,     -348.0662f,     -465.0402f,     -523.0202f,     -126.9367f,        7.9922f,
    -242.4066f,     -358.0976f,     -506.2984f,     -527.3067f,      103.2345f,      112.8789f,       19.5721f,
    -329.7812f,     -399.2909f,     -525.3788f,     -519.3241f,     -114.6023f,       18.0531f,      108.4014f,
    -101.3959f,     -182.8774f,     -323.7689f,     -459.4139f,     -208.2967f,     -218.5872f,      -30.6618f,
    -83.9128f,     -188.9391f,     -321.0572f,     -481.5454f,     -309.1473f,        5.7541f,      -53.7133f,
    508.3954f,      514.6412f,      492.8828f,      409.4624f,      279.6907f,      139.5316f,      -25.0946f,
    225.7716f,      321.9763f,      361.4909f,      313.2012f,      246.2739f,      141.2217f,       40.0333f,
    183.5499f,      361.1524f,      299.5782f,      200.8792f,      127.5401f,       74.2915f,      -43.7510f,
    87.8314f,      192.1731f,      193.5542f,      170.6556f,      233.6155f,      150.0142f,      -17.3959f,
    16.6972f,       31.8549f,      -16.4255f,       68.2118f,      202.5792f,      133.4167f,      -24.8757f,
    -118.5934f,      -60.2884f,       62.2425f,      224.9154f,      157.3277f,       86.2001f,      127.8335f,
    83.3985f,       95.4353f,       47.7289f,      -24.4079f,      122.0239f,       35.9347f,      -62.3200f,
    85.0292f,       81.2156f,      121.2625f,      104.6399f,      119.6594f,      126.2998f,      -77.7217f,
    -111.4887f,     -105.1822f,      -30.9685f,      -48.2729f,      -55.9544f,      -59.5831f,       92.3539f,
    -80.0937f,     -149.8609f,     -166.3557f,      134.5224f,       22.8807f,      -72.2311f,      -71.7019f,
    -106.2400f,       96.5443f,       49.1033f,      -82.1511f,     -202.4001f,     -182.6395f,       30.4307f,
    -38.6498f,      -47.0332f,      196.2347f,       62.6390f,     -109.4412f,     -217.5327f,      118.6330f,
    -165.3289f,       -6.5073f,     -110.5468f,     -172.9718f,       83.9014f,       82.6244f,      -54.8262f,
    -220.1304f,     -267.2490f,      -88.9432f,      199.2986f,      140.8517f,       50.8656f,      126.1685f,
    -167.2625f,      130.8662f,       38.2409f,      -25.2887f,       14.1618f,      -84.0247f,      -96.2550f,
    -141.5362f,       19.9235f,      142.0336f,       -6.1892f,      -91.4426f,       58.7228f,      -64.2743f,
    356.9441f,      345.0619f,      293.3749f,      255.2251f,      264.2440f,      181.1552f,      -59.9296f,
    246.4391f,      212.9810f,      208.9891f,      281.1677f,      232.7401f,      140.5526f,      -31.7890f,
    305.7318f,      278.3117f,      199.8758f,      171.6015f,      133.0515f,       98.0317f,     -152.6052f,
    194.0116f,      162.7764f,       97.4355f,      145.3808f,      115.4215f,       67.7161f,      -75.3193f,
    50.0116f,      -43.0169f,     -150.4608f,       36.4008f,       15.3428f,       67.7103f,      -90.2827f,
    84.1801f,      -22.9641f,      -98.8488f,      180.4238f,      151.9562f,       59.9903f,       26.9906f,
    177.5510f,      105.3890f,       -1.4605f,     -131.7380f,      -19.1906f,       90.9329f,     -125.9315f,
    119.9137f,       55.8859f,       20.5790f,       85.2794f,       50.1218f,       92.1433f,      -60.8729f,
    -14.4439f,      -72.6866f,      -93.8542f,     -160.4042f,      -42.8567f,        3.3977f,      156.0409f,
    -54.5578f,     -142.4629f,     -245.2400f,      100.6745f,      148.4848f,       83.6861f,      108.3569f,
    51.3106f,      177.4475f,       69.0944f,     -111.1996f,     -202.9647f,       42.3005f,      -83.6978f,
    30.1802f,      -55.2034f,       78.5647f,      -47.9833f,     -191.5273f,      -51.2293f,       23.2575f,
    -5.5372f,      -75.8171f,     -203.4011f,     -289.5156f,      106.7613f,      141.4280f,      -13.0810f,
    -141.4010f,     -221.2458f,     -112.2780f,      -89.1527f,       63.0527f,       92.4026f,      123.8935f,
    -105.1256f,       76.2826f,      -29.3279f,     -146.3319f,      -79.8275f,        4.2937f,       30.2187f,
    -50.0448f,     -103.1965f,      -61.1121f,      -87.1858f,     -185.4814f,      103.5567f,       10.4906f,
    483.7709f,      447.9613f,      357.9065f,      269.2391f,      168.5860f,       81.9800f,     -109.5565f,
    312.3829f,      259.3732f,      343.4722f,      283.4192f,      160.6555f,       62.4472f,      -64.0786f,
    177.4189f,      268.0235f,      209.2622f,      107.3129f,       57.2866f,       17.7874f,       43.3733f,
    118.3413f,      189.8245f,      200.1482f,      138.5254f,       93.9936f,       70.6362f,      -26.8448f,
    30.9857f,       35.8345f,       11.3604f,       57.5567f,       90.9626f,       20.1319f,        6.8180f,
    -66.7255f,      112.7395f,       51.2972f,      171.5931f,      105.7922f,        1.0289f,       -4.0888f,
    161.4374f,       94.0077f,       56.1444f,       67.9007f,       60.5061f,       -0.5993f,        5.5333f,
    22.6145f,       84.7579f,       96.3842f,       85.7332f,       58.1820f,       68.5529f,       -7.0445f,
    89.2476f,       -2.9310f,      -93.5695f,      -80.5243f,     -200.4216f,      -74.7223f,       78.7932f,
    -37.6075f,     -106.1347f,     -177.1898f,       12.7187f,     -117.0868f,     -224.7555f,       18.0710f,
    -3.9184f,      -42.1867f,      -96.2393f,     -135.5441f,     -300.7351f,     -209.1140f,        3.3638f,
    -127.2731f,     -168.0130f,      -23.6514f,     -125.4722f,     -275.0623f,     -116.8249f,       78.4081f,
    -0.3268f,     -109.2929f,     -235.6517f,     -163.5220f,      -72.4472f,        7.1522f,      -14.1950f,
    -201.5567f,     -203.8994f,     -147.8831f,     -113.7655f,      -70.6486f,      -37.9403f,       10.4648f,
    -61.9333f,     -122.2785f,     -205.0957f,      -87.3765f,     -199.0248f,     -324.4658f,      -76.9686f,
    -114.1747f,     -179.4460f,      -22.8678f,     -120.9749f,     -219.5858f,      -55.7430f,     -137.0347f,
    416.5525f,      356.2247f,      246.4192f,      151.7590f,       80.9813f,       33.7425f,      -87.5668f,
    232.7198f,      199.8298f,      232.8017f,      197.1352f,      122.7492f,       47.7377f,      -18.8607f,
    307.4450f,      336.4361f,      172.1882f,      -36.4639f,     -118.2980f,       12.7783f,      -74.1220f,
    100.4413f,      183.0223f,      131.6807f,       19.7279f,        5.8399f,      116.3680f,      -36.1637f,
    115.0603f,       28.3727f,      -46.6535f,        9.9458f,       14.2165f,        8.8947f,       42.1125f,
    -11.0346f,       -1.0867f,      -12.6705f,       44.5022f,        8.2729f,       72.2938f,       41.9570f,
    188.4713f,      119.1476f,        5.8222f,     -109.1441f,     -124.7922f,       20.2470f,       37.4241f,
    88.4120f,       18.1026f,       44.8535f,       28.1015f,      -53.1688f,       52.0384f,      -48.7039f,
    7.0136f,      -80.7959f,     -218.2056f,     -230.6367f,     -196.4241f,     -188.3921f,      125.5651f,
    -223.0832f,     -308.3413f,     -371.4560f,      -67.3406f,     -172.4539f,     -210.1611f,       44.0330f,
    70.5425f,        5.5613f,     -121.1026f,     -250.2220f,     -391.0280f,      -78.8702f,       62.0359f,
    -53.2080f,     -153.5175f,     -168.9519f,     -200.2387f,     -356.0113f,      -56.1841f,       -8.4833f,
    28.1989f,     -103.3445f,     -275.6373f,     -372.5401f,      -62.2850f,       20.7805f,      129.8285f,
    -131.8626f,     -230.9837f,     -332.7086f,     -149.5865f,     -154.3909f,       21.7068f,       17.3275f,
    16.7300f,      -61.8863f,     -181.1369f,     -350.5149f,     -246.6439f,      -61.1861f,     -114.9767f,
    -62.9283f,      -50.0990f,     -128.3168f,     -223.8037f,     -188.6130f,      -48.9473f,        4.2910f,
    397.1338f,      354.0856f,      410.7048f,      392.6840f,      265.0492f,      133.1239f,      -39.9595f,
    140.3398f,      130.2926f,      612.1718f,      513.2461f,      282.4946f,       41.1820f,        3.7939f,
    -25.5253f,      283.5953f,      206.7656f,      117.4847f,       85.9801f,       16.9447f,     -106.7023f,
    -199.2065f,      170.3263f,      280.7031f,      221.1866f,      139.8684f,       69.7774f,       44.7026f,
    -218.6125f,      116.3745f,       51.8822f,      -46.6960f,      133.6225f,       87.8249f,        5.3826f,
    -351.2338f,      -39.4894f,       84.6148f,      241.0717f,      156.3851f,       57.0277f,      -22.5485f,
    -16.1558f,      137.3482f,       31.9090f,      -76.7114f,       15.3505f,       47.2591f,      -65.0792f,
    -82.6497f,       23.1536f,      174.7281f,      111.0391f,      165.1666f,       97.6276f,      -66.0758f,
    -144.8786f,     -188.8722f,     -232.9240f,       11.8115f,      -15.8240f,       97.1230f,        8.4134f,
    -145.3324f,     -253.9705f,     -310.2223f,      186.1852f,      173.7029f,       84.4147f,      -31.0347f,
    -137.6416f,      107.5353f,        6.4667f,     -172.8744f,     -362.7197f,       36.0251f,        7.3423f,
    -273.1752f,     -271.7551f,      168.5304f,      103.1478f,      -19.2394f,     -121.0773f,       71.0605f,
    -382.1200f,      -84.7432f,     -167.9304f,     -156.0550f,       39.5436f,      102.1275f,       28.0496f,
    -362.7133f,     -347.0801f,     -139.5875f,       -5.2563f,      181.0231f,      147.5667f,       92.1709f,
    -322.5983f,       22.0118f,       11.8984f,     -116.7982f,     -140.8088f,      -50.1710f,      -20.0495f,
    -342.8153f,     -116.9352f,      -43.2698f,       29.1059f,       25.4655f,       14.1526f,        1.1041f,
    319.3257f,      143.9371f,       -9.8398f,      138.1817f,      272.2951f,      230.7682f,      -67.6844f,
    120.5561f,       82.8050f,       86.9118f,      293.3890f,      188.8921f,       54.7609f,      -21.7199f,
    231.6328f,      148.0905f,       27.2085f,       -3.2337f,      100.6721f,       70.2593f,       42.8315f,
    64.4154f,      -17.9857f,       99.5439f,      116.0344f,       85.7395f,      106.6537f,       41.0177f,
    62.6236f,      -27.4056f,     -139.7237f,      -70.5707f,      148.2318f,      128.9077f,      124.7000f,
    -92.9236f,     -144.0688f,      -77.1586f,      288.9071f,      226.4347f,      124.6281f,      -55.6669f,
    78.3503f,       42.4807f,      -79.0042f,     -178.3122f,      128.1446f,      107.8855f,      -55.1806f,
    79.1238f,       66.4433f,       43.2504f,       16.2992f,       80.8281f,      140.7251f,       73.5809f,
    -134.6119f,     -155.8599f,     -200.3194f,      -90.9865f,      253.7969f,      164.9683f,       31.5576f,
    -248.1197f,     -375.5200f,     -476.6351f,      180.7157f,      210.6575f,       79.8609f,       81.7351f,
    78.7261f,       -9.7665f,      -75.8617f,     -194.4922f,     -307.4282f,       75.4347f,      -56.0501f,
    -175.4331f,     -210.0029f,       75.9892f,      -41.3638f,     -129.4197f,       26.7040f,       24.1293f,
    -89.1388f,     -186.3199f,     -327.9780f,     -225.0781f,      123.8019f,       49.8056f,      110.5614f,
    -262.0009f,     -365.9398f,     -315.0958f,      -44.6833f,      152.6366f,      130.9091f,      -24.3555f,
    96.1914f,        0.9431f,     -122.7709f,     -265.0437f,     -118.4077f,       70.4388f,      -34.3324f,
    -41.7155f,     -106.2450f,       35.3080f,      -77.1729f,      -11.0485f,      113.3317f,      -43.5801f,
    345.8234f,      448.9382f,      398.8093f,      278.1467f,      193.7783f,      109.9307f,      -32.5084f,
    105.2215f,      192.0218f,      307.4095f,      251.2213f,      135.6460f,       27.1659f,       48.2501f,
    131.1255f,      248.6208f,      194.8135f,       35.9742f,      -89.6413f,      -70.1114f,       74.4933f,
    10.3277f,      157.1341f,      220.2146f,      132.8669f,       58.2022f,       -4.2414f,       52.5998f,
    -171.9997f,      219.1700f,      183.7592f,       79.7388f,      -28.2743f,      -72.7875f,       54.8047f,
    -281.0813f,        5.4272f,      138.6439f,       89.6476f,       26.7423f,      -52.0621f,      181.8158f,
    42.9908f,      121.1063f,       40.1449f,        4.6961f,       41.3091f,       11.3680f,       61.7374f,
    -69.6739f,       44.0933f,       62.9511f,       55.3414f,       47.1718f,       45.0520f,       10.5398f,
    -254.2462f,     -161.6377f,     -252.0311f,      -59.3082f,      -64.1228f,       -5.1355f,     -167.6060f,
    -249.7012f,     -368.7658f,     -266.1853f,      -40.5172f,      -31.5949f,       20.3852f,      -73.7292f,
    -259.0964f,      -63.9727f,     -123.4555f,     -266.6797f,     -372.6790f,      -79.9634f,      -32.2913f,
    -237.8991f,     -261.1591f,      -67.3100f,     -201.9258f,     -271.1355f,      110.5556f,      -31.4253f,
    -252.1870f,      -59.5241f,     -149.7008f,     -264.8359f,      -95.9333f,      -15.7623f,      -55.9292f,
    -291.6127f,     -310.8436f,     -291.0997f,     -152.3425f,      -38.1903f,       16.9302f,      107.5521f,
    -234.1635f,      -77.8775f,     -155.4929f,     -169.1375f,     -170.1633f,     -210.0618f,       12.2871f,
    -432.5516f,     -222.0327f,     -146.7204f,     -103.4423f,      -49.3643f,       -8.0516f,        0.3778f,
    330.7150f,      223.7578f,      120.2566f,      152.9689f,      119.1688f,       39.3462f,       21.3169f,
    106.4649f,      114.2936f,       78.3297f,      104.4772f,      135.1724f,       78.5670f,       48.1339f,
    284.0033f,      187.5895f,       88.2418f,        0.6583f,      -25.3445f,      -53.7671f,       63.9802f,
    106.5275f,       81.1295f,       67.7705f,      114.2483f,        4.6206f,       98.6728f,       68.0557f,
    132.7267f,       80.9311f,       70.2013f,       34.2614f,       45.4356f,       17.9487f,      185.5185f,
    -179.6926f,      -64.9953f,      -11.8397f,        5.1401f,       42.9932f,       67.5337f,      154.7699f,
    53.6060f,       34.2805f,       16.7478f,      -53.4059f,      -36.7348f,       13.1978f,      110.7422f,
    37.6082f,       -5.5267f,       88.1530f,       15.7336f,       24.4194f,       27.1976f,       50.6641f,
    -182.5485f,     -287.0959f,     -395.1311f,     -458.4781f,     -119.8993f,      119.0388f,      -26.2634f,
    -239.2084f,     -359.3420f,     -447.6111f,     -221.6196f,       -3.2312f,       35.8538f,       -9.6860f,
    -70.9599f,     -105.8073f,     -192.0091f,     -294.5047f,     -334.6240f,      111.9638f,      -29.3527f,
    -193.0902f,     -307.5872f,     -268.9553f,     -266.8591f,     -276.8985f,       53.4395f,     -127.3159f,
    -112.3830f,     -214.7503f,     -352.5892f,     -431.6330f,      130.6462f,      125.3650f,      -24.3701f,
    -138.4310f,     -254.9568f,     -325.5955f,     -173.9416f,        0.3136f,      147.4202f,      -59.5469f,
    -63.4081f,     -119.3462f,     -237.6156f,     -366.1194f,     -116.1935f,       96.5096f,      -74.8714f,
    -91.5009f,     -186.5192f,      -95.3213f,     -190.6698f,     -103.7853f,      133.5730f,     -129.6124f
};

/*-------------------------------------------------------------------*
 * AMR-WB ISF codebook - 46bits, 2 stages, 1st stage common with the
 *                       36bit codebook,5 splits in the 2nd stage
 *
 *  codebook   vector dimension    number of vectors
 *  ~~~~~~~~   ~~~~~~~~~~~~~~~~    ~~~~~~~~~~~~~~~~~
 *     2_1            3                  64
 *     2_2            3                  128
 *     2_3            3                  128
 *     2_4            3                  32
 *     2_5            4                  32
 *-------------------------------------------------------------------*/

/*-------------------------------------------------------------------*
 * 2nd stage, 1st split: ISF0 to ISF2
 *-------------------------------------------------------------------*/

const float dico21_isf_46b[] =
{
    128.4688f,      159.8148f,       97.2755f,
    -12.9836f,      197.1542f,       62.3669f,
    -11.1370f,       -5.4038f,      227.1786f,
    -102.5247f,       49.5302f,      138.2452f,
    56.6014f,       92.4597f,       68.2462f,
    -59.4614f,       95.8021f,       47.7671f,
    10.6214f,       16.4206f,      132.7432f,
    -33.0052f,      -36.4880f,      121.6274f,
    111.3621f,       86.8573f,      -60.9301f,
    18.4019f,      -16.9460f,     -196.8595f,
    91.2159f,       47.1568f,      150.3417f,
    40.7444f,     -123.8314f,       17.6656f,
    68.7560f,       76.0870f,        3.0834f,
    40.5189f,      -22.9558f,      -36.8239f,
    68.9463f,       20.8592f,       75.1641f,
    -13.4297f,      -49.7472f,       59.4394f,
    222.6512f,      108.2263f,      -13.1594f,
    -26.2678f,     -128.5232f,     -249.6796f,
    -61.3770f,     -106.3253f,      180.3803f,
    -69.2195f,     -180.5594f,       77.3840f,
    125.7118f,       69.8739f,       44.7696f,
    -150.6344f,       66.9866f,        7.4132f,
    7.5039f,       -4.7150f,       76.2746f,
    -46.9159f,      -98.2953f,       78.4325f,
    118.5603f,       14.1695f,     -131.2373f,
    -50.1565f,      -86.1739f,     -148.3825f,
    66.6965f,      -72.1903f,      115.4583f,
    -94.5599f,     -121.9918f,        8.8523f,
    77.1679f,       15.2443f,        6.1163f,
    -1.0987f,      -69.2605f,      -43.3316f,
    43.3928f,      -36.3404f,       29.4998f,
    -36.0829f,      -87.1134f,        1.6094f,
    69.0548f,      158.6352f,      -17.3680f,
    -65.7580f,      148.4039f,      -58.1224f,
    -1.4207f,      106.6547f,      129.4115f,
    -163.9787f,      200.5753f,      108.3887f,
    8.0981f,       96.4962f,       18.4523f,
    -22.7513f,       51.0308f,       -0.8203f,
    -1.3389f,       52.2067f,       70.5057f,
    -56.5316f,       15.5148f,       68.5082f,
    73.6822f,       28.9345f,      -56.5083f,
    -10.5212f,      -17.6820f,     -126.8611f,
    144.6737f,      -44.4661f,       -8.2446f,
    -32.2712f,     -161.9950f,      -67.5138f,
    29.9266f,       37.2667f,      -20.0451f,
    -15.7787f,      -11.7016f,      -26.2432f,
    27.7648f,       34.4647f,       33.4065f,
    -13.8614f,      -38.4420f,        5.6107f,
    27.0098f,       76.8588f,     -130.2875f,
    -76.5280f,       30.9527f,      -90.1727f,
    -135.8326f,      -53.3710f,       85.3346f,
    -137.4852f,      -34.8750f,      -33.3215f,
    18.2807f,       78.3958f,      -50.7970f,
    -64.5101f,       14.5083f,       -5.6925f,
    -16.6084f,        1.0141f,       33.5889f,
    -63.0082f,      -42.0433f,       31.0393f,
    32.2577f,        8.3123f,      -92.4112f,
    -31.6346f,      -58.2893f,      -92.9305f,
    58.7086f,      -72.6659f,      -98.0877f,
    -72.8089f,      -97.1838f,      -63.2264f,
    -7.5866f,       25.6299f,      -54.3822f,
    -10.3321f,      -19.4552f,      -70.7729f,
    9.4725f,        4.3403f,        0.0721f,
    -50.7563f,      -41.0679f,      -38.2745f
};

/*-------------------------------------------------------------------*
 * 2nd stage, 2nd split: ISF3 to ISF5
 *-------------------------------------------------------------------*/

const float dico22_isf_46b[] =
{
    -49.5271f,      121.1295f,       16.4769f,
    -94.4022f,       76.8061f,        2.1280f,
    -58.8683f,       32.7926f,       -6.6703f,
    -83.7461f,       49.5749f,      -58.1205f,
    -96.5332f,      -51.1816f,       62.2310f,
    -104.6874f,     -104.4218f,      -36.9709f,
    -84.8023f,        0.4441f,      -31.0082f,
    -105.8907f,      -31.0867f,      -72.0962f,
    -17.4561f,      170.2726f,       62.0341f,
    64.3231f,       77.6492f,      152.6545f,
    -13.0558f,       31.6496f,       73.1381f,
    -25.9540f,      -16.3235f,      138.6579f,
    -116.2904f,      -22.1347f,      133.9606f,
    -42.0923f,     -209.9028f,       88.4509f,
    -56.0897f,       -9.1734f,       75.5450f,
    68.7883f,     -157.0452f,       33.8343f,
    20.5838f,      115.6837f,        9.8136f,
    -32.8948f,       98.7358f,      -40.4656f,
    -22.8099f,       41.1383f,      -49.3496f,
    -66.1700f,       67.9190f,     -122.8227f,
    -18.8196f,       17.0630f,     -114.9884f,
    -64.0458f,     -162.7084f,      -94.5118f,
    -54.2084f,        1.0923f,      -75.9526f,
    -60.5415f,      -80.9324f,      -82.4130f,
    46.5760f,      125.8621f,       83.1458f,
    129.9934f,       19.7027f,      148.2803f,
    92.6546f,       96.4434f,       -0.8040f,
    181.9977f,       -6.0791f,       78.6212f,
    93.0392f,      -99.5781f,      -41.6073f,
    26.0437f,     -172.0070f,      -58.1634f,
    47.8475f,      -34.2895f,      -54.2498f,
    34.4187f,      -96.6345f,      -28.5027f,
    -15.8270f,       90.1190f,       65.2787f,
    -24.1274f,       60.7006f,        6.3059f,
    -25.2307f,        6.3412f,       30.0794f,
    -26.6845f,       -0.7965f,      -24.5917f,
    -59.0614f,     -117.3599f,       62.4002f,
    -7.0821f,     -130.0555f,       20.9710f,
    -21.7086f,      -36.6794f,        1.9468f,
    0.6440f,      -74.2564f,        5.5161f,
    35.9276f,       57.9971f,       81.4502f,
    42.2272f,        3.3575f,      106.2218f,
    42.1565f,       13.6719f,       43.0135f,
    55.6116f,      -33.1310f,       56.8126f,
    18.4410f,      -61.4055f,      109.0841f,
    1.0223f,     -125.1248f,       96.1657f,
    16.9404f,      -28.1707f,       26.5748f,
    33.5245f,      -84.6827f,       52.6704f,
    14.2066f,       54.8716f,       30.7506f,
    21.9479f,       68.4119f,      -19.0589f,
    10.1034f,       17.7161f,        1.1122f,
    28.3594f,       21.5207f,      -39.3190f,
    42.6619f,      -71.6784f,      -94.4716f,
    -1.6345f,     -110.6804f,      -94.5938f,
    18.7091f,      -26.5385f,      -18.5676f,
    -2.2267f,      -59.7051f,      -47.6606f,
    63.0633f,       76.6895f,       37.6845f,
    90.5993f,       31.2041f,       74.2520f,
    64.4418f,       37.7231f,        4.2748f,
    100.9151f,      -12.1708f,       27.5607f,
    104.1606f,      -30.0584f,      -35.7097f,
    121.5339f,      -81.6812f,       34.1503f,
    59.3840f,       -5.5457f,       -8.5514f,
    58.5319f,      -58.3782f,        3.4649f,
    -126.3823f,      217.4185f,       72.9956f,
    -149.8116f,      119.9919f,       17.7920f,
    -98.1555f,       10.6050f,       30.1117f,
    -142.4950f,       30.1718f,      -20.4500f,
    -188.3500f,      -32.7229f,       62.5055f,
    -165.4842f,     -201.2336f,      -25.1871f,
    -114.8346f,      -46.6803f,       -1.4401f,
    -185.9166f,      -45.3806f,      -42.6756f,
    -37.7442f,      124.2892f,      142.7720f,
    41.5423f,      244.7676f,      173.7613f,
    -74.1037f,       46.8818f,      112.0588f,
    -57.0922f,       25.5056f,      241.9654f,
    -166.9268f,       94.6864f,      141.8443f,
    -141.0368f,     -145.0649f,      168.9254f,
    -135.5530f,       39.8468f,       65.4743f,
    -245.6494f,       76.1803f,       -5.6309f,
    -25.5608f,      185.7902f,      -18.2246f,
    -116.1471f,      125.0659f,      -65.5997f,
    -21.6448f,      139.2267f,     -103.0516f,
    -152.7089f,       32.1737f,     -111.7466f,
    -19.9673f,      -12.1771f,     -217.1499f,
    -69.4452f,     -156.0378f,     -228.9529f,
    -79.9513f,      -19.3186f,     -140.5787f,
    -134.0792f,      -92.8863f,     -131.5222f,
    85.7696f,      178.6823f,       22.5404f,
    219.0179f,      182.4547f,      100.9819f,
    132.7898f,      105.4102f,      -65.5694f,
    175.6583f,       30.2382f,     -109.3055f,
    23.2833f,       65.0492f,     -161.3234f,
    51.9178f,      -98.2708f,     -192.0347f,
    84.2797f,       61.1831f,     -113.4513f,
    110.0580f,        0.1775f,     -193.4730f,
    -88.3674f,      114.5595f,       71.3481f,
    -61.4713f,       52.7833f,       47.8295f,
    -61.8477f,      -23.0151f,       15.1016f,
    -52.0862f,      -46.0690f,      -37.7005f,
    -129.6202f,     -120.6827f,       44.2216f,
    -62.4412f,     -165.8667f,       -2.2683f,
    -58.1508f,      -82.2449f,        9.3842f,
    -31.2569f,     -108.3441f,      -35.0348f,
    -4.4143f,       48.6610f,      132.2242f,
    50.8942f,      -27.6676f,      181.6500f,
    2.0066f,      -17.6839f,       71.9731f,
    92.7139f,      -37.1637f,       98.9732f,
    -54.3785f,      -76.9789f,      115.8870f,
    -7.4354f,     -117.3479f,      199.5254f,
    -24.6757f,      -59.5165f,       54.3134f,
    97.6902f,     -113.0194f,      131.1002f,
    48.4163f,      132.4722f,      -58.7820f,
    13.3327f,       68.6117f,      -81.0715f,
    66.7414f,       64.6961f,      -45.2427f,
    36.7779f,       14.7160f,      -89.5910f,
    29.2181f,      -25.5238f,     -132.3077f,
    -30.5052f,      -80.0320f,     -150.5560f,
    0.1157f,      -11.7322f,      -63.8467f,
    -21.6912f,      -43.0765f,      -94.6223f,
    125.3290f,       95.1208f,       75.9759f,
    197.4010f,       92.9319f,       -0.5012f,
    123.8246f,       45.4969f,       25.5317f,
    120.7415f,       34.4155f,      -28.8961f,
    176.6600f,      -20.0903f,      -19.4091f,
    130.6288f,      -84.9368f,     -113.4633f,
    82.2281f,       16.0388f,      -59.4614f,
    93.1589f,      -21.5846f,     -101.7248f
};

/*-------------------------------------------------------------------*
 * 2nd stage, 3rd split: ISF6 to ISF8
 *-------------------------------------------------------------------*/

const float dico23_isf_46b[] =
{
    -3.8995f,       58.9472f,      140.2168f,
    53.1422f,      116.3810f,       87.0383f,
    99.7094f,      -40.4441f,      113.1331f,
    165.1496f,        2.2135f,       71.5223f,
    -105.3934f,     -104.9144f,      -38.2897f,
    -20.3247f,      -32.1811f,        5.1214f,
    -32.0250f,     -106.9634f,      -37.7452f,
    35.0256f,      -95.9288f,      -28.2073f,
    -116.9343f,      -27.2704f,      164.5334f,
    -34.2352f,      142.6884f,      167.9453f,
    72.9835f,     -124.0776f,      148.8355f,
    148.2748f,       14.5359f,      190.7047f,
    -145.5305f,     -123.4847f,       30.8224f,
    -120.2600f,      -39.3306f,        2.0939f,
    -52.9049f,     -176.3645f,        3.0609f,
    27.9487f,     -164.3167f,      -60.3281f,
    70.4088f,       66.5042f,      -47.2043f,
    24.2507f,       69.1997f,      -15.5014f,
    127.5028f,       31.2976f,      -40.8233f,
    96.9136f,      102.7271f,       -1.9768f,
    -65.7818f,      -70.8663f,      -86.5155f,
    -0.6444f,       -8.8675f,      -61.8361f,
    -5.3369f,      -58.3089f,      -47.3390f,
    46.4765f,      -35.6284f,      -57.4718f,
    46.3328f,      129.6813f,      -59.6592f,
    18.9988f,      118.4842f,       13.3515f,
    172.5430f,      -21.3132f,      -26.8827f,
    84.7525f,      177.2668f,       22.5077f,
    -140.2432f,      -73.0634f,     -146.3583f,
    -16.3786f,       19.6063f,     -107.1305f,
    -3.0698f,     -104.1769f,      -97.1330f,
    33.2378f,      -33.4660f,     -134.9635f,
    -29.8971f,      -15.7433f,      134.7990f,
    34.9346f,       52.2504f,       85.7197f,
    60.8752f,      -31.2562f,       62.5970f,
    42.3279f,       15.7348f,       45.3299f,
    -61.8761f,      -80.5864f,       11.3831f,
    1.9118f,      -12.4255f,       68.2023f,
    -25.4049f,      -61.6688f,       57.1412f,
    21.3127f,      -30.3874f,       28.3554f,
    -44.5637f,      -86.8534f,      137.9897f,
    -18.2977f,       31.6219f,       82.2796f,
    19.0573f,      -58.8750f,      104.6892f,
    41.1433f,        1.5028f,      117.9977f,
    -102.7489f,      -51.4207f,       71.3300f,
    -59.0984f,      -10.9389f,       78.5554f,
    -69.1486f,     -120.0273f,       65.0256f,
    39.6252f,      -86.2109f,       50.9690f,
    29.0714f,       22.6919f,      -38.4256f,
    12.6360f,       17.2986f,        5.2183f,
    75.9445f,       11.6720f,      -55.4942f,
    66.2898f,       37.5939f,        3.0594f,
    -53.0062f,      -46.4272f,      -35.4140f,
    -25.4219f,        2.9542f,      -21.2949f,
    1.3392f,      -73.4502f,        4.6640f,
    17.5926f,      -24.6153f,      -19.1614f,
    58.2567f,       -8.0154f,       -7.3521f,
    9.4616f,       56.2212f,       37.1474f,
    99.2497f,       -8.5999f,       23.5678f,
    62.8908f,       76.5199f,       37.4883f,
    -61.5740f,      -23.6494f,       18.8743f,
    -27.4404f,       12.7151f,       31.8660f,
    -8.8214f,     -125.3200f,       22.5806f,
    60.3707f,      -57.3931f,        1.9729f,
    -142.0781f,      128.1134f,       29.9265f,
    -8.1434f,      177.0072f,       67.7176f,
    -42.2467f,       31.9985f,      246.1330f,
    143.5303f,      102.5801f,       81.3050f,
    -117.3709f,      -24.3191f,      -68.7836f,
    -80.1727f,       55.9021f,      -61.6700f,
    -65.9167f,     -159.9841f,     -103.0851f,
    100.4774f,     -105.1623f,      -39.0393f,
    -248.4434f,      113.0562f,       -0.9632f,
    -114.2012f,      244.7349f,       67.3892f,
    -149.2039f,     -141.9386f,      151.3480f,
    96.8171f,      204.6967f,      174.6282f,
    -203.4799f,      -43.3805f,      -41.7327f,
    -154.4080f,       46.2418f,     -107.0591f,
    -133.7993f,     -265.7036f,      -48.9596f,
    -67.3323f,     -174.6485f,     -259.0245f,
    29.4362f,       57.7183f,     -143.2330f,
    -30.9358f,      102.7735f,      -36.8946f,
    97.2809f,       57.7730f,     -111.7326f,
    148.5371f,      105.7429f,      -63.3760f,
    -55.6062f,       -1.6898f,      -72.6741f,
    -22.0825f,       43.4697f,      -48.9841f,
    -13.6583f,      -42.0695f,      -99.1267f,
    39.0227f,       11.1441f,      -94.4170f,
    -31.1674f,      118.4450f,     -103.1298f,
    -30.5761f,      181.1050f,      -22.4168f,
    96.8625f,       -8.6867f,     -192.7743f,
    258.0970f,      258.6485f,       17.2359f,
    -75.4867f,      -15.7399f,     -128.9883f,
    -69.4209f,       56.4875f,     -131.4587f,
    -35.1219f,      -77.9249f,     -156.1559f,
    -15.4754f,       -8.8922f,     -194.7119f,
    -74.8584f,       44.6175f,      122.9601f,
    -15.9046f,       95.4389f,       74.2532f,
    34.5640f,      -37.7631f,      189.4453f,
    93.9878f,       31.0970f,       82.8675f,
    -96.2834f,       15.6201f,       33.9921f,
    -60.9930f,       57.5930f,       52.2667f,
    -0.7661f,     -130.2809f,       93.4385f,
    120.2708f,      -79.2677f,       42.9508f,
    -179.2200f,       97.8633f,      164.7641f,
    -85.0375f,      121.2092f,       89.0752f,
    -33.4305f,     -135.1092f,      255.3923f,
    71.7349f,       68.5372f,      165.8218f,
    -187.7999f,      -24.7305f,       65.9037f,
    -136.4161f,       45.6197f,       73.4184f,
    -48.8887f,     -218.9293f,      120.9648f,
    61.8728f,     -162.4253f,       36.5784f,
    17.9416f,       66.9736f,      -75.1315f,
    -24.6266f,       61.4069f,        5.3953f,
    100.0199f,      -13.7281f,     -105.7749f,
    125.9485f,       48.0431f,       20.6117f,
    -83.4273f,        1.6803f,      -29.7397f,
    -60.9733f,       33.6154f,       -6.9071f,
    49.9381f,      -77.0001f,      -90.5842f,
    103.7070f,      -35.1051f,      -38.3706f,
    -120.2797f,      129.5670f,      -56.7507f,
    -51.1815f,      120.2600f,       22.5398f,
    198.7324f,       23.1592f,     -132.3752f,
    219.6951f,       76.6881f,       -5.4836f,
    -147.6706f,       39.1117f,      -18.2240f,
    -91.4913f,       78.8627f,        0.3161f,
    40.5908f,     -105.4075f,     -192.5737f,
    124.6250f,      -81.8382f,     -127.0619f
};

/*-------------------------------------------------------------------*
 * 2nd stage, 4th split: ISF9 to ISF11
 *-------------------------------------------------------------------*/

const float dico24_isf_46b[] =
{
    -30.8071f,      -34.8458f,       -1.7377f,
    -66.7509f,       30.0385f,      -82.3340f,
    62.4748f,      -75.5700f,       38.3392f,
    47.0287f,      -40.0671f,      126.1063f,
    12.5178f,       -8.7146f,      -50.3954f,
    27.9620f,       30.3537f,     -104.7235f,
    71.0260f,      -29.6231f,      -25.7014f,
    120.7753f,       38.6709f,      -56.4990f,
    -89.5313f,      -61.4613f,      -32.9542f,
    -149.7260f,       38.4143f,      -27.8365f,
    -35.1587f,     -137.6189f,        4.6136f,
    -110.8198f,      -69.6633f,       69.4652f,
    -25.4794f,      -48.9702f,      -64.6927f,
    -34.0250f,      -68.5378f,     -137.1167f,
    16.3769f,      -77.3935f,      -18.8382f,
    60.1539f,      -54.6626f,      -95.0395f,
    -29.9828f,        6.8644f,       42.3138f,
    -15.0985f,      138.6659f,       35.6532f,
    34.1357f,        3.3162f,       60.3957f,
    -1.5046f,       61.8542f,       93.5327f,
    49.8233f,       37.2486f,      -21.0923f,
    2.6462f,       96.2433f,      -48.4645f,
    100.8559f,        5.8835f,       34.9436f,
    80.3813f,       84.4933f,       38.3143f,
    -78.4639f,        3.3495f,        7.0416f,
    -121.9442f,       90.8917f,       79.7252f,
    -15.2997f,      -67.8455f,       60.6317f,
    -56.1035f,       -3.5687f,      110.7510f,
    -22.2741f,       27.4204f,      -26.9833f,
    -61.1362f,       73.0974f,        7.1390f,
    21.0362f,      -11.6205f,        9.0680f,
    9.3252f,       52.8599f,       21.3451f
};

/*-------------------------------------------------------------------*
 * 2nd stage, 1st split: ISF12 to ISF15
 *-------------------------------------------------------------------*/

const float dico25_isf_46b[] =
{
    65.8574f,       55.5896f,      -46.5520f,       44.9019f,
    80.4838f,       -7.7875f,       36.7110f,       88.1867f,
    -41.5522f,      122.0924f,       -8.3769f,        6.2406f,
    -24.0605f,       63.0705f,       27.8308f,       99.4548f,
    -34.8725f,       39.6270f,      -72.1743f,       48.7995f,
    28.2859f,      -11.6999f,      -78.4246f,      134.1911f,
    -100.6717f,       12.7337f,       -3.2716f,       31.4897f,
    -40.5514f,      -60.1846f,       28.1000f,      115.5554f,
    56.1050f,      -26.6471f,     -104.7202f,       -9.7237f,
    31.5196f,      -30.3722f,      -34.0636f,       41.4375f,
    8.5013f,       60.4295f,      -72.4835f,      -46.4772f,
    -18.1378f,      -10.8741f,       10.5206f,       35.6699f,
    -44.7247f,      -14.6405f,      -68.4296f,      -12.8925f,
    -36.6233f,      -86.8592f,      -73.8785f,       47.7951f,
    -51.6319f,      -46.3776f,      -74.4907f,     -105.4981f,
    -67.2817f,      -67.7186f,        6.9193f,      -16.9668f,
    108.8168f,       52.7624f,      -16.3049f,      -50.0846f,
    72.9801f,      -33.7268f,       89.4150f,      -54.0673f,
    62.1588f,       93.8928f,       54.7414f,       17.8328f,
    26.7626f,        9.6218f,       88.5287f,       29.9594f,
    8.1440f,       44.9198f,        5.0806f,        2.9996f,
    26.4759f,      -96.7328f,       49.0444f,       31.6496f,
    -58.6349f,       53.6024f,       80.8924f,       -3.3883f,
    -60.0341f,      -51.9482f,      112.9073f,       26.0056f,
    55.9483f,      -14.6255f,      -33.5049f,     -127.3506f,
    70.1847f,      -12.4499f,        7.3368f,       -8.8635f,
    10.1728f,       65.7077f,       45.2101f,      -90.9790f,
    -12.5750f,      -10.0652f,       45.9762f,      -30.2995f,
    1.2805f,       -3.2898f,      -17.5766f,      -44.9828f,
    22.1316f,      -84.0894f,      -21.1065f,      -32.5923f,
    -81.6581f,       43.6873f,       -8.6894f,      -65.0775f,
    -35.4129f,      -58.9663f,       65.8078f,     -102.2045f
};

/*-------------------------------------------------------------------*
 * AMR-WB ISF codebook - 36bits, 2 stages, 1st stage common with the
 *                       46bit codebook,3 splits in the 2nd stage
 *
 *  codebook   vector dimension    number of vectors
 *  ~~~~~~~~   ~~~~~~~~~~~~~~~~    ~~~~~~~~~~~~~~~~~
 *     2_1            5                  128
 *     2_2            4                  128
 *     2_3            7                  64
 *-------------------------------------------------------------------*/

/*-------------------------------------------------------------------*
 * 2nd stage, 1st split: ISF0 to ISF4
 *-------------------------------------------------------------------*/

const float dico21_isf_36b[] =
{
    -20.3147f,      -37.6762f,       82.8575f,      122.9161f,      -28.4468f,
    31.9756f,      -79.5400f,      141.6557f,       53.2923f,      -77.0688f,
    -49.3360f,     -129.1711f,       71.5448f,       85.1944f,       55.7117f,
    -19.1147f,      -16.1797f,      217.6729f,       89.8943f,       28.1868f,
    0.9668f,      -28.5091f,       63.7145f,      147.3305f,       86.3104f,
    52.0605f,       43.3415f,      108.6263f,       83.9071f,      -42.8628f,
    -39.7734f,       -7.6796f,      110.7755f,       44.0677f,      106.4663f,
    32.7239f,      124.4301f,      113.4192f,        7.2217f,       33.0503f,
    -9.5746f,       -1.9619f,       48.6607f,       51.4268f,      -79.8193f,
    -14.9729f,       -2.0174f,      111.5604f,       -3.5774f,     -139.2041f,
    -54.5000f,     -100.1092f,       35.8796f,       45.5500f,      -73.7805f,
    -56.2694f,       74.4424f,      122.2707f,       20.1155f,      -38.3887f,
    65.2094f,       -3.9808f,       17.2638f,       96.6362f,       14.0115f,
    148.8982f,       77.1199f,       93.1280f,       28.7596f,        2.2577f,
    14.8324f,     -159.4414f,       11.4260f,       -1.0211f,      -33.2422f,
    35.9112f,      103.8106f,       61.4044f,       -9.7034f,      -78.2548f,
    62.7658f,      -47.4034f,       27.3267f,       32.6865f,      -54.7569f,
    -6.2693f,      -33.7779f,       43.5591f,      -36.6678f,      -73.8111f,
    -104.9376f,     -105.4944f,      137.0911f,       41.7979f,       -9.4558f,
    -26.6750f,      -26.3288f,      192.3279f,      -40.3915f,      -60.3539f,
    -20.5168f,      -51.3274f,       24.2191f,       47.5655f,        3.7810f,
    52.7448f,       32.7149f,      110.3630f,      -21.5464f,      -46.7397f,
    -4.6471f,      -85.4498f,      129.3530f,      -31.6973f,       65.0658f,
    85.9795f,      -53.2356f,       57.2992f,      -67.2997f,      -16.4516f,
    54.7607f,      -37.1454f,      -42.4738f,      -34.5633f,      -75.7294f,
    0.0517f,       -0.6519f,       -1.3703f,      -12.9917f,     -148.9960f,
    -25.8564f,      -84.6818f,       59.5151f,      -72.5006f,     -156.8837f,
    95.5045f,       42.2665f,       60.9475f,      -54.5273f,     -154.2295f,
    44.2810f,      -53.2856f,      -76.4082f,       42.9736f,       -9.5286f,
    83.7851f,       46.2184f,        4.1979f,      -25.1575f,      -51.0520f,
    -43.1590f,     -111.8518f,       -2.3420f,     -129.5042f,        6.3083f,
    36.5568f,       37.9981f,       30.8304f,     -113.4959f,      -79.9345f,
    -1.8493f,      -15.3605f,       -7.7093f,       98.5986f,      -37.6177f,
    29.8557f,       67.8956f,       39.3578f,       63.5122f,       23.6349f,
    -27.0502f,      -93.1902f,      -21.6230f,      155.8476f,        2.5165f,
    -44.7515f,      124.6855f,       64.1401f,      107.4525f,       76.4296f,
    -5.6913f,       14.2025f,      -18.3757f,      129.1303f,       47.2448f,
    88.4045f,       81.8179f,      106.0131f,      126.8375f,       71.9790f,
    5.1288f,      -31.2676f,      -85.3474f,      183.8293f,      137.8851f,
    112.3553f,      147.7620f,        6.3634f,      -19.8307f,       97.9225f,
    68.1479f,       45.1480f,       20.4456f,       58.0360f,     -109.0384f,
    91.7441f,      107.7617f,       15.1212f,       47.0576f,      -18.7769f,
    0.0359f,      -42.2360f,      -42.2471f,       94.1364f,     -132.5071f,
    -36.3673f,      208.5491f,       17.4150f,       13.0281f,      -33.9693f,
    75.8679f,       58.1435f,      -27.7181f,      158.0312f,      -17.2012f,
    159.6027f,      144.6236f,       31.6370f,      -72.6323f,      -59.9622f,
    9.6094f,      -39.8213f,     -175.1189f,       48.5059f,      -67.6102f,
    8.4503f,      159.5329f,      -43.0075f,     -121.1605f,      -83.4178f,
    -10.0988f,        8.8687f,      -32.4219f,       44.4166f,        5.5756f,
    -42.8299f,       63.9306f,       20.2856f,       86.9213f,      -32.1874f,
    14.3835f,       -9.6605f,     -102.7732f,      119.7146f,       -5.8143f,
    -181.8677f,      162.2914f,      114.1354f,       64.3820f,       -7.2207f,
    11.2529f,       -7.2901f,      -66.7670f,       60.6365f,       71.2140f,
    69.9911f,       56.0744f,      -10.7183f,       90.0489f,      100.9538f,
    -40.2531f,      -96.6451f,     -154.5512f,       92.9078f,       43.9867f,
    146.6528f,      -60.2643f,      -42.7063f,       -1.4891f,       60.9280f,
    38.2143f,       33.0628f,     -113.9071f,       -1.8860f,      -48.5082f,
    45.4740f,       54.2829f,      -45.4768f,      -38.2865f,     -114.7585f,
    -5.4061f,      -32.4176f,     -108.6457f,      -45.8426f,     -147.6796f,
    41.4813f,       12.9066f,      -41.5456f,     -134.2382f,     -189.2112f,
    46.4330f,        6.8074f,     -160.9846f,       53.8969f,       64.9889f,
    149.8519f,       39.6080f,      -79.5860f,       34.3934f,      -61.0983f,
    -47.2568f,     -110.8652f,     -117.2089f,       -0.3717f,      -64.7306f,
    109.4393f,       12.8368f,      -59.4424f,     -122.1797f,      -31.4694f,
    -14.4126f,        8.5189f,       89.4622f,       59.7035f,       14.3509f,
    -23.3690f,      -32.3486f,       92.0827f,       -3.3169f,      -16.0022f,
    -66.1460f,      -89.0215f,       49.1022f,       -7.9295f,      141.6034f,
    -91.8393f,        6.6528f,      142.3305f,      -60.9383f,       61.1140f,
    -9.9035f,      -11.7998f,       27.9396f,       56.3528f,       60.7524f,
    59.7717f,      -10.3224f,      100.1088f,       37.9471f,       56.4210f,
    -8.0706f,      -14.3273f,       18.7969f,      -25.3479f,       97.6871f,
    24.5711f,       30.0075f,      106.4596f,      -49.8085f,       48.5911f,
    -50.4430f,      -10.2232f,       15.4334f,        3.6211f,      -45.0851f,
    -2.3100f,       32.1923f,       14.7250f,      -35.3260f,      -71.2667f,
    -131.2863f,       -5.1029f,       11.0382f,       61.7451f,       35.4884f,
    -11.6345f,       94.0117f,       53.4418f,      -66.3264f,       -6.6649f,
    57.0155f,        5.4850f,       -4.4053f,       12.7554f,       23.6955f,
    74.8564f,       77.0331f,       21.2315f,      -32.6182f,       33.2036f,
    9.1670f,      -78.1914f,      -30.2862f,      -11.1652f,       54.5347f,
    47.7388f,       92.4139f,       41.3020f,     -133.3741f,       53.0528f,
    -22.2909f,      -55.2830f,      -33.2798f,       -6.2896f,      -28.8257f,
    -23.1116f,      -35.0033f,       -3.2927f,      -72.9685f,       -7.7727f,
    -82.3073f,     -104.1028f,       84.5118f,      -69.8221f,      -43.1637f,
    -19.5349f,       -2.7976f,       85.8117f,     -104.2825f,      -27.2739f,
    -22.1902f,      -16.4648f,       -6.6730f,       -5.7920f,       27.7237f,
    12.5658f,        8.3566f,       24.7755f,      -53.6096f,       12.7618f,
    -53.5741f,      -68.1802f,       40.6279f,      -26.4454f,       38.0614f,
    -26.1757f,      -16.7503f,       52.0974f,     -117.6298f,       86.4284f,
    -45.3502f,      -78.0491f,      -31.6007f,      -35.9389f,     -106.1265f,
    -24.8954f,      -15.9989f,      -21.2401f,      -95.2454f,      -86.1251f,
    -112.2460f,      -94.4001f,      -19.4652f,      -33.9923f,      -34.6433f,
    -95.7000f,       92.3440f,       39.8654f,      -64.8912f,     -115.0483f,
    25.8969f,        9.4794f,      -63.2644f,      -27.6289f,       36.9308f,
    25.6901f,       52.9741f,      -35.3425f,      -86.0458f,      -14.2567f,
    -38.4101f,      -62.7105f,      -86.5748f,      -73.4519f,       11.4446f,
    -7.0262f,        6.9787f,       -7.4983f,     -161.9427f,        3.4520f,
    19.1677f,       23.8207f,       38.9733f,       15.3764f,      -21.7743f,
    -43.1688f,       31.9400f,       52.7685f,      -11.9674f,       20.1452f,
    -35.0128f,      -59.7929f,      -36.1783f,       73.7702f,       71.2205f,
    -83.5945f,      115.1128f,       46.5742f,      -28.7420f,      110.8292f,
    0.6347f,       53.5489f,       14.3686f,       18.4025f,       71.1819f,
    35.9728f,       45.7217f,       71.9726f,      -20.7319f,      145.8423f,
    -8.1019f,       -5.6290f,      -13.8278f,       53.1928f,      152.8343f,
    57.0881f,       50.3240f,      -64.1728f,      -11.0774f,      129.9089f,
    36.0925f,       31.0887f,      -32.6698f,       39.1693f,      -52.3060f,
    -3.1405f,       84.8560f,      -12.4226f,        1.0655f,      -18.3673f,
    -58.9719f,       98.0129f,      -83.8334f,       55.3139f,       35.7679f,
    -87.3652f,      121.2513f,      -67.0447f,     -107.5562f,       38.2622f,
    62.0513f,       60.4638f,      -69.1208f,       43.6854f,       20.7579f,
    79.9694f,       10.7071f,        3.2196f,      -93.6621f,       75.1450f,
    66.1122f,       46.9324f,     -124.5950f,      -78.3322f,       41.3915f,
    4.3229f,       13.8757f,      -33.6575f,      -92.7601f,      177.5551f,
    -42.5067f,      -60.2164f,      -63.5331f,       67.8862f,      -21.5990f,
    -14.9811f,       12.6046f,      -39.5598f,      -30.2755f,      -22.9980f,
    -80.2668f,     -125.5028f,      -37.7023f,       27.0213f,       31.0364f,
    -121.0989f,       17.0095f,        6.9604f,      -72.1639f,       13.2205f,
    -45.0105f,       -7.6587f,      -57.9626f,      -15.4159f,       79.2983f,
    -11.3128f,       60.2083f,      -11.6157f,      -61.5281f,       64.7932f,
    -17.6502f,      -51.3289f,     -123.9766f,       -9.4275f,      141.7024f,
    -64.4806f,      -80.0931f,      -43.9064f,      -86.7513f,      103.4672f,
    -12.6910f,      -17.1597f,      -58.5736f,       21.2452f,      -75.2569f,
    -2.3195f,      -14.7279f,      -99.6098f,      -65.8753f,      -44.8940f,
    -103.7556f,       33.9613f,      -73.7263f,      -13.9038f,      -66.1526f,
    -23.2670f,      -33.9743f,     -103.9167f,     -170.2949f,      -66.2644f,
    -26.4354f,      -31.7233f,     -108.7190f,        9.2282f,       14.7962f,
    -9.0340f,       -7.5327f,      -60.7032f,     -100.1385f,       55.1481f,
    -23.7530f,      -88.2969f,     -220.5980f,      -68.4569f,       27.6805f,
    3.3643f,      -11.1758f,      -92.5898f,     -201.1381f,      102.8789f
};

/*-------------------------------------------------------------------*
 * 2nd stage, 2nd split: ISF5 to ISF8
 *-------------------------------------------------------------------*/

const float dico22_isf_36b[] =
{
    -116.4826f,       -2.3267f,       37.0276f,       11.9585f,
    -83.2536f,      -34.0855f,      -47.5833f,      101.8900f,
    1.6666f,      -19.3089f,       81.2133f,        5.5915f,
    -50.2199f,      -43.0204f,       11.8773f,       45.9389f,
    -83.6736f,      100.7533f,       42.9626f,      -91.7069f,
    -15.8879f,       -6.8432f,      -49.2481f,       46.8567f,
    40.2748f,       25.3026f,       49.6150f,      -14.6042f,
    49.1020f,      -13.9172f,       -9.5624f,        9.9442f,
    -53.7549f,      -26.0755f,     -108.5515f,      -72.7670f,
    -64.1594f,      -75.7696f,      -78.4742f,       30.5700f,
    -82.2540f,      -34.1100f,      -20.0480f,      -86.1655f,
    -68.0474f,      -31.0203f,      -36.5615f,      -15.3976f,
    8.8102f,       -2.3252f,      -61.3614f,      -93.8460f,
    8.4465f,      -43.1451f,      -59.6402f,      -26.4485f,
    57.8873f,       -1.8283f,       -0.9150f,      -58.1355f,
    -0.3760f,      -52.6396f,      -15.1757f,      -69.7872f,
    26.6552f,      140.6710f,      -45.5320f,       -5.9904f,
    53.5205f,       18.1777f,     -108.7393f,       57.1700f,
    53.1281f,      101.4898f,       52.8254f,       25.2450f,
    23.9310f,       45.2712f,      -17.5932f,       37.8318f,
    90.1549f,      147.8806f,       33.8829f,      -46.8215f,
    132.2255f,       69.0079f,     -106.1068f,        1.3402f,
    103.9284f,       60.8167f,       10.9874f,      -26.8688f,
    101.6619f,       32.7808f,      -33.2101f,       33.7802f,
    -103.9522f,       60.0893f,     -100.1459f,      -71.1324f,
    -6.7456f,      -25.3835f,     -118.9063f,       -2.2439f,
    -15.7859f,       68.4583f,      -59.0835f,      -70.2552f,
    -10.4160f,       10.4323f,      -34.1781f,      -24.5999f,
    47.1747f,       44.4596f,      -64.8288f,     -183.2536f,
    62.0332f,      -25.7788f,     -126.3596f,      -90.0926f,
    83.7341f,       59.4975f,      -55.2472f,      -82.6595f,
    53.3482f,       14.1273f,      -71.7379f,      -20.0471f,
    -110.1113f,      -92.4130f,       15.5809f,        3.7302f,
    -18.8013f,      -91.7902f,      -14.6105f,       98.1369f,
    -21.2096f,     -126.2513f,       53.1438f,       11.3308f,
    -34.3197f,      -67.9178f,       83.0592f,       77.2733f,
    -152.4262f,       38.6895f,      -24.6967f,     -146.6594f,
    41.7355f,      -66.1454f,      -64.2312f,      165.7005f,
    27.0772f,      -43.2220f,       54.9943f,      -65.1872f,
    28.8899f,      -50.2606f,       25.5035f,       56.2652f,
    -137.7163f,      -80.7691f,      -80.0014f,      -42.7037f,
    -62.3651f,     -150.7820f,     -138.8149f,       38.1900f,
    -68.7802f,     -192.5785f,       -7.8749f,      -55.9578f,
    -98.5983f,     -168.6083f,       -0.7398f,       84.2329f,
    -35.1656f,      -67.9774f,      -65.6374f,     -160.6224f,
    4.9446f,     -110.8514f,      -89.3759f,      -62.4133f,
    -34.1288f,     -108.8451f,       13.3702f,      -98.1466f,
    -29.4614f,     -102.8405f,      -22.8325f,      -16.4528f,
    163.9105f,       20.5337f,      -82.4577f,     -139.6505f,
    149.8660f,      -13.6016f,     -146.1693f,      154.5116f,
    26.6673f,      -89.2330f,      126.1283f,       -0.6475f,
    65.0738f,     -119.9143f,       75.1351f,       75.9130f,
    179.3039f,      128.5647f,       -1.9070f,     -129.8349f,
    146.4228f,       30.7058f,       -2.7357f,      122.1955f,
    110.1199f,      -48.4108f,       78.0568f,      -35.8715f,
    105.8916f,      -63.1848f,      -27.3019f,       70.1234f,
    -61.4940f,     -116.2433f,     -200.7709f,     -120.8167f,
    22.5673f,      -63.6047f,     -213.1464f,        7.0661f,
    48.3577f,     -141.9964f,       65.3628f,      -93.1012f,
    32.5991f,     -160.4748f,      -45.5903f,       37.6377f,
    54.6730f,      -43.7561f,     -151.6335f,     -243.7797f,
    101.1397f,      -52.0073f,     -123.8756f,       16.0909f,
    63.7439f,      -50.8957f,      -25.0308f,     -130.5887f,
    88.2969f,      -64.3814f,      -48.5324f,      -43.0123f,
    -181.9705f,      -24.0096f,        2.3863f,       89.5185f,
    -59.5915f,       80.1714f,      -56.6992f,       94.5562f,
    -62.1659f,       18.9433f,       76.0160f,       57.8553f,
    -22.4665f,       10.7743f,       12.0918f,      108.9830f,
    -118.1671f,       72.3971f,      109.1443f,       -1.3839f,
    -23.8459f,       76.9232f,       22.9444f,       33.4435f,
    -44.5975f,       47.9554f,       65.6020f,      -20.3018f,
    13.6440f,       14.2271f,       38.9794f,       49.0774f,
    -159.0490f,       40.0263f,      -30.2347f,      -15.6526f,
    -132.0447f,       -0.4802f,     -133.5965f,       61.0673f,
    -69.7882f,       40.8409f,      -13.3128f,      -38.0654f,
    -72.3667f,       32.7089f,      -13.7936f,       42.2054f,
    -51.7645f,       41.9187f,      -35.3954f,     -139.3463f,
    -70.4106f,       21.2248f,      -89.5260f,        9.2659f,
    -17.3511f,       18.5094f,       18.3073f,      -71.0465f,
    -25.6477f,        4.9120f,       17.7504f,        1.3904f,
    -132.5788f,       97.9003f,       25.0501f,       88.4524f,
    -16.3421f,       39.3618f,     -136.5657f,      107.5423f,
    -38.7664f,      155.3425f,       55.5880f,       47.1198f,
    43.2628f,        4.6910f,      -39.9914f,      101.5498f,
    0.0830f,      197.2389f,      101.6377f,      -36.9070f,
    62.8279f,      111.5018f,      -37.6259f,       87.5036f,
    -1.4618f,       80.2742f,      122.5196f,       12.8147f,
    65.1409f,       54.2334f,       34.3093f,       79.7332f,
    -91.6271f,      123.5048f,      -23.6092f,       -9.5877f,
    -3.2208f,      -58.6010f,     -121.8443f,       78.4266f,
    -14.0112f,      114.0430f,       23.9902f,      -40.4777f,
    -15.4729f,       68.1635f,      -63.4068f,       16.5519f,
    -8.1780f,      157.1093f,      -11.2800f,     -137.0649f,
    8.0606f,       59.4657f,     -140.5838f,      -36.3320f,
    22.2676f,       74.5499f,       82.8755f,      -76.6792f,
    29.5054f,       61.7793f,       -8.0867f,      -27.0956f,
    -128.1797f,      -72.1649f,      129.2723f,       46.4323f,
    -20.7709f,      111.3353f,       22.0263f,      131.4695f,
    -41.9162f,       -9.2182f,      158.1064f,       11.2798f,
    -7.1545f,       53.6140f,      106.2812f,      108.0610f,
    -99.5471f,        8.6443f,       67.7713f,      -74.7187f,
    115.0857f,      125.6656f,      126.8208f,      118.1528f,
    8.3489f,      -10.6246f,      129.8214f,      -69.4937f,
    46.4587f,        5.2711f,      105.7244f,       50.4485f,
    -177.6754f,      -70.1548f,       45.4547f,      -74.5236f,
    -88.7724f,       24.0424f,      -57.8465f,      204.7888f,
    -68.8890f,     -112.1224f,      110.3182f,      -61.1447f,
    -94.7905f,        5.0186f,       77.6790f,      167.9779f,
    -23.0125f,      -19.1513f,       44.8958f,     -142.4394f,
    28.0225f,      -67.2659f,      -53.6584f,       36.2990f,
    -54.0239f,      -49.3550f,       55.1522f,      -32.8946f,
    2.0792f,      -48.4861f,       14.9542f,       -7.9957f,
    -100.8337f,      121.3744f,      234.8044f,       83.3187f,
    36.5393f,       50.8425f,      -23.7400f,      196.1698f,
    -0.3059f,      -61.1762f,      189.5078f,      122.4017f,
    57.0232f,      -28.8934f,       61.7134f,      134.6930f,
    107.9555f,       52.8736f,      109.5032f,      -22.1311f,
    191.2912f,       98.4213f,       38.7853f,       16.9729f,
    104.1509f,      -28.9315f,      167.6925f,       40.9011f,
    108.7356f,       -8.7976f,       46.5837f,       36.6080f,
    -211.7768f,      190.5028f,      100.4753f,      -45.0833f,
    -32.7791f,      -95.3684f,     -171.2339f,      186.7766f,
    -44.0395f,     -212.9286f,      151.2602f,       39.5958f,
    -37.2152f,     -119.5092f,       43.4460f,      194.5965f,
    37.2023f,       64.8673f,        8.5289f,     -117.5366f,
    163.8890f,       -5.9760f,      -22.5312f,      -30.3817f,
    105.4272f,       11.3735f,       47.6228f,     -110.1422f,
    62.3479f,      -93.6059f,       19.4353f,      -14.9112f
};

/*-------------------------------------------------------------------*
 * 2nd stage, 3rd split: ISF9 to ISF15
 *-------------------------------------------------------------------*/

const float dico23_isf_36b[] =
{
    31.6601f,       -7.0021f,       26.7324f,      -10.6919f,      -47.7440f,     -109.3316f,       -1.6793f,
    17.6152f,      -69.1639f,       81.7745f,      -11.6557f,      -53.0002f,      -28.8501f,       51.3155f,
    -17.3392f,       39.6296f,      -29.4208f,      -34.2716f,      -18.7475f,      -53.4279f,      -21.0682f,
    -95.6211f,      -11.0108f,       24.5639f,       -6.9345f,      -43.8606f,      -40.3930f,       22.5841f,
    -30.9469f,       -2.2484f,       85.8968f,      -25.2118f,       44.4649f,      -13.7549f,      -19.6283f,
    42.5807f,      -25.3893f,       55.9790f,      -44.6039f,       50.3451f,       29.5180f,       49.0040f,
    64.7422f,       35.0105f,      -24.0120f,      -94.6131f,       72.4785f,      -29.0560f,      -16.8213f,
    -17.7762f,      -36.1097f,       19.1423f,      -88.8131f,        9.4121f,      -60.6212f,       15.2182f,
    26.1194f,       33.0214f,       38.6243f,      -16.4898f,       20.5108f,      -71.7754f,     -109.7775f,
    55.6133f,      -47.5797f,        0.0746f,        8.1716f,      -55.6639f,       -5.8260f,       -6.7666f,
    86.9148f,       36.0665f,       -8.0422f,      -18.6522f,      -31.9936f,       -5.4779f,      -65.2340f,
    20.0656f,      -14.5303f,      -94.7449f,      -11.7982f,      -35.2031f,        6.9138f,      -22.0461f,
    20.9060f,       41.0458f,       29.0299f,       33.4933f,       27.0675f,        5.1646f,      -39.4529f,
    76.7175f,       28.2216f,      -34.8562f,       16.7304f,       25.2291f,        7.4912f,       15.3906f,
    47.1053f,       13.3625f,       50.9902f,      -31.9588f,        9.8596f,       83.1329f,      -61.0081f,
    39.4355f,      -39.6936f,      -53.1235f,       -8.1282f,       22.3882f,       83.7131f,        8.6440f,
    13.9302f,      -48.4179f,       80.1925f,       79.6573f,       22.8321f,      -61.0888f,      -32.5848f,
    32.2601f,      -45.5857f,       53.4300f,       53.4773f,       33.0895f,       45.4420f,       17.2865f,
    -36.0406f,      -57.6566f,      -26.6841f,        4.2674f,      -39.8452f,      -76.9236f,      -85.9930f,
    -29.8696f,      -72.1261f,      -22.6802f,       51.6689f,      -10.3407f,      -71.6716f,       33.3209f,
    -2.6190f,      -11.9459f,       -0.7138f,        9.1651f,       80.0695f,      -58.7987f,        3.7833f,
    -10.6521f,      -14.2910f,       -1.7854f,       -6.9002f,      114.1547f,       51.0851f,        0.4936f,
    45.5988f,      -65.6262f,        3.5076f,      -36.3037f,       31.3412f,      -22.8916f,      -48.6823f,
    -71.1623f,      -95.4642f,       38.3287f,       -9.4939f,       52.9002f,       -8.4421f,       36.7283f,
    86.2675f,       37.9505f,       41.2317f,       16.4269f,       16.7260f,      -62.6682f,       32.6168f,
    9.9181f,      -25.0994f,       -8.3770f,        2.2985f,        5.3157f,       -6.0428f,       60.1555f,
    49.0247f,        6.0545f,      -54.7919f,       58.6261f,       -3.9732f,      -80.9565f,      -44.3777f,
    30.6734f,      -24.5101f,      -82.4513f,      -27.4901f,      -10.8146f,      -84.7650f,       64.6334f,
    18.0553f,       14.7350f,       -8.7675f,      109.6707f,       51.4393f,      -24.1075f,       42.7732f,
    43.6601f,       21.1278f,      -43.7223f,      -36.3814f,       81.3688f,       10.3561f,      115.5857f,
    44.7304f,        4.0203f,      -57.4008f,       16.1462f,       84.4927f,       16.5958f,     -107.7931f,
    19.3887f,      -44.8683f,      -99.3061f,       65.1051f,       45.6203f,       -0.6984f,       23.6828f,
    6.4828f,       56.2769f,       13.3073f,      -28.0424f,      -72.7066f,      -58.5212f,      106.1769f,
    -11.1674f,      -25.7849f,      -34.9574f,      -36.9812f,      -58.1843f,       50.2182f,       98.0044f,
    47.6759f,        0.1786f,      -19.4605f,      -91.2611f,      -35.5267f,       13.8815f,       10.2127f,
    -41.1350f,      -39.8329f,      -34.1829f,      -47.4437f,      -91.9939f,       -2.6788f,       -4.2821f,
    -79.6033f,       42.6213f,        2.0653f,      -74.4526f,       41.0602f,       -5.7905f,       63.6539f,
    -31.4071f,       12.4383f,       -9.2647f,      -81.5461f,       16.0430f,      114.6936f,       27.3863f,
    -41.2719f,      -36.6253f,      -79.4997f,      -46.2467f,       46.8034f,      -19.4146f,      -14.6126f,
    -31.9554f,      -93.9975f,       17.8233f,      -51.0152f,      -11.4389f,       58.4455f,      -21.6241f,
    12.9670f,       60.7166f,       46.9564f,      -34.6928f,       -3.1553f,        2.7762f,       24.2978f,
    83.1108f,       31.8670f,       23.6533f,        6.8663f,      -63.0785f,       56.1031f,       59.2073f,
    11.6877f,       51.3190f,       25.3083f,      -33.9761f,      -99.5482f,       -6.6294f,      -41.7488f,
    -3.1041f,       33.3329f,      -24.8851f,       20.0947f,      -63.3399f,       87.2565f,      -20.6208f,
    -52.2549f,      102.0059f,       26.9280f,      -22.0208f,       85.2782f,       28.3108f,      -43.2782f,
    0.8584f,       60.5987f,      -44.2357f,      -33.9700f,       19.1247f,       33.1631f,      -10.8275f,
    -63.5371f,       16.2471f,       -0.2828f,      -76.6458f,        2.8322f,       15.2373f,      -95.8412f,
    5.5912f,      -53.4989f,      -30.8518f,        4.1365f,      -62.3116f,       79.0018f,     -114.5611f,
    -36.8596f,       12.7812f,       81.1609f,       39.2434f,       21.9162f,      -17.2064f,      127.1804f,
    -30.4279f,      -15.8549f,       90.5057f,        4.9324f,      -55.6202f,       88.7264f,       31.2457f,
    -6.4338f,      -33.9992f,       78.4675f,       12.7460f,      -51.8920f,        5.7002f,      -71.3454f,
    -22.6305f,      -75.0886f,      -18.4430f,       71.6854f,      -49.9613f,       51.9112f,       38.5919f,
    -80.1990f,        4.2373f,      -60.6613f,       30.4453f,       20.4006f,       28.0162f,       55.1546f,
    -96.2887f,       10.3433f,       38.5883f,       59.1444f,       23.2247f,       45.0000f,      -24.9305f,
    -30.9055f,      -18.2692f,       -6.1201f,       -5.6460f,        2.1550f,       18.2502f,      -16.8166f,
    -28.0966f,      -69.3654f,      -10.5762f,       63.4193f,       43.8444f,       16.6643f,      -67.9380f,
    -68.3269f,       93.1501f,       72.8030f,       27.6125f,      -21.1484f,      -73.4926f,      -29.7929f,
    -88.0045f,       91.0304f,       15.1885f,      -15.1144f,      -61.6391f,       47.5526f,       17.2017f,
    -10.0973f,       16.8435f,       32.7608f,       50.6231f,      -36.3173f,      -19.8196f,        8.7833f,
    1.1920f,       35.7643f,      -58.4480f,       53.1925f,      -71.1458f,      -22.3426f,       37.8118f,
    -51.2779f,       69.9477f,      -30.3236f,       31.2621f,       35.5419f,      -64.6025f,       35.1224f,
    -0.6572f,       57.9364f,        5.6749f,       50.6782f,       25.3456f,       68.4492f,       45.6955f,
    -53.8176f,       44.6419f,      -53.4407f,       51.5645f,        1.3456f,       -4.0462f,      -72.5604f,
    54.6610f,       -1.6150f,      -14.3009f,       99.1775f,      -24.2467f,       36.0557f,      -42.7052f
};

/*-------------------------------------------------------------------*
 * AMR-WB ISF codebook for SID - 28bits, 1 stage, 5 splits
 *
 *  codebook   vector dimension    number of vectors
 *  ~~~~~~~~   ~~~~~~~~~~~~~~~~    ~~~~~~~~~~~~~~~~~
 *     1            2                  64
 *     2            3                  64
 *     3            3                  64
 *     4            4                  32
 *     5            4                  32
 *-------------------------------------------------------------------*/

/*-------------------------------------------------------------------*
 * 1st stage, 1st split: ISF0 to ISF1
 *-------------------------------------------------------------------*/

const float dico1_ns_28b[64*2] =
{
    -105.0619f,     -262.8448f,
    -86.6322f,     -209.7320f,
    -91.1931f,     -168.0481f,
    -53.8753f,     -176.1473f,
    -82.7923f,     -129.2635f,
    -75.0845f,      -93.9859f,
    -33.9476f,      -90.3333f,
    -74.4463f,      -50.0451f,
    -27.3422f,      -41.3458f,
    -64.0658f,       -2.5361f,
    28.8179f,      -70.0786f,
    10.5059f,      -12.8463f,
    -39.9581f,       28.7359f,
    -63.4034f,       44.7503f,
    -36.8732f,       67.0368f,
    -2.3563f,       50.6058f,
    -55.9412f,       91.2822f,
    5.5577f,       85.1171f,
    -25.2586f,      105.6009f,
    34.3216f,       71.1726f,
    -48.3043f,      133.1605f,
    -17.0366f,      148.8321f,
    14.8305f,      130.6908f,
    45.5592f,      106.8464f,
    -43.7865f,      177.4889f,
    28.9675f,      168.2081f,
    -1.7812f,      190.4731f,
    68.4806f,      149.8876f,
    -32.5396f,      218.9960f,
    47.8438f,      206.6539f,
    8.1960f,      234.8430f,
    89.3668f,      188.0221f,
    90.4035f,      118.3064f,
    88.4263f,      237.5410f,
    117.3136f,      145.4498f,
    82.0645f,       73.1093f,
    119.3943f,      103.4796f,
    128.2321f,      184.8528f,
    149.1563f,      129.2199f,
    144.9058f,       51.5776f,
    54.4305f,       22.6608f,
    142.5451f,        8.2812f,
    97.4966f,      -31.8767f,
    173.0963f,       84.9898f,
    188.5170f,       42.9719f,
    166.5772f,      162.2136f,
    226.1740f,       86.5496f,
    202.2992f,      129.9512f,
    223.9365f,      175.1483f,
    177.6235f,      206.6174f,
    267.4435f,      128.4469f,
    129.8694f,      226.5438f,
    232.5047f,      231.7147f,
    182.8960f,      252.1132f,
    297.7026f,      201.9668f,
    127.2108f,      277.0716f,
    189.5906f,      309.6084f,
    50.8926f,      267.2207f,
    262.1367f,      287.8791f,
    138.4480f,      342.2196f,
    34.3804f,      314.8025f,
    -25.4771f,      275.9066f,
    -13.5804f,      397.0122f,
    103.9035f,      438.8237f
};

/*-------------------------------------------------------------------*
 * 1st stage, 2ndt split: ISF2 to ISF4
 *-------------------------------------------------------------------*/

const float dico2_ns_28b[64*3] =
{
    -322.0252f,     -345.3659f,     -370.7835f,
    -314.5226f,     -178.1928f,     -163.4712f,
    -172.6074f,     -171.2812f,     -211.3224f,
    -84.6538f,     -225.6710f,     -309.6982f,
    -65.7865f,     -173.3148f,     -227.1618f,
    -112.2154f,     -192.0593f,     -106.9376f,
    -215.4487f,     -115.9810f,     -117.3159f,
    -63.6069f,     -129.9179f,     -139.6890f,
    -144.6460f,      -90.4563f,      -90.4457f,
    -68.4568f,     -140.0307f,      -62.0772f,
    -148.8729f,       -8.2807f,     -139.6018f,
    -71.8488f,      -61.9658f,      -63.2677f,
    -20.5518f,      -74.4279f,     -109.2530f,
    7.0237f,     -104.2936f,      -83.9866f,
    -53.7369f,       23.9918f,     -110.5212f,
    27.5927f,      -37.1603f,     -114.8537f,
    5.1437f,      -60.8316f,     -213.2375f,
    -0.0302f,      -32.5161f,      -30.9893f,
    17.0532f,       37.8947f,     -123.4512f,
    69.4656f,      -20.4364f,      -83.2673f,
    86.8486f,     -101.9140f,     -164.6497f,
    92.7595f,      -46.0582f,      -17.0665f,
    55.0807f,       56.5797f,      -51.6089f,
    141.9268f,       31.5952f,     -111.9348f,
    83.1350f,       25.3995f,       13.2634f,
    -41.6305f,       36.7624f,       -1.8806f,
    35.5619f,      -11.1360f,       49.0468f,
    -138.6944f,       20.1165f,      -16.0470f,
    -85.7227f,      -29.5173f,       56.5419f,
    -24.5306f,       39.2035f,       95.3233f,
    -280.8913f,       17.3520f,       10.4723f,
    -223.4287f,      -48.5814f,       60.3781f,
    -165.0790f,       52.0898f,      122.9863f,
    -358.1462f,       27.5800f,       87.6394f,
    -104.6460f,      124.2969f,       51.2676f,
    -36.4609f,      -74.1586f,      163.9110f,
    -38.0255f,       47.6372f,      191.7725f,
    -30.7896f,      123.7246f,      138.8302f,
    50.7064f,       39.0454f,      126.9589f,
    33.4334f,     -114.5499f,       82.0810f,
    52.0289f,      100.6551f,       62.9260f,
    68.9398f,      -28.6776f,      181.7511f,
    76.3353f,      117.0400f,      150.0834f,
    135.9951f,        8.5581f,       86.5077f,
    146.9219f,       71.3024f,      159.6375f,
    147.3144f,      111.7858f,       78.8838f,
    94.6612f,       83.2958f,      257.4856f,
    100.5727f,      220.5308f,       96.9196f,
    134.4751f,      159.3021f,      -29.6067f,
    158.3509f,      171.9108f,      198.9399f,
    238.9283f,      150.3837f,      148.0492f,
    209.2346f,      237.2747f,       84.4977f,
    -21.9723f,      227.3437f,       75.1847f,
    39.1823f,      202.0239f,      221.5619f,
    -142.6753f,      174.8218f,      173.9311f,
    284.1931f,      135.5243f,        4.0420f,
    197.3545f,      139.2970f,      296.6173f,
    248.5921f,      227.1523f,      257.1579f,
    130.8344f,      201.7665f,      332.6679f,
    147.8451f,      316.0691f,      223.3704f,
    -76.1983f,      342.8470f,      323.9619f,
    206.5931f,      276.1481f,      385.6192f,
    358.4664f,      283.4258f,      153.2502f,
    488.2212f,      389.4155f,      415.1465f
};

/*-------------------------------------------------------------------*
 * 1st stage, 3rd split: ISF5 to ISF7
 *-------------------------------------------------------------------*/

const float dico3_ns_28b[64*3] =
{
    -314.4522f,     -327.3454f,     -302.2017f,
    -203.9117f,     -244.9068f,     -323.6309f,
    -186.2536f,     -189.6962f,     -235.4297f,
    -115.3995f,     -187.7246f,     -247.4612f,
    -142.8871f,     -150.1942f,     -153.3509f,
    -72.7072f,     -161.6552f,     -154.8560f,
    -92.6058f,     -153.8863f,      -41.3953f,
    -98.5994f,      -78.7129f,     -107.5332f,
    -23.9335f,      -69.1898f,     -172.7805f,
    -32.7960f,      -77.3107f,      -77.6193f,
    -69.7610f,      -48.7327f,      -12.2728f,
    -28.2008f,      -18.3660f,      -63.7045f,
    -116.3960f,      -85.9584f,       84.0164f,
    -24.9241f,      -65.7832f,       98.1712f,
    -51.8131f,       60.9599f,      -23.0835f,
    -11.5386f,       -0.7831f,       49.5084f,
    20.9367f,       25.8838f,      -24.0191f,
    -91.0503f,        8.0161f,       98.1430f,
    81.8089f,      -19.4694f,       12.5661f,
    12.6976f,       75.6776f,       53.0320f,
    -45.8943f,       -7.2062f,      185.7293f,
    78.8625f,       17.9396f,      120.6767f,
    99.9111f,       72.2135f,       20.5674f,
    13.7143f,       77.9979f,      152.4088f,
    78.0738f,      102.8484f,       94.6295f,
    -84.5040f,      118.1050f,      114.7064f,
    50.0596f,      139.6647f,       -0.1577f,
    7.5966f,      168.3675f,      112.1363f,
    87.3316f,      174.4695f,      109.2434f,
    143.4298f,       64.6162f,       83.1959f,
    155.2307f,      122.7478f,      124.7551f,
    149.4719f,      147.9446f,       29.2261f,
    108.3426f,      127.0695f,      180.3353f,
    153.8867f,      197.0929f,      130.5922f,
    98.1956f,       38.2729f,      -83.1688f,
    175.9048f,       59.9165f,      174.8273f,
    220.7233f,       88.4354f,       29.6527f,
    183.5505f,      149.7702f,      195.9197f,
    248.2375f,      152.2900f,      108.7161f,
    92.6034f,       52.6123f,      242.1773f,
    133.7155f,      156.6441f,      253.6524f,
    129.4868f,      215.2826f,      202.4702f,
    50.8526f,      163.2149f,      231.3041f,
    207.4225f,      119.3517f,      287.7008f,
    284.9414f,      152.0429f,      226.6699f,
    194.1092f,      217.5607f,      272.9373f,
    115.7381f,      149.7147f,      341.2299f,
    110.4872f,      243.8135f,      296.4818f,
    49.2583f,      242.9759f,      185.7527f,
    218.4281f,      232.2570f,      184.3956f,
    149.3219f,      300.8763f,      240.4531f,
    280.7402f,      239.3506f,      291.1599f,
    210.7589f,      249.5308f,      362.4219f,
    201.8519f,      322.7530f,      312.7221f,
    267.0336f,      316.7373f,      236.0985f,
    293.8933f,      307.2101f,      334.8007f,
    364.5740f,      258.0872f,      136.8430f,
    271.0491f,      175.6599f,      414.3537f,
    219.3663f,      355.8581f,      410.6574f,
    321.8781f,      317.4617f,      431.4073f,
    295.9753f,      408.9221f,      344.4007f,
    445.2552f,      358.3636f,      347.1212f,
    405.7584f,      486.9081f,      556.9660f,
    579.1823f,      650.5953f,      732.6415f
};

/*-------------------------------------------------------------------*
 * 1st stage, 4th split: ISF8 to ISF11
 *-------------------------------------------------------------------*/

const float dico4_ns_28b[32*4] =
{
    -303.1361f,     -333.7803f,     -347.8725f,     -359.4826f,
    -215.7523f,     -238.3714f,     -259.0660f,     -289.4405f,
    -125.2913f,     -144.5697f,     -186.1030f,     -220.5702f,
    107.0201f,      -62.5400f,     -178.2959f,       78.3558f,
    103.6377f,       26.1626f,      -62.5396f,     -119.5691f,
    -2.9518f,      -82.1288f,       30.9020f,      106.1641f,
    63.5315f,       92.0127f,      120.0751f,      120.2205f,
    225.8191f,      123.6829f,       24.8449f,      116.4136f,
    -3.5121f,       76.7992f,      133.5771f,      242.3746f,
    133.9970f,       90.5385f,      122.6116f,      242.8362f,
    67.7067f,       58.1366f,      214.2467f,      205.7587f,
    139.2159f,      144.6370f,      188.0780f,      146.8699f,
    52.7259f,      173.3530f,      190.5093f,      217.0651f,
    152.5843f,      183.9790f,      190.4016f,      255.0127f,
    89.0815f,      165.5783f,      224.8295f,      325.9805f,
    164.7109f,      145.4724f,      282.2096f,      266.3416f,
    115.0926f,      262.9259f,      270.8098f,      248.1893f,
    210.4561f,      232.8534f,      230.5395f,      175.4710f,
    185.5563f,      241.3006f,      257.2568f,      319.6433f,
    287.0131f,      201.7823f,      191.6938f,      262.7153f,
    234.9706f,      135.0743f,      100.3842f,      342.4814f,
    244.1460f,      248.1535f,      331.5106f,      281.3059f,
    283.8415f,      319.6996f,      272.8347f,      232.3501f,
    255.2254f,      187.9562f,      269.5668f,      445.0594f,
    318.1439f,      297.7580f,      274.9042f,      354.5264f,
    198.0688f,      291.9682f,      350.7645f,      365.4872f,
    331.2469f,      333.9341f,      361.1275f,      306.5865f,
    252.3140f,      405.2271f,      344.4444f,      310.3618f,
    301.5996f,      329.9839f,      399.8752f,      449.5998f,
    442.5639f,      384.1796f,      319.3500f,      359.8945f,
    367.3365f,      417.2813f,      488.9795f,      508.7549f,
    620.4818f,      690.0919f,      671.0975f,      590.9387f
};

/*-------------------------------------------------------------------*
 * 1st stage, 5th split: ISF12 to ISF15
 *-------------------------------------------------------------------*/

const float dico5_ns_28b[32*4] =
{
    -316.2941f,     -343.3920f,     -368.9643f,      -99.0392f,
    97.0450f,       71.7080f,      262.1754f,       50.0767f,
    112.4468f,      274.7287f,      358.7211f,       38.6232f,
    257.1795f,      217.8952f,      258.6022f,       85.4104f,
    215.6079f,      228.7031f,      355.6118f,       81.4276f,
    218.4167f,      314.1638f,      296.3636f,       46.5526f,
    236.5851f,      302.2603f,      359.7074f,      -54.3647f,
    305.5962f,      297.4161f,      292.2765f,       81.3061f,
    295.4005f,      276.4861f,      384.1555f,       21.9038f,
    212.3865f,      337.6641f,      394.4713f,       59.4888f,
    287.8841f,      272.8244f,      385.4754f,      116.6899f,
    301.1416f,      360.9641f,      343.2708f,       40.2882f,
    209.5407f,      306.5670f,      375.3650f,      158.1632f,
    260.4655f,      357.6203f,      312.8495f,      128.1323f,
    288.3843f,      275.2455f,      301.9735f,      171.2988f,
    321.4736f,      340.3829f,      387.3967f,      138.5811f,
    250.1021f,      392.3276f,      410.9932f,      144.0109f,
    282.6727f,      320.9480f,      370.8150f,      233.3823f,
    161.9622f,      255.8086f,      284.8333f,      188.2323f,
    393.9827f,      349.8717f,      309.8297f,      141.6719f,
    354.6675f,      313.7792f,      268.4562f,       -9.8681f,
    396.7580f,      327.4283f,      395.0635f,       73.8789f,
    369.8889f,      434.5653f,      367.9579f,       86.8706f,
    356.9169f,      409.7761f,      383.1727f,      205.7493f,
    373.4236f,      385.5478f,      394.8253f,      -47.0644f,
    305.1456f,      409.5952f,      437.7072f,       36.1164f,
    460.1152f,      411.4012f,      345.2657f,       18.4203f,
    438.6750f,      413.5906f,      461.8582f,       46.2207f,
    364.6111f,      379.8415f,      498.6693f,      139.3899f,
    433.1401f,      358.6805f,      429.9292f,      196.6537f,
    405.9484f,      502.2995f,      476.5874f,      123.6977f,
    527.5430f,      471.6736f,      394.4862f,      127.2615f
};


const float *lsf_means[2] = { means_wb_31bits_ma_lsf, means_nb_31bits_ma_lsf };

const lsp_unw_triplet p16_gamma0_92to1[16] =
{
    {  0.00000f,  1.19764f, -0.59173f },
    { -0.91173f,  1.79182f, -0.80921f },
    { -0.51779f,  1.44703f, -0.81871f },
    { -0.44862f,  1.36777f, -0.75103f },
    { -0.45150f,  1.30719f, -0.74220f },
    { -0.43157f,  1.21326f, -0.68538f },
    { -0.43606f,  1.21317f, -0.69131f },
    { -0.39200f,  1.04941f, -0.58674f },
    { -0.45208f,  1.10009f, -0.59175f },
    { -0.42553f,  0.99725f, -0.49992f },
    { -0.50168f,  1.07575f, -0.51401f },
    { -0.49800f,  1.06563f, -0.50592f },
    { -0.53101f,  1.16372f, -0.58033f },
    { -0.48744f,  1.07596f, -0.52531f },
    { -0.51899f,  1.04998f, -0.49495f },
    { -0.47730f,  0.90959f,  0.00000f }
};

const lsp_unw_triplet p16_gamma0_94to1[16] =
{
    {  0.00000f,  0.78925f, -0.38537f },
    { -0.57154f,  1.19486f, -0.54136f },
    { -0.33642f,  0.99096f, -0.56792f },
    { -0.29856f,  0.93785f, -0.51255f },
    { -0.29716f,  0.89303f, -0.50509f },
    { -0.28264f,  0.81530f, -0.46020f },
    { -0.27926f,  0.80997f, -0.46378f },
    { -0.25334f,  0.69596f, -0.38969f },
    { -0.29656f,  0.72916f, -0.38888f },
    { -0.27488f,  0.65949f, -0.32999f },
    { -0.32630f,  0.70913f, -0.33659f },
    { -0.33069f,  0.70668f, -0.33105f },
    { -0.35437f,  0.77582f, -0.38003f },
    { -0.31771f,  0.70752f, -0.34216f },
    { -0.35066f,  0.70177f, -0.31664f },
    { -0.33404f,  0.62528f,  0.00000f }
};

const float dico_lsf_abs_8b[256*M] =
{
    377.3749f,     688.0079f,    1147.3799f,    1461.0438f,    1786.7794f,    2143.6711f,    2522.1946f,    2889.7402f,    3263.6023f,    3628.4624f,    4005.4351f,    4379.4170f,    4783.9556f,    5157.1753f,    5555.1797f,    5926.6816f,
    601.5123f,    1066.8242f,    1384.3585f,    1652.9448f,    1978.3910f,    2311.2676f,    2674.0537f,    3010.3896f,    3360.0623f,    3725.9336f,    4093.3335f,    4470.6431f,    4859.1006f,    5210.4717f,    5598.3716f,    5954.4204f,
    552.5036f,     859.7047f,    1355.2023f,    1624.9041f,    1887.5609f,    2173.1638f,    2540.7429f,    2926.8169f,    3323.2173f,    3680.7197f,    4008.3447f,    4330.8442f,    4692.8228f,    5033.9697f,    5443.3467f,    5875.4497f,
    459.4534f,     793.3189f,    1293.7278f,    1617.3970f,    1920.0642f,    2192.2153f,    2487.5627f,    2772.1514f,    3111.3823f,    3461.2671f,    3867.0176f,    4279.8550f,    4741.0664f,    5141.0181f,    5552.8237f,    5933.6934f,
    327.9834f,     430.4954f,     723.9031f,    1528.6172f,    1763.1125f,    2013.7936f,    2334.2153f,    2569.0334f,    3017.9436f,    3308.0610f,    3591.7820f,    3865.5430f,    4693.5786f,    5286.7646f,    5647.7036f,    5987.2305f,
    455.0753f,     606.0817f,     963.7564f,    1374.9937f,    1536.4897f,    1914.7618f,    2376.9631f,    2580.8184f,    2989.1501f,    3258.8386f,    3485.1460f,    3741.1270f,    4297.4912f,    5207.3779f,    5672.3818f,    5980.5322f,
    434.9507f,     558.8508f,     890.7061f,    1355.7625f,    1552.6155f,    1895.7960f,    2222.5579f,    2502.6079f,    2841.8738f,    3137.5264f,    3367.7336f,    3860.7769f,    4795.2554f,    5090.9370f,    5421.8218f,    5874.4287f,
    281.0164f,     404.5417f,     729.2898f,     997.1851f,    1699.8862f,    1961.3673f,    2255.7202f,    2540.9187f,    2804.4553f,    3057.1843f,    3750.2288f,    4340.9893f,    4716.8647f,    5002.7471f,    5477.2998f,    5965.7402f,
    372.2410f,     505.3570f,     762.3755f,     997.3586f,    1174.4255f,    1986.1741f,    2368.1367f,    2624.1733f,    3194.6084f,    3403.2793f,    3877.7622f,    4425.7676f,    4824.7837f,    5158.1606f,    5532.7466f,    5893.5483f,
    367.3766f,     501.1806f,     824.5358f,    1090.6857f,    1271.9792f,    1527.7137f,    2381.4382f,    2694.4634f,    2964.5359f,    3639.4832f,    3946.4038f,    4254.3916f,    4645.8076f,    5033.5396f,    5373.8735f,    5878.4385f,
    229.4505f,     352.5671f,     701.0831f,    1226.4518f,    1678.3601f,    1895.7949f,    2140.0664f,    2526.5515f,    3080.3391f,    3297.8284f,    3845.3987f,    4427.9785f,    4704.4551f,    4997.4155f,    5434.0698f,    5918.4785f,
    336.3082f,     516.7915f,     881.9847f,    1272.5824f,    1505.1870f,    1880.7520f,    2274.9458f,    2611.0083f,    3126.5256f,    3655.5332f,    4183.3877f,    4668.2993f,    5004.0029f,    5305.3491f,    5650.4985f,    5943.7383f,
    296.0867f,     469.6519f,     956.5997f,    1224.1262f,    1443.0049f,    1727.6880f,    2216.1677f,    2689.3677f,    3060.4456f,    3520.9438f,    3916.6050f,    4343.7954f,    4763.8906f,    5156.0132f,    5553.8115f,    5936.9634f,
    407.1503f,     577.5120f,     839.7361f,    1455.3907f,    1665.2137f,    1935.0054f,    2398.0537f,    2652.2605f,    3111.1831f,    3505.5962f,    3766.7554f,    4204.8730f,    4699.1631f,    4970.8652f,    5295.5962f,    5695.6919f,
    281.0083f,     361.8386f,     950.9102f,    1464.1158f,    1634.7019f,    1965.4950f,    2211.1406f,    2662.1055f,    2846.0122f,    3585.8884f,    4048.7148f,    4358.9150f,    4683.8755f,    5046.0908f,    5400.0859f,    5956.1040f,
    279.1811f,     393.9142f,     876.8306f,    1502.2417f,    1673.0590f,    2288.7161f,    2545.3674f,    3028.9507f,    3517.5840f,    3824.4246f,    4144.8486f,    4481.8140f,    4821.2769f,    5162.3975f,    5542.8560f,    5928.5854f,
    379.7892f,     500.9199f,     725.0223f,     998.7143f,    1179.6127f,    1771.9886f,    2775.4812f,    3136.8457f,    3378.6143f,    3674.0188f,    3946.3604f,    4184.4824f,    4521.5454f,    4934.8940f,    5315.5029f,    5759.7544f,
    317.4339f,     442.2628f,     778.7388f,    1167.8633f,    1356.1576f,    1578.5603f,    1840.1584f,    2870.7527f,    3236.1504f,    3502.7249f,    3876.3696f,    4100.5244f,    4650.2632f,    5235.1890f,    5665.2285f,    5999.0649f,
    350.2696f,     492.2163f,     763.0640f,    1264.7550f,    1515.0244f,    1755.7783f,    2489.3274f,    2898.6252f,    3143.1018f,    3643.0640f,    4035.0657f,    4255.0889f,    4641.7231f,    5138.5107f,    5557.1318f,    5920.2402f,
    301.3833f,     464.9852f,     762.3419f,    1012.2126f,    1803.5172f,    2192.4214f,    2651.6287f,    3013.6697f,    3251.3591f,    3539.4675f,    3946.3433f,    4469.3560f,    4890.7446f,    5200.4878f,    5509.6753f,    5910.2397f,
    253.1752f,     356.8990f,     630.3325f,    1163.1683f,    1528.6230f,    2023.4438f,    2488.6001f,    2745.5627f,    2933.7024f,    3237.4414f,    3976.9258f,    4415.2534f,    4789.9131f,    5194.3423f,    5714.6445f,    6032.4160f,
    265.1815f,     364.7549f,     590.0148f,     805.2595f,    1564.7582f,    2150.6536f,    2365.6501f,    2598.7876f,    2861.5334f,    3514.1265f,    4005.6328f,    4609.3091f,    4955.4478f,    5238.4116f,    5519.5884f,    5890.7925f,
    209.3544f,     313.1497f,     503.2642f,     949.4504f,    1729.7280f,    1912.6814f,    2117.5051f,    2498.6272f,    3284.6587f,    3810.8555f,    4105.0195f,    4349.5151f,    4770.3682f,    5210.2910f,    5585.1533f,    5970.3638f,
    302.3150f,     415.6502f,     684.1018f,     922.3598f,    1489.4418f,    2235.6252f,    2449.9773f,    2800.6938f,    3061.3721f,    3526.1001f,    3905.8174f,    4170.7891f,    4446.4209f,    4907.9937f,    5470.7158f,    5914.7261f,
    264.9068f,     366.4342f,     582.8182f,     790.8568f,    1619.4548f,    2034.0782f,    2337.6724f,    2632.1714f,    2933.2356f,    3430.1858f,    3815.0198f,    4276.3931f,    4748.3149f,    5164.0098f,    5553.3320f,    5974.9092f,
    249.6359f,     361.9234f,     581.9844f,     841.1097f,    1657.5543f,    2184.4114f,    2525.9739f,    2820.0503f,    3120.7190f,    3623.7678f,    4050.5435f,    4434.5742f,    4802.6782f,    5171.8438f,    5575.0068f,    5963.7402f,
    290.1085f,     404.2538f,     664.1223f,     878.2748f,    1237.1085f,    2237.4707f,    2497.5647f,    2957.7786f,    3289.3928f,    3626.5276f,    4190.9243f,    4594.6450f,    4981.7456f,    5283.5513f,    5617.1538f,    5938.3760f,
    182.7846f,     270.3831f,     490.2131f,    1070.2524f,    1674.5724f,    2092.4905f,    2524.1472f,    2929.3523f,    3334.8005f,    3712.0061f,    4101.2896f,    4475.7324f,    4866.1919f,    5231.7559f,    5606.4077f,    5960.9644f,
    286.7701f,     386.1487f,     577.4210f,     764.3087f,    1151.2404f,    2014.4502f,    2399.8547f,    2879.0371f,    3160.2502f,    3450.6274f,    3869.8240f,    4368.3618f,    4816.7861f,    5187.6450f,    5564.7231f,    5962.0386f,
    179.9538f,     266.0682f,     647.9122f,    1380.2810f,    1776.1240f,    2208.4592f,    2590.6843f,    2993.6758f,    3368.2034f,    3753.2156f,    4125.2124f,    4508.6050f,    4878.9932f,    5249.3291f,    5612.5049f,    5965.2134f,
    309.2416f,     434.7111f,     724.6614f,     936.5360f,    1264.9886f,    2272.1338f,    2548.4519f,    2904.0798f,    3313.4990f,    3579.7854f,    3914.5811f,    4297.5938f,    4756.9072f,    5163.2017f,    5592.2822f,    5943.7222f,
    256.9009f,     393.7155f,     769.3966f,    1200.9640f,    1774.4797f,    2307.9629f,    2794.6799f,    3165.9431f,    3507.7952f,    3840.5791f,    4142.8877f,    4453.5078f,    4790.6973f,    5142.6123f,    5530.5977f,    5923.2188f,
    394.1425f,     602.0079f,     934.5173f,    1352.9718f,    1813.9639f,    2172.5435f,    2603.7295f,    2963.9590f,    3335.2344f,    3732.0515f,    4120.0151f,    4487.9668f,    4877.6294f,    5238.9336f,    5596.1479f,    5939.6489f,
    373.0307f,     665.4328f,    1227.4684f,    1524.6017f,    1947.3784f,    2361.6384f,    2778.1921f,    3134.5396f,    3462.3992f,    3752.4592f,    4069.0352f,    4404.2720f,    4782.2241f,    5145.0581f,    5541.9980f,    5932.9136f,
    449.9942f,     814.1862f,    1344.2784f,    1682.7061f,    2086.3599f,    2486.9709f,    2916.1177f,    3265.9099f,    3616.3977f,    3919.6345f,    4218.5342f,    4519.2207f,    4857.5220f,    5193.5269f,    5573.7339f,    5934.5400f,
    531.4455f,     965.7403f,    1458.5353f,    1773.3784f,    2236.0146f,    2650.9109f,    3099.2871f,    3467.1567f,    3809.7056f,    4094.6472f,    4378.5811f,    4660.2471f,    4962.5078f,    5270.9863f,    5629.4160f,    5973.6450f,
    565.5986f,    1091.1300f,    1561.4944f,    1983.5482f,    2492.8821f,    2897.5085f,    3233.5361f,    3539.8831f,    3838.6494f,    4093.4460f,    4372.1924f,    4678.2251f,    4999.2646f,    5325.0371f,    5672.8887f,    5998.9990f,
    581.0623f,     976.0275f,    1447.0302f,    1779.9243f,    2148.2158f,    2543.8347f,    2979.5061f,    3373.6099f,    3796.8259f,    4164.8242f,    4510.5493f,    4853.5527f,    5175.6318f,    5465.3647f,    5763.2334f,    6050.6582f,
    429.4613f,     802.5781f,    1229.0529f,    1512.6678f,    1835.8625f,    2216.9915f,    2625.3999f,    2995.9927f,    3379.5146f,    3764.7837f,    4156.1382f,    4532.4570f,    4906.4678f,    5262.8960f,    5626.6519f,    5970.6504f,
    224.5468f,     328.6938f,     615.8844f,    1207.4470f,    1520.9565f,    1865.9806f,    2182.4731f,    2431.4897f,    3239.3486f,    3490.9065f,    3775.7139f,    4291.4312f,    4740.0815f,    5192.0786f,    5532.9302f,    5928.7236f,
    312.1133f,     424.3103f,     716.4448f,     921.9969f,    1244.5491f,    2017.9143f,    2248.4170f,    2840.0688f,    3138.9390f,    3399.7288f,    3723.3479f,    3999.6824f,    4582.2339f,    5148.5166f,    5631.8989f,    6000.7192f,
    373.5378f,     506.7356f,     789.6149f,     942.6201f,    1695.8035f,    2021.6426f,    2323.3867f,    2649.5979f,    2853.1729f,    3169.5815f,    3524.9375f,    3848.6399f,    4261.7319f,    4978.9668f,    5505.4004f,    5924.7939f,
    503.2296f,     724.8124f,     940.3833f,    1220.5646f,    1439.8641f,    1726.9827f,    2215.5464f,    2476.0925f,    2846.8127f,    3232.0950f,    3638.5989f,    3986.3333f,    4371.3052f,    5022.0664f,    5657.4897f,    6040.3452f,
    398.3355f,     530.8898f,     835.5377f,    1058.3699f,    1327.2036f,    1814.9178f,    2114.2439f,    2515.8892f,    2754.9077f,    3094.8794f,    3598.7061f,    3981.2385f,    4605.9160f,    5110.8364f,    5550.1899f,    5953.9600f,
    327.7583f,     454.8903f,     825.9029f,    1025.4349f,    1321.1567f,    1551.4836f,    1978.2037f,    2838.9021f,    3111.9041f,    3417.3940f,    3841.0564f,    4696.0547f,    5126.1641f,    5409.5347f,    5711.7163f,    5968.3394f,
    327.1260f,     431.3983f,     721.9533f,     871.1266f,    1507.7616f,    1847.8716f,    2144.9641f,    2491.1108f,    2702.0847f,    3483.1516f,    3917.5173f,    4254.1260f,    4704.4863f,    4981.6284f,    5450.1035f,    5937.7861f,
    443.5867f,     610.7686f,     818.9614f,     999.3525f,    1181.9182f,    1884.4948f,    2243.3950f,    2522.8867f,    2993.8594f,    3196.6631f,    3835.5020f,    4233.2568f,    4506.8604f,    4985.0249f,    5544.1382f,    5980.0083f,
    395.7788f,     582.9504f,     822.1151f,    1013.0453f,    1224.6812f,    1988.4263f,    2452.4744f,    2686.4263f,    2952.8831f,    3135.0867f,    3562.5471f,    4006.6929f,    4401.7471f,    5038.5654f,    5567.4189f,    5986.0850f,
    264.3071f,     372.0398f,     616.4940f,     842.1705f,    1350.0250f,    1822.1957f,    2165.8896f,    2662.2937f,    3055.4390f,    3502.6787f,    3923.4236f,    4352.6587f,    4772.5068f,    5158.1309f,    5573.9385f,    5972.6895f,
    218.7390f,     325.2024f,     635.0441f,    1103.4701f,    1636.4287f,    2070.2615f,    2274.2910f,    2453.2002f,    3069.4382f,    3615.7065f,    3980.0811f,    4484.8662f,    4848.6416f,    5093.7163f,    5522.6973f,    5907.4048f,
    260.0797f,     461.2137f,    1049.2261f,    1334.1865f,    1628.6233f,    2014.9823f,    2413.4802f,    2844.4973f,    3232.3040f,    3661.0122f,    4069.8274f,    4466.5210f,    4857.6553f,    5234.4463f,    5608.4517f,    5954.7920f,
    301.7969f,     406.3861f,     706.7324f,    1387.1207f,    1581.4719f,    2004.7585f,    2291.9421f,    2548.9978f,    3076.8755f,    3343.1306f,    3623.1770f,    4279.7432f,    4777.6563f,    5084.3960f,    5473.4536f,    5872.0615f,
    344.0269f,     472.3550f,     776.6819f,    1455.1270f,    1611.6870f,    2012.4386f,    2417.4033f,    2621.8564f,    3318.9663f,    3709.0132f,    3944.1958f,    4299.0293f,    4776.4038f,    5184.1089f,    5545.5454f,    5913.9531f,
    332.1463f,     433.0623f,     992.1605f,    1254.8217f,    1498.4819f,    1824.6357f,    2118.3374f,    2444.6484f,    2684.8369f,    2930.4683f,    3557.4851f,    4292.9014f,    4786.7251f,    5138.2168f,    5616.2739f,    5996.8369f,
    281.7202f,     372.7708f,    1074.7051f,    1443.0428f,    1687.6460f,    1980.7075f,    2275.4241f,    2632.2017f,    2848.1765f,    3118.7881f,    3628.5857f,    4522.9585f,    4876.2163f,    5177.2739f,    5600.6675f,    5960.9634f,
    412.0151f,     535.6881f,     768.8618f,    1462.2601f,    1789.1055f,    1947.8196f,    2224.6890f,    2447.9089f,    2834.6140f,    3472.6721f,    3729.8525f,    4008.2893f,    4525.7271f,    4822.9194f,    5204.6611f,    5895.0942f,
    263.8760f,     379.7789f,     825.0498f,    1113.1218f,    1465.8749f,    1846.7463f,    2146.0496f,    2487.2766f,    2845.8447f,    3388.4800f,    3883.8447f,    4440.7603f,    4867.0815f,    5214.7280f,    5535.8149f,    5906.9932f,
    409.8116f,     583.7237f,     859.1983f,    1172.0491f,    1377.6473f,    1984.8322f,    2361.7292f,    2688.9368f,    3238.6563f,    3542.6716f,    3944.3005f,    4441.0840f,    4881.1211f,    5224.6045f,    5604.3711f,    5909.3657f,
    318.0743f,     438.8244f,     852.9153f,    1061.4503f,    1290.7609f,    1552.5408f,    2053.1118f,    2373.2883f,    2926.1560f,    3452.9551f,    4098.6626f,    4585.2773f,    4967.0898f,    5271.2720f,    5644.6709f,    5961.9585f,
    370.3631f,     496.5860f,     932.6390f,    1213.4189f,    1452.6641f,    1803.1532f,    2092.2354f,    2607.5247f,    2883.8086f,    3112.1086f,    3687.5657f,    4525.1274f,    4846.9404f,    5130.0537f,    5416.4141f,    5804.5122f,
    247.8941f,     343.9862f,     751.6780f,    1526.2566f,    1712.5012f,    2038.0667f,    2324.0371f,    2727.9749f,    3005.8975f,    3378.9817f,    3858.2002f,    4339.2017f,    4716.4580f,    5125.0918f,    5564.3589f,    5969.7163f,
    297.6552f,     401.7544f,     891.9346f,    1380.2275f,    1540.3125f,    1782.6058f,    2009.2045f,    2614.2092f,    2899.5396f,    3379.9722f,    3804.1169f,    4284.8540f,    4696.3335f,    5118.4551f,    5525.9839f,    5934.2686f,
    226.1444f,     333.4511f,     682.9995f,    1307.4166f,    1554.1943f,    1849.3679f,    2116.3438f,    2756.3567f,    3204.3018f,    3540.4106f,    4002.1895f,    4402.7734f,    4796.4395f,    5192.6812f,    5600.6841f,    5960.1855f,
    196.3791f,     299.9716f,     572.3173f,    1201.8826f,    1804.7235f,    2012.0171f,    2264.7415f,    2790.3406f,    3272.6926f,    3668.4863f,    4063.0435f,    4442.4419f,    4810.5957f,    5156.0923f,    5512.8501f,    5900.7441f,
    280.1911f,     391.5190f,     705.9903f,    1435.5063f,    1588.2345f,    2116.5032f,    2357.1875f,    2670.7461f,    3299.0071f,    3507.9336f,    4044.3057f,    4591.9023f,    4981.4575f,    5281.1270f,    5654.7158f,    5949.9263f,
    262.5740f,     370.5089f,     654.7243f,    1278.9299f,    1847.3096f,    2087.3394f,    2553.8892f,    2887.8269f,    3254.0747f,    3810.6626f,    4258.4390f,    4528.8022f,    4872.9741f,    5206.0483f,    5565.2876f,    5918.5596f,
    193.6133f,     356.3127f,    1076.8109f,    1485.8608f,    1887.7994f,    2273.1333f,    2676.7832f,    3052.3513f,    3419.1294f,    3792.5024f,    4161.7036f,    4532.6431f,    4898.5176f,    5262.0498f,    5622.8901f,    5976.4863f,
    302.7377f,     409.7598f,     899.1851f,    1176.6501f,    1531.3615f,    1933.6494f,    2229.9561f,    2819.8936f,    3031.6248f,    3807.0129f,    4118.7495f,    4412.7339f,    4704.6758f,    5012.0190f,    5351.4160f,    5892.3232f,
    421.1889f,     587.3521f,     835.9208f,    1248.0127f,    1475.8882f,    1779.3772f,    2330.6294f,    2606.6780f,    3026.0417f,    3513.8035f,    3754.6023f,    4081.0518f,    4536.3438f,    4815.9336f,    5117.6392f,    5802.9902f,
    378.0719f,     722.0884f,    1327.5808f,    1665.8940f,    1954.7782f,    2238.9473f,    2608.8538f,    2958.7910f,    3341.5112f,    3721.2021f,    4095.8457f,    4457.6865f,    4843.8672f,    5212.5142f,    5589.5122f,    5945.3730f,
    468.4631f,     962.3222f,    1541.0238f,    1919.1746f,    2347.4365f,    2650.7366f,    2927.5945f,    3166.4202f,    3451.0664f,    3757.8477f,    4109.2383f,    4467.9443f,    4858.6045f,    5211.8428f,    5593.3311f,    5951.0137f,
    422.2508f,     845.8956f,    1495.2552f,    1811.3933f,    2128.1157f,    2371.2532f,    2656.0715f,    2942.9011f,    3294.5308f,    3652.0935f,    4031.2534f,    4399.2222f,    4801.9497f,    5163.3721f,    5559.4517f,    5934.4063f,
    423.1028f,     661.7286f,     991.1974f,    1204.3813f,    1472.8564f,    2003.0298f,    2443.5833f,    2789.2795f,    3354.1692f,    3722.7822f,    4032.7351f,    4320.9727f,    4621.8140f,    4963.7310f,    5429.8203f,    5900.1465f,
    361.2513f,     485.9720f,     828.4865f,    1340.9952f,    1497.8477f,    2072.8511f,    2437.9839f,    2674.9912f,    3259.3357f,    3539.0474f,    3789.1389f,    4087.5015f,    4404.8867f,    4771.0947f,    5500.2227f,    6015.7041f,
    301.8146f,     392.9569f,     685.1938f,    1783.6246f,    2034.8542f,    2257.1614f,    2519.8713f,    2782.6279f,    3152.1135f,    3400.8662f,    3614.3801f,    3906.7375f,    4233.1968f,    4712.3682f,    5596.0396f,    5998.5742f,
    242.0591f,     371.0809f,     729.0743f,    1190.6813f,    1851.5691f,    2132.6724f,    2334.7773f,    2522.3608f,    3091.8643f,    3621.4614f,    3854.5227f,    4174.7017f,    4490.7510f,    4780.1230f,    5157.6147f,    5865.4756f,
    431.2477f,     562.1808f,     888.5207f,    1034.2062f,    1443.2480f,    2109.8850f,    2337.1443f,    2829.1870f,    3070.1301f,    3252.6370f,    3510.3967f,    4366.2236f,    4843.2139f,    5133.0537f,    5549.8911f,    5850.3252f,
    420.2594f,     668.9339f,     911.1281f,    1218.0372f,    1806.5541f,    2050.8423f,    2394.5708f,    2761.3542f,    3021.1716f,    3414.0020f,    3970.9626f,    4342.2900f,    4691.6074f,    5062.5386f,    5452.6655f,    5792.8384f,
    257.3011f,     370.8905f,     604.8825f,    1096.4209f,    1711.8464f,    1934.4335f,    2319.4717f,    2769.0144f,    3019.0200f,    3354.3726f,    4119.8809f,    4354.8589f,    4557.7979f,    4893.5776f,    5450.3042f,    5910.4136f,
    241.4264f,     347.9253f,     622.2432f,    1248.8121f,    1559.7318f,    1848.8098f,    2315.5635f,    2571.5894f,    2879.5754f,    3624.1069f,    3968.0334f,    4238.9727f,    4713.4746f,    5156.6792f,    5568.5596f,    5975.8716f,
    478.7131f,     629.4184f,     918.1857f,    1342.7815f,    1535.1541f,    1803.0487f,    2483.7764f,    2724.4321f,    2998.1257f,    3634.9932f,    3915.9443f,    4119.2837f,    4327.0283f,    4980.3516f,    5532.6880f,    5964.3052f,
    265.7818f,     373.8575f,     723.3755f,    1186.0619f,    1509.2827f,    2064.2075f,    2298.1992f,    2566.4395f,    2785.7659f,    3423.1396f,    3883.9011f,    4136.8940f,    4463.0386f,    5010.6592f,    5539.0337f,    5931.4414f,
    221.4221f,     347.7610f,     707.4465f,    1187.0800f,    1575.9095f,    1824.3983f,    1979.3307f,    2299.3174f,    2967.6799f,    3472.3381f,    3955.8469f,    4292.6079f,    4794.8745f,    5127.5181f,    5652.6729f,    5953.0132f,
    397.2769f,     510.2605f,     746.8268f,    1588.0735f,    1991.5200f,    2150.6843f,    2439.0486f,    2712.2754f,    2972.5825f,    3501.2673f,    3917.5459f,    4143.6069f,    4443.4414f,    4829.1929f,    5490.0376f,    6028.3794f,
    280.5184f,     370.6464f,     640.7120f,    1721.3899f,    1948.9806f,    2149.9592f,    2400.4678f,    2674.0542f,    3146.3154f,    3419.8850f,    3813.9553f,    4417.4497f,    4818.3652f,    5139.6323f,    5465.0669f,    5879.7183f,
    325.2418f,     431.2627f,    1008.7708f,    1271.9235f,    1527.4150f,    2066.6370f,    2242.3311f,    2883.4065f,    3180.6614f,    3352.5015f,    3756.9688f,    4386.6904f,    4857.6621f,    5189.2212f,    5514.7573f,    5856.8086f,
    451.8427f,     582.4401f,     925.8821f,    1363.4249f,    1503.2460f,    1961.5940f,    2265.6001f,    2574.4414f,    3123.0769f,    3345.1587f,    3634.3022f,    4266.0137f,    4880.8052f,    5223.5776f,    5567.8901f,    5880.3770f,
    411.0873f,     553.3847f,     809.2106f,    1023.4841f,    1189.0618f,    1786.0770f,    2121.8489f,    2454.6458f,    2947.4700f,    3220.3210f,    3828.0911f,    4218.0229f,    4831.2383f,    5322.1445f,    5727.3906f,    6033.3887f,
    310.5608f,     442.2204f,     742.7755f,    1097.5740f,    1340.9608f,    1854.4385f,    2261.6399f,    2634.8315f,    3297.8879f,    3638.6956f,    3925.8770f,    4232.9146f,    4559.9287f,    4893.5830f,    5403.0981f,    5917.7056f,
    377.5583f,     488.4103f,     945.2491f,    1234.1572f,    1416.0774f,    1666.5979f,    1932.9910f,    2746.2000f,    2997.4753f,    3216.6152f,    3559.3999f,    3843.8130f,    4359.6626f,    5014.2920f,    5560.6162f,    5992.7212f,
    285.2173f,     389.6116f,     825.5790f,    1238.8229f,    1459.6588f,    1860.8855f,    2178.6296f,    2519.1597f,    2828.0032f,    3278.8101f,    3560.8286f,    4142.0552f,    4691.0698f,    5117.7778f,    5558.7944f,    5954.6680f,
    465.7002f,     631.7491f,     914.5521f,    1340.0057f,    1562.5760f,    1844.1741f,    2186.1208f,    2483.7080f,    2901.9417f,    3190.3162f,    3474.7651f,    3873.4065f,    4240.1973f,    4761.1255f,    5428.2832f,    5958.5273f,
    340.5456f,     449.2341f,     793.7005f,    1387.7467f,    1555.8701f,    1938.7877f,    2201.6155f,    2579.5762f,    2914.9724f,    3149.8584f,    3699.3984f,    3985.6790f,    4331.7534f,    4999.4805f,    5514.6924f,    5969.4897f,
    395.8350f,     564.1188f,     774.8214f,    1276.3201f,    1721.8716f,    1864.0143f,    2267.5696f,    2790.2031f,    3003.9434f,    3377.6140f,    3917.7395f,    4167.3867f,    4465.2529f,    4936.1138f,    5464.0479f,    5905.0444f,
    324.1844f,     443.0006f,     728.8958f,    1398.6589f,    1584.1820f,    1923.8724f,    2348.0903f,    2561.5554f,    3154.5991f,    3449.1746f,    3771.7927f,    4182.1899f,    4937.0791f,    5361.6509f,    5727.7656f,    6002.7505f,
    267.1790f,     373.7663f,     703.5949f,    1173.7009f,    1390.2002f,    1905.7941f,    2177.4961f,    2703.2627f,    3022.9121f,    3308.9612f,    3798.5823f,    4187.1533f,    4703.2163f,    5136.0918f,    5571.1655f,    5966.6577f,
    272.9294f,     399.3804f,     797.7335f,    1180.1516f,    1426.4850f,    2097.2839f,    2355.4727f,    2793.8774f,    3137.1907f,    3458.7727f,    3893.6628f,    4245.8047f,    4652.3794f,    5106.5293f,    5568.1885f,    5948.3169f,
    324.5529f,     431.7663f,     759.6147f,    1494.8739f,    1668.8168f,    2110.5635f,    2427.4104f,    2672.9270f,    3170.5266f,    3448.2080f,    3717.1240f,    4034.2280f,    4375.3647f,    5041.1372f,    5666.9517f,    6014.7217f,
    306.4759f,     404.5361f,     795.7795f,    1675.9967f,    1835.0950f,    2160.6624f,    2430.8855f,    2734.2646f,    3270.1426f,    3586.1355f,    3821.9670f,    4102.0078f,    4372.9404f,    4918.9146f,    5412.0376f,    5868.5225f,
    421.3803f,     607.7995f,     813.0241f,    1286.8525f,    1827.2451f,    2026.8683f,    2333.9453f,    2730.9817f,    2988.4067f,    3303.8513f,    3759.1897f,    4057.5264f,    4441.5493f,    4890.0078f,    5212.0469f,    5672.2188f,
    423.8560f,     599.5201f,     829.0651f,    1082.6381f,    1245.9272f,    1623.7075f,    2453.0420f,    2855.6631f,    3171.3855f,    3475.5881f,    3715.4219f,    3972.1326f,    4419.1597f,    4894.0283f,    5363.8691f,    5919.2681f,
    441.2789f,     634.8879f,     921.6287f,    1189.0240f,    1368.7466f,    2012.1312f,    2383.7656f,    2638.5222f,    2975.0288f,    3163.6150f,    3433.9958f,    3838.9917f,    4186.6426f,    4856.8477f,    5559.1196f,    5977.2290f,
    349.2039f,     466.2342f,     724.2582f,     904.4043f,    1190.4492f,    1981.7565f,    2226.5554f,    2592.5098f,    2865.5525f,    3195.8196f,    3735.6345f,    4267.1660f,    4810.9893f,    5207.5093f,    5605.1445f,    5952.0361f,
    497.7713f,     719.9073f,     925.0815f,    1146.3021f,    1326.7095f,    1574.5039f,    2306.7678f,    2714.8022f,    2967.5190f,    3400.1121f,    3732.0544f,    3981.7878f,    4553.4819f,    5090.0869f,    5426.2085f,    5833.5220f,
    471.7526f,     648.3213f,     902.1542f,    1245.7086f,    1423.3403f,    1701.1757f,    2125.8530f,    2407.0481f,    2969.5583f,    3294.1296f,    3712.8398f,    4140.7930f,    4808.4668f,    5322.3896f,    5662.1255f,    5950.6211f,
    345.3843f,     485.9887f,     841.2579f,    1035.9401f,    1244.8905f,    1488.1833f,    2340.4253f,    2607.0859f,    2845.4153f,    3223.1768f,    3557.0696f,    4119.7944f,    4666.8896f,    5145.8589f,    5565.7534f,    5976.6875f,
    332.4270f,     427.5984f,     829.9191f,    1138.0469f,    1339.4468f,    1589.0535f,    1926.0630f,    2432.9331f,    2699.7964f,    3311.4355f,    3716.1003f,    4270.4990f,    4760.3647f,    5208.3950f,    5619.2080f,    5971.2715f,
    249.0114f,     381.2982f,     925.7067f,    1520.3356f,    1842.8396f,    2368.2908f,    2783.4033f,    3272.5757f,    3673.7402f,    4046.3950f,    4370.4966f,    4688.0269f,    5002.6772f,    5316.3594f,    5650.2192f,    5977.6587f,
    263.3275f,     451.6255f,    1252.2307f,    1503.0652f,    1786.7695f,    2082.7554f,    2451.1829f,    2804.7590f,    3116.7583f,    3493.8892f,    3884.6575f,    4349.6724f,    4770.0156f,    5143.1636f,    5542.5913f,    5931.5522f,
    252.9447f,     341.5762f,     632.7664f,    1766.8096f,    2084.1511f,    2272.7332f,    2531.1006f,    2765.2080f,    3134.5417f,    3380.6223f,    3640.8015f,    3932.7854f,    4532.1172f,    5245.2070f,    5597.0776f,    5973.6831f,
    234.9979f,     324.6731f,    1239.8643f,    1663.1921f,    1858.7769f,    2171.1614f,    2403.8818f,    2680.6433f,    2836.4985f,    3192.6577f,    3864.8811f,    4385.8066f,    4845.9766f,    5150.2412f,    5631.1519f,    6011.7773f,
    284.5302f,     410.1263f,     985.4119f,    1298.3987f,    1789.4304f,    1996.9287f,    2450.8525f,    2831.6011f,    2994.2073f,    3214.1306f,    3525.0498f,    3819.9141f,    4672.7544f,    5424.3545f,    5691.0732f,    5980.3096f,
    244.2704f,     415.5891f,    1038.3009f,    1317.5186f,    1686.4528f,    2081.3147f,    2476.9873f,    2959.5393f,    3214.9561f,    3569.1431f,    3934.4736f,    4308.7114f,    4728.3687f,    5105.7964f,    5488.1938f,    5908.9443f,
    335.8417f,     468.3464f,    1003.6253f,    1275.0145f,    1534.2854f,    1985.3167f,    2348.3411f,    2743.3169f,    2956.0967f,    3408.5063f,    3866.8574f,    4287.0034f,    4556.7222f,    4922.7832f,    5259.7480f,    5800.2876f,
    388.2726f,     518.0591f,     832.5999f,    1325.0247f,    1528.8624f,    1808.1732f,    2151.0820f,    2486.1331f,    2815.4980f,    3158.5391f,    3635.3606f,    3960.5383f,    4671.7686f,    5371.8140f,    5777.8940f,    6056.4722f,
    506.5153f,     673.0771f,     900.0349f,    1154.2124f,    1378.2689f,    1786.9409f,    2081.9631f,    2398.6965f,    2859.7441f,    3075.4841f,    3546.6563f,    4322.6694f,    4732.0049f,    4992.5542f,    5267.5859f,    5807.1812f,
    487.2466f,     653.6116f,     968.5656f,    1389.2708f,    1601.5822f,    1910.9694f,    2282.4038f,    2608.7063f,    3032.6233f,    3361.9692f,    3629.8552f,    3908.8335f,    4318.4009f,    4646.5781f,    5043.5962f,    5792.7393f,
    432.8733f,     591.7551f,     899.2619f,    1490.1176f,    1789.8751f,    2060.3750f,    2434.8779f,    2840.3374f,    3122.1292f,    3472.8079f,    3830.8870f,    4097.2622f,    4353.5464f,    4650.2075f,    4981.5752f,    5482.9565f,
    378.4767f,     508.5656f,     802.8280f,     947.2892f,    1532.0898f,    2038.8177f,    2349.1965f,    2650.2039f,    2863.8018f,    3591.6697f,    3918.9211f,    4256.6255f,    4604.8467f,    4899.0996f,    5237.6084f,    5791.5029f,
    407.0908f,     546.0364f,     866.1215f,    1098.6927f,    1347.2009f,    1657.1525f,    1965.5845f,    2717.7190f,    3033.4961f,    3509.9031f,    3873.4150f,    4131.4438f,    4389.5693f,    4774.2295f,    5450.1768f,    5977.5151f,
    429.3459f,     568.8134f,     903.5659f,    1099.2942f,    1379.4979f,    2207.5940f,    2479.9919f,    2780.9072f,    3206.3960f,    3425.4084f,    3682.5911f,    3950.1941f,    4324.0840f,    4689.4922f,    5068.2534f,    5787.2852f,
    371.9443f,     524.7249f,     890.0464f,    1670.7485f,    1958.5308f,    2182.7007f,    2558.5007f,    2835.4937f,    3192.0740f,    3634.4817f,    3950.0942f,    4259.6953f,    4628.0049f,    4999.1616f,    5364.9893f,    5801.6855f,
    323.1922f,     451.0327f,     787.1655f,    1011.6555f,    1323.8138f,    2177.6636f,    2401.1392f,    2826.8796f,    3432.8999f,    3653.1851f,    3883.9897f,    4082.7559f,    4361.6753f,    4635.1475f,    5084.7544f,    5823.3062f,
    377.0061f,     524.2181f,     743.6288f,    1378.9187f,    1857.6434f,    2056.4695f,    2453.7949f,    2902.1995f,    3127.2651f,    3463.3523f,    3980.1316f,    4241.2578f,    4528.5859f,    4881.4521f,    5239.3145f,    5580.5986f,
    308.7965f,     403.7058f,     705.9506f,    1823.8571f,    2126.9387f,    2369.2810f,    2647.2048f,    2855.8276f,    3209.7708f,    3498.2310f,    3747.6047f,    3972.8647f,    4254.3325f,    4574.4292f,    5087.3965f,    5890.4219f,
    274.7571f,     383.7251f,     573.6029f,    1142.8372f,    2151.7173f,    2558.8972f,    2751.9468f,    2987.4412f,    3234.3350f,    3526.0127f,    3922.9927f,    4189.0249f,    4483.3774f,    4877.1860f,    5396.7798f,    5921.8125f,
    248.5916f,     423.6264f,    1260.9626f,    1696.0492f,    1972.9108f,    2298.5972f,    2592.9307f,    2947.2292f,    3266.2227f,    3614.3572f,    3980.3892f,    4359.4067f,    4770.2842f,    5158.9058f,    5554.6597f,    5936.9043f,
    320.5471f,     429.6766f,     657.1440f,    1390.1080f,    2194.6426f,    2507.6086f,    2712.3662f,    2980.3408f,    3216.1682f,    3544.8467f,    3956.9790f,    4227.5308f,    4463.7563f,    4745.7124f,    5088.6650f,    5525.8516f,
    245.5478f,     520.3131f,    1177.0693f,    1454.0125f,    1770.2620f,    2160.8779f,    2551.2700f,    2950.2324f,    3326.8621f,    3710.4624f,    4104.3936f,    4481.9971f,    4865.9736f,    5230.6396f,    5608.5649f,    5965.6162f,
    514.5864f,     956.9897f,    1287.9597f,    1520.3473f,    1802.0631f,    2116.4980f,    2509.8552f,    2865.9822f,    3238.7510f,    3611.3108f,    4016.4353f,    4431.8457f,    4860.3442f,    5231.4814f,    5614.6016f,    5963.9976f,
    537.0523f,     932.2803f,    1380.2690f,    1709.4702f,    2079.9902f,    2446.4014f,    2859.4204f,    3229.6975f,    3623.4031f,    4012.5327f,    4373.7568f,    4724.3359f,    5078.2686f,    5397.6040f,    5721.9639f,    6028.1167f,
    452.5153f,     798.2777f,    1099.3080f,    1317.0807f,    1652.6885f,    2059.7708f,    2471.0164f,    2808.5396f,    3146.5076f,    3494.0779f,    3870.6912f,    4310.8281f,    4777.5024f,    5181.2617f,    5574.4912f,    5934.3813f,
    340.3716f,     430.5102f,     872.3513f,    1636.3792f,    1772.8615f,    2074.0161f,    2295.1008f,    2693.0037f,    3177.7710f,    3391.7559f,    3670.8718f,    4224.3926f,    4896.3877f,    5199.9883f,    5580.4512f,    5911.7671f,
    317.8269f,     414.8185f,     881.1970f,    1658.4944f,    1852.0098f,    2136.0415f,    2380.8228f,    2668.9141f,    3046.8027f,    3299.0051f,    3523.0593f,    3758.9412f,    4116.9063f,    5061.2124f,    5624.1777f,    5989.4761f,
    374.0671f,     488.0840f,     734.0546f,    1415.9261f,    1648.7783f,    1852.8462f,    2099.1895f,    2347.5562f,    2954.8359f,    3269.6714f,    3536.7920f,    4116.1743f,    4481.4355f,    4913.8838f,    5467.2817f,    5909.8779f,
    340.4291f,     448.5775f,    1041.4979f,    1426.0011f,    1637.8165f,    1968.6743f,    2210.7976f,    2647.5144f,    2913.8650f,    3131.7698f,    3429.8755f,    3722.6763f,    4104.6479f,    4969.0093f,    5574.2231f,    5978.2070f,
    254.2538f,     412.7710f,     947.8206f,    1209.3683f,    1690.4813f,    2040.7881f,    2401.4314f,    2728.0066f,    3016.2290f,    3530.3865f,    3964.6563f,    4393.6934f,    4804.2168f,    5187.9302f,    5586.4399f,    5954.8950f,
    241.0244f,     347.0750f,     835.2348f,    1601.9089f,    1786.4336f,    2134.3950f,    2396.0139f,    2848.9712f,    3239.9138f,    3623.8250f,    4029.5088f,    4400.3936f,    4797.3564f,    5195.7310f,    5596.6689f,    5965.9878f,
    309.3683f,     453.6776f,     812.9343f,    1125.9915f,    1423.5935f,    2149.2227f,    2514.9277f,    3031.3599f,    3463.7219f,    3790.7839f,    4064.0039f,    4297.9839f,    4653.4551f,    5189.7061f,    5721.2954f,    6033.0752f,
    469.4284f,     730.1902f,     973.0643f,    1170.5016f,    1572.2559f,    2084.2769f,    2567.8604f,    2963.4592f,    3286.9617f,    3580.3228f,    3882.8706f,    4335.5483f,    4859.7197f,    5258.2827f,    5627.9785f,    5957.8623f,
    454.6165f,     795.2360f,    1078.7705f,    1294.9473f,    1761.6650f,    2235.2788f,    2695.8455f,    3095.7695f,    3473.4897f,    3833.0889f,    4185.7290f,    4528.9863f,    4893.0039f,    5240.7627f,    5608.8594f,    5951.0718f,
    563.4587f,     875.8987f,    1139.0026f,    1378.2317f,    1855.7401f,    2279.7683f,    2651.3079f,    2968.4397f,    3279.4453f,    3607.2500f,    3975.5796f,    4358.3574f,    4768.7969f,    5135.3706f,    5525.3501f,    5904.2617f,
    461.7852f,     855.0644f,    1367.4387f,    1702.5593f,    2141.0093f,    2500.9055f,    2853.8596f,    3123.9744f,    3406.0178f,    3694.0481f,    4028.9985f,    4373.1113f,    4768.2891f,    5137.6895f,    5541.3721f,    5921.4507f,
    438.6031f,     753.0179f,    1269.3203f,    1630.4396f,    2027.2959f,    2350.9695f,    2672.1396f,    2957.1809f,    3250.1545f,    3546.5315f,    3894.0161f,    4249.9346f,    4666.2266f,    5061.2524f,    5490.7749f,    5904.6362f,
    543.3182f,     828.4835f,    1239.1818f,    1471.1134f,    1737.8622f,    2037.2484f,    2434.5112f,    2801.3242f,    3162.3250f,    3508.1255f,    3849.0903f,    4165.7588f,    4588.3809f,    5020.0952f,    5475.2813f,    5904.6377f,
    519.5982f,     837.6639f,    1171.2003f,    1363.0320f,    1617.4617f,    1976.1787f,    2472.0303f,    2901.3264f,    3340.7300f,    3736.0830f,    4103.3843f,    4444.8657f,    4800.9482f,    5145.6011f,    5544.2002f,    5933.0981f,
    433.3774f,     582.7663f,     899.6142f,    1150.7437f,    1321.1309f,    1947.8643f,    2557.8604f,    2733.1497f,    3240.4907f,    3634.7915f,    3855.9856f,    4058.0281f,    4364.2568f,    5096.5225f,    5659.0952f,    6013.8145f,
    424.9731f,     604.3164f,     868.1793f,    1207.7882f,    1414.2374f,    1713.2893f,    2520.2900f,    2960.8887f,    3210.8542f,    3584.5403f,    3914.5796f,    4149.8550f,    4505.7705f,    4886.9575f,    5214.5361f,    5597.8389f,
    347.0334f,     494.2440f,     753.7191f,    1451.0435f,    1700.7461f,    1925.4844f,    2605.7988f,    2870.4744f,    3173.7312f,    3758.7219f,    4112.1929f,    4400.3882f,    4866.1016f,    5165.8799f,    5433.0371f,    5781.1509f,
    318.4942f,     464.3939f,     783.5214f,    1491.0234f,    1708.4984f,    2280.2876f,    2533.3354f,    2885.1736f,    3443.7451f,    3669.8506f,    4000.6792f,    4269.6626f,    4571.2739f,    4827.2158f,    5277.3813f,    5850.4736f,
    386.8698f,     519.0056f,     725.0029f,     981.5649f,    1156.1665f,    1500.4691f,    2421.7993f,    2962.4722f,    3175.0166f,    3548.4756f,    3860.7961f,    4146.4150f,    4658.9897f,    5088.3999f,    5531.8945f,    5951.4624f,
    315.9294f,     738.5538f,    1171.9581f,    1553.7167f,    1949.9159f,    2319.6641f,    2707.5493f,    3069.2996f,    3444.6157f,    3811.2139f,    4177.5469f,    4545.6943f,    4905.0444f,    5271.3926f,    5622.6831f,    5974.4141f,
    216.5136f,     598.1122f,    1059.3214f,    1466.4785f,    1880.1747f,    2263.6533f,    2658.3081f,    3030.4099f,    3413.6802f,    3780.1853f,    4157.1455f,    4519.1919f,    4893.5439f,    5244.3530f,    5603.1064f,    5926.8379f,
    375.4021f,     487.0890f,     844.4013f,    1574.3596f,    1794.5249f,    2106.2878f,    2418.5217f,    2657.8938f,    3116.6096f,    3457.8625f,    3691.0596f,    3930.1062f,    4259.5928f,    4592.4370f,    5020.5078f,    5840.3989f,
    474.3148f,     724.2144f,     974.0716f,    1283.4182f,    1521.2632f,    1746.4248f,    2333.0957f,    2874.2966f,    3111.9636f,    3440.0410f,    3752.9678f,    3975.7139f,    4294.7056f,    4821.9893f,    5201.5562f,    5658.8301f,
    400.0291f,     564.9626f,     808.2393f,    1083.2745f,    1300.4403f,    2080.7405f,    2588.6882f,    2858.4629f,    3206.4502f,    3429.8623f,    3746.9080f,    4341.4868f,    4713.2803f,    4986.4258f,    5336.7339f,    5710.1123f,
    354.4416f,     480.1495f,     834.1089f,    1037.7775f,    1350.0652f,    1791.1736f,    2193.0159f,    2504.6775f,    2776.0623f,    3153.0994f,    4108.1357f,    4597.4082f,    4861.9688f,    5092.8613f,    5473.2295f,    5932.0332f,
    237.3935f,     346.9133f,     675.5335f,    1481.0535f,    1716.8414f,    1884.7153f,    2099.3057f,    2725.5403f,    3022.8506f,    3276.2922f,    3639.1001f,    4185.3926f,    4941.6597f,    5292.0093f,    5682.0391f,    5981.0215f,
    367.4981f,     469.7130f,     820.7811f,    1219.7736f,    1368.4479f,    1624.6671f,    1804.2581f,    2607.8589f,    2891.3174f,    3212.2432f,    3760.7290f,    4015.6111f,    4618.0068f,    5129.3213f,    5652.1582f,    6042.1113f,
    312.6796f,     415.8322f,     674.1500f,     853.7709f,    1808.7385f,    2232.5310f,    2497.8157f,    2834.2991f,    3039.7012f,    3301.4050f,    3659.2969f,    4455.9453f,    4841.4912f,    5111.6167f,    5502.2534f,    5924.6357f,
    341.9309f,     471.7513f,     758.1926f,     979.7221f,    1287.4463f,    1737.0303f,    2160.7915f,    2664.5562f,    2961.8315f,    3461.7439f,    3732.6611f,    4109.0928f,    4568.9111f,    5037.4331f,    5511.3169f,    5966.1304f,
    351.3721f,     462.1897f,     765.1075f,     946.3102f,    1322.8093f,    2292.2400f,    2503.6494f,    2819.7234f,    3079.2803f,    3297.6252f,    3571.4668f,    3872.0823f,    4337.6426f,    5079.1504f,    5562.8110f,    5942.7153f,
    435.4323f,     614.4746f,     892.8980f,    1215.9469f,    1395.9762f,    1814.3936f,    2155.9590f,    2465.0427f,    3201.6211f,    3490.9224f,    3853.2620f,    4410.1855f,    4786.0625f,    5095.0181f,    5394.4805f,    5715.3364f,
    294.6053f,     417.1553f,    1046.2922f,    1443.0247f,    1636.7180f,    1956.4248f,    2189.9697f,    2869.8071f,    3129.9385f,    3462.5681f,    3895.2805f,    4213.4541f,    4541.8950f,    5009.1958f,    5472.7642f,    5983.0063f,
    322.1185f,     446.8733f,     689.4188f,    1338.2788f,    1643.1023f,    1903.8652f,    2494.2722f,    2804.6968f,    3103.8682f,    3640.1233f,    3965.9861f,    4172.5596f,    4404.7388f,    4670.7544f,    5240.3682f,    5893.4600f,
    209.7024f,     336.5508f,     729.0126f,    1217.3285f,    1699.0111f,    1891.2837f,    2146.8486f,    2830.0850f,    3108.6204f,    3446.0396f,    3754.1230f,    3945.1038f,    4474.5806f,    5191.6987f,    5613.3076f,    5970.2695f,
    346.6580f,     470.5094f,     663.3455f,    1266.9061f,    2020.5759f,    2270.5173f,    2527.3550f,    2826.9104f,    3078.3403f,    3401.2625f,    3804.3770f,    4100.3091f,    4407.7876f,    4732.2319f,    5150.2749f,    5808.2559f,
    283.7796f,     391.4603f,    1165.6863f,    1456.1125f,    1692.9001f,    2008.4825f,    2322.7837f,    2784.0608f,    2998.5811f,    3268.5164f,    3548.9373f,    4167.1289f,    4643.9878f,    5099.2881f,    5473.0781f,    5929.8242f,
    301.0849f,     383.1578f,     692.0848f,    1648.9374f,    1873.0947f,    2109.6113f,    2345.0110f,    2613.1121f,    2922.0193f,    3170.0020f,    3405.0774f,    3881.9875f,    4778.3154f,    5092.5205f,    5445.7100f,    5920.7896f,
    509.1023f,     750.8580f,     963.8820f,    1295.3452f,    1634.8796f,    1818.7975f,    2151.1250f,    2590.3354f,    2867.5596f,    3238.7666f,    3747.2834f,    4053.8911f,    4457.8164f,    4928.0151f,    5295.3521f,    5789.0571f,
    421.8951f,     547.9814f,     967.4185f,    1153.8607f,    1461.4230f,    1813.0994f,    2155.2703f,    2570.9712f,    2777.6597f,    3048.9863f,    3432.0986f,    3729.3877f,    4395.7461f,    5028.7402f,    5486.4946f,    5951.5024f,
    340.6758f,     445.7014f,     931.8882f,    1253.4775f,    1521.9260f,    1969.5759f,    2267.5332f,    2735.0112f,    2948.7678f,    3236.5166f,    3529.5505f,    3882.3674f,    4699.5781f,    5089.6641f,    5377.7842f,    5880.7778f,
    284.1882f,     408.6918f,     786.3123f,    1670.3220f,    2042.9493f,    2265.2275f,    2691.2012f,    3035.8762f,    3334.1719f,    3863.1194f,    4276.8916f,    4571.0420f,    4996.4404f,    5336.5205f,    5647.9556f,    5944.5996f,
    300.0066f,     616.4817f,    1238.7324f,    1614.8296f,    1997.6188f,    2367.4343f,    2784.5605f,    3168.8354f,    3569.8250f,    3965.6011f,    4336.3804f,    4689.5874f,    5044.2012f,    5365.7456f,    5697.5654f,    6010.6572f,
    242.9420f,     476.8371f,    1250.6661f,    1671.6031f,    2159.6443f,    2637.7417f,    3049.8589f,    3371.6045f,    3674.8706f,    3951.1006f,    4230.6416f,    4543.2827f,    4887.4478f,    5220.5581f,    5595.2686f,    5962.1313f,
    242.6795f,     331.1335f,     635.2861f,    1801.5236f,    2084.1472f,    2264.4692f,    2506.2891f,    2799.4441f,    3236.7134f,    3489.6038f,    3859.3291f,    4424.8008f,    4964.6348f,    5298.6533f,    5640.2031f,    5988.0552f,
    254.0538f,     336.2447f,    1216.6261f,    1717.7201f,    1886.0708f,    2176.6338f,    2405.8547f,    2762.3037f,    2934.8816f,    3167.0657f,    3385.5457f,    3804.4346f,    4848.8198f,    5286.0352f,    5630.5391f,    6086.4492f,
    295.2298f,     426.2079f,     630.7856f,    1155.5609f,    1827.6831f,    2120.5283f,    2462.4373f,    2759.6152f,    2990.9526f,    3253.4216f,    3910.9834f,    4204.2754f,    4462.7944f,    4909.7529f,    5579.9653f,    5985.8579f,
    298.9633f,     410.3875f,     810.1115f,    1346.1040f,    1499.2391f,    2210.3948f,    2467.9424f,    2792.7122f,    3284.0874f,    3493.0740f,    3784.1899f,    4319.6396f,    4860.6548f,    5213.8540f,    5609.8672f,    5949.6890f,
    437.9900f,     575.3093f,     866.0077f,    1104.2080f,    1307.4966f,    1959.9323f,    2293.9365f,    2604.6704f,    2966.6514f,    3228.0056f,    3548.8499f,    4096.4424f,    4769.5420f,    5086.5449f,    5416.5317f,    5853.6909f,
    412.4955f,     569.1867f,     864.0179f,    1117.6798f,    1348.6332f,    1976.5171f,    2334.3960f,    2640.3381f,    3006.5347f,    3327.5784f,    3695.8564f,    4042.1753f,    4362.7837f,    4687.4751f,    5389.8662f,    5966.5825f,
    406.8686f,     542.0319f,     867.3541f,    1436.3810f,    1678.6399f,    2000.1501f,    2358.1204f,    2651.3806f,    3042.1216f,    3339.2766f,    3617.9963f,    3933.3860f,    4249.0278f,    4591.8530f,    5502.0400f,    6020.7910f,
    375.4336f,     519.7731f,     764.5574f,    1215.1381f,    1482.9417f,    1696.8020f,    1957.0332f,    2169.1169f,    2973.4634f,    3687.7449f,    3966.8525f,    4258.8042f,    4680.6567f,    4947.0225f,    5230.9824f,    5843.2466f,
    443.2378f,     574.0562f,     813.3345f,    1282.7894f,    1538.0752f,    1727.8997f,    2007.8584f,    2194.5601f,    2755.8220f,    3460.9243f,    3654.1399f,    4030.5530f,    4572.4727f,    4904.7847f,    5400.6147f,    5934.2656f,
    423.6246f,     540.1947f,     862.8629f,    1386.7659f,    1577.2052f,    1811.0304f,    2046.7363f,    2309.0366f,    3129.1145f,    3533.0020f,    3738.4211f,    4021.1111f,    4357.3677f,    4634.8740f,    5307.2920f,    5944.9155f,
    287.7661f,     401.5490f,     725.6079f,     950.8911f,    1186.5465f,    1490.1750f,    2114.7920f,    2562.4019f,    3028.3977f,    3519.6277f,    3940.5737f,    4339.3086f,    4765.8188f,    5172.3428f,    5582.8022f,    5971.0273f,
    382.6039f,     537.7234f,     836.8093f,    1371.3546f,    1578.9803f,    1869.8213f,    2292.5596f,    2540.8601f,    3032.9834f,    3402.5059f,    3737.0569f,    4053.9937f,    4446.6240f,    5251.8457f,    5710.7935f,    6022.2925f,
    313.2195f,     415.0511f,     690.6860f,    1561.4832f,    1815.6521f,    2059.9187f,    2345.5095f,    2614.8701f,    3006.9604f,    3291.9744f,    3590.4119f,    3996.1516f,    4365.4995f,    4853.4956f,    5465.1572f,    5954.5718f,
    361.7959f,     448.4001f,     921.3198f,    1343.1167f,    1488.6287f,    1736.7700f,    1950.8906f,    2536.0193f,    2768.7393f,    3062.4473f,    3484.6570f,    3888.5618f,    4618.4038f,    5092.6641f,    5523.3657f,    5966.6772f,
    249.5541f,     366.6601f,     684.6592f,    1203.0931f,    1642.2089f,    1961.8837f,    2227.3289f,    2421.1348f,    2660.5676f,    3229.5410f,    3822.5837f,    4232.7266f,    4782.5181f,    5127.2612f,    5570.2676f,    5978.9858f,
    287.4206f,     421.3210f,     704.0352f,    1279.8597f,    1562.7307f,    2115.4241f,    2492.4517f,    2780.9470f,    3317.3616f,    3606.1492f,    4026.6375f,    4337.9014f,    4699.6895f,    4997.2573f,    5431.1787f,    5903.8628f,
    487.9554f,     740.9349f,    1021.9616f,    1327.3262f,    1620.8544f,    1890.7717f,    2269.1218f,    2584.4868f,    2911.2896f,    3424.9221f,    3855.1670f,    4205.9272f,    4707.2466f,    5147.1846f,    5601.1152f,    5953.4673f,
    400.8269f,     513.4500f,     786.8242f,    1269.3298f,    1441.4178f,    1696.9789f,    1911.0537f,    2223.0684f,    2847.1619f,    3113.3845f,    3670.6318f,    4146.2900f,    4555.9204f,    5083.8579f,    5574.8120f,    5987.6030f,
    379.0329f,     487.7222f,     914.8179f,    1130.9854f,    1430.1394f,    1830.0769f,    2088.8796f,    2613.6855f,    2803.1633f,    3457.1777f,    4032.6118f,    4306.7344f,    4662.6899f,    4959.6348f,    5245.5234f,    5787.3940f,
    340.6941f,     451.0338f,     656.2767f,     911.5805f,    1124.9330f,    1733.8730f,    2518.7861f,    2768.6851f,    3211.3733f,    3717.7583f,    3929.6772f,    4176.2993f,    4522.4517f,    5011.5547f,    5575.8784f,    6006.7222f,
    341.5027f,     441.6417f,     807.2695f,    1060.2080f,    1251.2837f,    1478.9895f,    1750.0796f,    2594.8977f,    2924.5027f,    3401.4751f,    3852.0557f,    4292.4683f,    4718.2930f,    5159.4775f,    5562.4067f,    5972.5571f,
    313.8985f,     421.5380f,     667.2407f,     873.6023f,    1110.1119f,    2060.7332f,    2381.0916f,    2746.2288f,    3080.5649f,    3399.9905f,    3897.5884f,    4434.9990f,    5048.1343f,    5390.8149f,    5744.3931f,    6007.9326f,
    252.1832f,     354.2392f,     673.5427f,    1339.1161f,    1554.8853f,    2014.9351f,    2300.4138f,    2829.6182f,    3213.1714f,    3409.5105f,    3604.3242f,    3927.8020f,    4622.3218f,    5103.4565f,    5559.5024f,    5971.5986f,
    385.2648f,     513.7607f,     760.7678f,     983.5819f,    1175.7727f,    2134.7810f,    2592.9614f,    2822.0161f,    3232.2524f,    3445.3516f,    3750.7583f,    4094.6714f,    4401.5830f,    4753.4204f,    5549.2319f,    6034.7148f,
    220.6833f,     314.5706f,     622.2172f,    1350.8225f,    1785.5879f,    2077.5837f,    2504.2158f,    3057.6992f,    3436.0974f,    3695.2976f,    3953.4272f,    4267.8701f,    4660.6865f,    5073.6831f,    5501.9478f,    5929.9780f,
    207.8814f,     310.4071f,     646.2098f,    1270.5835f,    1542.7271f,    2079.3804f,    2440.0339f,    2843.4690f,    3272.4854f,    3657.9851f,    4061.2014f,    4444.9780f,    4841.6060f,    5224.5947f,    5620.9141f,    5972.7261f,
    326.1488f,     456.7737f,     740.3350f,     961.4597f,    1262.7579f,    2190.7178f,    2483.5300f,    2872.4180f,    3328.4910f,    3811.0334f,    4153.1602f,    4441.8271f,    4801.1802f,    5065.2988f,    5381.6309f,    5693.2886f,
    206.2046f,     328.0855f,     618.9507f,     980.9994f,    1695.9775f,    1982.3051f,    2275.5444f,    2806.0271f,    3269.5178f,    3491.2456f,    3722.1775f,    4145.9121f,    4843.1167f,    5266.8677f,    5656.8794f,    5992.1201f,
    308.1086f,     407.7706f,     806.7985f,    1045.7629f,    1401.8912f,    2108.3472f,    2331.7849f,    2952.5391f,    3174.1865f,    3374.0686f,    3645.4260f,    4292.7183f,    4939.2969f,    5250.4829f,    5607.2358f,    5932.8657f,
    267.5990f,     378.7492f,     642.2629f,     871.7917f,    1691.7523f,    2087.5117f,    2423.1462f,    2686.1487f,    3021.7893f,    3724.0247f,    4035.5454f,    4369.5903f,    4680.1167f,    4991.4175f,    5323.6875f,    5811.7471f,
    312.3856f,     437.4281f,     714.5340f,     899.5771f,    1632.7545f,    1938.5369f,    2295.5544f,    2625.6189f,    2900.5576f,    3295.4934f,    3557.1260f,    3960.1123f,    4731.6079f,    5141.8447f,    5502.7793f,    5954.0049f,
    332.2842f,     449.0976f,     875.9957f,    1206.1912f,    1422.6793f,    2097.5745f,    2354.2483f,    2715.8494f,    3093.4697f,    3344.5132f,    3623.4814f,    3889.3655f,    4256.2002f,    4994.5742f,    5593.8428f,    5985.9575f,
    286.9586f,     434.7701f,     781.3996f,    1248.3495f,    1835.5530f,    2137.1155f,    2573.7449f,    2869.9299f,    3126.0564f,    3459.1448f,    3769.4475f,    4138.3076f,    4688.0298f,    5084.9028f,    5436.8086f,    5894.2520f,
    327.0000f,     429.0804f,     663.7327f,     849.7463f,    1174.9340f,    2383.3875f,    2695.9597f,    2941.2026f,    3214.4724f,    3433.6287f,    3778.9312f,    4134.8096f,    4504.8022f,    5066.7559f,    5599.2290f,    5985.7334f,
    244.4052f,     499.2254f,    1294.8232f,    1689.3677f,    2123.5024f,    2572.4958f,    3042.9067f,    3446.8752f,    3836.3740f,    4175.6729f,    4485.3213f,    4792.3755f,    5094.9077f,    5386.1816f,    5699.6411f,    6008.2114f,
    561.9757f,    1020.3204f,    1494.1995f,    1841.8171f,    2297.0906f,    2772.6184f,    3204.8804f,    3565.8628f,    3935.4106f,    4253.4141f,    4559.7021f,    4849.9653f,    5140.2852f,    5428.6934f,    5731.2251f,    6023.5078f,
    581.6182f,    1053.5670f,    1478.5878f,    1784.4789f,    2125.1157f,    2454.5889f,    2809.0256f,    3141.7256f,    3490.7529f,    3848.5923f,    4201.7271f,    4568.7720f,    4945.9619f,    5288.6289f,    5647.7642f,    5981.9341f,
    258.9683f,     364.0963f,     722.5463f,    1763.2114f,    1969.3870f,    2265.5239f,    2532.1821f,    2883.3557f,    3388.1838f,    3725.3120f,    4080.9338f,    4390.3818f,    4716.3599f,    5068.4941f,    5452.2778f,    5847.1401f,
    271.5428f,     401.4228f,     695.5894f,     857.3072f,    1776.5358f,    2008.5603f,    2554.4143f,    2844.4021f,    3018.6877f,    3226.1279f,    3482.3398f,    3810.6858f,    4549.3071f,    5266.2764f,    5614.6157f,    5945.6904f,
    330.3132f,     444.6271f,     669.0279f,     874.5479f,    1102.9247f,    2052.1780f,    2436.2378f,    2711.1165f,    3037.7537f,    3298.2036f,    3898.6858f,    4241.5415f,    4606.7637f,    5086.6919f,    5569.7397f,    5988.6797f,
    232.3014f,     344.5512f,     578.5155f,    1213.9569f,    1880.9729f,    2105.6685f,    2335.4148f,    2550.3965f,    3147.6501f,    3491.9253f,    3791.5613f,    4159.6694f,    4642.2441f,    5103.3340f,    5605.4106f,    5989.7969f,
    346.3687f,     444.8047f,     714.3775f,     889.1195f,    1211.8463f,    2168.7598f,    2430.2490f,    2760.6326f,    3012.4961f,    3268.8750f,    3565.1558f,    4172.5791f,    4781.5391f,    5127.6704f,    5512.6323f,    5911.3779f,
    398.0477f,     553.8537f,     845.8521f,    1119.3066f,    1309.7244f,    1928.3351f,    2351.2095f,    2649.8230f,    3050.6750f,    3297.0566f,    3592.7275f,    3916.1785f,    4723.3325f,    5318.1221f,    5703.9697f,    5996.7651f,
    371.4409f,     471.0789f,     896.4924f,    1197.7544f,    1400.8007f,    1611.1555f,    1867.3550f,    2818.4475f,    3002.5906f,    3250.1440f,    3546.5891f,    4265.0371f,    4890.3369f,    5274.4722f,    5659.3560f,    5946.9644f,
    330.9331f,     448.7211f,     808.3973f,     978.2021f,    1652.6361f,    1969.0725f,    2357.0146f,    2680.4792f,    2859.9165f,    3078.9578f,    3423.6895f,    4233.3169f,    4856.7813f,    5086.5723f,    5393.9961f,    5938.6035f,
    323.9659f,     433.8731f,    1045.5168f,    1369.1907f,    1561.9178f,    1984.2457f,    2224.0959f,    2747.3657f,    2995.0359f,    3242.9248f,    3501.0344f,    4022.2388f,    4847.4985f,    5210.9922f,    5658.1357f,    6005.0718f,
    354.6574f,     501.6520f,     852.5305f,    1020.8707f,    1540.5925f,    1998.5675f,    2253.1487f,    2845.3960f,    3056.5273f,    3305.0466f,    3954.2900f,    4591.7471f,    4915.2856f,    5221.9082f,    5544.7285f,    5879.9150f,
    363.1311f,     474.7310f,     907.5490f,    1106.8586f,    1367.2662f,    1646.6934f,    2031.3650f,    2326.4382f,    2568.6519f,    3030.1091f,    3905.6482f,    4265.9111f,    4716.1831f,    5017.0454f,    5469.8149f,    5958.6182f,
    379.9262f,     524.4459f,     845.4813f,    1275.4414f,    1458.2488f,    1772.5863f,    2067.7981f,    2526.8850f,    3066.4063f,    3307.8713f,    3807.2900f,    4199.1509f,    4452.4653f,    4854.7471f,    5464.8833f,    5947.7842f,
    371.8218f,     483.9148f,     778.2747f,    1208.0812f,    1366.3983f,    1623.4895f,    1798.8777f,    2224.6445f,    3103.7175f,    3386.0408f,    3782.8284f,    4307.4727f,    4698.8994f,    5118.1255f,    5505.1919f,    5921.1724f,
    217.9059f,     323.3224f,     639.7305f,    1026.5331f,    1312.9242f,    1885.6948f,    2361.8403f,    2805.5396f,    3213.2600f,    3631.5017f,    4033.4087f,    4426.3423f,    4821.3203f,    5208.3833f,    5590.5205f,    5956.1538f,
    211.9971f,     311.2018f,     504.6345f,     858.3289f,    1574.7019f,    1934.9866f,    2381.4163f,    2786.2043f,    3238.9326f,    3611.0518f,    4005.2578f,    4401.0615f,    4802.1479f,    5192.5493f,    5587.1479f,    5965.5977f,
    219.3884f,     319.3835f,     604.0102f,    1114.8630f,    1481.3870f,    2036.0469f,    2303.4883f,    2616.1384f,    3253.6335f,    3556.5107f,    3946.6567f,    4520.3555f,    5091.0479f,    5416.3037f,    5748.5737f,    5946.5757f,
    350.3716f,     515.4462f,     756.5206f,    1061.4270f,    1251.9570f,    1723.2751f,    2687.6689f,    3036.2019f,    3273.9678f,    3744.2939f,    4098.6284f,    4391.4160f,    4917.6777f,    5244.2852f,    5551.4976f,    5880.1572f,
    311.6069f,     458.7317f,     795.9418f,     969.5021f,    1511.2507f,    1952.5673f,    2273.6116f,    2795.8657f,    3049.7053f,    3578.0598f,    3911.1873f,    4327.2598f,    4735.3105f,    5122.3423f,    5479.7817f,    5858.1504f,
    267.8399f,     390.6757f,     886.2357f,    1179.5110f,    1466.6409f,    2088.7725f,    2328.1262f,    2993.5786f,    3283.5256f,    3593.2822f,    4095.7588f,    4500.4009f,    4887.5132f,    5219.0859f,    5553.4224f,    5915.6831f,
    279.2209f,     413.3200f,     648.4438f,    1282.1798f,    1793.2556f,    1952.1060f,    2484.9436f,    2857.3630f,    3077.2114f,    3548.2585f,    4045.4526f,    4309.5947f,    4760.2900f,    5208.1948f,    5620.9717f,    5968.3237f,
    306.2321f,     424.7843f,     618.7867f,    1288.7572f,    2110.7849f,    2346.5396f,    2582.5366f,    2833.5730f,    3074.3774f,    3464.7886f,    3984.6379f,    4262.0337f,    4601.5132f,    4999.6992f,    5498.8926f,    5920.4814f,
    259.2613f,     353.6931f,     762.5328f,    1906.2162f,    2088.1213f,    2317.9741f,    2546.5935f,    2880.3687f,    3332.0002f,    3636.9216f,    3946.4287f,    4226.0356f,    4502.1084f,    5007.0601f,    5496.4824f,    5924.8877f,
    244.3871f,     357.0287f,    1114.7865f,    1651.1329f,    1850.2976f,    2200.5942f,    2484.7026f,    2872.6968f,    3092.8455f,    3373.5869f,    3707.5891f,    4180.1289f,    4603.5298f,    5132.2671f,    5554.7617f,    5973.5220f,
    700.5439f,    1363.5277f,    1745.2494f,    2081.9539f,    2379.8628f,    2623.6003f,    2883.6484f,    3133.9824f,    3457.7092f,    3819.0100f,    4191.0537f,    4547.0400f,    4912.5127f,    5241.3423f,    5594.9395f,    5930.6099f,
    268.7704f,     370.8200f,     609.4679f,    1558.5339f,    1961.6279f,    2155.8916f,    2419.4485f,    2655.5103f,    3152.6685f,    3426.9221f,    3716.8181f,    4107.1616f,    4965.5698f,    5384.2026f,    5706.7183f,    6015.6196f,
    305.7638f,     395.9599f,    1103.0944f,    1383.6494f,    1612.9742f,    1915.2496f,    2189.8008f,    2555.3608f,    2720.8220f,    3038.2434f,    3927.1301f,    4263.0518f,    4685.7217f,    4984.1377f,    5272.6162f,    5984.5376f,
    294.0385f,     426.7762f,     814.5162f,    1056.9037f,    1715.3539f,    2005.3177f,    2316.4392f,    2647.4297f,    2893.8242f,    3196.7476f,    3720.0044f,    4186.9790f,    4840.4512f,    5290.1250f,    5684.2139f,    5967.5859f,
    359.5141f,     517.6051f,     807.4898f,    1143.5930f,    1328.1393f,    1814.7098f,    2309.8894f,    2618.8655f,    3160.5962f,    3445.0479f,    3883.2664f,    4235.5200f,    4718.7324f,    5367.3608f,    5765.9331f,    6034.9233f,
    241.5752f,     375.5109f,     818.8776f,    1298.7773f,    1656.9050f,    2169.8962f,    2565.1440f,    3015.9919f,    3437.9463f,    3863.8203f,    4254.4023f,    4637.0952f,    5027.8252f,    5358.3784f,    5685.5000f,    5980.4063f,
    322.5406f,     454.9644f,     963.3659f,    1513.8885f,    1704.5070f,    2235.6599f,    2523.6467f,    2995.0757f,    3287.8682f,    3552.8811f,    3872.4360f,    4201.2227f,    4571.9087f,    5066.6792f,    5562.1206f,    5935.7900f,
    412.5748f,     615.8419f,    1126.9519f,    1455.5172f,    1653.3076f,    1965.2689f,    2240.6904f,    2672.5129f,    3127.3301f,    3477.8540f,    3983.6145f,    4458.6558f,    4896.7998f,    5237.9814f,    5609.1597f,    5939.6416f,
    342.1361f,     470.6100f,     958.3576f,    1195.0166f,    1426.4667f,    1684.2009f,    2194.0950f,    2545.9453f,    2946.1851f,    3415.2820f,    3657.4158f,    4408.6763f,    5097.2251f,    5404.2202f,    5719.9829f,    5977.7959f,
    297.8767f,     386.6347f,    1095.8346f,    1454.3085f,    1651.6417f,    1927.9633f,    2198.4927f,    2583.1694f,    2757.0144f,    3009.6497f,    3310.9514f,    3956.9753f,    4677.3208f,    5122.2222f,    5539.0688f,    5993.0542f,
    334.7170f,     450.1582f,     747.3162f,    1560.2024f,    1808.2147f,    2006.5011f,    2415.2419f,    2680.1956f,    3016.5549f,    3651.1340f,    3975.3625f,    4209.6563f,    4531.0396f,    5121.7212f,    5585.2202f,    5962.3667f,
    256.4101f,     495.5723f,    1341.4860f,    1805.1255f,    2201.8318f,    2514.7769f,    2820.4092f,    3102.3867f,    3414.3872f,    3754.7742f,    4108.2378f,    4465.9258f,    4857.4355f,    5216.2144f,    5592.3076f,    5951.9995f,
    530.7974f,    1017.4255f,    1463.9575f,    1858.6631f,    2360.1265f,    2770.3811f,    3106.0894f,    3379.1919f,    3647.7175f,    3895.9026f,    4188.8652f,    4522.8984f,    4893.7954f,    5241.4312f,    5623.8994f,    5975.3608f,
    597.1553f,    1198.0758f,    1722.7361f,    2128.6658f,    2519.1504f,    2825.5122f,    3086.1943f,    3330.0283f,    3608.2961f,    3906.9929f,    4241.8105f,    4603.1694f,    4972.8159f,    5308.1670f,    5651.1968f,    5976.6704f,
    699.1581f,    1293.3193f,    1637.3395f,    1912.7987f,    2163.3445f,    2425.7944f,    2704.0396f,    3006.5984f,    3358.2126f,    3746.1548f,    4125.0762f,    4489.7485f,    4854.0088f,    5188.5146f,    5558.2056f,    5913.3164f,
    489.0107f,     921.4806f,    1329.8511f,    1644.8383f,    2013.6794f,    2365.2683f,    2746.1553f,    3085.6912f,    3457.0234f,    3825.2183f,    4203.4224f,    4575.9331f,    4950.6606f,    5298.7559f,    5659.8618f,    5997.0015f,
    230.3653f,     389.8415f,     938.1970f,    1294.3594f,    1768.8275f,    2189.1001f,    2597.3755f,    2985.8518f,    3323.6023f,    3705.8533f,    4065.5361f,    4446.4224f,    4818.4502f,    5185.9634f,    5583.2168f,    5954.2573f,
    283.9404f,     400.2146f,     630.6198f,    1491.5646f,    2295.1375f,    2496.3457f,    2726.5803f,    2971.1951f,    3207.2317f,    3634.5439f,    4178.0376f,    4423.5537f,    4836.2109f,    5172.1821f,    5464.0454f,    5777.5801f,
    242.6232f,     351.1541f,     807.9852f,    1621.9950f,    2043.8676f,    2532.5122f,    2860.5505f,    3200.3403f,    3499.8274f,    3760.3772f,    4068.9617f,    4410.7339f,    4778.8413f,    5153.0142f,    5553.1997f,    5932.5996f,
    227.3320f,     323.2667f,     752.3189f,    1572.3750f,    1930.6083f,    2355.0117f,    2717.6223f,    2968.3215f,    3233.4026f,    3551.9622f,    3918.5608f,    4346.0190f,    4778.6880f,    5159.6172f,    5568.5566f,    5980.8086f,
    307.9120f,     439.7297f,     660.0276f,    1243.3854f,    1532.3577f,    1796.3936f,    2437.3232f,    2691.4072f,    3030.3025f,    3524.1379f,    3771.7576f,    4083.2375f,    4601.1567f,    4963.4697f,    5434.8530f,    5942.8315f
};

const float lsf_cdk_nb_gc_stg1[] =
{
    -50.2820f,     -20.3699f,     -85.9016f,    -168.2552f,    -219.7203f,    -228.3721f,    -209.7385f,    -115.7139f,     -70.1936f,       2.9143f,      53.7331f,     204.0881f,     324.2565f,     283.0311f,     194.2415f,      55.6127f,
    -7.7024f,      55.3216f,      40.0302f,      -2.6173f,     -31.0254f,     -49.9638f,     -89.5104f,     -79.9710f,    -100.2947f,     -84.2426f,     -89.8130f,     -44.4505f,       8.1330f,     123.3018f,     115.2609f,      17.5947f,
    -29.7454f,      23.9522f,      -6.6145f,     -47.3088f,     -83.6021f,    -109.3905f,    -118.2556f,     -70.7910f,     -71.2423f,     -49.5609f,     -49.3213f,       0.8054f,      70.8270f,     167.7499f,     132.1748f,      26.7946f,
    -46.7868f,      21.9789f,      17.0331f,       1.6574f,      -5.3416f,      -1.5485f,     -24.7294f,      -2.2697f,     -36.0918f,     -31.9601f,     -52.9409f,     -18.2356f,     -16.6137f,      52.8291f,      99.2958f,       9.2780f,
    -48.8451f,      -8.8573f,     -49.2111f,     -93.0997f,    -116.0209f,    -119.2193f,    -130.6934f,     -90.0435f,     -85.8524f,     -49.9080f,     -30.8948f,      57.8291f,     207.6663f,     238.5938f,     162.1688f,      42.1291f,
    6.0599f,      96.6534f,      89.7254f,      64.7391f,      47.1759f,      39.3332f,       3.8599f,      12.1104f,     -25.8483f,     -30.7162f,     -54.9950f,     -24.3625f,     -65.0093f,     -91.8893f,      41.2788f,      -9.3500f,
    -74.6215f,     -34.1444f,     -45.1607f,     -35.7601f,      20.1298f,      61.8053f,      45.9485f,      61.3004f,      23.1269f,      17.0184f,     -14.6351f,      11.5369f,      40.6714f,     134.6762f,     127.4157f,      23.2286f,
    -53.8382f,      -7.1967f,      51.3428f,     149.2781f,     132.0314f,     106.9591f,      40.3082f,      28.7839f,     -20.0071f,     -32.1960f,     -69.3754f,     -44.7267f,     -19.1058f,      81.8775f,     103.3263f,      11.7826f,
    -83.4690f,     -58.9994f,    -100.6923f,    -109.7423f,     -77.3123f,     -51.0569f,     -49.0334f,     -11.2254f,     -13.7028f,      11.7115f,      17.4433f,     113.4333f,     269.5462f,     270.9727f,     181.4436f,      50.9590f,
    19.0904f,     106.4309f,      78.2419f,      22.1934f,     -28.2661f,     -71.6118f,     -97.8980f,     -57.5252f,     -73.2944f,     -59.0236f,     -70.7380f,     -30.7879f,     -16.6118f,      71.0734f,     102.1686f,      10.6722f,
    -44.5958f,       9.5910f,      -9.9670f,     -35.4491f,     -36.7779f,     -38.2726f,     -71.5033f,     -56.3692f,     -75.3217f,     -60.2630f,     -64.3206f,     -15.0396f,      51.1008f,     156.1136f,     128.1305f,      24.1397f,
    -26.8342f,      50.7102f,      47.9495f,      34.1131f,      33.1750f,      40.6004f,       1.8381f,       6.9380f,     -34.5476f,     -37.5681f,     -63.3813f,     -32.2824f,     -50.5980f,     -25.5098f,      69.6276f,      -1.2117f,
    6.7027f,      67.8112f,      38.0872f,     -23.7302f,     -79.0851f,    -119.7724f,    -146.1929f,    -104.8024f,    -107.0018f,     -86.5365f,     -75.9935f,     -16.8613f,      84.1440f,     178.1427f,     133.5219f,      27.8811f,
    46.6789f,     157.1987f,     135.6186f,      86.3393f,      50.7338f,      16.6195f,     -30.7043f,     -23.0751f,     -58.4989f,     -58.2831f,     -83.9640f,     -51.4746f,     -40.3803f,      39.6990f,      89.0926f,       5.3683f,
    -66.8068f,     -25.7930f,     -49.4702f,     -55.7445f,     -47.4219f,     -47.2327f,     -55.9657f,     -21.6380f,     -32.0155f,     -16.3766f,     -23.1897f,      25.9724f,     108.6076f,     192.8678f,     143.8874f,      32.5168f,
    -29.4610f,      51.1883f,     125.8174f,     178.0158f,     192.4019f,     200.6733f,     150.3214f,     139.0109f,      70.5642f,      49.0546f,       5.2967f,      10.7600f,     -32.3233f,     -56.1770f,      38.7244f,      -6.3720f,
    -90.7935f,     -86.8579f,    -165.1847f,    -206.9982f,    -177.3116f,    -110.7218f,     -60.4555f,      28.9968f,      59.3721f,     111.7430f,     148.9078f,     297.0840f,     382.8354f,     319.0586f,     217.5980f,      66.9906f,
    -8.8907f,      51.2038f,      20.6150f,     -25.0275f,      -6.4919f,      28.5998f,     -19.2903f,     -28.0775f,     -67.6854f,     -70.6924f,     -91.1332f,     -51.9799f,       4.7191f,     121.9776f,     114.5332f,      16.9555f,
    -29.5779f,      38.1348f,      16.9460f,     -13.1717f,     -43.7665f,     -58.5053f,     -66.8853f,     -23.5223f,     -47.7123f,     -38.4358f,     -52.6004f,     -12.1781f,      -9.5310f,      62.0772f,     102.4962f,      10.5329f,
    -51.3839f,      10.1170f,       8.8413f,       7.1799f,      27.0856f,      57.8446f,      40.2151f,      55.8005f,      14.1522f,       8.5107f,     -25.3037f,      -4.1035f,     -34.2602f,     -19.2221f,      74.9812f,       1.2982f,
    -9.0629f,      39.9632f,      -4.2048f,     -68.4062f,    -125.5652f,    -168.4946f,    -200.3423f,    -148.8132f,    -131.2517f,     -83.3627f,     -43.4004f,      70.8276f,     231.0238f,     241.4682f,     165.0121f,      42.8259f,
    23.0736f,     143.9185f,     165.8485f,     141.1318f,     126.9031f,     113.7775f,      58.7625f,      48.6260f,       0.7530f,     -14.8817f,     -51.1437f,     -31.9407f,     -63.3610f,     -68.5826f,      42.2195f,      -8.3010f,
    -64.7372f,     -30.3666f,     -13.8118f,      64.0613f,     130.9271f,     167.6980f,     130.2968f,     120.2481f,      53.8473f,      30.9594f,     -13.2901f,      -0.2919f,     -12.6298f,      33.0601f,      89.8137f,       7.9164f,
    -27.4071f,      46.5739f,      73.0324f,      90.7500f,      97.4257f,     110.0360f,      75.8612f,      77.2110f,      30.1418f,      14.8390f,     -22.5191f,      -7.5352f,     -58.3772f,    -104.3289f,      27.0985f,     -11.5599f,
    -48.6199f,      -8.4983f,     -71.8930f,    -149.9820f,    -149.4210f,     -44.3473f,       3.8456f,      37.8226f,      11.8655f,       4.7745f,     -23.8053f,      15.0402f,      99.2230f,     190.4169f,     143.6005f,      32.2851f,
    15.9306f,      86.2159f,      75.9614f,      40.8587f,      13.8614f,      -5.1135f,     -53.5447f,     -49.2651f,     -83.1781f,     -77.3701f,     -94.7805f,     -58.1423f,     -37.1552f,      59.5436f,      95.8876f,       7.8334f,
    -71.4812f,     -18.0191f,     -10.6353f,     -10.9646f,      -4.7830f,       7.0689f,      -8.9645f,      17.0751f,      -8.9055f,      -4.5033f,     -26.7167f,       6.5207f,      41.1034f,     136.7648f,     126.6881f,      22.6529f,
    -13.3071f,      67.8215f,      50.5701f,      22.0055f,      -0.1895f,     -16.2081f,     -44.2669f,     -15.2243f,     -42.5961f,     -37.7900f,     -54.1335f,     -14.8001f,     -44.7622f,     -39.3502f,      68.9017f,      -1.9700f,
    54.4719f,     135.4882f,     107.6822f,      37.1723f,     -15.7729f,     -58.2111f,    -117.6718f,    -111.5628f,    -125.9742f,     -95.3344f,     -71.1785f,      20.4405f,     178.9972f,     225.0608f,     154.3984f,      37.7039f,
    199.1418f,     301.5473f,     242.3446f,     156.1444f,     129.3343f,     112.5769f,      60.9076f,      24.7294f,     -36.1788f,     -44.7856f,     -49.6138f,      35.8621f,     132.4271f,     180.8326f,     145.9355f,      30.7412f,
    -95.8307f,     -73.4794f,     -76.3260f,     -32.8480f,      25.0377f,      53.0367f,      47.9260f,      71.8612f,      48.9617f,      48.0805f,      31.5298f,      92.4644f,     215.5727f,     252.6642f,     172.3081f,      47.3738f,
    -2.1387f,     144.6784f,     257.4241f,     293.7984f,     302.9054f,     301.4404f,     234.6555f,     199.2878f,     117.8049f,      82.4572f,      28.1316f,      27.9394f,     -20.8952f,     -53.5108f,      47.9862f,      -3.2292f
};

const float lsf_cdk_nb_gc_stg2[] =
{
    -11.7897f,     -34.0201f,     -78.3915f,     -67.4130f,      11.6646f,      27.0897f,
    -25.4365f,     -16.9519f,       1.3623f,     -14.4721f,     -40.8934f,     -28.8082f,
    -17.5541f,     -24.8863f,     -42.0546f,     -57.4396f,     -48.2462f,     -17.3640f,
    -23.4838f,     -18.0105f,     -23.4463f,     -23.8641f,      20.1374f,      22.8944f,
    -27.9673f,     -51.2149f,     -32.0136f,      58.4191f,      66.0445f,      33.8922f,
    -28.8229f,     -24.7667f,      12.6486f,      32.0241f,      14.4964f,       5.0635f,
    11.7718f,      12.7508f,     -18.2755f,     -64.0918f,     -88.2808f,     -46.2724f,
    11.7478f,      -4.0560f,     -28.8370f,     -15.2873f,     -17.0688f,     -21.2716f,
    21.1704f,       4.6685f,     -15.1944f,      19.2773f,      48.9464f,      24.7768f,
    -31.9223f,     -48.4027f,     -40.5826f,      -2.3521f,      -7.7634f,      -9.3639f,
    49.8116f,      38.9864f,      -9.6274f,     -43.4792f,     -14.3368f,       6.7127f,
    -17.8859f,      16.5261f,      17.9780f,     -18.2431f,      -4.9259f,       4.9691f,
    34.1057f,      28.5456f,      37.3357f,      25.9730f,     -12.0323f,     -14.3174f,
    -35.7203f,     -11.7712f,      71.0202f,      87.9962f,      53.5089f,      22.0342f,
    -29.0835f,       7.8202f,      61.7147f,      30.4243f,      -7.0096f,     -12.3327f,
    121.0591f,     124.7827f,      86.3632f,      52.5283f,      25.7588f,       2.2977f
};

const float lsf_cdk_nb_gc_stg3[] =
{
    -20.1057f,     -62.1359f,     -90.9211f,     -83.2088f,     -41.8080f,       4.3801f,      64.9293f,      55.2259f,      18.8953f,       8.4560f,
    -12.4851f,     -29.8479f,     -46.3014f,     -59.0597f,     -57.9280f,     -55.5646f,     -16.2912f,      29.7501f,       6.4438f,       1.9289f,
    -42.4234f,     -57.2848f,     -42.1410f,     -25.0914f,     -20.5850f,     -22.9466f,     -28.6753f,      -9.5206f,      -2.8536f,      -2.4606f,
    2.9437f,      -3.2337f,     -19.4418f,     -30.8279f,     -40.2200f,     -54.7107f,     -69.2608f,     -36.5696f,     -14.6763f,      -7.4390f,
    56.9685f,      42.9405f,       2.6357f,     -28.9316f,     -41.7842f,     -41.1244f,       7.2469f,      37.7725f,       9.4299f,       3.8716f,
    -13.4056f,     -11.0915f,      -7.8932f,      -4.4242f,      -3.6432f,      -6.2205f,     -52.2374f,    -101.3244f,     -31.8836f,     -12.9959f,
    -49.5845f,     -68.9839f,     -40.9861f,      -4.8425f,      25.7585f,      49.5206f,      52.3506f,      42.0803f,      18.1566f,       7.3750f,
    7.9175f,      30.0116f,      39.2961f,      39.8519f,      33.8428f,      18.7027f,     -42.1156f,    -114.4817f,     -41.9139f,     -14.3475f,
    -10.3140f,     -13.1813f,      -8.6771f,     -12.5086f,      -7.9996f,       8.1476f,      62.8062f,      70.2916f,      23.1315f,      10.3555f,
    7.8827f,      -9.7751f,     -27.3751f,     -19.0843f,      -3.1083f,       5.0911f,      -8.9477f,      -1.9864f,      -0.0476f,      -1.0431f,
    -25.6990f,      -1.3466f,      13.9307f,      -1.5450f,     -21.5161f,     -36.5054f,     -27.3657f,       9.1052f,       0.5716f,      -0.5675f,
    26.0226f,      39.0806f,      25.3016f,      10.6567f,      -7.6451f,     -27.7012f,     -57.9450f,     -49.0041f,     -17.4613f,      -8.2350f,
    24.7306f,      40.5991f,      39.1729f,      32.6364f,      20.0500f,       9.7588f,      17.8440f,      32.3000f,      10.7014f,       4.0975f,
    -31.9825f,     -23.6145f,      19.2348f,      43.8139f,      32.4545f,      14.8018f,     -12.9031f,     -14.2377f,      -3.4099f,      -2.2026f,
    17.4813f,      29.7370f,      40.6045f,      56.0407f,      77.3266f,     109.6360f,     126.9981f,      90.0105f,      41.2847f,      18.3934f,
    62.0530f,      98.1263f,     103.5605f,      86.5243f,      56.8051f,      24.7345f,     -16.4333f,     -39.4116f,     -16.3685f,      -5.1868f
};

const float lsf_cdk_nb_vc_stg1[] =
{
    -47.8739f,     -33.3324f,    -111.7403f,    -187.1021f,    -217.8067f,    -211.2333f,    -197.1951f,    -112.5993f,     -54.4085f,      25.6601f,     103.3922f,     273.8963f,     384.4787f,     321.9756f,     214.8825f,      64.7502f,
    5.7213f,      62.0822f,       4.1813f,     -75.3379f,    -130.0791f,    -169.8000f,    -137.2333f,      -8.1913f,       9.1551f,      12.5919f,     -10.2666f,      24.1670f,      78.8903f,     170.0603f,     136.5900f,      28.5131f,
    -61.2759f,     -38.8420f,     -92.0781f,    -106.8447f,     -84.5683f,     -75.2343f,     -90.1177f,     -57.8575f,     -57.3309f,     -23.0973f,      -6.5859f,      96.8941f,     263.0488f,     266.3097f,     177.9874f,      48.9404f,
    -4.6756f,      65.2555f,      47.7555f,      30.0066f,      28.7910f,      33.2401f,       1.0363f,      13.6479f,     -20.0856f,     -24.5283f,     -44.3793f,     -10.0354f,     -56.2017f,     -77.3347f,      55.5984f,      -6.2838f,
    -40.8653f,     -14.8363f,     -92.0112f,    -175.7323f,    -221.1710f,    -161.1121f,     -52.8429f,      37.5645f,      41.2468f,      45.5229f,      26.4500f,      86.3998f,     219.2824f,     253.3986f,     172.4165f,      46.3912f,
    -35.6673f,      17.5904f,     -11.9410f,     -25.7858f,      -8.8584f,      21.6273f,       0.1729f,       6.5783f,     -34.6991f,     -36.4150f,     -56.0023f,     -21.0789f,     -19.8846f,      54.1067f,      99.1987f,       9.4728f,
    -14.2776f,      27.3931f,     -14.6997f,     -66.6010f,     -99.6813f,    -122.6578f,    -150.2305f,    -113.9728f,    -109.1274f,     -78.9555f,     -60.2257f,      27.8011f,     190.2385f,     229.8084f,     157.2525f,      39.3867f,
    7.6929f,      67.9322f,      38.8456f,     -21.1201f,     -59.7777f,     -99.3488f,    -141.1098f,    -110.2669f,    -114.7237f,     -91.8703f,     -77.7551f,     -15.8694f,      90.5305f,     184.5058f,     136.0935f,      29.0311f,
    -81.2402f,     -78.5803f,    -151.4014f,    -172.9501f,    -128.6324f,     -73.2223f,     -54.4444f,     -10.0382f,       0.8191f,      49.8313f,      85.4796f,     237.9407f,     375.9963f,     320.3293f,     212.6340f,      64.0690f,
    -7.5501f,      56.9796f,      22.4374f,     -12.3837f,     -25.5942f,     -46.4205f,     -67.6393f,     -25.5805f,     -48.1321f,     -39.6622f,     -53.1014f,     -11.2472f,     -23.2435f,      35.6549f,      94.7977f,       6.9705f,
    -35.2312f,       5.7296f,     -40.3538f,     -74.0301f,     -73.9051f,     -78.4101f,     -69.6657f,     -23.5663f,     -38.8351f,     -23.3996f,     -29.2527f,      14.7714f,      60.7441f,     159.3770f,     132.0680f,      26.1624f,
    63.7916f,     158.4710f,     108.6537f,      49.2831f,      12.4814f,     -34.2755f,     -68.0055f,     -38.2006f,     -61.2743f,     -54.7496f,     -73.2102f,     -37.3536f,      -2.8530f,      99.6502f,     109.4658f,      14.7136f,
    -46.8550f,     -17.8951f,     -73.5817f,    -109.9269f,     -59.6995f,      13.9228f,      17.3227f,      37.6147f,       5.2378f,       2.5800f,     -15.0369f,      23.6412f,      86.2658f,     178.2385f,     140.5764f,      30.3354f,
    -64.0179f,     -34.7786f,     -33.8634f,      32.5490f,      41.5821f,      30.0052f,       2.8933f,       7.9098f,     -23.6020f,     -21.4437f,     -40.3389f,      -5.3147f,      46.4389f,     149.8765f,     129.5062f,      24.3633f,
    53.2208f,      88.2962f,      18.1083f,     -68.6983f,    -163.9225f,    -257.5996f,    -286.3273f,    -136.1982f,     -54.0297f,      17.4621f,      96.5930f,     257.5079f,     374.4247f,     316.8143f,     211.5481f,      63.1783f,
    174.9770f,     220.4714f,     114.9514f,      39.1980f,      15.6628f,     -57.4971f,    -151.3537f,    -151.4255f,    -122.5434f,     -39.5915f,      43.3476f,     204.8011f,     347.0733f,     300.8141f,     202.2481f,      58.3570f,
    -24.8002f,       5.5647f,     -51.1305f,    -108.2679f,    -143.4691f,    -168.1934f,    -183.0667f,    -123.7768f,    -105.2566f,     -53.2548f,     -15.6183f,     132.2483f,     301.9698f,     276.6960f,     185.6425f,      51.4215f,
    63.0767f,      97.9030f,      23.3427f,     -27.8271f,      -7.6827f,      11.5110f,      -9.1648f,     -16.5310f,     -60.2418f,     -68.6020f,     -79.4697f,      -9.9630f,     143.1208f,     212.2018f,     148.4344f,      34.8853f,
    -52.8577f,     -17.0901f,     -38.4446f,     -44.4913f,     -48.3650f,     -49.3479f,     -79.7237f,     -66.0328f,     -77.9226f,     -56.8956f,     -48.1326f,      19.1059f,     138.4749f,     210.3387f,     148.5705f,      35.3026f,
    16.4209f,     102.4966f,     100.9513f,      64.0511f,      50.2873f,      36.1014f,     -21.6103f,     -26.7705f,     -65.0290f,     -62.8056f,     -83.1056f,     -46.5621f,     -51.3341f,       1.7945f,      78.1135f,       1.0912f,
    -75.6609f,     -71.8274f,    -139.7561f,    -117.4244f,     -22.4806f,      39.5285f,      53.1389f,      65.2518f,      36.9996f,      37.9781f,      25.3240f,      92.8186f,     227.9041f,     260.3466f,     176.7927f,      48.2170f,
    -18.6440f,      33.8824f,      28.5803f,      10.9212f,       5.0722f,       4.4072f,     -39.6675f,     -38.3990f,     -75.6662f,     -72.1438f,     -87.2765f,     -46.7029f,      -6.7231f,     107.6602f,     110.8838f,      15.3706f,
    21.3981f,      74.2394f,      19.3760f,     -47.0944f,     -99.2094f,    -138.5254f,    -193.3578f,    -171.5091f,    -176.8980f,    -112.0385f,     -43.8164f,      79.0272f,     251.8247f,     251.6656f,     170.8083f,      44.5524f,
    67.4133f,     149.9282f,     118.6238f,      30.5943f,     -33.2344f,     -70.7200f,    -120.6338f,    -105.4183f,    -118.8368f,     -86.5003f,     -64.0278f,      50.0950f,     231.7671f,     247.4923f,     167.0543f,      43.3706f,
    -40.9878f,     -39.3167f,    -163.9672f,    -281.7721f,    -267.4339f,    -138.3948f,     -88.8411f,       0.7440f,      65.0724f,     165.9769f,     269.7260f,     427.8145f,     485.5638f,     388.7820f,     254.5937f,      84.1430f,
    12.9002f,      76.9394f,      62.5283f,      13.6656f,     -10.4341f,     -35.7194f,     -84.1773f,     -75.4588f,     -98.8663f,     -85.0203f,     -91.0417f,     -43.6094f,       6.1868f,     120.0995f,     114.3634f,      17.2779f,
    -21.4884f,      29.4970f,       1.0910f,     -37.4928f,     -55.1841f,     -66.8253f,     -92.8491f,     -74.1643f,     -90.3904f,     -72.3158f,     -69.6267f,     -16.2943f,      51.2075f,     158.6230f,     128.0881f,      24.5940f,
    140.4902f,     213.5873f,     167.7455f,     102.0038f,      85.7659f,      59.5426f,       9.2403f,      -0.7622f,     -35.6690f,     -35.9801f,     -58.6565f,     -15.1000f,      23.5135f,     101.5155f,     111.5278f,      16.5967f,
    -62.8100f,     -47.2312f,     -97.3130f,     -60.9976f,      82.6761f,     193.9902f,     154.0588f,     118.2896f,      43.6828f,      13.9735f,     -22.6650f,       0.5943f,      26.8732f,     111.3673f,     120.5305f,      20.1022f,
    -44.4747f,     -10.4204f,      32.1805f,     131.3261f,     157.9129f,     155.8841f,      90.2107f,      70.7406f,       9.4064f,      -4.0535f,     -42.4163f,     -26.0150f,     -39.1314f,      20.5559f,      82.2390f,       4.9553f,
    88.4086f,     134.4090f,      60.3778f,     -13.5659f,     -72.1912f,    -160.4579f,    -261.2583f,    -247.6886f,    -121.4628f,     -13.9737f,      35.4003f,     197.3431f,     335.8232f,     294.0672f,     197.4029f,      56.5130f,
    267.3715f,     336.4754f,     224.6896f,     104.9689f,     104.5109f,      94.7971f,     -20.0482f,     -88.9197f,    -142.8754f,     -60.7279f,      30.3207f,     189.5033f,     335.5709f,     295.5561f,     200.0838f,      57.2552f
};

const float lsf_cdk_nb_vc_stg2[] =
{
    -9.6827f,     -17.9738f,     -44.2587f,     -53.7409f,      10.1005f,      32.4057f,
    -29.5803f,     -35.3673f,     -50.3175f,     -49.1053f,     -47.5762f,     -37.2894f,
    -10.3138f,      -3.1171f,       2.9317f,     -20.2045f,     -78.9643f,     -84.6932f,
    13.6252f,       8.7360f,     -21.5126f,     -20.8022f,     -14.8279f,     -30.9676f,
    -28.1089f,     -48.1602f,     -64.6161f,      -0.2872f,     108.6371f,      93.6271f,
    -38.2393f,       1.9703f,      14.1451f,      -7.5949f,      39.2872f,      33.7052f,
    -38.5209f,     -10.1299f,      61.9126f,      45.3993f,      -7.5115f,     -17.0167f,
    26.2164f,      20.2119f,      40.4075f,      45.2381f,      -2.3925f,     -17.4109f,
    -19.1953f,     -10.5024f,      12.6622f,     -19.8408f,     -40.6066f,       1.8757f,
    -32.7274f,     -41.0545f,     -26.1793f,      15.7486f,       1.2783f,     -17.0256f,
    3.5921f,       2.2211f,     -27.0254f,     -81.1776f,     -88.9427f,     -11.1151f,
    48.7753f,      42.6625f,       3.8241f,     -21.1582f,      27.5770f,      36.8815f,
    6.8266f,      -6.1852f,     -19.6226f,      28.9512f,      50.9852f,      15.2853f,
    -33.3786f,     -38.1386f,      24.6782f,      95.1954f,      64.2442f,      33.4105f,
    49.0652f,      49.8207f,      29.3688f,     -11.7891f,     -57.3484f,     -44.4722f,
    91.6464f,      85.0063f,      63.6020f,      55.1679f,      36.0606f,      12.7997f
};

const float lsf_cdk_nb_vc_stg3[] =
{
    -16.5483f,     -67.8691f,    -113.3476f,     -92.9768f,     -18.1549f,      21.7013f,      31.7869f,      25.1431f,       9.0112f,       3.4920f,
    -7.8375f,     -22.7162f,     -45.0895f,     -61.3419f,     -64.4643f,     -67.3643f,     -44.8953f,      -6.2556f,      -7.9342f,      -3.9490f,
    -63.5255f,     -72.6896f,     -45.5471f,     -30.5803f,     -26.8317f,     -24.4668f,     -15.1301f,       4.8754f,      -0.5588f,      -0.8157f,
    -2.2381f,      13.4403f,      16.0097f,       1.0526f,     -24.8448f,     -61.3997f,     -91.3894f,     -39.4637f,     -19.2183f,      -9.1265f,
    -16.0140f,     -32.7087f,     -45.2478f,     -59.4365f,     -60.1819f,     -31.6687f,      70.4575f,      64.2544f,      19.1841f,       9.3201f,
    -8.2141f,       2.4761f,       7.4360f,      11.7049f,      14.0396f,      16.9693f,     -53.7166f,    -119.3159f,     -33.5007f,     -15.4114f,
    -64.5115f,     -52.5888f,      30.5453f,      56.2986f,      31.6535f,       9.3509f,       4.3678f,      13.3055f,       5.1440f,       2.0290f,
    22.3180f,      44.1101f,      48.7477f,      40.2739f,      14.9495f,      -7.3707f,     -10.3082f,       6.3741f,       1.0122f,       0.2673f,
    -42.3440f,     -58.8447f,     -42.2171f,      -8.0384f,      34.3873f,      59.7095f,      50.7660f,      38.7146f,      16.7582f,       7.2512f,
    -0.1088f,     -28.5624f,     -30.3477f,      -2.8206f,      -1.3093f,     -12.9286f,     -21.2371f,      -1.4331f,      -2.6014f,      -1.5170f,
    -41.2001f,       4.7383f,      13.3788f,     -12.5767f,     -22.3489f,     -14.4064f,      10.9753f,      22.2182f,       6.2625f,       2.5488f,
    63.9302f,      51.1717f,      10.5411f,     -23.3105f,     -47.9860f,     -59.1260f,     -29.9675f,       0.0559f,      -4.8774f,      -2.3217f,
    37.1022f,      14.8587f,     -19.5761f,     -23.3122f,       2.3273f,      32.9204f,      53.1779f,      43.4994f,      16.5403f,       7.5156f,
    48.8143f,      82.6708f,      85.7133f,      77.5688f,      56.9332f,      24.0950f,     -63.9412f,    -138.5729f,     -45.8026f,     -17.6440f,
    -4.0024f,      18.2212f,      40.5425f,      57.9095f,      69.5262f,      79.8498f,      71.0971f,      51.3637f,      24.2751f,      10.9558f,
    94.3797f,     104.2925f,      88.4585f,      69.5855f,      42.3052f,      34.1349f,      37.9570f,      35.2368f,      16.3058f,       7.4056f
};

const float lsf_cdk_wb_gc_stg1[] =
{
    -21.1721f,      -6.9787f,     -78.7739f,    -158.7331f,    -205.5198f,    -259.2706f,    -287.6161f,    -271.9965f,    -264.8213f,    -231.0206f,    -194.9294f,    -147.7609f,    -117.1413f,     -85.8077f,     -63.7689f,     -31.4680f,
    -66.9546f,     -30.5144f,     -36.8376f,     -53.0491f,     -36.1642f,     -48.5647f,     -62.2295f,     -55.2760f,     -57.6386f,     -55.8977f,     -55.9952f,     -40.6957f,     -43.2573f,     -33.7185f,     -37.3113f,     -27.4703f,
    -18.0276f,      24.5300f,      -3.1374f,     -40.7788f,     -39.2887f,     -55.1486f,     -87.4694f,     -97.8466f,    -113.0920f,    -112.2454f,    -110.4983f,     -92.0446f,     -80.8734f,     -57.2883f,     -52.4648f,     -39.3426f,
    -14.5043f,      41.4594f,      30.8683f,      19.7189f,      29.0785f,       7.4155f,     -21.7427f,     -23.9321f,     -38.3113f,     -41.2907f,     -40.8309f,     -25.7969f,     -29.7702f,     -20.8620f,     -29.2581f,     -26.0135f,
    -39.7173f,     -14.6068f,     -62.7880f,    -111.0359f,    -122.7799f,    -150.6084f,    -167.3332f,    -164.6087f,    -165.9175f,    -146.9592f,    -135.1085f,    -110.8433f,     -97.6828f,     -72.7079f,     -64.6184f,     -45.5537f,
    -42.5539f,      26.5080f,      31.4593f,       1.2393f,       1.6319f,       6.6465f,      16.6621f,      35.3616f,      33.5966f,      53.0816f,      65.9800f,      78.6870f,      64.5119f,      50.4778f,      20.7076f,       7.5572f,
    -2.4650f,      88.7057f,      93.4778f,      47.6900f,      47.2210f,      51.8796f,      27.4629f,      23.3020f,       8.4560f,      12.2382f,      12.4948f,      25.9549f,      18.2040f,      17.5385f,      -2.2674f,      -6.8910f,
    -25.2995f,      40.1554f,     131.5320f,     193.8438f,     224.6298f,     213.8258f,     187.1185f,     169.5623f,     131.4438f,     108.3838f,      93.4648f,      94.1147f,      68.7427f,      48.9293f,      15.1647f,       1.4396f,
    -63.4604f,     -63.8774f,    -152.1996f,    -247.2777f,    -281.1492f,    -288.1032f,    -252.3883f,    -181.6764f,    -141.4441f,     -90.3039f,     -56.5279f,     -23.8054f,     -11.9068f,      -1.3377f,      -7.5474f,      -0.6953f,
    -77.4333f,     -60.8457f,     -86.6258f,     -86.4012f,     -29.1547f,       7.2174f,      40.0438f,      63.6826f,      53.0035f,      51.5329f,      55.6684f,      68.8552f,      50.7040f,      34.0814f,       7.7594f,      -2.1278f,
    30.9564f,      87.5489f,      69.5663f,      23.2907f,      13.9146f,      -0.9477f,     -37.0125f,     -58.8950f,     -99.1749f,    -117.9716f,    -127.4967f,    -107.3465f,     -91.7610f,     -62.6527f,     -50.4613f,     -32.9533f,
    -64.2954f,     -37.5670f,     -21.0138f,      41.6351f,     121.9423f,     170.7496f,     195.4955f,     225.2859f,     224.2241f,     223.8838f,     222.3937f,     225.7590f,     188.7341f,     143.2967f,      83.3796f,      41.8113f,
    10.6654f,      55.4135f,      18.0177f,     -53.2381f,     -88.7693f,    -114.5825f,    -122.2372f,    -110.6857f,    -120.7652f,    -124.3872f,    -136.2432f,    -135.4537f,    -132.9560f,    -104.3421f,     -82.6202f,     -57.8286f,
    -56.8219f,      -2.2176f,       4.5106f,       4.9045f,      63.5084f,      94.3949f,      92.6963f,      98.2198f,      78.5731f,      65.0247f,      60.8502f,      70.0685f,      53.4160f,      34.2990f,       2.3436f,     -13.6945f,
    62.5259f,     160.0315f,     153.0699f,     116.3367f,      94.9113f,      59.6879f,      36.7834f,      42.8554f,      34.9832f,      32.1663f,      34.2612f,      46.5764f,      32.6032f,      22.8721f,      -2.2313f,      -9.0276f,
    -17.8885f,      81.5994f,     153.8725f,     203.3483f,     260.8972f,     308.2464f,     337.7084f,     369.5280f,     355.1932f,     340.5538f,     332.7582f,     318.9620f,     261.2268f,     196.0706f,     116.6797f,      63.9204f,
    20.6478f,      57.4084f,       3.7268f,     -83.6103f,    -145.3750f,    -207.9262f,    -235.3695f,    -209.9292f,    -200.7669f,    -173.1530f,    -148.7498f,    -120.9027f,    -110.3875f,     -91.3718f,     -83.8093f,     -58.7850f,
    -39.9125f,      14.8531f,      -3.7779f,     -42.3801f,     -47.0086f,     -54.0654f,     -37.4186f,      -7.7530f,      -2.3503f,      11.8227f,      22.9690f,      37.9258f,      31.1117f,      26.1390f,       3.9131f,      -4.7425f,
    13.2679f,      79.8638f,      51.3108f,     -15.0032f,     -39.4744f,     -78.1680f,     -87.2337f,     -58.9813f,     -51.8486f,     -39.6199f,     -34.6732f,     -22.2829f,     -24.1548f,     -18.6608f,     -25.3619f,     -24.4411f,
    -31.4295f,      11.0108f,      63.6155f,     150.7589f,     166.6739f,     132.7679f,      86.6371f,      71.7386f,      36.6906f,      13.2914f,      -2.6491f,       5.5439f,     -13.1750f,     -13.8798f,     -27.3878f,     -22.3777f,
    -24.3473f,      16.7839f,     -21.6102f,     -77.9093f,    -107.7952f,    -144.9666f,    -139.6022f,     -95.3828f,     -79.5686f,     -54.4138f,     -40.2750f,     -17.7668f,     -12.9124f,      -7.1218f,     -21.3606f,     -21.7144f,
    -3.0221f,      85.8766f,      60.9027f,      16.5821f,       7.9817f,     -16.4117f,     -11.2119f,      17.4948f,      20.8488f,      33.8053f,      43.5158f,      54.6661f,      45.1287f,      38.3086f,      11.1080f,       2.6446f,
    6.4417f,     122.4950f,     125.6148f,      93.2892f,     108.5553f,     111.2156f,     105.3841f,     113.7573f,     102.0970f,     107.1194f,     105.9578f,     110.0393f,      89.3394f,      67.9986f,      28.3953f,      10.5845f,
    5.3008f,     132.8202f,     246.6148f,     259.5175f,     279.9749f,     270.1955f,     242.3427f,     226.1996f,     198.6216f,     175.1598f,     153.5215f,     148.0765f,     116.8644f,      82.8352f,      39.2114f,      16.4926f,
    -77.2826f,     -81.0630f,    -142.8123f,    -175.7374f,    -154.6778f,    -134.7003f,    -107.5754f,     -71.3200f,     -53.8328f,     -25.9739f,      -7.0973f,      14.6180f,      12.4415f,      12.6191f,      -3.8318f,      -4.2210f,
    -73.5975f,     -49.6810f,     -33.1272f,      10.8925f,      60.1080f,      61.8344f,      45.3548f,      45.5924f,      22.6090f,      11.2679f,       6.9455f,      18.9899f,      -3.4566f,     -13.0973f,     -24.6136f,     -17.3529f,
    93.3489f,     170.7564f,     135.3343f,      56.2893f,      22.2173f,     -20.1927f,     -41.3723f,     -39.2133f,     -50.1699f,     -54.9363f,     -60.2521f,     -47.5990f,     -54.0679f,     -44.0381f,     -47.1772f,     -37.0088f,
    -27.3811f,      60.8027f,      88.5729f,      82.6088f,     118.1956f,     140.5540f,     153.1990f,     173.3699f,     166.1148f,     168.4157f,     165.4583f,     168.4201f,     141.6623f,     111.7883f,      61.8626f,      28.6598f,
    61.0331f,     119.7275f,      83.9777f,      -1.2269f,     -56.5834f,    -121.3104f,    -176.1751f,    -202.5282f,    -219.9765f,    -194.9138f,    -167.0230f,    -130.8084f,    -105.0937f,     -81.6082f,     -73.9476f,     -53.6392f,
    -27.5935f,      45.9596f,      43.4074f,      35.4528f,      51.8229f,      58.2166f,      66.0162f,      87.5896f,      84.5125f,      96.2322f,     104.1692f,     116.0263f,      98.4793f,      78.3333f,      38.3067f,      15.3865f,
    174.0302f,     282.5094f,     259.6900f,     204.4108f,     189.3996f,     158.0569f,     123.9944f,     123.1922f,     118.3560f,     110.6961f,     101.0661f,      96.5273f,      78.1838f,      52.7614f,      22.4974f,       2.3781f,
    59.8885f,     245.4498f,     371.2458f,     409.7723f,     455.9382f,     450.3678f,     424.1982f,     412.1477f,     364.9408f,     325.9947f,     285.4946f,     257.5709f,     202.0349f,     150.8332f,      79.0164f,      39.6259f
};

const float lsf_cdk_wb_gc_stg2[] =
{
    -30.3104f,     -56.7575f,     -84.1487f,     -72.1960f,     -22.8352f,       3.3243f,
    -46.3791f,     -58.1840f,     -25.7428f,      -7.3327f,     -15.5902f,     -11.0671f,
    -25.6715f,     -22.2643f,     -12.1418f,     -44.6014f,     -57.5933f,     -25.0539f,
    20.6377f,       3.9627f,     -56.7740f,    -110.5344f,     -99.0040f,     -23.5388f,
    -33.0807f,     -65.7310f,     -43.7344f,      59.6097f,      60.3127f,      29.3885f,
    12.2596f,      64.5636f,      86.5834f,      56.7668f,      33.1992f,       8.0321f,
    -27.2580f,      -0.3414f,      60.0624f,      27.3071f,     -13.3937f,     -18.6842f,
    24.2406f,      11.7818f,      14.7099f,      38.2644f,       1.7464f,     -12.1068f,
    7.3676f,     -14.0551f,     -58.7823f,     -43.8456f,      44.8481f,      49.4476f,
    -27.1385f,     -20.1290f,       3.2930f,      11.7314f,      24.8512f,      17.5045f,
    6.8143f,     -14.7678f,     -42.8682f,     -16.1166f,     -13.7942f,     -20.4421f,
    1.4928f,      29.4512f,      13.1269f,     -26.8534f,      -7.1498f,       6.9288f,
    12.0685f,      25.8088f,      13.8913f,      37.8771f,      77.3020f,      41.3878f,
    -31.3089f,     -16.5767f,      72.2701f,     101.6937f,      66.1076f,      29.3520f,
    33.0047f,      43.3667f,      18.6451f,     -26.2905f,     -83.9726f,     -67.8400f,
    103.2615f,      89.8720f,      41.6101f,      14.5203f,       4.9658f,      -6.6327f
};

const float lsf_cdk_wb_gc_stg3[] =
{
    -41.3186f,     -87.9369f,    -117.0141f,    -113.4593f,     -76.4138f,     -35.5126f,     -13.8432f,      -7.5581f,      -3.0880f,       2.3802f,
    -19.0684f,     -32.7726f,     -38.9479f,     -44.5597f,     -48.0524f,     -54.3931f,     -59.1547f,     -53.0509f,     -42.1806f,     -24.7633f,
    27.3501f,      -3.4361f,     -42.3300f,     -83.6244f,    -126.2025f,    -139.2743f,    -121.0968f,     -84.5803f,     -46.8967f,     -18.1514f,
    -0.8794f,       7.8351f,      13.7504f,      10.5629f,      -2.3365f,     -27.6351f,     -53.8406f,     -67.9140f,     -63.0094f,     -41.9336f,
    9.4961f,     -11.0357f,     -24.5415f,      -6.6821f,      20.3012f,      24.1832f,       9.4935f,      -5.4294f,     -16.9057f,     -12.2235f,
    -53.4765f,     -68.3201f,     -39.2295f,     -10.3152f,      -3.0430f,      -6.2765f,     -10.5345f,     -10.9752f,      -8.2812f,      -5.0682f,
    52.0481f,      94.0614f,      84.0495f,      48.7509f,       4.2751f,     -40.3696f,     -69.1195f,     -63.3772f,     -42.9216f,     -24.6160f,
    10.0049f,      13.7676f,      17.2697f,      29.3297f,      46.7856f,      60.3615f,      66.0947f,      59.6799f,      45.2938f,      27.9216f,
    3.2564f,     -15.2692f,     -47.6037f,     -66.2845f,     -62.6754f,     -33.3695f,       8.7487f,      22.9938f,      23.4655f,      15.0233f,
    -23.6148f,       4.1981f,      21.0969f,       4.2267f,     -12.9805f,     -17.4187f,      -2.7787f,      14.0826f,      22.1174f,      12.4585f,
    44.7733f,      31.5401f,      -0.1129f,     -26.8177f,     -43.6473f,     -45.9941f,     -38.3653f,     -26.4489f,     -17.8081f,     -11.4307f,
    -21.6468f,       9.0710f,      56.6256f,      68.0223f,      58.5665f,      37.6095f,      13.9228f,      -1.0286f,      -7.3812f,      -7.6752f,
    45.1285f,      52.2192f,      35.8172f,      24.0812f,      18.9679f,      16.9917f,      14.5014f,       8.4539f,      -0.8742f,      -3.9224f,
    -36.6106f,     -54.0904f,     -50.6995f,     -17.6751f,      24.5062f,      61.1192f,      77.2085f,      68.1297f,      51.1173f,      30.6627f,
    45.4659f,      77.8448f,      86.8785f,      84.8886f,      78.1169f,      70.7257f,      58.9888f,      47.0442f,      34.4050f,      19.2233f,
    -40.9082f,     -17.6764f,      44.9914f,      99.5556f,     123.8320f,     129.2527f,     119.7749f,      99.9787f,      72.9475f,      42.1147f
};

const float lsf_cdk_wb_vc_stg1[] =
{
    -28.5460f,     -28.7607f,    -132.3446f,    -253.0434f,    -312.8796f,    -342.8824f,    -300.5386f,    -244.2990f,    -209.7251f,    -159.5373f,    -112.6287f,     -67.3791f,     -48.8219f,     -29.0922f,     -22.2704f,      -4.3572f,
    -46.5981f,     -22.9649f,     -50.9384f,     -55.9409f,     -47.4823f,     -67.2740f,     -93.7612f,     -98.1688f,    -103.5437f,    -102.1144f,    -101.9471f,     -86.9149f,     -76.1870f,     -53.2461f,     -51.2004f,     -39.3148f,
    12.7666f,      41.7683f,     -13.1290f,     -96.2977f,    -149.3018f,    -210.6122f,    -234.0799f,    -215.3711f,    -220.5745f,    -210.7746f,    -191.5374f,    -156.6170f,    -137.7840f,    -109.8098f,     -92.2552f,     -56.2013f,
    -45.2993f,     -13.6438f,     -31.2795f,       0.5585f,      26.1751f,      13.9611f,      18.6252f,      28.1510f,      20.3802f,      26.9694f,      32.9577f,      42.5006f,      29.2892f,      25.1029f,       1.3317f,      -5.8774f,
    -65.7100f,     -62.1535f,    -124.6012f,    -161.3454f,    -151.1323f,    -164.9561f,    -165.1614f,    -150.4622f,    -139.8421f,    -109.2422f,     -83.0457f,     -55.1891f,     -45.0696f,     -29.5104f,     -29.5390f,     -21.1071f,
    -75.2456f,     -87.4543f,    -164.3682f,    -176.4217f,     -83.4371f,     -28.9912f,      -6.9410f,       7.5825f,      -2.7413f,       1.1408f,       4.1258f,       6.3013f,      -0.6780f,      -0.2756f,     -18.0540f,     -14.7263f,
    109.2056f,     132.5509f,      37.4910f,     -93.8923f,    -199.5966f,    -323.5385f,    -370.8597f,    -259.1066f,    -144.1366f,     -52.9207f,      -7.3753f,       8.7209f,       4.6669f,      18.2182f,      35.3204f,      18.9218f,
    34.9292f,      54.1737f,     -19.4212f,     -84.9971f,     -62.3420f,     -22.1402f,     -18.0859f,     -54.5195f,    -107.3912f,    -147.4533f,    -198.2396f,    -216.4862f,    -199.3848f,    -152.0050f,     -94.9586f,     -38.9081f,
    -43.7524f,     -65.5612f,    -209.2403f,    -339.0183f,    -315.2712f,    -219.0569f,    -129.2175f,     -68.7060f,     -44.3255f,     -17.2217f,       5.9129f,      29.8303f,      18.2167f,      13.0068f,      -3.9593f,       4.1232f,
    -20.9014f,      30.0658f,      17.8576f,     -24.7442f,     -27.5837f,     -29.5508f,     -45.9995f,     -42.7483f,     -54.9773f,     -59.2762f,     -57.4101f,     -42.5711f,     -43.9485f,     -38.1621f,     -41.1044f,     -32.5227f,
    -0.5370f,      38.0716f,      14.4030f,     -41.8046f,     -67.6856f,     -96.6404f,    -122.3561f,    -123.7498f,    -138.9439f,    -138.4913f,    -136.8318f,    -124.9522f,    -118.9503f,     -96.3028f,     -81.0357f,     -58.1597f,
    -19.4244f,      61.2237f,      71.3972f,      25.6367f,      35.9458f,      21.4457f,      -1.7383f,       3.2413f,     -12.2673f,     -20.9311f,     -19.4463f,      -5.0683f,      -9.0711f,     -11.3618f,     -25.0494f,     -19.2853f,
    -30.0686f,       7.6179f,     -29.1133f,     -90.4660f,     -97.3464f,    -101.9661f,     -79.7809f,     -41.4927f,     -30.2058f,     -14.9387f,      -1.3463f,      14.7957f,       5.7342f,      -1.8387f,     -13.7457f,     -15.5035f,
    -60.0474f,     -62.2162f,     -94.9658f,     -16.5692f,     137.3642f,     195.2581f,     171.5869f,     140.1564f,     102.9256f,      81.4529f,      62.9621f,      57.0500f,      25.7595f,       5.7185f,     -17.0122f,     -18.2020f,
    186.4318f,     224.6768f,     114.4757f,      -1.7200f,     -54.2938f,    -162.2942f,    -260.9445f,    -305.8334f,    -275.9291f,    -196.7974f,    -106.2413f,     -38.2122f,      -9.9698f,      -0.0348f,      -3.2806f,      -1.0904f,
    131.8525f,     182.9257f,     129.5468f,      39.5803f,      -1.4035f,     -45.6323f,     -49.7229f,     -34.2829f,     -46.2254f,     -45.3785f,     -41.8506f,     -32.6587f,     -52.7586f,     -51.1091f,     -48.4846f,     -48.8108f,
    -7.2430f,       5.5232f,     -74.0471f,    -159.3008f,    -202.7316f,    -252.2241f,    -289.9449f,    -278.4816f,    -262.2343f,    -234.1872f,    -194.1267f,    -147.2734f,    -119.3163f,     -94.6419f,     -70.6759f,     -32.5601f,
    -22.3081f,      -6.0222f,     -71.4069f,     -57.5585f,      87.3579f,     111.3674f,      19.2319f,     -62.1519f,    -140.4286f,    -175.0389f,    -160.2987f,    -104.7539f,     -80.1002f,     -50.0734f,     -23.5490f,       1.6408f,
    23.3797f,      81.2481f,      31.3892f,     -52.3576f,     -81.9250f,    -125.5061f,    -125.9686f,     -77.3511f,     -70.4429f,     -55.1778f,     -44.3888f,     -25.9966f,     -26.5913f,     -23.2118f,     -31.8502f,     -31.7050f,
    -27.1231f,      37.7616f,      25.1095f,      15.1436f,      46.6224f,      72.7080f,      91.0447f,     118.4813f,     115.1246f,     132.4240f,     135.0095f,     145.7460f,     121.1771f,      93.8520f,      46.9298f,      19.6713f,
    -19.2617f,      10.4880f,     -44.5537f,    -114.3566f,    -130.3973f,    -156.7718f,    -173.2891f,    -165.3661f,    -167.0274f,    -147.1746f,    -129.2874f,    -104.7640f,     -95.4641f,     -77.5872f,     -69.6100f,     -49.0499f,
    -3.7184f,      35.4165f,     -28.7033f,     -86.2246f,     -61.2082f,     -15.9498f,      31.1702f,      56.3138f,      49.9412f,      77.3057f,      94.0143f,      94.3239f,      78.8126f,      62.9187f,      30.4449f,       9.8069f,
    55.4567f,     100.2570f,      28.4890f,     -59.9100f,    -114.0757f,    -166.5609f,    -236.0665f,    -274.6304f,    -256.7512f,     -58.8984f,       6.9854f,       2.1456f,      44.3655f,      27.4061f,     -65.0542f,     -69.1642f,
    95.5202f,     139.3445f,     117.4449f,      81.4589f,      34.9276f,     -44.4909f,     -90.4718f,    -127.2388f,    -175.4005f,    -220.3445f,    -288.6741f,    -303.4144f,    -260.5738f,    -126.2845f,     -58.1968f,     -29.1673f,
    3.0556f,      18.3576f,     -71.4110f,    -183.6864f,    -237.4567f,    -273.2383f,    -199.6331f,     -69.6698f,     -37.7715f,     -22.6972f,      -8.8733f,      16.1036f,      11.3358f,      -3.2045f,     -17.9569f,     -20.6306f,
    39.1896f,      96.2913f,      80.5943f,      18.4912f,      -3.4620f,     -34.5205f,     -64.0148f,     -77.2972f,     -99.9022f,    -107.3139f,    -104.8068f,     -92.0120f,     -86.4257f,     -73.8585f,     -70.7371f,     -53.2077f,
    81.1530f,     122.0539f,      53.2063f,     -53.6774f,    -106.3376f,    -163.4776f,    -180.9786f,    -175.0377f,    -183.3532f,    -183.5190f,    -169.4248f,    -137.3097f,    -123.3554f,    -101.5521f,     -94.1512f,     -61.8612f,
    47.0309f,     137.9525f,     111.1768f,      67.6681f,      63.8415f,      52.4017f,      35.8194f,      35.6828f,      19.7444f,      10.1125f,       6.1064f,      10.9675f,       5.0407f,      -0.1812f,     -16.8272f,     -19.3810f,
    42.6721f,      92.5038f,      31.4316f,      -5.1224f,      -6.0796f,     -41.9120f,     -30.0922f,       1.7396f,      15.4681f,      21.9765f,      36.6015f,      47.1275f,      37.4374f,      28.9853f,       9.1342f,       2.7556f,
    -25.6593f,      22.2684f,      98.1230f,     166.4577f,     187.4970f,     165.0274f,     123.8612f,     113.1471f,      79.0653f,      48.7839f,      25.8742f,      32.9158f,      10.3013f,       1.0495f,     -15.4120f,     -15.0391f,
    304.7019f,     354.4388f,     217.4228f,      65.5482f,      65.3717f,      25.9965f,     -93.4052f,    -188.0092f,    -255.0247f,    -224.5901f,    -158.7919f,    -116.2751f,     -72.5203f,     -57.4171f,     -28.9851f,      -1.9506f,
    179.5714f,     241.9845f,     193.4582f,     112.7762f,     108.6980f,      80.4323f,      56.9618f,      58.6676f,      36.2938f,      12.8297f,       4.7285f,      10.9217f,      12.0551f,      12.0937f,       1.6504f,     -14.7259f
};

const float lsf_cdk_wb_vc_stg2[] =
{
    -4.8704f,     -25.4945f,     -63.8565f,     -65.1017f,      -4.5396f,      12.9750f,
    -51.6246f,     -71.2351f,     -70.8930f,     -49.5365f,     -41.5492f,     -21.1764f,
    -4.1941f,     -21.5321f,     -43.7546f,     -75.1360f,    -101.6917f,     -51.6149f,
    39.1412f,      15.8593f,     -34.7315f,     -30.9497f,       5.4101f,     -22.1983f,
    -27.3812f,     -44.2900f,     -51.8477f,      17.0318f,      63.3214f,      33.3719f,
    -42.1936f,     -38.7776f,      26.9794f,      58.3819f,      22.3255f,       7.3631f,
    -17.3453f,      32.8013f,      16.4392f,      -4.8961f,      34.6309f,       3.7975f,
    20.9889f,      11.0332f,      21.2790f,      43.6082f,      11.3288f,      -4.0437f,
    -30.7619f,     -28.1362f,      -7.6918f,     -26.0495f,     -20.5254f,      20.4943f,
    -5.8695f,     -15.0159f,     -12.0884f,       4.0124f,     -37.3326f,     -57.6803f,
    31.1085f,      51.7290f,      46.8635f,     -11.1193f,     -84.1480f,     -75.2940f,
    31.7638f,      33.3860f,      -2.0831f,     -68.1944f,     -69.2055f,      16.6054f,
    26.8476f,      11.7277f,     -21.2873f,     -16.1653f,      77.7471f,      74.9747f,
    -11.9492f,     -11.8103f,      39.7377f,     110.8560f,      91.1983f,      51.6182f,
    -16.9337f,      34.0576f,      97.5442f,      55.3237f,       6.0911f,     -14.5976f,
    63.2733f,      65.6975f,      59.3910f,      57.9345f,      46.9389f,      25.4049f
};

const float lsf_cdk_wb_vc_stg3[] =
{
    -32.9020f,     -78.5896f,    -107.4534f,     -95.7731f,     -74.7222f,     -53.0220f,     -21.3706f,      -6.3135f,       4.4667f,       8.3786f,
    -55.7273f,     -51.1982f,     -23.4921f,     -31.8303f,     -40.9730f,     -44.0985f,     -32.5056f,     -19.4304f,     -11.2363f,      -6.8031f,
    -1.3625f,     -17.5965f,     -40.9966f,     -56.5415f,     -66.9172f,     -82.2625f,     -98.8410f,     -92.9959f,     -64.2789f,     -34.2565f,
    -0.1831f,      28.9371f,      27.3975f,       6.7646f,     -26.2844f,     -55.3561f,     -55.5887f,     -25.6472f,       4.2175f,       6.7426f,
    -0.1042f,     -22.5234f,     -18.6769f,       9.5775f,      20.8908f,       1.7399f,     -25.4612f,     -48.9497f,     -58.9339f,     -45.8070f,
    -59.3842f,     -92.5268f,     -67.7156f,      -8.1650f,      22.6518f,      30.8838f,      30.1565f,      24.4312f,      17.5083f,       9.4537f,
    61.2263f,     100.3160f,      74.2819f,      32.8490f,     -21.2300f,     -80.0984f,    -138.8597f,    -144.8649f,    -102.7813f,     -51.4501f,
    20.9615f,      14.5464f,      12.7374f,      42.2801f,      62.5685f,      59.3555f,      43.2439f,      37.0487f,      22.3288f,      14.0209f,
    6.4664f,     -20.5406f,     -67.1147f,     -81.1455f,     -18.3522f,      38.5675f,      31.4978f,       9.2431f,      -5.5141f,      -0.9299f,
    -14.7299f,      -8.8186f,      -2.0488f,      -3.6924f,     -11.6375f,      -3.0631f,      38.0648f,      50.4570f,      46.9399f,      28.7229f,
    34.6418f,      11.8422f,     -31.9716f,     -72.1947f,    -102.4017f,     -89.6780f,     -33.2158f,       7.5030f,      18.7080f,      14.6731f,
    -62.1236f,     -44.3324f,      53.6090f,      72.1405f,      58.0429f,      57.2172f,      43.2329f,      33.7172f,      19.9635f,       6.9351f,
    73.8739f,      68.1656f,      32.4182f,       5.6585f,      -7.7073f,       3.9480f,      12.5407f,      12.3801f,      -2.4527f,      -5.8024f,
    -21.3075f,     -24.8496f,     -17.5965f,       2.9303f,      59.0699f,     104.4524f,     127.5622f,     113.8932f,      89.2660f,      52.1358f,
    4.2469f,      56.7592f,      88.2184f,      81.0948f,      49.2982f,      15.3523f,      -8.4240f,     -22.2333f,     -30.5271f,     -24.1128f,
    46.4076f,      80.4091f,      88.4039f,      96.0474f,      97.7032f,      96.0620f,      87.9680f,      71.7615f,      52.3257f,      28.0991f
};

const float *const lsf_codebook[2][2][TCXLPC_NUMSTAGES] =
{
    {
        { lsf_cdk_wb_gc_stg1, lsf_cdk_wb_gc_stg2, lsf_cdk_wb_gc_stg3 },
        { lsf_cdk_wb_vc_stg1, lsf_cdk_wb_vc_stg2, lsf_cdk_wb_vc_stg3 }
    },
    {
        { lsf_cdk_nb_gc_stg1, lsf_cdk_nb_gc_stg2, lsf_cdk_nb_gc_stg3 },
        { lsf_cdk_nb_vc_stg1, lsf_cdk_nb_vc_stg2, lsf_cdk_nb_vc_stg3 }
    }
};

const int lsf_numbits[TCXLPC_NUMSTAGES] = { 5, 4, 4 };

const int lsf_dims[TCXLPC_NUMSTAGES] = { 16,  6, 10 };
const int lsf_offs[TCXLPC_NUMSTAGES] = {  0,  0,  6 };

const float lsf_ind_cdk_nb_gc_stg4[] =
{
    -33.5099f,     -17.2439f,
    1.9585f,       6.4210f,
    -21.9240f,      24.8014f,
    23.6604f,      49.3421f
};

const float lsf_ind_cdk_nb_vc_stg4[] =
{
    -33.5292f,     -23.3982f,
    15.6149f,      34.3889f,
    -9.2455f,       6.1721f,
    60.7325f,      78.8354f
};

const float lsf_ind_cdk_wb_gc_stg4[] =
{
    -31.4516f,     -19.9820f,
    9.1071f,       6.9160f,
    -17.3554f,      28.1193f,
    31.7476f,      59.9379f
};

const float lsf_ind_cdk_wb_vc_stg4[] =
{
    -25.6665f,     -20.7100f,
    17.1565f,       9.9963f,
    -13.7601f,      37.4813f,
    55.4374f,      66.3001f
};

const float *const lsf_ind_codebook[2][2][TCXLPC_IND_NUMSTAGES] =
{
    { { lsf_ind_cdk_wb_gc_stg4 }, { lsf_ind_cdk_wb_vc_stg4 } },
    { { lsf_ind_cdk_nb_gc_stg4 }, { lsf_ind_cdk_nb_vc_stg4 } }
};

const int lsf_ind_numbits[TCXLPC_IND_NUMSTAGES] = { 2 };

const int lsf_ind_dims[TCXLPC_IND_NUMSTAGES] = { 2 };
const int lsf_ind_offs[TCXLPC_IND_NUMSTAGES] = { 0 };

const Word16 min_distance_thr[2][2] = /* 14Q1*1.28 */
{
    /* GC,  VC  */
    /* WB */ { 580, 580 },
    /* NB */ {1000, 580 }
};

const float lsf_q_diff_cb_8b_rf[256*16] =
{
    -49.142456f, 13.490689f, -21.704788f, 63.851589f, 17.341200f, 49.889275f, 4.535705f, -49.377617f, 12.881550f, 3.317029f, -45.874687f, -91.048477f, -159.075317f, -244.532806f, -208.950378f, -60.136238f,
    -71.911499f, -50.432014f, -131.216339f, -25.763540f, -90.432335f, -140.176178f, -31.643175f, -46.414715f, -23.065298f, -42.936611f, -38.403904f, 15.094532f, -0.061476f, -28.153961f, -21.246065f, 10.218022f,
    -134.834076f, -120.343132f, 98.120338f, 51.493057f, -18.822592f, 5.707322f, -93.194328f, 48.820892f, 38.169155f, 22.535019f, 17.952980f, -59.919395f, -154.178802f, -66.216209f, -30.895947f, -30.548832f,
    -41.079960f, -11.862259f, -32.120766f, -35.889202f, -28.737438f, 26.212168f, -37.682671f, -117.789268f, -206.368179f, -150.378693f, -26.382723f, -33.924740f, 14.733324f, -7.089695f, 8.373900f, 41.311722f,
    -44.370823f, -21.727020f, -164.064880f, 39.315842f, 14.170435f, 2.276680f, -43.158184f, -105.471977f, 46.076225f, -35.652943f, -72.096603f, -88.481071f, -121.452873f, -86.098267f, -92.925804f, -58.238682f,
    -62.593822f, -14.669445f, -39.062012f, -12.045748f, -53.345932f, -70.633652f, -100.257874f, -63.507019f, 57.782543f, 62.015087f, 67.188080f, 65.260689f, -49.929119f, -162.794342f, -204.251465f, -104.609535f,
    -66.932289f, -18.313484f, -68.981606f, -25.012476f, -94.210236f, 1.026957f, -67.785004f, -35.943043f, -53.149406f, -87.719955f, -112.206566f, -113.875397f, 111.780113f, 102.159576f, 1.001174f, -50.978374f,
    -101.098640f, -70.354515f, -151.534393f, -91.954025f, 3.666550f, 78.893501f, 42.150974f, -57.122208f, -56.242603f, -97.829124f, -66.723511f, 11.967057f, 16.204992f, -23.608727f, -19.899971f, 28.121500f,
    10.450438f, 45.892262f, -54.131168f, -16.160269f, -64.032661f, -176.495041f, -5.962820f, -72.027107f, -150.201141f, -32.517159f, 61.674686f, 44.256657f, 46.283817f, -5.180211f, -141.241837f, -167.211639f,
    -173.577682f, -92.975533f, -112.498154f, -101.956200f, -66.556870f, -79.061409f, -139.621201f, -1.422741f, -10.495166f, 71.210350f, 49.869511f, -2.298943f, -35.104397f, 24.463161f, -11.476251f, -46.980118f,
    -37.676750f, 24.794701f, -40.237633f, 33.943848f, -51.101398f, 166.382629f, 110.829704f, 23.702038f, 23.627102f, -6.121801f, 0.773019f, -142.445435f, -263.982605f, -14.189220f, -131.928268f, -155.050293f,
    -30.214348f, -9.421390f, -102.936676f, 83.361900f, -24.453602f, -180.015442f, 92.876984f, -79.562981f, -9.609303f, -34.706200f, -120.354073f, -29.731850f, -81.171555f, 36.295174f, 61.845047f, 47.662693f,
    -110.844032f, 83.765533f, -123.206459f, -51.540508f, -51.287010f, -48.821514f, -29.502964f, -6.343169f, 23.775656f, -0.353102f, -23.523582f, -94.919563f, -133.085464f, -118.824188f, -53.901115f, -52.530910f,
    -55.833942f, -37.825222f, 21.633268f, -2.833855f, -172.300034f, 74.660912f, -62.712250f, -77.443947f, 114.319824f, 49.023743f, 36.734745f, 53.222221f, -31.211931f, -15.118987f, -37.109795f, -50.964909f,
    -2.209181f, 103.944717f, 186.623413f, -64.544991f, -32.391006f, -40.504578f, -24.400692f, 23.758614f, -28.194080f, -40.393677f, -41.950493f, -90.601120f, -169.530365f, -181.697540f, -67.184174f, -66.990860f,
    -24.511374f, 34.831326f, 36.412617f, 49.172550f, -16.029377f, -109.529999f, 4.142260f, -20.617449f, -56.997406f, 30.342079f, -83.989975f, 1.144082f, 161.687592f, 61.147705f, -86.482475f, -92.777733f,
    -88.158249f, -53.647205f, -131.604202f, 18.409283f, -8.442244f, -74.841873f, -30.877779f, 73.223831f, 26.580759f, -20.676722f, -31.395731f, -93.706764f, -88.946129f, -60.194122f, -118.809082f, -83.768547f,
    -27.869957f, -5.078736f, -133.762909f, -274.870483f, 25.990072f, 21.509178f, 36.674843f, -3.828471f, -37.908432f, 2.206993f, -2.133470f, 15.392393f, -76.964806f, -123.400665f, -55.604580f, 13.984759f,
    -39.818924f, -24.414286f, -78.231728f, 114.239975f, 68.886200f, 49.643444f, 61.244785f, 24.158489f, -11.322248f, -82.068733f, -152.400940f, -144.792816f, -89.084679f, -107.811325f, -15.021494f, 27.688988f,
    -26.188799f, 13.887177f, -74.969177f, 125.939407f, 54.065468f, -29.856068f, 6.488181f, -63.185188f, -96.026291f, -188.663879f, -165.438187f, 203.997070f, 43.201817f, 21.809793f, -74.018494f, -76.644218f,
    14.730933f, 52.225765f, -133.046051f, 73.062096f, -12.101256f, -61.917290f, -85.989738f, -25.391121f, 61.084568f, -56.463966f, 192.920975f, 44.298870f, -151.724915f, 91.825546f, 4.643712f, -14.348310f,
    -83.082611f, -43.735950f, -57.932819f, -63.816303f, -127.738678f, -96.165390f, 27.380922f, 106.262009f, 117.074669f, 97.982422f, 63.797035f, 48.936672f, -12.647917f, -65.618805f, -84.200691f, -93.463432f,
    -79.058868f, -82.570656f, -23.950100f, -42.977753f, 35.295464f, -60.833336f, -54.265438f, -1.680498f, -73.608223f, -41.047230f, -32.325935f, -36.250416f, -2.680869f, 24.178974f, 12.027203f, 4.833654f,
    -70.078651f, -40.907417f, -113.092224f, 27.616556f, -46.329929f, 104.583298f, 82.129387f, 0.280690f, -27.957493f, -79.316704f, 111.977844f, 50.056763f, -19.403173f, 25.433884f, 70.602043f, 28.069981f,
    -1.787399f, 19.136635f, -48.166355f, 5.009412f, -62.536564f, 75.527115f, -47.088139f, -11.585875f, -65.448433f, -92.899475f, 107.363365f, -32.311649f, -203.382462f, -152.693619f, -50.552776f, 31.944372f,
    8.727448f, 163.701584f, -151.617279f, -120.834221f, -140.449585f, -168.542450f, -161.597626f, -134.148041f, -44.436928f, 23.024485f, 88.100662f, 153.087036f, 171.657425f, 142.269592f, 72.176025f, 34.152279f,
    24.626226f, 141.228775f, 68.035118f, 32.383106f, 29.076723f, -23.316879f, -11.166278f, 28.757330f, -105.244186f, -168.721451f, 15.529101f, -45.646198f, -99.508888f, 12.179071f, 41.687931f, -6.929618f,
    -32.293335f, -15.942890f, 0.017796f, 227.668884f, 35.207336f, -33.792694f, 82.114479f, 15.197913f, -26.902617f, 65.209732f, 1.587932f, -56.761986f, -22.348925f, -26.869337f, 19.428514f, 27.321255f,
    -102.949432f, -25.011555f, -147.959137f, -87.200294f, 47.153675f, 18.530943f, -0.166834f, 19.560911f, 89.191528f, 52.157402f, 2.918095f, -61.719532f, -94.293381f, -51.465199f, -1.655222f, -17.656567f,
    -38.911335f, 6.948825f, -39.729725f, -51.301937f, -53.620224f, -108.789536f, 155.468872f, 63.620651f, 35.850296f, 70.581047f, 42.754013f, 127.703674f, 66.715858f, -130.426041f, -146.462341f, 74.622078f,
    -1.029140f, 54.317455f, 8.387774f, 41.543407f, -10.573199f, 24.244738f, 30.842634f, -26.604139f, -33.421272f, -9.906475f, -31.059523f, 10.844967f, 30.019199f, -202.162201f, -258.204132f, 91.369331f,
    -153.889771f, 115.453377f, 72.695793f, -18.096334f, 20.942005f, -35.160381f, -38.443104f, -34.397667f, -48.781742f, -1.410000f, 62.099541f, 79.766754f, 142.615189f, 135.960159f, 96.626495f, 58.906452f,
    -79.472115f, -49.353893f, -49.954609f, -155.367615f, -116.776726f, 15.010523f, 18.099497f, -55.247025f, 16.403715f, 87.059982f, -23.132126f, -173.747818f, -144.933502f, -28.767344f, -32.596806f, -0.380802f,
    -15.925756f, -5.412324f, -105.707176f, -130.356949f, -98.465538f, -47.166088f, -87.599068f, 42.630928f, -62.413151f, -107.954193f, 158.527435f, 98.763542f, -3.586527f, -6.147307f, -13.222188f, -23.993233f,
    -24.975382f, 56.402035f, 52.029133f, -3.636582f, -18.978687f, -30.510057f, -20.777334f, 0.297320f, -75.612679f, -166.890121f, -182.792877f, -17.244802f, 17.907167f, -95.983925f, -107.016418f, 6.600997f,
    13.935800f, 124.014893f, -78.200630f, -86.667000f, 27.445192f, -62.815701f, -53.436100f, -106.422089f, -98.502609f, -122.057808f, -94.039665f, 79.832077f, 85.983383f, 86.996208f, 71.870331f, 101.132660f,
    -51.503838f, -34.840988f, -93.907707f, 54.647934f, 85.969376f, -35.794395f, -36.596844f, -102.254219f, -196.495346f, 34.254475f, -15.691520f, -81.330208f, -7.808877f, -105.690956f, -96.873695f, 28.378246f,
    79.900681f, 76.900246f, 101.535088f, 103.327919f, 76.696190f, 36.222244f, -87.911812f, -186.179047f, 47.998817f, 180.776077f, 27.586971f, 68.147926f, 8.632617f, -127.173943f, -218.839523f, -269.181305f,
    -51.884178f, -23.658228f, -7.389097f, 51.481766f, -16.066425f, -70.871017f, -193.338547f, 194.566742f, 115.566246f, -35.451885f, -78.933662f, 8.663171f, 16.445974f, -68.275475f, -91.542229f, 1.517690f,
    -39.556801f, 39.785755f, -76.877228f, -215.618423f, 126.814384f, 37.883842f, 26.489124f, -32.631229f, -79.764656f, -5.413741f, -44.822353f, -38.384186f, 145.878082f, 205.717392f, 96.100632f, 80.714775f,
    -36.383427f, 1.122570f, 179.888214f, -48.044216f, -121.014236f, -85.808846f, -125.241035f, -79.817886f, -0.247583f, 50.953720f, 13.693697f, -5.582759f, -50.636333f, -46.192039f, -66.636848f, -36.257576f,
    -122.950089f, -101.489883f, -260.444885f, -20.923767f, -57.475227f, 15.233345f, -42.816353f, -43.372814f, 58.668098f, 2.198759f, -2.974080f, 16.032595f, 93.305153f, 50.504028f, -14.432660f, -50.193291f,
    -16.826427f, 8.873464f, -87.595573f, 23.091625f, -3.794562f, 38.739624f, 159.341888f, 57.302864f, 10.663289f, -44.891232f, -143.189377f, -141.278580f, 34.162834f, 67.916397f, -11.724302f, 82.864563f,
    8.689659f, 79.660339f, -106.648331f, -40.056900f, -61.659725f, -89.878143f, 30.882858f, -96.414940f, -87.919632f, 71.567696f, -13.048811f, -99.413971f, 158.306488f, 148.612640f, 101.164139f, 44.707798f,
    51.876743f, 173.028961f, -7.548154f, 42.151535f, -0.306372f, -63.804768f, -65.823441f, -61.424610f, -3.614527f, -0.266337f, -28.529921f, -42.772068f, -92.503525f, -24.051035f, -29.639515f, -52.302032f,
    -21.027899f, 32.422092f, -19.221569f, -81.996292f, 170.400146f, 147.834946f, 78.837563f, 54.455120f, -4.170513f, -14.816674f, 66.761642f, 29.512554f, 1.267826f, -7.617690f, -74.421074f, -86.431335f,
    -19.333296f, 100.725983f, 62.089886f, 80.720032f, -11.293929f, -156.758041f, 130.283081f, 64.092621f, 10.666490f, 23.035032f, 9.748004f, -82.614822f, -134.818069f, -117.491508f, -98.273796f, 27.608231f,
    3.230417f, 41.808163f, 13.598584f, 214.913864f, 110.737106f, 36.832939f, -14.412317f, -27.091141f, -72.668190f, 5.492285f, 219.188553f, 157.024200f, 139.305466f, 42.584637f, -89.405518f, -147.115540f,
    5.685055f, 57.183292f, -12.697913f, 68.282562f, -33.609550f, -33.049332f, 87.031670f, -39.772167f, -127.605225f, -30.905075f, -129.695374f, -167.423813f, 14.979711f, -80.101776f, -175.781570f, -120.638008f,
    -26.057411f, -22.450294f, -86.065346f, -174.294159f, -236.409439f, 106.705414f, 94.844818f, -24.300186f, -47.618366f, -4.900061f, -8.250068f, 26.776390f, 23.026890f, -0.663881f, -8.460385f, 52.523418f,
    -239.938965f, -188.228012f, -72.794617f, -24.974373f, 64.134842f, 47.954140f, 37.109238f, 56.990929f, 19.013355f, 2.195176f, -39.343456f, -65.541855f, -48.117985f, 33.679371f, 1.032876f, -8.904166f,
    1.318133f, 23.793682f, -11.594374f, 208.226288f, 86.628777f, -41.451736f, -85.691925f, -59.617199f, -144.367111f, -168.655807f, 108.856461f, 32.739384f, -66.105087f, -32.850475f, 68.247009f, 136.522278f,
    46.231567f, 61.993446f, -37.963066f, 71.883453f, 4.955863f, 90.692329f, -55.423782f, -173.421982f, 91.392097f, 4.265558f, -86.143791f, 11.978693f, -147.210098f, -173.357559f, 47.334595f, 132.379639f,
    -8.091352f, 36.792015f, 42.705544f, 0.830618f, -22.491022f, -42.331161f, -6.163970f, 83.671753f, -37.618378f, -48.777485f, 136.386185f, 88.433350f, 121.425102f, 78.104286f, -118.565308f, -236.474899f,
    -34.999004f, 35.648041f, 104.321472f, -80.549561f, 88.479385f, 4.159388f, -68.049988f, -110.190895f, -59.762150f, -34.927917f, -42.892593f, -50.185341f, -31.525537f, 28.561077f, 30.799391f, 32.589943f,
    -19.395960f, 10.917861f, -33.211983f, 59.916050f, 17.923265f, 69.628220f, -59.527351f, -0.360134f, 20.055620f, -76.225594f, 59.490189f, 219.202728f, 44.065163f, -105.835022f, 149.316025f, 103.121368f,
    -26.811831f, 4.917114f, -50.918606f, -51.282066f, -44.665630f, -34.671989f, 54.816383f, -53.930695f, -122.650787f, 9.736618f, -86.848312f, -33.875164f, 28.787636f, -128.559616f, -13.832273f, 240.435959f,
    -127.768944f, -120.395676f, -224.640091f, -106.371384f, -110.915848f, -119.944382f, -64.704178f, -86.686111f, 57.449604f, 91.349197f, 96.250694f, 156.740128f, 176.836166f, 127.207031f, 51.964844f, 14.125758f,
    -47.998665f, 17.796474f, 29.304367f, 75.164230f, 58.860054f, 113.970734f, 70.417877f, 23.055088f, -25.342611f, -99.771896f, 5.999279f, 51.847668f, -60.419800f, -163.240036f, -99.791527f, -66.431305f,
    -0.302659f, 17.211594f, -98.700340f, 53.635334f, -28.992607f, -89.555244f, 112.895592f, -32.920498f, -109.022964f, 150.316772f, 124.435059f, 47.075050f, 111.757408f, 77.910065f, -34.123623f, 33.374477f,
    -8.188879f, 23.113052f, -14.419042f, 58.259747f, -4.053533f, 3.542868f, 101.208923f, 41.556973f, 65.754631f, 15.887958f, -6.614230f, -95.157341f, -213.709061f, 82.959053f, 10.967265f, 42.520882f,
    -12.848677f, 33.983711f, 26.826427f, 55.942802f, 17.707258f, 59.918518f, 15.309278f, 207.269272f, 99.491982f, 42.829330f, 116.586906f, 97.039436f, -36.674652f, -119.304512f, 74.699173f, 64.565712f,
    -127.629143f, 210.633652f, 90.269417f, -15.052937f, 10.047224f, -44.578220f, -32.594685f, -24.894297f, -32.681622f, 36.690662f, 60.424084f, 6.454986f, 7.198017f, 25.681587f, -4.052445f, -25.874166f,
    -13.218253f, 25.233515f, -43.822559f, 14.608809f, 50.092663f, 29.797066f, 122.838074f, 60.946331f, -15.227234f, 70.429047f, 49.234367f, 22.393675f, 241.398132f, 68.944763f, -19.084089f, 15.646838f,
    -61.749660f, 22.046791f, -33.557991f, -16.016773f, -39.896496f, -65.069405f, -73.831696f, -54.138386f, -41.472534f, -59.811478f, -96.109680f, -119.990692f, -91.886162f, -31.355206f, -9.082160f, -39.052567f,
    -27.257662f, 71.028709f, -136.328506f, -98.025055f, -21.314344f, -16.991056f, -34.343781f, -70.373230f, -55.339901f, -30.724577f, -8.068395f, -12.537150f, 6.994465f, -2.531820f, -19.959831f, -32.511631f,
    -189.575684f, -170.668686f, 159.468323f, 69.316818f, 9.541554f, -35.932343f, -76.965225f, -73.569916f, -80.277435f, -52.695671f, 36.840542f, 4.612717f, -5.781191f, 68.836777f, 46.053165f, 5.477945f,
    23.076845f, 56.007298f, 58.995125f, 73.648643f, -23.558571f, 31.706146f, 6.650000f, -81.954597f, -43.828186f, -91.444901f, -136.752670f, 3.109934f, -61.638336f, 161.845291f, 158.234512f, 75.812927f,
    -29.586615f, 8.254013f, -12.131930f, 42.161793f, -20.277391f, -118.423508f, -194.639008f, -196.011337f, 38.792351f, 37.828663f, -2.185939f, 11.298992f, -6.172924f, -4.559058f, -65.562843f, -27.597832f,
    -47.978813f, 22.640007f, -58.066402f, 58.001053f, -47.134541f, 8.486321f, -6.111372f, -31.006121f, 51.575218f, 5.865514f, 17.294910f, -41.168453f, 73.907234f, 13.599236f, -307.273499f, -197.696899f,
    -44.109650f, 49.449520f, 84.357780f, -161.258835f, -95.109154f, -44.129417f, -5.148076f, -26.549320f, -4.192320f, -31.172485f, -35.216717f, 42.882584f, 4.978696f, 0.798938f, 44.287029f, 7.057617f,
    -44.323925f, -3.754397f, -20.289011f, 35.057964f, 30.896481f, 47.822914f, 57.432564f, -18.862158f, -58.972874f, -40.730820f, -53.210159f, 151.582123f, 189.086823f, -47.681084f, -160.354431f, 18.183973f,
    -24.190926f, -8.054521f, -60.337772f, 17.447094f, 52.011765f, 64.135529f, -12.559262f, -64.698524f, -145.641434f, -49.002659f, 27.998568f, 54.442074f, 31.638771f, -105.428864f, -187.366058f, -170.395126f,
    -52.519932f, -45.655670f, -54.255409f, 18.195887f, -47.736511f, -25.311331f, -74.233253f, -139.686768f, -7.455135f, 30.180883f, 16.468306f, 73.234703f, 89.610466f, 86.974052f, 38.241241f, -12.159492f,
    27.982965f, 58.867645f, 9.410244f, -37.832794f, -107.431290f, 148.510559f, 114.846024f, 37.929848f, -49.612717f, -97.690834f, -11.054573f, -58.132690f, -120.672997f, -0.656331f, 67.064285f, -17.834682f,
    -38.582962f, 4.200229f, -16.068153f, 16.516636f, -13.899181f, 5.986161f, -2.004643f, 12.832077f, -44.597519f, -86.681267f, -38.071716f, -52.322094f, 61.482838f, 23.035675f, 222.921036f, 209.259064f,
    -53.377850f, 219.871765f, 18.681116f, -49.476475f, -66.432587f, -11.111042f, 8.136900f, 38.469578f, 83.534767f, 23.165945f, -66.981857f, -119.944641f, -90.701843f, -5.017766f, 13.544878f, 7.416979f,
    -26.158424f, 21.733870f, 8.429042f, -7.359868f, -81.261559f, -0.384979f, 107.991409f, -33.468559f, 163.344254f, 171.295059f, 21.148136f, -44.234226f, -50.298836f, -2.045869f, -46.947075f, -69.817322f,
    54.305538f, 77.911476f, 98.722816f, -46.229565f, -143.810577f, -1.355024f, 61.036888f, -13.015687f, -3.865948f, 88.857635f, 7.053370f, 11.180832f, -46.409653f, -90.435066f, -105.360260f, -147.441849f,
    75.489372f, 105.739868f, 60.188259f, 33.809502f, -21.277689f, -21.943260f, -50.937679f, -75.105469f, 43.895504f, -42.176373f, -73.326416f, 343.493774f, 168.802673f, 63.476738f, 36.762135f, 96.509972f,
    -43.959518f, -13.900088f, -83.791946f, -2.585726f, -89.923798f, -318.138428f, 56.854568f, 72.487968f, -32.397919f, 28.099873f, -17.146538f, -96.395309f, 0.466646f, -28.547890f, -71.721748f, -40.413429f,
    -91.491898f, -100.288185f, -158.042801f, -94.347038f, 41.776943f, 56.555912f, 18.842609f, 21.550163f, -8.122741f, 83.330833f, 83.349388f, 56.535236f, 6.853065f, -16.367655f, 6.860499f, 12.135324f,
    -122.978020f, 41.508400f, -57.019398f, 119.866692f, 169.921616f, 82.577713f, 6.609851f, 29.209021f, -35.676617f, -95.016159f, -42.960949f, -61.483852f, -28.365889f, 44.539429f, 11.786313f, -39.760418f,
    -35.204288f, -3.827494f, 1.364895f, 53.625450f, 67.540977f, 12.539343f, -62.200562f, -131.499298f, -190.222824f, 97.861145f, 145.009247f, 116.742218f, 39.964626f, 5.113988f, -49.972206f, -22.433067f,
    -21.844286f, -3.302132f, -103.041687f, 72.974442f, 0.991044f, 31.884541f, -68.314651f, 15.106439f, 38.181488f, -142.549530f, -177.428543f, 26.987268f, -65.951744f, -49.118980f, 100.179466f, 67.782463f,
    -68.886017f, -50.878456f, -101.627640f, 94.751526f, 63.353767f, -35.431698f, 88.086647f, 85.405006f, 1.274280f, -8.066319f, 108.974724f, 81.340332f, 19.295490f, -5.680541f, -76.852966f, -93.998848f,
    0.026969f, 0.110805f, -0.074311f, 0.076925f, 0.017105f, 0.036573f, -0.118072f, 0.068798f, 0.056649f, 0.036456f, 0.063553f, 0.071463f, 0.000525f, -0.019787f, -0.046544f, 0.021337f,
    -17.799213f, 17.198961f, -23.454958f, -48.785267f, 32.178555f, 142.656906f, 87.394043f, -46.504601f, -91.326263f, -128.089188f, 168.745255f, 12.046860f, -75.234085f, 321.776276f, 84.140045f, 147.402191f,
    -7.771455f, 13.708800f, -83.826019f, -18.597784f, -45.941696f, -97.131195f, 73.443825f, 13.631736f, -35.554703f, 154.701080f, 86.402138f, 6.515917f, -68.449318f, -152.233841f, -30.240294f, -16.017389f,
    -55.553074f, -10.045274f, -82.091660f, -104.274841f, -102.906937f, -76.238228f, -59.226723f, -42.700069f, 16.344666f, 35.539070f, 49.328686f, 56.921478f, 131.003021f, 165.738358f, 186.387207f, 144.321213f,
    24.576750f, 51.924622f, 2.034293f, 189.503342f, 148.765106f, 101.905212f, 63.054604f, -22.561197f, -112.342194f, 8.821053f, 33.745621f, -43.875877f, -58.067898f, -146.850281f, -17.419054f, 72.366890f,
    -30.276649f, -31.782654f, -80.339973f, 100.106911f, 93.313034f, 4.726528f, -48.094799f, -115.030556f, -191.082672f, 102.985733f, 88.130089f, 19.376783f, 42.609215f, 50.674198f, 152.159012f, 114.587776f,
    -137.391373f, 14.609784f, -65.256355f, 1.609928f, 37.473400f, 26.934027f, 24.673132f, 119.508095f, 88.831779f, 43.605965f, 27.401138f, -7.082619f, -78.587341f, -76.090195f, -60.487331f, -49.042698f,
    -3.795852f, 48.615219f, -32.316784f, 47.219639f, -71.672012f, -177.180862f, 227.674683f, 121.423073f, 55.595085f, 89.844704f, 18.789379f, 72.883820f, -30.959936f, -1.702511f, 69.411217f, 21.385332f,
    -31.896704f, 58.013481f, 15.825336f, 21.007841f, 73.693138f, 2.008733f, 47.849987f, 22.561638f, -56.861252f, -96.624382f, 116.512817f, 122.175636f, 14.970264f, -131.112076f, -137.480362f, 145.503159f,
    3.666602f, 60.865307f, 190.182358f, 42.435371f, -21.053213f, -17.096897f, -76.084404f, -13.743227f, 117.478218f, 140.799774f, 154.908340f, 88.790558f, 92.327370f, 121.949478f, 69.189064f, 33.268280f,
    -24.028364f, -0.568868f, -10.598723f, 23.224901f, -10.145369f, 23.696190f, -80.020584f, 133.288193f, 78.874382f, -28.811146f, -74.702332f, -142.888794f, -177.398254f, -126.189499f, -64.583435f, -4.795106f,
    -42.301235f, 1.254746f, -92.263153f, -67.414131f, -68.581459f, -105.596657f, -95.386429f, -140.669708f, -167.874496f, -26.571861f, 58.823044f, 95.171120f, 164.426514f, 117.247391f, 67.970955f, 67.381973f,
    12.281957f, 57.241734f, 145.007370f, 102.782562f, 6.108451f, 23.661549f, -109.679001f, 79.513168f, 54.415848f, -107.359993f, -127.692383f, -2.818198f, -116.707993f, 22.176086f, -1.896818f, 13.089568f,
    42.066715f, 109.299110f, 22.366495f, -16.778564f, 21.774530f, -4.182106f, -18.286386f, -52.603218f, -118.524780f, -89.037674f, 118.551682f, 115.277679f, 89.577263f, 130.519241f, 158.623138f, 169.276016f,
    -127.461502f, -97.991295f, -154.912262f, 156.017349f, 83.816185f, -40.645927f, -30.617186f, -97.806175f, -64.010101f, 50.553226f, 32.767338f, -3.065530f, 46.381119f, 52.668839f, 32.740833f, -18.864176f,
    -35.447090f, 10.117445f, -29.844646f, 121.351227f, 83.683456f, 57.303402f, 15.328587f, 44.133987f, 67.000153f, 104.188065f, 10.872536f, -10.320432f, 63.163109f, -83.689003f, -200.906555f, -56.971607f,
    -73.476898f, -50.613533f, 157.811996f, -36.126892f, -3.998129f, -33.125019f, -40.811184f, 75.547150f, -26.170004f, 16.685923f, 89.786247f, -2.189539f, -13.579331f, 56.560184f, 54.771152f, 26.603344f,
    -50.784908f, -37.853783f, -22.237158f, -10.529336f, -75.668167f, 170.388672f, 64.201385f, 9.919388f, -25.087654f, -97.517700f, -38.260277f, 51.479713f, 98.044075f, 224.824921f, 125.035980f, 68.006523f,
    -13.163634f, 49.532330f, 22.343836f, 23.637941f, -71.608704f, -200.313492f, 22.972029f, -65.936508f, -139.879044f, 109.168282f, 73.714027f, 8.318653f, -33.382645f, -57.808838f, -26.988724f, 70.492950f,
    -57.241489f, -35.265514f, -140.595444f, 85.484810f, 13.172671f, -44.652134f, -64.718590f, 80.219849f, 113.279419f, 8.199357f, 46.910881f, 1.842971f, 6.611537f, 108.265114f, 84.200981f, -15.673004f,
    -54.020992f, -40.065796f, 68.741219f, 89.963760f, -22.845310f, 156.119400f, 40.349724f, 13.827300f, 99.219742f, -10.468677f, -69.469467f, -91.899101f, -28.343006f, -18.399660f, -48.014648f, 18.084986f,
    39.514809f, 117.259254f, 84.999840f, 3.152317f, -89.788651f, -15.256340f, 128.664642f, 16.396799f, -2.824860f, -2.224188f, -108.113235f, -104.294632f, 285.672485f, 258.659821f, 131.015823f, 46.896381f,
    35.400707f, 199.269470f, -50.829807f, -59.871765f, -112.504417f, -87.914078f, -74.663177f, -14.457950f, 3.730728f, 8.424652f, 34.759491f, 5.061568f, 49.715153f, 29.911200f, -4.833649f, -7.921039f,
    79.273865f, 68.455246f, 143.235184f, 29.923138f, -61.068966f, 27.401043f, -93.697815f, 39.637844f, 278.054901f, 207.706467f, 114.287697f, 191.970261f, 28.365456f, -67.643982f, -126.002037f, -324.593506f,
    -38.810867f, 77.219002f, 226.800339f, 84.473801f, -40.547543f, -21.564167f, 131.517456f, 93.058868f, 25.796638f, 24.364828f, -21.709984f, 0.377355f, -100.328873f, -63.233959f, 39.949356f, -20.796144f,
    -49.434875f, 13.246425f, 235.871155f, 150.979660f, 94.417747f, 49.695023f, 9.298592f, 42.695667f, 12.962906f, 29.078457f, 141.417770f, 131.790558f, 139.121719f, 102.666374f, 34.500813f, -11.908920f,
    -2.108662f, 13.590509f, -38.806015f, -50.421722f, -148.383850f, -9.163120f, 221.518173f, 91.873947f, -57.944500f, 7.884820f, -23.169016f, -6.481791f, 39.176830f, -30.829500f, -216.452530f, -132.310471f,
    -60.222321f, -37.813641f, -144.648758f, -74.471680f, -53.668755f, -36.867607f, 163.549622f, 118.314560f, 9.347286f, -64.045303f, 54.008766f, 6.278257f, -3.053545f, 65.511765f, 31.613440f, 28.923603f,
    -68.111702f, -58.754192f, -20.550688f, -9.141284f, 178.296661f, 46.222195f, 85.088615f, 25.129522f, 3.565898f, 73.297729f, 22.594685f, -30.790440f, -60.898556f, -59.714981f, -25.799683f, -26.515989f,
    79.872566f, 27.157415f, -193.357193f, 172.950409f, 131.502487f, -2.173946f, -11.273206f, 11.559188f, -135.590240f, -117.606354f, 162.157654f, 74.852615f, 84.181198f, 42.567123f, 72.688606f, 30.169746f,
    -22.176310f, 8.126409f, -98.820702f, 162.383163f, 130.916565f, 39.752148f, -32.870506f, -173.600403f, 116.578125f, 45.067692f, -27.598148f, 8.555970f, -3.395607f, -42.335846f, -20.110458f, -40.589352f,
    31.181765f, 77.636864f, 60.341606f, 90.832474f, -9.832494f, -111.538925f, 111.043030f, 140.765152f, 80.575752f, 24.432682f, 81.943199f, 20.720406f, 1.215079f, 4.115319f, -68.575241f, -91.525787f,
    -84.731537f, -0.527349f, 25.745188f, 36.190254f, -62.206528f, -86.327141f, -27.536991f, -15.557912f, 32.424694f, 13.717608f, 11.215924f, 22.781013f, 9.574938f, 61.158257f, 61.121010f, 32.403088f,
    -18.375742f, 10.047339f, -50.339001f, -6.936292f, 12.167328f, 150.529266f, 222.465683f, 183.672455f, 58.230515f, 30.788654f, -22.198248f, 57.085861f, 28.043667f, -36.177765f, 171.042053f, 134.737167f,
    0.297151f, 95.241844f, 51.197784f, 41.369175f, 33.568478f, 7.960698f, 55.897408f, 15.283177f, 29.098846f, 91.276161f, 20.340677f, -60.202499f, -171.769867f, -193.836426f, 13.407167f, 121.289520f,
    -77.249527f, -31.146763f, -86.916313f, 13.008453f, -21.325594f, -35.007175f, -0.394985f, 39.783211f, 158.601135f, 162.017731f, 166.716888f, 164.855255f, 145.650070f, 87.215416f, 13.765621f, -16.071383f,
    -11.922022f, 69.904465f, 145.530533f, 137.786896f, 42.237782f, 75.689651f, 121.502434f, 26.309196f, 0.019661f, -62.185799f, -152.175339f, 86.949432f, 41.679405f, 18.519968f, 34.415928f, 25.165304f,
    -9.927750f, 11.307752f, -64.252609f, 131.465469f, 47.641304f, 22.456234f, 36.158360f, -40.804043f, -91.170403f, 86.573074f, -47.294422f, 15.884171f, 222.589951f, 158.826157f, 154.847031f, 224.892197f,
    34.394650f, 50.068573f, -4.612890f, 39.353638f, -13.351929f, 82.855324f, -34.119553f, -198.830780f, 169.354126f, 20.893297f, 2.412445f, -82.652008f, -123.564072f, 148.278564f, 67.057632f, 86.445847f,
    8.496761f, 55.847862f, 9.401371f, -12.230957f, -48.765945f, 339.392365f, 127.588539f, -17.772644f, 73.892937f, -37.477283f, 39.123516f, 58.133339f, -42.253559f, -161.082916f, 77.454605f, 125.429886f,
    43.473793f, 173.585449f, 85.007156f, 42.041813f, -61.597820f, 51.345463f, 44.502201f, -8.306359f, -2.903240f, -41.573891f, 114.340172f, 93.989349f, -18.752844f, 33.966118f, 85.911499f, -5.925835f,
    69.373337f, 94.525620f, 55.872551f, -12.796402f, -57.766541f, 205.378647f, 150.999893f, -34.033718f, 46.349552f, 51.589359f, -9.740956f, 165.190857f, 245.511856f, 140.620789f, 33.383125f, -80.622025f,
    -24.897663f, 9.583753f, 62.261280f, -111.380074f, -93.574211f, 37.958935f, 11.259578f, -85.749733f, -185.118637f, 15.325944f, -47.716419f, -70.300369f, -64.094902f, -120.984238f, -115.879242f, -5.316128f,
    -43.105038f, -38.260498f, -69.155273f, -106.188942f, -215.693817f, -116.750755f, -22.012207f, -17.229620f, 2.833113f, 47.987717f, 6.774336f, -11.583231f, 16.325312f, 30.872992f, 21.988634f, 21.333845f,
    -40.281574f, -19.919075f, 83.175934f, 145.520676f, 74.963409f, -17.649036f, -97.185730f, -32.826363f, -53.159214f, -13.556940f, -30.614326f, -68.210266f, -70.881149f, -25.398729f, -57.834473f, -78.295006f,
    -54.354683f, -53.242130f, -151.652374f, 75.184731f, -12.681744f, -62.721302f, 39.976120f, -84.622726f, -164.732422f, -81.025864f, -59.992664f, 18.575914f, 59.433632f, 91.230606f, 74.121452f, 15.667545f,
    -56.008598f, -36.547680f, -74.135963f, 60.449661f, -43.171642f, 20.404333f, -94.677895f, -134.441208f, -21.513660f, -79.943031f, -11.399878f, -26.450451f, -51.884460f, 13.872990f, -10.700389f, 13.693831f,
    -54.557514f, 14.214915f, -109.558357f, -39.927799f, -80.414780f, -21.436823f, -29.838932f, -133.094101f, 41.575626f, 119.561104f, 108.865402f, 113.994164f, 70.534935f, -74.075966f, -153.541779f, 13.645255f,
    -19.660948f, 72.645828f, 57.090542f, 10.197439f, -82.249893f, -86.073334f, -65.963997f, 26.606983f, 62.380840f, -79.725609f, -67.844391f, -100.735214f, 103.173157f, 41.282562f, -14.417590f, 97.527374f,
    -15.501063f, 10.106770f, 19.181379f, -48.813862f, -54.115250f, 235.424240f, 13.094974f, -96.655479f, -53.639637f, 13.621657f, 1.518511f, 44.934509f, 57.590019f, -41.299301f, -105.937149f, 5.567881f,
    -26.978188f, 39.920815f, 39.867668f, -30.284748f, -137.471680f, -12.073587f, -11.821868f, -56.056862f, -109.460243f, -95.643143f, 71.884705f, 3.678432f, -69.469994f, 46.625034f, 21.143269f, -12.124670f,
    -235.238770f, -189.902191f, -98.019753f, 1.308181f, 6.093620f, -51.336655f, -74.336411f, -58.007866f, -34.142288f, -23.622774f, 21.920612f, 54.356789f, 118.404907f, 98.866112f, 78.824142f, 48.048695f,
    38.583252f, 140.003342f, 104.366905f, 59.575905f, 16.539742f, 143.487717f, 46.418877f, 67.189468f, -16.257248f, -14.486803f, -37.126595f, -97.505363f, -80.173981f, -94.221985f, -115.390350f, -118.126472f,
    14.582953f, 70.503632f, -14.045506f, -19.149410f, -112.971611f, -166.393768f, 175.770172f, 72.728432f, -123.819260f, -84.734123f, -79.798332f, 15.522896f, 9.189954f, 45.245491f, 67.264786f, 21.392374f,
    -30.288527f, 176.278839f, -42.118710f, -113.833649f, 18.178839f, -98.263985f, -5.378097f, -36.394852f, 56.751965f, 34.232403f, -15.896103f, -21.939495f, -36.014275f, -97.239891f, -44.097141f, -21.397247f,
    -57.630421f, -14.344311f, -48.722851f, 4.000876f, -85.091949f, 134.974442f, 96.790924f, 44.602585f, 116.120537f, 108.384445f, 134.965012f, 62.810093f, -51.505104f, -66.570000f, 0.324640f, -61.159451f,
    46.961773f, 91.328773f, 255.896439f, 266.543579f, 55.914829f, 1.617108f, 3.187201f, -8.799063f, 27.105843f, 96.940453f, -6.333913f, -40.912540f, -123.896332f, -219.183456f, -147.103104f, -82.445755f,
    4.730723f, 14.597744f, -4.770158f, 50.178673f, -46.408352f, 46.296600f, 159.859604f, 44.269157f, 25.871405f, 18.163599f, -69.356171f, 99.161255f, 145.530502f, 110.339287f, -78.356651f, -249.688126f,
    -4.995772f, 7.796484f, -231.294037f, 72.029633f, 33.000286f, -63.268135f, 113.155357f, -3.829946f, -48.667412f, 20.674379f, -19.940260f, -66.963058f, -30.490475f, 1.557967f, -21.697649f, -25.190910f,
    -68.609848f, -42.050915f, -81.286026f, -171.873383f, 5.826807f, -37.863060f, 65.958603f, 64.783348f, 16.320978f, 7.862601f, -63.484844f, -35.056782f, 36.112469f, 25.719179f, -27.790937f, -49.815948f,
    -52.712395f, 5.407033f, -50.664661f, -57.217823f, 93.290443f, 86.227432f, 47.213612f, 8.067347f, -70.909805f, -102.342758f, -81.671745f, -96.333832f, -76.863091f, -17.267122f, 0.470240f, 11.259017f,
    45.857506f, 61.279209f, -16.262930f, 65.889984f, 39.496490f, 31.019928f, 10.330289f, -12.880993f, -158.328720f, -214.299026f, 136.159515f, 34.651714f, 58.886429f, 52.877373f, 18.637857f, -97.587326f,
    -83.695442f, -46.231495f, -126.655914f, 84.273537f, 24.091738f, -77.565994f, -121.072006f, -65.358688f, 13.704159f, 17.912792f, 129.792953f, 45.167286f, -76.637970f, -90.235817f, 29.498278f, 22.527498f,
    -38.629421f, -13.281903f, 19.966961f, 21.830301f, -71.014816f, -56.646057f, -183.160706f, 153.295105f, 121.722061f, 122.379555f, 191.160324f, 94.983765f, -38.069660f, -13.902174f, -28.430313f, -3.660168f,
    -61.012142f, -16.898062f, -122.156700f, 40.265934f, -4.676280f, 89.712509f, 77.850525f, -22.210423f, 54.780842f, -9.432448f, -77.245964f, 33.276836f, 8.500788f, 24.147732f, -37.488598f, -50.028263f,
    -13.981007f, -3.172497f, 12.233177f, -3.165506f, -42.713432f, 159.373047f, 120.601517f, 61.609337f, -95.282997f, 154.044556f, 146.461670f, 105.883102f, 35.354893f, -32.637356f, 13.527010f, 52.834805f,
    -59.811607f, 31.116199f, -44.788532f, -25.192825f, 11.671334f, -60.872108f, 94.383209f, 44.916836f, -91.212807f, -106.707802f, -36.229931f, -17.900185f, -138.207123f, -165.818100f, 56.715836f, 45.974777f,
    -7.959111f, 85.271294f, 17.490253f, -50.336193f, -56.605679f, -100.320343f, -152.276581f, -135.327911f, 88.408737f, 129.427505f, 125.965462f, 98.592941f, 27.923223f, 7.087426f, 27.595392f, 42.971786f,
    -25.500626f, 121.667168f, 83.573936f, 3.791471f, -23.845556f, 49.105648f, 81.526443f, 160.776093f, 22.598379f, -98.819115f, -47.420437f, -16.478176f, 46.472534f, -122.984657f, 0.608375f, 57.243511f,
    -12.015658f, -0.135543f, -139.000534f, 151.549393f, 71.025963f, -20.232512f, 95.418777f, -70.840523f, 52.608326f, 22.649012f, -56.357464f, 137.754135f, 50.294880f, -87.514961f, 20.277452f, 193.218811f,
    -111.404922f, -69.059303f, -107.005531f, 53.955250f, 56.233429f, 68.297432f, 9.512801f, -94.675659f, 125.887329f, 141.677551f, 37.625774f, -55.039444f, -107.942078f, -106.586906f, -103.690109f, -31.521854f,
    -7.459867f, 80.387726f, -22.849117f, -7.418187f, -31.289583f, -58.895996f, 121.585495f, 71.303520f, 69.327995f, 33.343830f, -42.588058f, 246.521713f, 44.359360f, -30.136723f, 45.514824f, 33.970772f,
    13.146280f, 37.437431f, 11.781944f, 221.298462f, 64.525116f, -28.227280f, -2.765812f, -60.692303f, -105.971016f, 145.109314f, 29.132435f, -9.364019f, 92.389153f, -40.417786f, -167.946228f, 91.506371f,
    20.380590f, 124.691406f, -34.959442f, -32.687466f, -68.501457f, -12.932295f, 8.627584f, -95.438469f, 34.264408f, 157.920456f, 94.634033f, 154.451233f, 203.167297f, 140.269073f, 62.590698f, -14.471005f,
    -23.798073f, 20.029366f, -28.207727f, -42.335686f, -94.120468f, -119.036964f, -160.177826f, 13.003415f, -10.760310f, -23.243717f, 23.871334f, -25.554195f, -70.506531f, -62.087463f, 52.588543f, 91.934219f,
    -45.170189f, -10.087015f, -66.042885f, -262.296326f, 71.659988f, 42.020767f, -0.749665f, 30.568419f, -84.345169f, -88.957222f, 62.976131f, 17.781088f, 35.814819f, 41.151264f, 100.832329f, 51.108604f,
    -55.090458f, 141.549744f, 45.250282f, 126.572884f, 51.766277f, -4.223619f, -20.867323f, -46.912258f, 12.903956f, -24.562819f, -59.262470f, -34.927166f, -24.950871f, 4.246840f, 14.226479f, -12.156185f,
    -18.676003f, 56.782200f, 24.631006f, 31.817165f, -57.425724f, -164.249939f, -100.221893f, -51.068310f, -151.775375f, -103.694389f, 51.353741f, -14.789831f, 103.796227f, 121.169785f, 67.449203f, 45.746460f,
    -9.249492f, -0.717516f, -95.589256f, -58.979927f, 183.596542f, 82.821739f, -44.961880f, -113.124100f, -73.027855f, 24.111319f, -9.787043f, -20.309830f, -9.503817f, -25.950542f, -63.329922f, -49.288395f,
    -39.281731f, -8.520073f, 12.045630f, 113.941223f, 56.889790f, 11.705962f, -25.992363f, -25.818201f, 41.962906f, 136.173462f, 158.992706f, 71.041000f, -94.766388f, -115.894958f, -100.844521f, -76.998589f,
    -8.995197f, 14.692396f, 10.648182f, 46.508247f, -46.040749f, -30.752420f, -101.055634f, 157.707993f, 120.625099f, -34.914780f, -60.452560f, -125.891411f, -64.873436f, 115.602501f, 134.647278f, 88.401085f,
    -16.291512f, 25.577784f, -57.797333f, -93.257050f, 204.563004f, 23.844887f, 18.521849f, -48.872440f, -34.910671f, 52.242157f, 90.209885f, 155.241089f, 122.966759f, 97.500565f, 51.306534f, 61.434639f,
    5.888782f, 91.756126f, 55.121063f, 59.742477f, -13.308426f, -24.613007f, -59.364792f, -131.265594f, -87.939194f, -56.433189f, -38.294590f, 21.820187f, 22.980511f, -26.082766f, -9.050174f, -5.993128f,
    -109.033333f, -70.663361f, -105.171837f, -29.390360f, 23.201317f, -1.143196f, -0.591588f, -62.349960f, 177.791931f, 64.124794f, 18.023848f, 85.805557f, 57.960117f, -10.079674f, -10.009348f, -11.720422f,
    -1.513953f, 39.937832f, 25.296638f, 52.355652f, 31.179762f, 169.450806f, 131.414230f, 42.987076f, 48.422070f, -2.570796f, -102.850693f, -184.716797f, 126.997742f, 120.658882f, 70.227798f, 51.911579f,
    14.841161f, 42.875328f, -31.856815f, -61.852024f, -95.273911f, -33.013256f, 70.492905f, -26.551783f, -11.850163f, 50.677963f, -74.369408f, 121.694061f, 184.952850f, 83.381836f, 119.151489f, 86.071533f,
    -76.190552f, 217.282104f, -47.804283f, 21.103445f, 63.081154f, 35.664818f, 9.597631f, -78.337799f, 33.574825f, 9.579362f, 11.619099f, -66.239075f, -93.457573f, -67.129135f, -28.104412f, -48.758240f,
    -32.987583f, 55.155075f, -19.071968f, 25.848909f, 147.531418f, 161.891159f, 100.338860f, 122.278191f, 117.346077f, 121.715561f, 59.932480f, -5.041065f, -11.882968f, 25.816359f, 5.152595f, -6.028398f,
    -50.602802f, 47.969971f, 109.523300f, -18.894117f, 104.845932f, 3.333271f, 81.642517f, 48.507870f, 18.322062f, 13.163134f, -27.716911f, -78.545464f, -60.946442f, -21.241007f, -43.533047f, -54.892029f,
    23.136389f, 29.755871f, 115.663109f, 366.295105f, 92.912613f, -56.490879f, -23.877293f, -67.456276f, -41.077976f, 176.197632f, 112.048927f, 87.809334f, 124.036644f, 73.674416f, 55.857883f, -59.281975f,
    36.171646f, 81.249886f, 0.990727f, 62.659752f, -6.243932f, -32.411499f, 103.505295f, -8.062663f, -11.415750f, -33.329777f, -157.624710f, 108.892738f, -52.815735f, -116.408310f, -114.794746f, -108.042885f,
    -53.235435f, -53.853008f, -22.214457f, -62.809551f, -184.508316f, 55.657627f, 60.393047f, 8.903349f, 119.629532f, 99.485672f, 93.179787f, 12.529486f, -36.033150f, 91.600227f, 120.306450f, 101.186569f,
    -266.389862f, -40.268497f, 58.560471f, -15.688929f, 15.476221f, 40.140427f, 70.106178f, 33.398193f, -55.307781f, -54.812614f, 9.501314f, -32.842312f, 1.404359f, 72.411819f, 48.677658f, 19.896832f,
    -30.625458f, -22.088581f, 23.690083f, 147.814285f, 106.761505f, 32.618851f, -56.217175f, -56.086750f, -39.910542f, -27.860449f, 41.870930f, 33.237003f, 14.673645f, 133.780670f, 65.161377f, 29.900471f,
    52.106541f, 97.515167f, -46.684582f, 28.368923f, 50.509525f, -14.864295f, 9.164424f, -87.343681f, -53.357895f, -14.466661f, -124.789276f, 139.007889f, 57.820137f, -198.630005f, 89.412651f, 73.174347f,
    -11.813260f, 28.477610f, 43.814209f, 53.005009f, -31.552076f, 12.509279f, -45.665352f, 0.665018f, 89.380127f, 35.962025f, 56.310169f, 231.104538f, 77.507759f, -6.636252f, -114.024948f, -103.220619f,
    3.209964f, 92.323235f, 134.360977f, 72.508331f, -71.873093f, -24.684990f, -70.873833f, -80.898567f, 36.660206f, 107.964767f, 56.888454f, -41.093380f, -94.986824f, 5.479705f, 85.588272f, 86.314072f,
    2.358892f, 19.563696f, -40.146599f, 106.779350f, 84.014519f, 66.932846f, 7.030437f, -25.116844f, 113.391785f, 69.206184f, -40.131550f, 153.922714f, 143.482407f, 34.324108f, 313.322266f, 143.053925f,
    -22.836403f, 14.444014f, -49.938580f, -50.887901f, -139.897385f, 96.043907f, 97.666435f, -49.784187f, 51.330086f, 49.973110f, 36.349068f, 19.132963f, -131.961868f, -176.490204f, 84.266121f, 168.514481f,
    -37.196350f, -31.474470f, -145.770355f, 73.739777f, -13.749185f, -36.067165f, -73.649986f, 69.205238f, 57.424969f, -29.286839f, 50.821659f, 151.341400f, 196.208405f, 145.900299f, 73.740807f, 59.942463f,
    -48.483910f, 109.854485f, 175.905731f, 107.550728f, 182.661041f, 127.042297f, 56.932144f, -4.789718f, -40.474155f, -4.276073f, 15.682971f, -20.523733f, -2.600147f, 47.862274f, 10.863128f, -28.360899f,
    -38.357815f, 12.670331f, -18.138870f, 42.676201f, 92.674187f, 36.742359f, 52.514660f, -5.668614f, -115.172440f, 43.835323f, 63.331287f, 56.027485f, 115.062248f, 3.782463f, -26.444477f, 273.927704f,
    -70.262749f, -8.360212f, 4.471777f, 3.338549f, 59.435081f, 178.305817f, 71.276756f, -18.074911f, 8.591813f, 75.633720f, 25.886395f, -77.867401f, -98.552505f, 23.158539f, 89.771393f, 55.317135f,
    -43.166435f, -20.516071f, -21.639067f, 58.366417f, -37.861000f, 87.507889f, 228.670868f, 168.987442f, 151.971222f, 95.947609f, 62.651642f, 55.564648f, -1.630664f, -52.394417f, -111.610962f, 110.578148f,
    -3.820340f, 128.265320f, 241.518845f, 81.778282f, 29.058863f, -34.290600f, -72.192398f, -76.477760f, -66.605965f, -11.854634f, 31.504972f, 41.623680f, 49.260410f, 46.350578f, 25.015730f, 0.466101f,
    -74.436829f, -21.117008f, 50.415005f, 41.561440f, 24.320005f, 3.089626f, 84.041313f, 176.202164f, 134.057922f, 109.030365f, 39.151558f, 51.717243f, 205.704620f, 150.353210f, 111.243019f, 26.017376f,
    -0.922336f, 8.721625f, 49.901936f, 20.303036f, -45.592381f, -38.354324f, 58.650257f, -53.023918f, -56.784760f, -43.466248f, -124.796875f, -123.479370f, -110.273987f, -34.595661f, -16.564945f, 34.111702f,
    -30.525043f, -2.907169f, -178.401764f, -44.677608f, -17.348223f, -31.677353f, -14.556618f, -31.867868f, 20.035357f, 2.716418f, -2.513957f, -41.058819f, -52.201744f, 41.795589f, 65.134628f, 38.667267f,
    -92.711220f, -81.188332f, 165.320053f, 146.599762f, 22.146481f, -21.278519f, -40.179806f, -68.613281f, 115.899551f, 67.407913f, 2.306747f, 0.489086f, -1.279717f, 7.199631f, -40.551086f, -8.905237f,
    -56.852066f, -32.516693f, -15.849322f, 68.052765f, 92.856277f, 97.140533f, 38.923428f, -64.162766f, -101.875473f, -63.277794f, -78.587120f, -32.074039f, 106.572845f, 95.851845f, 38.376095f, 15.852232f,
    -53.858379f, -20.356443f, -84.059586f, -105.614822f, -51.119640f, -2.018013f, -77.954140f, -175.482086f, 79.777809f, 19.744781f, -53.635326f, -51.991280f, -49.052460f, -20.029406f, 16.108711f, 24.346910f,
    65.308319f, 24.882250f, -53.676472f, 35.191555f, -75.052139f, -100.669830f, 139.646332f, 26.502867f, -87.489288f, 144.371918f, 85.639999f, -5.127411f, 49.956379f, -68.622177f, -194.561584f, -257.525238f,
    -72.071564f, 88.947922f, 181.188904f, -141.172180f, 21.858112f, 21.690336f, 80.976372f, 74.222694f, 14.965449f, 4.836141f, -13.533607f, 12.946756f, 80.034424f, 18.799646f, -1.797944f, -11.852658f,
    -55.483604f, -28.792759f, -51.127789f, -27.386141f, -3.054134f, 270.684784f, 127.849197f, -7.843138f, -46.675968f, -2.273780f, -41.244320f, 107.264915f, 109.052605f, -57.428146f, -94.478180f, 201.012741f,
    58.417904f, 129.794479f, 88.032875f, -43.482414f, 1.503281f, 18.233082f, -4.274224f, -9.935395f, -90.743645f, -138.744934f, 13.047572f, 99.424622f, 79.562485f, -10.939718f, -128.585876f, -119.279457f,
    -106.237129f, -91.740143f, 68.612770f, 19.771488f, -23.333853f, 6.881060f, -114.409279f, 37.293667f, 27.547070f, -21.962831f, 62.975277f, 126.174873f, 137.661591f, 88.351982f, 21.489727f, 36.082073f,
    49.864040f, 101.988388f, 41.740952f, -2.001927f, -83.519859f, 222.208069f, 203.213120f, 27.999317f, -8.565958f, -46.465588f, -117.948517f, -54.232327f, 28.665607f, -23.274929f, -55.554726f, -66.254654f,
    -52.622940f, -27.317537f, -61.638550f, 130.447021f, 38.187801f, -83.578110f, 91.015823f, 65.975807f, -29.551769f, -55.780457f, -169.249374f, 136.943573f, 43.613983f, 85.860855f, 145.805145f, 83.847832f,
    15.936594f, 90.094734f, -129.895950f, 8.163410f, -8.877759f, -0.308240f, -33.896103f, 62.208805f, 103.766220f, 66.179008f, 27.826544f, -68.158470f, -111.605835f, -60.367783f, -34.454868f, -50.271614f,
    -51.554886f, -21.024059f, -18.746723f, 92.973503f, -20.544609f, -4.456210f, 41.285404f, -2.806954f, 202.912384f, 180.625198f, 93.686058f, 105.542542f, -40.283619f, -22.137281f, 28.882605f, 86.878098f,
    166.593475f, 204.373047f, 175.392639f, 6.547530f, -67.728508f, -1.995924f, 104.944130f, 25.587944f, -76.602921f, 2.406351f, -37.560753f, -66.060905f, 82.223129f, -5.690928f, -80.786980f, -192.349823f,
    5.629341f, 24.807444f, 33.959263f, 139.666183f, 67.254204f, 113.142754f, 5.735409f, -36.896606f, 102.640205f, 13.071086f, -75.008644f, 135.153275f, 112.622955f, 93.684708f, 55.722095f, 17.380138f,
    -78.392647f, 67.183548f, 41.397549f, 47.879723f, -95.470726f, -223.305008f, 34.429707f, 203.257339f, 81.951591f, 24.905951f, -102.131676f, -172.571976f, 80.404175f, -3.289175f, -63.539902f, -178.667999f,
    -8.287517f, 28.750130f, 2.918398f, -190.230972f, 30.998074f, -24.621058f, 57.173183f, 67.070824f, -30.796249f, 125.394531f, 129.483154f, 69.056030f, 61.479782f, 5.587425f, -26.427807f, -42.299709f,
    -53.579803f, 3.932101f, 19.298172f, 60.866375f, 203.507217f, 92.185112f, 4.952492f, 26.875463f, 58.186695f, 23.599648f, -55.879227f, -95.170883f, -128.408905f, -56.559254f, -13.179881f, -6.339478f,
    32.887764f, 110.878929f, 47.881824f, 61.743668f, 32.366764f, -43.335995f, 132.176224f, 23.456560f, -170.514435f, 21.666937f, -6.332648f, 200.979141f, 36.371750f, 69.918137f, 54.659019f, -24.744967f,
    -48.200562f, -14.369913f, -109.873573f, 132.716415f, 33.534492f, 21.027716f, 29.168337f, -6.307217f, 29.464451f, -16.280748f, -5.903169f, -33.134434f, -163.021179f, -114.629570f, 242.579056f, 153.244400f,
    -245.076645f, -119.108864f, 30.076363f, 46.303539f, 62.514118f, -1.635351f, 60.051456f, 85.906593f, 63.114086f, 96.103294f, 94.438263f, 60.414326f, 27.037113f, 46.420849f, 23.188837f, -4.991467f,
    48.128830f, 147.061111f, -19.109028f, -62.073257f, 73.974655f, 35.121407f, 48.858604f, 17.476908f, -27.161577f, -26.075205f, -23.080959f, -22.997204f, 22.060139f, 18.945644f, 12.078902f, 26.152502f,
    -11.399143f, 35.660534f, 7.735845f, 28.895029f, 11.763469f, 67.383682f, 32.067547f, 172.807663f, 41.212330f, -64.892891f, 202.612274f, 66.128975f, 24.998840f, 129.758621f, 97.607491f, 64.079475f,
    16.849846f, -8.063315f, -96.246849f, -42.776253f, -61.709106f, 8.576951f, 41.636856f, 4.893633f, -184.455124f, 90.305283f, 214.893326f, 77.557159f, -52.231232f, -59.771557f, 115.499374f, 10.271899f,
    -52.432972f, -10.506747f, 32.671928f, 30.160530f, -30.343365f, -108.296562f, -124.741348f, -114.153496f, 22.689064f, 53.387943f, 152.464798f, 195.884613f, 223.508789f, 180.783310f, 88.327431f, 24.891722f,
    44.069721f, 128.580154f, 87.081917f, 97.057877f, 80.764305f, 71.377975f, 76.201828f, 19.052254f, -86.244247f, -55.772846f, -78.071259f, 59.358582f, -18.004076f, -97.394165f, 203.970825f, 128.282730f,
    -29.760933f, -17.373451f, -26.997627f, 298.461884f, 135.359589f, -5.173777f, 50.398880f, 16.654043f, -28.228046f, 127.954193f, 88.721756f, 31.046473f, 72.834770f, 51.219566f, 124.174194f, 179.024460f,
    -71.473610f, -8.079115f, -80.057495f, 73.607849f, -11.565989f, 6.495467f, 75.740349f, 69.178413f, 172.751343f, 50.800892f, -29.929661f, -55.132294f, -39.521492f, -34.578106f, 29.018955f, 18.790855f,
    4.944071f, 58.298073f, 72.167747f, -20.213915f, -49.029274f, -5.245622f, 135.798645f, 114.233170f, 48.812248f, 154.565750f, 91.869995f, 9.594048f, 29.263868f, 29.942837f, 60.248390f, 56.068134f,
    20.676535f, 129.442535f, 114.557922f, 65.585472f, 9.776167f, 76.209824f, 142.460770f, 65.045479f, 31.220121f, 68.550804f, 85.770195f, 65.380852f, 33.190002f, -80.774033f, -170.538605f, 61.262844f,
    -23.503824f, 198.854172f, 14.658221f, 54.346264f, 29.317448f, -15.893962f, 6.081978f, 50.519886f, 129.337723f, 125.421761f, 131.127838f, 197.853912f, 207.257065f, 154.032959f, 90.113098f, 66.989784f,
    -62.626553f, 0.772200f, -28.967108f, -85.223953f, -146.385803f, 82.958099f, -24.949381f, 93.786552f, 94.234512f, -39.738564f, -74.894165f, -36.566628f, -39.978264f, 3.580493f, -15.366054f, -32.318130f,
    -54.913471f, 12.737958f, -117.342049f, -59.757664f, -14.541400f, -24.570677f, -20.895752f, -18.573147f, -31.541250f, 3.822062f, 63.816460f, 68.993881f, 96.323494f, 113.108215f, 60.914867f, 38.452541f,
    -74.699921f, -33.957706f, 274.636505f, 42.985191f, -13.963601f, 35.379383f, 27.960144f, -9.738332f, 15.494253f, -5.034236f, -48.640007f, -28.968740f, -24.268768f, 34.582504f, 11.429268f, 13.275120f,
    32.094368f, 53.997974f, 58.552933f, 60.038021f, 15.307313f, -14.686091f, -79.145950f, -92.266304f, 6.606106f, -31.398434f, 1.153621f, 61.459366f, 211.102783f, 199.088348f, 139.181458f, 90.360237f,
    13.961225f, 107.374969f, -42.851105f, 111.353691f, 85.895554f, -10.314037f, -36.885490f, -48.654755f, -86.748146f, -13.811635f, -28.521486f, -133.376526f, 66.836365f, 63.232780f, 50.980137f, 33.082199f,
    0.719331f, 59.833492f, 52.997120f, 109.368217f, 78.191238f, 181.871460f, 110.776367f, 41.572018f, 32.371555f, 59.911247f, 100.121117f, 147.708542f, 67.625221f, -90.737854f, -184.544220f, -95.008667f,
    17.476965f, 51.444233f, 130.136398f, 86.703789f, -21.260557f, -68.970932f, -246.970169f, 111.624298f, 106.618408f, -70.539291f, -17.852840f, 74.588875f, 22.676432f, 82.200706f, 75.469940f, 86.911079f,
    -21.763515f, 88.468819f, 69.462051f, 28.234957f, 137.905060f, 97.628418f, 100.231453f, 71.048729f, -26.023251f, 18.455929f, 100.078911f, 91.618004f, 129.572266f, 162.295929f, 117.883362f, 73.251602f,
    20.503130f, 123.177406f, 98.707054f, -61.945675f, -133.366302f, -42.585499f, 17.451960f, -85.110466f, -109.559792f, 57.105164f, 49.939404f, 71.494247f, 106.595436f, -5.332850f, -10.096909f, 95.286079f,
    -98.944687f, -70.735931f, -91.238235f, 77.213318f, 43.834396f, 103.931374f, 14.455284f, -18.546854f, 60.298130f, 69.783432f, 81.150307f, 75.219597f, 117.014557f, 133.318222f, 45.655605f, 44.907104f,
    -17.773401f, 16.685305f, 35.210880f, 58.453514f, -39.141315f, 154.492096f, 160.108368f, 54.245167f, 143.091782f, 18.370985f, -46.498653f, 30.260704f, -32.253002f, 114.865051f, 94.643227f, 42.126125f,
    8.305405f, 73.466248f, 71.895737f, 7.841229f, -21.096027f, -83.805069f, 142.372986f, 32.864574f, -67.817047f, 0.273488f, -20.763456f, -39.558540f, 45.929173f, 245.427109f, 63.606354f, -33.662392f,
    -9.818366f, 215.528351f, -34.979908f, -46.600666f, -52.985126f, -36.442551f, -23.177917f, 89.040405f, 115.907364f, 85.734955f, 85.459145f, 53.537971f, 38.606289f, 35.117779f, -9.532898f, -46.531116f,
    70.627678f, 109.927406f, 130.617371f, 127.965912f, 68.237038f, 175.485825f, 141.335297f, 101.838699f, 85.440056f, 100.211769f, -9.782224f, -34.040447f, -36.362839f, -103.141747f, -183.433182f, -281.405945f,
    13.631050f, 103.082298f, 153.487061f, 95.539291f, 80.014320f, 47.319462f, -47.897068f, 144.786728f, 150.994034f, 33.507248f, 38.446999f, -11.836577f, -52.710697f, -5.434279f, -6.585646f, -43.525864f,
    -46.841568f, -36.090340f, 91.028366f, 223.865204f, 162.487579f, 161.622040f, 92.281693f, 72.600441f, 62.700375f, 116.998756f, 104.000122f, 56.268940f, 3.313947f, 39.044933f, 12.683829f, -66.421524f,
    -53.988426f, -4.046704f, -43.765293f, -58.490433f, -61.409744f, 68.780487f, 180.177185f, 130.743820f, 59.566154f, 41.610359f, -29.455439f, -47.845570f, -53.330845f, -194.252975f, -99.193802f, -28.624321f,
    -40.226192f, 19.173496f, -102.776230f, -115.559639f, -2.041245f, 17.804632f, 54.120743f, 35.981876f, 107.003677f, 67.225113f, 6.590813f, 31.162287f, 75.625832f, 94.116089f, 68.273361f, 19.100948f,
    -81.027779f, -47.543785f, -81.577866f, 147.072006f, 140.771072f, 98.894592f, 98.462875f, 120.500710f, 69.188560f, -27.267778f, -26.730125f, 19.004963f, 28.982193f, 18.988167f, 15.679336f, 0.912693f,
    60.063290f, 68.444176f, -38.306652f, 274.795166f, 81.706596f, 1.653586f, 59.518078f, 81.843979f, 45.452694f, -98.132660f, 99.485909f, 72.635452f, 59.011009f, 43.986206f, 68.393044f, 153.643753f,
    -54.196396f, 105.024605f, -46.588734f, 29.173431f, 46.003738f, 53.556526f, -1.795008f, -94.732422f, 74.060417f, 37.018723f, 57.519180f, 40.312252f, 4.980567f, 1.190214f, 65.139198f, 16.854973f,
    83.697479f, 124.012848f, 136.707169f, 105.191093f, 50.574764f, 7.427887f, 165.615936f, 120.431198f, 35.935490f, 146.632690f, 107.372086f, 101.817780f, 178.695389f, 32.956997f, -43.566265f, -170.662201f,
    -45.706387f, 22.193432f, 48.583588f, 7.809529f, 108.639076f, 20.145479f, -8.151466f, 16.626425f, 45.076824f, 100.699867f, 56.172535f, 31.245377f, 41.698193f, 43.700226f, 33.969212f, 13.647820f,
    30.930534f, 96.241432f, 20.796177f, 20.642069f, -30.030577f, 105.024353f, 182.286652f, 51.891121f, -23.670610f, 19.259420f, -25.995207f, 144.711807f, 151.061661f, 39.095882f, 216.597061f, 151.033951f,
    55.972961f, 165.229263f, 42.423416f, -9.421596f, 9.304959f, -24.490530f, 65.337448f, 0.772096f, 34.500309f, 28.041000f, 164.460770f, 148.005341f, -44.788933f, -131.866653f, 118.602074f, 174.952545f,
    -36.805115f, 2.389628f, -160.064590f, -74.493019f, -34.030777f, -37.621536f, 21.365028f, 11.060207f, 72.113487f, 151.263977f, 203.227783f, 232.426346f, 240.348846f, 198.561386f, 130.545105f, 79.279305f,
    -5.590322f, 28.170464f, 31.049704f, 123.245987f, 143.256638f, 251.395782f, 35.744690f, -42.437420f, -26.080673f, 16.841845f, 18.203182f, 83.183998f, 68.937943f, -68.034676f, 4.653465f, 101.861214f,
    75.410370f, 146.164398f, 101.675415f, 188.854752f, 65.271072f, -0.098294f, 44.761238f, -45.286770f, -80.445572f, 95.316223f, -28.573139f, 1.249410f, 194.675003f, 77.615021f, 9.229208f, 122.592499f,
    -53.932175f, 216.979111f, -2.220833f, 63.310429f, 91.275101f, 57.843071f, 70.857147f, 42.466930f, 77.749489f, 57.652969f, 21.516739f, -1.124474f, -30.274309f, -13.056955f, 15.011532f, -30.375456f,
    67.425507f, 84.229256f, 101.499359f, 28.049738f, -35.614960f, 320.076202f, 252.214386f, 152.618103f, 138.893570f, 99.840240f, 27.951473f, 49.207226f, 65.402916f, 7.603233f, -14.404366f, -35.147362f,
    -19.139826f, 222.586807f, 160.578033f, 15.308187f, 37.928532f, 2.810670f, 89.260468f, 73.903893f, -14.074634f, 9.220748f, 52.358765f, 29.237804f, 68.572754f, 74.369972f, 135.163269f, 53.634529f,
    27.498774f, 55.932766f, 90.594849f, 106.451241f, 66.339134f, 276.491119f, 112.921783f, 68.186401f, 34.717724f, 217.367447f, 183.300674f, 171.332642f, 233.111526f, 113.635857f, -94.105415f, 101.164040f
};

/*----------------------------------------------------------------------------------*
 * LSF quantization - Scaling factors
 *----------------------------------------------------------------------------------*/

/* stable ISP vector */
const float stable_ISP[M] =
{
    0.9808f, 0.9239f, 0.8315f, 0.7071f, 0.5556f, 0.3827f, 0.1951f, 0.0f, -0.195f, -0.3826f, -0.5555f, -0.7071f, -0.8314f, -0.9238f, -0.9808f, 0.045f
};

/* stable ISF vector */
const float stable_ISF[M] =
{
    399.846527f, 799.890991f, 1199.888550f, 1600.019531f, 1999.927002f, 2399.963379f, 2799.979736f, 3200.0f, 3599.812256f, 3999.815918f, 4399.827637f, 4799.980469f, 5199.744629f, 5599.576660f, 6000.153320f, 1554.147827f
};

/* stable LSP vector (corresponds to GEWB_Ave[]) */
const float stable_LSP[M] =
{
    0.9899f, 0.9667f, 0.8998f, 0.7837f, 0.6581f, 0.5009f, 0.3307f, 0.1643f, -0.0224f, -0.1955f, -0.3658f, -0.5200f, -0.6730f, -0.8040f, -0.9057f,-0.9700f
};


/*----------------------------------------------------------------------------------*
 * LSF quantization - Mean LSF vectors
 *----------------------------------------------------------------------------------*/
/* These are  not used anywhere */
/*   A 16-by-1 matrix */
const float means_wb_cleanspeech_lsf16k0[16] = {355.08f, 696.48f, 1260.55f, 1735.55f, 2220.70f, 2676.17f, 3123.44f, 3560.94f, 3989.45f, 4399.61f, 4869.14f, 5372.66f, 5894.53f, 6364.45f, 6883.20f, 7302.73f};
/*   A 16-by-1 matrix */
const float means_swb_cleanspeech_lsf25k6[16] = {614.44f, 1437.24f, 2259.37f, 2994.68f, 3732.57f, 4420.10f, 5187.93f, 5985.97f, 6790.66f, 7523.16f, 8283.87f, 9010.86f, 9757.03f, 10458.90f, 11209.84f, 11888.64f};
/*   A 16-by-1 matrix */
const float means_swb_cleanspeech_lsf32k0[16] = {739.65f,  1811.71f, 2794.79f, 3708.53f, 4594.87f, 5528.75f, 6583.99f, 7512.05f, 8455.51f,  9352.67f, 10266.73f, 11133.74f, 12067.91f, 12958.21f, 13940.67f, 14794.15f};

/*   An 16-by-1 matrix */
const float SVWB2_Ave[16] =
{
    389.8438f, 581.2500f, 1047.6563f, 1493.3594f, 1985.9375f, 2462.8906f, 2923.8281f, 3392.9688f, 3851.9531f, 4298.4375f, 4819.9219f, 5337.5000f, 5893.7500f, 6378.9063f, 6899.6094f, 7325.7813f
};
/*   An 16-by-1 matrix */
const float IANB_Ave[16] =
{
    283.5938f, 559.7656f, 973.8281f, 1331.2500f, 1695.3125f, 2037.1094f, 2383.9844f, 2713.6719f, 3035.9375f, 3334.3750f, 3614.0625f, 3910.9375f, 4261.3281f, 4854.2969f, 5467.5781f, 5934.7656f
};
/*   An 16-by-1 matrix */
const float IAWB_Ave[16] =
{
    225.3906f, 527.3438f, 986.7188f, 1380.8594f, 1773.0469f, 2150.0000f, 2537.8906f, 2914.0625f, 3298.8281f, 3670.3125f, 4051.1719f, 4421.4844f, 4807.4219f, 5182.8125f, 5566.0156f, 5940.2344f
};
/*   An 16-by-1 matrix */
const float IAWB2_Ave[16] =
{
    285.5469f, 694.1406f, 1247.6563f, 1713.2813f, 2198.8281f, 2658.5938f, 3129.6875f, 3579.6875f, 4034.7656f, 4480.0781f, 4973.0469f, 5483.2031f, 5986.7188f, 6460.1563f, 6953.5156f, 7393.3594f
};
/*   An 16-by-1 matrix */
const float UVNB_Ave[16] =
{
    397.6563f, 689.0625f, 1115.6250f, 1465.2344f, 1801.1719f, 2113.2813f, 2434.7656f, 2719.1406f, 3001.9531f, 3243.7500f, 3460.5469f, 3642.5781f, 3897.2656f, 4586.3281f, 5351.1719f, 5888.2813f
};
/*   An 16-by-1 matrix */
const float UVWB_Ave[16] =
{
    350.7813f, 742.1875f, 1239.0625f, 1636.7188f, 2023.8281f, 2406.6406f, 2786.7188f, 3150.7813f, 3513.6719f, 3862.5000f, 4212.5000f, 4545.3125f, 4893.3594f, 5232.8125f, 5586.3281f, 5930.8594f
};
/*   An 16-by-1 matrix */
const float SVNB_Ave[16] =
{
    347.6563f, 495.3125f, 753.9063f, 1133.5938f, 1538.2813f, 1883.9844f, 2278.1250f, 2595.3125f, 2924.6094f, 3203.9063f, 3478.9063f, 3728.5156f, 4214.0625f, 4908.2031f, 5452.7344f, 5930.8594f
};
/*   An 16-by-1 matrix */
const float SVWB_Ave[16] =
{
    325.0000f, 487.5000f, 761.3281f, 1204.2969f, 1613.6719f, 1998.8281f, 2413.6719f, 2760.5469f, 3128.1250f, 3485.1563f, 3857.4219f, 4195.7031f, 4603.5156f, 5023.4375f, 5456.2500f, 5878.1250f
};
/*   An 16-by-1 matrix */
const float GEWB_Ave[16] =
{
    289.8438f, 527.3438f, 919.5313f, 1365.2344f, 1736.7188f, 2131.2500f, 2513.2813f, 2863.6719f, 3245.7031f, 3600.7813f, 3962.8906f, 4314.0625f, 4703.9063f, 5102.7344f, 5508.2031f, 5899.6094f
};
/*   An 16-by-1 matrix */
const float GEWB2_Ave[16] =
{
    355.0781f, 696.4844f, 1260.5469f, 1735.5469f, 2220.7031f, 2676.1719f, 3123.4375f, 3560.9375f, 3989.4531f, 4399.6094f, 4869.1406f, 5372.6563f, 5894.5313f, 6364.4531f, 6883.2031f, 7302.7344f
};
/*   An 16-by-1 matrix */
const float GENB_Ave[16] =
{
    326.5625f, 525.0000f, 881.6406f, 1274.6094f, 1630.0781f, 1965.2344f, 2324.2188f, 2619.9219f, 2935.1563f, 3216.4063f, 3469.1406f, 3687.1094f, 4059.7656f, 4775.7813f, 5412.1094f, 5912.1094f
};
/*   An 16-by-1 matrix */
const float TRNB_Ave[16] =
{
    358.9844f, 521.4844f, 822.6563f, 1227.3438f, 1598.4375f, 1928.9063f, 2306.6406f, 2605.4688f, 2925.7813f, 3202.7344f, 3464.0625f, 3689.0625f, 4118.7500f, 4837.1094f, 5429.6875f, 5920.3125f
};
/*   An 16-by-1 matrix */
const float TRWB_Ave[16] =
{
    325.7813f, 517.9688f, 840.2344f, 1305.0781f, 1681.6406f, 2069.9219f, 2467.9688f, 2811.7188f, 3190.2344f, 3543.3594f, 3906.6406f, 4244.9219f, 4637.1094f, 5043.7500f, 5463.2813f, 5877.3438f
};
/*   An 16-by-1 matrix */
const float TRWB2_Ave[16] =
{
    369.1406f, 603.9063f, 1119.5313f, 1621.0938f, 2086.7188f, 2565.6250f, 2992.1875f, 3441.0156f, 3864.8438f, 4271.0938f, 4753.9063f, 5303.5156f, 5851.9531f, 6359.3750f, 6880.4688f, 7335.1563f
};
/*   An 16-by-1 matrix */
const float AUNB_Ave[16] =
{
    346.4844f, 563.6719f, 920.3125f, 1247.6563f, 1603.5156f, 1933.2031f, 2281.6406f, 2591.7969f, 2905.0781f, 3195.7031f, 3463.6719f, 3702.3438f, 4056.6406f, 4758.5938f, 5413.2813f, 5910.5469f
};
/*   An 16-by-1 matrix */
const float AUWB_Ave[16] =
{
    316.4063f, 573.4375f, 967.1875f, 1334.7656f, 1717.1875f, 2086.7188f, 2465.2344f, 2818.3594f, 3191.7969f, 3546.0938f, 3917.9688f, 4284.7656f, 4692.9688f, 5107.4219f, 5525.7813f, 5911.3281f
};
/*   An 16-by-1 matrix */
const float AUWB2_Ave[16] =
{
    364.4531f, 681.6406f, 1187.5000f, 1623.8281f, 2101.1719f, 2535.1563f, 2986.7188f, 3408.2031f, 3848.4375f, 4269.5313f, 4771.0938f, 5330.8594f, 5883.5938f, 6366.0156f, 6889.0625f, 7331.2500f
};
/*   An 16-by-1 matrix */
const float Predictor0[16] =
{
    0.83499f, 0.83499f, 0.83499f, 0.82999f, 0.82999f, 0.82999f, 0.80499f, 0.80750f, 0.79999f, 0.79300f, 0.80750f, 0.80750f, 0.79300f, 0.78500f, 0.78500f, 0.75500f
};
/*   An 16-by-1 matrix */
const float Predictor1[16] =
{
    0.82501f, 0.82501f, 0.82501f, 0.81299f, 0.80301f, 0.81299f, 0.81299f, 0.79749f, 0.79999f, 0.79999f, 0.80750f, 0.82001f, 0.82001f, 0.81500f, 0.82501f, 0.81299f
};
/*   An 16-by-1 matrix */
const float Predictor2[16] =
{
    0.73999f, 0.72000f, 0.74799f, 0.73999f, 0.74799f, 0.73300f, 0.73300f, 0.72501f, 0.72501f, 0.73300f, 0.73999f, 0.73999f, 0.72000f, 0.70499f, 0.72000f, 0.70499f
};
/*   An 16-by-1 matrix */
const float Predictor3[16] =
{
    0.73999f, 0.73999f, 0.75500f, 0.73999f, 0.74799f, 0.72501f, 0.71500f, 0.70499f, 0.69000f, 0.70499f, 0.72000f, 0.75500f, 0.76300f, 0.75500f, 0.76300f, 0.75800f
};
/*   An 16-by-1 matrix */
const float Predictor4[16] =
{
    0.57999f, 0.56000f, 0.58801f, 0.57999f, 0.58801f, 0.57300f, 0.57300f, 0.56500f, 0.56500f, 0.57300f, 0.57999f, 0.57999f, 0.56000f, 0.54501f, 0.54001f, 0.52499f
};
/*   An 16-by-1 matrix */
const float Predictor5[16] =
{
    0.72751f, 0.72000f, 0.72000f, 0.72751f, 0.72751f, 0.72000f, 0.72000f, 0.72000f, 0.72751f, 0.73499f, 0.74301f, 0.75000f, 0.75000f, 0.71301f, 0.71301f, 0.71301f
};
/*   An 16-by-1 matrix */
const float Predictor6[16] =
{
    0.73499f, 0.72751f, 0.73499f, 0.72000f, 0.72000f, 0.70001f, 0.68301f, 0.66501f, 0.64499f, 0.67001f, 0.68301f, 0.74301f, 0.75000f, 0.72000f, 0.75000f, 0.74301f
};
/*   An 16-by-1 matrix */
const float Predictor7[16] =
{
    0.74301f, 0.73499f, 0.74301f, 0.74301f, 0.74301f, 0.73499f, 0.74301f, 0.75000f, 0.75000f, 0.75500f, 0.76501f, 0.74301f, 0.73499f, 0.72751f, 0.71301f, 0.75500f
};
/*   An 16-by-1 matrix */
const float Predictor8[16] =
{
    0.75500f, 0.75500f, 0.75500f, 0.75000f, 0.75000f, 0.75000f, 0.73499f, 0.72751f, 0.72000f, 0.71301f, 0.72751f, 0.72751f, 0.71301f, 0.70499f, 0.70499f, 0.67499f
};
/*   An 16-by-16 matrix */
const float UVD_MA1[256] =
{
    -117.5781f, -196.4844f, -166.4063f, -73.0469f, -51.1719f, -25.0000f, -17.5781f, -7.8125f, 4.2969f, 21.8750f, 24.6094f, 35.1563f, 42.9688f, 68.3594f, 37.8906f, 12.8906f,
    62.8906f, 137.8906f, 185.1563f, 196.0938f, 276.9531f, 305.4688f, 310.1563f, 298.8281f, 246.8750f, 207.8125f, 158.5938f, 111.3281f, 89.8438f, 56.6406f, 37.8906f, 20.3125f,
    -14.4531f, -1.9531f, 80.0781f, 126.1719f, 160.9375f, 136.3281f, 86.3281f, 35.5469f, -2.3438f, -23.0469f, -33.5938f, -43.7500f, -12.5000f, 81.6406f, 28.5156f, 8.9844f,
    -106.6406f, -240.2344f, -320.3125f, -310.1563f, -325.7813f, -327.3438f, -321.0938f, -319.9219f, -293.3594f, -273.8281f, -250.3906f, -219.5313f, -152.7344f, -105.8594f, -71.8750f, -24.6094f,
    102.3438f, 65.6250f, 40.6250f, -3.5156f, -30.4688f, -63.6719f, -55.0781f, -77.7344f, -74.6094f, -97.2656f, -95.7031f, -123.8281f, -65.6250f, 208.9844f, 42.5781f, 12.8906f,
    -160.1563f, -263.6719f, -266.0156f, -238.6719f, -195.3125f, -154.6875f, -106.6406f, -71.4844f, -18.3594f, 23.4375f, 75.7813f, 139.4531f, 407.8125f, 421.8750f, 130.8594f, 54.6875f,
    60.1563f, 72.2656f, 100.0000f, 92.9688f, 79.2969f, 92.9688f, 109.3750f, 101.5625f, 117.1875f, 104.2969f, 100.7813f, 76.5625f, 47.2656f, -241.4063f, -102.7344f, -23.4375f,
    134.7656f, 275.3906f, 335.5469f, 307.0313f, 290.2344f, 228.1250f, 166.0156f, 104.2969f, 65.6250f, 41.0156f, 28.9063f, 10.9375f, 46.4844f, 104.2969f, 41.0156f, 15.2344f,
    -15.2344f, -64.8438f, -89.8438f, -76.5625f, -99.6094f, -107.8125f, -124.2188f, -136.3281f, -151.1719f, -171.0938f, -210.5469f, -239.4531f, -293.7500f, -373.4375f, -528.5156f, -635.9375f,
    194.5313f, 187.1094f, 161.7188f, 90.2344f, 38.2813f, 1.9531f, -7.0313f, -16.0156f, -23.4375f, -30.4688f, -35.5469f, -37.5000f, -31.6406f, 28.1250f, 11.7188f, -3.1250f,
    16.0156f, 46.8750f, 25.3906f, 55.0781f, 45.7031f, 72.6563f, 97.2656f, 116.7969f, 163.2813f, 203.1250f, 221.0938f, 241.4063f, 270.3125f, 226.1719f, 125.3906f, 64.8438f,
    -92.1875f, -108.5938f, -26.9531f, 5.0781f, 44.1406f, 141.4063f, 173.8281f, 210.5469f, 196.4844f, 151.1719f, 105.0781f, 67.1875f, 46.8750f, -8.2031f, 0.3906f, 1.5625f,
    -40.2344f, -17.9688f, -53.5156f, -51.5625f, -42.1875f, -37.8906f, -26.1719f, -14.4531f, -3.1250f, 16.0156f, 32.0313f, 41.7969f, 16.7969f, -236.3281f, -73.8281f, -21.8750f,
    -85.9375f, -123.0469f, -188.2813f, -201.5625f, -191.0156f, -173.8281f, -162.1094f, -141.4063f, -118.7500f, -80.0781f, -53.1250f, -26.5625f, -2.7344f, 51.1719f, 27.3438f, 9.7656f,
    -3.9063f, -47.2656f, -82.0313f, -92.5781f, -87.5000f, -117.9688f, -96.0938f, -121.0938f, -105.8594f, -133.9844f, -111.3281f, -142.1875f, 10.9375f, 274.6094f, 52.7344f, 21.0938f,
    46.0938f, 19.5313f, -26.1719f, -64.8438f, -136.3281f, -162.5000f, -172.6563f, -174.2188f, -171.4844f, -164.0625f, -149.2188f, -124.6094f, -95.7031f, -81.6406f, -54.6875f, -32.0313f
};
/*   An 16-by-16 matrix */
const float UVD_MA2[256] =
{
    -29.2969f, -25.0000f, -58.5938f, -90.2344f, -106.2500f, -108.5938f, -96.8750f, -75.7813f, -60.9375f, -41.7969f, -28.9063f, -16.7969f, -35.9375f, -8.2031f, 3.5156f, 1.9531f,
    153.5156f, 107.4219f, -4.6875f, -60.9375f, -81.2500f, -83.9844f, -63.2813f, -51.5625f, -44.9219f, -42.5781f, -36.7188f, -33.2031f, -40.6250f, -3.9063f, 1.9531f, -0.3906f,
    -116.0156f, -151.9531f, -38.6719f, -30.4688f, -25.7813f, -7.4219f, -4.6875f, 3.1250f, 0.0000f, -1.1719f, -5.8594f, -8.5938f, -44.1406f, -32.0313f, -6.2500f, 0.7813f,
    23.0469f, -4.2969f, 1.9531f, -12.8906f, -4.2969f, -23.8281f, -27.3438f, -54.2969f, -55.8594f, -93.3594f, -80.8594f, -87.1094f, 277.7344f, 273.8281f, 55.8594f, 26.5625f,
    -76.1719f, 158.5938f, 86.7188f, 19.1406f, -2.3438f, -8.9844f, -2.3438f, 3.5156f, 0.0000f, 5.0781f, 10.1563f, 19.1406f, -17.1875f, -50.3906f, -7.0313f, -2.7344f,
    8.9844f, -11.7188f, -55.0781f, 30.8594f, -7.0313f, -29.6875f, -21.4844f, -5.4688f, 17.1875f, 38.2813f, 34.3750f, 33.5938f, -37.5000f, -137.1094f, -43.7500f, -15.2344f,
    148.4375f, 128.5156f, 91.7969f, 67.5781f, 55.0781f, 28.1250f, 9.7656f, -1.5625f, -2.3438f, -7.4219f, -8.2031f, -12.8906f, -21.4844f, -8.9844f, 1.1719f, -0.3906f,
    -31.6406f, -82.0313f, -110.9375f, 61.7188f, 154.6875f, 113.2813f, 63.6719f, 23.0469f, -9.7656f, -8.5938f, -3.9063f, -2.3438f, -17.9688f, -12.5000f, 3.5156f, 1.9531f,
    3.5156f, 13.2813f, -5.8594f, 1.9531f, 8.9844f, -18.7500f, -49.6094f, -94.9219f, -135.5469f, -164.4531f, -177.7344f, -185.5469f, -193.3594f, -175.3906f, -114.8438f, -63.6719f,
    -5.0781f, -66.7969f, -162.5000f, -161.7188f, -95.7031f, -9.7656f, 26.9531f, 39.8438f, 40.6250f, 32.8125f, 19.5313f, 12.8906f, -14.8438f, -1.5625f, 0.0000f, 1.9531f,
    19.5313f, 46.0938f, 26.5625f, 14.4531f, 57.4219f, 124.6094f, 144.9219f, 138.6719f, 113.6719f, 79.6875f, 50.7813f, 31.6406f, 8.2031f, 17.9688f, 14.0625f, 8.5938f,
    -37.1094f, -42.1875f, 121.4844f, 83.5938f, -10.9375f, -59.7656f, -88.2813f, -75.0000f, -50.3906f, -26.9531f, -16.4063f, -4.2969f, -18.7500f, -6.6406f, 5.0781f, 0.7813f,
    -72.2656f, -87.1094f, -40.6250f, 10.1563f, 20.7031f, 34.7656f, 51.5625f, 70.7031f, 100.7813f, 135.1563f, 155.0781f, 173.8281f, 153.1250f, 94.1406f, 48.8281f, 22.6563f,
    32.4219f, 12.8906f, -3.5156f, -31.6406f, 15.6250f, 38.6719f, 21.8750f, 3.1250f, -19.9219f, -33.2031f, -41.4063f, -48.4375f, -76.5625f, 1.9531f, 1.9531f, 0.0000f,
    55.8594f, 57.8125f, 7.4219f, -47.2656f, -96.4844f, -82.4219f, -26.1719f, 32.4219f, 77.3438f, 104.6875f, 113.2813f, 117.1875f, 93.7500f, 64.0625f, 33.5938f, 14.4531f,
    -77.3438f, -53.1250f, 144.5313f, 145.3125f, 117.1875f, 93.7500f, 60.9375f, 44.1406f, 30.8594f, 23.4375f, 17.1875f, 11.3281f, -13.6719f, -14.8438f, 2.3438f, 2.7344f
};
/*   An 16-by-16 matrix */
const float UVWB_MA3[256] =
{
    -10.1563f, 8.9844f, 2.7344f, -2.3438f, -0.3906f, 1.1719f, 15.6250f, 13.6719f, -16.7969f, -9.3750f, 21.8750f, 61.3281f, 103.5156f, 165.2344f, 149.2188f, 101.5625f,
    23.8281f, -117.1875f, -50.7813f, -39.4531f, -3.1250f, 41.4063f, 42.1875f, 44.5313f, 34.3750f, 16.7969f, -0.7813f, -12.8906f, -21.8750f, 26.1719f, 11.3281f, 5.0781f,
    -12.1094f, 18.3594f, 17.5781f, -47.2656f, 17.9688f, 8.5938f, 43.3594f, 91.0156f, -100.0000f, -98.4375f, -48.0469f, -27.7344f, -12.1094f, 21.0938f, 21.8750f, 12.8906f,
    7.8125f, -60.1563f, 26.1719f, 77.3438f, -90.6250f, -65.2344f, -33.5938f, -4.6875f, 30.8594f, 45.3125f, 34.3750f, 30.4688f, 17.1875f, 29.2969f, 10.5469f, -2.7344f,
    -5.4688f, 59.7656f, -64.8438f, 8.2031f, 41.7969f, 25.0000f, 91.0156f, -87.1094f, -57.4219f, -10.5469f, -0.3906f, 16.7969f, 23.8281f, 27.3438f, 19.5313f, 7.0313f,
    1.1719f, -44.9219f, -3.1250f, 55.8594f, 75.0000f, 75.3906f, -48.4375f, -76.1719f, -77.3438f, -63.2813f, -29.2969f, 5.4688f, 17.5781f, 32.4219f, 30.8594f, 19.1406f,
    4.6875f, -22.2656f, 9.7656f, -11.3281f, -4.2969f, 4.6875f, -2.7344f, -5.0781f, -4.6875f, 12.1094f, 28.9063f, 38.6719f, -3.9063f, -164.4531f, -81.6406f, -43.3594f,
    -9.7656f, 44.9219f, 46.4844f, -7.4219f, -45.7031f, -64.0625f, -79.2969f, -92.5781f, -80.4688f, -66.0156f, -42.9688f, -16.0156f, -4.2969f, 5.8594f, 0.3906f, -2.7344f,
    -5.0781f, 66.4063f, -55.8594f, -50.0000f, -87.5000f, -36.7188f, 0.3906f, 37.5000f, 56.2500f, 39.8438f, 11.3281f, 0.7813f, -14.4531f, 17.9688f, 2.7344f, -4.6875f,
    -4.2969f, 3.9063f, -13.2813f, 14.8438f, 9.3750f, 33.5938f, 58.2031f, 82.4219f, 93.7500f, 108.9844f, 96.4844f, 85.1563f, 60.1563f, 62.8906f, 28.9063f, 5.8594f,
    -9.3750f, 25.0000f, 42.9688f, 48.8281f, -9.3750f, 48.0469f, 62.8906f, 64.8438f, 69.1406f, 7.0313f, -43.7500f, -45.3125f, -55.0781f, -45.7031f, -44.1406f, -35.5469f,
    -1.5625f, -7.8125f, -6.6406f, -4.2969f, -10.5469f, 5.0781f, -5.8594f, -15.6250f, -22.6563f, -61.3281f, -98.4375f, -110.5469f, -112.5000f, -72.6563f, -63.2813f, -43.7500f,
    -7.8125f, 0.7813f, 12.5000f, 17.1875f, -12.1094f, -19.1406f, 3.1250f, 5.0781f, 21.4844f, -23.0469f, -63.2813f, -82.8125f, -23.8281f, 150.0000f, 44.9219f, 14.0625f,
    -1.5625f, 16.4063f, -29.2969f, 35.9375f, 104.6875f, -79.2969f, -48.8281f, 3.9063f, 20.3125f, 47.2656f, 28.1250f, -16.7969f, -42.5781f, -18.3594f, -25.7813f, -29.6875f,
    -15.2344f, 29.6875f, 104.6875f, -99.2188f, -10.9375f, 33.9844f, 0.7813f, 35.5469f, 33.2031f, 26.5625f, 34.7656f, 37.5000f, 16.4063f, 35.1563f, 15.2344f, 1.5625f,
    0.7813f, 0.7813f, -21.8750f, 2.7344f, 26.1719f, -12.1094f, -85.5469f, -75.0000f, -9.3750f, 57.0313f, 97.2656f, 105.0781f, 81.6406f, 77.7344f, 41.4063f, 12.1094f
};
/*   An 16-by-16 matrix */
const float SVNB_SN1[256] =
{
    52.7344f, 42.5781f, 52.7344f, -59.7656f, -214.4531f, 83.5938f, 162.5000f, 76.1719f, 113.6719f, 96.4844f, 39.0625f, -49.6094f, -226.1719f, -62.5000f, -25.7813f, -12.5000f,
    -41.7969f, -58.5938f, -107.0313f, -58.2031f, 250.7813f, 232.0313f, 132.0313f, 71.4844f, 31.6406f, -12.1094f, -5.4688f, -58.5938f, -151.1719f, -15.6250f, -17.1875f, -7.0313f,
    28.5156f, 16.4063f, 66.7969f, 132.4219f, 83.2031f, 16.4063f, -53.5156f, -108.2031f, -148.0469f, -172.2656f, -171.8750f, -186.7188f, 105.4688f, 49.2188f, -1.5625f, 2.3438f,
    -119.9219f, -187.1094f, -248.4375f, -232.8125f, -39.0625f, 32.4219f, 65.2344f, 78.1250f, 101.5625f, 146.8750f, 204.2969f, 410.5469f, 446.0938f, 191.4063f, 97.2656f, 42.1875f,
    -57.8125f, -83.9844f, -126.5625f, -222.6563f, -358.2031f, -267.5781f, -81.2500f, 49.6094f, 111.3281f, 137.8906f, 172.2656f, 367.1875f, 429.6875f, 178.9063f, 89.4531f, 39.0625f,
    166.7969f, 168.7500f, 214.0625f, 166.4063f, 51.9531f, 5.0781f, -3.5156f, -55.0781f, -42.1875f, -56.2500f, -76.1719f, -163.6719f, -286.3281f, -56.2500f, -42.5781f, -17.5781f,
    -44.9219f, -85.9375f, -75.7813f, 258.2031f, 350.0000f, 268.7500f, 191.0156f, 137.1094f, 82.4219f, 100.7813f, 57.4219f, 11.7188f, -291.4063f, -306.2500f, -60.9375f, -37.1094f,
    6.2500f, -18.7500f, -34.3750f, -167.9688f, -311.7188f, 14.0625f, 79.6875f, 26.5625f, 67.9688f, 63.2813f, 7.8125f, 23.8281f, 244.9219f, 103.9063f, 39.8438f, 18.7500f,
    -98.4375f, -144.5313f, -246.0938f, -239.8438f, 265.6250f, 400.0000f, 339.4531f, 233.5938f, 163.6719f, 101.1719f, 75.3906f, 10.5469f, 35.1563f, 60.9375f, 20.7031f, 10.5469f,
    -18.7500f, 12.8906f, 10.1563f, -88.6719f, -217.1875f, -299.2188f, -152.7344f, 90.2344f, 161.3281f, 110.1563f, 88.2813f, 34.7656f, 75.7813f, 73.0469f, 17.1875f, 11.7188f,
    -79.6875f, -113.6719f, -134.7656f, -51.1719f, 48.8281f, 28.1250f, 6.2500f, -11.3281f, -41.4063f, -19.1406f, -10.5469f, 71.4844f, 278.9063f, 108.2031f, 44.5313f, 19.1406f,
    -4.2969f, 80.0781f, 111.3281f, 26.9531f, -22.6563f, -80.8594f, -117.5781f, -62.5000f, -11.7188f, -0.7813f, 4.6875f, -38.6719f, -226.5625f, -69.5313f, -31.2500f, -16.0156f,
    46.8750f, 73.8281f, 109.7656f, 166.7969f, 91.4063f, 53.9063f, 48.4375f, 49.2188f, 19.5313f, 80.0781f, 47.2656f, 29.6875f, -311.3281f, -470.3125f, -91.7969f, -51.9531f,
    24.6094f, -7.0313f, 57.0313f, 260.1563f, 187.5000f, 92.1875f, 52.3438f, -15.2344f, -37.8906f, -50.7813f, -68.3594f, -147.6563f, -291.4063f, -62.1094f, -41.4063f, -17.9688f,
    150.7813f, 155.8594f, 162.1094f, 61.3281f, -68.3594f, -110.1563f, -123.0469f, -124.2188f, -86.7188f, -87.8906f, -104.2969f, -133.5938f, 123.8281f, 59.3750f, 5.8594f, 5.4688f,
    15.2344f, 21.8750f, 27.7344f, -37.1094f, -151.1719f, -198.8281f, -232.4219f, -182.0313f, -154.2969f, -72.6563f, -9.3750f, 164.4531f, 317.9688f, 114.0625f, 49.6094f, 20.3125f
};
/*   An 16-by-16 matrix */
const float SVNB_SN2[256] =
{
    -6.2500f, 43.3594f, 43.3594f, -34.7656f, -44.9219f, -157.8125f, -200.7813f, 63.2813f, 108.2031f, 16.0156f, -36.7188f, -34.7656f, 5.8594f, 12.1094f, 0.7813f, 0.7813f,
    -32.0313f, -38.6719f, -9.7656f, -112.1094f, -181.2500f, 79.6875f, 7.0313f, -48.0469f, -14.8438f, 21.8750f, 42.5781f, 77.3438f, 62.5000f, 37.5000f, 16.0156f, 7.4219f,
    -37.1094f, -24.2188f, -94.5313f, -162.1094f, 124.2188f, 46.0938f, -47.2656f, 17.1875f, 28.9063f, 15.6250f, 33.2031f, 44.5313f, 20.3125f, 14.0625f, 8.2031f, 3.1250f,
    11.3281f, 15.6250f, 16.7969f, 8.9844f, -78.9063f, -58.2031f, 112.5000f, 58.2031f, -7.8125f, -42.5781f, -72.6563f, -107.4219f, -49.6094f, 7.0313f, -9.7656f, -2.3438f,
    7.8125f, 14.0625f, -37.8906f, -89.0625f, 220.7031f, 198.4375f, 52.3438f, 16.4063f, -27.3438f, -92.5781f, -100.7813f, -101.1719f, -48.0469f, -3.5156f, -11.3281f, -3.9063f,
    -28.1250f, -66.0156f, 192.1875f, 180.8594f, 75.3906f, 79.6875f, -5.0781f, -29.2969f, -32.0313f, -48.8281f, -70.7031f, -89.8438f, -70.7031f, -3.9063f, -15.6250f, -4.6875f,
    -42.1875f, -86.3281f, -89.4531f, 253.1250f, 224.6094f, 112.5000f, 57.0313f, 0.3906f, -5.4688f, -1.5625f, -19.9219f, -46.8750f, -31.6406f, -5.4688f, -6.6406f, -1.9531f,
    -77.7344f, -103.1250f, -120.7031f, 81.6406f, 3.1250f, -50.0000f, 9.3750f, -18.3594f, 33.9844f, 100.3906f, 93.7500f, 72.2656f, 36.3281f, 27.3438f, 13.2813f, 6.2500f,
    9.7656f, 32.0313f, -23.4375f, -60.5469f, -158.9844f, -240.2344f, 11.3281f, 39.0625f, -44.1406f, 12.5000f, 80.8594f, 100.7813f, 79.2969f, 43.3594f, 19.1406f, 8.2031f,
    14.4531f, 49.6094f, 37.1094f, 1.5625f, 43.7500f, -17.5781f, -84.7656f, -61.7188f, -108.2031f, -158.9844f, -118.7500f, -59.3750f, 28.1250f, 20.3125f, -2.3438f, 0.0000f,
    -11.7188f, -31.6406f, -45.3125f, -162.5000f, -85.5469f, 264.4531f, 210.1563f, 128.1250f, 83.2031f, 23.4375f, -23.4375f, -42.5781f, -30.4688f, 0.0000f, -1.9531f, 0.0000f,
    3.5156f, -5.8594f, 10.1563f, 29.2969f, -68.3594f, -131.2500f, -262.8906f, -228.9063f, 92.9688f, 121.0938f, 77.3438f, 73.8281f, 82.8125f, 49.2188f, 18.7500f, 9.3750f,
    -7.0313f, -1.5625f, -31.2500f, 39.8438f, 50.7813f, -45.3125f, -104.6875f, -183.9844f, -221.4844f, -40.6250f, 80.0781f, 86.3281f, 55.8594f, 31.6406f, 11.3281f, 4.6875f,
    1.5625f, 15.2344f, 25.3906f, 44.9219f, 34.3750f, 73.8281f, 53.1250f, 48.4375f, 19.1406f, 41.4063f, 14.4531f, 34.7656f, -146.4844f, -244.5313f, -44.5313f, -28.5156f,
    210.9375f, 205.0781f, 184.3750f, 86.3281f, 46.0938f, -12.1094f, 5.8594f, 2.7344f, -27.7344f, -54.2969f, -42.1875f, -36.3281f, -5.0781f, -1.5625f, -5.0781f, -3.1250f,
    -17.1875f, -17.1875f, -55.8594f, -106.2500f, -205.0781f, -142.5781f, 187.1094f, 196.0938f, 121.8750f, 87.8906f, 62.8906f, 28.1250f, 10.9375f, 16.4063f, 10.1563f, 4.6875f
};
/*   An 16-by-16 matrix */
const float SVWB_SN1[256] =
{
    -27.7344f, -23.8281f, -66.4063f, -219.9219f, -375.7813f, -330.0781f, 72.6563f, 164.4531f, 110.1563f, 134.3750f, 101.5625f, 60.5469f, 72.6563f, 20.3125f, -7.0313f, -4.2969f,
    -41.7969f, -54.2969f, -112.8906f, -105.4688f, 307.8125f, 240.2344f, 97.2656f, 67.9688f, -0.3906f, -9.3750f, 62.1094f, 41.4063f, -17.9688f, -71.4844f, -73.0469f, -41.7969f,
    -56.2500f, -86.3281f, -83.9844f, 140.2344f, 75.0000f, -13.2813f, -72.6563f, -127.3438f, -100.0000f, -48.4375f, -19.1406f, 32.8125f, 83.5938f, 92.5781f, 72.6563f, 35.5469f,
    85.1563f, 129.6875f, 130.8594f, 16.0156f, -74.6094f, -153.9063f, -239.8438f, -212.1094f, -162.1094f, -148.0469f, -111.3281f, -59.7656f, -33.5938f, -39.4531f, -26.9531f, -5.0781f,
    229.2969f, 240.6250f, 285.9375f, 163.6719f, 105.4688f, 98.4375f, 39.8438f, 15.6250f, 20.7031f, -13.6719f, -22.2656f, -13.2813f, 7.4219f, -5.4688f, -5.8594f, -46.8750f,
    -29.6875f, -86.7188f, -49.6094f, 475.0000f, 464.0625f, 318.3594f, 207.8125f, 125.0000f, 121.4844f, 89.0625f, 13.2813f, -23.0469f, -37.5000f, -33.5938f, -17.1875f, -14.8438f,
    -68.7500f, -110.1563f, -198.0469f, -177.7344f, 438.2813f, 530.8594f, 376.9531f, 289.8438f, 238.2813f, 175.0000f, 185.1563f, 160.9375f, 72.2656f, 49.6094f, 49.6094f, -9.3750f,
    -60.9375f, -87.8906f, 6.2500f, 178.9063f, 165.2344f, 171.0938f, 153.5156f, 156.2500f, 205.0781f, 257.0313f, 266.4063f, 266.0156f, 239.0625f, 171.0938f, 104.2969f, 26.5625f,
    34.7656f, 46.8750f, 67.1875f, 138.6719f, 76.1719f, -3.1250f, -8.5938f, -26.1719f, -42.9688f, -15.6250f, -36.3281f, -63.6719f, -149.2188f, -267.5781f, -361.7188f, -182.8125f,
    -88.6719f, -141.4063f, -176.5625f, -225.3906f, -83.2031f, -8.5938f, 21.8750f, 32.0313f, 51.5625f, 84.3750f, 135.9375f, 164.0625f, 139.8438f, 116.7969f, 100.3906f, 55.8594f,
    14.8438f, -30.0781f, 45.7031f, 334.3750f, 189.8438f, 110.1563f, 6.2500f, -60.1563f, -50.7813f, -123.0469f, -241.4063f, -305.8594f, -348.4375f, -212.8906f, -34.3750f, 23.0469f,
    85.1563f, 126.5625f, 90.6250f, -63.2813f, -227.7344f, -215.6250f, 49.2188f, 24.2188f, -15.6250f, -10.5469f, -88.6719f, -135.9375f, -130.4688f, -126.5625f, -92.9688f, -25.3906f,
    32.0313f, 6.2500f, -7.8125f, -210.5469f, -307.4219f, 235.9375f, 132.8125f, 101.1719f, 101.5625f, -20.7031f, -98.0469f, -82.4219f, -4.6875f, 49.6094f, 66.7969f, 38.6719f,
    -9.3750f, 65.6250f, 78.9063f, -55.4688f, -87.1094f, -175.0000f, -110.1563f, 47.6563f, 57.8125f, 60.5469f, 141.7969f, 148.4375f, 135.5469f, 102.7344f, 48.4375f, -26.5625f,
    64.4531f, 58.5938f, 88.2813f, 37.1094f, -67.1875f, -100.3906f, -161.3281f, -199.2188f, -208.2031f, -286.7188f, -396.0938f, -471.0938f, -325.7813f, -63.2813f, 2.3438f, 37.8906f,
    -30.4688f, -28.1250f, -31.6406f, -125.7813f, -236.3281f, -285.5469f, -289.0625f, -220.3125f, -139.0625f, -85.5469f, -58.9844f, 4.2969f, 78.1250f, 92.5781f, 82.8125f, 66.4063f
};
/*   An 16-by-16 matrix */
const float SVWB_SN2[256] =
{
    -49.2188f, -59.3750f, -133.5938f, -165.2344f, 121.4844f, 37.1094f, 1.1719f, 11.3281f, -36.3281f, 1.5625f, 88.6719f, 75.3906f, 55.4688f, 46.8750f, 36.3281f, 24.2188f,
    74.2188f, 100.7813f, 149.2188f, 121.0938f, 64.8438f, -4.2969f, -30.0781f, -26.1719f, -84.7656f, -127.7344f, -128.9063f, -147.6563f, -180.0781f, -120.7031f, -55.4688f, -18.3594f,
    -6.2500f, -22.6563f, -30.0781f, -132.4219f, -208.5938f, 183.2031f, 155.8594f, 92.5781f, 113.2813f, 52.7344f, 13.2813f, 33.5938f, -5.4688f, -30.0781f, -11.7188f, 3.9063f,
    5.0781f, -1.5625f, 251.5625f, 223.4375f, 160.9375f, 171.0938f, 106.2500f, 111.7188f, 91.4063f, 69.1406f, 46.0938f, 57.4219f, 51.1719f, 53.9063f, 49.6094f, 14.8438f,
    -28.5156f, -34.3750f, -43.7500f, 16.4063f, 14.0625f, 55.0781f, 165.6250f, 150.7813f, 196.8750f, 225.0000f, 204.2969f, 188.6719f, 168.3594f, 128.1250f, 91.0156f, 23.0469f,
    -46.8750f, -66.0156f, -105.4688f, -173.8281f, -231.6406f, -104.6875f, -51.9531f, -53.9063f, -4.2969f, 21.8750f, 51.9531f, 82.0313f, 64.8438f, 45.3125f, 47.6563f, 53.5156f,
    110.1563f, 144.5313f, 99.6094f, 29.6875f, -34.7656f, -74.6094f, 54.2969f, 31.2500f, 4.6875f, 68.7500f, 72.2656f, 56.6406f, 95.3125f, 98.8281f, 67.5781f, -7.0313f,
    5.0781f, 5.4688f, -16.7969f, 28.5156f, -23.0469f, -105.4688f, -175.0000f, -242.9688f, -23.0469f, 146.0938f, 137.8906f, 114.4531f, 73.8281f, -21.0938f, -77.7344f, -47.6563f,
    -29.2969f, -41.4063f, -109.7656f, -121.8750f, 228.5156f, 158.2031f, 72.2656f, 24.2188f, -68.7500f, -124.6094f, -128.9063f, -156.2500f, -163.2813f, -63.2813f, -1.5625f, 30.4688f,
    -12.1094f, -4.2969f, -30.8594f, -32.4219f, -34.3750f, -107.0313f, -133.9844f, -168.3594f, -243.3594f, -202.3438f, -57.8125f, -4.2969f, -6.6406f, -8.2031f, 8.2031f, 35.1563f,
    -39.4531f, -67.5781f, -93.7500f, 173.4375f, 118.3594f, 47.2656f, 40.6250f, -14.4531f, 72.2656f, 52.3438f, -17.5781f, -53.1250f, -64.0625f, 1.5625f, 59.7656f, 44.5313f,
    -3.1250f, 15.6250f, 41.7969f, -29.6875f, -99.2188f, -215.2344f, -262.8906f, 112.5000f, 124.2188f, 9.7656f, 5.4688f, -24.2188f, -37.8906f, -0.7813f, 5.0781f, -7.8125f,
    33.9844f, 49.6094f, 31.2500f, 84.3750f, 131.2500f, 57.4219f, 73.4375f, 64.4531f, -3.9063f, 48.8281f, 75.3906f, 33.9844f, -49.2188f, -154.6875f, -287.5000f, -261.3281f,
    0.7813f, 1.5625f, 37.5000f, 72.2656f, 2.3438f, 24.2188f, -14.4531f, -53.1250f, -69.1406f, -97.6563f, -88.6719f, 78.5156f, 290.6250f, 254.2969f, 137.1094f, 28.9063f,
    -6.2500f, -15.2344f, -32.0313f, -69.1406f, -148.4375f, -71.4844f, -9.3750f, -42.5781f, -75.7813f, -158.9844f, -250.3906f, -240.2344f, -61.3281f, 57.0313f, 74.6094f, 65.2344f,
    -8.2031f, -4.6875f, -15.2344f, -24.6094f, -62.1094f, -50.0000f, 7.8125f, 2.3438f, 6.2500f, 15.2344f, -23.4375f, -94.9219f, -232.0313f, -286.3281f, -142.1875f, 17.9688f
};
/*   An 16-by-32 matrix */
const float GEWB_MA1[512] =
{
    105.0781f, 104.6875f, 162.5000f, 112.1094f, 61.3281f, 2.7344f, -51.5625f, -107.8125f, -188.2813f, -273.8281f, -400.3906f, -527.3438f, -641.4063f, -383.5938f, -125.3906f, -19.1406f,
    92.5781f, 370.7031f, 536.7188f, 479.6875f, 522.2656f, 476.1719f, 438.6719f, 396.8750f, 332.8125f, 293.7500f, 259.3750f, 218.3594f, 175.0000f, 119.5313f, 75.7813f, 32.4219f,
    -2.3438f, -68.7500f, -145.7031f, -43.3594f, -86.3281f, -151.1719f, -188.6719f, -249.6094f, -294.1406f, -307.0313f, -302.3438f, -255.8594f, -128.1250f, -44.5313f, -9.7656f, 10.5469f,
    52.7344f, 64.0625f, -1.5625f, -70.7031f, -142.1875f, -206.2500f, -181.2500f, -165.6250f, -153.5156f, -122.6563f, -94.5313f, -72.2656f, -40.6250f, -23.8281f, -12.5000f, -14.4531f,
    5.8594f, -85.1563f, -125.7813f, 260.9375f, 233.2031f, 133.9844f, 76.5625f, -1.9531f, -17.9688f, -62.1094f, -140.2344f, -204.6875f, -245.7031f, -214.0625f, -120.3125f, -37.1094f,
    94.5313f, 180.8594f, 299.6094f, 258.2031f, 217.9688f, 157.4219f, 104.6875f, 74.6094f, 27.7344f, -1.5625f, -19.9219f, -40.2344f, -55.0781f, -68.7500f, -62.8906f, -55.4688f,
    -69.9219f, -57.4219f, 279.2969f, 337.8906f, 378.9063f, 364.0625f, 321.0938f, 298.0469f, 235.1563f, 200.7813f, 170.3125f, 144.5313f, 111.3281f, 73.8281f, 41.4063f, 14.0625f,
    -19.1406f, -88.6719f, -230.0781f, -364.4531f, -457.8125f, -273.4375f, -96.8750f, -68.3594f, -51.5625f, -51.5625f, -48.8281f, -40.2344f, -18.3594f, -19.1406f, -4.6875f, 23.4375f,
    -2.7344f, -88.6719f, -157.8125f, 106.2500f, 32.4219f, -19.5313f, -64.4531f, -124.6094f, -133.9844f, -195.7031f, -285.5469f, -366.7969f, -395.7031f, -237.1094f, -78.9063f, -0.7813f,
    -29.6875f, -105.8594f, -258.2031f, -227.3438f, 115.6250f, 33.5938f, -23.4375f, -64.8438f, -130.8594f, -122.6563f, -83.2031f, -111.3281f, -126.5625f, -109.3750f, -64.0625f, -15.2344f,
    -103.1250f, -176.5625f, -43.3594f, 66.7969f, 89.4531f, 139.4531f, 138.6719f, 180.0781f, 198.8281f, 201.9531f, 191.0156f, 172.2656f, 135.5469f, 96.0938f, 61.7188f, 29.2969f,
    26.1719f, -19.1406f, -132.8125f, -213.2813f, -296.0938f, -358.9844f, -342.1875f, -283.9844f, -257.0313f, -221.4844f, -192.1875f, -156.2500f, -91.4063f, -54.6875f, -24.6094f, 14.0625f,
    -55.4688f, 36.7188f, 200.7813f, 156.2500f, 158.5938f, 151.9531f, 148.0469f, 161.3281f, 152.7344f, 147.2656f, 138.2813f, 122.6563f, 95.7031f, 60.9375f, 36.7188f, 13.2813f,
    37.8906f, -18.3594f, -123.4375f, -242.1875f, -341.4063f, -69.9219f, -80.4688f, -113.2813f, -118.7500f, -200.7813f, -269.5313f, -282.4219f, -196.4844f, -98.4375f, -28.5156f, 15.2344f,
    189.4531f, 263.2813f, 207.8125f, 76.1719f, 14.8438f, -23.4375f, 6.6406f, 20.3125f, 24.6094f, 28.9063f, 33.2031f, 24.2188f, 13.6719f, -3.9063f, -8.5938f, -19.9219f,
    -41.0156f, -8.9844f, 112.1094f, 153.9063f, 183.2031f, 237.8906f, 275.7813f, 335.9375f, 364.4531f, 364.4531f, 341.4063f, 308.2031f, 249.2188f, 181.6406f, 116.0156f, 57.8125f,
    -87.1094f, -194.9219f, -326.9531f, -317.5781f, -152.7344f, -90.2344f, -69.5313f, -71.0938f, -31.6406f, 0.7813f, 32.8125f, 44.1406f, 51.1719f, 55.4688f, 49.6094f, 41.7969f,
    -25.0000f, 105.0781f, 343.3594f, 331.6406f, 395.7031f, 451.9531f, 488.2813f, 522.2656f, 493.3594f, 459.3750f, 409.3750f, 351.5625f, 274.6094f, 196.0938f, 124.2188f, 64.4531f,
    23.8281f, 0.3906f, -77.3438f, -81.6406f, -134.7656f, -162.8906f, -109.3750f, -109.3750f, -119.9219f, -106.2500f, -133.2031f, -163.2813f, -235.9375f, -288.2813f, -346.4844f, -153.9063f,
    17.5781f, 30.0781f, 48.4375f, 59.3750f, 38.6719f, 16.7969f, 7.8125f, -1.5625f, -35.5469f, -33.2031f, -75.0000f, -109.3750f, -212.5000f, -294.5313f, -459.3750f, -506.2500f,
    67.5781f, 26.9531f, -19.1406f, -88.2813f, -134.3750f, -187.1094f, -191.0156f, -241.4063f, -283.9844f, -355.0781f, -438.2813f, -564.8438f, -504.6875f, -192.1875f, -80.0781f, 3.9063f,
    -31.2500f, -31.2500f, 132.0313f, 111.3281f, 48.0469f, 18.7500f, -29.6875f, -31.2500f, -41.0156f, -46.0938f, -42.1875f, -31.2500f, -22.6563f, -10.9375f, -3.5156f, -3.1250f,
    28.9063f, -30.8594f, -114.0625f, -241.4063f, -295.3125f, 134.7656f, 84.3750f, 70.3125f, 55.8594f, -28.5156f, -72.6563f, -87.1094f, -78.1250f, -55.8594f, -20.3125f, -8.2031f,
    -98.8281f, -202.7344f, -225.7813f, -73.4375f, -37.5000f, -13.6719f, -2.7344f, 10.5469f, 51.9531f, 85.1563f, 100.7813f, 100.7813f, 90.2344f, 70.3125f, 46.8750f, 27.3438f,
    106.6406f, 289.0625f, 371.0938f, 287.5000f, 273.8281f, 248.0469f, 238.6719f, 235.1563f, 221.0938f, 208.2031f, 192.9688f, 174.6094f, 136.7188f, 89.8438f, 51.1719f, 16.4063f,
    -39.0625f, -134.7656f, -274.2188f, -137.5000f, 276.9531f, 266.4063f, 189.4531f, 126.5625f, 62.8906f, 43.7500f, 57.8125f, 9.7656f, -34.3750f, -41.4063f, -33.5938f, -39.4531f,
    119.9219f, 103.5156f, 98.8281f, 25.3906f, -24.6094f, -29.2969f, -66.0156f, -110.1563f, -152.3438f, -195.7031f, -214.8438f, -207.8125f, -158.5938f, -115.6250f, -72.6563f, -51.5625f,
    -10.1563f, 27.3438f, 19.5313f, -32.8125f, -34.7656f, 10.9375f, 41.4063f, 77.7344f, 119.1406f, 152.7344f, 175.7813f, 183.2031f, 163.6719f, 117.5781f, 74.6094f, 31.2500f,
    8.5938f, 15.2344f, -60.1563f, -166.4063f, -233.2031f, -194.1406f, -62.1094f, -26.9531f, 16.0156f, 37.1094f, 44.5313f, 44.5313f, 38.6719f, 12.8906f, -2.7344f, -15.6250f,
    -63.2813f, -139.0625f, -199.6094f, -180.0781f, -185.5469f, -200.3906f, -186.3281f, -189.4531f, -154.2969f, -97.2656f, -53.1250f, -27.7344f, -1.5625f, 12.8906f, 21.0938f, 25.0000f,
    -32.0313f, -115.2344f, -219.5313f, 94.1406f, 25.3906f, -63.6719f, -88.6719f, -150.0000f, -92.5781f, -89.4531f, -103.9063f, -87.1094f, -36.7188f, 3.9063f, 16.0156f, 12.1094f,
    -40.6250f, -126.1719f, -117.9688f, 286.3281f, 252.3438f, 163.2813f, 105.8594f, 58.2031f, 60.5469f, 60.1563f, 46.4844f, 38.6719f, 34.7656f, 24.6094f, 5.0781f, -6.2500f
};
/*   An 16-by-32 matrix */
const float GETRNB_SN1[512] =
{
    -46.4844f, -105.8594f, -166.7969f, 174.6094f, 125.3906f, 22.6563f, 14.4531f, -41.0156f, -25.3906f, 38.6719f, 41.4063f, 8.2031f, -108.2031f, 20.7031f, 3.5156f, -2.3438f,
    -36.3281f, -94.1406f, -169.1406f, -322.6563f, -401.5625f, 6.6406f, 70.3125f, 53.9063f, 125.0000f, 91.4063f, 59.3750f, 91.7969f, 380.0781f, 232.0313f, 77.7344f, 37.5000f,
    -117.1875f, -185.1563f, -216.0156f, -194.1406f, -146.0938f, -90.2344f, -87.5000f, -66.4063f, -56.6406f, 19.9219f, 60.1563f, 278.9063f, 522.6563f, 269.5313f, 105.8594f, 46.0938f,
    -44.9219f, -89.0625f, -96.8750f, 3.5156f, -10.5469f, -76.5625f, -93.7500f, -105.0781f, -114.4531f, -121.0938f, -107.8125f, -99.2188f, 300.3906f, 187.8906f, 45.7031f, 23.0469f,
    67.1875f, 22.6563f, 183.2031f, 228.5156f, 200.0000f, 131.2500f, 56.6406f, -20.3125f, -65.2344f, -134.3750f, -148.0469f, -190.2344f, 111.3281f, 147.2656f, 10.5469f, 10.5469f,
    31.6406f, 13.2813f, 224.2188f, 335.5469f, 319.5313f, 274.2188f, 203.5156f, 134.3750f, 69.1406f, 8.9844f, -45.3125f, -107.0313f, -238.6719f, -30.4688f, -23.8281f, -13.6719f,
    29.6875f, 7.4219f, -40.6250f, -151.5625f, -268.3594f, 21.0938f, 108.9844f, 56.2500f, 92.5781f, 87.1094f, 42.9688f, 3.5156f, -130.8594f, 1.5625f, 1.1719f, -3.9063f,
    44.9219f, 148.4375f, 189.8438f, 174.2188f, 151.9531f, 123.4375f, 93.3594f, 97.2656f, 76.9531f, 80.8594f, 63.2813f, 55.0781f, -169.9219f, -592.1875f, -159.7656f, -53.1250f,
    -57.0313f, -135.9375f, -166.0156f, 251.9531f, 389.8438f, 308.5938f, 237.8906f, 182.8125f, 110.1563f, 112.1094f, 59.7656f, 33.9844f, -180.0781f, -231.2500f, -34.3750f, -25.0000f,
    -97.2656f, -183.9844f, -326.1719f, -250.7813f, 230.0781f, 375.0000f, 346.4844f, 248.8281f, 172.6563f, 111.7188f, 94.5313f, 51.5625f, 55.4688f, 116.7969f, 38.6719f, 17.1875f,
    50.0000f, 14.4531f, -46.8750f, -122.6563f, -223.0469f, -285.1563f, -339.0625f, -217.9688f, -101.1719f, -42.5781f, 3.1250f, 161.3281f, 447.2656f, 231.6406f, 82.0313f, 35.9375f,
    58.9844f, 129.2969f, 104.2969f, 50.7813f, -9.3750f, -34.7656f, -51.9531f, -16.7969f, -29.2969f, 22.2656f, 7.4219f, 36.7188f, -183.2031f, -310.9375f, -48.4375f, -35.1563f,
    -132.4219f, -182.8125f, -114.0625f, -13.2813f, 29.6875f, 69.9219f, 90.2344f, 105.0781f, 101.1719f, 109.7656f, 107.4219f, 79.6875f, -36.3281f, 61.3281f, 20.7031f, 6.2500f,
    12.8906f, 68.7500f, 9.7656f, -78.5156f, -121.4844f, -194.1406f, -198.8281f, -94.5313f, -18.3594f, 2.3438f, 33.5938f, 18.7500f, -64.4531f, 68.7500f, 9.3750f, 3.1250f,
    10.5469f, 87.1094f, 180.0781f, 195.3125f, 187.1094f, 185.5469f, 191.0156f, 218.7500f, 248.0469f, 289.4531f, 360.9375f, 526.1719f, 603.9063f, 314.8438f, 108.2031f, 21.0938f,
    199.2188f, 181.2500f, 157.0313f, 44.5313f, -31.2500f, -111.3281f, -113.2813f, -125.3906f, -110.5469f, -143.7500f, -126.9531f, -165.6250f, 151.5625f, 157.0313f, 20.3125f, 14.8438f,
    203.5156f, 239.8438f, 285.9375f, 214.4531f, 167.1875f, 108.5938f, 70.3125f, 31.6406f, 5.4688f, -42.9688f, -79.6875f, -138.6719f, -253.5156f, -12.5000f, -21.8750f, -14.0625f,
    28.1250f, 10.1563f, 102.3438f, 102.7344f, 62.1094f, 44.1406f, 23.4375f, -3.9063f, -28.5156f, -47.2656f, -78.5156f, -128.5156f, -300.0000f, -23.8281f, -23.4375f, -15.2344f,
    33.2031f, 22.2656f, 45.3125f, -15.6250f, -30.4688f, -62.1094f, -60.1563f, -96.4844f, -85.9375f, -142.9688f, -129.2969f, -207.8125f, -13.6719f, 134.3750f, 0.0000f, 9.7656f,
    205.8594f, 358.9844f, 523.0469f, 478.5156f, 464.8438f, 399.6094f, 302.3438f, 225.3906f, 153.5156f, 62.5000f, -1.5625f, -71.8750f, -109.7656f, 11.3281f, -8.2031f, -4.6875f,
    -89.8438f, -110.5469f, -132.0313f, -148.0469f, -122.2656f, -114.4531f, -63.6719f, -47.6563f, 5.8594f, 37.8906f, 94.9219f, 65.6250f, 141.0156f, 175.3906f, 39.8438f, 23.8281f,
    147.6563f, 144.1406f, 144.1406f, 53.1250f, 16.4063f, -28.1250f, -28.5156f, -60.1563f, -60.5469f, -101.5625f, -105.4688f, -173.4375f, -219.5313f, 67.5781f, -14.0625f, -3.5156f,
    65.6250f, 42.1875f, -14.0625f, -135.5469f, -218.3594f, -170.3125f, -99.2188f, -102.7344f, -92.1875f, -88.6719f, -96.4844f, -92.9688f, 310.9375f, 190.6250f, 48.0469f, 24.2188f,
    -58.9844f, -46.0938f, 63.6719f, 176.5625f, 167.9688f, 189.0625f, 178.1250f, 163.2813f, 147.2656f, 141.7969f, 100.0000f, 71.4844f, -157.4219f, -558.2031f, -149.2188f, -49.2188f,
    -79.6875f, -142.9688f, -254.6875f, -200.0000f, 167.1875f, 137.8906f, 71.0938f, 34.3750f, -3.9063f, -36.7188f, -21.0938f, -4.2969f, 312.8906f, 205.8594f, 58.9844f, 29.6875f,
    23.4375f, 30.8594f, -66.0156f, -181.6406f, -308.2031f, -329.6875f, -21.4844f, 70.7031f, 81.6406f, 67.1875f, 82.0313f, 41.7969f, 101.5625f, 155.8594f, 35.5469f, 20.3125f,
    -26.9531f, -80.0781f, -147.2656f, -64.0625f, 252.7344f, 228.1250f, 117.9688f, 58.9844f, 12.5000f, -52.7344f, -53.1250f, -87.1094f, -105.0781f, 66.4063f, 1.5625f, 1.9531f,
    14.8438f, 163.2813f, 345.7031f, 382.4219f, 386.7188f, 401.1719f, 339.8438f, 314.0625f, 261.3281f, 209.7656f, 140.6250f, 94.1406f, -131.2500f, -500.3906f, -132.0313f, -43.3594f,
    -164.0625f, -273.4375f, -356.2500f, -242.9688f, -131.6406f, -19.9219f, 26.1719f, 67.5781f, 127.3438f, 216.4063f, 299.2188f, 544.9219f, 646.8750f, 349.2188f, 152.3438f, 69.5313f,
    -55.0781f, -98.4375f, -198.0469f, -321.0938f, -423.4375f, -330.0781f, -109.3750f, 7.8125f, 58.2031f, 94.5313f, 153.5156f, 371.4844f, 557.8125f, 289.0625f, 118.3594f, 52.7344f,
    -46.8750f, -14.4531f, 12.1094f, 41.0156f, 28.1250f, 38.6719f, 20.7031f, 45.7031f, 23.0469f, 66.7969f, 46.8750f, 69.1406f, -161.7188f, -387.8906f, -62.5000f, -38.2813f,
    -149.2188f, -239.0625f, -246.4844f, -65.2344f, 1.5625f, 40.6250f, 50.7813f, 55.0781f, 94.5313f, 126.9531f, 135.9375f, 167.9688f, 409.3750f, 254.2969f, 86.7188f, 42.5781f
};
/*   An 16-by-16 matrix */
const float GETRNB_SN2[256] =
{
    -10.5469f, 27.7344f, 17.5781f, -1.5625f, 10.9375f, 26.9531f, 9.7656f, 36.7188f, 17.5781f, 35.1563f, 17.5781f, 33.9844f, -69.1406f, -221.4844f, -45.3125f, -23.0469f,
    -81.2500f, -57.4219f, 207.4219f, 155.8594f, 77.7344f, 44.1406f, -8.2031f, -10.9375f, -13.2813f, -14.8438f, -18.7500f, -17.9688f, -18.3594f, 7.0313f, -0.3906f, -0.3906f,
    26.9531f, -7.8125f, -44.9219f, -138.6719f, -148.4375f, 151.5625f, 148.0469f, 75.3906f, 52.3438f, 14.4531f, -16.4063f, -23.4375f, -13.6719f, 11.3281f, 2.3438f, 1.9531f,
    41.7969f, 34.7656f, -38.2813f, -73.8281f, 148.0469f, 112.8906f, 26.5625f, 8.5938f, -27.7344f, -69.9219f, -73.0469f, -75.0000f, -53.5156f, 1.5625f, -6.6406f, -2.7344f,
    -17.1875f, -31.6406f, -144.9219f, -175.0000f, 88.2813f, 29.2969f, -20.3125f, 16.7969f, 15.6250f, 14.0625f, 30.8594f, 46.8750f, 50.7813f, 29.6875f, 14.0625f, 5.8594f,
    51.1719f, 44.9219f, 75.0000f, 69.1406f, 9.7656f, -2.7344f, -8.9844f, -37.1094f, -51.5625f, -71.8750f, -80.4688f, -95.7031f, -78.1250f, -4.6875f, -11.3281f, -4.2969f,
    17.5781f, -9.7656f, -97.2656f, 19.5313f, -73.8281f, -139.8438f, 98.8281f, 56.6406f, -15.2344f, 10.5469f, 13.2813f, -7.8125f, -20.3125f, 5.0781f, 0.3906f, 0.7813f,
    -99.2188f, -60.5469f, 8.9844f, -34.7656f, -11.7188f, 8.9844f, -8.9844f, -8.2031f, -17.5781f, -33.5938f, -35.9375f, -42.5781f, -18.7500f, 20.3125f, 1.1719f, 1.1719f,
    -96.8750f, -91.0156f, 54.2969f, 83.2031f, 90.6250f, 141.0156f, 136.3281f, 156.6406f, 145.7031f, 117.5781f, 89.8438f, 80.8594f, 79.6875f, 39.4531f, 12.5000f, 5.4688f,
    191.7969f, 213.2813f, 159.7656f, 57.4219f, 13.2813f, -7.0313f, 20.3125f, 23.0469f, 18.7500f, 10.5469f, 5.4688f, 2.7344f, -0.3906f, -14.4531f, -6.2500f, -3.5156f,
    14.0625f, 16.0156f, 0.0000f, -8.2031f, -11.3281f, -25.0000f, -80.8594f, -135.1563f, -201.5625f, -138.6719f, -25.0000f, 28.5156f, 60.9375f, 36.7188f, 11.7188f, 4.2969f,
    -10.9375f, -67.5781f, -108.5938f, 197.6563f, 166.7969f, 64.0625f, 43.3594f, 8.2031f, -12.8906f, -23.8281f, -30.4688f, -35.1563f, -12.5000f, 15.2344f, 1.5625f, 1.5625f,
    -17.1875f, -23.4375f, -83.9844f, -145.7031f, -189.4531f, -105.4688f, 4.6875f, 58.9844f, 105.8594f, 103.5156f, 83.9844f, 69.5313f, 59.7656f, 27.7344f, 12.5000f, 6.6406f,
    42.9688f, 60.5469f, -11.3281f, -101.1719f, -85.1563f, -71.4844f, -68.3594f, -51.5625f, -33.2031f, -38.2813f, -33.9844f, -36.3281f, -30.0781f, 0.0000f, -3.5156f, -1.5625f,
    -45.3125f, -5.4688f, 91.7969f, 0.3906f, -92.9688f, -155.4688f, -163.6719f, -21.4844f, 42.5781f, 30.0781f, 24.2188f, 28.9063f, 28.5156f, 18.3594f, 6.2500f, 3.1250f,
    -7.8125f, -42.1875f, -85.5469f, 96.0938f, 7.8125f, -71.8750f, -128.1250f, -175.3906f, -26.1719f, 55.4688f, 48.8281f, 42.9688f, 35.5469f, 28.9063f, 10.9375f, 5.0781f
};
/*   An 16-by-32 matrix */
const float GETRWB_SN1[512] =
{
    -90.6250f, -74.6094f, 110.1563f, 96.8750f, 134.3750f, 152.3438f, 167.1875f, 191.4063f, 210.1563f, 231.2500f, 242.1875f, 237.1094f, 208.2031f, 145.3125f, 101.9531f, 53.1250f,
    -23.0469f, -88.6719f, -163.2813f, -112.5000f, -96.4844f, -175.0000f, -195.7031f, -251.5625f, -296.8750f, -360.1563f, -434.3750f, -470.3125f, -204.2969f, -50.7813f, 4.6875f, 51.1719f,
    54.2969f, 327.3438f, 547.6563f, 518.3594f, 572.2656f, 543.3594f, 535.5469f, 524.2188f, 476.5625f, 448.0469f, 406.6406f, 355.4688f, 286.3281f, 202.3438f, 130.8594f, 70.7031f,
    82.4219f, 57.8125f, -36.7188f, -107.4219f, -189.0625f, -228.9063f, -211.3281f, -247.6563f, -227.7344f, -199.6094f, -165.6250f, -125.7813f, -111.3281f, -116.7969f, -75.7813f, -33.9844f,
    160.1563f, 141.4063f, 131.6406f, 28.5156f, -14.0625f, -44.1406f, -70.3125f, -107.0313f, -145.7031f, -192.5781f, -195.7031f, -184.7656f, -153.5156f, -141.0156f, -105.8594f, -98.0469f,
    -33.2031f, -142.9688f, -319.9219f, -207.8125f, 294.1406f, 268.7500f, 161.7188f, 79.2969f, 9.3750f, -16.7969f, 50.3906f, 23.4375f, -39.0625f, -48.0469f, -37.8906f, -44.5313f,
    1.5625f, 14.4531f, 189.0625f, 200.7813f, 132.8125f, 87.8906f, 34.7656f, 23.0469f, 15.6250f, 1.1719f, -1.9531f, -0.3906f, -4.2969f, -19.1406f, -16.7969f, -18.7500f,
    -87.1094f, -183.9844f, -258.2031f, -221.4844f, -193.7500f, -202.7344f, -181.2500f, -211.7188f, -189.0625f, -133.9844f, -107.8125f, -72.2656f, -16.7969f, 6.6406f, 32.8125f, 51.9531f,
    -41.4063f, -121.8750f, -260.9375f, -289.4531f, 150.3906f, 128.5156f, 47.2656f, -61.3281f, -165.2344f, -277.3438f, -373.8281f, -500.0000f, -446.4844f, -128.9063f, -7.8125f, 51.1719f,
    97.6563f, 61.3281f, 27.7344f, -121.0938f, -215.6250f, -289.0625f, -291.0156f, -303.9063f, -323.0469f, -415.6250f, -521.8750f, -636.3281f, -307.8125f, -76.1719f, -17.1875f, 51.1719f,
    54.6875f, 247.2656f, 378.9063f, 337.5000f, 338.6719f, 297.2656f, 266.7969f, 253.1250f, 223.4375f, 212.5000f, 201.5625f, 183.2031f, 149.6094f, 92.9688f, 55.8594f, 21.4844f,
    45.3125f, 55.8594f, 89.4531f, 52.3438f, -9.7656f, -46.8750f, -90.6250f, -130.0781f, -208.9844f, -250.7813f, -384.7656f, -491.7969f, -731.6406f, -674.6094f, -128.9063f, -3.9063f,
    -25.0000f, -32.0313f, -24.2188f, -90.6250f, -120.3125f, -135.1563f, -115.6250f, -106.2500f, -59.7656f, -10.1563f, 42.1875f, 80.0781f, 90.6250f, 61.7188f, 50.3906f, 20.7031f,
    32.0313f, -35.9375f, -120.7031f, -308.9844f, -440.6250f, -101.1719f, -94.9219f, -158.2031f, -143.3594f, -248.8281f, -352.7344f, -423.4375f, -263.6719f, -77.7344f, 6.6406f, 57.0313f,
    -96.4844f, -222.2656f, -346.0938f, -296.0938f, -130.4688f, -80.4688f, -61.7188f, -58.5938f, -25.0000f, 22.2656f, 74.2188f, 98.4375f, 101.9531f, 82.0313f, 63.6719f, 50.3906f,
    -8.9844f, -124.6094f, -178.9063f, 308.9844f, 280.4688f, 156.2500f, 91.0156f, -31.6406f, -67.9688f, -156.2500f, -296.0938f, -409.3750f, -522.6563f, -405.4688f, -112.5000f, -2.3438f,
    19.5313f, 180.4688f, 118.3594f, -18.3594f, -47.6563f, -52.3438f, 5.8594f, 53.5156f, 69.9219f, 86.7188f, 103.9063f, 97.2656f, 85.5469f, 48.0469f, 31.2500f, 11.7188f,
    -45.3125f, -129.6875f, -253.9063f, -431.2500f, -533.9844f, -269.9219f, -146.8750f, -115.2344f, -69.5313f, -77.7344f, -66.4063f, -9.3750f, 48.8281f, 37.1094f, 48.8281f, 65.6250f,
    -25.7813f, -122.6563f, -205.4688f, 126.9531f, 60.9375f, -21.8750f, -44.5313f, -112.1094f, -49.2188f, -72.2656f, -114.0625f, -116.4063f, -73.8281f, -31.6406f, 0.3906f, 8.9844f,
    57.4219f, -11.7188f, -113.6719f, -301.1719f, -366.7969f, 102.3438f, 71.0938f, 49.2188f, 49.6094f, -39.0625f, -63.6719f, -52.3438f, -35.5469f, -37.1094f, -20.3125f, -7.4219f,
    -87.8906f, -193.7500f, -175.3906f, -23.8281f, 17.9688f, 52.7344f, 71.0938f, 96.4844f, 126.5625f, 157.8125f, 178.5156f, 181.2500f, 164.0625f, 119.1406f, 81.6406f, 41.4063f,
    163.2813f, 121.8750f, 162.1094f, 28.9063f, -60.9375f, -134.7656f, -156.2500f, -247.6563f, -300.3906f, -412.8906f, -532.0313f, -719.1406f, -721.8750f, -183.9844f, -57.4219f, 33.9844f,
    14.8438f, 7.4219f, -90.6250f, -215.6250f, -272.6563f, -367.5781f, -188.6719f, 46.4844f, 21.0938f, -13.2813f, 27.3438f, -26.5625f, -56.2500f, -75.0000f, -98.8281f, -92.1875f,
    31.2500f, -11.7188f, -83.5938f, -61.3281f, -114.0625f, -121.8750f, -110.5469f, -135.5469f, -150.0000f, -145.3125f, -190.2344f, -196.4844f, -291.4063f, -371.0938f, -535.9375f, -251.5625f,
    17.1875f, 21.4844f, 48.4375f, 70.7031f, 48.8281f, 42.5781f, 23.8281f, 11.3281f, -28.5156f, -21.0938f, -80.4688f, -108.5938f, -249.2188f, -362.8906f, -610.5469f, -680.4688f,
    313.2813f, 321.4844f, 283.5938f, 137.8906f, 106.2500f, 47.6563f, 45.7031f, 36.7188f, 31.2500f, 15.6250f, 26.5625f, 18.3594f, 16.4063f, -7.4219f, -10.1563f, -26.9531f,
    19.5313f, -37.8906f, -119.5313f, -260.1563f, -358.5938f, -433.2031f, -439.0625f, -303.1250f, -277.3438f, -284.3750f, -263.6719f, -189.8438f, -58.5938f, -1.1719f, 36.3281f, 62.5000f,
    31.6406f, -56.2500f, -51.1719f, 124.6094f, 88.6719f, -37.5000f, -92.1875f, -201.9531f, -277.7344f, -370.7031f, -480.8594f, -642.1875f, -634.7656f, -173.4375f, -45.7031f, 33.5938f,
    -89.8438f, -92.5781f, 228.9063f, 312.1094f, 363.6719f, 399.6094f, 420.7031f, 460.5469f, 442.5781f, 430.0781f, 401.1719f, 355.0781f, 285.5469f, 201.1719f, 128.9063f, 66.7969f,
    175.0000f, 246.8750f, 408.9844f, 305.4688f, 246.4844f, 152.3438f, 60.5469f, -32.0313f, -133.5938f, -267.5781f, -430.8594f, -593.7500f, -694.9219f, -363.6719f, -83.5938f, 13.2813f,
    -30.0781f, -137.5000f, -137.8906f, 307.4219f, 366.4063f, 264.4531f, 200.3906f, 137.5000f, 110.9375f, 108.5938f, 96.4844f, 70.7031f, 55.0781f, 28.5156f, 3.1250f, -15.2344f,
    21.0938f, 16.4063f, -26.1719f, -116.4063f, -181.6406f, -231.6406f, -208.2031f, -213.6719f, -244.5313f, -289.4531f, -381.6406f, -514.4531f, -650.3906f, -239.4531f, -46.4844f, 31.2500f
};
/*   An 16-by-16 matrix */
const float GETRWB_SN2[256] =
{
    -78.9063f, -96.0938f, -139.0625f, -139.0625f, -90.6250f, -64.0625f, -30.8594f, 1.5625f, 30.4688f, 50.7813f, 59.3750f, 64.4531f, 66.4063f, 55.0781f, 35.1563f, 27.3438f,
    14.8438f, 30.4688f, -28.1250f, -72.2656f, -174.2188f, -215.6250f, 105.0781f, 115.2344f, 40.6250f, 30.0781f, -21.0938f, -71.8750f, -65.6250f, -28.1250f, -12.5000f, -0.7813f,
    26.9531f, 36.3281f, 15.2344f, 45.3125f, 39.0625f, 17.9688f, 19.5313f, -0.3906f, -0.7813f, 24.2188f, 3.1250f, -41.0156f, -157.8125f, -256.2500f, -192.9688f, -87.5000f,
    -111.3281f, -119.1406f, 102.7344f, 37.8906f, 11.3281f, 12.8906f, -9.3750f, 21.0938f, 13.6719f, 9.7656f, -1.5625f, -2.3438f, -11.7188f, 5.0781f, 7.8125f, 8.2031f,
    -10.9375f, -27.3438f, -62.5000f, 13.2813f, 1.9531f, -56.6406f, -103.1250f, -166.0156f, -210.5469f, -128.5156f, -7.4219f, 89.0625f, 160.5469f, 109.3750f, 55.0781f, 19.9219f,
    95.3125f, 95.7031f, 7.4219f, -124.6094f, -180.0781f, -71.8750f, -3.9063f, 18.3594f, 85.9375f, 114.4531f, 120.7031f, 128.9063f, 109.7656f, 54.6875f, 27.7344f, 4.6875f,
    -50.0000f, -98.0469f, -146.0938f, 165.6250f, 108.9844f, 26.5625f, 13.6719f, -26.5625f, 5.0781f, 17.5781f, -2.3438f, -16.0156f, -28.5156f, -6.6406f, 3.1250f, 10.5469f,
    -21.4844f, -2.7344f, 171.0938f, 195.3125f, 192.5781f, 172.6563f, 111.7188f, 82.4219f, 26.5625f, -15.2344f, -45.7031f, -65.2344f, -70.3125f, -51.1719f, -29.2969f, -24.6094f,
    11.7188f, 12.1094f, 26.9531f, 44.5313f, -67.1875f, -158.9844f, -232.8125f, -152.7344f, 39.8438f, 66.0156f, 61.7188f, 51.1719f, 17.9688f, 1.5625f, -2.3438f, -1.1719f,
    26.9531f, 29.6875f, 12.8906f, 92.9688f, 64.0625f, 46.4844f, 62.5000f, 64.4531f, 106.6406f, 133.5938f, 149.6094f, 163.6719f, 178.1250f, 147.6563f, 102.3438f, 37.5000f,
    -21.4844f, 16.7969f, -23.0469f, -106.6406f, -78.1250f, -111.7188f, -112.1094f, -86.3281f, -96.4844f, -95.7031f, -75.7813f, -62.5000f, -50.3906f, -14.0625f, -12.1094f, 1.1719f,
    -13.6719f, -17.9688f, -106.2500f, -139.4531f, 189.0625f, 96.0938f, -4.2969f, 8.2031f, -48.0469f, -76.9531f, -39.8438f, -36.7188f, -37.5000f, -8.5938f, 2.3438f, 2.3438f,
    -45.7031f, -73.4375f, -98.4375f, -88.6719f, 0.0000f, 179.6875f, 197.6563f, 205.4688f, 195.7031f, 151.9531f, 97.6563f, 51.1719f, -10.9375f, -12.5000f, 9.3750f, 6.6406f,
    155.8594f, 199.6094f, 152.3438f, 57.0313f, 31.2500f, -32.8125f, -31.6406f, -22.2656f, -48.0469f, -53.9063f, -37.1094f, -32.0313f, -19.9219f, -12.8906f, -5.4688f, -17.5781f,
    -3.5156f, 4.6875f, 117.1875f, 118.7500f, 71.0938f, 10.5469f, -76.9531f, -100.7813f, -134.3750f, -153.5156f, -150.0000f, -124.2188f, -54.6875f, -1.9531f, -2.3438f, 2.3438f,
    25.0000f, 9.7656f, -2.7344f, -100.0000f, -119.5313f, 148.8281f, 94.9219f, 37.5000f, -6.6406f, -74.2188f, -111.3281f, -96.0938f, -25.3906f, 18.7500f, 14.4531f, 11.3281f
};
/*   An 16-by-16 matrix */
const float TRWB2_SN1[256] =
{
    -28.9063f, -150.0000f, -298.4375f, -376.5625f, -438.2813f, -356.2500f, -319.9219f, -289.0625f, -284.3750f, -223.4375f, -148.0469f, -123.8281f, -97.6563f, -19.9219f, -26.1719f, 33.2031f,
    -121.4844f, -241.4063f, -171.4844f, -42.1875f, 60.9375f, 100.3906f, 157.8125f, 212.1094f, 251.1719f, 284.7656f, 285.9375f, 223.4375f, 174.2188f, 128.5156f, 92.1875f, 64.0625f,
    204.2969f, 605.0781f, 608.2031f, 576.5625f, 536.7188f, 465.6250f, 417.1875f, 360.5469f, 351.9531f, 307.8125f, 280.0781f, 156.6406f, 102.3438f, 2.3438f, -39.0625f, -143.7500f,
    -5.0781f, -31.2500f, -73.8281f, -150.7813f, -189.8438f, -139.4531f, -84.3750f, -24.6094f, 25.3906f, 73.8281f, 96.8750f, 75.7813f, 85.1563f, 85.5469f, 80.0781f, 66.0156f,
    -40.6250f, -202.7344f, -301.5625f, 192.1875f, 87.5000f, 7.0313f, -79.2969f, -95.3125f, -49.2188f, -85.9375f, -141.4063f, -162.8906f, -105.8594f, -27.7344f, -13.2813f, -19.5313f,
    -78.9063f, 48.4375f, 316.7969f, 380.8594f, 517.9688f, 573.4375f, 630.0781f, 596.4844f, 575.7813f, 533.5938f, 476.5625f, 353.9063f, 273.4375f, 198.8281f, 137.1094f, 80.8594f,
    -22.2656f, -76.5625f, -92.9688f, -109.7656f, -104.2969f, -93.3594f, -74.2188f, -53.5156f, -10.5469f, 1.5625f, 30.0781f, -69.5313f, -100.0000f, -216.0156f, -261.3281f, -431.6406f,
    -71.4844f, -82.4219f, 314.0625f, 308.2031f, 267.5781f, 206.6406f, 187.1094f, 157.4219f, 144.9219f, 122.2656f, 108.9844f, 19.1406f, -7.4219f, -60.9375f, -69.9219f, -130.8594f,
    296.0938f, 331.2500f, 237.5000f, 122.2656f, 105.8594f, 68.7500f, 69.1406f, 28.5156f, 41.4063f, 23.8281f, 23.0469f, -62.1094f, -79.2969f, -112.1094f, -104.6875f, -133.9844f,
    77.7344f, 27.3438f, 37.1094f, -11.3281f, -95.7031f, -160.5469f, -291.0156f, -394.1406f, -575.3906f, -750.3906f, -1028.5156f, -643.7500f, -209.7656f, -110.9375f, -33.9844f, 80.8594f,
    32.0313f, -84.7656f, -179.6875f, -252.3438f, -280.4688f, -320.7031f, -383.9844f, -500.7813f, -617.1875f, -823.4375f, -727.7344f, -237.8906f, -158.9844f, -47.6563f, -19.5313f, 94.9219f,
    -51.5625f, 142.1875f, 142.1875f, 132.8125f, 191.0156f, 193.7500f, 232.8125f, 236.7188f, 275.0000f, 295.3125f, 303.5156f, 240.6250f, 203.5156f, 159.7656f, 119.1406f, 82.4219f,
    48.0469f, -73.8281f, -35.5469f, -119.5313f, -124.6094f, -158.9844f, -234.3750f, -265.2344f, -355.8594f, -333.9844f, -221.0938f, -97.2656f, -25.3906f, -0.3906f, -25.3906f, -9.7656f,
    30.8594f, -22.6563f, -40.2344f, -58.5938f, -104.6875f, -103.5156f, -166.4063f, -187.1094f, -239.8438f, -262.1094f, -392.5781f, -538.2813f, -791.7969f, -604.2969f, -221.8750f, -20.3125f,
    -107.4219f, -261.3281f, -417.9688f, -428.5156f, -268.7500f, -169.1406f, -132.8125f, -57.8125f, -10.5469f, 75.7813f, 120.7031f, 108.2031f, 89.4531f, 73.4375f, 32.0313f, 49.6094f,
    155.0781f, 524.6094f, 578.9063f, 675.3906f, 772.6563f, 785.9375f, 769.1406f, 723.4375f, 675.3906f, 614.8438f, 549.6094f, 424.6094f, 331.2500f, 248.4375f, 168.3594f, 108.5938f
};
/*   An 16-by-16 matrix */
const float TRWB2_SN2[256] =
{
    19.5313f, -25.7813f, -189.8438f, -332.0313f, 196.8750f, 134.7656f, 101.9531f, 3.9063f, -80.8594f, -85.1563f, -67.9688f, -7.0313f, 28.1250f, 26.9531f, 1.1719f, 9.3750f,
    -66.7969f, -171.4844f, -246.8750f, 152.3438f, 55.8594f, -34.7656f, -114.0625f, -122.6563f, -88.6719f, -61.3281f, 12.8906f, 70.7031f, 72.2656f, 79.6875f, 50.0000f, 65.2344f,
    178.9063f, 179.2969f, 30.4688f, -97.6563f, -142.5781f, -148.8281f, -137.8906f, -149.2188f, -127.7344f, -110.9375f, -74.6094f, -7.0313f, 1.1719f, 14.4531f, 11.3281f, 37.1094f,
    -66.0156f, -88.6719f, -165.2344f, -175.0000f, -189.4531f, -166.4063f, -142.1875f, -110.9375f, -92.9688f, -71.8750f, -89.0625f, -74.2188f, -56.6406f, 6.6406f, 25.3906f, 56.6406f,
    -1.5625f, -46.8750f, -66.4063f, -130.0781f, -264.4531f, -305.4688f, -280.8594f, -152.7344f, -43.7500f, 90.6250f, 181.2500f, 153.1250f, 107.4219f, 83.9844f, 47.2656f, 54.2969f,
    -36.7188f, -50.7813f, 176.9531f, 115.2344f, -17.5781f, -111.7188f, -173.4375f, -184.7656f, -202.7344f, -167.1875f, -104.6875f, -15.6250f, -4.6875f, 17.9688f, 15.2344f, 46.0938f,
    -73.8281f, -95.7031f, 314.4531f, 318.3594f, 202.3438f, 114.4531f, 63.2813f, 42.9688f, -26.1719f, -61.7188f, -87.1094f, -46.8750f, -14.0625f, 5.8594f, 10.1563f, 23.4375f,
    8.9844f, 50.7813f, 41.7969f, 0.0000f, -12.1094f, -25.7813f, 12.8906f, 8.5938f, 39.4531f, -3.9063f, -12.5000f, -90.6250f, -109.7656f, -230.4688f, -262.5000f, -425.3906f,
    19.9219f, 41.4063f, 61.3281f, 51.5625f, 15.6250f, 4.2969f, -28.5156f, -25.7813f, -64.4531f, -114.8438f, -219.1406f, -300.7813f, -289.8438f, -191.0156f, -78.9063f, 1.5625f,
    9.7656f, 89.8438f, 111.7188f, 69.9219f, 29.2969f, 7.0313f, 5.8594f, 9.3750f, 42.5781f, 73.0469f, 121.0938f, 130.4688f, 128.1250f, 113.6719f, 92.5781f, 82.8125f,
    -92.9688f, -192.1875f, -214.8438f, 219.9219f, 298.4375f, 238.2813f, 211.7188f, 166.7969f, 145.7031f, 101.9531f, 64.8438f, 66.7969f, 47.6563f, 13.2813f, -8.2031f, -35.9375f,
    -140.2344f, -180.4688f, -3.9063f, 8.5938f, -16.4063f, -0.7813f, 30.4688f, 65.2344f, 60.1563f, 60.5469f, 28.9063f, 28.5156f, 25.7813f, 36.7188f, 34.7656f, 49.2188f,
    -1.9531f, -42.9688f, -146.0938f, -213.2813f, -150.7813f, -53.1250f, 37.1094f, 119.1406f, 170.7031f, 222.6563f, 240.2344f, 217.9688f, 180.8594f, 130.8594f, 81.6406f, 58.9844f,
    8.9844f, 146.8750f, 114.0625f, 91.7969f, 189.4531f, 202.7344f, 256.6406f, 214.4531f, 186.7188f, 132.0313f, 72.6563f, 2.7344f, -10.9375f, -60.5469f, -37.1094f, -73.4375f,
    64.8438f, 54.2969f, -108.2031f, -279.6875f, -321.0938f, 91.4063f, 124.6094f, 127.3438f, 91.4063f, 14.0625f, -60.5469f, -123.8281f, -96.4844f, -31.2500f, 19.1406f, 45.7031f,
    168.3594f, 333.2031f, 291.0156f, 200.0000f, 126.9531f, 54.2969f, 32.4219f, -12.1094f, -9.7656f, -18.3594f, -6.6406f, -4.6875f, -9.3750f, -16.7969f, -1.9531f, 5.0781f
};
/*   An 16-by-32 matrix */
const float GEWB2_MA1[512] =
{
    257.4219f, 661.7188f, 638.2813f, 591.0156f, 509.7656f, 428.9063f, 364.4531f, 314.4531f, 286.3281f, 243.7500f, 205.0781f, 132.4219f, 93.3594f, 19.5313f, -13.6719f, -83.9844f,
    2.3438f, 25.3906f, 48.8281f, 21.4844f, -33.2031f, -49.2188f, -106.2500f, -123.4375f, -198.0469f, -228.9063f, -394.5313f, -499.2188f, -758.2031f, -746.0938f, -166.4063f, 30.4688f,
    109.7656f, 123.0469f, 92.1875f, -1.5625f, -39.8438f, -66.7969f, -90.6250f, -130.8594f, -141.4063f, -166.0156f, -190.6250f, -235.5469f, -261.3281f, -287.5000f, -253.1250f, -231.6406f,
    11.3281f, -98.0469f, -227.3438f, -340.2344f, -378.5156f, -350.3906f, -387.1094f, -420.7031f, -498.0469f, -578.1250f, -389.8438f, -153.5156f, -96.4844f, -3.5156f, 10.9375f, 105.8594f,
    -23.4375f, -141.0156f, 156.6406f, 215.6250f, 92.1875f, 13.6719f, -76.5625f, -83.9844f, -193.7500f, -266.7969f, -355.8594f, -320.3125f, -225.0000f, -116.7969f, -93.7500f, -55.0781f,
    162.5000f, 224.2188f, 258.5938f, 136.7188f, 51.9531f, -62.5000f, -168.3594f, -305.0781f, -468.7500f, -645.3125f, -794.9219f, -426.5625f, -175.3906f, -75.0000f, -4.2969f, 102.7344f,
    -80.4688f, -237.8906f, -363.6719f, 10.9375f, -89.4531f, -139.8438f, -212.1094f, -180.4688f, -147.2656f, -140.6250f, -131.2500f, -98.0469f, -41.0156f, 13.6719f, 10.1563f, 31.2500f,
    144.1406f, 490.6250f, 539.0625f, 613.6719f, 674.2188f, 674.6094f, 642.1875f, 594.1406f, 527.3438f, 451.5625f, 384.3750f, 292.1875f, 226.5625f, 154.2969f, 99.2188f, 42.1875f,
    -57.4219f, -187.1094f, -128.9063f, -28.5156f, -106.2500f, -172.2656f, -267.5781f, -326.9531f, -444.9219f, -569.5313f, -535.1563f, -161.7188f, -81.2500f, -4.6875f, 5.4688f, 83.2031f,
    -19.5313f, 39.0625f, -32.0313f, -98.8281f, -2.7344f, 46.4844f, 114.8438f, 153.1250f, 192.9688f, 225.7813f, 230.0781f, 204.2969f, 180.4688f, 149.6094f, 117.1875f, 97.2656f,
    -36.7188f, -141.4063f, -224.6094f, -300.7813f, -385.5469f, -390.2344f, -360.1563f, -272.2656f, -227.3438f, -119.1406f, -52.7344f, -12.1094f, -3.1250f, 8.9844f, -12.8906f, 24.2188f,
    11.3281f, -25.0000f, -1.5625f, -48.0469f, -134.3750f, -161.7188f, -265.2344f, -299.6094f, -450.0000f, -547.2656f, -822.2656f, -744.1406f, -227.3438f, -117.1875f, -25.0000f, 87.1094f,
    167.1875f, 386.7188f, 398.0469f, 316.0156f, 266.0156f, 183.5938f, 142.9688f, 69.9219f, 49.2188f, -10.1563f, -55.0781f, -141.7969f, -165.2344f, -209.3750f, -170.7031f, -212.8906f,
    -51.9531f, -139.4531f, 142.1875f, 94.1406f, -15.2344f, -88.6719f, -130.4688f, -119.1406f, -166.4063f, -114.0625f, -39.8438f, 33.9844f, 62.1094f, 71.0938f, 62.5000f, 74.2188f,
    218.7500f, 298.4375f, 207.4219f, 60.9375f, 8.5938f, -7.0313f, 8.9844f, -7.8125f, 7.4219f, 0.0000f, 5.0781f, -23.8281f, -13.6719f, -17.1875f, -4.6875f, -18.7500f,
    12.8906f, -91.7969f, -247.6563f, -426.9531f, 53.1250f, -12.1094f, -26.5625f, -111.3281f, -206.6406f, -208.9844f, -180.4688f, -97.2656f, -37.1094f, -20.7031f, -45.3125f, -23.8281f,
    -73.4375f, -245.3125f, -349.2188f, 274.2188f, 273.4375f, 145.7031f, 76.5625f, 19.9219f, 37.1094f, -21.8750f, -74.6094f, -70.7031f, -67.5781f, -51.5625f, -45.3125f, -85.1563f,
    14.4531f, -73.4375f, -258.2031f, -424.6094f, -516.4063f, -100.7813f, -72.6563f, -70.7031f, -92.9688f, -145.3125f, -163.2813f, -198.4375f, -169.1406f, -76.9531f, -28.5156f, 10.9375f,
    -90.2344f, -86.7188f, 355.8594f, 341.7969f, 261.3281f, 171.8750f, 141.7969f, 117.5781f, 100.3906f, 75.0000f, 57.4219f, 26.5625f, 30.0781f, 16.7969f, 22.2656f, 6.6406f,
    -1.5625f, -73.0469f, -139.0625f, -160.1563f, -222.2656f, -194.9219f, -228.1250f, -221.8750f, -257.8125f, -274.6094f, -376.9531f, -469.1406f, -601.5625f, -276.5625f, -98.4375f, 33.9844f,
    85.9375f, 25.0000f, -26.1719f, -139.4531f, -223.4375f, -290.6250f, -356.6406f, -459.3750f, -562.1094f, -739.8438f, -840.6250f, -297.6563f, -163.6719f, -57.0313f, -3.9063f, 109.7656f,
    -98.8281f, -244.9219f, -419.9219f, -471.0938f, -281.6406f, -155.4688f, -131.6406f, -73.4375f, -46.0938f, 19.5313f, 48.8281f, 77.3438f, 78.1250f, 74.2188f, 37.5000f, 64.0625f,
    -135.9375f, -289.4531f, -333.5938f, -139.4531f, -63.6719f, -40.2344f, -10.1563f, 55.8594f, 90.2344f, 124.2188f, 130.8594f, 126.9531f, 107.0313f, 91.0156f, 65.2344f, 74.2188f,
    -55.8594f, -100.0000f, -74.6094f, -109.3750f, -97.6563f, -74.6094f, -32.0313f, 14.4531f, 49.2188f, 39.8438f, 26.1719f, -50.7813f, -78.9063f, -167.9688f, -193.3594f, -316.4063f,
    90.6250f, 41.7969f, -8.5938f, -133.2031f, -194.1406f, -204.2969f, -237.1094f, -252.3438f, -291.4063f, -269.5313f, -186.7188f, -115.2344f, -62.5000f, -30.0781f, -20.7031f, -2.7344f,
    -12.8906f, -38.2813f, -100.7813f, -195.7031f, -230.0781f, -171.0938f, -123.4375f, -65.6250f, -22.6563f, 32.0313f, 68.3594f, 85.5469f, 97.2656f, 101.1719f, 92.5781f, 88.2813f,
    -153.5156f, -259.7656f, -7.4219f, 72.2656f, 97.2656f, 103.9063f, 147.6563f, 182.8125f, 194.9219f, 198.4375f, 181.2500f, 151.5625f, 121.0938f, 92.9688f, 72.6563f, 56.6406f,
    -93.7500f, -38.6719f, 159.3750f, 187.5000f, 270.7031f, 297.2656f, 369.5313f, 368.3594f, 371.4844f, 348.8281f, 305.4688f, 239.4531f, 188.2813f, 137.1094f, 101.5625f, 63.6719f,
    -8.9844f, 204.2969f, 345.7031f, 352.7344f, 457.8125f, 502.7344f, 578.9063f, 582.4219f, 576.5625f, 547.6563f, 484.3750f, 392.5781f, 307.4219f, 235.9375f, 169.1406f, 114.0625f,
    102.3438f, 385.9375f, 353.1250f, 285.9375f, 286.7188f, 259.7656f, 279.2969f, 256.2500f, 262.8906f, 240.2344f, 211.3281f, 145.3125f, 110.9375f, 54.2969f, 26.5625f, -32.8125f,
    -46.4844f, 174.2188f, 436.7188f, 474.6094f, 535.9375f, 500.0000f, 471.8750f, 386.3281f, 344.1406f, 263.6719f, 217.5781f, 124.6094f, 88.6719f, 8.9844f, -15.2344f, -100.0000f,
    -39.8438f, 69.5313f, 148.0469f, 98.4375f, 142.5781f, 124.6094f, 177.7344f, 147.2656f, 161.3281f, 108.5938f, 87.8906f, -14.0625f, -26.1719f, -137.1094f, -146.4844f, -301.5625f
};
/*   An 16-by-16 matrix */
const float AUNB_SN1[256] =
{
    -70.3125f, -30.8594f, -19.9219f, 15.2344f, 25.7813f, 38.6719f, 18.7500f, 42.1875f, 21.8750f, 49.6094f, 13.2813f, 17.9688f, -183.5938f, -330.0781f, -55.0781f, -35.1563f,
    -82.8125f, 32.0313f, 110.9375f, 164.8438f, 162.5000f, 162.5000f, 122.2656f, 112.8906f, 91.0156f, 82.0313f, 42.1875f, 21.4844f, -171.4844f, -516.7969f, -131.2500f, -48.0469f,
    -3.5156f, 158.2031f, 207.8125f, 257.4219f, 277.3438f, 311.7188f, 329.6875f, 379.2969f, 418.7500f, 461.3281f, 571.8750f, 747.2656f, 792.1875f, 481.2500f, 214.4531f, 103.5156f,
    29.2969f, 19.1406f, 128.9063f, 192.5781f, 175.0000f, 128.5156f, 79.6875f, 26.1719f, -7.0313f, -52.3438f, -91.7969f, -156.2500f, -236.3281f, -11.7188f, -26.1719f, -14.0625f,
    -3.5156f, -2.7344f, -37.1094f, -86.7188f, -125.7813f, -164.4531f, -125.3906f, -91.0156f, -42.9688f, -33.5938f, 26.1719f, -7.4219f, 1.1719f, 134.7656f, 16.0156f, 11.7188f,
    59.7656f, 13.2813f, -67.1875f, -150.7813f, -195.3125f, -214.0625f, -196.4844f, -164.0625f, -123.8281f, -80.8594f, -44.5313f, 71.4844f, 428.1250f, 258.2031f, 77.3438f, 36.7188f,
    240.6250f, 195.7031f, 183.9844f, 85.9375f, 61.3281f, 21.4844f, 1.5625f, -62.8906f, -69.5313f, -122.6563f, -104.2969f, -151.9531f, 84.3750f, 167.5781f, 17.9688f, 14.8438f,
    -218.3594f, -333.5938f, -308.2031f, -144.1406f, -59.7656f, 25.0000f, 57.0313f, 115.6250f, 151.5625f, 203.1250f, 224.2188f, 374.2188f, 578.5156f, 350.7813f, 132.8125f, 64.0625f,
    51.1719f, 53.5156f, 45.3125f, 22.2656f, 25.0000f, -8.2031f, -14.8438f, -43.7500f, -48.0469f, -77.7344f, -83.5938f, -148.0469f, -250.3906f, 32.4219f, -20.7031f, -8.2031f,
    -39.4531f, -126.5625f, -253.1250f, -312.8906f, -326.1719f, -287.8906f, -195.7031f, -115.6250f, -33.5938f, 56.2500f, 156.2500f, 400.3906f, 586.3281f, 336.3281f, 125.7813f, 58.9844f,
    -90.2344f, -155.0781f, -200.0000f, -197.6563f, -120.3125f, -78.1250f, -49.6094f, -35.5469f, -7.0313f, 6.6406f, 36.7188f, 44.5313f, 311.7188f, 244.1406f, 62.8906f, 34.3750f,
    -202.3438f, -241.0156f, -78.5156f, 40.2344f, 100.7813f, 108.9844f, 106.6406f, 104.2969f, 109.7656f, 98.0469f, 83.5938f, 44.5313f, 22.6563f, 105.4688f, 27.3438f, 12.1094f,
    6.6406f, -33.5938f, -30.4688f, -32.0313f, -8.5938f, -28.5156f, -66.7969f, -116.7969f, -130.4688f, -168.3594f, -164.8438f, -205.4688f, 201.9531f, 199.6094f, 27.7344f, 20.7031f,
    107.8125f, 71.0938f, -15.6250f, -131.2500f, -180.0781f, -36.3281f, 133.5938f, 104.2969f, 64.8438f, 7.0313f, -16.7969f, -76.5625f, -57.0313f, 92.1875f, 7.0313f, 5.4688f,
    88.6719f, 132.0313f, 87.5000f, 73.4375f, 41.7969f, 31.2500f, 22.2656f, 35.9375f, 13.2813f, 31.2500f, -1.9531f, -1.5625f, -201.1719f, -362.1094f, -67.9688f, -39.0625f,
    285.5469f, 290.6250f, 311.3281f, 263.6719f, 230.4688f, 171.0938f, 128.1250f, 83.9844f, 56.2500f, 9.3750f, -37.5000f, -93.3594f, -189.8438f, -68.3594f, -25.3906f, -16.0156f
};
/*   An 16-by-16 matrix */
const float AUWB_SN1[256] =
{
    128.1250f, 53.5156f, 139.8438f, 128.9063f, 71.8750f, 56.6406f, -23.4375f, -114.8438f, -216.7969f, -306.2500f, -369.1406f, -340.6250f, -234.7656f, -131.6406f, -60.5469f, -12.8906f,
    12.5000f, -82.8125f, -190.6250f, -254.2969f, -293.7500f, -342.5781f, -348.4375f, -346.0938f, -333.2031f, -310.5469f, -275.3906f, -214.4531f, -128.9063f, -87.5000f, -49.6094f, -3.5156f,
    145.3125f, 127.7344f, 76.9531f, 12.8906f, 5.0781f, -21.4844f, -33.9844f, -48.4375f, -48.8281f, -57.8125f, -56.2500f, -65.6250f, -68.3594f, -71.8750f, -49.6094f, -48.8281f,
    293.7500f, 283.9844f, 243.3594f, 202.7344f, 175.3906f, 136.7188f, 120.7031f, 112.8906f, 106.2500f, 98.4375f, 72.2656f, 48.4375f, 46.0938f, 13.6719f, 8.5938f, -7.8125f,
    5.4688f, 56.2500f, 115.6250f, 168.7500f, 162.5000f, 126.9531f, 69.1406f, 64.8438f, 58.9844f, 48.0469f, 42.5781f, 40.6250f, 18.3594f, -8.5938f, -17.5781f, -19.1406f,
    121.0938f, 43.7500f, -55.0781f, -206.6406f, -255.4688f, -20.7031f, 63.2813f, -12.8906f, -116.0156f, -215.2344f, -301.5625f, -319.1406f, -210.9375f, -112.1094f, -37.1094f, -2.7344f,
    -61.7188f, 94.1406f, 173.0469f, 212.1094f, 218.3594f, 226.1719f, 221.0938f, 236.7188f, 238.2813f, 242.9688f, 235.1563f, 225.7813f, 189.4531f, 129.2969f, 76.9531f, 40.6250f,
    -183.9844f, -207.0313f, 14.4531f, 106.2500f, 155.0781f, 172.6563f, 182.0313f, 204.2969f, 219.1406f, 231.2500f, 237.5000f, 225.0000f, 189.4531f, 135.9375f, 86.7188f, 51.9531f,
    63.2813f, 0.0000f, -33.9844f, -33.2031f, -58.9844f, -129.2969f, -160.1563f, -235.5469f, -299.6094f, -402.3438f, -526.5625f, -707.8125f, -677.7344f, -264.8438f, -110.9375f, -2.3438f,
    -60.9375f, 14.0625f, 5.8594f, 10.1563f, 16.0156f, 46.0938f, 78.5156f, 103.5156f, 132.4219f, 149.2188f, 164.0625f, 169.9219f, 147.2656f, 103.1250f, 62.1094f, 32.8125f,
    -26.9531f, -107.0313f, -160.5469f, -61.7188f, 23.4375f, -21.8750f, -74.2188f, -119.1406f, -144.9219f, -151.9531f, -160.5469f, -158.9844f, -132.0313f, -107.8125f, -67.5781f, -38.6719f,
    0.0000f, -10.1563f, -76.5625f, -148.0469f, -144.1406f, -127.7344f, -75.3906f, -57.8125f, -30.0781f, -3.9063f, 24.6094f, 38.2813f, 38.2813f, 19.1406f, 15.6250f, -1.9531f,
    -58.2031f, -168.7500f, -284.7656f, -360.5469f, -362.1094f, -299.2188f, -221.8750f, -177.7344f, -130.0781f, -85.5469f, -47.6563f, -11.3281f, 4.2969f, 3.5156f, 7.8125f, 21.0938f,
    69.1406f, 25.0000f, -23.4375f, -90.6250f, -160.5469f, -215.6250f, -217.5781f, -214.8438f, -198.8281f, -181.2500f, -148.4375f, -129.2969f, -116.0156f, -112.5000f, -83.9844f, -66.4063f,
    -6.2500f, 171.4844f, 379.2969f, 431.2500f, 472.2656f, 516.7969f, 523.0469f, 536.7188f, 514.4531f, 477.7344f, 432.4219f, 383.9844f, 305.0781f, 208.9844f, 123.0469f, 58.9844f,
    -168.7500f, -283.9844f, -267.9688f, -132.8125f, -60.9375f, -15.6250f, 7.0313f, 39.8438f, 66.0156f, 100.3906f, 119.5313f, 130.8594f, 115.6250f, 83.2031f, 53.5156f, 37.8906f
};
/*   An 16-by-16 matrix */
const float AUWB2_SN1[256] =
{
    -41.7969f, -174.2188f, -326.1719f, -406.6406f, -450.0000f, -453.5156f, -447.6563f, -378.5156f, -323.4375f, -208.2031f, -98.0469f, -94.5313f, -54.2969f, 67.1875f, 37.1094f, 182.0313f,
    410.9375f, 393.7500f, 410.9375f, 341.7969f, 337.5000f, 292.1875f, 305.8594f, 269.5313f, 294.5313f, 279.2969f, 268.7500f, 133.5938f, 76.1719f, -12.5000f, -98.0469f, -198.8281f,
    -121.4844f, -66.4063f, 142.9688f, 246.8750f, 292.1875f, 337.1094f, 383.9844f, 407.0313f, 436.7188f, 464.0625f, 442.5781f, 349.6094f, 284.3750f, 242.5781f, 179.6875f, 163.2813f,
    237.5000f, 205.0781f, 125.7813f, 11.7188f, -92.5781f, -188.6719f, -336.7188f, -460.1563f, -644.9219f, -853.1250f, -1082.0313f, -526.9531f, -167.9688f, -10.9375f, 50.0000f, 219.5313f,
    115.6250f, 66.7969f, -75.0000f, -167.5781f, -190.6250f, -183.5938f, -192.1875f, -184.7656f, -175.0000f, -137.5000f, -94.5313f, -120.7031f, -131.6406f, -82.0313f, -103.5156f, -71.0938f,
    324.6094f, 274.6094f, 178.1250f, 84.7656f, 64.4531f, 25.3906f, 6.6406f, -20.7031f, -26.1719f, -30.4688f, -14.8438f, -86.7188f, -132.8125f, -128.5156f, -136.3281f, -152.7344f,
    63.2813f, -5.0781f, -61.7188f, -130.8594f, -205.4688f, -275.3906f, -385.1563f, -486.3281f, -640.6250f, -839.4531f, -1075.7813f, -525.0000f, -145.3125f, -4.6875f, 52.3438f, 220.3125f,
    -30.8594f, -151.9531f, -222.2656f, -273.0469f, -316.7969f, -367.1875f, -413.2813f, -507.4219f, -599.2188f, -811.3281f, -762.8906f, -198.0469f, -84.3750f, 55.8594f, 74.6094f, 237.1094f,
    -41.4063f, -45.3125f, -82.0313f, -87.8906f, -126.1719f, -128.9063f, -192.9688f, -191.7969f, -273.4375f, -295.7031f, -412.8906f, -556.2500f, -867.9688f, -589.4531f, -101.1719f, 135.9375f,
    -142.9688f, -292.1875f, -459.7656f, -475.0000f, -397.2656f, -272.6563f, -173.4375f, -60.1563f, 3.9063f, 111.3281f, 141.0156f, 110.9375f, 99.6094f, 140.2344f, 73.0469f, 142.5781f,
    30.0781f, 174.6094f, 163.2813f, 185.5469f, 176.9531f, 179.2969f, 185.5469f, 201.1719f, 219.5313f, 253.1250f, 257.0313f, 176.5625f, 143.3594f, 130.4688f, 95.3125f, 79.6875f,
    3.9063f, 76.9531f, 66.4063f, 64.8438f, 56.2500f, 23.4375f, 20.3125f, -0.7813f, -7.8125f, -15.6250f, 7.0313f, -92.9688f, -108.9844f, -169.5313f, -176.1719f, -315.2344f,
    -179.6875f, -278.5156f, -213.6719f, -59.7656f, 25.0000f, 94.9219f, 150.7813f, 192.1875f, 242.1875f, 293.7500f, 296.4844f, 209.3750f, 173.8281f, 126.5625f, 58.9844f, -12.5000f,
    -96.0938f, -154.6875f, -161.3281f, -144.9219f, -138.2813f, -123.8281f, -119.9219f, -89.0625f, -76.1719f, -39.4531f, -14.0625f, -67.9688f, -76.9531f, -63.2813f, -101.9531f, -136.3281f,
    -128.5156f, -93.7500f, 127.3438f, 180.4688f, 167.1875f, 134.3750f, 158.2031f, 146.0938f, 171.4844f, 169.5313f, 182.4219f, 49.6094f, 33.2031f, -60.1563f, -96.8750f, -266.7969f,
    -4.6875f, 5.8594f, -86.7188f, -88.6719f, -12.1094f, 48.4375f, 78.1250f, 114.8438f, 139.4531f, 211.3281f, 237.1094f, 179.2969f, 146.8750f, 137.5000f, 110.1563f, 110.5469f
};
/*   An 16-by-16 matrix */
const float CNG_SN1[256] =
{
    234.3750f, 640.6250f, 1187.1094f, 1662.8906f, 2153.1250f, 2632.8125f, 3120.7031f, 3581.6406f, 4059.7656f, 4535.9375f, 5031.2500f, 5507.8125f, 6007.0313f, 6466.4063f, 6959.3750f, 7389.8438f,
    464.0625f, 971.4844f, 1463.2813f, 1915.2344f, 2383.9844f, 2836.3281f, 3295.7031f, 3744.9219f, 4209.3750f, 4669.5313f, 5145.3125f, 5607.4219f, 6079.6875f, 6528.1250f, 6997.2656f, 7426.5625f,
    135.1563f, 312.1094f, 882.4219f, 1388.6719f, 1904.6875f, 2412.1094f, 2935.9375f, 3438.6719f, 3934.7656f, 4423.0469f, 4933.9844f, 5444.5313f, 5969.5313f, 6466.0156f, 6959.7656f, 7437.1094f,
    171.4844f, 631.2500f, 1346.0938f, 1852.7344f, 2372.2656f, 2846.8750f, 3341.0156f, 3799.2188f, 4276.1719f, 4728.9063f, 5200.0000f, 5653.9063f, 6113.2813f, 6551.9531f, 6989.8438f, 7412.8906f,
    359.7656f, 703.1250f, 1162.5000f, 1565.2344f, 1994.1406f, 2397.2656f, 2803.9063f, 3183.5938f, 3537.8906f, 3872.6563f, 4300.3906f, 4900.3906f, 5340.2344f, 6055.4688f, 6807.8125f, 7393.3594f,
    350.0000f, 741.7969f, 1185.5469f, 1612.5000f, 2070.7031f, 2511.3281f, 2970.3125f, 3405.8594f, 3861.7188f, 4319.9219f, 4850.3906f, 5320.7031f, 5844.5313f, 6302.7344f, 6826.1719f, 7210.9375f,
    282.0313f, 588.6719f, 991.0156f, 1342.5781f, 1690.6250f, 2027.3438f, 2350.7813f, 2672.2656f, 2963.6719f, 3258.9844f, 3486.3281f, 3715.2344f, 3874.6094f, 4326.1719f, 5317.5781f, 5867.5781f,
    123.0469f, 239.0625f, 652.7344f, 1136.7188f, 1558.5938f, 1985.5469f, 2390.6250f, 2800.7813f, 3198.4375f, 3583.2031f, 3964.0625f, 4369.5313f, 4785.1563f, 5180.4688f, 5582.0313f, 5970.3125f,
    345.7031f, 753.1250f, 1175.7813f, 1551.9531f, 1934.3750f, 2304.6875f, 2675.0000f, 3034.7656f, 3398.8281f, 3753.5156f, 4133.2031f, 4507.8125f, 4885.9375f, 5253.9063f, 5629.6875f, 5995.7031f,
    132.0313f, 398.4375f, 1037.8906f, 1459.3750f, 1890.2344f, 2262.1094f, 2658.5938f, 3031.2500f, 3413.2813f, 3773.0469f, 4151.1719f, 4518.3594f, 4896.0938f, 5260.9375f, 5631.2500f, 5989.8438f,
    439.8438f, 767.1875f, 1171.4844f, 1505.8594f, 1860.9375f, 2190.6250f, 2532.0313f, 2846.0938f, 3167.5781f, 3448.0469f, 3738.2813f, 4159.7656f, 4687.1094f, 5126.9531f, 5555.8594f, 5957.8125f,
    150.3906f, 318.3594f, 781.2500f, 1148.0469f, 1525.7813f, 1905.8594f, 2262.8906f, 2630.4688f, 2992.5781f, 3330.4688f, 3636.3281f, 3963.2813f, 4530.0781f, 5060.5469f, 5510.1563f, 5953.5156f,
    247.2656f, 564.4531f, 937.5000f, 1286.3281f, 1654.2969f, 2019.9219f, 2399.6094f, 2767.1875f, 3147.2656f, 3507.8125f, 3876.5625f, 4267.1875f, 4682.4219f, 5077.3438f, 5475.0000f, 5882.0313f,
    228.1250f, 487.5000f, 878.9063f, 1223.0469f, 1582.0313f, 1921.8750f, 2269.9219f, 2598.4375f, 2918.3594f, 3220.3125f, 3481.6406f, 3703.1250f, 3979.6875f, 4775.3906f, 5418.3594f, 5907.4219f,
    451.9531f, 710.9375f, 1072.2656f, 1369.1406f, 1700.7813f, 1991.0156f, 2317.1875f, 2596.8750f, 2893.7500f, 3138.2813f, 3373.0469f, 3548.0469f, 3897.2656f, 4776.5625f, 5398.0469f, 5901.5625f,
    223.4375f, 547.2656f, 982.0313f, 1367.5781f, 1758.9844f, 2134.7656f, 2526.9531f, 2904.2969f, 3287.5000f, 3643.7500f, 4025.7813f, 4417.5781f, 4815.6250f, 5196.4844f, 5588.2813f, 5961.3281f
};
/*   An 16-by-32 matrix */
const float IAA_MA1[512] =
{
    -68.3594f, -191.4063f, -203.1250f, -246.4844f, -251.9531f, -239.8438f, -238.2813f, -214.0625f, -196.4844f, -168.7500f, -137.8906f, -117.5781f, -92.9688f, -55.0781f, -26.1719f, 10.1563f,
    117.5781f, 158.9844f, 88.6719f, 37.5000f, -4.6875f, -7.0313f, -5.0781f, 0.7813f, 15.2344f, 41.7969f, 48.4375f, 35.9375f, 32.4219f, 39.0625f, 24.2188f, 28.1250f,
    -109.3750f, -287.8906f, -222.2656f, -64.0625f, -3.5156f, 39.0625f, 55.0781f, 82.4219f, 98.4375f, 109.7656f, 107.0313f, 84.7656f, 80.4688f, 85.5469f, 45.7031f, 41.4063f,
    -103.9063f, -294.1406f, -328.5156f, -229.2969f, -190.2344f, -134.7656f, -102.7344f, -65.2344f, -44.5313f, -11.7188f, 3.1250f, 12.5000f, 13.2813f, 23.8281f, 21.4844f, 40.6250f,
    -35.5469f, -53.5156f, -114.4531f, -136.3281f, -137.5000f, -127.3438f, -104.6875f, -96.4844f, -69.5313f, -50.3906f, -21.8750f, -37.5000f, -4.2969f, 85.5469f, 19.1406f, 21.8750f,
    -7.0313f, 0.3906f, -12.8906f, -5.4688f, -7.4219f, -1.9531f, -8.5938f, -5.4688f, -16.7969f, -14.4531f, -40.6250f, -55.8594f, -146.4844f, -300.7813f, -74.2188f, -39.0625f,
    28.1250f, -8.5938f, -47.2656f, -85.9375f, -125.0000f, -147.6563f, -195.3125f, -229.2969f, -284.7656f, -310.5469f, -412.5000f, -509.7656f, -660.5469f, -425.7813f, -176.5625f, -23.4375f,
    7.4219f, -108.9844f, -176.9531f, -226.5625f, -229.6875f, -288.6719f, -335.1563f, -407.8125f, -500.3906f, -630.4688f, -359.7656f, -146.8750f, -106.6406f, -32.8125f, -0.7813f, 73.0469f,
    333.2031f, 296.4844f, 230.8594f, 146.8750f, 101.5625f, 47.6563f, 15.2344f, -27.7344f, -51.9531f, -71.8750f, -81.6406f, -116.0156f, -116.7969f, -66.7969f, -48.4375f, -32.4219f,
    103.9063f, 13.2813f, -71.0938f, -143.3594f, -201.5625f, -267.9688f, -344.1406f, -437.8906f, -552.3438f, -716.4063f, -824.2188f, -389.4531f, -202.7344f, -107.0313f, -42.5781f, 53.5156f,
    -0.7813f, -3.1250f, 16.4063f, 35.5469f, 67.1875f, 82.4219f, 116.4063f, 131.2500f, 169.1406f, 159.7656f, 213.2813f, 407.4219f, 585.5469f, 405.4688f, 160.1563f, 73.8281f,
    33.5938f, 99.2188f, 101.1719f, 99.2188f, 96.0938f, 85.5469f, 71.8750f, 47.6563f, 30.8594f, 4.2969f, -21.4844f, -66.4063f, -141.7969f, -364.8438f, -144.9219f, -73.4375f,
    65.6250f, 65.2344f, -47.6563f, -95.3125f, -126.9531f, -132.8125f, -140.2344f, -133.9844f, -129.2969f, -113.6719f, -108.5938f, -105.4688f, -106.2500f, -63.2813f, -39.4531f, -17.9688f,
    -95.3125f, -179.2969f, -143.3594f, -132.8125f, -115.2344f, -85.9375f, -67.5781f, -41.7969f, -8.5938f, 20.7031f, 40.2344f, 114.4531f, 423.4375f, 315.2344f, 101.5625f, 45.7031f,
    -124.6094f, -253.9063f, -267.5781f, -166.7969f, -113.2813f, -41.0156f, 9.7656f, 62.8906f, 118.3594f, 163.2813f, 229.2969f, 419.5313f, 610.5469f, 423.8281f, 156.2500f, 66.4063f,
    57.0313f, 100.3906f, 110.1563f, 115.2344f, 118.3594f, 114.8438f, 116.0156f, 102.3438f, 92.5781f, 75.3906f, 35.9375f, 133.2031f, 476.5625f, 345.3125f, 123.0469f, 56.2500f,
    -113.6719f, -217.9688f, 57.4219f, 78.5156f, 110.1563f, 109.3750f, 121.0938f, 117.9688f, 122.2656f, 119.5313f, 114.0625f, 93.3594f, 77.3438f, 73.4375f, 41.4063f, 36.7188f,
    -4.2969f, -3.1250f, -60.9375f, -79.6875f, -90.2344f, -97.6563f, -103.5156f, -112.8906f, -105.0781f, -123.4375f, -125.7813f, -175.7813f, -190.6250f, -264.0625f, -303.9063f, -380.0781f,
    -45.7031f, -10.5469f, 1.5625f, 37.5000f, 67.9688f, 89.4531f, 105.8594f, 121.0938f, 134.3750f, 141.4063f, 134.3750f, 106.6406f, 81.6406f, 70.3125f, 42.5781f, 41.4063f,
    -101.5625f, -113.2813f, 58.9844f, 105.0781f, 158.5938f, 172.6563f, 215.2344f, 230.4688f, 265.2344f, 266.0156f, 351.5625f, 505.0781f, 637.1094f, 442.1875f, 186.3281f, 86.3281f,
    -14.4531f, 146.0938f, 153.9063f, 161.7188f, 163.6719f, 154.2969f, 134.7656f, 122.2656f, 110.1563f, 99.6094f, 82.4219f, 49.2188f, 32.8125f, 19.9219f, -3.9063f, -20.7031f,
    157.8125f, 127.7344f, 67.9688f, 10.9375f, -48.4375f, -113.2813f, -191.4063f, -271.4844f, -394.9219f, -433.9844f, -206.6406f, -112.5000f, -71.4844f, -26.9531f, -2.7344f, 55.4688f,
    219.9219f, 293.7500f, 228.5156f, 216.7969f, 200.0000f, 186.7188f, 165.6250f, 154.6875f, 146.8750f, 133.9844f, 117.1875f, 75.7813f, 75.3906f, 63.2813f, 30.4688f, 17.9688f,
    -23.0469f, -51.1719f, -13.6719f, 19.1406f, 21.0938f, -4.6875f, -35.9375f, -72.2656f, -94.9219f, -112.8906f, -112.5000f, -134.3750f, -127.3438f, 0.0000f, -14.8438f, 2.3438f,
    193.7500f, 227.3438f, 220.3125f, 200.7813f, 203.5156f, 191.4063f, 189.8438f, 170.3125f, 168.7500f, 125.0000f, 178.1250f, 414.0625f, 594.9219f, 413.2813f, 163.6719f, 75.7813f,
    67.9688f, 30.0781f, 7.0313f, -34.7656f, -43.7500f, -76.5625f, -64.4531f, -96.4844f, -86.7188f, -127.3438f, -129.6875f, -192.9688f, 194.9219f, 241.0156f, 47.2656f, 23.4375f,
    123.0469f, 116.7969f, 89.4531f, 53.5156f, 30.4688f, -1.1719f, -15.6250f, -53.9063f, -77.3438f, -119.9219f, -146.4844f, -196.0938f, -201.1719f, -9.7656f, -34.3750f, -19.1406f,
    -90.6250f, -11.3281f, 137.8906f, 155.8594f, 189.4531f, 190.2344f, 204.2969f, 205.4688f, 217.1875f, 218.3594f, 203.1250f, 162.1094f, 128.1250f, 110.5469f, 73.0469f, 64.8438f,
    71.0938f, 150.3906f, 157.4219f, 176.9531f, 201.1719f, 223.4375f, 248.0469f, 269.9219f, 307.4219f, 332.8125f, 450.7813f, 579.2969f, 694.9219f, 480.8594f, 204.6875f, 96.0938f,
    -106.6406f, -192.1875f, -72.2656f, -37.8906f, -20.3125f, -19.9219f, -6.6406f, -10.5469f, 5.0781f, 7.8125f, 17.5781f, -7.8125f, 20.3125f, 95.3125f, 22.6563f, 21.8750f,
    7.8125f, -1.1719f, -94.1406f, -104.2969f, -75.7813f, -33.5938f, 1.5625f, 29.2969f, 54.6875f, 74.6094f, 78.1250f, 60.1563f, 53.5156f, 57.0313f, 33.2031f, 30.0781f,
    35.9375f, 245.3125f, 238.6719f, 276.5625f, 275.7813f, 279.6875f, 262.5000f, 271.0938f, 255.8594f, 241.7969f, 214.8438f, 168.7500f, 138.2813f, 110.9375f, 79.6875f, 67.1875f
};
/*   An 16-by-8 matrix */
const float GESVNB_AR1[128] =
{
    -9.7656f, -25.0000f, -54.6875f, -46.0938f, 105.4688f, 93.7500f, 49.6094f, 27.3438f, 7.8125f, -15.6250f, -21.8750f, -43.3594f, -32.0313f, 25.0000f, 0.7813f, 1.9531f,
    31.6406f, 40.6250f, 27.7344f, 27.3438f, 0.0000f, -19.1406f, -21.0938f, -28.5156f, -23.0469f, -35.9375f, -39.8438f, -78.5156f, -157.8125f, -20.3125f, -15.6250f, -5.8594f,
    -43.7500f, -84.7656f, -98.0469f, -78.9063f, -13.2813f, 22.2656f, 22.6563f, 24.2188f, 30.8594f, 49.6094f, 69.1406f, 119.5313f, 204.6875f, 123.0469f, 43.7500f, 20.7031f,
    6.6406f, -2.3438f, 13.2813f, 25.7813f, 5.4688f, -10.1563f, -67.9688f, -76.5625f, -55.4688f, -51.1719f, -39.8438f, -37.8906f, 70.3125f, 60.1563f, 11.3281f, 6.6406f,
    1.9531f, -10.5469f, -41.7969f, -76.9531f, -133.9844f, -130.0781f, -71.0938f, -55.8594f, -35.5469f, -6.6406f, 16.7969f, 46.8750f, 149.6094f, 104.2969f, 32.4219f, 15.6250f,
    -0.3906f, -5.8594f, -13.6719f, -21.8750f, -66.0156f, -56.6406f, 33.5938f, 39.4531f, 30.0781f, 18.7500f, 11.3281f, 30.4688f, -3.5156f, 26.5625f, 5.8594f, 3.5156f,
    1.1719f, 3.5156f, 125.0000f, 175.7813f, 150.3906f, 135.9375f, 83.9844f, 60.5469f, 41.0156f, 17.5781f, -5.0781f, -29.2969f, -106.2500f, -50.3906f, -20.3125f, -8.9844f,
    1.5625f, 19.1406f, 21.0938f, 35.1563f, 35.9375f, 39.4531f, 23.0469f, 26.9531f, 7.8125f, 27.3438f, 8.9844f, 16.7969f, -109.3750f, -243.7500f, -44.5313f, -21.4844f
};
/*   An 16-by-8 matrix */
const float GESVNB_AR2[128] =
{
    -8.5938f, -13.6719f, -12.1094f, -64.8438f, -64.0625f, 84.7656f, 82.8125f, 60.5469f, 64.8438f, 48.0469f, 26.1719f, 12.8906f, -8.2031f, -16.0156f, -1.1719f, -0.3906f,
    -5.4688f, -7.8125f, -6.2500f, -27.3438f, -30.0781f, -20.7031f, 8.9844f, -2.7344f, -38.2813f, -48.0469f, -38.6719f, -19.1406f, 139.4531f, 44.5313f, 14.0625f, 7.4219f,
    -22.2656f, -46.4844f, -118.3594f, -83.9844f, -12.8906f, -40.2344f, -37.8906f, -45.7031f, -41.0156f, -39.8438f, -26.1719f, -52.3438f, -68.7500f, 44.1406f, 6.2500f, 3.1250f,
    -4.6875f, 5.4688f, 11.7188f, -14.4531f, -43.7500f, -88.2813f, -80.4688f, -9.7656f, 48.8281f, 52.3438f, 38.6719f, 32.4219f, 21.4844f, -1.5625f, 3.5156f, 1.5625f,
    -7.4219f, 8.9844f, 66.7969f, 22.2656f, 5.0781f, -5.8594f, -10.1563f, -16.4063f, -25.3906f, -26.9531f, -30.0781f, -66.0156f, -137.1094f, -41.0156f, -19.1406f, -8.2031f,
    -5.4688f, -3.9063f, 3.1250f, 13.6719f, 62.8906f, 40.6250f, -28.9063f, -39.8438f, -52.7344f, -18.3594f, 17.5781f, 103.1250f, 20.3125f, -26.9531f, -0.3906f, -1.9531f,
    83.2031f, 110.9375f, 89.8438f, 47.2656f, 19.5313f, 4.6875f, 16.7969f, 18.7500f, 10.5469f, -2.7344f, -9.3750f, -15.2344f, 29.2969f, 0.3906f, -3.5156f, -1.1719f,
    -29.2969f, -53.5156f, -34.7656f, 107.4219f, 64.0625f, 25.3906f, 48.8281f, 35.5469f, 33.5938f, 35.5469f, 21.8750f, 3.9063f, 3.5156f, -3.9063f, 0.0000f, 0.0000f
};
/*   An 16-by-8 matrix */
const float GESVWB_AR1[128] =
{
    -1.1719f, -6.2500f, -12.1094f, 0.7813f, -31.6406f, -48.0469f, -88.2813f, -101.5625f, -76.5625f, -47.6563f, -7.8125f, 30.4688f, 69.5313f, 56.6406f, 32.8125f, 17.9688f,
    21.4844f, 16.4063f, 5.8594f, 12.5000f, -18.7500f, -31.6406f, -42.5781f, -53.5156f, -73.0469f, -103.1250f, -128.9063f, -151.1719f, -141.7969f, -68.7500f, -14.8438f, 14.4531f,
    -12.5000f, -27.3438f, -56.2500f, -105.0781f, -131.6406f, -71.4844f, 23.0469f, 22.6563f, 17.1875f, 19.1406f, 16.4063f, 19.9219f, 28.1250f, 19.5313f, 10.1563f, 14.8438f,
    -7.0313f, -22.6563f, -30.8594f, 48.8281f, 137.5000f, 113.6719f, 70.3125f, 46.0938f, 28.1250f, 9.7656f, -8.9844f, -32.0313f, -72.2656f, -65.2344f, -12.8906f, 2.3438f,
    -3.9063f, 52.7344f, 212.5000f, 201.9531f, 201.9531f, 219.1406f, 201.1719f, 206.2500f, 195.3125f, 184.3750f, 161.3281f, 149.6094f, 124.2188f, 85.5469f, 46.0938f, 22.2656f,
    -21.0938f, -109.3750f, -239.8438f, -214.0625f, -203.5156f, -203.9063f, -175.0000f, -187.1094f, -178.5156f, -171.0938f, -147.2656f, -138.6719f, -124.2188f, -105.8594f, -86.7188f, -34.7656f,
    -24.2188f, -37.5000f, -33.5938f, -3.9063f, 40.6250f, 60.5469f, 46.8750f, 43.7500f, 74.2188f, 103.1250f, 113.6719f, 106.2500f, 90.6250f, 64.8438f, 37.1094f, 10.5469f,
    12.8906f, 23.8281f, 60.5469f, 47.2656f, 3.5156f, -10.9375f, 2.3438f, 40.2344f, 25.0000f, 6.6406f, 1.5625f, -0.7813f, -12.1094f, -34.3750f, -81.6406f, -80.4688f
};
/*   An 16-by-8 matrix */
const float GESVWB_AR2[128] =
{
    -57.4219f, -127.3438f, -164.4531f, -35.5469f, -8.5938f, -9.7656f, -5.4688f, -8.2031f, 12.5000f, 29.6875f, 40.6250f, 39.8438f, 25.3906f, 18.3594f, 19.5313f, 16.0156f,
    -15.2344f, -6.2500f, 23.8281f, -5.0781f, -14.8438f, -21.8750f, 18.3594f, 59.7656f, 76.1719f, 83.2031f, 82.8125f, 85.9375f, 95.7031f, 95.7031f, 81.6406f, 33.5938f,
    -13.2813f, -28.5156f, 32.0313f, 151.1719f, 77.7344f, 27.7344f, 21.8750f, -7.0313f, -12.8906f, -21.8750f, -34.3750f, -30.8594f, -1.9531f, 23.0469f, 21.4844f, 11.3281f,
    -2.7344f, -8.2031f, -8.2031f, -61.7188f, -48.0469f, 118.7500f, 88.2813f, 65.6250f, 48.4375f, 3.1250f, -29.2969f, -35.5469f, -21.0938f, -1.9531f, 14.4531f, 11.7188f,
    -10.1563f, -8.5938f, -26.1719f, -87.8906f, 41.7969f, 14.8438f, -32.0313f, -44.1406f, -83.2031f, -80.0781f, -24.2188f, 10.9375f, 34.7656f, 37.1094f, 20.3125f, 6.6406f,
    88.6719f, 157.8125f, 126.9531f, 52.3438f, 17.5781f, -6.2500f, 1.1719f, -5.8594f, -21.4844f, -25.3906f, -21.4844f, -21.0938f, -7.0313f, -3.1250f, 0.3906f, -5.4688f,
    7.4219f, 11.7188f, 4.6875f, 10.9375f, 18.7500f, 5.0781f, 0.7813f, -18.3594f, -14.8438f, 16.0156f, 11.3281f, -3.1250f, -60.1563f, -123.0469f, -160.5469f, -94.5313f,
    3.1250f, 9.3750f, 11.3281f, -23.8281f, -83.9844f, -128.5156f, -92.5781f, -41.4063f, -4.6875f, -4.6875f, -25.0000f, -46.0938f, -65.2344f, -46.4844f, 3.1250f, 20.3125f
};
/*   An 16-by-32 matrix */
const float AUWB2_MA1[512] =
{
    152.7344f, 116.4063f, 69.9219f, -14.4531f, -87.8906f, -151.1719f, -244.9219f, -337.5000f, -475.0000f, -642.1875f, -823.4375f, -314.0625f, -108.2031f, -1.9531f, 47.2656f, 182.8125f,
    137.1094f, 83.2031f, 55.0781f, -29.2969f, -50.7813f, -64.0625f, -129.6875f, -160.1563f, -204.6875f, -223.8281f, -224.6094f, -185.1563f, -129.2969f, -40.2344f, -8.5938f, 78.5156f,
    31.6406f, 341.4063f, 444.1406f, 477.7344f, 485.1563f, 492.9688f, 483.5938f, 462.8906f, 445.7031f, 423.8281f, 387.8906f, 286.3281f, 222.6563f, 165.6250f, 100.0000f, 56.6406f,
    -2.3438f, -9.7656f, -41.0156f, -57.4219f, -127.7344f, -133.5938f, -229.2969f, -242.1875f, -372.6563f, -446.4844f, -733.5938f, -804.2969f, -139.0625f, -39.0625f, 52.3438f, 186.3281f,
    -76.9531f, -197.2656f, -322.6563f, -407.4219f, -337.1094f, -189.4531f, -115.6250f, -40.2344f, -2.3438f, 69.5313f, 105.0781f, 95.7031f, 90.2344f, 125.0000f, 94.9219f, 161.3281f,
    -202.3438f, -236.3281f, 110.1563f, 167.9688f, 207.8125f, 232.8125f, 264.0625f, 292.1875f, 315.6250f, 336.3281f, 325.7813f, 266.0156f, 208.5938f, 194.5313f, 114.4531f, 131.6406f,
    -95.3125f, -219.9219f, -281.2500f, -233.9844f, -195.3125f, -192.9688f, -244.9219f, -288.6719f, -401.5625f, -476.1719f, -116.0156f, 3.5156f, 27.7344f, 106.2500f, 111.3281f, 219.9219f,
    -175.0000f, -333.5938f, -357.8125f, -202.3438f, -112.1094f, -20.3125f, 21.8750f, 95.7031f, 135.5469f, 204.6875f, 217.5781f, 194.1406f, 162.5000f, 176.5625f, 125.3906f, 170.7031f,
    58.5938f, 44.1406f, 10.9375f, -10.1563f, 0.3906f, -31.2500f, -69.1406f, -88.2813f, -75.3906f, -60.9375f, -24.2188f, -88.6719f, -93.7500f, -149.6094f, -208.9844f, -316.0156f,
    -93.7500f, -96.0938f, -67.9688f, -25.7813f, 31.2500f, 58.2031f, 95.3125f, 110.9375f, 161.3281f, 169.5313f, 184.7656f, 61.7188f, 21.8750f, -65.2344f, -127.3438f, -282.4219f,
    51.1719f, -4.2969f, 55.0781f, 12.5000f, 9.3750f, -47.6563f, -155.0781f, -238.2813f, -346.8750f, -317.1875f, 11.7188f, 90.6250f, 119.5313f, 144.9219f, 133.2031f, 174.2188f,
    -61.7188f, -212.8906f, -206.6406f, 58.9844f, 55.4688f, -39.4531f, -166.4063f, -279.6875f, -402.7344f, -577.7344f, -605.4688f, -137.5000f, -51.5625f, 56.6406f, 73.0469f, 201.9531f,
    57.8125f, -40.6250f, -173.8281f, -328.5156f, -12.1094f, 71.4844f, -33.5938f, -123.4375f, -240.2344f, -257.8125f, -90.2344f, 32.8125f, 75.0000f, 107.4219f, 78.5156f, 121.4844f,
    -71.4844f, -85.9375f, -94.9219f, -71.0938f, -92.5781f, -68.7500f, -103.9063f, -91.0156f, -131.2500f, -132.4219f, -253.9063f, -398.0469f, -645.3125f, -330.4688f, -20.3125f, 151.1719f,
    -40.6250f, -45.7031f, -99.2188f, -129.6875f, -74.6094f, 0.3906f, 25.0000f, 71.0938f, 123.8281f, 193.3594f, 244.5313f, 224.2188f, 202.7344f, 198.4375f, 178.1250f, 197.2656f,
    -58.9844f, -92.5781f, 192.1875f, 187.1094f, 106.6406f, 54.2969f, 14.0625f, -23.4375f, -46.4844f, 28.9063f, 67.9688f, 73.4375f, 116.4063f, 142.9688f, 135.5469f, 186.7188f,
    61.7188f, 8.9844f, -82.0313f, -175.7813f, -262.8906f, -248.8281f, -165.2344f, -129.2969f, -51.9531f, 5.4688f, 50.0000f, 26.9531f, 24.2188f, 55.8594f, 66.7969f, 122.2656f,
    195.7031f, 153.9063f, 14.4531f, -22.2656f, 26.1719f, 27.3438f, 17.9688f, 13.6719f, 35.9375f, 46.8750f, 131.6406f, 100.7813f, 107.8125f, 110.5469f, 143.7500f, 195.3125f,
    16.4063f, -61.3281f, -155.4688f, -234.3750f, -289.8438f, -304.6875f, -305.0781f, -382.8125f, -455.4688f, -636.3281f, -378.1250f, -58.2031f, -38.6719f, 73.4375f, 81.6406f, 206.6406f,
    -93.7500f, 74.2188f, 181.6406f, 212.1094f, 224.6094f, 220.7031f, 236.3281f, 232.8125f, 255.0781f, 233.9844f, 227.7344f, 108.9844f, 79.2969f, -19.9219f, -72.6563f, -230.0781f,
    123.4375f, 144.9219f, 162.8906f, 145.3125f, 114.4531f, 73.8281f, 89.8438f, 60.1563f, 71.8750f, 35.5469f, 36.7188f, -68.3594f, -77.3438f, -139.8438f, -177.3438f, -287.5000f,
    28.1250f, -62.1094f, -141.4063f, -194.9219f, -247.2656f, -269.5313f, -310.1563f, -288.6719f, -258.5938f, -178.1250f, -140.6250f, -132.0313f, -98.0469f, -2.3438f, 19.5313f, 135.1563f,
    -78.9063f, -129.6875f, -167.1875f, -180.4688f, -198.4375f, -171.8750f, -215.6250f, -252.7344f, -345.7031f, -475.3906f, -676.9531f, -241.7969f, -63.2813f, 37.1094f, 78.9063f, 199.2188f,
    -35.5469f, -152.7344f, -276.9531f, -345.3125f, -395.3125f, -391.0156f, -365.6250f, -278.9063f, -198.8281f, -77.3438f, 16.4063f, 38.6719f, 46.4844f, 101.9531f, 92.9688f, 193.7500f,
    -144.5313f, 35.9375f, 185.9375f, 235.9375f, 266.0156f, 297.6563f, 322.6563f, 348.8281f, 364.8438f, 391.0156f, 372.6563f, 305.8594f, 245.7031f, 230.4688f, 160.9375f, 182.4219f,
    -75.3906f, -8.5938f, -10.9375f, 17.9688f, 83.5938f, 151.1719f, 196.0938f, 251.1719f, 284.3750f, 337.5000f, 335.5469f, 282.4219f, 226.9531f, 222.2656f, 169.9219f, 188.6719f,
    87.1094f, 113.6719f, 247.2656f, 198.4375f, 136.7188f, 55.0781f, -60.9375f, -185.9375f, -363.2813f, -553.5156f, -706.6406f, -298.4375f, -80.4688f, 30.0781f, 74.6094f, 201.1719f,
    -185.5469f, -308.9844f, -162.8906f, 29.2969f, 78.5156f, 133.9844f, 159.3750f, 214.4531f, 239.0625f, 276.1719f, 267.9688f, 223.4375f, 180.8594f, 178.5156f, 125.3906f, 145.7031f,
    328.9063f, 279.6875f, 261.3281f, 231.6406f, 163.6719f, 165.2344f, 145.7031f, 125.3906f, 106.6406f, 109.3750f, 138.2813f, 84.7656f, 75.3906f, 90.6250f, 68.3594f, 114.8438f,
    45.3125f, -23.4375f, -56.2500f, -116.7969f, -164.4531f, -215.2344f, -285.9375f, -371.8750f, -469.9219f, -649.2188f, -779.6875f, -209.7656f, -93.7500f, 21.4844f, 53.9063f, 189.8438f,
    -126.1719f, -259.7656f, -267.9688f, -83.5938f, -78.5156f, -101.5625f, -145.7031f, -128.5156f, -130.0781f, -64.4531f, 25.7813f, 37.5000f, 68.3594f, 121.0938f, 113.6719f, 189.8438f,
    -7.4219f, 16.7969f, 13.6719f, 15.6250f, 16.4063f, 21.4844f, 24.6094f, 39.4531f, 51.9531f, 75.7813f, 86.7188f, 59.3750f, 45.7031f, 56.6406f, 51.9531f, 83.2031f
};

/*----------------------------------------------------------------------------------*
 * LSF quantization - LSF mode/codebook selection tables
 *----------------------------------------------------------------------------------*/
const short CB[] =
{
    -1,		/* Mode 0 : INACTIVE NB, Safety net          */
    -1,		/* Mode 1 : UNVOICED NB, Safety net          */
    0,		/* Mode 2 : VOICED NB, Safety net            */
    2,		/* Mode 3 : GENERIC NB, Safety net           */
    2,		/* Mode 4 : TRANSITION NB, Safety net        */
    4,		/* Mode 5 : AUDIO NB, Safety net             */
    -1,		/* Mode 6 : INACTIVE WB, Safety net          */
    -1,		/* Mode 7 : UNVOICED WB, Safety net          */
    5,		/* Mode 8 : VOICED WB, Safety net            */
    7,		/* Mode 9 : GENERIC WB, Safety net           */
    7,		/* Mode 10 : TRANSITION WB, Safety net       */
    9,		/* Mode 11 : AUDIO WB, Safety net            */
    -1,		/* Mode 12 : INACTIVE WB16k, Safety net      */
    -1,		/* Mode 13 : UNVOICED WB16k, Safety net      */
    -1,		/* Mode 14 : VOICED WB16k, Safety net        */
    -1,		/* Mode 15 : GENERIC WB 16k, Safety net      */
    10,		/* Mode 16 : TRANSITION WB16k, Safety net    */
    -1,		/* Mode 17 : AUDIO WB16k, Safety net         */
    13		/* Mode 18 : CNG, Safety net                 */
};

const short CB_p[] =
{
    0,			/* Mode 0 : INACTIVE NB, Predictive            */
    1,			/* Mode 1 : UNVOICED NB, Predictive            */
    4,			/* Mode 2 : VOICED NB, Predictive              */
    4,			/* Mode 3 : GENERIC NB, Predictive             */
    -1,			/* Mode 4 : TRANSITION NB, Predictive          */
    -1,			/* Mode 5 : AUDIO NB, Predictive               */
    0,			/* Mode 6 : INACTIVE WB, Predictive            */
    1,			/* Mode 7 : UNVOICED WB, Predictive            */
    6,			/* Mode 8 : VOICED WB, Predictive              */
    6,			/* Mode 9 : GENERIC WB, Predictive             */
    -1,			/* Mode 10 : TRANSITION WB, Predictive         */
    -1,			/* Mode 11 : AUDIO WB, Predictive              */
    0,			/* Mode 12 : INACTIVE WB16k, Predictive        */
    -1,			/* Mode 13 : UNVOICED WB16k, Predictive        */
    -1,			/* Mode 14 : VOICED WB16k, Predictive          */
    8,			/* Mode 15 : GENERIC WB16k, Predictive         */
    -1,			/* Mode 16 : TRANSITION WB16k, Predictive      */
    10,			/* Mode 17 : AUDIO WB16k, Predictive           */
    9,			/* Mode 18 : GENERIC WB, MA Predictive         */
};


const float *const ModeMeans[] = {IANB_Ave, UVNB_Ave, SVNB_Ave, GENB_Ave, TRNB_Ave, AUNB_Ave, IAWB_Ave, UVWB_Ave,
                                  SVWB_Ave, GEWB_Ave, TRWB_Ave, AUWB_Ave, IAWB2_Ave, NULL, SVWB2_Ave, GEWB2_Ave, TRWB2_Ave, AUWB2_Ave
                                 };
const float * const Predictors[] = {Predictor6, NULL, Predictor1, Predictor3, NULL, Predictor6,Predictor5, NULL, Predictor0,
                                    Predictor2, NULL, Predictor5, Predictor7, NULL, Predictor8, Predictor4, NULL, Predictor7
                                   };
const float means_nb_31bits_ma_lsf[16] = {336.3281f , 531.2500f , 886.7188f , 1266.7969f , 1629.2969f , 1973.4375f , 2348.4375f , 2646.8750f , 2998.4375f , 3292.1875f , 3591.4062f , 3806.2500f , 4132.8125f , 4652.7344f , 5250.0000f , 5883.2031f};
const float means_wb_31bits_ma_lsf[16] = {319.5312f , 548.0469f , 934.3750f , 1353.5156f , 1730.0781f , 2120.3125f , 2505.4688f , 2860.5469f , 3243.7500f , 3601.9531f , 3969.5312f , 4332.4219f , 4736.3281f , 5137.8906f , 5562.8906f , 5963.2812f};


const short CBsizes[] =
{
    1,2,4,8,16,32,64
};


const short CBbits[] =
{
    -1,			/* Mode 0 : INACTIVE NB, Safety net            */
    -1,			/* Mode 1 : UNVOICED NB, Safety net            */
    4,			/* Mode 2 : VOICED NB, Safety net              */
    5,			/* Mode 3 : GENERIC NB, Safety net             */
    5,			/* Mode 4 : TRANSITION NB, Safety net          */
    4,			/* Mode 5 : AUDIO NB, Safety net               */
    -1,			/* Mode 6 : INACTIVE WB, Safety net            */
    -1,			/* Mode 7 : UNVOICED WB, Safety net            */
    4,			/* Mode 8 : VOICED WB, Safety net              */
    5,			/* Mode 9 : GENERIC WB, Safety net             */
    5,			/* Mode 10 : TRANSITION WB, Safety net         */
    4,			/* Mode 11 : AUDIO WB, Safety net              */
    -1,			/* Mode 12 : INACTIVE WB16k, Safety net        */
    -1,			/* Mode 13 : UNVOICED WB16k, Safety net        */
    4,			/* Mode 14 : VOICED WB16k, Safety net          */
    -1,			/* Mode 15 : GENERIC WB16k, Safety net         */
    4,			/* Mode 16 : TRANSITION WB16k, Safety net      */
    -1,			/* Mode 17 : AUDIO WB16k, Safety net           */
    4,         /* Mode 18: CNG, Safety net                    */
};


const short CBbits_p[] =
{
    5,			/* Mode 0 : INACTIVE NB, Predictive            */
    4,			/* Mode 1 : UNVOICED NB, Predictive            */
    3,			/* Mode 2 : VOICED NB, Predictive              */
    3,			/* Mode 3 : GENERIC NB, Predictive             */
    -1,			/* Mode 4 : TRANSITION NB, Predictive          */
    0,			/* Mode 5 : AUDIO NB, Predictive               */
    5,			/* Mode 6 : INACTIVE WB, Predictive            */
    4,			/* Mode 7 : UNVOICED WB, Predictive            */
    3,			/* Mode 8 : VOICED WB, Predictive              */
    3,			/* Mode 9 : GENERIC WB, Predictive             */
    -1,			/* Mode 10 : TRANSITION WB, Predictive         */
    0,			/* Mode 11 : AUDIO WB, Predictive              */
    5,			/* Mode 12 : INACTIVE WB16k, Predictive        */
    -1,			/* Mode 13 : UNVOICED WB16k, Predictive        */
    3,			/* Mode 14 : VOICED WB16k, Predictive          */
    5,			/* Mode 15 : GENERIC WB16k, Predictive         */
    -1,			/* Mode 16 : TRANSITION WB16k, Predictive      */
    5,			/* Mode 17 : AUDIO WB16k, Predictive           */
    5,			/* Mode 9 : GENERIC WB, Predictive             */
};



const short BitsVQ[]=
{
    -1,			/* Mode 0 : INACTIVE NB, Safety net            */
    -1,			/* Mode 1 : UNVOICED NB, Safety net            */
    8,			/* Mode 2 : VOICED NB, Safety net              */
    9,			/* Mode 3 : GENERIC NB, Safety net             */
    9,			/* Mode 4 : TRANSITION NB, Safety net          */
    4,			/* Mode 5 : AUDIO NB, Safety net               */
    -1,			/* Mode 6 : INACTIVE WB, Safety net            */
    -1,			/* Mode 7 : UNVOICED WB, Safety net            */
    8,			/* Mode 8 : VOICED WB, Safety net              */
    9,			/* Mode 9 : GENERIC WB, Safety net             */
    9,			/* Mode 10 : TRANSITION WB, Safety net         */
    4,			/* Mode 11 : AUDIO WB, Safety net              */
    -1,			/* Mode 12 : INACTIVE WB16k, Safety net        */
    -1,			/* Mode 13 : UNVOICED WB16k, Safety net        */
    8,			/* Mode 14 : VOICED WB16k, Safety net          */
    -1,			/* Mode 15 : GENERIC WB16k, Safety net         */
    8,			/* Mode 16 : TRANSITION WB16k, Safety net      */
    -1,			/* Mode 17 : AUDIO WB16k, Safety net           */
    4,         /* Mode 18: CNG, Safety net                    */
};


const short BitsVQ_p[]=
{
    5,			/* Mode 0 : INACTIVE NB, Predictive            */
    8,			/* Mode 1 : UNVOICED NB, Predictive            */
    6,			/* Mode 2 : VOICED NB, Predictive              */
    6,			/* Mode 3 : GENERIC NB, Predictive             */
    -1,			/* Mode 4 : TRANSITION NB, Predictive          */
    0,			/* Mode 5 : AUDIO NB, Predictive               */
    5,			/* Mode 6 : INACTIVE WB, Predictive            */
    12,			/* Mode 7 : UNVOICED WB, Predictive            */
    6,			/* Mode 8 : VOICED WB, Predictive              */
    6,			/* Mode 9 : GENERIC WB, Predictive             */
    -1,			/* Mode 10 : TRANSITION WB, Predictive         */
    0,			/* Mode 11 : AUDIO WB, Predictive              */
    5,			/* Mode 12 : INACTIVE WB16k, Predictive        */
    -1,			/* Mode 13 : UNVOICED WB16k, Predictive        */
    6,			/* Mode 14 : VOICED WB16k, Predictive          */
    5,			/* Mode 15 : GENERIC WB16k, Predictive         */
    -1,			/* Mode 16 : TRANSITION WB16k, Predictive      */
    5,			/* Mode 17 : AUDIO WB16k, Predictive           */
    5,			/* Mode 18 : GENERIC WB, MA Predictive          */
};


const short predmode_tab[][6] =
{
    {1,1,2,2,0,2},
    {1,1,2,2,0,2},
    {1,-1,2,1,0,1},
    {1,1,2,1,0,1} /* should check how is the cb for audio mode at 13.2*/
};

const float *const Quantizers[] = {SVNB_SN1, SVNB_SN2, GETRNB_SN1, GETRNB_SN2, AUNB_SN1,SVWB_SN1, SVWB_SN2, GETRWB_SN1,
                                   GETRWB_SN2, AUWB_SN1,TRWB2_SN1, TRWB2_SN2, AUWB2_SN1, CNG_SN1
                                  };
const float *const Quantizers_p[] = {IAA_MA1, UVD_MA1, UVD_MA2, UVWB_MA3, GESVNB_AR1, GESVNB_AR2, GESVWB_AR1, GESVWB_AR2,
                                     GEWB2_MA1,GEWB_MA1, AUWB2_MA1
                                    };

const float vals[NO_LEADERS][MAX_NO_VALS]=
{
    {1.0f, 0.0f, 0.0f, 0.0f},
    {0.5f, 0.0f, 0.0f, 0.0f},
    {1.0f, 0.0f, 0.0f, 0.0f},
    {2.0f, 0.0f, 0.0f, 0.0f},
    {1.5f, 0.5f, 0.0f, 0.0f},
    {1.0f, 0.0f, 0.0f, 0.0f},
    {2.0f, 1.0f, 0.0f, 0.0f},
    {1.5f, 0.5f, 0.0f, 0.0f},
    {1.0f, 0.0f, 0.0f, 0.0f},
    {2.0f, 1.0f, 0.0f, 0.0f},
    {2.0f, 0.0f, 0.0f, 0.0f},
    {1.5f, 0.5f, 0.0f, 0.0f},
    {2.5f, 0.5f, 0.0f, 0.0f},
    {2.0f, 1.0f, 0.0f, 0.0f},
    {2.0f, 1.0f, 0.0f, 0.0f},
    {3.0f, 1.0f, 0.0f, 0.0f},
    {1.5f, 0.5f, 0.0f, 0.0f},
    {2.5f, 1.5f, 0.5f, 0.0f},
    {2.0f, 1.0f, 0.0f, 0.0f},
    {2.0f, 0.0f, 0.0f, 0.0f},
    {3.0f, 1.0f, 0.0f, 0.0f},
    {1.5f, 0.5f, 0.0f, 0.0f},
    {2.5f, 1.5f, 0.5f, 0.0f},
    {2.0f, 1.0f, 0.0f, 0.0f},
    {2.0f, 1.0f, 0.0f, 0.0f},
    {3.0f, 1.0f, 0.0f, 0.0f},
    {3.0f, 2.0f, 1.0f, 0.0f},
    {1.5f, 0.5f, 0.0f, 0.0f},
    {2.5f, 1.5f, 0.5f, 0.0f},
    {2.5f, 0.5f, 0.0f, 0.0f},
    {3.5f, 0.5f, 0.0f, 0.0f},
    {2.0f, 1.0f, 0.0f, 0.0f},
    {2.0f, 0.0f, 0.0f, 0.0f},
    {3.0f, 1.0f, 0.0f, 0.0f},
    {3.0f, 2.0f, 1.0f, 0.0f},
    {4.0f, 0.0f, 0.0f, 0.0f},
    {1.5f, 0.5f, 0.0f, 0.0f},
    {2.5f, 1.5f, 0.5f, 0.0f},
    {2.5f, 1.5f, 0.5f, 0.0f},
    {3.5f, 1.5f, 0.5f, 0.0f},
    {2.0f, 1.0f, 0.0f, 0.0f},
    {3.0f, 2.0f, 1.0f, 0.0f},
    {3.0f, 2.0f, 1.0f, 0.0f},
    {3.0f, 0.0f, 0.0f, 0.0f},
    {4.0f, 1.0f, 0.0f, 0.0f},
    {1.5f, 0.0f, 0.0f, 0.0f},
    {2.5f, 1.5f, 0.5f, 0.0f},
    {2.5f, 1.5f, 0.5f, 0.0f},
    {3.5f, 1.5f, 0.5f, 0.0f}
};

const int no_vals[NO_LEADERS]= {2,1,2,2,2,2,3,2,1,3,2,2,2,3,3,3,2,3,3,2,3,2,3,2,3,3,4,2,3,2,2,3,2,2,4,2,2,3,3,3,3,4,4,2,3,1,3,3,3};

const int no_vals_ind[NO_LEADERS][MAX_NO_VALS]=
{
    {2,6,0,0},
    {8,0,0,0},
    {4,4,0,0},
    {1,7,0,0},
    {1,7,0,0},
    {6,2,0,0},
    {1,2,5,0},
    {2,6,0,0},
    {8,0,0,0},
    {1,4,3,0},
    {2,6,0,0},
    {3,5,0,0},
    {1,7,0,0},
    {1,6,1,0},
    {2,2,4,0},
    {1,1,6,0},
    {4,4,0,0},
    {1,1,6,0},
    {2,4,2,0},
    {3,5,0,0},
    {1,3,4,0},
    {5,3,0,0},
    {1,2,5,0},
    {2,6,0,0},
    {3,2,3,0},
    {1,5,2,0},
    {1,1,1,5},
    {6,2,0,0},
    {1,3,4,0},
    {2,6,0,0},
    {1,7,0,0},
    {3,4,1,0},
    {4,4,0,0},
    {1,7,0,0},
    {1,1,3,3},
    {1,7,0,0},
    {7,1,0,0},
    {1,4,3,0},
    {2,1,5,0},
    {1,1,6,0},
    {4,2,2,0},
    {1,1,5,1},
    {1,2,1,4},
    {2,6,0,0},
    {1,2,5,0},
    {8,0,0,0},
    {1,5,2,0},
    {2,2,4,0},
    {1,2,5,0}
};

const int C[LATTICE_DIM+1][LATTICE_DIM+1]=
{
    {1,0,0,0,0,0,0,0,0},
    {1,1,0,0,0,0,0,0,0},
    {1,2,1,0,0,0,0,0,0},
    {1,3,3,1,0,0,0,0,0},
    {1,4,6,4,1,0,0,0,0},
    {1,5,10,10,5,1,0,0,0},
    {1,6,15,20,15,6,1,0,0},
    {1,7,21,35,35,21,7,1,0},
    {1,8,28,56,70,56,28,8,1}
};

const unsigned int table_no_cv[] = { 0, 112, 240, 1360, 1376, 2400, 4192, 5536, 9120, 9376, 18336, 18448, 25616, 26640, 33808, 40528, 40752,
                                     49712, 56880, 83760, 84208, 88688, 95856, 117360, 124528,   142448,  153200,  155888,  159472,  195312,  198896,  199920,
                                     235760, 236880, 238928, 274768, 274784, 275808, 311648, 333152, 340320, 367200, 410208, 423648,423760, 425104, 425232, 446736, 500496, 522000
                                     ,0
                                   };
const int pi0[] = {28,1,70,8,8,28,168,28,1,280,28,56,8,56,420,56, 70, 56,420, 56, 280, 56, 168, 28, 560, 168,336,28,280,28,8
                   ,280,70, 8, 1120, 8, 8, 280, 168, 56, 420, 336, 840, 28, 168, 1, 168, 420, 168
                  };

const float pl[] =             /* vectors in first layers */
{
    1, 1, 0, 0, 0, 0, 0, 0,                                      /* 112, 4, 28 */
    0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,                      /* 128, 128, 1 */
    1, 1, 1, 1, 0, 0, 0, 0,                                      /* 1120, 16, 70 */
    2, 0, 0, 0, 0, 0, 0, 0,                                      /* 16 , 2, 8 */
    1.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,        /* 5 */ /* 1024,128, 8 */
    1, 1, 1, 1, 1, 1, 0, 0,                                      /* 1792, 64, 28 */
    2, 1, 1, 0, 0, 0, 0, 0,                                      /* 1344, 8, 168 */
    1.5, 1.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,                      /* 3584, 128, 28*/
    1, 1, 1, 1, 1, 1, 1, 1,                                      /*256, 256, 1*/
    2, 1, 1, 1, 1, 0, 0, 0,                /* 10 */ /* 8960, 32, 280 */
    2, 2, 0, 0, 0, 0, 0, 0,                                      /* 112, 4, 28 */
    1.5, 1.5, 1.5, 0.5, 0.5, 0.5, 0.5, 0.5,                      /* 7168, 128, 56 */
    2.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,                      /* 1024, 128, 8*/
    2, 1, 1, 1, 1, 1, 1, 0,                                      /* 7168, 128, 56*/
    2, 2, 1, 1, 0, 0, 0, 0,                /* 15 */ /* 6720, 16, 420 */
    3, 1, 0, 0, 0, 0, 0, 0,                                      /* 224, 4, 56 */
    1.5, 1.5, 1.5, 1.5, 0.5, 0.5, 0.5, 0.5,                      /* 8960, 128, 70 */
    2.5, 1.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,                      /* 7168, 128, 56*/
    2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 0,   0,                        /* 26880, 64, 420 */
    2, 2, 2, 0, 0, 0, 0, 0,                               /*20 */ /* 448, 8, 56 */
    3, 1, 1, 1, 0, 0, 0, 0,                                      /* 4480, 16, 280 */
    1.5, 1.5, 1.5, 1.5, 1.5, 0.5, 0.5, 0.5,              /* 7168, 128, 56 */
    2.5, 1.5, 1.5, 0.5, 0.5, 0.5, 0.5, 0.5,                      /* 21504, 128, 168 */
    2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,                      /* 7168, 256, 28 */
    2.0, 2.0, 2.0, 1.0, 1.0, 0,   0,   0,                 /* 25 */ /* 17920, 32, 560 */
    3.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0,   0,                         /* 10752, 64, 168  */
    3.0, 2.0, 1.0, 0,   0,   0,   0,   0,                         /* 2688, 8, 336  */
    1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 0.5, 0.5,                       /*  3584, 128, 28 */
    2.5, 1.5, 1.5, 1.5, 0.5, 0.5, 0.5, 0.5,                       /* 35840,128,280*/
    2.5, 2.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,             /*30 */   /* 3584, 128, 28*/
    3.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,                       /* 1024,128, 8 */
    2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 0,
    2.0f, 2.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    3.0f, 1.0f,  1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    3.0f, 2.0f,  1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f,
    4.0f, 0.0f,  0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    1.5f, 1.5f,  1.5f, 1.5f, 1.5f, 1.5f, 1.5f, 0.5f,
    2.5f, 1.5f,  1.5f, 1.5f, 1.5f, 0.5f, 0.5f, 0.5f,
    2.5f, 2.5f,  1.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f,
    3.5f, 1.5f,  0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f,
    2.0f, 2.0f,  2.0f, 2.0f, 1.0f, 1.0f, 0.0f, 0.0f,
    3.0f, 2.0f,  1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    3.0f, 2.0f,  2.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    3.0f, 3.0f,  0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    4.0f, 1.0f,  1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    1.5f, 1.5f,  1.5f, 1.5f, 1.5f, 1.5f, 1.5f, 1.5f,
    2.5f, 1.5f,  1.5f, 1.5f, 1.5f, 1.5f, 0.5f, 0.5f,
    2.5f, 2.5f,  1.5f, 1.5f, 0.5f, 0.5f, 0.5f, 0.5f,
    3.5f, 1.5f,  1.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f
};

/*----------------------------------------------------------------------------------*
 * LSF quantization for CNG
 *----------------------------------------------------------------------------------*/

const short cng_sort[] = {/*5f */1,1,0,1,0,0, /* 4f */0,1,0,1,0,0,1,1,1,1};

const short perm[][4] =
{
    /* 5f*/
    {6,11,7,15},
    {6,15,-1,0},
    {5,8,7,15},
    {7,10,-1,0},
    {-1,0,0,0},
    {-1,0,0,0},
    /* 4f */
    {-1,0,0,0},
    {0,9,7,10},
    {-1,0,0,0},
    {7,15,-1,0},
    {-1,0,0,0},
    {-1,0,0,0},
    {6,10,7,11},
    {6,11,7,12},
    {6,11,7,12},
    {6,11,7,12}
};

const int pl_par[] =           /* 1 if even number of signs */
{
    0,  1, 0, 0, -1, 0, 0,  1,  0, 0,
    0, -1, 1, 0,  0, 0, 1, -1,  0, 0,
    0, -1, 1, 0,  0, 0, 0,  1, -1, 1, -1, 0,
    0, 0, 0, 0, -1, 1, -1, 1, 0, 0, 0, 0, 0, 1, -1, 1, -1
};

const float scales[][MAX_NO_SCALES*2]= /* 2 subvectors */
{
    {1.528f, 0.000f, 0.000f, 1.532f, 0.000f, 0.000f, }, /* 14 */
    {1.605f, 0.000f, 0.000f, 1.532f, 0.000f, 0.000f, }, /* 15 */
    {1.275f, 2.458f, 0.000f, 1.532f, 0.000f, 0.000f, }, /* 18 */
    {1.275f, 2.458f, 0.000f, 1.631f, 0.000f, 0.000f, }, /* 19 */
    {1.057f, 1.794f, 2.896f, 1.154f, 1.860f, 3.067f, }, /* 25 */
    {0.927f, 1.458f, 2.317f, 1.033f, 1.791f, 3.440f, }, /* 28*/ /* mode 0 UV WB*/
    {1.284f, 2.676f, 0.000f, 1.451f, 0.000f, 0.000f, },
    {1.368f, 0.000f, 0.000f, 1.401f, 2.477f, 0.000f, }, /* 19 */
    {0.861f, 1.243f, 1.818f, 1.228f, 2.226f, 10.307f, }, /* 24 */
    {1.072f, 1.934f, 3.633f, 1.221f, 2.938f, 10.723f, }, /* 25 */
    {0.899f, 1.417f, 0.677f, 1.033f, 1.837f, 10.893f, }, /* 29 */
    {0.830f, 1.323f, 0.629f, 0.911f, 1.585f, 10.088f, }, /* 32 */ /* mode 1 UV NB*/
    {1.573f, 0.000f, 0.000f, 1.656f, 0.000f, 0.000f, }, /* 17 */
    {1.239f, 2.404f, 0.000f, 1.556f, 0.000f, 0.000f, }, /* 18 */
    {1.055f, 1.700f, 4.439f, 1.656f, 0.000f, 0.000f, }, /* 21 */
    {1.250f, 2.404f, 4.132f, 1.355f, 2.361f, 0.000f, }, /* 22 */
    {1.056f, 1.785f, 4.523f, 1.318f, 2.586f, 0.000f, }, /* 25 */
    {0.996f, 1.505f, 3.355f, 1.185f, 1.776f, 2.728f, },
    {0.929f, 1.387f, 3.357f, 1.080f, 1.701f, 2.885f, },
    {0.922f, 1.493f, 3.369f, 1.080f, 1.701f, 2.885f, },
    {0.922f, 1.493f, 3.369f, 1.066f, 1.694f, 3.135f, },
    {0.922f, 1.493f, 3.369f, 0.962f, 1.550f, 3.946f, }, /* 30 */
    {0.746f, 1.108f, 2.869f, 0.959f, 1.481f, 3.907f, }, /* 32 */
    {0.770f, 1.194f, 2.823f, 0.907f, 1.402f, 2.116f, },
    {0.748f, 1.103f, 2.866f, 1.182f, 0.811f, 3.332f, },/* 34*/
    {0.677f, 0.963f, 2.127f, 0.726f, 1.082f, 2.204f, }, /* 37*/ /* mode 2 V WB*/
    {1.639f, 0.000f, 0.000f, 1.218f, 2.161f, 0.000f, }, /* 17 */
    {1.286f, 2.446f, 0.000f, 1.410f, 0.000f, 0.000f, }, /* 18 */
    {1.086f, 1.728f, 3.758f, 1.218f, 2.161f, 0.000f, }, /* 22 */
    {1.035f, 1.575f, 4.815f, 1.218f, 2.161f, 0.000f, }, /* 23 */
    {0.964f, 1.533f, 4.942f, 1.218f, 2.161f, 0.000f, }, /* 24 */
    {0.841f, 1.198f, 1.982f, 1.218f, 2.161f, 0.000f, }, /* 25 */
    {0.898f, 1.298f, 2.184f, 1.216f, 2.664f, 0.000f, }, /* 27 */
    {0.841f, 1.237f, 2.237f, 0.995f, 1.657f, 2.836f, }, /* 29 */
    {0.697f, 0.981f, 2.043f, 0.935f, 1.505f, 0.659f, }, /* 34 */
    {0.669f, 0.909f, 1.328f, 0.985f, 0.654f, 1.911f, }, /* 37 */ /* mode 3 V NB*/
    {1.212f, 1.897f, 0.000f, 0.000f, 0.000f, 0.000f, },  /* 12 (11.883) */
    {1.634f, 0.000f, 0.000f, 1.669f, 0.000f, 0.000f, },  /* 16 (15.826) */
    {1.288f, 2.423f, 0.000f, 1.669f, 0.000f, 0.000f, },  /* 19 (18.572) */
    {1.212f, 1.897f, 0.000f, 1.669f, 0.000f, 0.000f, },  /* 20 (19.796) */
    {1.083f, 1.766f, 3.175f, 1.669f, 0.000f, 0.000f, },  /* 21 (20.910) */
    {1.037f, 1.609f, 4.228f, 1.669f, 0.000f, 0.000f, },  /* 22 (21.776) */
    {1.095f, 1.659f, 2.716f, 1.315f, 2.506f, 0.000f, },  /* 23 (22.959) */
    {0.941f, 1.386f, 2.221f, 1.315f, 2.506f, 0.000f, },  /* 25 (24.992) */
    {0.908f, 1.306f, 1.901f, 1.320f, 2.623f, 0.000f, },  /* 26 (25.904) */
    {1.075f, 1.767f, 0.790f, 1.320f, 2.623f, 0.000f, },  /* 27 (26.829) */
    {1.022f, 1.531f, 0.759f, 1.110f, 1.755f, 2.594f, },  /* 28 (27.989) */
    {1.075f, 1.767f, 0.790f, 1.093f, 1.902f, 3.014f, },  /* 29 (28.984) */
    {0.893f, 1.472f, 0.675f, 1.103f, 1.770f, 2.842f, },  /* 30 (29.980) */
    {0.910f, 1.548f, 0.685f, 1.032f, 1.651f, 2.513f, },  /* 31 (30.966) */
    {0.826f, 1.256f, 0.632f, 0.981f, 1.542f, 2.217f, },  /* 32 (31.995) */ /* G WB*/
    {1.184f, 1.810f, 2.761f, 0.000f, 0.000f, 0.000f, },  /* 12 (11.925) */
    {1.611f, 0.000f, 0.000f, 1.618f, 0.000f, 0.000f, },  /* 16 (15.826) */
    {1.184f, 1.810f, 2.761f, 1.550f, 0.000f, 0.000f, },  /* 19 (18.745) */
    {1.184f, 1.810f, 2.761f, 1.618f, 0.000f, 0.000f, },  /* 20 (19.838) */
    {1.063f, 1.737f, 2.985f, 1.618f, 0.000f, 0.000f, },  /* 21 (20.910) */
    {1.078f, 1.825f, 3.162f, 1.469f, 2.249f, 0.000f, },  /* 22 (21.985) */
    {1.375f, 0.915f, 2.082f, 1.469f, 2.249f, 0.000f, },  /* 23 (22.815) */
    {0.960f, 1.423f, 0.700f, 1.310f, 2.132f, 0.000f, },  /* 25 (24.996) */
    {1.124f, 0.794f, 1.902f, 1.283f, 2.302f, 0.000f, },  /* 26 (25.993) */
    {1.077f, 1.727f, 0.767f, 1.250f, 1.951f, 2.981f, },  /* 27 (26.954) */
    {0.933f, 1.471f, 0.685f, 1.250f, 1.951f, 2.981f, },  /* 28 (27.992) */
    {0.927f, 1.600f, 0.674f, 1.154f, 1.776f, 2.854f, },  /* 29 (28.996) */
    {1.047f, 0.722f, 1.785f, 1.056f, 1.642f, 2.701f, },  /* 30 (29.988) */
    {0.971f, 0.688f, 1.509f, 1.043f, 1.730f, 2.931f, },  /* 31 (30.962) */
    {0.919f, 0.662f, 1.367f, 1.057f, 1.808f, 3.069f, },  /* 32 (31.987) */ /* G NB*/

    {1.617f, 0.000f, 0.000f, 1.657f, 0.000f, 0.000f, }, /* 17 */
    {1.275f, 2.298f, 0.000f, 1.563f, 0.000f, 0.000f, }, /* 18 */
    {1.308f, 2.354f, 0.000f, 1.387f, 0.000f, 0.000f, }, /* 21 */
    {1.291f, 2.418f, 0.000f, 1.355f, 2.443f, 0.000f, }, /* 22 */
    {1.079f, 1.769f, 3.012f, 1.387f, 0.000f, 0.000f, }, /* 24 */
    {1.079f, 1.769f, 3.012f, 1.325f, 2.555f, 0.000f, }, /* 25 */
    {0.897f, 1.340f, 2.604f, 1.070f, 1.689f, 2.527f, }, /* 28 */
    {0.897f, 1.340f, 2.604f, 0.939f, 1.454f, 2.083f, }, /* 30 */
    {0.905f, 1.327f, 2.599f, 1.109f, 0.777f, 1.705f, },
    {0.762f, 1.101f, 2.359f, 0.939f, 1.454f, 2.083f, },
    {0.794f, 1.226f, 3.180f, 1.109f, 0.777f, 1.705f, }, /* 33 */ /* mode 6 T WB */
    {1.629f, 0.000f, 0.000f, 1.191f, 2.211f, 0.000f, }, /* 17 */
    {1.277f, 2.557f, 0.000f, 1.367f, 0.000f, 0.000f, }, /* 18 */
    {1.082f, 1.761f, 3.929f, 1.191f, 2.211f, 0.000f, }, /* 22 */
    {1.018f, 1.535f, 2.808f, 1.191f, 2.211f, 0.000f, }, /* 23 */
    {0.944f, 1.477f, 2.763f, 1.191f, 2.211f, 0.000f, }, /* 24 */
    {0.910f, 1.744f, 3.317f, 1.191f, 2.211f, 0.000f, }, /* 25 */
    {0.920f, 1.648f, 3.068f, 0.969f, 1.683f, 3.953f, }, /* 28 */
    {0.739f, 1.111f, 2.694f, 0.879f, 1.411f, 2.305f, }, /* 31 */
    {0.709f, 1.032f, 2.717f, 0.810f, 1.245f, 1.824f, }, /* 32*/ /* mode 7 T NB*/
    {0.758f, 1.116f, 1.964f, 2.021f, 0.798f, 1.219f, }, /* 31 */
    {0.699f, 1.034f, 1.978f, 2.021f, 0.798f, 1.219f, }, /* 32 */ /* mode 8 G 16k */
    {0.726f, 1.050f, 1.845f, 1.355f, 0.860f, 2.205f, },  /* 32 (31.998) */
    {0.677f, 0.997f, 1.669f, 1.355f, 0.860f, 2.205f, },  /* 33 (32.983) */
    {1.646f, 0.000f, 0.000f, 1.254f, 2.459f, 0.000f, }, /* 17 */
    {1.073f, 1.863f, 3.231f, 1.678f, 0.000f, 0.000f, }, /* 21 */
    {1.073f, 1.863f, 3.231f, 1.254f, 2.459f, 0.000f, }, /* 22 */
    {0.951f, 1.492f, 2.496f, 1.255f, 2.971f, 0.000f, }, /* 25 */
    {1.148f, 1.841f, 0.813f, 1.255f, 2.971f, 0.000f, }, /* 26 */
    {0.602f, 0.869f, 1.418f, 1.264f, 0.764f, 2.218f}, /* 36 */ /* mode 10 AUDIO_WB LVQ bitrate 15-36 + 4 + 1*/
    {0.853f, 1.769f, 4.425f, 1.000f, 1.000f, 1.000f}, /* 17 */
    {1.011f, 1.663f, 4.403f, 1.578f, 0.000f, 0.000f}, /* 21 */
    {1.011f, 1.663f, 4.403f, 1.202f, 2.424f, 0.000f}, /* 22 */
    {0.881f, 1.618f, 4.136f, 1.202f, 2.424f, 0.000f}, /* 25 */
    {0.847f, 1.791f, 4.466f, 1.202f, 2.424f, 0.000f}, /* 26 */
    {0.670f, 1.112f, 2.389f, 1.202f, 2.424f, 0.000f}, /* 28 */ /* mode 11 AUDIO_NB */
    {1.131f, 1.815f, 0.796f, 1.265f, 2.794f, 0.000f, }, /* 26 */
    {0.570f, 0.804f, 1.197f, 1.162f, 1.949f, 0.728f, }, /* 36*/ /* mode 12 AUDIO_WB 16k bitrate 15-36 + 4 + 1*/
    {1.045f, 1.586f, 3.754f, 1.669f, 0.000f, 0.000f, },  /* 22 (21.776) */
    {0.880f, 1.280f, 2.824f, 1.099f, 1.735f, 0.000f, },  /* 28 (27.994) */
    {0.831f, 1.215f, 2.927f, 1.089f, 1.708f, 2.479f, },  /* 29 (28.996) */
    {0.870f, 1.327f, 2.906f, 1.066f, 1.719f, 2.676f, },  /* 30 (29.991) */
    {0.772f, 1.122f, 2.351f, 1.446f, 0.944f, 2.072f, },  /* 32 (31.992) */
    {0.701f, 0.977f, 1.738f, 0.947f, 1.453f, 2.082f, },  /* 33 (32.993) */
    {0.719f, 1.021f, 1.701f, 1.119f, 0.794f, 1.696f, },  /* 34 (33.968) */
    {0.640f, 0.884f, 1.732f, 0.755f, 1.090f, 1.548f, },  /* 37 (36.995) */ /* VOICED 16k */
    /* 5sf */
    {1.218f, 0.796f, 2.283f, 1.290f, 3.325f, 0.000f, },  /* 25 (24.980) */
    {1.590f, 0.835f, 4.436f, 1.097f, 3.070f, 0.000f, },  /* 25 (24.974) */
    {0.994f, 2.617f, 0.000f, 1.091f, 2.233f, 3.457f, },  /* 25 (24.852) */
    {0.887f, 1.573f, 3.543f, 1.088f, 1.827f, 3.067f, },  /* 25 (24.994) */
    {0.837f, 1.238f, 1.903f, 1.298f, 2.797f, 0.000f, },  /* 25 (24.996) */
    {1.138f, 2.826f, 0.000f, 1.106f, 2.796f, 4.391f, },  /* 25 (24.671) */

    /* 4sf */
    {0.941f, 1.931f, 4.473f, 0.681f, 1.266f, 2.328f, },  /* 25 (24.936) */
    {1.352f, 4.332f, 0.000f, 0.820f, 1.545f, 4.175f, },  /* 25 (24.955) */
    {1.343f, 3.607f, 0.000f, 0.859f, 1.453f, 2.590f, },  /* 25 (24.853) */
    {1.208f, 2.740f, 0.000f, 0.759f, 1.240f, 2.182f, },  /* 25 (24.881) */
    {1.123f, 2.736f, 0.000f, 0.874f, 1.498f, 2.586f, },  /* 25 (24.939) */
    {0.919f, 2.471f, 0.000f, 0.615f, 1.072f, 2.096f, },  /* 25 (24.996) */
    {1.548f, 4.508f, 0.000f, 0.825f, 2.178f, 4.305f, },  /* 25 (24.310) */
    {1.217f, 2.898f, 0.000f, 0.737f, 1.217f, 1.930f, },  /* 25 (24.955) */
    {0.976f, 2.190f, 5.716f, 1.506f, 0.642f, 4.211f, },  /* 25 (24.984) */
    {1.107f, 2.595f, 0.000f, 1.302f, 0.604f, 0.880f, },  /* 25 (24.866) */
};

const float scales_p[][MAX_NO_SCALES*2]= /* 2 subvectors 20 modes */
{
    {1.464f, 2.374f, 0.000f, 0.000f, 0.000f, 0.000f, },  /*  9 (8.464) */
    {1.265f, 2.564f, 0.000f, 1.638f, 0.000f, 0.000f, },  /* 19 (18.572) */
    {1.063f, 1.703f, 2.805f, 1.294f, 2.353f, 0.000f, },  /* 23 (22.959) */
    {1.063f, 1.917f, 3.063f, 1.365f, 0.000f, 0.000f, },  /* 24 (23.949) */
    {0.914f, 1.412f, 2.223f, 1.294f, 2.353f, 0.000f, },  /* 25 (24.992) */
    {0.882f, 1.401f, 2.402f, 1.313f, 2.441f, 0.000f, },  /* 27 (26.902) */
    {1.356f, 0.867f, 2.377f, 1.070f, 1.686f, 2.546f, },  /* 28 (27.996) */
    {0.846f, 1.348f, 2.546f, 1.076f, 1.742f, 2.658f, },  /* 29 (28.937) */
    {0.845f, 1.379f, 2.566f, 1.019f, 1.577f, 2.443f, },  /* 30 (29.954) */
    {0.756f, 1.189f, 2.799f, 1.084f, 1.804f, 2.758f, },  /* 31 (30.978) */
    {0.755f, 1.218f, 2.821f, 0.944f, 1.433f, 1.973f, },  /* 32 (31.978) */
    {0.724f, 1.235f, 2.942f, 1.255f, 0.848f, 2.000f, },  /* 34 (33.975) */
    {0.687f, 1.113f, 2.338f, 0.853f, 1.328f, 1.944f, },  /* 35 (34.975) */
    {0.648f, 1.029f, 1.836f, 0.854f, 1.356f, 1.961f, },  /* 36 (35.889) */
    {0.648f, 1.029f, 1.836f, 0.687f, 1.058f, 1.900f, },  /* 39 (38.488) */ /* V WB*/
    {1.613f, 0.000f, 0.000f, 0.000f, 0.000f, 0.000f, },  /*  8 (7.913) */
    {1.267f, 2.475f, 0.000f, 1.619f, 0.000f, 0.000f, },  /* 19 (18.572) */
    {1.014f, 1.630f, 2.464f, 1.285f, 2.151f, 0.000f, },  /* 23 (22.773) */
    {0.893f, 1.390f, 2.314f, 1.465f, 2.299f, 0.000f, },  /* 24 (23.999) */
    {0.930f, 1.401f, 2.150f, 1.280f, 2.254f, 0.000f, },  /* 25 (24.992) */
    {0.893f, 1.390f, 2.314f, 1.276f, 2.206f, 2.984f, },  /* 27 (26.962) */
    {0.893f, 1.390f, 2.314f, 1.036f, 1.646f, 2.471f, },  /* 28 (27.835) */
    {0.857f, 1.337f, 2.464f, 1.043f, 1.730f, 2.625f, },  /* 29 (28.937) */
    {0.765f, 1.219f, 1.553f, 1.036f, 1.646f, 2.471f, },  /* 30 (29.969) */
    {0.789f, 1.328f, 1.652f, 1.052f, 1.784f, 2.706f, },  /* 31 (30.952) */
    {0.764f, 1.224f, 1.555f, 0.920f, 1.443f, 2.035f, },  /* 32 (31.978) */
    {0.663f, 1.061f, 1.238f, 1.379f, 0.898f, 1.951f, },  /* 34 (33.992) */
    {0.673f, 1.104f, 1.306f, 1.259f, 0.828f, 1.954f, },  /* 35 (35.000) */
    {0.666f, 1.071f, 1.249f, 0.803f, 1.241f, 1.729f, },  /* 36 (35.980) */
    {0.658f, 1.039f, 1.214f, 0.950f, 0.651f, 1.429f, },  /* 39 (38.512) */ /* V NB*/

    {1.600f, 0.000f, 0.000f, 1.553f, 0.000f, 0.000f, },  /* 15 (14.733) */
    {1.134f, 1.986f, 3.295f, 1.553f, 0.000f, 0.000f, },  /* 19 (18.745) */
    {0.987f, 1.788f, 2.659f, 1.647f, 0.000f, 0.000f, },  /* 22 (21.776) */
    {0.899f, 1.602f, 2.579f, 1.647f, 0.000f, 0.000f, },  /* 23 (22.791) */
    {0.797f, 1.294f, 2.140f, 1.647f, 0.000f, 0.000f, },  /* 24 (23.999) */
    {0.797f, 1.294f, 2.140f, 1.335f, 2.225f, 0.000f, },  /* 25 (24.996) */
    {0.741f, 1.151f, 1.816f, 1.335f, 2.225f, 0.000f, },  /* 26 (25.934) */
    {0.797f, 1.294f, 2.140f, 1.186f, 1.932f, 0.000f, },  /* 28 (27.969) */
    {0.741f, 1.151f, 1.816f, 1.164f, 1.823f, 2.769f, },  /* 29 (28.996) */
    {0.708f, 1.126f, 1.953f, 1.076f, 1.730f, 2.777f, },  /* 30 (29.988) */
    {0.660f, 1.049f, 1.571f, 1.076f, 1.730f, 2.777f, },  /* 31 (30.931) */
    {0.662f, 1.026f, 1.554f, 1.074f, 1.913f, 3.022f, },  /* 32 (31.987) */
    {0.660f, 1.049f, 1.571f, 1.439f, 0.926f, 2.131f, },  /* 33 (32.982) */
    {0.630f, 0.966f, 1.522f, 1.312f, 0.881f, 2.207f, },  /* 34 (33.967) */
    {0.617f, 0.921f, 1.447f, 1.032f, 1.549f, 0.756f, },  /* 35 (34.994) */ /* G WB*/

    {1.595f, 0.000f, 0.000f, 1.502f, 0.000f, 0.000f, },  /* 15 (14.733) */
    {1.123f, 1.946f, 3.732f, 1.502f, 0.000f, 0.000f, },  /* 19 (18.792) */
    {1.033f, 2.075f, 4.339f, 1.419f, 2.446f, 0.000f, },  /* 22 (21.985) */
    {0.985f, 1.793f, 5.965f, 1.281f, 2.324f, 0.000f, },  /* 23 (22.773) */
    {0.881f, 1.606f, 6.995f, 1.419f, 2.446f, 0.000f, },  /* 24 (23.932) */
    {0.844f, 1.582f, 7.020f, 1.281f, 2.324f, 0.000f, },  /* 25 (24.955) */
    {0.789f, 1.520f, 7.203f, 1.281f, 2.324f, 0.000f, },  /* 26 (25.991) */
    {0.869f, 1.547f, 6.995f, 1.030f, 1.754f, 3.102f, },  /* 28 (27.979) */
    {0.817f, 1.492f, 7.120f, 1.030f, 1.754f, 3.102f, },  /* 29 (28.878) */
    {0.755f, 1.382f, 7.133f, 1.030f, 1.754f, 3.102f, },  /* 30 (29.954) */
    {0.706f, 1.315f, 7.225f, 1.030f, 1.754f, 3.102f, },  /* 31 (30.893) */
    {0.689f, 1.296f, 7.290f, 1.016f, 1.875f, 3.239f, },  /* 32 (31.963) */
    {0.698f, 1.275f, 7.209f, 0.914f, 1.548f, 2.433f, },  /* 33 (32.997) */
    {0.679f, 1.315f, 7.290f, 1.229f, 1.845f, 0.813f, },  /* 34 (33.986) */
    {0.679f, 1.315f, 7.290f, 1.188f, 0.772f, 1.955f, },  /* 35 (34.952) */ /* G NB*/


    {1.011f, 1.777f, 2.760f, 1.614f, 0.000f, 0.000f, }, /* 21 */
    {0.853f, 1.382f, 2.066f, 1.245f, 2.679f, 0.000f, }, /* 25 */
    { 1.207f, 0.778f, 2.208f, 1.245f, 2.679f, 0.000f, }, /* 26 */
    { 1.207f, 0.778f, 2.208f, 1.013f, 1.832f, 3.053f, }, /* 29 */
    {1.207f, 0.778f, 2.208f, 1.420f, 0.872f, 2.330f, }, /* 30 */
    {0.525f, 0.770f, 1.073f, 0.815f, 1.237f, 0.567f,}, /* 40 */ /* mode 7 AUDIO_WB 19-40 + 0 + 1 */
    {1.070f, 1.791f, 3.903f, 1.599f, 0.000f, 0.000f}, /* 21 */
    {0.820f, 1.217f, 2.089f, 1.255f, 2.290f, 0.000f}, /* 25 */
    {0.780f, 1.169f, 2.495f, 1.255f, 2.290f, 0.000f}, /* 26 */
    {1.075f, 0.723f, 2.361f, 1.110f, 1.961f, 3.491f}, /* 30 */
    {0.691f, 1.029f, 2.337f, 1.034f, 1.791f, 4.004f}, /* 31 */
    {0.671f, 1.076f, 2.606f, 0.955f, 1.547f, 2.514f}, /* 32 */ /*mode 8 AUDIO_NB  */
    {1.184f, 0.776f, 2.117f, 1.057f, 1.670f, 0.674f,}, /* 30 */
    {0.521f, 0.747f, 1.033f, 0.796f, 1.333f, 0.542f,}, /* 40 */ /* mode 9 AUDIO_WB 16k 19-40+ 0 + 1*/
    {1.679f, 0.000f, 0.000f, 1.282f, 2.471f, 0.000f, },  /* 17 (16.823) */
    {1.088f, 1.849f, 3.195f, 1.687f, 0.000f, 0.000f, },  /* 21 (20.910) */
    {1.088f, 1.849f, 3.195f, 1.282f, 2.471f, 0.000f, },  /* 22 (21.907) */
    {1.126f, 1.689f, 0.790f, 1.282f, 2.471f, 0.000f, },  /* 25 (24.863) */
    {0.930f, 1.382f, 0.682f, 1.282f, 2.471f, 0.000f, },  /* 26 (25.921) */
    {1.115f, 0.794f, 1.852f, 1.281f, 3.033f, 0.000f, },  /* 27 (26.837) */
    {0.840f, 1.376f, 0.623f, 0.800f, 1.416f, 4.260f, },  /* 36 (35.998) */ /* INACTIVE NB */

    {0.801f, 1.148f, 1.802f, 0.000f, 0.000f, 0.000f, },  /* 17 (16.932) */
    {1.089f, 1.812f, 3.172f, 1.677f, 0.000f, 0.000f, },  /* 21 (20.910) */
    {1.089f, 1.904f, 3.221f, 1.521f, 2.635f, 0.000f, },  /* 22 (21.985) */
    {0.845f, 1.212f, 1.934f, 1.313f, 2.419f, 0.000f, },  /* 25 (24.845) */
    {0.779f, 1.095f, 1.700f, 1.313f, 2.419f, 0.000f, },  /* 26 (25.999) */
    {0.723f, 1.015f, 1.664f, 1.313f, 2.419f, 0.000f, },  /* 27 (26.981) */
    {0.893f, 0.652f, 1.438f, 1.076f, 0.720f, 1.794f, },  /* 36 (35.929) */ /* INACTIVE WB*/

    {1.359f, 2.306f, 0.000f, 1.669f, 0.000f, 0.000f, },  /* 17 (16.823) */
    {1.077f, 1.927f, 3.546f, 1.669f, 0.000f, 0.000f, },  /* 21 (20.910) */
    {1.077f, 2.032f, 3.578f, 1.429f, 2.711f, 0.000f, },  /* 22 (21.985) */
    {0.833f, 1.253f, 2.105f, 1.283f, 2.556f, 0.000f, },  /* 25 (24.845) */
    {0.776f, 1.152f, 1.858f, 1.283f, 2.556f, 0.000f, },  /* 26 (25.934) */
    {0.719f, 1.066f, 1.732f, 1.283f, 2.556f, 0.000f, },  /* 27 (26.914) */
    {0.941f, 0.651f, 1.565f, 0.722f, 1.190f, 1.940f, },  /* 36 (35.915) */  /* INACTIVE 16k*/

    {1.292f, 2.479f, 0.000f, 1.541f, 0.000f, 0.000f, },  /* 18 (17.479) */
    {1.202f, 1.903f, 0.000f, 1.541f, 0.000f, 0.000f, },  /* 19 (18.703) */
    {1.028f, 1.641f, 2.455f, 1.648f, 0.000f, 0.000f, },  /* 22 (21.776) */
    {1.247f, 0.878f, 2.329f, 1.648f, 0.000f, 0.000f, },  /* 23 (22.791) */
    {0.863f, 1.358f, 2.522f, 1.648f, 0.000f, 0.000f, },  /* 24 (23.999) */
    {0.817f, 1.222f, 2.010f, 1.074f, 1.785f, 2.733f, },  /* 29 (28.966) */
    {0.815f, 0.612f, 1.281f, 1.055f, 1.724f, 2.952f, },  /* 32 (31.990) */ /* UNVOICED NB */
    {1.545f, 0.000f, 0.000f, 1.548f, 0.000f, 0.000f, },  /* 14 (13.640) */
    {1.640f, 0.000f, 0.000f, 1.548f, 0.000f, 0.000f, },  /* 15 (14.733) */
    {1.287f, 2.749f, 0.000f, 1.548f, 0.000f, 0.000f, },  /* 18 (17.479) */
    {1.287f, 2.749f, 0.000f, 1.654f, 0.000f, 0.000f, },  /* 19 (18.572) */
    {1.190f, 2.026f, 0.000f, 1.654f, 0.000f, 0.000f, },  /* 20 (19.796) */
    {0.931f, 1.458f, 2.450f, 1.294f, 2.742f, 0.000f, },  /* 25 (24.992) */
    {0.877f, 1.396f, 2.737f, 1.081f, 1.816f, 3.360f, },  /* 28 (27.996) */ /* UNVOICED WB*/

    {1.131f, 1.636f, 0.000f, 1.371f, 0.000f, 0.000f, },  /* 24 (23.818) */
    {0.934f, 1.277f, 0.728f,1.157f, 1.697f, 0.000f, },  /* 30 (29.992) */
    {0.833f, 1.162f, 0.658f,1.151f, 1.687f, 0.000f, },  /* 31 (30.998) */
    {0.751f, 1.032f, 0.598f,1.151f, 1.687f, 0.000f, },  /* 32 (31.987) */
    {0.709f, 1.005f, 0.570f, 1.060f, 1.772f, 2.719f, },  /* 34 (33.994) */
    {0.746f, 1.001f, 0.601f,1.004f, 1.803f, 2.892f, },  /* 35 (35.000) */
    {0.743f, 1.000f, 0.599f,0.936f, 1.861f, 2.874f, },  /* 36 (35.994) */
    {0.775f, 0.614f, 1.037f, 0.796f, 1.304f, 1.905f, },  /* 39 (38.301) */ /* VOICED 16k */
    {0.894f, 1.339f, 2.549f, 1.308f, 2.601f, 0.000f, },  /* 26 (25.917) */
    {0.720f, 1.012f, 1.598f, 1.512f, 0.926f, 2.137f, },  /* 32 (31.980) */
    {0.681f, 0.973f, 1.649f, 1.381f, 0.876f, 2.129f, },  /* 33 (32.990) */
    {0.684f, 0.964f, 1.640f, 1.168f, 1.776f, 0.787f, },  /* 34 (33.974) */
    {0.668f, 0.935f, 1.551f, 1.016f, 1.518f, 0.712f, },  /* 35 (34.989) */
    {0.659f, 0.911f, 1.425f, 1.337f, 0.889f, 0.642f, },  /* 36 (35.988) */
    {0.659f, 0.911f, 1.425f, 0.839f, 1.287f, 0.607f, },  /* 37 (36.989) */ /* GENERIC 16k*/
    {1.633f, 0.000f, 0.000f, 1.687f, 0.000f, 0.000f, },  /* 16 (15.826) */
    {1.076f, 1.790f, 2.942f, 1.687f, 0.000f, 0.000f, },  /* 21 (20.910) */
    {0.834f, 1.229f, 1.890f, 1.687f, 0.000f, 0.000f, },  /* 24 (23.999) */
    {0.938f, 1.404f, 2.153f, 1.306f, 2.630f, 0.000f, },  /* 25 (24.992) */
    {1.340f, 0.886f, 2.320f, 1.306f, 2.630f, 0.000f, },  /* 26 (25.917) */
    {0.833f, 1.250f, 1.908f, 1.306f, 2.630f, 0.000f, },  /* 27 (26.883) */
    {0.833f, 1.213f, 1.873f, 1.125f, 1.839f, 2.819f, },  /* 28 (27.901) */
    {0.765f, 1.162f, 1.690f, 1.024f, 1.738f, 2.838f, },  /* 30 (29.916) */
    {0.725f, 1.050f, 1.791f, 1.480f, 0.922f, 3.104f, },  /* 31 (30.993) */
    {0.712f, 1.012f, 1.549f, 1.494f, 0.903f, 3.364f, },  /* 32 (31.980) */
    {0.659f, 0.927f, 1.357f, 1.494f, 0.903f, 3.364f, },  /* 33 (32.958) */
    {0.822f, 0.614f, 1.288f, 0.910f, 1.509f, 2.255f, },  /* 34 (33.987) */
    {0.841f, 0.624f, 1.278f, 1.161f, 0.762f, 1.808f, },  /* 35 (34.994) */
    {0.838f, 0.622f, 1.266f, 1.080f, 0.711f, 1.710f, },  /* 36 (35.968) */
    {0.832f, 0.619f, 1.275f, 0.938f, 1.430f, 0.644f, },  /* 37 (36.971) */ /* GENERIC 12.8k MA*/

    {0.884f, 1.349f, 2.570f, 1.314f, 2.609f, 0.000f, },  /* 26 (25.917) */
    {0.711f, 1.018f, 1.615f, 1.482f, 0.921f, 3.431f, },  /* 32 (31.980) */
    {0.679f, 0.974f, 1.659f, 0.948f, 1.549f, 3.448f, },  /* 33 (32.995) */
    {0.831f, 0.618f, 1.481f, 0.933f, 1.514f, 2.310f, },  /* 34 (33.993) */
    {0.816f, 0.610f, 1.402f, 1.426f, 0.877f, 2.265f, },  /* 35 (34.992) */
    {0.787f, 1.257f, 0.596f, 0.859f, 1.447f, 2.431f, },  /* 36 (35.997) */
    {0.787f, 1.257f, 0.596f, 1.106f, 0.735f, 1.659f, },  /* 37 (36.961) */ /* AUDIO 16k */
};

/*   An 16-by-34 matrix in Scale = 20.48f */
const float sigma[][16] =
{
    { 1.0f }, /* IA NB */
    { 1.0f }, /* UV NB */
    {41.8457031f, 43.9453125f, 62.5976563f, 72.3632813f, 78.7597656f, 82.4707031f, 85.4492188f, 86.5722656f, 86.6210938f, 84.9121094f, 85.2050781f, 105.5664063f, 127.8320313f, 68.6523438f, 25.7324219f, 16.9433594f },  /* V NB */
    {48.9257813f, 50.5859375f, 71.0449219f, 72.4609375f, 74.5117188f, 77.8808594f, 79.5898438f, 80.8105469f, 79.9804688f, 74.5117188f, 70.0683594f, 88.7207031f, 119.1406250f, 102.0019531f, 37.1093750f, 25.0976563f },  /* G NB */
    {48.2421875f, 48.0468750f, 68.7500000f, 76.9531250f, 80.9570313f, 85.1562500f, 89.0625000f, 91.8457031f, 90.4296875f, 85.2050781f, 81.5917969f, 106.2988281f, 133.6425781f, 84.3750000f, 34.7656250f, 26.6113281f },  /* T NB */
    {85.5957031f, 82.9101563f, 99.5605469f, 105.9570313f, 106.6406250f, 106.8847656f, 101.6601563f, 99.5605469f, 97.7050781f, 97.0703125f, 97.1191406f, 117.8710938f, 128.1738281f, 153.9550781f, 33.1542969f, 14.5996094f },/* AU NB*/
    { 1.0f },
    { 1.0f }, /* UV WB*/
    {44.2382813f, 52.1972656f, 85.7910156f, 98.6816406f, 101.7089844f, 107.2753906f, 106.9824219f, 112.0605469f, 118.8476563f, 126.3183594f, 125.4882813f, 126.8554688f, 136.3281250f, 136.7675781f, 146.9726563f, 129.7851563f },  /* V WB  */
    {61.8164063f, 69.8730469f, 94.6289063f, 97.0214844f, 96.0449219f, 101.3671875f, 100.5371094f, 104.3945313f, 108.5937500f, 106.9824219f, 107.9101563f, 112.8417969f, 120.7519531f, 120.6542969f, 122.0214844f, 119.6289063f },   /* G WB  */
    {56.8847656f, 56.9335938f, 86.7187500f, 100.1953125f, 101.9042969f, 108.5449219f, 113.4765625f, 117.9199219f, 124.1699219f, 122.1679688f, 126.3183594f, 137.4023438f, 153.9550781f, 158.8867188f, 161.9140625f, 155.9570313f }, /* T WB  */
    {84.8632813f, 88.6230469f, 112.0605469f, 118.3593750f, 123.3886719f, 121.0937500f, 115.4785156f, 118.7011719f, 118.5058594f, 119.0429688f, 123.9257813f, 127.6855469f, 138.5742188f, 125.2441406f, 118.9941406f, 109.0332031f },/* AU WB */
    { 1.0f },
    { 1.0f },
    {75.2441406f, 84.3261719f, 110.6933594f, 125.0000000f, 134.0332031f, 140.3808594f, 146.6308594f, 159.5214844f, 161.3281250f, 173.9746094f, 186.9628906f, 190.9667969f, 196.2402344f, 181.9335938f, 177.9785156f, 187.2070313f },  /* VO 16k */
    {89.6972656f, 92.9687500f, 122.0703125f, 129.0527344f, 130.4687500f, 128.3691406f, 132.5683594f, 139.2578125f, 137.9882813f, 139.9902344f, 152.8320313f, 157.3730469f, 172.4121094f, 179.4433594f, 147.9980469f, 194.1894531f },  /* G  16k */
    {90.3320313f, 108.3496094f, 118.7500000f, 125.7324219f, 135.7421875f, 137.9882813f, 143.0175781f, 145.1660156f, 145.8007813f, 155.1757813f, 171.2402344f, 176.1230469f, 165.4785156f, 161.3769531f, 148.6816406f, 174.4140625f }, /* T  16k */
    {103.1250000f, 112.3046875f, 142.3339844f, 150.6347656f, 150.0488281f, 145.8496094f, 149.3164063f, 145.8496094f, 153.5156250f, 157.3242188f, 175.0000000f, 170.9960938f, 157.4707031f, 168.1152344f, 156.5917969f, 229.0527344f },/* AU 16k */
    {87.5488281f, 116.4062500f, 102.3925781f, 103.1738281f, 100.8789063f, 95.2636719f, 101.7578125f, 110.5468750f, 122.2167969f, 115.2343750f, 107.2753906f, 108.8378906f, 101.7089844f, 111.5722656f, 111.6699219f, 155.9570313f },
    {160.5957031f, 122.6074219f, 117.4804688f, 129.7363281f, 130.9570313f, 133.8378906f, 139.1601563f, 159.9121094f, 168.0664063f, 161.3281250f, 141.9433594f, 142.1386719f, 132.0312500f, 129.8828125f, 122.9980469f, 160.9863281f },
    {53.2226563f, 105.1757813f, 133.9355469f, 143.3593750f, 158.2031250f, 168.1640625f, 160.5957031f, 164.4042969f, 173.4863281f, 182.0800781f, 170.0683594f, 165.3320313f, 128.1738281f, 96.5332031f, 91.9433594f, 93.7988281f },
    {69.5312500f, 169.0429688f, 118.9453125f, 104.6875000f, 100.7812500f, 98.3398438f, 98.8281250f, 95.9472656f, 97.8027344f, 97.6562500f, 95.8496094f, 99.8046875f, 94.3847656f, 106.5917969f, 117.1386719f, 144.7265625f },
    {136.1816406f, 130.5175781f, 130.9082031f, 133.3007813f, 131.3476563f, 129.1992188f, 133.8867188f, 166.1621094f, 197.0703125f, 281.9824219f, 305.7617188f, 255.8105469f, 392.7734375f, 336.6699219f, 135.2050781f, 96.7773438f },
    {123.0957031f, 119.6777344f, 126.3183594f, 119.5800781f, 117.3339844f, 108.4472656f, 107.9101563f, 112.2070313f, 148.2910156f, 153.9550781f, 127.6367188f, 129.9316406f, 132.5683594f, 149.3164063f, 144.6777344f, 244.6289063f },
    {92.3339844f, 97.5097656f, 94.0917969f, 90.2832031f, 94.1894531f, 95.8007813f, 92.8710938f, 86.4746094f, 83.8867188f, 74.1699219f, 70.8984375f, 69.3847656f, 71.5332031f, 167.2851563f, 71.8750000f, 21.5820313f },
    {44.0429688f, 73.9257813f, 140.6738281f, 121.8750000f, 129.5410156f, 127.3437500f, 115.7226563f, 104.8339844f, 106.2500000f, 110.0097656f, 125.0000000f, 107.5195313f, 85.6445313f, 79.2968750f, 69.9218750f, 55.9570313f },
    {106.4453125f, 99.4140625f, 95.6542969f, 92.7246094f, 94.3359375f, 92.0898438f, 83.6914063f, 84.7167969f, 87.1582031f, 101.6113281f, 91.1621094f, 75.3417969f, 73.0957031f, 71.5332031f, 68.0175781f, 63.7207031f },
    {43.3105469f, 125.5371094f, 107.4707031f, 85.4003906f, 83.1542969f, 80.7617188f, 78.8574219f, 80.0781250f, 80.1269531f, 88.0859375f, 93.2128906f, 81.3964844f, 74.8535156f, 73.0957031f, 65.8203125f, 59.3750000f },
    {149.6093750f, 127.3925781f, 117.1875000f, 111.9628906f, 113.4277344f, 113.8671875f, 107.8125000f, 97.9492188f, 100.7324219f, 113.5253906f, 167.9687500f, 203.4667969f, 154.9804688f, 119.1894531f, 107.1289063f, 104.8828125f },
    {59.5214844f, 86.2792969f, 106.0058594f, 113.7207031f, 134.4726563f, 120.9960938f, 120.4589844f, 100.4882813f, 98.5839844f, 100.0488281f, 132.3730469f, 191.8457031f, 194.7753906f, 77.8320313f, 70.0195313f, 41.9433594f },
    {88.2812500f, 92.3828125f, 92.1386719f, 93.5546875f, 97.6074219f, 92.7734375f, 89.0625000f, 87.2070313f, 88.8671875f, 94.1406250f, 121.5820313f, 121.9238281f, 116.7968750f, 122.1191406f, 164.5996094f, 140.4296875f },
    {86.2792969f, 92.8710938f, 83.5937500f, 86.0839844f, 95.8984375f, 95.2148438f, 90.5273438f, 86.5234375f, 82.1289063f, 81.3964844f, 77.9785156f, 89.4042969f, 143.7011719f, 168.3593750f, 41.5039063f, 27.6855469f },
    {97.1679688f, 101.0253906f, 104.3945313f, 110.4003906f, 108.7890625f, 107.4707031f, 97.8515625f, 92.6757813f, 79.1503906f, 81.6406250f, 77.1972656f, 108.8867188f, 212.2070313f, 198.8281250f, 47.4609375f, 35.3515625f },
    {74.8535156f, 97.3632813f, 100.1464844f, 91.6992188f, 90.3808594f, 89.6484375f, 83.2031250f, 84.0820313f, 81.9335938f, 96.4355469f, 110.9863281f, 92.6757813f, 83.4960938f, 82.1289063f, 77.8808594f, 70.8984375f}
};

/*   An 16-by-34 matrix in Scale = 20.48f */
const float inv_sigma[][16] =
{
    {1.0f }, /* IA NB */
    {1.0f }, /* UV NB */
    {0.0238973f, 0.0227556f, 0.0159750f, 0.0138192f, 0.0126968f, 0.0121255f, 0.0117029f, 0.0115510f, 0.0115445f, 0.0117769f, 0.0117364f, 0.0094727f, 0.0078228f, 0.0145661f, 0.0388615f, 0.0590202f }, /* V NB  */
    {0.0204391f, 0.0197683f, 0.0140756f, 0.0138005f, 0.0134207f, 0.0128401f, 0.0125644f, 0.0123746f, 0.0125031f, 0.0134207f, 0.0142718f, 0.0112713f, 0.0083934f, 0.0098037f, 0.0269474f, 0.0398444f }, /* G NB  */
    {0.0207287f, 0.0208130f, 0.0145455f, 0.0129949f, 0.0123522f, 0.0117431f, 0.0112281f, 0.0108878f, 0.0110583f, 0.0117364f, 0.0122561f, 0.0094074f, 0.0074826f, 0.0118519f, 0.0287640f, 0.0375780f }, /* T NB  */
    {0.0116828f, 0.0120612f, 0.0100441f, 0.0094378f, 0.0093773f, 0.0093559f, 0.0098367f, 0.0100441f, 0.0102349f, 0.0103018f, 0.0102966f, 0.0084838f, 0.0078019f, 0.0064954f, 0.0301620f, 0.0684950f }, /* AU NB */
    {1.0f },
    {1.0f }, /* UV WB */
    {0.0226049f, 0.0191581f, 0.0116562f, 0.0101336f, 0.0098320f, 0.0093218f, 0.0093473f, 0.0089237f, 0.0084141f, 0.0079165f, 0.0079689f, 0.0078830f, 0.0073352f, 0.0073117f, 0.0068040f, 0.0077050f }, /* V WB  */
    {0.0161769f, 0.0143117f, 0.0105676f, 0.0103070f, 0.0104118f, 0.0098651f, 0.0099466f, 0.0095790f, 0.0092086f, 0.0093473f, 0.0092670f, 0.0088620f, 0.0082814f, 0.0082881f, 0.0081953f, 0.0083592f }, /* G WB  */
    {0.0175794f, 0.0175643f, 0.0115315f, 0.0099805f, 0.0098131f, 0.0092128f, 0.0088124f, 0.0084803f, 0.0080535f, 0.0081855f, 0.0079165f, 0.0072779f, 0.0064954f, 0.0062938f, 0.0061761f, 0.0064120f }, /* T WB  */
    {0.0117837f, 0.0112837f, 0.0089237f, 0.0084488f, 0.0081045f, 0.0082581f, 0.0086596f, 0.0084245f, 0.0084384f, 0.0084003f, 0.0080693f, 0.0078317f, 0.0072163f, 0.0079844f, 0.0084038f, 0.0091715f }, /* AU WB */
    {1.0f },
    {1.0f },
    {0.0132901f, 0.0118587f, 0.0090340f, 0.0080000f, 0.0074608f, 0.0071235f, 0.0068198f, 0.0062687f, 0.0061985f, 0.0057480f, 0.0053487f, 0.0052365f, 0.0050958f, 0.0054965f, 0.0056187f, 0.0053417f }, /* V 16k  */
    {0.0111486f, 0.0107563f, 0.0081920f, 0.0077488f, 0.0076647f, 0.0077900f, 0.0075433f, 0.0071809f, 0.0072470f, 0.0071434f, 0.0065431f, 0.0063543f, 0.0058001f, 0.0055728f, 0.0067568f, 0.0051496f }, /* G 16k  */
    {0.0110703f, 0.0092294f, 0.0084211f, 0.0079534f, 0.0073669f, 0.0072470f, 0.0069921f, 0.0068887f, 0.0068587f, 0.0064443f, 0.0058397f, 0.0056778f, 0.0060431f, 0.0061967f, 0.0067258f, 0.0057335f }, /* T 16k  */
    {0.0096970f, 0.0089043f, 0.0070257f, 0.0066386f, 0.0066645f, 0.0068564f, 0.0066972f, 0.0068564f, 0.0065140f, 0.0063563f, 0.0057143f, 0.0058481f, 0.0063504f, 0.0059483f, 0.0063860f, 0.0043658f }, /* AU 16k */
    {0.0114222f, 0.0085906f, 0.0097663f, 0.0096924f, 0.0099129f, 0.0104972f, 0.0098273f, 0.0090459f, 0.0081822f, 0.0086780f, 0.0093218f, 0.0091880f, 0.0098320f, 0.0089628f, 0.0089550f, 0.0064120f },
    {0.0062268f, 0.0081561f, 0.0085121f, 0.0077079f, 0.0076361f, 0.0074717f, 0.0071860f, 0.0062534f, 0.0059500f, 0.0061985f, 0.0070451f, 0.0070354f, 0.0075740f, 0.0076992f, 0.0081302f, 0.0062117f },
    {0.0187890f, 0.0095079f, 0.0074663f, 0.0069755f, 0.0063210f, 0.0059466f, 0.0062268f, 0.0060826f, 0.0057641f, 0.0054921f, 0.0058800f, 0.0060484f, 0.0078019f, 0.0103591f, 0.0108763f, 0.0106611f },
    {0.0143820f, 0.0059157f, 0.0084072f, 0.0095522f, 0.0099225f, 0.0101688f, 0.0101186f, 0.0104224f, 0.0102247f, 0.0102400f, 0.0104330f, 0.0100196f, 0.0105949f, 0.0093816f, 0.0085369f, 0.0069096f },
    {0.0073431f, 0.0076618f, 0.0076389f, 0.0075018f, 0.0076134f, 0.0077400f, 0.0074690f, 0.0060182f, 0.0050743f, 0.0035463f, 0.0032705f, 0.0039091f, 0.0025460f, 0.0029703f, 0.0073962f, 0.0103330f },
    {0.0081238f, 0.0083558f, 0.0079165f, 0.0083626f, 0.0085227f, 0.0092211f, 0.0092670f, 0.0089121f, 0.0067435f, 0.0064954f, 0.0078347f, 0.0076964f, 0.0075433f, 0.0066972f, 0.0069119f, 0.0040878f },
    {0.0108302f, 0.0102554f, 0.0106279f, 0.0110763f, 0.0106169f, 0.0104383f, 0.0107676f, 0.0115641f, 0.0119208f, 0.0134826f, 0.0141047f, 0.0144124f, 0.0139795f, 0.0059778f, 0.0139130f, 0.0463348f },
    {0.0227051f, 0.0135271f, 0.0071086f, 0.0082051f, 0.0077196f, 0.0078528f, 0.0086414f, 0.0095389f, 0.0094118f, 0.0090901f, 0.0080000f, 0.0093006f, 0.0116762f, 0.0126108f, 0.0143017f, 0.0178709f },
    {0.0093945f, 0.0100589f, 0.0104543f, 0.0107846f, 0.0106004f, 0.0108590f, 0.0119487f, 0.0118040f, 0.0114734f, 0.0098414f, 0.0109695f, 0.0132728f, 0.0136807f, 0.0139795f, 0.0147021f, 0.0156935f },
    {0.0230891f, 0.0079658f, 0.0093049f, 0.0117095f, 0.0120258f, 0.0123821f, 0.0126811f, 0.0124878f, 0.0124802f, 0.0113525f, 0.0107281f, 0.0122855f, 0.0133594f, 0.0136807f, 0.0151929f, 0.0168421f },
    {0.0066841f, 0.0078498f, 0.0085333f, 0.0089315f, 0.0088162f, 0.0087822f, 0.0092754f, 0.0102094f, 0.0099273f, 0.0088086f, 0.0059535f, 0.0049148f, 0.0064524f, 0.0083900f, 0.0093345f, 0.0095345f },
    {0.0168007f, 0.0115903f, 0.0094334f, 0.0087935f, 0.0074365f, 0.0082647f, 0.0083016f, 0.0099514f, 0.0101436f, 0.0099951f, 0.0075544f, 0.0052125f, 0.0051341f, 0.0128482f, 0.0142817f, 0.0238417f },
    {0.0113274f, 0.0108245f, 0.0108532f, 0.0106889f, 0.0102451f, 0.0107789f, 0.0112281f, 0.0114670f, 0.0112527f, 0.0106224f, 0.0082249f, 0.0082018f, 0.0085619f, 0.0081887f, 0.0060753f, 0.0071210f },
    {0.0115903f, 0.0107676f, 0.0119626f, 0.0116166f, 0.0104277f, 0.0105026f, 0.0110464f, 0.0115576f, 0.0121760f, 0.0122855f, 0.0128240f, 0.0111851f, 0.0069589f, 0.0059397f, 0.0240941f, 0.0361199f },
    {0.0102915f, 0.0098985f, 0.0095790f, 0.0090579f, 0.0091921f, 0.0093049f, 0.0102196f, 0.0107903f, 0.0126342f, 0.0122488f, 0.0129538f, 0.0091839f, 0.0047124f, 0.0050295f, 0.0210700f, 0.0282873f },
    {0.0133594f, 0.0102708f, 0.0099854f, 0.0109052f, 0.0110643f, 0.0111547f, 0.0120188f, 0.0118931f, 0.0122050f, 0.0103696f, 0.0090101f, 0.0107903f, 0.0119766f, 0.0121760f, 0.0128401f, 0.0141047f}
};

/*   An 16-by-19 matrix in Scale = 20.48f */
const float sigma_p[][16] =
{
    {59.3261719f, 63.9160156f, 69.7753906f, 66.3574219f, 67.3339844f, 68.5546875f, 66.6015625f, 66.0156250f, 66.0156250f, 67.9687500f, 68.2617188f, 84.3261719f, 96.5820313f, 118.6523438f, 44.0917969f, 43.1152344f }, /* IA NB */
    {51.2207031f, 66.6015625f, 69.3847656f, 68.6035156f, 67.9199219f, 69.6289063f, 69.6777344f, 69.5800781f, 52.5878906f, 64.9902344f, 65.3808594f, 68.7500000f, 71.4355469f, 77.0507813f, 77.9296875f, 80.3222656f },  /* U NB  */
    {32.7148438f, 34.9121094f, 47.0703125f, 55.6152344f, 60.1562500f, 68.3105469f, 71.8261719f, 72.7539063f, 73.8281250f, 70.8984375f, 69.4335938f, 77.1972656f, 95.8007813f, 74.3164063f, 20.8984375f, 10.9375000f },  /* V NB  */
    {53.8085938f, 61.3281250f, 78.1738281f, 75.8789063f, 73.7792969f, 81.3964844f, 80.7128906f, 80.5664063f, 83.6914063f, 77.0996094f, 72.5097656f, 86.6210938f, 121.6796875f, 117.7734375f, 40.0390625f, 16.8945313f },/* G NB  */
    {1.0f }, /* T NB */
    {57.0312500f, 64.5996094f, 71.4355469f, 75.8789063f, 77.0507813f, 79.0039063f, 74.5117188f, 74.2187500f, 72.9492188f, 72.8515625f, 66.9433594f, 73.9257813f, 109.6191406f, 121.5332031f, 23.7792969f, 13.3789063f },  /* AU NB */
    {55.4687500f, 65.6738281f, 71.8261719f, 71.6308594f, 73.0468750f, 74.3164063f, 73.0957031f, 73.4863281f, 73.8769531f, 75.2441406f, 78.0761719f, 82.6171875f, 90.1367188f, 95.8496094f, 66.0644531f, 68.9941406f },    /* IA WB */
    {67.9687500f, 64.0625000f, 65.8203125f, 76.9531250f, 117.1875000f, 145.5078125f, 77.6855469f, 23.2421875f, 81.0546875f, 81.1035156f, 81.4453125f, 85.0585938f, 90.0878906f, 95.8984375f, 92.3828125f, 90.7226563f },  /* U WB  */
    {35.6933594f, 39.4042969f, 57.3242188f, 64.6484375f, 68.0175781f, 76.2695313f, 80.7128906f, 82.0800781f, 85.1562500f, 89.6484375f, 89.9414063f, 95.3613281f, 104.7363281f, 106.0546875f, 105.2734375f, 97.8515625f }, /* V WB  */
    {61.4257813f, 75.1464844f, 88.4277344f, 82.1777344f, 82.4218750f, 89.1601563f, 89.2578125f, 94.1894531f, 95.5566406f, 95.9472656f, 97.0703125f, 102.6367188f, 107.2265625f, 107.3730469f, 105.4199219f, 98.1933594f },/* G WB  */
    {1.0f },/* T WB */
    {51.1230469f, 62.5976563f, 71.5820313f, 75.5371094f, 78.9550781f, 79.9804688f, 79.4433594f, 82.9101563f, 82.6171875f, 83.1054688f, 84.8632813f, 86.1328125f, 89.5996094f, 83.6914063f, 79.3945313f, 78.2226563f },    /* AU WB  */
    {72.9980469f, 86.2792969f, 90.0878906f, 89.5996094f, 92.4316406f, 90.5273438f, 90.5273438f, 92.1386719f, 97.3632813f, 101.3671875f, 111.7675781f, 110.8398438f, 97.5585938f, 93.1640625f, 92.8710938f, 115.7226563f },/* IA 16k */
    {1.0f },/* U 16k */
    {54.4921875f, 67.4804688f, 94.1406250f, 125.0000000f, 122.8027344f, 123.0957031f, 118.5546875f, 115.0878906f, 128.5644531f, 140.3808594f, 144.2382813f, 139.4042969f, 151.4160156f, 138.1347656f, 140.3808594f, 154.7851563f },  /* V 16k */
    {96.8261719f, 117.3339844f, 132.5683594f, 134.4726563f, 140.7226563f, 136.8652344f, 141.6992188f, 141.1132813f, 143.8964844f, 152.6367188f, 168.5058594f, 169.1406250f, 158.4960938f, 156.1523438f, 147.4609375f, 182.4707031f },/* G 16k */
    {1.0f },/* T 16k */
    {55.1269531f, 70.3613281f, 83.1054688f, 87.2070313f, 90.5273438f, 91.4550781f, 94.7265625f, 93.6035156f, 97.6074219f, 98.7304688f, 104.6875000f, 99.6582031f, 95.6054688f, 91.6503906f, 88.4765625f, 78.2226563f, },/* NOT USED ! AU 16k */
    {69.5312500f, 80.1757813f, 101.3183594f, 100.9277344f, 106.4941406f, 111.1816406f, 107.6171875f, 112.9882813f, 116.6992188f, 117.1875000f, 120.9472656f, 125.0976563f, 130.7617188f, 128.7109375f, 123.3886719f, 104.9316406f} /* G WB for MA*/
};
/*   An 16-by-19 matrix in Scale = 20.48f */
const float inv_sigma_p[][16] =
{
    {0.0168560f, 0.0156455f, 0.0143317f, 0.0150699f, 0.0148513f, 0.0145869f, 0.0150147f, 0.0151479f, 0.0151479f, 0.0147126f, 0.0146495f, 0.0118587f, 0.0103539f, 0.0084280f, 0.0226800f, 0.0231937f }, /* IA NB */
    {0.0195234f, 0.0150147f, 0.0144124f, 0.0145765f, 0.0147232f, 0.0143619f, 0.0143518f, 0.0143719f, 0.0190158f, 0.0153869f, 0.0152950f, 0.0145455f, 0.0139986f, 0.0129785f, 0.0128321f, 0.0124498f }, /* U NB  */
    {0.0305672f, 0.0286434f, 0.0212448f, 0.0179807f, 0.0166234f, 0.0146390f, 0.0139225f, 0.0137450f, 0.0135450f, 0.0141047f, 0.0144023f, 0.0129538f, 0.0104383f, 0.0134560f, 0.0478505f, 0.0914286f }, /* V NB  */
    {0.0185844f, 0.0163057f, 0.0127920f, 0.0131789f, 0.0135539f, 0.0122855f, 0.0123896f, 0.0124121f, 0.0119487f, 0.0129702f, 0.0137912f, 0.0115445f, 0.0082183f, 0.0084909f, 0.0249756f, 0.0591908f }, /* G NB  */
    {1.0f }, /* T NB */
    {0.0175342f, 0.0154800f, 0.0139986f, 0.0131789f, 0.0129785f, 0.0126576f, 0.0134207f, 0.0134737f, 0.0137082f, 0.0137265f, 0.0149380f, 0.0135271f, 0.0091225f, 0.0082282f, 0.0420534f, 0.0747445f }, /* AU NB */
    {0.0180282f, 0.0152268f, 0.0139225f, 0.0139605f, 0.0136898f, 0.0134560f, 0.0136807f, 0.0136080f, 0.0135360f, 0.0132901f, 0.0128080f, 0.0121040f, 0.0110943f, 0.0104330f, 0.0151367f, 0.0144940f }, /* IA WB */
    {0.0147126f, 0.0156098f, 0.0151929f, 0.0129949f, 0.0085333f, 0.0068725f, 0.0128724f, 0.0430252f, 0.0123373f, 0.0123299f, 0.0122782f, 0.0117566f, 0.0111003f, 0.0104277f, 0.0108245f, 0.0110226f }, /* U WB  */
    {0.0280164f, 0.0253779f, 0.0174446f, 0.0154683f, 0.0147021f, 0.0131114f, 0.0123896f, 0.0121832f, 0.0117431f, 0.0111547f, 0.0111183f, 0.0104864f, 0.0095478f, 0.0094291f, 0.0094991f, 0.0102196f }, /* V WB  */
    {0.0162798f, 0.0133073f, 0.0113087f, 0.0121687f, 0.0121327f, 0.0112158f, 0.0112035f, 0.0106169f, 0.0104650f, 0.0104224f, 0.0103018f, 0.0097431f, 0.0093260f, 0.0093133f, 0.0094859f, 0.0101840f }, /* G WB  */
    {1.0f }, /* T WB */
    {0.0195606f, 0.0159750f, 0.0139700f, 0.0132385f, 0.0126654f, 0.0125031f, 0.0125876f, 0.0120612f, 0.0121040f, 0.0120329f, 0.0117837f, 0.0116100f, 0.0111608f, 0.0119487f, 0.0125953f, 0.0127840f }, /* AU WB */
    {0.0136990f, 0.0115903f, 0.0111003f, 0.0111608f, 0.0108188f, 0.0110464f, 0.0110464f, 0.0108532f, 0.0102708f, 0.0098651f, 0.0089471f, 0.0090220f, 0.0102503f, 0.0107338f, 0.0107676f, 0.0086414f }, /* IA 16k*/
    {1.0f }, /* U 16k */
    {0.0183513f, 0.0148191f, 0.0106224f, 0.0080000f, 0.0081431f, 0.0081238f, 0.0084349f, 0.0086890f, 0.0077782f, 0.0071235f, 0.0069330f, 0.0071734f, 0.0066043f, 0.0072393f, 0.0071235f, 0.0064606f }, /* V 16k */
    {0.0103278f, 0.0085227f, 0.0075433f, 0.0074365f, 0.0071062f, 0.0073065f, 0.0070572f, 0.0070865f, 0.0069494f, 0.0065515f, 0.0059345f, 0.0059122f, 0.0063093f, 0.0064040f, 0.0067815f, 0.0054803f }, /* G 16k */
    {1.0f }, /* T 16k */
    {0.0181399f, 0.0142124f, 0.0120329f, 0.0114670f, 0.0110464f, 0.0109343f, 0.0105567f, 0.0106834f, 0.0102451f, 0.0101286f, 0.0095522f, 0.0100343f, 0.0104597f, 0.0109110f, 0.0113024f, 0.0127840f },/* NOT USED ! AU 16k */
    {0.0143820f, 0.0124726f, 0.0098699f, 0.0099081f, 0.0093902f, 0.0089943f, 0.0092922f, 0.0088505f, 0.0085690f, 0.0085333f, 0.0082681f, 0.0079938f, 0.0076475f, 0.0077693f, 0.0081045f, 0.0095300f}  /* G WB for MA*/
};
const int no_lead[][MAX_NO_SCALES*2] =
{
    {   1,    0,    0,    1,    0,    0, }, /* 14 */
    {   2,    0,    0,    1,    0,    0, }, /* 15 */
    {   4,    2,    0,    1,    0,    0, }, /* 18 */
    {   4,    2,    0,    2,    0,    0, }, /* 19 */
    {   7,    5,    2,    5,    4,    2, }, /* 25 */
    {   8,    8,    3,    8,    6,    2, }, /* 28 */ /* mode 0 UV WB*/
    {   4,    2,    0,    1,    0,    0, }, /* 18 */
    {   4,    0,    0,    2,    1,    0, }, /* 19 */
    {   9,    8,    8,    2,    2,    1, }, /* 24 */
    {   8,    5,    2,    5,    2,    1, }, /* 25 */
    {  18,   16,    8,    5,    5,    1, }, /* 29 */
    {  24,   21,   10,    8,    8,    2, }, /* 32 */ /* mode 1  UV NB*/
    {   2,    0,    0,    2,    0,    0, }, /* 17 */
    {   4,    2,    0,    1,    0,    0, }, /* 18 */
    {   7,    5,    2,    2,    0,    0, }, /* 21 */
    {   5,    2,    1,    4,    1,    0, }, /* 22 */
    {   8,    5,    2,    5,    2,    0, }, /* 25 */
    {   8,    7,    4,    5,    3,    2, },
    {   8,    8,    4,    6,    5,    2, },
    {  13,    8,    5,    6,    5,    2, },
    {  13,    8,    5,    8,    6,    2, },
    {  13,    8,    5,   11,    8,    2, }, /* 30 */
    {  24,   21,    8,    9,    8,    2, }, /* 32 */
    {  23,   18,    8,   13,   11,    3, },
    {  23,   21,    8,   17,   13,    4, }, /* 34 */
    {  31,   31,   17,   26,   25,    9, }, /* 37 */ /* mode 2 V WB*/
    {   2,    0,    0,    2,    2,    0, }, /* 17 */
    {   4,    2,    0,    1,    0,    0, }, /* 18 */
    {   7,    5,    2,    2,    2,    0, }, /* 22 */
    {   8,    7,    2,    2,    2,    0, }, /* 23 */
    {  11,    8,    2,    2,    2,    0, }, /* 24 */
    {  13,   13,    9,    2,    2,    0, }, /* 25 */
    {  13,   11,    7,    5,    2,    0, }, /* 27 */
    {  18,   14,    9,    5,    5,    2, }, /* 29 */
    {  31,   31,   14,   11,   11,    5, }, /* 34 */
    {  31,   31,   27,   24,   21,   14, }, /* 37 */ /* mode 3 V NB */
    {   5,    4,    0,    0,    0,    0, },  /* 12 (11.883) */
    {   2,    0,    0,    2,    0,    0, },  /* 16 (15.826) */
    {   4,    2,    0,    2,    0,    0, },  /* 19 (18.572) */
    {   5,    4,    0,    2,    0,    0, },  /* 20 (19.796) */
    {   7,    5,    2,    2,    0,    0, },  /* 21 (20.910) */
    {   8,    7,    2,    2,    0,    0, },  /* 22 (21.776) */
    {   5,    5,    2,    4,    2,    0, },  /* 23 (22.959) */
    {   8,    8,    5,    4,    2,    0, },  /* 25 (24.992) */
    {   8,    8,    7,    5,    2,    0, },  /* 26 (25.904) */
    {  13,    9,    8,    5,    2,    0, },  /* 27 (26.829) */
    {  13,   11,    8,    5,    5,    1, },  /* 28 (27.989) */
    {  13,    9,    8,    8,    5,    2, },  /* 29 (28.984) */
    {  22,   16,   10,    6,    5,    2, },  /* 30 (29.980) */
    {  21,   14,   10,    8,    7,    2, },  /* 31 (30.966) */
    {  24,   21,   10,    8,    8,    2, },  /* 32 (31.995) */ /* G WB*/
    {   5,    4,    1,    0,    0,    0, },  /* 12 (11.925) */
    {   2,    0,    0,    2,    0,    0, },  /* 16 (15.826) */
    {   5,    4,    1,    1,    0,    0, },  /* 19 (18.745) */
    {   5,    4,    1,    2,    0,    0, },  /* 20 (19.838) */
    {   7,    5,    2,    2,    0,    0, },  /* 21 (20.910) */
    {   8,    5,    2,    2,    1,    0, },  /* 22 (21.985) */
    {   9,    8,    5,    2,    1,    0, },  /* 23 (22.815) */
    {  14,   13,    8,    2,    2,    0, },  /* 25 (24.996) */
    {  13,    8,    7,    4,    2,    0, },  /* 26 (25.993) */
    {  13,    9,    8,    5,    2,    2, },  /* 27 (26.954) */
    {  18,   13,    8,    5,    2,    2, },  /* 28 (27.992) */
    {  21,   13,   11,    5,    3,    2, },  /* 29 (28.996) */
    {  22,   21,   13,    5,    5,    2, },  /* 30 (29.988) */
    {  23,   21,   17,    7,    5,    2, },  /* 31 (30.962) */
    {  27,   23,   21,    8,    5,    2, },  /* 32 (31.987) */ /* G NB*/

    {   2,    0,    0,    2,    0,    0, }, /* 17 */
    {   4,    2,    0,    1,    0,    0, }, /* 18 */
    {   4,    1,    0,    4,    0,    0, }, /* 21 */
    {   5,    2,    0,    4,    1,    0, }, /* 22 */
    {   8,    5,    2,    4,    0,    0, }, /* 24 */
    {   8,    5,    2,    5,    2,    0, }, /* 25 */
    {  14,   10,    5,    5,    5,    1, }, /* 28 */
    {  14,   10,    5,    8,    8,    4, }, /* 30 */
    {  13,   10,    5,   13,    8,    8, },
    {  23,   21,    8,    8,    8,    4, },
    {  23,   18,    5,   13,    8,    8, }, /* 33 */ /* mode 6 T WB */
    {   2,    0,    0,    2,    2,    0, }, /* 17 */
    {   4,    2,    0,    1,    0,    0, }, /* 18 */
    {   7,    5,    2,    2,    2,    0, }, /* 22 */
    {   8,    7,    4,    2,    2,    0, }, /* 23 */
    {  11,    8,    5,    2,    2,    0, }, /* 24 */
    {  18,    8,    5,    2,    2,    0, }, /* 25 */
    {  16,    8,    5,    5,    5,    2, }, /* 28 */
    {  28,   23,    8,    5,    5,    5, }, /* 31 */
    {  31,   31,    8,    5,    5,    7, }, /* 32 */ /* mode 7 T NB */
    {  18,   18,   11,    9,    6,    5, }, /* 31 */
    {  24,   23,   13,    9,    6,    5, }, /* 32 */ /* mode 8 G 16k  */
    {  24,   23,   13,    9,    6,    5, },  /* 32 (31.998) */
    {  36,   31,   18,    9,    6,    5, },  /* 33 (32.983) */ /* T 16k */
    {   2,    0,    0,    2,    2,    0, }, /* 17 */
    {   7,    5,    2,    2,    0,    0, }, /* 21 */
    {   7,    5,    2,    2,    2,    0, }, /* 22 */
    {   9,    8,    3,    4,    2,    0, }, /* 25 */
    {  11,    9,    8,    4,    2,    0, }, /* 26 */ /* mode 10 AUDIO_WB*/
    {  48,   48,   34,   13,   11,    9  }, /* 36 */ /* mode 10 AUDIO_WB 36 + 4 + 1 */
    {  22,   10,    3,    0,    0,    0  }, /* 17 */
    {   6,    6,    2,    2,    0,    0  }, /* 21 */
    {   6,    6,    2,    2,    2,    0  }, /* 22 */
    {  23,   10,    3,    2,    2,    0  }, /* 26 */
    {  32,   16,    3,    2,    2,    0  }, /* 27 */
    {  39,   30,   12,    2,    2,    0  }, /* 28 */ /* AUDIO_NB */
    {  11,    9,    8,    4,    2,    0, }, /* 26 */
    {  48,   48,   48,   13,    9,    8, }, /* 36 */ /* mode 12 AUDIO_WB 16k 15-36 + 4 + 1*/
    {   8,    7,    2,    2,    0,    0, },  /* 22 (21.776) */
    {  13,   13,    5,    5,    5,    0, },  /* 28 (27.994) */
    {  18,   17,    5,    5,    5,    1, },  /* 29 (28.996) */
    {  17,   13,    5,    8,    6,    2, },  /* 30 (29.991) */
    {  23,   21,    8,    9,    8,    3, },  /* 32 (31.992) */
    {  31,   29,   16,    8,    8,    3, },  /* 33 (32.993) */
    {  31,   25,   16,    12,   8,    8, },  /* 34 (33.968) */
    {  46,   48,   18,   18,   18,   12, },  /* 37 (36.995) */ /* VOICED 16k actually not used */
    {  14,   12,    9,    2,    2,    0, },  /* 25 (24.980) */
    {  15,   13,    3,    2,    2,    0, },  /* 25 (24.974) */
    {  17,    3,    0,    2,    2,    1, },  /* 25 (24.852) */
    {  13,   10,    3,    2,    2,    2, },  /* 25 (24.994) */
    {  14,   13,    8,    2,    2,    0, },  /* 25 (24.996) */
    {   7,    3,    0,    5,    3,    1, },  /* 25 (24.671) */
    {   4,    3,    2,    6,    6,    5, },  /* 25 (24.936) */
    {   4,    2,    0,    9,    9,    3, },  /* 25 (24.955) */
    {   4,    2,    0,    9,    8,    2, },  /* 25 (24.853) */
    {   4,    2,    0,    9,    7,    6, },  /* 25 (24.881) */
    {   6,    3,    0,    6,    3,    2, },  /* 25 (24.939) */
    {   3,    2,    0,    9,    8,    5, },  /* 25 (24.996) */
    {   2,    2,    0,   15,    3,    3, },  /* 25 (24.310) */
    {   4,    2,    0,    9,    9,    3, },  /* 25 (24.955) */
    {   4,    4,    2,    7,    6,    3, },  /* 25 (24.984) */
    {   3,    2,    0,    9,    7,    6, },  /* 25 (24.866) */
};

const int no_lead_p[][MAX_NO_SCALES*2] =
{
    {   2,    1,    0,    0,    0,    0, },  /*  9 (8.464) */
    {   4,    2,    0,    2,    0,    0, },  /* 19 (18.572) */
    {   5,    5,    2,    4,    2,    0, },  /* 23 (22.959) */
    {   8,    5,    2,    4,    0,    0, },  /* 24 (23.949) */
    {   8,    8,    5,    4,    2,    0, },  /* 25 (24.992) */
    {  13,   11,    5,    5,    2,    0, },  /* 27 (26.902) */
    {  11,   10,    5,    6,    5,    2, },  /* 28 (27.996) */
    {  14,   13,    5,    7,    5,    2, },  /* 29 (28.937) */
    {  16,   13,    5,    8,    7,    2, },  /* 30 (29.954) */
    {  21,   21,    5,    8,    5,    2, },  /* 31 (30.978) */
    {  24,   21,    5,    8,    8,    4, },  /* 32 (31.978) */
    {  32,   23,    5,   13,   11,    5, },  /* 34 (33.975) */
    {  36,   31,    8,   16,   13,    5, },  /* 35 (34.975) */
    {  45,   35,   16,   18,   13,    5, },  /* 36 (35.889) */
    {  45,   35,   16,   38,   31,    8, },  /* 39 (38.488) */ /* V WB*/ /* 14 */

    {   2,    0,    0,    0,    0,    0, },  /*  8 (7.913) */
    {   4,    2,    0,    2,    0,    0, },  /* 19 (18.572) */
    {   8,    7,    2,    2,    2,    0, },  /* 23 (22.773) */
    {  13,   11,    5,    2,    1,    0, },  /* 24 (23.999) */
    {   8,    8,    5,    4,    2,    0, },  /* 25 (24.992) */
    {  13,   11,    5,    5,    2,    1, },  /* 27 (26.962) */
    {  13,   11,    5,    5,    5,    2, },  /* 28 (27.835) */
    {  14,   13,    5,    7,    5,    2, },  /* 29 (28.937) */
    {  23,   21,    5,    5,    5,    2, },  /* 30 (29.969) */
    {  23,   18,    5,    8,    5,    2, },  /* 31 (30.952) */
    {  24,   21,    5,    8,    8,    4, },  /* 32 (31.978) */
    {  43,   41,   13,    9,    8,    5, },  /* 34 (33.992) */
    {  43,   36,   13,   13,   10,    5, },  /* 35 (35.000) */
    {  43,   40,   13,   17,   13,    9, },  /* 36 (35.980) */
    {  43,   42,   13,   31,   30,   18, },  /* 39 (38.512) */ /* V NB*/ /* 29 */

    {   2,    0,    0,    1,    0,    0, },  /* 15 (14.733) */
    {   5,    4,    1,    1,    0,    0, },  /* 19 (18.745) */
    {   8,    7,    2,    2,    0,    0, },  /* 22 (21.776) */
    {  10,    9,    5,    2,    0,    0, },  /* 23 (22.791) */
    {  14,   13,    8,    2,    0,    0, },  /* 24 (23.999) */
    {  14,   13,    8,    2,    2,    0, },  /* 25 (24.996) */
    {  18,   17,   13,    2,    2,    0, },  /* 26 (25.934) */
    {  14,   13,    8,    5,    4,    0, },  /* 28 (27.969) */
    {  18,   17,   13,    5,    4,    2, },  /* 29 (28.996) */
    {  22,   21,   13,    5,    5,    2, },  /* 30 (29.988) */
    {  31,   23,   21,    5,    5,    2, },  /* 31 (30.931) */
    {  27,   23,   21,    8,    5,    2, },  /* 32 (31.987) */
    {  31,   23,   21,    9,    8,    5, },  /* 33 (32.982) */
    {  32,   31,   24,   11,    8,    5, },  /* 34 (33.967) */
    {  32,   32,   28,   13,   11,    8, },  /* 35 (34.994) */ /* G WB*/ /* 44 */

    {   2,    0,    0,    1,    0,    0, },  /* 15 (14.733) */
    {   5,    4,    2,    1,    0,    0, },  /* 19 (18.792) */
    {   8,    5,    2,    2,    1,    0, },  /* 22 (21.985) */
    {   8,    7,    2,    2,    2,    0, },  /* 23 (22.773) */
    {  13,   11,    2,    2,    1,    0, },  /* 24 (23.932) */
    {  16,   13,    2,    2,    2,    0, },  /* 25 (24.955) */
    {  21,   17,    2,    2,    2,    0, },  /* 26 (25.991) */
    {  13,   12,    2,    5,    5,    2, },  /* 28 (27.979) */
    {  18,   16,    2,    5,    5,    2, },  /* 29 (28.878) */
    {  23,   21,    2,    5,    5,    2, },  /* 30 (29.954) */
    {  32,   28,    2,    5,    5,    2, },  /* 31 (30.893) */
    {  38,   31,    2,    7,    5,    2, },  /* 32 (31.963) */
    {  33,   31,    2,    8,    8,    4, },  /* 33 (32.997) */
    {  42,   31,    2,    9,    9,    8, },  /* 34 (33.986) */
    {  42,   31,    2,   13,   11,    9, },  /* 35 (34.952) */ /* G NB*/ /* 59 */


    {   7,    5,    2,    2,    0,    0, }, /* 21 */
    {   8,    8,    5,    4,    2,    0, }, /* 25 */
    {  13,    8,     5,    4,    2,    0, }, /* 26 */
    {  13,    8,     5,    8,    6,    2, }, /* 29 */
    {   13,   8,     5,    9,    8,    5, }, /* 30 */
    {  48,   48,    48,   36,   36,   28  }, /* 40 */ /* mode 7 AUDIO_WB */ /* 65*/
    {   7,    5,    2,    2,    0,    0  }, /* 21 */
    {  13,   13,    9,    2,    2,    0  }, /* 25 */
    {  18,   18,    9,    2,    2,    0  }, /* 26 */
    {  24,   23,   10,    5,    4,    2  }, /* 30 */
    {  31,   31,   12,    5,    5,    2  }, /* 31 */
    {  43,   34,   12,    5,    5,    4  }, /* 32 */ /*AUDIO_NB */ /* 71 */
    {  13,    8,    5,    9,    8,    5, }, /* 30 */
    {  48,   48,   45,   45,   31,   25, }, /* 40 */ /* mode  AUDIO_WB 16k */ /* 73*/
    {   2,    0,    0,    2,    2,    0, },  /* 17 (16.823) */
    {   7,    5,    2,    2,    0,    0, },  /* 21 (20.910) */
    {   7,    5,    2,    2,    2,    0, },  /* 22 (21.907) */
    {  13,   11,   10,    2,    2,    0, },  /* 25 (24.863) */
    {  18,   18,   10,    2,    2,    0, },  /* 26 (25.921) */
    {  13,    9,    9,    5,    2,    0, },  /* 27 (26.837) */
    {  40,   28,   25,   18,   17,    2, },  /* 36 (35.998) */ /* INACTIVE NB*/ /* 80*/

    {  18,   17,   11,    0,    0,    0, },  /* 17 (16.932) */
    {   7,    5,    2,    2,    0,    0, },  /* 21 (20.910) */
    {   8,    5,    2,    2,    1,    0, },  /* 22 (21.985) */
    {  13,   13,    9,    2,    2,    0, },  /* 25 (24.845) */
    {  18,   18,   12,    2,    2,    0, },  /* 26 (25.999) */
    {  23,   23,   16,    2,    2,    0, },  /* 27 (26.981) */
    {  36,   32,   24,   17,   13,   13, },  /* 36 (35.929) */ /* INACTIVE WB */

    {   2,    2,    0,    2,    0,    0, },  /* 17 (16.823) */
    {   7,    5,    2,    2,    0,    0, },  /* 21 (20.910) */
    {   8,    5,    2,    2,    1,    0, },  /* 22 (21.985) */
    {  13,   13,    9,    2,    2,    0, },  /* 25 (24.845) */
    {  18,   17,   13,    2,    2,    0, },  /* 26 (25.934) */
    {  23,   22,   17,    2,    2,    0, },  /* 27 (26.914) */
    {  34,   32,   24,   16,   16,   13, },  /* 36 (35.915) */ /* INACTIVE WB 16k*/

    {   4,    2,    0,    1,    0,    0, },  /* 18 (17.479) */
    {   5,    4,    0,    1,    0,    0, },  /* 19 (18.703) */
    {   8,    7,    2,    2,    0,    0, },  /* 22 (21.776) */
    {  10,   9,    5,    2,    0,    0, },  /* 23 (22.791) */
    {  15,   13,    5,    2,    0,    0, },  /* 24 (23.999) */
    {  18,   16,    8,    5,    5,    1, },  /* 29 (28.966) */
    {  42,   32,   31,    5,    5,    2, },  /* 32 (31.990) */ /* UNVOICED NB*/
    {   1,    0,    0,    1,    0,    0, },  /* 14 (13.640) */
    {   2,    0,    0,    1,    0,    0, },  /* 15 (14.733) */
    {   4,    2,    0,    1,    0,    0, },  /* 18 (17.479) */
    {   4,    2,    0,    2,    0,    0, },  /* 19 (18.572) */
    {   5,    4,    0,    2,    0,    0, },  /* 20 (19.796) */
    {   8,    8,    5,    4,    2,    0, },  /* 25 (24.992) */
    {  11,   10,    5,    6,    5,    2, },  /* 28 (27.996) */ /* UNVOICED WB */

    {   9,    3,    0,    4,    0,    0, },  /* 24 (23.818) */
    {  18,   13,   10,    8,    3,    0, },  /* 30 (29.992) */
    {  24,   18,   10,    9,    3,    0, },  /* 31 (30.998) */
    {  32,   25,   10,    9,    3,    0, },  /* 32 (31.987) */
    {  42,   31,   10,   12,    3,    2, },  /* 34 (33.994) */
    {  44,   32,   27,   15,    3,    2, },  /* 35 (35.000) */
    {  44,   32,   25,   19,    3,    2, },  /* 36 (35.994) */
    {  48,   39,   32,   35,   15,    3, },  /* 39 (38.301) */ /* VOICED 16k */
    {  11,   10,    5,    4,    2,    0, },  /* 26 (25.917) */
    {  23,   23,   17,    8,    7,    2, },  /* 32 (31.980) */
    {  32,   31,   18,    9,    7,    5, },  /* 33 (32.990) */
    {  31,   31,   18,   11,    9,    8, },  /* 34 (33.974) */
    {  32,   32,   20,   13,   12,    8, },  /* 35 (34.989) */
    {  32,   32,   23,   18,   17,    8, },  /* 36 (35.988) */
    {  32,   32,   23,   23,   22,   10, },  /* 37 (36.989) */ /* GENERIC 16k*/

    {   2,    0,    0,    2,    0,    0, },  /* 16 (15.826) */
    {   7,    5,    2,    2,    0,    0, },  /* 21 (20.910) */
    {  14,   13,    8,    2,    0,    0, },  /* 24 (23.999) */
    {   8,    8,    5,    4,    2,    0, },  /* 25 (24.992) */
    {  11,   10,    5,    4,    2,    0, },  /* 26 (25.917) */
    {  16,   13,    8,    4,    2,    0, },  /* 27 (26.883) */
    {  13,   13,    8,    5,    4,    2, },  /* 28 (27.901) */
    {  23,   18,   13,    5,    5,    2, },  /* 30 (29.916) */
    {  23,   23,   13,    7,    5,    2, },  /* 31 (30.993) */
    {  23,   23,   17,    8,    7,    2, },  /* 32 (31.980) */
    {  32,   31,   24,    8,    7,    2, },  /* 33 (32.958) */
    {  42,   32,   31,    9,    9,    4, },  /* 34 (33.987) */
    {  40,   32,   29,   12,    9,    9, },  /* 35 (34.994) */
    {  40,   32,   31,   17,   11,   11, },  /* 36 (35.968) */
    {  41,   32,   31,   20,   18,   13, },  /* 37 (36.971) */ /* GENERIC 12.8k MA*/


    {  11,   10,    5,    4,    2,    0, },  /* 26 (25.917) */
    {  23,   23,   17,    8,    7,    2, },  /* 32 (31.980) */
    {  31,   31,   18,    9,    8,    2, },  /* 33 (32.995) */
    {  48,   32,   24,    9,    8,    3, },  /* 34 (33.993) */
    {  48,   32,   28,   11,   10,    3, },  /* 35 (34.992) */
    {  48,   37,   32,   16,   12,    4, },  /* 36 (35.997) */
    {  48,   37,   32,   18,   17,   12, },  /* 37 (36.961) */ /* AUDIO 16k */
};

const short min_lat_bits_SN[] = {-1, -1, 17, 12, 17, 17, -1, -1, 17, 12, 17, 17, -1, -1, 22, -1, 32, 26
                                };

const short min_lat_bits_pred[] = {17, 18, 9, 15, -1, 21, 17, 14, 9, 15, -1, 21, 17, -1, -1, 26, -1, 26, 16};



const short offset_in_lvq_mode_SN[][21] =
{
    {0},                                                /* I NB */
    {0,1,1,1,1,1,2,3,3,3,3,4,4,4,5},                   /* UV NB*/
    {0,1,1,1,1,2,3,4,5,5,6,6,7,7,7,7,7,8,8,8,9},       /* V NB */
    {0,0,0,0,1,1,1,2,3,4,5,6,6,7,8,9,10,11,12,13,14},   /* G NB */
    {0,1,1,1,1,2,3,4,5,5,5,6,6,6,7,8},                 /* T NB */
    {0,0,0,0,1,2,2,2,2,3,4,5},                         /* A NB */
    {0},                                                /* I WB */
    {0,1,1,1,2,3,3,3,3,3,3,4,4,4,5},                   /* UV WB*/
    {0,1,1,1,2,3,3,3,4,5,6,7,8,9,9,10,11,12,12,12,13}, /* V WB */
    {0,0,0,0,1,1,1,2,3,4,5,6,6,7,8,9,10,11,12,13,14},             /* G WB */
    {0,1,1,1,2,3,3,4,5,5,5,6,6,7,8,9,10},              /* T WB */
    {0,0,0,0,1,2,2,2,3,4,4,4,4,4,4,4,4,4,4,5},         /* A WB */
    {0},
    {0},
    {0,0,0,0,0,0,1,2,3,3,4,5,6,6,6,7},                 /* V 16k */
    {0},                                               /* G 16k */
    {0,1},                                             /* T 16k */
    {0}, /*{0,0,0,0,0,0,0,0,0,0,1} */                  /* A 16k */
};
const short offset_in_lvq_mode_pred[][32] =
{
    {0,0,0,0,1,2,2,2,3,4,5,5,5,5,5,5,5,5,5,6},          /* I NB */
    {0,1,1,1,2,3,4,4,4,4,4,5,5,5,6},                    /* UV NB */
    {0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,3,4,4,5,6,7,8,9,10,10,11,12,13,13,13,14},        /* V NB */
    {0,0,0,0,1,1,1,2,3,4,5,6,6,7,8,9,10,11,12,13,14},   /* G NB */
    {0},                                                /* T NB */
    {0,0,0,0,1,2,2,2,2,3,4,5},                          /* A NB */
    {0,0,0,0,1,2,2,2,3,4,5,5,5,5,5,5,5,5,5,6},          /* I WB */
    {0,1,1,1,2,3,4,4,4,4,4,5,5,5,6},                    /* UV WB */
    {0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,3,4,4,5,6,7,8,9,10,10,11,12,13,13,13,14}, /* V WB */
    {0,0,0,0,1,1,1,2,3,4,5,6,6,7,8,9,10,11,12,13,14},   /* G WB */
    {0},                                                /* T WB */
    {0,0,0,0,1,2,2,2,3,4,4,4,4,4,4,4,4,4,4,5},          /* A WB */
    {0,0,0,0,1,2,2,2,3,4,5,5,5,5,5,5,5,5,5,6},          /* I 16k */
    {0},												/* UV 16k */
    {0,0,0,0,0,0,1,2,3,3,4,5,6,6,6,7},                  /* V 16k */
    {0,0,0,0,0,0,1,2,3,4,5,6},                          /* G 16k */
    {0},												/* T 16k */
    {0,0,0,0,0,0,1,2,3,4,5,6},                          /* A 16k */
    {0,0,0,0,0,1,1,1,2,3,4,5,6,6,7,8,9,10,11,12,13,14}, /* G WB MA*/
};
const short offset_lvq_modes_SN[] = {-1,-1,26,51,77,96,-1,-1,12,36,66,90,-1,-1,105,-1,88,102,
                                     112
                                    };   /* CNG */

const short offset_lvq_modes_pred[] = {74, 95, 15, 45, -1, 66, 81, 102, 0, 30, -1, 60, 88, -1, 109, 117, -1, 139, 124};


/*-----------------------------------------------------------------*
 * BC-TCVQ frame-end quantization tables (BC-TCVQ is used in Voiced mode for 16kHz isf)
 *-----------------------------------------------------------------*/
const int NTRANS[4][NUM_STATE] = {{0,2,4,6,8,10,12,14,0,2,4,6,8,10,12,14},		/* indices of previous state of first branche */
    {1,3,5,7,9,11,13,15,1,3,5,7,9,11,13,15},		/* indices of previous state of second branches */
    {4,2,1,3,0,2,1,3,2,0,3,1,7,0,3,1},			/* indices of previous subset of first branch */
    {2,0,3,6,2,0,3,1,0,2,1,3,0,2,1,5}				/* indices of previous subset of second branch */
};

const int NTRANS2[4][NUM_STATE] = {{0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7},
    {8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15},
    {4,2,2,0,1,3,3,6,0,2,2,0,1,3,3,1},
    {2,0,0,2,3,1,1,3,7,0,0,2,3,1,1,5}
};

/* BC-TCQ Bit Allocations */
const short BC_TCVQ_BIT_ALLOC_40B[M/2+4] = {1, 4, 5,5,4,4, 2,2,2,2, 5,4 }; /*1+39bit*/

const short FixBranch[4][4][N_STAGE_VQ - 4] =
{
    {{0, 0, 0, 0}, {1, 0, 0, 0}, {0, 1, 0, 0}, {1, 1, 0, 0}},				/* incase of initial state 0  */
    {{0, 0, 1, 0}, {1, 0, 1, 0}, {0, 1, 1, 0}, {1, 1, 1, 0}},				/* incase of initial state 4  */
    {{0, 0, 0, 1}, {1, 0, 0, 1}, {0, 1, 0, 1}, {1, 1, 0, 1}},				/* incase of initial state 8  */
    {{0, 0, 1, 1}, {1, 0, 1, 1}, {0, 1, 1, 1}, {1, 1, 1, 1}}				/* incase of initial state 12 */
};

/* Intra-Prediction */
const float AR_IntraCoeff[N_STAGE_VQ-1][2][2] =
{
    {{-0.292479f, 0.676331f}, {-0.422648f, 0.217490f}},
    {{ 0.048957f, 0.500476f}, { 0.087301f, 0.287286f}},
    {{ 0.199481f, 0.502784f}, { 0.106762f, 0.420907f}},
    {{ 0.240459f, 0.440504f}, { 0.214255f, 0.396496f}},
    {{ 0.193161f, 0.494850f}, { 0.158690f, 0.306771f}},
    {{ 0.093435f, 0.370662f}, { 0.065526f, 0.148231f}},
    {{ 0.037417f, 0.336906f}, {-0.024246f, 0.187298f}}
};

const float SN_IntraCoeff[N_STAGE_VQ-1][2][2] =
{
    {{-0.452324f, 0.808759f}, {-0.524298f, 0.305544f}},
    {{ 0.009663f, 0.606028f}, {-0.013208f, 0.421115f}},
    {{ 0.144877f, 0.673495f}, { 0.080963f, 0.580317f}},
    {{ 0.208225f, 0.633144f}, { 0.215958f, 0.584520f}},
    {{ 0.050822f, 0.767842f}, { 0.076879f, 0.416693f}},
    {{ 0.005058f, 0.550614f}, {-0.006786f, 0.296984f}},
    {{-0.023860f, 0.611144f}, {-0.162706f, 0.576228f}}
};

const float scale_ARSN[M] = {1.8307f, 1.8404f, 1.8009f, 1.7416f, 1.7240f, 1.7467f, 1.6106f, 1.6497f, 1.5702f, 1.5548f, 1.5745f, 1.6199f, 1.5633f, 1.5239f, 1.5796f, 1.5615f};
const float scale_inv_ARSN[M] = {0.5462f, 0.5434f, 0.5553f, 0.5742f, 0.5800f, 0.5725f, 0.6209f, 0.6062f, 0.6369f, 0.6432f, 0.6351f, 0.6173f, 0.6397f, 0.6562f, 0.6331f, 0.6404f};

/* TCVQ Codebook */
const float AR_TCVQ_CB_SUB1[2][128][2] =
{
    {
        {-170.0561F,-169.3847F,},{-90.97870F,48.531700F,},{-148.6968F,17.218300F,},{-107.0229F,-34.21990F,},{-129.8378F,-87.31650F,},{-220.1001F,-234.4751F,},{-129.6736F,52.471700F,},{20.510900F,-288.6602F,},
        {-221.5495F,-0.070200F,},{58.214300F,123.37490F,},{-74.50640F,211.33990F,},{-48.14920F,123.86970F,},{-192.6126F,-247.4666F,},{-206.1983F,104.78470F,},{-125.3893F,-150.7979F,},{-168.7912F,-86.03110F,},
        {-95.16320F,-89.65400F,},{-12.70900F,177.33540F,},{-73.43770F,-250.7212F,},{-51.23060F,-84.00830F,},{-264.2502F,102.67830F,},{-184.2570F,-157.5882F,},{-121.9781F,-62.24850F,},{-132.6231F,115.89740F,},
        {-47.38870F,-84.58990F,},{-2.521300F,94.296500F,},{-79.13010F,-82.28630F,},{-49.25610F,-5.992200F,},{-286.7041F,-146.2168F,},{-178.7492F,-2.262600F,},{-115.8487F,-10.64920F,},{-119.9947F,-216.1283F,},
        {-69.10170F,1.3002000F,},{-68.48210F,-106.6926F,},{24.572700F,141.84890F,},{51.813600F,206.02520F,},{-51.84400F,-72.25850F,},{-175.4067F,-470.9963F,},{-112.2572F,-109.9498F,},{-51.26580F,339.48830F,},
        {-38.93840F,-40.88940F,},{-29.20570F,-69.73790F,},{-55.22180F,51.015500F,},{-12.33040F,42.160700F,},{-31.81780F,63.017700F,},{-174.1785F,-89.95120F,},{-110.4181F,-345.4240F,},{-49.84300F,-64.35890F,},
        {-59.63520F,-175.9810F,},{-69.02910F,-44.58650F,},{-43.97120F,-49.59230F,},{-87.25920F,-138.5465F,},{-96.25540F,-174.5186F,},{-154.7553F,-275.2756F,},{-109.5143F,128.62810F,},{-14.54350F,-25.04360F,},
        {-46.05230F,81.366800F,},{-32.03440F,24.870900F,},{-132.5154F,-143.2318F,},{-22.59640F,-51.55940F,},{-178.7877F,251.71930F,},{-148.7196F,-212.2087F,},{-106.1241F,217.56180F,},{24.099800F,29.423900F,},
        {-119.7589F,-323.8735F,},{121.21500F,173.78130F,},{28.604700F,-10.13160F,},{37.177600F,85.584900F,},{87.071500F,238.62500F,},{109.09800F,76.070100F,},{167.92980F,224.78890F,},{165.46650F,86.241500F,},
        {-9.919200F,0.5865000F,},{126.17610F,92.028000F,},{-38.94060F,-121.2069F,},{4.4071000F,-13.64760F,},{32.528700F,-1.269700F,},{109.85480F,288.47620F,},{193.40720F,153.42400F,},{34.912700F,501.59090F,},
        {12.630000F,53.019400F,},{11.431500F,13.336900F,},{191.94830F,224.70850F,},{40.979900F,-73.55240F,},{5.8897000F,-171.8742F,},{111.18560F,4.0700000F,},{201.66060F,-41.15440F,},{122.30070F,274.89960F,},
        {-2.425900F,-107.2105F,},{-24.07350F,-25.13440F,},{-4.758000F,-49.75210F,},{66.313900F,932.60360F,},{63.427900F,76.575200F,},{131.07660F,161.35400F,},{211.93280F,81.864800F,},{90.057500F,-27.39110F,},
        {-0.656200F,269.81920F,},{38.372300F,52.479100F,},{9.8096000F,55.003200F,},{101.87250F,118.98060F,},{121.92950F,-125.7858F,},{131.37830F,88.916800F,},{218.95100F,305.25590F,},{299.20050F,200.64100F,},
        {-5.459000F,-45.76330F,},{64.972100F,353.45030F,},{-19.39350F,0.4459000F,},{183.81020F,144.04150F,},{134.69810F,96.639400F,},{135.54900F,-149.4564F,},{219.02860F,440.63140F,},{200.41160F,402.24270F,},
        {39.254000F,-5.942300F,},{72.189700F,27.428900F,},{65.129100F,51.010200F,},{47.723500F,14.090300F,},{219.06510F,290.25100F,},{156.45050F,43.423900F,},{232.59480F,-226.2346F,},{263.13970F,83.869400F,},
        {74.758000F,73.874300F,},{14.975400F,-30.59550F,},{167.16620F,0.0965000F,},{101.95820F,53.053900F,},{-11.37910F,-38.59220F,},{158.02420F,120.38810F,},{239.72370F,224.38630F,},{657.07030F,665.65960F,},
    },

    {
        {-368.0999F,-65.52540F,},{-102.2718F,-140.9826F,},{-20.59040F,-66.70470F,},{-95.79090F,184.47330F,},{-837.7641F,-904.4130F,},{-510.6703F,492.69680F,},{-339.6600F,-757.9813F,},{-254.7818F,-220.3240F,},
        {-195.1893F,174.78510F,},{-225.8519F,-77.48110F,},{-216.3949F,43.255000F,},{-38.17870F,-32.99880F,},{-513.7912F,0.1722000F,},{-480.2339F,-631.9721F,},{-338.9732F,89.728000F,},{-150.2896F,414.33830F,},
        {-299.8150F,-389.7000F,},{-78.78780F,-23.51500F,},{-110.4856F,-76.99170F,},{-55.54460F,-127.1259F,},{-217.9132F,295.10380F,},{-475.2952F,178.16700F,},{-313.6053F,299.37920F,},{-383.7671F,290.27470F,},
        {-162.0853F,-139.3168F,},{-10.81860F,411.75810F,},{44.425800F,-95.93580F,},{31.498700F,285.88550F,},{-313.9570F,-197.7654F,},{-439.8449F,-43.63990F,},{-311.4479F,-51.44460F,},{-112.9209F,-79.77700F,},
        {-135.4290F,-11.18290F,},{-14.37020F,-101.2914F,},{-55.36790F,-170.9950F,},{-97.12010F,33.922700F,},{-341.4857F,133.28130F,},{-419.5535F,-1029.264F,},{-261.0493F,-606.2968F,},{-445.1823F,-298.5443F,},
        {-95.70290F,-200.4782F,},{-18.66770F,205.38260F,},{5.2869000F,154.20340F,},{-176.5040F,-252.4035F,},{-172.0901F,-378.6187F,},{-372.2359F,-501.4665F,},{-252.0296F,-151.3651F,},{-287.6742F,43.301600F,},
        {-63.75070F,119.02160F,},{-136.2005F,87.531000F,},{-87.96100F,287.68010F,},{36.839700F,-33.04480F,},{-118.0163F,-214.5814F,},{-365.9238F,-348.5409F,},{-236.4188F,-425.5134F,},{-25.16220F,-39.63130F,},
        {-63.00320F,-82.32200F,},{-152.9630F,-507.2372F,},{-57.66390F,48.660600F,},{5.3785000F,51.097300F,},{-168.7345F,-49.50600F,},{-359.4378F,-199.1688F,},{-233.7651F,-285.0083F,},{33.347500F,60.305100F,},
        {9.5961000F,-60.67060F,},{-22.43980F,93.048400F,},{184.09080F,107.94670F,},{164.32090F,265.57780F,},{-67.49340F,123.30580F,},{233.22030F,704.96710F,},{353.99250F,-262.9922F,},{210.06920F,175.77800F,},
        {-104.2510F,-314.3242F,},{0.9024000F,-7.495400F,},{86.823700F,85.372000F,},{72.376700F,137.49970F,},{-13.00090F,-69.46920F,},{236.74980F,46.279600F,},{374.54780F,-27.20110F,},{136.88650F,-35.73790F,},
        {-34.16180F,16.487600F,},{283.87900F,353.51860F,},{21.261500F,12.921800F,},{123.46920F,17.014100F,},{98.105500F,5.7719000F,},{238.18290F,-47.81850F,},{386.73840F,560.96730F,},{32.152700F,578.18980F,},
        {70.706200F,208.99530F,},{69.254100F,50.614900F,},{273.61320F,220.89670F,},{244.46280F,129.16830F,},{108.85950F,215.41490F,},{265.47770F,276.31920F,},{395.46140F,283.90850F,},{412.94530F,299.13520F,},
        {-5.075000F,-154.7571F,},{142.09250F,160.91980F,},{172.66840F,-70.68220F,},{79.050300F,-150.7248F,},{220.80900F,545.83980F,},{289.05480F,1023.7731F,},{421.94000F,140.86480F,},{436.59640F,74.580500F,},
        {31.476700F,103.73850F,},{84.791000F,-50.67070F,},{136.49490F,394.28200F,},{264.97310F,-186.0375F,},{531.67460F,343.03590F,},{310.71060F,184.35030F,},{494.98260F,403.81940F,},{406.31780F,490.15840F,},
        {137.11870F,78.459100F,},{-26.93550F,-247.3193F,},{-13.90060F,-408.4927F,},{315.74950F,11.906200F,},{507.81160F,-77.48790F,},{313.84650F,400.68920F,},{543.13960F,-127.4566F,},{895.02000F,968.45590F,},
        {65.022700F,5.1458000F,},{203.36110F,32.767800F,},{99.442400F,-280.2416F,},{385.57300F,174.81870F,},{303.53400F,86.087500F,},{316.97760F,81.139300F,},{545.10640F,789.31480F,},{585.50660F,162.80340F,},
    }
};

const float AR_TCVQ_CB_SUB2[2][64][2] =
{
    {
        {-139.4748F,-20.51230F,},{-205.2710F,65.240700F,},{-90.66390F,99.509000F,},{-51.55990F,-140.1515F,},{-367.2977F,-86.40560F,},{-101.5758F,-506.4093F,},{-467.6164F,-177.7713F,},{-325.3952F,19.243000F,},
        {-51.50950F,-0.580700F,},{-156.7042F,-109.3179F,},{-82.92030F,-84.85600F,},{-75.64660F,36.105400F,},{-226.3753F,-277.4524F,},{-336.8399F,-293.0652F,},{-261.4553F,168.08600F,},{-203.4850F,280.69810F,},
        {-242.0593F,-177.4998F,},{-93.17880F,198.93370F,},{-6.034900F,-224.4959F,},{152.10510F,274.83370F,},{-347.4922F,202.31740F,},{-450.9290F,32.755600F,},{-246.8381F,-399.5943F,},{-242.2880F,-493.4214F,},
        {-104.8258F,-183.7260F,},{-127.2704F,-288.3692F,},{17.116300F,247.94440F,},{28.590000F,141.33180F,},{-88.39520F,-8.409100F,},{-244.1211F,-41.49450F,},{-281.3448F,-44.43050F,},{-435.1837F,-417.8239F,},
        {7.2419000F,-97.64420F,},{32.515300F,38.550200F,},{13.574300F,-6.174500F,},{102.88080F,-123.3195F,},{184.39410F,428.29360F,},{-20.13120F,-127.9658F,},{-97.25060F,379.22250F,},{541.89470F,342.12550F,},
        {3.8567000F,79.183500F,},{339.32440F,253.39800F,},{87.921000F,66.552800F,},{117.63820F,32.476100F,},{490.72400F,188.26100F,},{152.82630F,-303.6073F,},{415.46300F,-125.0126F,},{20.317700F,471.51620F,},
        {120.83170F,146.52980F,},{183.34470F,88.231900F,},{241.62970F,156.33030F,},{23.616600F,-36.17640F,},{130.82320F,95.319300F,},{123.34420F,-25.34570F,},{-17.53680F,-385.5626F,},{253.17360F,-114.7059F,},
        {85.112600F,-25.82990F,},{-42.33470F,-51.85570F,},{195.47230F,-7.405400F,},{322.01970F,63.832500F,},{188.75460F,-173.2249F,},{506.79120F,93.875700F,},{390.46690F,470.76120F,},{243.34080F,526.34460F,},
    },

    {
        {-165.6917F,-377.1008F,},{-17.98370F,-75.86160F,},{7.9923000F,116.25350F,},{-130.2646F,-108.4639F,},{-311.2591F,-203.8264F,},{-339.0670F,-23.57200F,},{-7.653600F,-54.53950F,},{-423.8622F,-353.1093F,},
        {-240.0843F,-95.08200F,},{-143.2687F,8.5443000F,},{-101.9498F,-202.8074F,},{-43.42630F,-10.37850F,},{-291.0372F,55.326100F,},{-189.0665F,-593.2565F,},{-128.3240F,5.0444000F,},{-420.8219F,35.762800F,},
        {-206.5327F,85.114800F,},{-202.6915F,-233.0529F,},{-107.8853F,-28.10810F,},{-33.95630F,-155.5147F,},{-19.77350F,-490.9996F,},{-113.7118F,159.73310F,},{-345.0899F,238.75620F,},{68.787700F,-156.6325F,},
        {-52.29900F,-95.54260F,},{14.606500F,197.56230F,},{9.1784000F,-3.906100F,},{-88.07510F,114.63690F,},{-356.4571F,-517.1363F,},{-68.02240F,-113.1240F,},{-424.2482F,-150.8795F,},{-54.13860F,-30.29230F,},
        {-48.11040F,48.722800F,},{-9.974700F,-288.3043F,},{44.249300F,-134.2835F,},{68.270600F,70.915400F,},{294.67340F,-174.3828F,},{471.33110F,206.81070F,},{363.89680F,386.90480F,},{52.930000F,47.618800F,},
        {104.26640F,127.63530F,},{149.10830F,-71.25040F,},{280.53550F,183.93680F,},{288.38200F,42.039600F,},{61.611600F,50.856600F,},{170.86680F,156.74650F,},{139.90090F,-260.6101F,},{539.24370F,326.70950F,},
        {71.975100F,-6.711500F,},{169.81850F,90.253300F,},{157.30500F,24.483300F,},{59.160200F,-48.84550F,},{-42.61460F,-92.55310F,},{270.15440F,-94.32920F,},{487.06470F,75.464100F,},{345.55540F,126.52380F,},
        {-110.4957F,258.30830F,},{17.373900F,41.055800F,},{60.912700F,355.85580F,},{151.18090F,229.57390F,},{269.34040F,569.72710F,},{259.50450F,412.82330F,},{-14.73050F,568.47830F,},{252.07040F,354.99801F,},
    }
};

const float AR_TCVQ_CB_SUB3[4][32][2] =
{
    {
        {-190.2462F,3.7460000F,},{-178.0891F,-156.6944F,},{37.733100F,176.00550F,},{-93.45970F,165.15130F,},{-267.7612F,-511.1700F,},{27.017600F,-276.8829F,},{-118.0160F,-462.8076F,},{188.15520F,-112.6265F,},
        {-112.2084F,-272.1046F,},{-75.63800F,28.803700F,},{-62.17480F,-51.65160F,},{-62.91250F,-122.3795F,},{-315.9380F,163.32500F,},{-335.8190F,-361.7829F,},{-10.02270F,-28.26150F,},{-411.0079F,-169.0698F,},
        {21.274600F,52.847800F,},{41.786600F,-55.20310F,},{131.61950F,-6.998400F,},{157.68690F,287.15550F,},{-42.42940F,-201.8275F,},{281.21280F,-25.80890F,},{-13.25970F,522.18800F,},{-66.78560F,354.06180F,},
        {20.563700F,-135.3851F,},{140.59070F,104.26130F,},{279.11580F,136.98410F,},{39.195800F,51.957500F,},{34.262500F,51.346000F,},{381.14700F,390.58580F,},{491.52390F,213.96490F,},{288.60580F,536.49710F,},
    },

    {
        {-133.0008F,-181.1299F,},{-84.55430F,-304.3680F,},{40.548600F,-157.9567F,},{-35.81290F,-86.14820F,},{-296.9231F,-235.1026F,},{-357.0671F,-316.6972F,},{-258.1654F,-349.4409F,},{-504.7979F,-113.4180F,},
        {-123.9764F,51.459200F,},{-224.7199F,-60.69300F,},{-89.06170F,-50.36220F,},{-100.2134F,190.61760F,},{-111.9099F,-529.1262F,},{-36.32900F,-101.2426F,},{-311.5327F,69.813400F,},{-318.3195F,-534.8423F,},
        {84.270600F,222.53200F,},{-0.942100F,28.769200F,},{213.25620F,65.535600F,},{97.994500F,73.849700F,},{30.130700F,19.067100F,},{-368.2725F,229.34600F,},{148.61930F,481.44170F,},{418.05130F,44.184400F,},
        {45.929700F,-10.41460F,},{151.92930F,-55.78590F,},{7.0662000F,84.175000F,},{287.46830F,226.85480F,},{429.16810F,486.29900F,},{176.48300F,159.59660F,},{579.15160F,254.26680F,},{-68.04440F,453.68870F,},
    },

    {
        {-100.1363F,-189.9851F,},{-26.01900F,223.37290F,},{-2.345900F,62.933400F,},{-66.92170F,59.692200F,},{-463.9627F,-172.0395F,},{-422.4871F,43.361300F,},{-250.2149F,-359.6565F,},{-90.88240F,-37.63640F,},
        {-199.5678F,57.586700F,},{-112.5751F,-36.52960F,},{189.51950F,260.19820F,},{-238.2629F,-142.8535F,},{-139.3418F,-351.6046F,},{-336.3076F,-424.9823F,},{-30.62490F,-40.98700F,},{-103.6085F,-330.2230F,},
        {5.6849000F,7.1876000F,},{31.018100F,-149.6002F,},{-80.41110F,-100.6484F,},{119.56500F,103.01690F,},{11.508400F,27.501500F,},{13.331700F,25.835000F,},{457.61300F,261.34590F,},{52.531100F,28.992900F,},
        {203.48110F,71.918000F,},{51.549200F,32.858000F,},{141.30200F,-35.55590F,},{22.330400F,-70.91510F,},{349.22210F,178.05560F,},{447.99330F,289.70830F,},{82.904000F,107.10660F,},{348.09590F,102.38850F,},
    },

    {
        {37.061900F,181.46230F,},{3.6812000F,53.960400F,},{-142.5384F,-250.3814F,},{-155.8055F,67.085000F,},{-97.44510F,-42.54350F,},{-36.71330F,-123.6734F,},{-63.68890F,-97.47460F,},{-233.4995F,-274.8922F,},
        {-72.26240F,14.184600F,},{-183.6676F,-77.60290F,},{25.462700F,93.954700F,},{-40.64230F,-141.5510F,},{-85.75550F,-313.0151F,},{-338.1776F,-25.63660F,},{-363.6425F,-156.2840F,},{-67.37240F,-51.54950F,},
        {-58.24200F,-193.3120F,},{181.77980F,98.461400F,},{-70.01130F,-27.99830F,},{171.39450F,112.01820F,},{321.84770F,218.43910F,},{12.987700F,52.170200F,},{22.943500F,52.400800F,},{34.529100F,56.928800F,},
        {72.765700F,16.633700F,},{26.847700F,-102.3211F,},{104.45050F,-37.68410F,},{15.601300F,31.425000F,},{32.724900F,50.955400F,},{264.88060F,147.81980F,},{316.65590F,175.13690F,},{359.29350F,211.19690F,},
    }
};

const float SN_TCVQ_CB_SUB1[2][128][2] =
{
    {
        {-249.7201F,40.935000F,},{-190.5588F,-175.3474F,},{-207.0069F,-316.9469F,},{-163.5806F,-247.6570F,},{-304.9679F,-414.6172F,},{-228.6147F,150.62910F,},{-195.6332F,-287.7428F,},{-190.9146F,-284.4862F,},
        {-274.4084F,-267.7108F,},{-199.2563F,-297.6162F,},{-152.2094F,-112.0928F,},{-148.0732F,-148.0190F,},{-223.7592F,-331.2033F,},{-227.6105F,-303.8584F,},{-195.2056F,-316.4586F,},{-262.2246F,-164.0172F,},
        {-201.5461F,313.27600F,},{-103.5079F,-192.2481F,},{-204.4250F,-221.9848F,},{-76.03550F,1125.8286F,},{-234.5633F,-67.04640F,},{-221.8844F,-339.4012F,},{-194.2347F,258.93820F,},{-251.0932F,-362.9766F,},
        {-135.0324F,-147.6629F,},{-98.67180F,-122.1392F,},{-163.4477F,232.42880F,},{-93.88090F,-181.8259F,},{-165.4640F,-213.2693F,},{-217.3162F,-119.1242F,},{-194.1371F,958.06900F,},{-176.2805F,-91.93370F,},
        {-176.7314F,-261.5485F,},{-143.7121F,-243.8883F,},{-148.1108F,-258.7831F,},{-118.9980F,-33.07910F,},{-214.2710F,155.74650F,},{-213.2181F,-251.6092F,},{-188.9855F,-166.4937F,},{-151.3290F,-213.3292F,},
        {-127.0467F,-214.8412F,},{-89.61480F,46.211900F,},{-32.48210F,392.23270F,},{-46.92120F,181.57460F,},{-113.0420F,-86.90470F,},{-201.7185F,60.547200F,},{-187.6557F,583.69500F,},{-161.9915F,53.907100F,},
        {-163.7852F,-39.11590F,},{-135.6215F,426.20040F,},{-169.3460F,29.788000F,},{-53.86960F,-113.5168F,},{-169.7033F,-280.7249F,},{-200.7809F,368.96580F,},{-184.8111F,-10.30170F,},{-56.33640F,-124.8625F,},
        {-146.8623F,587.82200F,},{-128.5270F,146.07030F,},{-123.4510F,-196.9422F,},{-22.75330F,-2.165400F,},{-105.3485F,-182.0782F,},{-198.0657F,-211.0788F,},{-181.9700F,-70.67280F,},{-100.1089F,-202.3083F,},
        {-76.38740F,283.61110F,},{-34.55220F,-139.0253F,},{-72.58420F,-153.9831F,},{11.931600F,-78.54570F,},{-30.11220F,-124.4284F,},{159.48950F,53.219000F,},{246.00260F,265.74940F,},{341.77020F,533.29990F,},
        {-78.13370F,-74.09460F,},{64.957700F,503.70880F,},{234.41130F,423.72930F,},{107.71920F,181.32610F,},{221.30620F,615.15230F,},{166.00660F,108.59500F,},{260.32690F,147.33710F,},{472.14910F,915.47850F,},
        {-71.05110F,-159.7740F,},{-37.06930F,-55.00150F,},{25.370000F,198.17320F,},{49.636800F,82.767400F,},{132.76160F,91.831000F,},{187.70590F,159.38410F,},{281.83160F,469.86870F,},{434.41380F,295.44770F,},
        {63.308300F,141.27590F,},{54.061700F,294.21520F,},{-65.88060F,-50.19340F,},{72.918300F,-12.50020F,},{26.680200F,-36.36690F,},{206.31630F,1119.4720F,},{306.99130F,308.17540F,},{487.14390F,573.31600F,},
        {-185.9491F,948.56350F,},{7.6792000F,52.069300F,},{0.9533000F,-92.26370F,},{166.57380F,312.24880F,},{153.64230F,230.62340F,},{207.81570F,610.05630F,},{315.18780F,208.51600F,},{550.64840F,410.71780F,},
        {-5.303600F,-102.8303F,},{32.350300F,-61.52830F,},{61.661100F,-14.86550F,},{240.57980F,214.70890F,},{329.97410F,212.08160F,},{209.52500F,92.791300F,},{356.06930F,594.08890F,},{638.68310F,525.05230F,},
        {45.061100F,-21.59060F,},{102.92090F,33.850300F,},{-49.38050F,91.477600F,},{147.03860F,74.554000F,},{179.35820F,1032.6932F,},{211.70910F,362.16160F,},{367.65010F,370.43750F,},{740.51460F,596.78260F,},
        {-7.303000F,724.00010F,},{177.80790F,142.93470F,},{213.00960F,110.61410F,},{324.63510F,326.04950F,},{475.33930F,330.59920F,},{218.87990F,211.76850F,},{395.71800F,253.94620F,},{744.16310F,915.21080F,},
    },

    {
        {-206.2475F,-95.90960F,},{-246.3082F,21.747300F,},{-280.0828F,-108.0290F,},{-15.81770F,518.20420F,},{-394.8764F,-268.7632F,},{-323.0682F,-133.0426F,},{-256.3050F,-624.6605F,},{-387.5242F,-608.8890F,},
        {-175.6982F,364.49880F,},{-210.8799F,823.99400F,},{-233.7273F,-494.8845F,},{-151.1368F,-199.8177F,},{-429.7681F,-772.9858F,},{-317.0574F,-240.9158F,},{-253.5630F,-57.26850F,},{-341.3936F,228.86220F,},
        {-281.1353F,-234.9062F,},{-109.7592F,-108.9512F,},{-225.6748F,247.90130F,},{65.929400F,31.226900F,},{-398.6104F,-52.49470F,},{-310.1716F,101.05650F,},{-249.3468F,320.56650F,},{-354.3097F,16.494000F,},
        {-277.0976F,-595.7491F,},{-188.3772F,523.29140F,},{-90.61150F,-382.6038F,},{40.513800F,903.74660F,},{-358.6226F,-460.4389F,},{-308.4215F,501.50370F,},{-237.7401F,882.27940F,},{-333.4506F,-381.9203F,},
        {-243.6204F,127.42030F,},{-75.62440F,666.13180F,},{-34.39620F,414.18390F,},{149.42210F,464.74430F,},{-162.1738F,5.7292000F,},{-308.1293F,-447.4555F,},{-236.0531F,158.90870F,},{-339.5853F,443.61930F,},
        {-196.4904F,-408.9761F,},{-212.8717F,-310.0990F,},{-50.11780F,183.79020F,},{32.747800F,249.33110F,},{-231.0534F,-589.2890F,},{-273.0207F,681.87410F,},{-234.5115F,-144.0888F,},{-306.1589F,641.38990F,},
        {-86.46690F,-261.1131F,},{-87.17310F,101.82230F,},{-32.13380F,-174.4069F,},{-147.5939F,-474.4269F,},{-289.3846F,378.38780F,},{-269.2454F,-337.1601F,},{-222.4565F,-232.3191F,},{-395.3117F,-157.5576F,},
        {-129.1616F,202.52440F,},{-68.35150F,307.27670F,},{-85.86670F,-1.271900F,},{-17.84710F,-328.4484F,},{-374.8384F,115.94100F,},{-260.0821F,26.484400F,},{-220.8236F,-532.8561F,},{-103.5023F,-8.057100F,},
        {253.68710F,299.43310F,},{99.798300F,140.48320F,},{132.05620F,-133.5340F,},{649.87660F,635.39510F,},{80.181400F,-88.45330F,},{377.92370F,11.967000F,},{475.26380F,362.41510F,},{663.04860F,481.53290F,},
        {125.93200F,564.57300F,},{125.00390F,699.34770F,},{161.43320F,82.756400F,},{388.46600F,81.488500F,},{299.40020F,103.03960F,},{380.48160F,344.82180F,},{479.55360F,94.266000F,},{656.04440F,313.06860F,},
        {29.314100F,121.82290F,},{294.35730F,556.75000F,},{136.00140F,242.52100F,},{251.75710F,185.26940F,},{393.60200F,297.97100F,},{404.77110F,790.64840F,},{528.97090F,207.17710F,},{629.35130F,831.62210F,},
        {63.429500F,363.62860F,},{344.74340F,320.98350F,},{386.67160F,190.67860F,},{240.19720F,-79.32440F,},{753.49380F,482.21660F,},{413.70600F,537.17310F,},{539.83860F,557.06520F,},{800.08120F,624.70540F,},
        {234.99860F,63.354100F,},{148.31920F,320.29180F,},{277.09270F,415.69540F,},{456.34320F,536.84340F,},{214.59280F,227.59820F,},{414.97560F,183.63070F,},{552.78850F,426.47270F,},{818.25130F,872.82940F,},
        {73.162100F,-246.0924F,},{46.113400F,-192.6345F,},{278.84370F,698.09160F,},{506.97560F,263.00580F,},{373.99370F,491.39020F,},{422.46610F,438.95710F,},{570.45150F,307.05580F,},{829.71370F,470.72770F,},
        {13.191300F,-73.93830F,},{20.994200F,-13.84500F,},{311.61780F,0.1251000F,},{291.89030F,929.08090F,},{554.80360F,450.16100F,},{436.77840F,653.52060F,},{582.72210F,893.43050F,},{943.77210F,632.08490F,},
        {452.66180F,701.26420F,},{152.06640F,-49.38430F,},{466.26870F,391.67580F,},{616.44670F,391.50590F,},{505.32310F,142.80040F,},{448.40750F,271.20620F,},{590.86500F,699.51280F,},{1072.8364F,818.59820F,},
    }
};

const float SN_TCVQ_CB_SUB2[2][64][2] =
{
    {
        {-276.9441F,-237.9956F,},{-240.2330F,-400.5215F,},{-168.0618F,-125.3249F,},{-17.18770F,403.15550F,},{-410.3021F,-12.59720F,},{-401.4485F,-725.0255F,},{-378.9797F,-42.53260F,},{-223.4008F,-557.0544F,},
        {-221.8536F,60.339100F,},{-55.66380F,-73.67660F,},{-31.18270F,208.03420F,},{-14.70030F,-246.7032F,},{-152.7168F,497.98040F,},{-385.0540F,-285.9732F,},{-187.2953F,-199.3057F,},{-377.2813F,37.510600F,},
        {-330.8419F,-541.7451F,},{-349.7656F,237.12440F,},{-143.6113F,-363.2778F,},{-150.6399F,137.64050F,},{-113.2274F,3.7534000F,},{-325.2374F,36.570200F,},{-206.2273F,671.09990F,},{-82.19470F,45.011800F,},
        {-206.7859F,334.70390F,},{-283.9658F,-89.72660F,},{-50.10190F,12.089100F,},{51.980300F,29.857900F,},{-107.5514F,-303.3203F,},{-240.0561F,-533.9766F,},{-132.4427F,-5.247100F,},{-404.3979F,480.69020F,},
        {175.02300F,332.36460F,},{233.95710F,41.575700F,},{430.97410F,434.21950F,},{248.10350F,487.89410F,},{297.34090F,302.33480F,},{207.50040F,-27.75610F,},{281.96760F,184.93040F,},{299.70790F,161.32720F,},
        {100.61040F,107.78600F,},{135.17980F,-148.3558F,},{190.27510F,196.71720F,},{435.19680F,47.673600F,},{344.53480F,606.71120F,},{774.72370F,483.79650F,},{830.43490F,475.25730F,},{680.48470F,492.90810F,},
        {52.827400F,-98.47120F,},{84.402600F,213.06580F,},{195.15830F,-48.72150F,},{538.51170F,746.06460F,},{118.75210F,29.688100F,},{589.58180F,237.71470F,},{602.54520F,540.84130F,},{211.57020F,715.21980F,},
        {-93.92180F,-182.2399F,},{301.03150F,254.59590F,},{356.44790F,109.52270F,},{510.59830F,279.64910F,},{716.35110F,402.13940F,},{409.68830F,191.91910F,},{634.49470F,286.14310F,},{974.51980F,759.27030F,},
    },

    {
        {-284.8923F,-332.8634F,},{-230.3763F,119.65300F,},{-155.3427F,115.29910F,},{-12.21440F,5.0214000F,},{-257.4728F,-29.15460F,},{-235.7490F,-480.0754F,},{-202.7355F,-263.5491F,},{-321.4648F,18.445600F,},
        {-294.7758F,-80.74580F,},{-319.5455F,-165.6476F,},{-275.4234F,-501.8569F,},{-100.6586F,-323.5581F,},{-315.1043F,-276.3239F,},{-71.14410F,-278.0978F,},{-362.3847F,1.2822000F,},{-177.8863F,-448.9796F,},
        {-329.8557F,164.76280F,},{-232.8216F,-393.7935F,},{-196.9382F,-183.5567F,},{-179.3588F,287.84510F,},{-131.8585F,-284.4139F,},{-326.5890F,401.69820F,},{-239.3882F,485.08990F,},{-238.0748F,504.86220F,},
        {-111.2109F,13.897700F,},{-109.4982F,-165.7892F,},{39.187700F,49.242200F,},{-179.4392F,-52.56030F,},{-62.00650F,-58.79660F,},{-112.2621F,74.326700F,},{21.768200F,-102.5222F,},{-103.2492F,-123.8958F,},
        {-2.999300F,235.37390F,},{24.464500F,117.61140F,},{209.73120F,-60.41300F,},{112.71650F,222.38860F,},{75.577500F,-161.0497F,},{337.52400F,31.008400F,},{267.89200F,155.94850F,},{328.81130F,647.32140F,},
        {45.064300F,-82.58150F,},{237.66130F,132.73260F,},{4.8216000F,-253.8600F,},{277.79930F,430.66600F,},{39.273100F,199.22940F,},{139.99440F,-162.6469F,},{494.67560F,176.94150F,},{207.76570F,239.06330F,},
        {-100.0752F,-265.5905F,},{15.938200F,454.44360F,},{233.38360F,309.59500F,},{189.17920F,-23.98650F,},{185.76940F,100.17430F,},{675.38230F,486.70190F,},{472.14070F,579.37430F,},{575.03280F,434.82210F,},
        {152.01630F,129.07580F,},{68.559300F,-151.6359F,},{400.30690F,123.64090F,},{409.88600F,286.04450F,},{578.27810F,432.67370F,},{502.13100F,240.50900F,},{675.71990F,390.09750F,},{781.79560F,651.86880F,},
    }
};

const float SN_TCVQ_CB_SUB3[4][32][2] =
{
    {
        {-147.1049F,-340.6287F,},{-158.8735F,313.47230F,},{-238.5137F,-175.2864F,},{-154.9957F,-34.27780F,},{-186.0273F,-415.2119F,},{-311.3175F,-97.27870F,},{-102.8572F,-258.6216F,},{-184.6271F,589.29930F,},
        {-279.5144F,121.03210F,},{-240.5628F,-383.6411F,},{-289.7553F,-518.3302F,},{77.502600F,128.26760F,},{-349.3453F,-608.3804F,},{-340.3397F,-491.6917F,},{-276.4456F,-539.0219F,},{-308.0319F,-331.5846F,},
        {25.470200F,-122.3889F,},{-23.10160F,-214.1888F,},{-0.632900F,26.756400F,},{142.04180F,-65.81690F,},{247.83350F,718.83400F,},{90.964100F,-139.8895F,},{485.82500F,582.96200F,},{641.17530F,379.95140F,},
        {79.709900F,202.16160F,},{199.84410F,369.96700F,},{239.35830F,94.047800F,},{423.