/*
**
** File:        "lbccodec.c"
**
** Description:     Top-level source code for G.723.1 dual-rate codec
**
** Functions:       main
**                  Process_files()
**
**
*/


/*
	ITU-T G.723.1 Software Package Release 2 (June 2006)
    
    ITU-T G.723.1 Speech Coder   ANSI-C Source Code     Version 5.2
    copyright (c) 1995, AudioCodes, DSP Group, France Telecom,
    Universite de Sherbrooke.  All rights reserved.
	Last modified : March 2006
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "typedef.h"
#include "basop.h"
#include "cst_lbc.h"
#include "tab_lbc.h"
#include "lbccodec.h"
#include "coder.h"
#include "decod.h"
#include "exc_lbc.h"
#include "util_lbc.h"
#include "cod_cng.h"
#include "dec_cng.h"
#include "vad.h"

#include "g723.h"

/* Global variables */
enum  Wmode    WrkMode = Both ;
enum  Crate    WrkRate = Rate63 ;

int   PackedFrameSize[2] = {
   24 ,
   20
   } ;

Flag    UseHp = True ;
Flag    UsePf = True ;
Flag    UseVx = False ;
Flag    UsePr = True ;

DLL_EXPORT void apiG723Init()
{
    /*
      Init coder and the decoder
    */
    Init_Decod( ) ;

    Init_Dec_Cng( );
}

DLL_EXPORT int apiG723decode(const char*payload, short *buf, short len)
{
    Word16  DataBuff[Frame] ;
    char    Line[24] ;

	memset(Line, 0, 24);
	memcpy(Line, payload, len);

    Decod( DataBuff, Line, 0 ) ;

	memcpy((void*)buf, (void*)DataBuff, sizeof(short)*Frame);

    return 0 ;
}
