#include "stdio.h"
#include "memory.h"
#include "g72x.h"
#include "g726.h"

DLL_EXPORT int g726_16_Decode(g726_state* state_ptr, unsigned char* bitstream, short* speech, int unpacklen)
{
	int i;
	int in;
	short temp;

	for (i = 0; i < unpacklen; i++)
	{
		in = (int) bitstream[i];
		temp = g726_16_decoder(in, AUDIO_ENCODING_LINEAR, state_ptr);
		memcpy((void*) (speech + i), &temp, 2);
	}

	return 0;
}

DLL_EXPORT int g726_24_Decode(g726_state* state_ptr, unsigned char* bitstream, short* speech, int unpacklen)
{
	int i;
	int in;
	short temp;

	for (i = 0; i < unpacklen; i++)
	{
		in = (int) bitstream[i];
		temp = g726_24_decoder(in, AUDIO_ENCODING_LINEAR, state_ptr);
		memcpy((void*) (speech + i), &temp, 2);
	}
	return 0;
}

DLL_EXPORT int g726_32_Decode(g726_state* state_ptr, unsigned char* bitstream, short* speech, int unpacklen)
{
	int i;
	int in;
	short temp;

	for (i = 0; i < unpacklen; i++)
	{
		in = (int) bitstream[i];
		temp = g726_32_decoder(in, AUDIO_ENCODING_LINEAR, state_ptr);
		memcpy((void*) (speech + i), &temp, 2);
	}
	return 0;
}

DLL_EXPORT int g726_40_Decode(g726_state* state_ptr, unsigned char* bitstream, short* speech, int unpacklen)
{
	int i;
	int in;
	short temp;

	for (i = 0; i < unpacklen; i++)
	{
		in = (int) bitstream[i];
		temp = g726_40_decoder(in, AUDIO_ENCODING_LINEAR, state_ptr);
		memcpy((void*) (speech + i), &temp, 2);
	}
	return 0;
}

DLL_EXPORT void g726_initstate(g726_state** state_ptr)
{
	*state_ptr = (g726_state*) malloc(sizeof(g726_state));
	g726_init_state(*state_ptr);
}

DLL_EXPORT void g726_freestate(g726_state* state_ptr)
{
	if (state_ptr != NULL)
	{
		free(state_ptr);
		state_ptr = NULL;
	}
}
