/*
   ITU-T G.729A Speech Coder with Annex B    ANSI-C Source Code
   Version 1.4    Last modified: November 2000

   Copyright (c) 1996,
   AT&T, France Telecom, NTT, Universite de Sherbrooke, Lucent Technologies,
   Rockwell International
   All rights reserved.
*/

/*-----------------------------------------------------------------*
 * Main program of the G.729A 8.0 kbit/s decoder.                  *
 *                                                                 *
 *    Usage : decoder  bitstream_file  synth_file                  *
 *                                                                 *
 *-----------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "typedef.h"
#include "basic_op.h"
#include "ld8a.h"
#include "dtx.h"
#include "octet.h"

#include "g729.h"

Word16  synth_buf[L_FRAME+M], *synth; /* Synthesis                   */

Word16 bad_lsf;        /* bad LSF indicator   */

/*
   This variable should be always set to zero unless transmission errors
   in LSP indices are detected.
   This variable is useful if the channel coding designer decides to
   perform error checking on these important parameters. If an error is
   detected on the  LSP indices, the corresponding flag is
   set to 1 signalling to the decoder to perform parameter substitution.
   (The flags should be set back to 0 for correct transmission).
*/

extern void apiG729Init()
{
	Word16  i;

	/*-----------------------------------------------------------------*
	*           Initialization of decoder                             *
	*-----------------------------------------------------------------*/

	for (i=0; i<M; i++) synth_buf[i] = 0;
	synth = synth_buf + M;

	bad_lsf = 0;          /* Initialize bad LSF indicator */
	Init_Decod_ld8a();
	Init_Post_Filter();
	Init_Post_Process();

	/* for G.729b */
	Init_Dec_cng();
}

/*-----------------------------------------------------------------*
 *            decoder routine                                      *
 *-----------------------------------------------------------------*/
extern int apiG729decode(const char*payload, short *buf, short len)
{
  Word16  Vad;
  Word16  parm[PRM_SIZE+2];             /* Synthesis parameters        */
  Word16  Az_dec[MP1*2];                /* Decoded Az for post-filter  */
  Word16  T2[2];                        /* Pitch lag for 2 subframes   */

/*-----------------------------------------------------------------*
 *            Loop for each "L_FRAME" speech data                  *
 *-----------------------------------------------------------------*/

  read_frame(payload, parm, (Word16)len);

  Decod_ld8a(parm, synth, Az_dec, T2, &Vad);
  Post_Filter(synth, Az_dec, T2, Vad);        /* Post-filter */
  Post_Process(synth, L_FRAME);

  memcpy((void*)buf,(void*)synth,L_FRAME*sizeof(short));

  return L_FRAME;
}




