#ifndef __MATHHALF
#define __MATHHALF

#include "typedefs.h"

/*_________________________________________________________________________
 |                                                                         |
 |                            Function Prototypes                          |
 |_________________________________________________________________________|
*/

/* addition */
/************/

Shortword GsmHr_add(Shortword var1, Shortword var2);  /* 1 ops */
Shortword GsmHr_sub(Shortword var1, Shortword var2);  /* 1 ops */
Longword GsmHr_L_add(Longword L_var1, Longword L_var2);       /* 2 ops */
Longword GsmHr_L_sub(Longword L_var1, Longword L_var2);       /* 2 ops */

/* multiplication */
/******************/

Shortword GsmHr_mult(Shortword var1, Shortword var2); /* 1 ops */
Longword GsmHr_L_mult(Shortword var1, Shortword var2);        /* 1 ops */
Shortword GsmHr_mult_r(Shortword var1, Shortword var2);       /* 2 ops */


/* arithmetic shifts */
/*********************/

Shortword GsmHr_shr(Shortword var1, Shortword var2);  /* 1 ops */
Shortword GsmHr_shl(Shortword var1, Shortword var2);  /* 1 ops */
Longword GsmHr_L_shr(Longword L_var1, Shortword var2);        /* 2 ops */
Longword GsmHr_L_shl(Longword L_var1, Shortword var2);        /* 2 ops */
Shortword GsmHr_shift_r(Shortword var, Shortword var2);       /* 2 ops */
Longword GsmHr_L_shift_r(Longword L_var, Shortword var2);     /* 3 ops */

/* absolute value  */
/*******************/

Shortword GsmHr_abs_s(Shortword var1);       /* 1 ops */
Longword GsmHr_L_abs(Longword var1);         /* 3 ops */


/* multiply accumulate  */
/************************/

Longword GsmHr_L_mac(Longword L_var3,
                      Shortword var1, Shortword var2);  /* 1 op */
Shortword GsmHr_mac_r(Longword L_var3,
                       Shortword var1, Shortword var2); /* 2 op */
Longword GsmHr_L_msu(Longword L_var3,
                      Shortword var1, Shortword var2);  /* 1 op */
Shortword GsmHr_msu_r(Longword L_var3,
                       Shortword var1, Shortword var2); /* 2 op */

/* negation  */
/*************/

Shortword GsmHr_negate(Shortword var1);      /* 1 ops */
Longword GsmHr_L_negate(Longword L_var1);    /* 2 ops */


/* Accumulator manipulation */
/****************************/

Longword GsmHr_L_deposit_l(Shortword var1);  /* 1 ops */
Longword GsmHr_L_deposit_h(Shortword var1);  /* 1 ops */
Shortword GsmHr_extract_l(Longword L_var1);  /* 1 ops */
Shortword GsmHr_extract_h(Longword L_var1);  /* 1 ops */

/* Round */
/*********/

Shortword GsmHr_gsm_round(Longword L_var1);      /* 1 ops */

/* Normalization */
/*****************/

Shortword GsmHr_norm_l(Longword L_var1);     /* 30 ops */
Shortword GsmHr_norm_s(Shortword var1);      /* 15 ops */

/* Division */
/************/
Shortword GsmHr_divide_s(Shortword var1, Shortword var2);     /* 18 ops */

/* Non-saturating instructions */
/*******************************/
Longword L_add_c(Longword L_Var1, Longword L_Var2);     /* 2 ops */
Longword L_sub_c(Longword L_Var1, Longword L_Var2);     /* 2 ops */
Longword L_sat(Longword L_var1);       /* 4 ops */
Longword L_macNs(Longword L_var3,
                        Shortword var1, Shortword var2);        /* 1 ops */
Longword L_msuNs(Longword L_var3,
                        Shortword var1, Shortword var2);        /* 1 ops */

#endif
