############################################################################
#
# Copyright (c) 2000-2016 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
############################################################################

#
# VQmon Target Platform Configuration Inclusion - Linux/x86_64
#
# Copyright (c) 2000-2016 Telchemy, Incorporated
#

HOST_OS         := linux
HOST_ARCH       := x86_64
HOST_SYSINC     := -I/usr/include

TARGET_OS       := linux
TARGET_ARCH     := x86_64
TARGET_SYSROOT  :=
TARGET_SYSINC   := -I$(TARGET_SYSROOT)/usr/include

CC              := gcc
CFLAGS_OPTS     += -m64 -ansi -Wall
CFLAGS_DEFS     += -DVQMON_HOSTOS_LINUX -D_LINUX -D_GNU_SOURCE

ifdef VQMONBLD_SHAREDLIB
CFLAGS_OPTS     += -fPIC
CFLAGS_DEFS     += -DVQMON_SHAREDLIB
endif

CFLAGS_INCS     += $(TARGET_SYSINC)
CFLAGS_DBG      += -DDEBUG -g
CFLAGS_REL      += -O2
ifeq ($(VQMONBLD_PROFILE),1)
CFLAGS_REL      += -g -fno-omit-frame-pointer
endif

ifdef VQMONBLD_ADDRSANTZ
CFLAGS_OPTS     += -fsanitize=address
CFLAGS_DBG      += -fno-omit-frame-pointer -fstack-protector-all
endif


AR              := ar
ARFLAGS_OPTS    := rcs

LD              := gcc
LDFLAGS_OPTS    += -m64
LDFLAGS_INCS     =
LDDYLIB_EXT     := so
