/* ###########################################################################
#
# Copyright (c) 2000-2015 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmonalt.h
 *
 * VQmon Public Header File - Alerting
 *
 * Copyright (c) 2000-2015 Telchemy, Incorporated
 */

#ifndef _TELCHEMY_VQMONALT_H_
#define _TELCHEMY_VQMONALT_H_

#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Alert Constant Definitions
 *
 * --------------------------------------------------------------------------
 */



/* --------------------------------------------------------------------------
 *
 *      VQmon Public Alert Enumerations
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon alert notification types.
 */
typedef enum
{
    vqmonAlertTypeExcessMidstreamBurstLoss  = 0x00000001,
    vqmonAlertTypeExcessDelay               = 0x00000002,

    vqmonAlertTypeVoiceLowMOS_LQ            = 0x00000010,
    vqmonAlertTypeVoiceLowMOS_CQ            = 0x00000020,

    vqmonAlertTypeAudioLowMOS_A             = 0x00001000,

    vqmonAlertTypeVideoLowMOS_V             = 0x00010000,
    vqmonAlertTypeVideoLowMOS_AV            = 0x00020000,

    vqmonAlertTypeVideoFrozenImage          = 0x00040000,
    vqmonAlertTypeVideoNoContent            = 0x00080000,
    vqmonAlertTypeVideoHighNoise            = 0x00100000,
    vqmonAlertTypeVideoMotionBlur           = 0x00200000

} vqmon_alerttype_t;


/*
 * VQmon alert notification states.
 */
typedef enum
{
    vqmonAlertStateCleared      = 0,
    vqmonAlertStateWarning,
    vqmonAlertStateMinor,
    vqmonAlertStateMajor,
    vqmonAlertStateCritical,
    vqmonAlertStateMax

} vqmon_alertstate_t;

#define VQMON_ALERT_THRESHLIST_SIZE     vqmonAlertStateMax

/* --------------------------------------------------------------------------
 *
 *      VQmon Public Alert Simple Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * Alert types.
 */

/*
 * Alert handler callback function definition.
 */
typedef void (*vqmon_func_alerthdlrcb_t)(
                            const vqmon_handle_t hInterface,
                            const vqmon_handle_t hStream,
                            const vqmon_alerttype_t eAlertType,
                            const vqmon_alertstate_t eAlertState
                            );


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Alert Complex Data Structures
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon alert configuration block.
 */
struct _vqmon_streamcfg_alertthresh_s
{
    vqmon_alerttype_t   eAlertType;

    /*
     * Use vqmon_alertstate_t as the index
     */
    struct
    {
        tcmyS32         nAlertValue;
        tcmyU32         nAlertDurationMs;
        tcmyBOOL        bEnabled;

    } threshList[VQMON_ALERT_THRESHLIST_SIZE];

};
typedef struct _vqmon_streamcfg_alertthresh_s vqmon_streamcfg_alertthresh_t;


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONALT_H_ */
