/* ###########################################################################
#
# Copyright (c) 2000-2015 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmoncdc.h
 *
 * VQmon Public Header File - CODEC Table
 *
 * Copyright (c) 2000-2015 Telchemy, Incorporated
 */

#ifndef _TELCHEMY_VQMONCDC_H_
#define _TELCHEMY_VQMONCDC_H_

#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Codec Table Constant Definitions
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon CODEC property block identifiers.
 */
#define VQMON_CODECPROPBLOCKID_GENERAL              (0x0001)
#define VQMON_CODECPROPBLOCKID_RATEDATA             (0x0002)
#define VQMON_CODECPROPBLOCKID_EXTPROPS             (0x0003)


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Codec Table Enumerations
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon CODEC media format.
 */
typedef enum
{
    vqmonCODECMediaFormatNone       = 0x00000,
    vqmonCODECMediaFormatAudio      = 0x01000,
    vqmonCODECMediaFormatVideo      = 0x02000,
    vqmonCODECMediaFormatVoice      = 0x04000,
    
    vqmonCODECMediaFormatVoiceNB    = 0x14000,
    vqmonCODECMediaFormatVoiceWB    = 0x24000,
    vqmonCODECMediaFormatVoiceSWB   = 0x34000,
    vqmonCODECMediaFormatVoiceFB    = 0x44000,

    vqmonCODECMediaFormatAll        = 0x0F000

} vqmon_codecmediaformat_t;


/*
 * VQmon CODEC table entry validity flags.
 */
typedef enum
{
    vqmonCODECTableEntryInvalid     = 0x00,
    vqmonCODECTableEntryProvisional = 0x01,
    vqmonCODECTableEntryValid       = 0x02

} vqmon_codecvalidity_t;

/*
 * VQmon CODEC Inband data
 */
typedef enum
{
    vqmonCODECInbandNone  = 0x0000,
    vqmonCODECInbandCNG   = 0x0001,
    vqmonCODECInbandDTMF  = 0x0002,
    vqmonCODECInbandOther = 0x0003,
    vqmonCODECInbandMax

} vqmon_codecinbanddata_t;



/* --------------------------------------------------------------------------
 *
 *      VQmon Public Codec Table Simple Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon CODEC type identifier.
 */
typedef tcmyU16 vqmon_codecid_t;

/*
 * VQmon CODEC property block identifier.
 */
typedef tcmyU16 vqmon_codecpropblkid_t;


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Codec Table Complex Data Structures
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon CODEC general properties.
 */
struct _vqmon_codecgenprops_s
{
    vqmon_codecid_t             idType;
    tcmyCHAR                    strName[VQMON_MAXSTRLENGTH];
    vqmon_codecmediaformat_t    eMediaType;
    vqmon_codecvalidity_t       eValidity;
    tcmyU8                      nVariableRateCount;
};

typedef struct _vqmon_codecgenprops_s vqmon_codecgenprops_t;

/*
 * VQmon CODEC Media specific extended properties.
 */
struct _vqmon_codec_audio_extprops_s
{
    tcmyU16                     nBpl1;
    tcmyU16                     nBpl2;
    tcmyU16                     nAdjDelay;
#if 0
    tcmyU16                     nEfficiency;
    tcmyU16                     nFrameDuration;
    tcmyU16                     nFramesPerPacket;
#endif
};
typedef struct _vqmon_codec_audio_extprops_s vqmon_codec_audio_extprops_t;


struct _vqmon_codec_video_extprops_s
{
    tcmyU16                     nFrameWidth;
    tcmyU16                     nFrameHeight;
    tcmyU32                     nFrameRate;
    tcmyBOOL                    bInterlaced;
    tcmyU16                     nFullReplaceThreshold;
    tcmyU16                     nFLCRobustness;
    tcmyU16                     nSlicesPerIFrame;
    tcmyU16                     nMotionSensitivity;
    tcmyU16                     nDetailSensitivity;
#if 0
    tcmyU16                     nEfficiency;
#endif
};
typedef struct _vqmon_codec_video_extprops_s vqmon_codec_video_extprops_t;

struct _vqmon_code_voice_extprops_s
{
    tcmyU8                      nBaseIe;
    tcmyU16                     nBpl1;
    tcmyU16                     nBpl2;
    tcmyU16                     nFrameDuration;
    tcmyU16                     nFrameSize;
    tcmyS16                     nPayloadType;
#if 0
    tcmyU16                     nFramesPerPacket;
#endif
};
typedef struct _vqmon_code_voice_extprops_s vqmon_codec_voice_extprops_t;


/*
 * VQmon CODEC rate-specific properties.
 */
struct _vqmon_codecrateprops_s
{
    tcmyU8                      nBaseIe;
    tcmyU16                     nBpl1;
    tcmyU16                     nBpl2;
    tcmyU16                     nD1;
    tcmyU16                     nD2;
    tcmyU16                     nFrameDuration;
    tcmyU32                     nEncodedBitRate;
    tcmyU8                      nVariableRateCount;
};

typedef struct _vqmon_codecrateprops_s vqmon_codecrateprops_t;


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Codec Table API Functions
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon CODEC table methods.
 */
VQMON_PUBLIC(tcmyU16)
VQmonCODECCount(
    const vqmon_codecmediaformat_t fCODECMediaFormat
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonCODECPropertiesGet(
    const vqmon_codecid_t idCODEC,
    const vqmon_codecpropblkid_t idCODECPropBlock,
    const void* pCODECPropBlockExt,
    tcmyU32* const pnCODECPropSz,
    void* const pCODECProp
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonCODECPropertiesSet(
    const vqmon_codecid_t idCODEC,
    const vqmon_codecpropblkid_t idCODECPropBlock,
    const void* pCODECPropBlockExt,
    const tcmyU32 nCODECPropSz,
    const void* pCODECProp
    );


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONCDC_H_ */
