/* ###########################################################################
#
# Copyright (c) 2000-2016 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmondef.h
 *
 * VQmon Common Type, Constant and Macro Header File
 *
 * Copyright (c) 2000-2016 Telchemy, Incorporated
 */

#ifndef _TELCHEMY_VQMONDEF_H_
#define _TELCHEMY_VQMONDEF_H_

#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 *
 *      Host Platform Headers
 *
 * --------------------------------------------------------------------------
 */

#if defined(DEBUG)
#include <assert.h>
#define VQMON_ASSERT(_c)                     assert(_c)
#else
#define VQMON_ASSERT(_c)
#endif

#if   defined(VQMON_HOSTOS_WIN32) || \
      defined(VQMON_HOSTOS_WIN64)

#include <winsock2.h>
#include <windows.h>
#include <stdlib.h>
#include <stddef.h>
#include <io.h>

#include <stdio.h>
#include <time.h>
#include <limits.h>

#elif defined(VQMON_HOSTOS_VXWORKS)

#include <string.h>
#include <memLib.h>
#include <fioLib.h>
#include <taskLib.h>
#include <netinet/in.h>

#include <stdio.h>
#include <time.h>
#include <limits.h>

#elif defined(VQMON_HOSTOS_PSOS)

#include <psos.h>
#include <stdarg.h>
#include <string.h>
#include <limits.h>
#include <netinet/in.h>

#elif defined(VQMON_HOSTOS_DARWIN)  || \
      defined(VQMON_HOSTOS_POSIX)   || \
      defined(VQMON_HOSTOS_LINUX)   || \
      defined(VQMON_HOSTOS_BSD)     || \
      defined(VQMON_HOSTOS_ANDROID)

#include <stdlib.h>
#include <stddef.h>
#include <stdarg.h>
#include <string.h>
#include <sys/time.h>
#include <netinet/in.h>

#include <stdio.h>
#include <time.h>
#include <limits.h>

#else

#error VQMON_HOSTOS_* is not defined!

#endif

/* --------------------------------------------------------------------------
 *
 *      Host Platform Basic Type Definitions
 *
 * --------------------------------------------------------------------------
 */

#if   defined(VQMON_HOSTOS_WIN32)

typedef UCHAR               tcmyU8;
typedef USHORT              tcmyU16;
typedef UINT                tcmyU32;
typedef ULONGLONG           tcmyU64;

typedef CHAR                tcmyS8;
typedef SHORT               tcmyS16;
typedef INT                 tcmyS32;
typedef LONGLONG            tcmyS64;

typedef BOOL                tcmyBOOL;
typedef CHAR                tcmyCHAR;

#else

typedef unsigned char       tcmyU8;
typedef unsigned short      tcmyU16;
typedef unsigned int        tcmyU32;
typedef unsigned long long  tcmyU64;

typedef signed char         tcmyS8;
typedef signed short        tcmyS16;
typedef signed int          tcmyS32;
typedef signed long long    tcmyS64;

typedef char                tcmyCHAR;

#ifndef BOOL
typedef unsigned int        tcmyBOOL;
#else
typedef BOOL                tcmyBOOL;
#endif

#endif


/* --------------------------------------------------------------------------
 *
 *      Host Platform Function Definitions
 *
 * --------------------------------------------------------------------------
 */

#if   defined(VQMON_HOSTOS_WIN32) ||\
      defined(VQMON_HOSTOS_WIN64)
      
#if defined(DEBUG)
int TelchemyWin32DbgPrint(const char *format, ...);
#define VQMON_DBGPRINT                      TelchemyWin32DbgPrint
#define VQMON_FUNCTION_NAME                 __FUNCTION__
#elif !defined(NDEBUG)
#define NDEBUG
#endif

#define VQMON_MEMCLEAR(_d, _size)           ZeroMemory((PVOID)_d, _size)
#define VQMON_MEMSET(_d, _b, _size)         FillMemory((PVOID)_d, _size, (BYTE)_b)
#define VQMON_MEMCOPY(_d, _s, _size)        CopyMemory((PVOID)_d, (CONST PVOID*)_s, _size)
#define VQMON_SNPRINTF                      _snprintf

#else

#if defined(DEBUG)

#if defined(VQMON_HOSTOS_ANDROID)
void VQmonDebugPrintAndroid(const tcmyCHAR *format, ...);
#define VQMON_DBGPRINT                      VQmonDebugPrintAndroid
#else
#define VQMON_DBGPRINT                      printf
#endif

#define VQMON_FUNCTION_NAME                 __func__
#endif

#define VQMON_MEMCLEAR(_d, _size)           memset(_d, 0, _size)
#define VQMON_MEMSET(_d, _b, _size)         memset(_d, _b, _size)
#define VQMON_MEMCOPY(_d, _s, _size)        memcpy(_d, _s, _size)
#define VQMON_SNPRINTF                      snprintf

#endif

#define VQMON_MEMALLOC(_size)               malloc(_size)
#define VQMON_MEMCMP(_d, _s, _size)         memcmp(_d, _s, _size)
#define VQMON_MEMFREE(_d)                   free(_d)
#define VQMON_MEMREALLOC(_d, _size)         realloc(_d, _size)

#define VQMON_STRLEN(_x)                    strlen(_x)
#define VQMON_STRNLEN(_x, _size)            strnlen(_x, _size)
#define VQMON_STRCPY(_d, _s)                strcpy(_d, _s)
#define VQMON_STRNCPY(_d, _s, _size)        strncpy(_d, _s, _size)
#define VQMON_STRCMP(_s1, _s2)              strcmp(_s1, _s2)
#define VQMON_STRNCMP(_s1, _s2, _size)      strncmp(_s1, _s2, _size)
#define VQMON_STRCAT(_s1, _s2)              strcat(_s1, _s2)
#define VQMON_STRNCAT(_s1, _s2, _size)      strncat(_s1, _s2, _size)

#define VQMON_NTOHL(_x)                     ntohl(_x)
#define VQMON_NTOHS(_x)                     ntohs(_x)
#define VQMON_HTONL(_x)                     htonl(_x)
#define VQMON_HTONS(_x)                     htons(_x)

/* 
 * Defining macros to convert a network pointer to host format
 */
#define VQMON_NPTRTOHS(_ptr)                                                \
    ((((tcmyU16)(_ptr)[0] << 8) & 0xFF00) | ((tcmyU16)(_ptr)[1] & 0x00FF))
#define VQMON_NPTRTOHL(_ptr)                                                \
   ((((tcmyU32)(_ptr)[0] << 24) & 0xFF000000) | (((tcmyU32)(_ptr)[1] << 16) \
   & 0x00FF0000) | (((tcmyU32)(_ptr)[2] << 8)  & 0x0000FF00) |              \
   ((tcmyU32)(_ptr)[3] & 0x000000FF))


/* --------------------------------------------------------------------------
 *
 *      VQmon Constants and Macros
 *
 * --------------------------------------------------------------------------
 */

/*
 * Generic constants and macros used by VQmon.
 */
#ifndef TRUE
#define TRUE                                (1)
#endif
#ifndef FALSE
#define FALSE                               (0)
#endif
#ifndef NULL
#define NULL                                (0)
#endif
#ifndef UNUSED
#define UNUSED(_x)                          ((void)_x)
#endif

/*
 * Error result codes
 */
#define VQMON_ESUCCESS                      (0)
#define VQMON_EFAILURE                      (-1)
#define VQMON_ENOMEM                        (-2)
#define VQMON_EOUTOFRANGE                   (-3)
#define VQMON_EINVALOP                      (-4)
#define VQMON_EBUFSIZE                      (-5)
#define VQMON_EBADHANDLE                    (-6)
#define VQMON_EINVALPARAM                   (-7)
#define VQMON_ESTREAMINPROGRESS             (-8)
#define VQMON_EEXISTS                       (-9)
#define VQMON_ENOBUFS                       (-10)
#define VQMON_EPENDING                      (-11)
#define VQMON_EFIRSTANOMALOUSPKT            (-12)
#define VQMON_ECONSECANOMALOUSPKT           (-13)
#define VQMON_ELCNSKEYINVALID               (-14)
#define VQMON_ELCNSKEYEXPIRED               (-15)
#define VQMON_ELCNSERROR                    (-16)
#define VQMON_ENOTSUPPORTED                 (-17)
#define VQMON_EAGAIN                        (-18)
#define VQMON_ECALLINPROG                   (-19)

#define VQMON_EINVALHANDLE                  VQMON_EBADHANDLE

/*
 * Debug levels
 */
#define VQMON_DBG_NONE                      (0)
#define VQMON_DBG_FATAL                     (1)
#define VQMON_DBG_ERROR                     (2)
#define VQMON_DBG_WARN                      (3)
#define VQMON_DBG_INFO                      (4)
#define VQMON_DBG_VERBOSE                   (5)

#define VQMON_DBG_MAXLEVELS                 (6)

/*
 * Version manipulation macros
 */
#define VQMON_VERSION_BUILDTYPE_RELEASE     (0)
#define VQMON_VERSION_BUILDTYPE_DEBUG       (1)

#define VQMON_VERSION_MAJOR(_v)             (tcmyU8)((_v & 0xFF000000) >> 24)
#define VQMON_VERSION_MINOR(_v)             (tcmyU8)((_v & 0x00FF0000) >> 16)
#define VQMON_VERSION_BUILD(_v)             (tcmyU16)((_v & 0x0000FFF0) >> 4)
#define VQMON_VERSION_BUILDTYPE(_v)         (tcmyU8)(_v & 0x0000000F)
#define VQMON_VERSION_BUILDTYPE_PATCH(_v)   (tcmyU8)((_v & 0x0F) >> 1)

/*
 * Maximum string length allowed for internal VQmon strings.
 */
#define VQMON_MAXSTRLENGTH                  (40)

/*
 * Define the maximum value allowed in the host processor general purpose
 *  registers.
 */
#define VQMON_HOST_MAXVALUE                 (tcmyU32)ULONG_MAX


/* --------------------------------------------------------------------------
 *
 *      VQmon Interface Declaration Macros
 *
 * --------------------------------------------------------------------------
 */

#ifndef STATIC
#if defined(VQMON_BUILDCFG_MEMCHECK)
#define STATIC
#else
#define STATIC                              static
#endif
#endif

#ifndef INLINE
#ifdef __STRICT_ANSI__
#define INLINE                              __inline
#else
#define INLINE
#endif
#endif

#if defined(__GNUC__)
#define VQMON_VISIBILITY_DEFAULT   __attribute__ ((visibility ("default")))
#else
#define VQMON_VISIBILITY_DEFAULT
#endif

#if defined(__GNUC__)
#define VQMON_VISIBILITY_HIDDEN   __attribute__ ((visibility ("hidden")))
#else
#define VQMON_VISIBILITY_HIDDEN
#endif

#if defined(__GNUC__)
#define VQMON_VISIBILITY_INTERNAL __attribute__ ((visibility ("internal")))
#else
#define VQMON_VISIBILITY_INTERNAL
#endif


#define VQMON_PRIVATE(_t)                   STATIC _t
#define VQMON_PRIVATE_PTR(_t)               STATIC _t  *
#define VQMON_PRIVATE_INLINE(_t)            STATIC INLINE _t
#define VQMON_PRIVATE_INLINE_PTR(_t)        STATIC INLINE _t  *
#define VQMON_PROTECTED(_t)                 _t VQMON_VISIBILITY_INTERNAL
#define VQMON_PROTECTED_PTR(_t)             _t VQMON_VISIBILITY_INTERNAL *
#define VQMON_PROTECTED_INLINE(_t)          INLINE _t VQMON_VISIBILITY_INTERNAL
#define VQMON_PROTECTED_INLINE_PTR(_t)      INLINE _t VQMON_VISIBILITY_INTERNAL *

#if defined(VQMON_HOSTOS_WIN32)
#if defined(VQMON_DLLEXPORT)
#define VQMON_PUBLIC(_t)                    extern __declspec(dllexport) _t __stdcall
#else
#define VQMON_PUBLIC(_t)                    extern _t __stdcall
#endif
#else
#if  defined(VQMON_BUILDCFG_HIDESYMBOLS)
#define VQMON_PUBLIC(_t)                    _t VQMON_VISIBILITY_HIDDEN
#else
#define VQMON_PUBLIC(_t)                    _t VQMON_VISIBILITY_DEFAULT
#endif
#endif

#if defined(VQMON_HOSTOS_WIN32)
#if defined(VQMON_DLLEXPORT)
#define VQMON_PUBLIC_PTR(_t)                extern __declspec(dllexport) _t * __stdcall
#else
#define VQMON_PUBLIC_PTR(_t)                extern _t * __stdcall
#endif
#else
#if  defined(VQMON_BUILDCFG_HIDESYMBOLS)
#define VQMON_PUBLIC_PTR(_t)                _t VQMON_VISIBILITY_HIDDEN *
#else
#define VQMON_PUBLIC_PTR(_t)                _t VQMON_VISIBILITY_DEFAULT *
#endif
#endif

#if defined(VQMON_HOSTOS_WIN32) && defined(VQMON_DLLEXPORT)
#define VQMON_GLOBAL_EXPORT(_t)             __declspec(dllexport) _t
#define VQMON_GLOBAL_IMPORT(_t)             __declspec(dllexport) _t
#else
#define VQMON_GLOBAL_EXPORT(_t)             _t
#define VQMON_GLOBAL_IMPORT(_t)             extern _t
#endif

#if defined(__GNUC__)
#define VQMON_GLOBAL_DYNSYMHIDE(_t)         _t VQMON_VISIBILITY_HIDDEN
#else
#define VQMON_GLOBAL_DYNSYMHIDE(_t)         _t
#endif


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONDEF_H_ */

