/* ###########################################################################
#
# Copyright (c) 2000-2015 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmonm2t.h
 *
 * VQmon Public Header File - MP2TS-Specific Inclusions
 *
 * Copyright (c) 2000-2015 Telchemy, Incorporated
 */

#include "vqmon.h"
#include "vqmontyp.h"


#ifndef _TELCHEMY_VQMONM2T_H_
#define _TELCHEMY_VQMONM2T_H_

#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 *
 *      VQmon Public MP2TS Constants
 *
 * --------------------------------------------------------------------------
 */

/*
 * Packet descriptor flags - MP2TS transport information
 */
#ifndef VQMON_MP2TSINFO_VALID
#define VQMON_MP2TSINFO_VALID                       (0x00000001)
#endif
#ifndef VQMON_MP2TSINFO_PCRVALID
#define VQMON_MP2TSINFO_PCRVALID                    (0x00000002)
#endif
#ifndef VQMON_MP2TSINFO_PTSVALID
#define VQMON_MP2TSINFO_PTSVALID                    (0x00000004)
#endif
#ifndef VQMON_MP2TSFLAG_PAYLOADSTART
#define VQMON_MP2TSFLAG_PAYLOADSTART                (0x00000010)
#endif
#ifndef VQMON_MP2TSFLAG_SCRAMBLED
#define VQMON_MP2TSFLAG_SCRAMBLED                   (0x00000020)
#endif
#ifndef VQMON_MP2TSFLAG_SYNCBYTEERROR
#define VQMON_MP2TSFLAG_SYNCBYTEERROR               (0x00000040)
#endif
#ifndef VQMON_MP2TSFLAG_TRANSPORTERROR
#define VQMON_MP2TSFLAG_TRANSPORTERROR              (0x00000080)
#endif
#ifndef VQMON_MP2TSFLAG_DISCONTINUITY
#define VQMON_MP2TSFLAG_DISCONTINUITY               (0x00000100)
#endif
#ifndef VQMON_MP2TSFLAG_RANDOMACCESS
#define VQMON_MP2TSFLAG_RANDOMACCESS                (0x00000200)
#endif


/*
 * Stream Program Information key size.
 */
#ifndef VQMON_STREAMPROGINFO_KEYSIZE
#define VQMON_STREAMPROGINFO_KEYSIZE                (60)
#endif


/*
 * Stream Program Information descriptor block sizes.
 */
#ifndef VQMON_STREAMPROGINFO_PMTESDESCSZ
#define VQMON_STREAMPROGINFO_PMTESDESCSZ            (20)
#endif
#ifndef VQMON_STREAMPROGINFO_PMTPGMDESCSZ
#define VQMON_STREAMPROGINFO_PMTPGMDESCSZ           (20)
#endif
#ifndef VQMON_STREAMPROGINFO_CATCADESCSZ
#define VQMON_STREAMPROGINFO_CATCADESCSZ            (128)
#endif
#ifndef VQMON_STREAMPROGINFO_NITDESCSZ
#define VQMON_STREAMPROGINFO_NITDESCSZ              (128)
#endif


/*
 * Stream transport protocol control flags.
 */
#define VQMON_STREAMTRANSPROTO_MP2TSSCRAMBLED       (0x0001)
#define VQMON_STREAMTRANSPROTO_MP2TSSCRAMBLEDPART   (0x0008)
#define VQMON_STREAMTRANSPROTO_PESSCRAMBLED         (0x0020)
#define VQMON_STREAMTRANSPROTO_PESSCRAMBLEDPART     (0x0080)


/*
 * Stream MP2TS default configuration.
 */
#define VQMON_STREAMCFGBLOCKID_MP2TSTR101290DEF     (0x3120)
#define VQMON_STREAMCFGBLOCKID_MP2TSTR101290NONSTDDEF (0x3121)

/*
 * Stream MP2TS metric block codes.
 */
#define VQMON_STREAMMETRICBLOCKID_MP2TSTR101290P1   (0x3320)
#define VQMON_STREAMMETRICBLOCKID_MP2TSTR101290P2   (0x3321)


/*
 * Stream MP2TS event indicator codes.
 */
#define VQMON_STREAMEVENTID_MP2TSTR101290CLR        (0x3401)
#define VQMON_STREAMEVENTID_MP2TSTR101290P1CLR      (0x3402)
#define VQMON_STREAMEVENTID_MP2TSTR101290P2CLR      (0x3403)


/*
 * VQmon Program Information table entry type definitions.
 */
#define VQMON_STREAMPROGINFOTABLE_MP2TSPATSEC       (0x0001)
#define VQMON_STREAMPROGINFOTABLE_MP2TSCATSEC       (0x0010)
#define VQMON_STREAMPROGINFOTABLE_MP2TSPMTSEC       (0x0100)
#define VQMON_STREAMPROGINFOTABLE_MP2TSNITSEC       (0x1000)
#define VQMON_STREAMPROGINFOTABLE_ALL               (0x1111)


/*
 * VQmon Program Information table entry descriptor definitions.
 */
#define VQMON_STREAMPROGINFOENTRYDESC_MP2TSPAT      (0x0001)
#define VQMON_STREAMPROGINFOENTRYDESC_MP2TSCAT      (0x0010)
#define VQMON_STREAMPROGINFOENTRYDESC_MP2TSPMTPROG  (0x0100)
#define VQMON_STREAMPROGINFOENTRYDESC_MP2TSPMTES    (0x0200)
#define VQMON_STREAMPROGINFOENTRYDESC_MP2TSNIT      (0x1000)
#define VQMON_STREAMPROGINFOENTRYDESC_ALL           (0x1311)


/*
 * VQmon MP2TS error/event indicator definitions.
 */
#define VQMON_MP2TSERROR_TSSYNCLOSS                 (0x0001)
#define VQMON_MP2TSERROR_SYNCBYTE                   (0x0002)
#define VQMON_MP2TSERROR_PATERROR                   (0x0004)
#define VQMON_MP2TSERROR_PATERROR2                  (0x0008)
#define VQMON_MP2TSERROR_CONTCOUNTERROR             (0x0010)
#define VQMON_MP2TSERROR_PMTERROR                   (0x0020)
#define VQMON_MP2TSERROR_PMTERROR2                  (0x0040)
#define VQMON_MP2TSERROR_PIDERROR                   (0x0080)

#define VQMON_MP2TSERROR_TRANSPORTERROR             (0x0100)
#define VQMON_MP2TSERROR_CRCERROR                   (0x0200)
#define VQMON_MP2TSERROR_PCRERROR                   (0x0400)
#define VQMON_MP2TSERROR_PCRREPTERROR               (0x0800)
#define VQMON_MP2TSERROR_PCRDISCONERROR             (0x1000)
#define VQMON_MP2TSERROR_PCRACCURACYERROR           (0x2000)
#define VQMON_MP2TSERROR_PTSERROR                   (0x4000)
#define VQMON_MP2TSERROR_CATERROR                   (0x8000)


/* --------------------------------------------------------------------------
 *
 *      VQmon Public MP2TS Enumerations
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon Program Stream Information table types.
 */
typedef enum
{
    vqmonProgInfoTableMP2TSPATSect  = VQMON_STREAMPROGINFOTABLE_MP2TSPATSEC,
    vqmonProgInfoTableMP2TSCATSect  = VQMON_STREAMPROGINFOTABLE_MP2TSCATSEC,
    vqmonProgInfoTableMP2TSPMTSect  = VQMON_STREAMPROGINFOTABLE_MP2TSPMTSEC,
    vqmonProgInfoTableMP2TSNITSect  = VQMON_STREAMPROGINFOTABLE_MP2TSNITSEC,
    vqmonProgInfoTableAll           = VQMON_STREAMPROGINFOTABLE_ALL

} vqmon_streamproginfotabletype_t;


/*
 * VQmon Program Stream Information table entry descriptor types.
 */
typedef enum
{
    vqmonProgInfoEntryDescMP2TSPAT  = \
        VQMON_STREAMPROGINFOENTRYDESC_MP2TSPAT,
    vqmonProgInfoEntryDescMP2TSCAT  = \
        VQMON_STREAMPROGINFOENTRYDESC_MP2TSCAT,
    vqmonProgInfoEntryDescMP2TSPMTProg = \
        VQMON_STREAMPROGINFOENTRYDESC_MP2TSPMTPROG,
    vqmonProgInfoEntryDescMP2TSPMTES = \
        VQMON_STREAMPROGINFOENTRYDESC_MP2TSPMTES,
    vqmonProgInfoEntryDescAll = \
        VQMON_STREAMPROGINFOENTRYDESC_ALL

} vqmon_streamproginfodesctype_t;


/*
 * VQmon MP2TS TR 101 290 error/event indicator enumeration.
 */
typedef enum
{
    vqmonMP2TSErrorTS_sync_loss         = VQMON_MP2TSERROR_TSSYNCLOSS,
    vqmonMP2TSErrorSync_byte_error      = VQMON_MP2TSERROR_SYNCBYTE,
    vqmonMP2TSErrorPAT_error            = VQMON_MP2TSERROR_PATERROR,
    vqmonMP2TSErrorPAT_error_2          = VQMON_MP2TSERROR_PATERROR2,
    vqmonMP2TSErrorContinuity_count_error = VQMON_MP2TSERROR_CONTCOUNTERROR,
    vqmonMP2TSErrorPMT_error            = VQMON_MP2TSERROR_PMTERROR,
    vqmonMP2TSErrorPMT_error_2          = VQMON_MP2TSERROR_PMTERROR2,
    vqmonMP2TSErrorPID_error            = VQMON_MP2TSERROR_PIDERROR,

    vqmonMP2TSErrorTransport_error      = VQMON_MP2TSERROR_TRANSPORTERROR,
    vqmonMP2TSErrorCRC_error            = VQMON_MP2TSERROR_CRCERROR,
    vqmonMP2TSErrorPCR_error            = VQMON_MP2TSERROR_PCRERROR,
    vqmonMP2TSErrorPCR_repetition_error = VQMON_MP2TSERROR_PCRREPTERROR,
    vqmonMP2TSErrorPCR_discontinuity_indicator__error = 
        VQMON_MP2TSERROR_PCRDISCONERROR,
    vqmonMP2TSErrorPCR_accuracy_error   = VQMON_MP2TSERROR_PCRACCURACYERROR,
    vqmonMP2TSErrorPTS_error            = VQMON_MP2TSERROR_PTSERROR,
    vqmonMP2TSErrorCAT_error            = VQMON_MP2TSERROR_CATERROR

} vqmon_mp2tserrindicator_t;

#define vqmonMP2TSErrorPCR_repitition_error vqmonMP2TSErrorPCR_repetition_error

/* --------------------------------------------------------------------------
 *
 *      VQmon Public Video-Specific Complex Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon elementary stream type mapping configuration for MPEG-2 transport.
 */
struct _vqmon_streamcfg_pestype_mapping_s
{
    tcmyU8                  nType;
    vqmon_codecid_t         eCODEC;
};

typedef struct _vqmon_streamcfg_pestype_mapping_s 
    vqmon_streamcfg_pestype_mapping_t;

struct _vqmon_streamcfg_pestmap_table_s
{
    tcmyU8                  nCount;
    vqmon_streamcfg_pestype_mapping_t aPESTMap[1];
};

typedef struct _vqmon_streamcfg_pestmap_table_s
            vqmon_streamcfg_pestmap_table_t;


/*
 * VQmon MP2TS TR 101 290 interval configuration.
 */
struct _vqmon_streamcfg_mp2tstr101290cfg_s
{
    tcmyU32                     nPIDIntervalMs;

};

typedef struct _vqmon_streamcfg_mp2tstr101290cfg_s \
    vqmon_streamcfg_mp2tstr101290cfg_t;

struct _vqmon_streamcfg_mp2tstr101290cfgnonstd_s
{
    tcmyU32                     nPATRepetitionMs;
    tcmyU32                     nPMTRepetitionMs;

    tcmyU32                     nPCRContinuityMs;
    tcmyU32                     nPCRRepetitionMs;
    tcmyU32                     nPTSRepetitionMs;
};

typedef struct _vqmon_streamcfg_mp2tstr101290cfgnonstd_s \
            vqmon_streamcfg_mp2tstr101290nonstdcfg_t;

/*
 * VQmon MP2TS TR 101 290 - Priority I metrics block.
 */
struct _vqmon_streammetrics_mp2tstr101290P1_s
{
    vqmon_mp2tserrindicator_t   fTSErrorIndicators;
    
    tcmyU32                     nTSSyncLossCount;
    tcmyU32                     nSyncByteErrorCount;
    tcmyU32                     nPATErrorCount;
    tcmyU32                     nPAT2ErrorCount;
    tcmyU32                     nContinuityErrorCount;
    tcmyU32                     nPMTErrorCount;
    tcmyU32                     nPMT2ErrorCount;
    tcmyU32                     nPIDErrorCount;
};

typedef struct _vqmon_streammetrics_mp2tstr101290P1_s \
    vqmon_streammetrics_mp2tstr101290P1_t;


/*
 * VQmon MP2TS TR 101 290 - Priority II metrics block.
 */
struct _vqmon_streammetrics_mp2tstr101290P2_s
{
    vqmon_mp2tserrindicator_t   fTSErrorIndicators;

    tcmyU32                     nTransportErrorCount;
    tcmyU32                     nCRCErrorCount;
    tcmyU32                     nPCRErrorCount;
    tcmyU32                     nPCRRepetitionErrorCount;
    tcmyU32                     nPCRDiscontinuityErrorCount;
    tcmyU32                     nPCRAccuracyErrorCount;
    tcmyU32                     nPTSErrorCount;
    tcmyU32                     nCATErrorCount;
};

typedef struct _vqmon_streammetrics_mp2tstr101290P2_s \
    vqmon_streammetrics_mp2tstr101290P2_t;


/*
 * VQmon Program Stream Information key.
 */
struct _vqmon_streamproginfo_key_s
{
    tcmyU8                      keyValue[VQMON_STREAMPROGINFO_KEYSIZE];
};

typedef struct _vqmon_streamproginfo_key_s vqmon_streamproginfo_key_t;


/* 
 * VQmon Program Stream Information table entry.
 */
struct _vqmon_streamproginfo_tableentry_s
{
    vqmon_streamproginfotabletype_t eTableType;
    vqmon_streamproginfo_key_t  tKey;

    union
    {
        struct 
        {
            tcmyU8              fSectionFlags;
            tcmyU8              idTable;
            tcmyU8              nVersion;
            tcmyU8              nSectionNo;
            tcmyU8              nLastSectionNo;
            tcmyU16             nSectionLength;
            tcmyU16             nTransStreamId;
            tcmyU16             nProgramCount;
            tcmyU32             nCRC32Reported;
            tcmyU32             nCRC32Calculated;

        } PATsection;

        struct
        {
            tcmyU8              fSectionFlags;
            tcmyU8              idTable;
            tcmyU8              nVersion;
            tcmyU8              nSectionNo;
            tcmyU8              nLastSectionNo;
            tcmyU16             nSectionLength;
            tcmyU16             nDescriptorCount;
            tcmyU32             nCRC32Reported;
            tcmyU32             nCRC32Calculated;

        } CATsection;

        struct 
        {
            tcmyU8              fSectionFlags;
            tcmyU8              idTable;
            tcmyU8              nVersion;
            tcmyU8              nSectionNo;
            tcmyU8              nLastSectionNo;
            tcmyU16             nSectionLength;
            tcmyU16             nProgramNo;
            tcmyU16             nPCRPID;
            tcmyU16             nProgInfoLength;
            tcmyU16             nProgDescCount;
            tcmyU16             nESDescCount;
            tcmyU32             nCRC32Reported;
            tcmyU32             nCRC32Calculated;

        } PMTsection;

    } PSItable;
};

typedef struct _vqmon_streamproginfo_tableentry_s \
    vqmon_streamproginfo_tableentry_t;


/* 
 * VQmon Program Stream Information table entry descriptor.
 */
struct _vqmon_streamproginfo_tableentrydesc_s
{
    vqmon_streamproginfodesctype_t eDescType;

    union
    {
        struct
        {
            tcmyU16             nProgramNumber;
            tcmyU16             nPID;
            vqmon_streamproginfo_key_t tKey;

        } PATprogdesc;
        
        struct
        {
            tcmyU8              nTag;
            tcmyU8              nLength;
            tcmyU16             nCASystemId;
            tcmyU16             nCAPID;
            tcmyU16             nDataLength;
            tcmyU16             nDataBytesRecorded;
            tcmyU8              aDataBytes[VQMON_STREAMPROGINFO_CATCADESCSZ];

        } CATdesc;

        struct
        {
            tcmyU8              nTag;
            tcmyU8              nDataLength;
            tcmyU8              nDataBytesRecorded;
            tcmyU8              aDataBytes[VQMON_STREAMPROGINFO_PMTPGMDESCSZ];

        } PMTprogdesc;

        struct
        {
            tcmyU8              nStreamType;
            tcmyU16             nESPID;
            tcmyU16             nESInfoLength;
            tcmyU16             nESInfoCount;
            vqmon_handle_t      hVQmonStream;

        } PMTESdesc;

        struct
        {
            tcmyU8              nDataLength;
            tcmyU8              nDataBytesRecorded;
            tcmyU8              aDataBytes[VQMON_STREAMPROGINFO_NITDESCSZ];

        } NITdesc;

    } desc;
};

typedef struct _vqmon_streamproginfo_tableentrydesc_s \
    vqmon_streamproginfo_tableentrydesc_t;


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONM2T_H_ */
