/* ###########################################################################
#
# Copyright (c) 2000-2017 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/*
 * vqmonmmd.h
 *
 * VQmon Markov Model Data Header File
 *
 * Copyright (c) 2000-2017 Telchemy, Incorporated
 */

#ifndef _TELCHEMY_VQMONMMD_H_
#define _TELCHEMY_VQMONMMD_H_

#include "vqmon.h"

#ifdef __cplusplus
extern "C" {
#endif

/* --------------------------------------------------------------------------
 *
 *      VQmon Markov Model Constants and Macros
 *
 * --------------------------------------------------------------------------
 */

#define VQMON_MMCOUNTERS_V1


/* --------------------------------------------------------------------------
 *
 *      VQmon Markov Model Complex Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon Markov Model v1 counters.
 */
struct _vqmon_mmcntrsv1_s
{
    tcmyU32             c11;
    tcmyU32             c13;
    tcmyU32             c14;
    tcmyU32             c22;
    tcmyU32             c23;
    tcmyU32             c33;
    tcmyU32             c5;
    tcmyU32             c6;
    tcmyU32             nLostPackets;
    tcmyU32             nRcvPktCount;
    tcmyU16             nLost;
    tcmyU16             nFramesPerPkt;
    tcmyU16             eCODECType;
};

typedef struct _vqmon_mmcntrsv1_s vqmon_mmcntrsv1_t;


/* --------------------------------------------------------------------------
 *
 *      VQmon Markov Model Function Prototypes
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon Stream functions to reset/clear memory for reuse.
 */
VQMON_PUBLIC(vqmon_result_t)
VQmonStreamReset(
    vqmon_handle_t const hStream
    );

/*
 * VQmon Stream functions to update Markov Model Counters and Metrics.
 */
VQMON_PUBLIC(vqmon_result_t)
VQmonStreamUpdateMMSession(
    vqmon_handle_t const hStream,
    const vqmon_time_t tCurTimestamp,
    vqmon_mmcntrsv1_t* pMMCounters,
    const tcmyU32 nActiveBitrate
    );


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONMMD_H_ */

