/* ###########################################################################
#
# Copyright (c) 2000-2015 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmonsvd.h
 *
 * VQmon Public Header File - Streaming Video-Specific Inclusions
 *
 * Copyright (c) 2000-2015 Telchemy, Incorporated
 */

#include "vqmon.h"
#include "vqmontyp.h"

#ifndef _TELCHEMY_VQMONSVD_H_
#define _TELCHEMY_VQMONSVD_H_

#ifdef __cplusplus
extern "C" {
#endif

/* --------------------------------------------------------------------------
 *
 *      VQmon Public Streaming Video-Specific Constants
 *
 * --------------------------------------------------------------------------
 */

/*
 * Streaming video configuration and metric block codes.
 */
#define VQMON_STREAMMETRICBLOCKID_STRMVIDEOSAMPLE   (0x2401)


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Streaming Video-Specific Complex Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * Sample/Period metrics for streaming video.
 */
struct _vqmon_streamvideosample_s
{
    tcmyU32                             nSampleNo;
    tcmyU32                             nDurationMs;

    vqmon_mos_t                         nAvgAbsoluteMOS_V;
    vqmon_mos_t                         nMinAbsoluteMOS_V;
    vqmon_mos_t                         nMaxAbsoluteMOS_V;
    vqmon_mos_t                         nInstAbsoluteMOS_V;

    vqmon_mos_t                         nAvgRelativeMOS_V;
    vqmon_mos_t                         nMinRelativeMOS_V;
    vqmon_mos_t                         nMaxRelativeMOS_V;
    vqmon_mos_t                         nInstRelativeMOS_V;

    vqmon_mos_t                         nAvgAbsoluteMOS_AV;
    vqmon_mos_t                         nMinAbsoluteMOS_AV;
    vqmon_mos_t                         nMaxAbsoluteMOS_AV;
    vqmon_mos_t                         nInstAbsoluteMOS_AV;

    vqmon_mos_t                         nAvgRelativeMOS_AV;
    vqmon_mos_t                         nMinRelativeMOS_AV;
    vqmon_mos_t                         nMaxRelativeMOS_AV;
    vqmon_mos_t                         nInstRelativeMOS_AV;

    tcmyU16                             nMediaSegments;
    vqmon_fpq8_t                        nEPSNR;

    vqmon_codecid_t                     idVideoCODEC;
    tcmyU16                             nFrameWidth;
    tcmyU16                             nFrameHeight;
    tcmyU32                             nFrameRate;
    tcmyU16                             nBitRateChanges;

    tcmyU16                             nBufEmptyCount;
    tcmyU32                             nBufEmptyDurMs;
    vqmon_proportion_t                  nBufEmptyProp;
    tcmyU32                             nRebufDurMs;
    vqmon_proportion_t                  nRebufDurProp;

    tcmyU32                             nBufLevelMs;
    tcmyU32                             nLowWatermark;
    tcmyU32                             nHighWatermark;
    tcmyU32                             nBufFillRate;
    tcmyU32                             nBufEmptyRate;

    vqmon_codecid_t                     idAudioCODEC;
    tcmyU32                             nAudioBitRate;
    vqmon_mos_t                         nMinMOS_A;
    vqmon_mos_t                         nAvgMOS_A;
    vqmon_mos_t                         nMaxMOS_A;
    vqmon_mos_t                         nInstMOS_A;

    vqmon_streamtransproto_t            eTransProtoType;
    union _vqmon_svdsample_proto_u
    {
        struct _vqmon_svdsample_tcp_s
        {
            tcmyU32                     nDataPackets;
            tcmyU32                     nRawDataPackets;
            tcmyU32                     nPackets;
            tcmyU32                     nResend;
            tcmyU32                     nDuplicateACK;

            tcmyU16                     idTCPStream;
            tcmyU16                     nWindowSize;
            tcmyU32                     nThroughput;
            tcmyU32                     nEffectiveThroughput;
            tcmyU32                     nMaxThroughput;
            tcmyU32                     nBurstBandwidth;
        } tcp;
    } proto;
};

typedef struct _vqmon_streamvideosample_s vqmon_streamvideosample_t;

struct _vqmon_streammetrics_videosample_s
{
    tcmyU16                             nNumSamples;
    tcmyU16                             nSampleOffset;
    vqmon_streamvideosample_t*          pSamples;
};

typedef struct _vqmon_streammetrics_videosample_s
    vqmon_streammetrics_videosample_t;


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONSVD_H_ */
