/* ###########################################################################
#
# Copyright (c) 2000-2016 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/*
 * vqmontcp.h
 *
 * VQmon Public Header File - TCP Stream
 *
 * Copyright (c) 2000-2016 Telchemy, Incorporated
 */

#ifndef _TELCHEMY_VQMONTCP_H_
#define _TELCHEMY_VQMONTCP_H_

#include "vqmon.h"
#include "vqmontyp.h"

#ifdef __cplusplus
extern "C" {
#endif

/* --------------------------------------------------------------------------
 *
 *      VQmon Public TCP Stream Constant Definitions
 *
 * --------------------------------------------------------------------------
 */

/*
 * Stream default configuration block identifiers for an interface.
 */
#define VQMON_STREAMCFGBLOCKID_PROTOTCPPORTFILTER   (0x0411)

/*
 * Stream configuration block identifiers.
 */
#define VQMON_STREAMCFGBLOCKID_STRMAPPLPROTO        (0x0421)
#define VQMON_STREAMCFGBLOCKID_STRMTRANSCOUNT       (0x0422)
#define VQMON_STREAMCFGBLOCKID_STRMMEDIACOUNT       (0x0423)

/*
 * Stream metric block identifiers.
 */
#define VQMON_STREAMMETRICBLOCKID_TCPPKTS           (0x0441)
#define VQMON_STREAMMETRICBLOCKID_TCPBW             (0x0442)

#define VQMON_STREAMMETRICBLOCKID_STRMMFINFO        (0x0451)
#define VQMON_STREAMMETRICBLOCKID_MEDIADNLD         (0x0452)
#define VQMON_STREAMMETRICBLOCKID_STRMQUAL          (0x0453)

#define VQMON_STREAMMETRICBLOCKID_QUICPKTS          (0x0461)
#define VQMON_STREAMMETRICBLOCKID_QUICBW            (0x0462)


/* --------------------------------------------------------------------------
 *
 *      VQmon Public TCP Stream Simple Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon stream application layer protocol.
 */
#define VQMON_STREAMAPPLPROTO_HTTP                  (0x0100)
#define VQMON_STREAMAPPLPROTO_RTMP                  (0x0200)
#define VQMON_STREAMAPPLPROTO_HTTPS                 (0x1000)
#define VQMON_STREAMAPPLPROTO_QUIC                  (0x2000)

typedef enum
{
    vqmonStreamApplProtoHTTP            = VQMON_STREAMAPPLPROTO_HTTP,
    vqmonStreamApplProtoRTMP            = VQMON_STREAMAPPLPROTO_RTMP,
    vqmonStreamApplProtoHTTPS           = VQMON_STREAMAPPLPROTO_HTTPS,
    vqmonStreamApplProtoQUIC            = VQMON_STREAMAPPLPROTO_QUIC

} vqmon_streamapplproto_t;


/*
 * Stream application layer protocol control flags.
 */
#define VQMON_STREAMAPPLPROTO_HTTPINDEXFILEVALID    (0x0001)
#define VQMON_STREAMAPPLPROTO_HTTPINDEXHOSTVALID    (0x0002)
#define VQMON_STREAMAPPLPROTO_HTTPMEDIAFILEVALID    (0x0004)
#define VQMON_STREAMAPPLPROTO_HTTPMEDIAHOSTVALID    (0x0008)


/* --------------------------------------------------------------------------
 *
 *      VQmon Public TCP Stream Complex Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * Default application (TCP/UDP) ports configuration block for an interface.
 */
struct _vqmon_streamcfg_prototcpportfilter_s
{
    vqmon_streamapplproto_t     eType;
    tcmyU16                     nNumPorts;
    tcmyU16                     aPorts[1];
};

typedef struct _vqmon_streamcfg_prototcpportfilter_s
    vqmon_streamcfg_prototcpportfilter_t;

/*
 * TCP transport layer packet metrics block.
 */
struct _vqmon_streammetrics_tcppkts_s
{
    tcmyU32         nDataPackets;
    tcmyU32         nRawDataPackets;
    tcmyU32         nPackets;
    tcmyU32         nReset;
    tcmyU32         nUrgent;
    tcmyU32         nResend;
    tcmyU32         nDuplicateACK;
    tcmyU16         nWindowSize;
};

typedef struct _vqmon_streammetrics_tcppkts_s vqmon_streammetrics_tcppkts_t;

/*
 * QUIC (Quick UDP Internet Connections) packet metrics block.
 */
struct _vqmon_streammetrics_quicpkts_s
{
    tcmyU32         nRegularPackets;
    tcmyU32         nReset;
    tcmyU32         nVersionNegot;
    tcmyU32         nLost;
};

typedef struct _vqmon_streammetrics_quicpkts_s vqmon_streammetrics_quicpkts_t;

/*
 * TCP transport layer throughput/bandwidth metrics block.
 */
struct _vqmon_streammetrics_tcpbw_s
{
    tcmyU32         nThroughput;
    tcmyU32         nEffectiveThroughput;
    tcmyU32         nMaxThroughput;
    tcmyU32         nBurstBandwidth;
};

typedef struct _vqmon_streammetrics_tcpbw_s vqmon_streammetrics_tcpbw_t;

typedef vqmon_streammetrics_tcpbw_t vqmon_streammetrics_quicbw_t;


/*
 * VQmon stream application layer protocol extended information.
 */
struct _vqmon_streamcfg_applprotoext_s
{
    vqmon_streamapplproto_t     eApplicationProto;
    tcmyCHAR                    strProtoName[8];

    union _vqmappl_proto_u
    {
        struct _vqmappl_proto_http_s
        {
            tcmyU16             fCtrlFlags;
            tcmyU8              strIndexFile[256];
            tcmyU8              strIndexHost[40];
            tcmyU8              strMediaFile[256];
            tcmyU8              strMediaHost[40];

        } http;

        struct _vqmappl_proto_rtmp_s
        {
            tcmyU16             fCtrlFlags;

        } rtmp;

    } proto;
};

typedef struct _vqmon_streamcfg_applprotoext_s \
    vqmon_streamcfg_applprotoext_t;

/*
 * VQmon TCP video streaming information - from manifest file(s).
 */
struct _vqmon_substrm_mfinfo_s
{
    tcmyBOOL        bMediaEncrypted;
    tcmyU32         nBitrate;
    tcmyU16         nFrameWidth;
    tcmyU16         nFrameHeight;
    tcmyU32         nSegmentsDownload;
};

typedef struct _vqmon_substrm_mfinfo_s vqmon_substrm_mfinfo_t;

#define VQMON_TIMEDNLDPCT_BINS                      (5)
#define VQMON_NUMBITRATES_MAX                       (16)
struct _vqmon_streammetrics_strmmfinfo_s
{
    tcmyU16         nNumBitratesAvail;
    tcmyU32         nSegmentsDownload;
    tcmyU32         nSegmentsComplete;
    vqmon_percent_t aTimeDownloadPct[VQMON_TIMEDNLDPCT_BINS];
    vqmon_substrm_mfinfo_t tSubStream[VQMON_NUMBITRATES_MAX];
};

typedef struct _vqmon_streammetrics_strmmfinfo_s \
    vqmon_streammetrics_strmmfiinfo_t;

/*
 * VQmon TCP video streaming media segments download information for HTTPS.
 */
#define VQMON_DNLDTIMEMS_BINS                       (10)
#define VQMON_DNLDTIMEPCT_BINS                      (5)
#define VQMON_DNLDBWPCT_BINS                        (5)
struct _vqmon_streammetrics_mediadnld_s
{
    tcmyU64         nDownloadOctets;
    tcmyU32         nDownloadTimeMs;
    tcmyU32         nElapsedTimeMs;
    tcmyU32         nSegmentsDownload;
    tcmyU32         nSegmentsComplete;
    vqmon_percent_t aDnldTimeMs[VQMON_DNLDTIMEMS_BINS];
    vqmon_percent_t aDnldTimePct[VQMON_DNLDTIMEPCT_BINS];
    vqmon_percent_t aDnldBandwidthPct[VQMON_DNLDBWPCT_BINS];
};

typedef struct _vqmon_streammetrics_mediadnld_s \
    vqmon_streammetrics_mediadnld_t;

/*
 * VQmon (encrypted) video streaming quality metric block.
 */
struct _vqmon_streammetrics_strmqual_s
{
    vqmon_mos_t     nMinMOS_B;
    vqmon_mos_t     nAvgMOS_B;
    vqmon_mos_t     nMaxMOS_B;
    vqmon_mos_t     nInstMOS_B;
};

typedef struct _vqmon_streammetrics_strmqual_s \
    vqmon_streammetrics_strmqual_t;

/*
 * Transport (TCP or QUIC) streams associated with a media streaming session.
 */
struct _vqmon_streamcfg_strmtranscount_s
{
    vqmon_streamtype_t          eStreamType;
    tcmyU16                     nAssocStreams;
    tcmyU16                     nTranStreams;
    vqmon_handle_t              ahTranStreams[1];
};

typedef struct _vqmon_streamcfg_strmtranscount_s \
    vqmon_streamcfg_strmtranscount_t;

/*
 * Media (audio or video) streams associated with a media streaming session.
 */
struct _vqmon_streamcfg_strmmediacount_s
{
    tcmyU16                     nMediaStreams;
    vqmon_handle_t              ahMediaStreams[1];
};

typedef struct _vqmon_streamcfg_strmmediacount_s \
    vqmon_streamcfg_strmmediacount_t;


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONTCP_H_ */
