/* ###########################################################################
#
# Copyright (c) 2000-2015 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmonvid.h
 *
 * VQmon Public Header File - Video-Specific Inclusions
 *
 * Copyright (c) 2000-2015 Telchemy, Incorporated
 */

#include "vqmon.h"
#include "vqmontyp.h"

#ifndef VQMON_BUILDCFG_NOMP2TS
#include "vqmonm2t.h"
#endif

#ifndef _TELCHEMY_VQMONVID_H_
#define _TELCHEMY_VQMONVID_H_

#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Video-Specific Constants
 *
 * --------------------------------------------------------------------------
 */

/*
 * Packet descriptor flags - video frame type information
 */
#define VQMON_VIDEO_FRAMESTART                      (0x00001000)
#define VQMON_VIDEO_FRAMEEND                        (0x00002000)

#define VQMON_VIDEO_FRAMETYPE_UNKNOWN               (0x00000000)
#define VQMON_VIDEO_FRAMEDESCVALID                  (0x00000001)
#define VQMON_VIDEO_FRAMESCRAMBLED                  (0x00000020)
#define VQMON_VIDEO_TRANSPORTSCRAMBLED              (0x00000040)
#define VQMON_VIDEO_FRAMETYPE_I                     (0x00010000)
#define VQMON_VIDEO_FRAMETYPE_P                     (0x00020000)
#define VQMON_VIDEO_FRAMETYPE_B                     (0x00040000)
#define VQMON_VIDEO_FRAMETYPE_PB                    (0x00060000)
#define VQMON_VIDEO_FRAMETYPE_IPB                   (0x00070000) /* Intra-PB */
#define VQMON_VIDEO_FRAMETYPE_SI                    (0x00090000)
#define VQMON_VIDEO_FRAMETYPE_SP                    (0x000A0000)
#define VQMON_VIDEO_FRAMETYPE_ALL                   (0x000F0000)


/*
 * Mask for video.
 */
#define VQMON_MEDIATYPEMASK_VIDEO                   (0x2000)


/*
 * Interface-specific video operation codes.
 */
#define VQMON_IFMETRICBLOCKID_VIDEOSTATS            (0x2321)

/*
 * Stream video default configuration.
 */
#define VQMON_STREAMCFGBLOCKID_VIDEOGENCFGDEF       (0x2101)
#define VQMON_STREAMCFGBLOCKID_VIDEOFLCDEF          (0x2102)
#define VQMON_STREAMCFGBLOCKID_VIDEOFRAMERESDEF     (0x2103)
#define VQMON_STREAMCFGBLOCKID_VIDEOFRAMERATEDEF    (0x2104)
#define VQMON_STREAMCFGBLOCKID_VIDEOTHRESHDEF       (0x2105)
#define VQMON_STREAMCFGBLOCKID_VIDEOPLAYOUTBUFDEF   (0x2106)

/*
 * Stream video configuration and metric block codes.
 */
#define VQMON_STREAMCFGBLOCKID_VIDEOGENCFG          (0x2201)
#define VQMON_STREAMCFGBLOCKID_VIDEOFLC             (0x2202)
#define VQMON_STREAMCFGBLOCKID_VIDEOFRAMERES        (0x2203)
#define VQMON_STREAMCFGBLOCKID_VIDEOFRAMERATE       (0x2204)
#define VQMON_STREAMCFGBLOCKID_VIDEOTHRESH          (0x2205)
#define VQMON_STREAMCFGBLOCKID_VIDEOCODECPROP       (0x2206)

#define VQMON_STREAMMETRICBLOCKID_VIDEODESC         (0x2301)
#define VQMON_STREAMMETRICBLOCKID_VIDEOQUAL         (0x2302)
#define VQMON_STREAMMETRICBLOCKID_VIDEOSCENE        (0x2303)
#define VQMON_STREAMMETRICBLOCKID_VIDEOFRAME        (0x2304)
#define VQMON_STREAMMETRICBLOCKID_VIDEOBW           (0x2305)
#define VQMON_STREAMMETRICBLOCKID_VIDEOJITTER       (0x2306)
#define VQMON_STREAMMETRICBLOCKID_VIDEOESDELAY      (0x2307)

#define VQMON_STREAMMETRICBLOCKID_VIDEOINTERVAL     (0x2310)
#define VQMON_STREAMMETRICBLOCKID_VIDEOINTERVALEX   (0x2311)

#define VQMON_STREAMMETRICBLOCKID_VIDEOLAYERS       (0x2320)

/*
 * VQmon video stream interval metrics validity flags.
 */
#define VQMON_STREAMMETRICVALID_VIDEOINTVL_PPDV         (0x0001)
#define VQMON_STREAMMETRICVALID_VIDEOINTVL_PCRJITTER    (0x0002)


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Video-Specific Enumerations
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon video CODEC identifiers.
 */
typedef enum
{
    vqmonCODECVideoUnknown          = 0,
    vqmonCODECVideoJPEG             = 0x2001,
    vqmonCODECVideoMPEG1            = 0x2002,
    vqmonCODECVideoMPEG2            = 0x2003,
    vqmonCODECVideoH261             = 0x2004,
    vqmonCODECVideoH263             = 0x2005,
    vqmonCODECVideoH263Plus         = 0x2006,
    vqmonCODECVideoH264             = 0x2007,
    vqmonCODECVideoMPEG4            = 0x2008,
    vqmonCODECVideoVC1              = 0x2009,
    vqmonCODECVideoVP6              = 0x200a,
    vqmonCODECVideoH264SVC          = 0x200b,
    vqmonCODECVideoVP8              = 0x200c,
    vqmonCODECVideoVP9              = 0x200d,
    vqmonCODECVideoH265             = 0x200e,
    vqmonCODECVideoMax,

    vqmonCODECVideoSDPPktLoopback   = 0x2FF2,

    vqmonCODECVideoUser1            = 0x2FFC,
    vqmonCODECVideoUser2            = 0x2FFD,
    vqmonCODECVideoUser3            = 0x2FFE,
    vqmonCODECVideoUser4            = 0x2FFF

} vqmon_codecvideo_t;


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Video-Specific Complex Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon video stream interface statistics.
 */
struct _vqmon_interfacestats_videostrm_s
{
    tcmyU32                     nStreamsActive;
    tcmyU32                     nStreamsTerminated;

    tcmyU64                     nPktsRcvd;
    tcmyU64                     nPktsLost;
    tcmyU64                     nPktsDiscarded;

    vqmon_mos_t                 nMinRelativeMOS_V;
    vqmon_mos_t                 nAvgRelativeMOS_V;
    vqmon_mos_t                 nMaxRelativeMOS_V;

    vqmon_mos_t                 nMinAbsoluteMOS_V;
    vqmon_mos_t                 nAvgAbsoluteMOS_V;
    vqmon_mos_t                 nMaxAbsoluteMOS_V;

    vqmon_mos_t                 nMinRelativeMOS_AV;
    vqmon_mos_t                 nAvgRelativeMOS_AV;
    vqmon_mos_t                 nMaxRelativeMOS_AV;

    vqmon_mos_t                 nMinAbsoluteMOS_AV;
    vqmon_mos_t                 nAvgAbsoluteMOS_AV;
    vqmon_mos_t                 nMaxAbsoluteMOS_AV;
};

typedef struct _vqmon_interfacestats_videostrm_s \
    vqmon_interfacestats_videostrm_t;


/*
 * VQmon stream video general configuration.
 */
struct _vqmon_streamcfg_videogencfg_s
{
    tcmyU32                     nStreamDescFlags;

    tcmyU32                     nRefClockRateHz;
};

typedef struct _vqmon_streamcfg_videogencfg_s \
    vqmon_streamcfg_videogencfg_t;


/*
 * VQmon stream video frame loss concealment configuration.
 */
struct _vqmon_streamcfg_videoflc_s
{
    tcmyU16                     nFullReplaceThreshold;
    tcmyU16                     nFLCRobustness;
    tcmyU16                     nSlicesPerIFrame;
    tcmyU16                     nMotionSensitivity;
    tcmyU16                     nDetailSensitivity;
    tcmyU16                     nPFrameIntraMBPct;
};

typedef struct _vqmon_streamcfg_videoflc_s vqmon_streamcfg_videoflc_t;


/*
 * VQmon stream video frame resolution configuration.
 */
struct _vqmon_streamcfg_videoframeres_s
{
    tcmyU16                    nFrameWidth;
    tcmyU16                    nFrameHeight;
};

typedef struct _vqmon_streamcfg_videoframeres_s \
    vqmon_streamcfg_videoframeres_t;


/*
 * VQmon stream video frame rate configuration.
 */
struct _vqmon_streamcfg_videoframerate_s
{
    tcmyU32                    nFrameRate;
    tcmyBOOL                   bInterlaced;
};

typedef struct _vqmon_streamcfg_videoframerate_s \
    vqmon_streamcfg_videoframerate_t;


/*
 * VQmon stream video perceptual quality thresholds.
 */
struct _vqmon_streamcfg_videothold_s
{
    vqmon_mos_t                 nThresholdAbsoluteMOS_V;
    vqmon_mos_t                 nThresholdRelativeMOS_V;
    vqmon_mos_t                 nThresholdAbsoluteMOS_AV;
    vqmon_mos_t                 nThresholdRelativeMOS_AV;
};

typedef struct _vqmon_streamcfg_videothold_s vqmon_streamcfg_videothold_t;


/*
 * VQmon stream video CODEC properties configuration.
 */
struct _vqmon_streamcfg_videocodec_s
{
    tcmyU16                     nCodingEffAdjust;
};

typedef struct _vqmon_streamcfg_videocodec_s vqmon_streamcfg_videocodec_t;


/*
 * VQmon stream video description information block.
 */
struct _vqmon_streammetrics_videodesc_s
{
    vqmon_streamcfg_netepdesc_t tEndpointDesc;
    tcmyU32                     fStreamDescFlags;

    vqmon_codecid_t             idCODECType;

    tcmyCHAR                    strGOPStructure[VQMON_MAXSTRLENGTH];
    tcmyU16                     nAvgGOPLength;
    tcmyU16                     nMaxGOPLength;
    tcmyU16                     nCurGOPLength;
    tcmyU16                     nAvgInterIFrameGap;

    tcmyU16                     nFrameWidth;
    tcmyU16                     nFrameHeight;
    tcmyU32                     nFrameRate;
    tcmyBOOL                    bInterlaced;
    tcmyU16                     nSlicesPerIFrame;

    tcmyU32                     nRefClockRateHz;
};

typedef struct _vqmon_streammetrics_videodesc_s \
    vqmon_streammetrics_videodesc_t;


/*
 * VQmon stream video perceptual quality metric block.
 */
struct _vqmon_streammetrics_videoqual_s
{
    vqmon_mos_t                 nMinAbsoluteMOS_V;
    vqmon_mos_t                 nAvgAbsoluteMOS_V;
    vqmon_mos_t                 nMaxAbsoluteMOS_V;
    vqmon_mos_t                 nInstAbsoluteMOS_V;
    vqmon_proportion_t          nPropBelowTholdAbsMOS_V;

    vqmon_mos_t                 nMinRelativeMOS_V;
    vqmon_mos_t                 nAvgRelativeMOS_V;
    vqmon_mos_t                 nMaxRelativeMOS_V;
    vqmon_mos_t                 nInstRelativeMOS_V;
    vqmon_proportion_t          nPropBelowTholdRelMOS_V;

    vqmon_mos_t                 nMinAbsoluteMOS_AV;
    vqmon_mos_t                 nAvgAbsoluteMOS_AV;
    vqmon_mos_t                 nMaxAbsoluteMOS_AV;
    vqmon_mos_t                 nInstAbsoluteMOS_AV;
    vqmon_proportion_t          nPropBelowTholdAbsMOS_AV;

    vqmon_mos_t                 nMinRelativeMOS_AV;
    vqmon_mos_t                 nAvgRelativeMOS_AV;
    vqmon_mos_t                 nMaxRelativeMOS_AV;
    vqmon_mos_t                 nInstRelativeMOS_AV;
    vqmon_proportion_t          nPropBelowTholdRelMOS_AV;

    vqmon_fpq8_t                nVSTQ;
    vqmon_fpq8_t                nEPSNR;
    vqmon_fpq8_t                nEPSNR_ATIS;
    
    struct 
    {
        vqmon_degsevlvl_t       nLossDeg;
        vqmon_degsevlvl_t       nDiscardDeg;
        vqmon_degsevlvl_t       nCODECQuantDeg;
        vqmon_degsevlvl_t       nCODECBWRestrictDeg;
        vqmon_degsevlvl_t       nFrameResolutionDeg;
        vqmon_degsevlvl_t       nFrameRateDeg;
        vqmon_degsevlvl_t       nGOPLengthDeg;
        vqmon_degsevlvl_t       nAvailNetBWDeg;
        vqmon_degsevlvl_t       nDelayDeg;
        vqmon_degsevlvl_t       nAVSyncDeg;
        vqmon_degsevlvl_t       nRecencyDeg;
    
    } deg_factors;
};

typedef struct _vqmon_streammetrics_videoqual_s vqmon_streammetrics_videoqual_t;


/*
 * Video stream scene analysis metrics block.
 */
struct _vqmon_streammetrics_videoscene_s
{
    tcmyU32                     fReserved;

    tcmyU8                      nInstDetailLvl;
    tcmyU8                      nInstMotionLvl;
    tcmyU8                      nInstPanningLvl;

    vqmon_proportion_t          nStaticImage;
    vqmon_proportion_t          nHighDetail;
    vqmon_proportion_t          nLowDetail;
    vqmon_proportion_t          nHighPanning;
    vqmon_proportion_t          nLowPanning;
    vqmon_proportion_t          nHighMotion;
    vqmon_proportion_t          nLowMotion;
    vqmon_proportion_t          nFrozenImage;
    vqmon_proportion_t          nNoContent;
};

typedef struct _vqmon_streammetrics_videoscene_s \
    vqmon_streammetrics_videoscene_t;


/*
 * VQmon stream video frame metrics block.
 */
struct _vqmon_streammetrics_videoframe_s
{
    tcmyU32                     nIFramesRcvd;
    tcmyU32                     nIFramesImpaired;
    vqmon_proportion_t          nPropIFramesImpaired;
    
    tcmyU32                     nPFramesRcvd;
    tcmyU32                     nPFramesImpaired;
    vqmon_proportion_t          nPropPFramesImpaired;
    
    tcmyU32                     nBFramesRcvd;
    tcmyU32                     nBFramesImpaired;
    vqmon_proportion_t          nPropBFramesImpaired;
    
    tcmyU32                     nSIFramesRcvd;
    tcmyU32                     nSIFramesImpaired;
    vqmon_proportion_t          nPropSIFramesImpaired;
    
    tcmyU32                     nSPFramesRcvd;
    tcmyU32                     nSPFramesImpaired;
    vqmon_proportion_t          nPropSPFramesImpaired;

    tcmyU32                     nIFramePktsRcvd;
    tcmyU32                     nIFramePktsLost;
    tcmyU32                     nIFramePktsDiscarded;
    vqmon_proportion_t          nIFramePropImpaired;
    
    tcmyU32                     nPFramePktsRcvd;
    tcmyU32                     nPFramePktsLost;
    tcmyU32                     nPFramePktsDiscarded;
    vqmon_proportion_t          nPFramePropImpaired;
    vqmon_proportion_t          nPFramePropErrExtImpaired;
    
    tcmyU32                     nBFramePktsRcvd;
    tcmyU32                     nBFramePktsLost;
    tcmyU32                     nBFramePktsDiscarded;
    vqmon_proportion_t          nBFramePropImpaired;
    vqmon_proportion_t          nBFramePropErrExtImpaired;
    
    tcmyU32                     nSIFramePktsRcvd;
    tcmyU32                     nSIFramePktsLost;
    tcmyU32                     nSIFramePktsDiscarded;
    vqmon_proportion_t          nSIFramePropImpaired;
    
    tcmyU32                     nSPFramePktsRcvd;
    tcmyU32                     nSPFramePktsLost;
    tcmyU32                     nSPFramePktsDiscarded;
    vqmon_proportion_t          nSPFramePropImpaired;
    vqmon_proportion_t          nSPFramePropErrExtImpaired;
};

typedef struct _vqmon_streammetrics_videoframe_s \
    vqmon_streammetrics_videoframe_t;


/*
 * VQmon stream video bandwidth metrics block.
 */
struct _vqmon_streammetrics_videobw_s
{
    tcmyU32                     nIFrameAvgVideoBandwidth;
    tcmyU32                     nIFrameMaxVideoBandwidth;
    tcmyU32                     nIFrameAvgRcvBandwidth;
    tcmyU32                     nIFrameMaxRcvBandwidth;

    tcmyU32                     nPFrameAvgVideoBandwidth;
    tcmyU32                     nPFrameMaxVideoBandwidth;
    tcmyU32                     nPFrameAvgRcvBandwidth;
    tcmyU32                     nPFrameMaxRcvBandwidth;

    tcmyU32                     nBFrameAvgVideoBandwidth;
    tcmyU32                     nBFrameMaxVideoBandwidth;
    tcmyU32                     nBFrameAvgRcvBandwidth;
    tcmyU32                     nBFrameMaxRcvBandwidth;

    tcmyU32                     nSIFrameAvgVideoBandwidth;
    tcmyU32                     nSIFrameMaxVideoBandwidth;
    tcmyU32                     nSIFrameAvgRcvBandwidth;
    tcmyU32                     nSIFrameMaxRcvBandwidth;

    tcmyU32                     nSPFrameAvgVideoBandwidth;
    tcmyU32                     nSPFrameMaxVideoBandwidth;
    tcmyU32                     nSPFrameAvgRcvBandwidth;
    tcmyU32                     nSPFrameMaxRcvBandwidth;

    tcmyU32                     nAvgVideoBandwidth;
    tcmyU32                     nPeakVideoBandwidth;
    tcmyU32                     nAvgRcvBandwidth;
    tcmyU32                     nPeakRcvBandwidth;
};

typedef struct _vqmon_streammetrics_videobw_s \
    vqmon_streammetrics_videobw_t;


/*
 * VQmon stream video jitter/delay metrics.
 */
struct _vqmon_streammetrics_videojitter_s
{
    vqmon_ufpq4_t               nFrameInterArrivalJitterMs;
    vqmon_ufpq4_t               nIFrameInterArrivalJitterMs;

    vqmon_ufpq8_t               nAvgFrameArrivalDlyMs;
    vqmon_ufpq8_t               nPeakFrameArrivalDlyMs;
};

typedef struct _vqmon_streammetrics_videojitter_s \
    vqmon_streammetrics_videojitter_t;


/*
 * VQmon stream video interval metrics block.
 */
struct _vqmon_streammetrics_videointerval_s
{
    vqmon_time_t                tStartTime;
    vqmon_time_t                tEndTime;

    tcmyU32                     nPktsRcvd;
    tcmyU32                     nPktsLost;
    tcmyU32                     nPktsDiscarded;
    tcmyU32                     nPktsOutOfSequence;
    tcmyU32                     nPktsDuplicated;
    tcmyU32                     nPktsCorrected;
    vqmon_proportion_t          nAvgEffPktLossRate;

    tcmyU16                     nBurstCount;
    vqmon_proportion_t          nBurstLossRate;
    tcmyU32                     nBurstLengthPkts;
    tcmyU16                     nGapCount;
    vqmon_proportion_t          nGapLossRate;
    tcmyU32                     nGapLengthPkts;

    vqmon_ufpq4_t               nPPDVMs;
    vqmon_ufpq4_t               nPCRJitterMs;
    tcmyU32                     fIntervalMetrics;

    tcmyU32                     nIFramesRcvd;
    tcmyU32                     nIFramesImpaired;
    tcmyU32                     nIFrameAvgVideoBandwidth;
    tcmyU32                     nIFrameAvgRcvBandwidth;
    vqmon_proportion_t          nIFramePropImpaired;

    tcmyU32                     nPFramesRcvd;
    tcmyU32                     nPFramesImpaired;
    tcmyU32                     nPFrameAvgVideoBandwidth;
    tcmyU32                     nPFrameAvgRcvBandwidth;
    vqmon_proportion_t          nPFramePropImpaired;
    vqmon_proportion_t          nPFramePropErrExtImpaired;

    tcmyU32                     nBFramesRcvd;
    tcmyU32                     nBFramesImpaired;
    tcmyU32                     nBFrameAvgVideoBandwidth;
    tcmyU32                     nBFrameAvgRcvBandwidth;
    vqmon_proportion_t          nBFramePropImpaired;
    vqmon_proportion_t          nBFramePropErrExtImpaired;

    tcmyU32                     nSIFramesRcvd;
    tcmyU32                     nSIFramesImpaired;
    tcmyU32                     nSIFrameAvgVideoBandwidth;
    tcmyU32                     nSIFrameAvgRcvBandwidth;
    vqmon_proportion_t          nSIFramePropImpaired;

    tcmyU32                     nSPFramesRcvd;
    tcmyU32                     nSPFramesImpaired;
    tcmyU32                     nSPFrameAvgVideoBandwidth;
    tcmyU32                     nSPFrameAvgRcvBandwidth;
    vqmon_proportion_t          nSPFramePropImpaired;
    vqmon_proportion_t          nSPFramePropErrExtImpaired;

    vqmon_mos_t                 nAbsoluteMOS_V;
    vqmon_mos_t                 nMinAbsoluteMOS_V;
    vqmon_mos_t                 nMaxAbsoluteMOS_V;
    vqmon_mos_t                 nInstAbsoluteMOS_V;
    
    vqmon_mos_t                 nRelativeMOS_V;
    vqmon_mos_t                 nMinRelativeMOS_V;
    vqmon_mos_t                 nMaxRelativeMOS_V;
    vqmon_mos_t                 nInstRelativeMOS_V;

    vqmon_mos_t                 nAbsoluteMOS_AV;
    vqmon_mos_t                 nMinAbsoluteMOS_AV;
    vqmon_mos_t                 nMaxAbsoluteMOS_AV;
    vqmon_mos_t                 nInstAbsoluteMOS_AV;

    vqmon_mos_t                 nRelativeMOS_AV;
    vqmon_mos_t                 nMinRelativeMOS_AV;
    vqmon_mos_t                 nMaxRelativeMOS_AV;
    vqmon_mos_t                 nInstRelativeMOS_AV;

    vqmon_fpq8_t                nVSTQ;
    vqmon_fpq8_t                nEPSNR;

    tcmyU32                     nAvgVideoBandwidth;
    tcmyU32                     nAvgRcvBandwidth;

    vqmon_streammetrics_videoscene_t tSceneAnalysis;
};

typedef struct _vqmon_streammetrics_videointerval_s \
    vqmon_streammetrics_videointerval_t;


/*
 * VQmon stream video extended interval metrics block.
 */
struct _vqmon_streammetrics_videointervalext_s
{
    tcmyU32                     nIntvlExtSampleCount;

    tcmyU32                     nIntvlDelayMetric;
    tcmyU32                     nIntvlDelayMetricMin;
    tcmyU32                     nIntvlDelayMetricAvg;
    tcmyU32                     nIntvlDelayMetricMax;

    tcmyU32                     nIntvlAdjLossCount;
    tcmyU32                     nIntvlAdjLossCountMin;
    tcmyU32                     nIntvlAdjLossCountAvg;
    tcmyU32                     nIntvlAdjLossCountMax;
};

typedef struct _vqmon_streammetrics_videointervalext_s \
    vqmon_streammetrics_videointervalext_t;

/*
 * VQmon video stream metrics for a given layer.
 */
struct _vqmon_streammetrics_videolayerinfo_s
{
    tcmyU8                      idDependency;
    tcmyU8                      idQuality;

    tcmyU32                     nPktsRcvd;
    tcmyU32                     nPktsCorrected;
    tcmyU32                     nPktsLost;
    tcmyU32                     nPktsDiscarded;
    tcmyU32                     nPktsOutOfSeq;
    tcmyU32                     nPktsDuplicated;

    vqmon_proportion_t          nNetworkLossProp;
    vqmon_proportion_t          nCorrectedLossProp;
    vqmon_proportion_t          nDiscardProp;
    vqmon_proportion_t          nOutOfSeqProp;
    vqmon_proportion_t          nDuplicateProp;

    tcmyU32                     nAvgVideoBandwidth;
};

typedef struct _vqmon_streammetrics_videolayerinfo_s \
    vqmon_streammetrics_videolayerinfo_t;

/*
 * VQmon supported maximum video layers (e.g. H.264 SVC).
 */
#define VQMON_VIDEO_LAYERS_MAX                      (4)

/*
 * VQmon video stream metrics block for layers (e.g. H.264 SVC).
 */
struct _vqmon_streammetrics_videolayers_s
{
    tcmyU8                                  nLayers;
    vqmon_streammetrics_videolayerinfo_t    aLayers[VQMON_VIDEO_LAYERS_MAX];
};

typedef struct _vqmon_streammetrics_videolayers_s \
    vqmon_streammetrics_videolayers_t;


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Video Stream Functions
 *
 * --------------------------------------------------------------------------
 */

#if (defined(VQMON_BUILDCFG_HAVEAUDIO) || defined(VQMON_BUILDCFG_HAVEVOICE))
VQMON_PUBLIC(vqmon_handle_t)
VQmonFindSiblingRTPStream(
    vqmon_handle_t hInterface,
    vqmon_handle_t hStream,
    vqmon_time_t tStartTime
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonSetSiblingRTPRelation(
    vqmon_handle_t hStream,
    vqmon_handle_t hSiblingStream
    );
#endif


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONVID_H_ */
