/* ###########################################################################
#
# Copyright (c) 2011-2012 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* tcpstrm.h
 *
 * VQmon Sample Host Application - TCP Streaming
 *
 * Copyright (c) 2011-2012 Telchemy, Incorporated
 */

#ifndef _TCPSTRM_H_
#define _TCPSTRM_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "vqmon.h"
#include "vqmontyp.h"
#include "vqmonstm.h"


/* --------------------------------------------------------------------------
 *
 *      Functions
 *
 * --------------------------------------------------------------------------
 */
vqmon_result_t
TCPStrm_NotifyHandler(
    const vqmon_handle_t hInterface,
    const vqmon_handle_t hStream,
    const vqmon_streammgmtnotifytype_t eNotification,
    struct _vqmon_streammgmtnotify_info_s* pNotifyInfo
    );

void
TCPStrm_VideoSummaryDisplay(
    vqmon_handle_t const hStream
    );

void
TCPStrm_AudioSummaryDisplay(
    vqmon_handle_t const hStream
    );

#ifdef __cplusplus
}
#endif

#endif /* _TCPSTRM_H_ */
